---
layout: "api"
page_title: "/sys/internal/ui/mounts - HTTP API"
sidebar_title: "<code>/sys/internal/ui/mounts</code>"
sidebar_current: "api-http-system-internal-ui-mounts"
description: |-
  The `/sys/internal/ui/mounts` endpoint is used to manage mount listing visibility.
---

# `/sys/internal/ui/mounts`

The `/sys/internal/ui/mounts` endpoint is used to manage mount listing
visibility. The response generated by this endpoint is based on the
`listing_visibility` value on the mount, which can be set during mount time or
via mount tuning. This is currently only being used internally for the UI and is
an unauthenticated endpoint.

Due to the nature of its intended usage, there is no guarantee on backwards
compatibility for this endpoint.

## Get Available Visible Mounts

This endpoint lists all enabled auth methods.

| Method |           Path            |
| :------------------------ | :--------------------- |
| `GET`  | `/sys/internal/ui/mounts` |


### Sample Request

```
$ curl \
    http://127.0.0.1:8200/v1/sys/internal/ui/mounts
```

### Sample Response

```json
{
  "auth": {
    "github/": {
      "description": "GitHub auth",
      "type": "github"
    }
  },
  "secret": {
    "custom-secrets/": {
      "description": "Custom secrets",
      "type": "kv"
    }
  }
}
```