package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAlias invokes the kms.UpdateAlias API synchronously
// api document: https://help.aliyun.com/api/kms/updatealias.html
func (client *Client) UpdateAlias(request *UpdateAliasRequest) (response *UpdateAliasResponse, err error) {
	response = CreateUpdateAliasResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAliasWithChan invokes the kms.UpdateAlias API asynchronously
// api document: https://help.aliyun.com/api/kms/updatealias.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAliasWithChan(request *UpdateAliasRequest) (<-chan *UpdateAliasResponse, <-chan error) {
	responseChan := make(chan *UpdateAliasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAlias(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAliasWithCallback invokes the kms.UpdateAlias API asynchronously
// api document: https://help.aliyun.com/api/kms/updatealias.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAliasWithCallback(request *UpdateAliasRequest, callback func(response *UpdateAliasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAliasResponse
		var err error
		defer close(result)
		response, err = client.UpdateAlias(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAliasRequest is the request struct for api UpdateAlias
type UpdateAliasRequest struct {
	*requests.RpcRequest
	AliasName string `position:"Query" name:"AliasName"`
	KeyId     string `position:"Query" name:"KeyId"`
}

// UpdateAliasResponse is the response struct for api UpdateAlias
type UpdateAliasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAliasRequest creates a request to invoke UpdateAlias API
func CreateUpdateAliasRequest() (request *UpdateAliasRequest) {
	request = &UpdateAliasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "UpdateAlias", "kms", "openAPI")
	return
}

// CreateUpdateAliasResponse creates a response to parse from UpdateAlias response
func CreateUpdateAliasResponse() (response *UpdateAliasResponse) {
	response = &UpdateAliasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
