// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: harp/bundle/v1/template.proto

package bundlev1

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Template represents bundle template generation definition.
type Template struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApiVersion string        `protobuf:"bytes,1,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	Kind       string        `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	Meta       *TemplateMeta `protobuf:"bytes,3,opt,name=meta,proto3" json:"meta,omitempty"`
	Spec       *TemplateSpec `protobuf:"bytes,4,opt,name=spec,proto3" json:"spec,omitempty"`
}

func (x *Template) Reset() {
	*x = Template{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Template) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Template) ProtoMessage() {}

func (x *Template) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Template.ProtoReflect.Descriptor instead.
func (*Template) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{0}
}

func (x *Template) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *Template) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Template) GetMeta() *TemplateMeta {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *Template) GetSpec() *TemplateSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

// TemplateMeta handles bundle template metadata.
type TemplateMeta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Template name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Template owner.
	Owner string `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	// REQUIRED. Short description for template role.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *TemplateMeta) Reset() {
	*x = TemplateMeta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TemplateMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TemplateMeta) ProtoMessage() {}

func (x *TemplateMeta) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TemplateMeta.ProtoReflect.Descriptor instead.
func (*TemplateMeta) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{1}
}

func (x *TemplateMeta) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TemplateMeta) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *TemplateMeta) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// TemplateSpec handles bundle template specification.
type TemplateSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Selector   *Selector   `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	Namespaces *Namespaces `protobuf:"bytes,2,opt,name=namespaces,proto3" json:"namespaces,omitempty"`
}

func (x *TemplateSpec) Reset() {
	*x = TemplateSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TemplateSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TemplateSpec) ProtoMessage() {}

func (x *TemplateSpec) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TemplateSpec.ProtoReflect.Descriptor instead.
func (*TemplateSpec) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{2}
}

func (x *TemplateSpec) GetSelector() *Selector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *TemplateSpec) GetNamespaces() *Namespaces {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

// BundleTemplateSelector defines secret path generator default values.
type Selector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Quality defines default quality value for CSO path builder.
	Quality string `protobuf:"bytes,1,opt,name=quality,proto3" json:"quality,omitempty"`
	// Platform defines default platform value in CSO path builder.
	Platform string `protobuf:"bytes,2,opt,name=platform,proto3" json:"platform,omitempty"`
	// Product defines default product value in CSO path builder.
	Product string `protobuf:"bytes,3,opt,name=product,proto3" json:"product,omitempty"`
	// Version defines default version value in CSO path builder.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Component defines default component value in CSO path builder.
	Component string `protobuf:"bytes,5,opt,name=component,proto3" json:"component,omitempty"`
}

func (x *Selector) Reset() {
	*x = Selector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Selector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Selector) ProtoMessage() {}

func (x *Selector) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Selector.ProtoReflect.Descriptor instead.
func (*Selector) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{3}
}

func (x *Selector) GetQuality() string {
	if x != nil {
		return x.Quality
	}
	return ""
}

func (x *Selector) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *Selector) GetProduct() string {
	if x != nil {
		return x.Product
	}
	return ""
}

func (x *Selector) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Selector) GetComponent() string {
	if x != nil {
		return x.Component
	}
	return ""
}

// Namespaces defines secret generation template specification accoridng
// to CSO path naming.
type Namespaces struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Infrastructure secret definitions.
	Infrastructure []*InfrastructureNS `protobuf:"bytes,1,rep,name=infrastructure,proto3" json:"infrastructure,omitempty"`
	// Platform secret definitions.
	Platform []*PlatformRegionNS `protobuf:"bytes,2,rep,name=platform,proto3" json:"platform,omitempty"`
	// Product secret definitions.
	Product []*ProductComponentNS `protobuf:"bytes,3,rep,name=product,proto3" json:"product,omitempty"`
	// Application secret definitions.
	Application []*ApplicationComponentNS `protobuf:"bytes,4,rep,name=application,proto3" json:"application,omitempty"`
}

func (x *Namespaces) Reset() {
	*x = Namespaces{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Namespaces) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Namespaces) ProtoMessage() {}

func (x *Namespaces) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Namespaces.ProtoReflect.Descriptor instead.
func (*Namespaces) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{4}
}

func (x *Namespaces) GetInfrastructure() []*InfrastructureNS {
	if x != nil {
		return x.Infrastructure
	}
	return nil
}

func (x *Namespaces) GetPlatform() []*PlatformRegionNS {
	if x != nil {
		return x.Platform
	}
	return nil
}

func (x *Namespaces) GetProduct() []*ProductComponentNS {
	if x != nil {
		return x.Product
	}
	return nil
}

func (x *Namespaces) GetApplication() []*ApplicationComponentNS {
	if x != nil {
		return x.Application
	}
	return nil
}

// InfrastructureSpec is the container for R1 secret generators.
type InfrastructureNS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Infrastructure provider
	Provider string `protobuf:"bytes,1,opt,name=provider,proto3" json:"provider,omitempty"`
	// REQUIRED. Infrastructure provider account
	Account string `protobuf:"bytes,2,opt,name=account,proto3" json:"account,omitempty"`
	// REQUIRED. Infrastructure provider account alias (user-friendly name)
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Short descript for the infrastructure purpose.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// REQUIRED. Cloud Provider Regions
	Regions []*InfrastructureRegionNS `protobuf:"bytes,5,rep,name=regions,proto3" json:"regions,omitempty"`
}

func (x *InfrastructureNS) Reset() {
	*x = InfrastructureNS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfrastructureNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfrastructureNS) ProtoMessage() {}

func (x *InfrastructureNS) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfrastructureNS.ProtoReflect.Descriptor instead.
func (*InfrastructureNS) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{5}
}

func (x *InfrastructureNS) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *InfrastructureNS) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *InfrastructureNS) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InfrastructureNS) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *InfrastructureNS) GetRegions() []*InfrastructureRegionNS {
	if x != nil {
		return x.Regions
	}
	return nil
}

// InfrastructureRegionSpec describes region partition.
type InfrastructureRegionNS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Infrastructure provider region name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Service secret definitions
	Services []*InfrastructureServiceNS `protobuf:"bytes,2,rep,name=services,proto3" json:"services,omitempty"`
}

func (x *InfrastructureRegionNS) Reset() {
	*x = InfrastructureRegionNS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfrastructureRegionNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfrastructureRegionNS) ProtoMessage() {}

func (x *InfrastructureRegionNS) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfrastructureRegionNS.ProtoReflect.Descriptor instead.
func (*InfrastructureRegionNS) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{6}
}

func (x *InfrastructureRegionNS) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InfrastructureRegionNS) GetServices() []*InfrastructureServiceNS {
	if x != nil {
		return x.Services
	}
	return nil
}

// InfrastructureServiceSpec describes infrastructure service.
type InfrastructureServiceNS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Service type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// REQUIRED. Service name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Service usage short description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// REQUIRED. Secret definitions.
	Secrets []*SecretSuffix `protobuf:"bytes,4,rep,name=secrets,proto3" json:"secrets,omitempty"`
}

func (x *InfrastructureServiceNS) Reset() {
	*x = InfrastructureServiceNS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfrastructureServiceNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfrastructureServiceNS) ProtoMessage() {}

func (x *InfrastructureServiceNS) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfrastructureServiceNS.ProtoReflect.Descriptor instead.
func (*InfrastructureServiceNS) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{7}
}

func (x *InfrastructureServiceNS) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *InfrastructureServiceNS) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InfrastructureServiceNS) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *InfrastructureServiceNS) GetSecrets() []*SecretSuffix {
	if x != nil {
		return x.Secrets
	}
	return nil
}

// PlatformRegionNS is the container for R2 secret generators.
type PlatformRegionNS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Platform region name.
	Region string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	// REQUIRED. Platform region short description.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// REQUIRED. Platform components deployed in the given region.
	Components []*PlatformComponentNS `protobuf:"bytes,3,rep,name=components,proto3" json:"components,omitempty"`
}

func (x *PlatformRegionNS) Reset() {
	*x = PlatformRegionNS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformRegionNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformRegionNS) ProtoMessage() {}

func (x *PlatformRegionNS) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformRegionNS.ProtoReflect.Descriptor instead.
func (*PlatformRegionNS) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{8}
}

func (x *PlatformRegionNS) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *PlatformRegionNS) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PlatformRegionNS) GetComponents() []*PlatformComponentNS {
	if x != nil {
		return x.Components
	}
	return nil
}

// PlatformComponentSpec describes platform components.
type PlatformComponentNS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Component type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// REQUIRED. Component name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Component short description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// REQUIRED. Secret definitions.
	Secrets []*SecretSuffix `protobuf:"bytes,4,rep,name=secrets,proto3" json:"secrets,omitempty"`
}

func (x *PlatformComponentNS) Reset() {
	*x = PlatformComponentNS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformComponentNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformComponentNS) ProtoMessage() {}

func (x *PlatformComponentNS) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformComponentNS.ProtoReflect.Descriptor instead.
func (*PlatformComponentNS) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{9}
}

func (x *PlatformComponentNS) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *PlatformComponentNS) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PlatformComponentNS) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PlatformComponentNS) GetSecrets() []*SecretSuffix {
	if x != nil {
		return x.Secrets
	}
	return nil
}

// ProductComponentNS describes product components.
type ProductComponentNS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Product type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// REQUIRED. Product name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Product short description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// REQUIRED. Secret definitions.
	Secrets []*SecretSuffix `protobuf:"bytes,4,rep,name=secrets,proto3" json:"secrets,omitempty"`
}

func (x *ProductComponentNS) Reset() {
	*x = ProductComponentNS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductComponentNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductComponentNS) ProtoMessage() {}

func (x *ProductComponentNS) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductComponentNS.ProtoReflect.Descriptor instead.
func (*ProductComponentNS) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{10}
}

func (x *ProductComponentNS) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ProductComponentNS) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProductComponentNS) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ProductComponentNS) GetSecrets() []*SecretSuffix {
	if x != nil {
		return x.Secrets
	}
	return nil
}

// ApplicationComponentNS describes application components.
type ApplicationComponentNS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Application type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// REQUIRED. Application name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Application short description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// REQUIRED. Secret definitions.
	Secrets []*SecretSuffix `protobuf:"bytes,4,rep,name=secrets,proto3" json:"secrets,omitempty"`
}

func (x *ApplicationComponentNS) Reset() {
	*x = ApplicationComponentNS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationComponentNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationComponentNS) ProtoMessage() {}

func (x *ApplicationComponentNS) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationComponentNS.ProtoReflect.Descriptor instead.
func (*ApplicationComponentNS) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{11}
}

func (x *ApplicationComponentNS) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ApplicationComponentNS) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApplicationComponentNS) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ApplicationComponentNS) GetSecrets() []*SecretSuffix {
	if x != nil {
		return x.Secrets
	}
	return nil
}

// SecretSuffix holds secret value generation details.
type SecretSuffix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. CSO Suffix.
	Suffix string `protobuf:"bytes,1,opt,name=suffix,proto3" json:"suffix,omitempty"`
	// REQUIRED. Short description of the purpose of the secret.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Defines if secret is managed or not (generated vs static secret).
	Vendor bool `protobuf:"varint,3,opt,name=vendor,proto3" json:"vendor,omitempty"`
	// JSON Template for K/V Generation.
	Template string `protobuf:"bytes,4,opt,name=template,proto3" json:"template,omitempty"`
	// String Content for file embedding process. (filename / content)
	Content map[string]string `protobuf:"bytes,5,rep,name=content,proto3" json:"content,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Secret labels contains identifying information used for query (i.e. Patch selector).
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Secret annotations not used internally used by external harp environments.
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SecretSuffix) Reset() {
	*x = SecretSuffix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_template_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretSuffix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretSuffix) ProtoMessage() {}

func (x *SecretSuffix) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_template_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretSuffix.ProtoReflect.Descriptor instead.
func (*SecretSuffix) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_template_proto_rawDescGZIP(), []int{12}
}

func (x *SecretSuffix) GetSuffix() string {
	if x != nil {
		return x.Suffix
	}
	return ""
}

func (x *SecretSuffix) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SecretSuffix) GetVendor() bool {
	if x != nil {
		return x.Vendor
	}
	return false
}

func (x *SecretSuffix) GetTemplate() string {
	if x != nil {
		return x.Template
	}
	return ""
}

func (x *SecretSuffix) GetContent() map[string]string {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *SecretSuffix) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *SecretSuffix) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

var File_harp_bundle_v1_template_proto protoreflect.FileDescriptor

var file_harp_bundle_v1_template_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x68, 0x61, 0x72, 0x70, 0x2f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x22,
	0xa3, 0x01, 0x0a, 0x08, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x12, 0x30, 0x0a, 0x04, 0x6d, 0x65, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x04, 0x6d,
	0x65, 0x74, 0x61, 0x12, 0x30, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x04, 0x73, 0x70, 0x65, 0x63, 0x22, 0x5a, 0x0a, 0x0c, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x80, 0x01, 0x0a, 0x0c, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x34, 0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x08,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x3a, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x68,
	0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x22, 0x92, 0x01, 0x0a, 0x08, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x18, 0x0a, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x22, 0x9c, 0x02, 0x0a, 0x0a, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0e, 0x69, 0x6e, 0x66, 0x72,
	0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x4e, 0x53, 0x52, 0x0e, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x4e, 0x53, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x12, 0x3c, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x4e, 0x53, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x48,
	0x0a, 0x0b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4e, 0x53, 0x52, 0x0b, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc0, 0x01, 0x0a, 0x10, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x4e, 0x53, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x07, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x72,
	0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x66, 0x72,
	0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x4e, 0x53, 0x52, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x71, 0x0a, 0x16, 0x49,
	0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x4e, 0x53, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x68, 0x61,
	0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4e, 0x53, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0x9b,
	0x01, 0x0a, 0x17, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x53, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x75, 0x66,
	0x66, 0x69, 0x78, 0x52, 0x07, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x22, 0x91, 0x01, 0x0a,
	0x10, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x4e,
	0x53, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0a, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x4e, 0x53, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73,
	0x22, 0x97, 0x01, 0x0a, 0x13, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4e, 0x53, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x75, 0x66, 0x66, 0x69,
	0x78, 0x52, 0x07, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x22, 0x96, 0x01, 0x0a, 0x12, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4e,
	0x53, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x07, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68,
	0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x52, 0x07, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x16, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4e, 0x53, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x72, 0x70,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x52, 0x07, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73,
	0x22, 0x8b, 0x04, 0x0a, 0x0c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x75, 0x66, 0x66, 0x69,
	0x78, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x76,
	0x65, 0x6e, 0x64, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x76, 0x65, 0x6e,
	0x64, 0x6f, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x43, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61,
	0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e,
	0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0xa1,
	0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x65, 0x6c,
	0x61, 0x73, 0x74, 0x69, 0x63, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x65, 0x63, 0x2e, 0x68,
	0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6c, 0x61, 0x73, 0x74,
	0x69, 0x63, 0x2f, 0x68, 0x61, 0x72, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x2f,
	0x67, 0x6f, 0x2f, 0x68, 0x61, 0x72, 0x70, 0x2f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2f, 0x76,
	0x31, 0x3b, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x76, 0x31, 0xa2, 0x02, 0x03, 0x53, 0x42, 0x58,
	0xaa, 0x02, 0x0e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x0e, 0x68, 0x61, 0x72, 0x70, 0x5c, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5c,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_harp_bundle_v1_template_proto_rawDescOnce sync.Once
	file_harp_bundle_v1_template_proto_rawDescData = file_harp_bundle_v1_template_proto_rawDesc
)

func file_harp_bundle_v1_template_proto_rawDescGZIP() []byte {
	file_harp_bundle_v1_template_proto_rawDescOnce.Do(func() {
		file_harp_bundle_v1_template_proto_rawDescData = protoimpl.X.CompressGZIP(file_harp_bundle_v1_template_proto_rawDescData)
	})
	return file_harp_bundle_v1_template_proto_rawDescData
}

var (
	file_harp_bundle_v1_template_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
	file_harp_bundle_v1_template_proto_goTypes  = []interface{}{
		(*Template)(nil),                // 0: harp.bundle.v1.Template
		(*TemplateMeta)(nil),            // 1: harp.bundle.v1.TemplateMeta
		(*TemplateSpec)(nil),            // 2: harp.bundle.v1.TemplateSpec
		(*Selector)(nil),                // 3: harp.bundle.v1.Selector
		(*Namespaces)(nil),              // 4: harp.bundle.v1.Namespaces
		(*InfrastructureNS)(nil),        // 5: harp.bundle.v1.InfrastructureNS
		(*InfrastructureRegionNS)(nil),  // 6: harp.bundle.v1.InfrastructureRegionNS
		(*InfrastructureServiceNS)(nil), // 7: harp.bundle.v1.InfrastructureServiceNS
		(*PlatformRegionNS)(nil),        // 8: harp.bundle.v1.PlatformRegionNS
		(*PlatformComponentNS)(nil),     // 9: harp.bundle.v1.PlatformComponentNS
		(*ProductComponentNS)(nil),      // 10: harp.bundle.v1.ProductComponentNS
		(*ApplicationComponentNS)(nil),  // 11: harp.bundle.v1.ApplicationComponentNS
		(*SecretSuffix)(nil),            // 12: harp.bundle.v1.SecretSuffix
		nil,                             // 13: harp.bundle.v1.SecretSuffix.ContentEntry
		nil,                             // 14: harp.bundle.v1.SecretSuffix.LabelsEntry
		nil,                             // 15: harp.bundle.v1.SecretSuffix.AnnotationsEntry
	}
)

var file_harp_bundle_v1_template_proto_depIdxs = []int32{
	1,  // 0: harp.bundle.v1.Template.meta:type_name -> harp.bundle.v1.TemplateMeta
	2,  // 1: harp.bundle.v1.Template.spec:type_name -> harp.bundle.v1.TemplateSpec
	3,  // 2: harp.bundle.v1.TemplateSpec.selector:type_name -> harp.bundle.v1.Selector
	4,  // 3: harp.bundle.v1.TemplateSpec.namespaces:type_name -> harp.bundle.v1.Namespaces
	5,  // 4: harp.bundle.v1.Namespaces.infrastructure:type_name -> harp.bundle.v1.InfrastructureNS
	8,  // 5: harp.bundle.v1.Namespaces.platform:type_name -> harp.bundle.v1.PlatformRegionNS
	10, // 6: harp.bundle.v1.Namespaces.product:type_name -> harp.bundle.v1.ProductComponentNS
	11, // 7: harp.bundle.v1.Namespaces.application:type_name -> harp.bundle.v1.ApplicationComponentNS
	6,  // 8: harp.bundle.v1.InfrastructureNS.regions:type_name -> harp.bundle.v1.InfrastructureRegionNS
	7,  // 9: harp.bundle.v1.InfrastructureRegionNS.services:type_name -> harp.bundle.v1.InfrastructureServiceNS
	12, // 10: harp.bundle.v1.InfrastructureServiceNS.secrets:type_name -> harp.bundle.v1.SecretSuffix
	9,  // 11: harp.bundle.v1.PlatformRegionNS.components:type_name -> harp.bundle.v1.PlatformComponentNS
	12, // 12: harp.bundle.v1.PlatformComponentNS.secrets:type_name -> harp.bundle.v1.SecretSuffix
	12, // 13: harp.bundle.v1.ProductComponentNS.secrets:type_name -> harp.bundle.v1.SecretSuffix
	12, // 14: harp.bundle.v1.ApplicationComponentNS.secrets:type_name -> harp.bundle.v1.SecretSuffix
	13, // 15: harp.bundle.v1.SecretSuffix.content:type_name -> harp.bundle.v1.SecretSuffix.ContentEntry
	14, // 16: harp.bundle.v1.SecretSuffix.labels:type_name -> harp.bundle.v1.SecretSuffix.LabelsEntry
	15, // 17: harp.bundle.v1.SecretSuffix.annotations:type_name -> harp.bundle.v1.SecretSuffix.AnnotationsEntry
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_harp_bundle_v1_template_proto_init() }
func file_harp_bundle_v1_template_proto_init() {
	if File_harp_bundle_v1_template_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_harp_bundle_v1_template_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Template); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TemplateMeta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TemplateSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Selector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Namespaces); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InfrastructureNS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InfrastructureRegionNS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InfrastructureServiceNS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformRegionNS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformComponentNS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductComponentNS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationComponentNS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_template_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretSuffix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_harp_bundle_v1_template_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_harp_bundle_v1_template_proto_goTypes,
		DependencyIndexes: file_harp_bundle_v1_template_proto_depIdxs,
		MessageInfos:      file_harp_bundle_v1_template_proto_msgTypes,
	}.Build()
	File_harp_bundle_v1_template_proto = out.File
	file_harp_bundle_v1_template_proto_rawDesc = nil
	file_harp_bundle_v1_template_proto_goTypes = nil
	file_harp_bundle_v1_template_proto_depIdxs = nil
}
