// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: harp/bundle/v1/patch.proto

package bundlev1

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Patch represents bundle patch definition.
type Patch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Default to ""
	ApiVersion string `protobuf:"bytes,1,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Default to "BundlePatch"
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	// BundlePatch metadata
	Meta *PatchMeta `protobuf:"bytes,3,opt,name=meta,proto3" json:"meta,omitempty"`
	// BundlePatch specification
	Spec *PatchSpec `protobuf:"bytes,4,opt,name=spec,proto3" json:"spec,omitempty"`
}

func (x *Patch) Reset() {
	*x = Patch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Patch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Patch) ProtoMessage() {}

func (x *Patch) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Patch.ProtoReflect.Descriptor instead.
func (*Patch) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{0}
}

func (x *Patch) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *Patch) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Patch) GetMeta() *PatchMeta {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *Patch) GetSpec() *PatchSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

// PatchMeta handles patch metadata.
type PatchMeta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// REQUIRED. Template name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Template owner.
	Owner string `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	// REQUIRED. Short description for template role.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *PatchMeta) Reset() {
	*x = PatchMeta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchMeta) ProtoMessage() {}

func (x *PatchMeta) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchMeta.ProtoReflect.Descriptor instead.
func (*PatchMeta) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{1}
}

func (x *PatchMeta) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PatchMeta) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *PatchMeta) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// PatchSpec repesetns bundle patch specification holder.
type PatchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Executor *PatchExecutor `protobuf:"bytes,1,opt,name=executor,proto3" json:"executor,omitempty"`
	// Patch selector rules. Applied in the declaration order.
	Rules []*PatchRule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *PatchSpec) Reset() {
	*x = PatchSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchSpec) ProtoMessage() {}

func (x *PatchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchSpec.ProtoReflect.Descriptor instead.
func (*PatchSpec) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{2}
}

func (x *PatchSpec) GetExecutor() *PatchExecutor {
	if x != nil {
		return x.Executor
	}
	return nil
}

func (x *PatchSpec) GetRules() []*PatchRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type PatchExecutor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable/Disable annotations after patch application.
	DisableAnnotations bool `protobuf:"varint,1,opt,name=disableAnnotations,proto3" json:"disableAnnotations,omitempty"`
}

func (x *PatchExecutor) Reset() {
	*x = PatchExecutor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchExecutor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchExecutor) ProtoMessage() {}

func (x *PatchExecutor) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchExecutor.ProtoReflect.Descriptor instead.
func (*PatchExecutor) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{3}
}

func (x *PatchExecutor) GetDisableAnnotations() bool {
	if x != nil {
		return x.DisableAnnotations
	}
	return false
}

// PatchRule represents an operation to apply to a given bundle.
type PatchRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rule identifier.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Used to determine is patch strategy is applicable to the package.
	Selector *PatchSelector `protobuf:"bytes,2,opt,name=selector,proto3" json:"selector,omitempty"`
	// Package patch operations.
	Package *PatchPackage `protobuf:"bytes,3,opt,name=package,proto3" json:"package,omitempty"`
}

func (x *PatchRule) Reset() {
	*x = PatchRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchRule) ProtoMessage() {}

func (x *PatchRule) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchRule.ProtoReflect.Descriptor instead.
func (*PatchRule) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{4}
}

func (x *PatchRule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PatchRule) GetSelector() *PatchSelector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *PatchRule) GetPackage() *PatchPackage {
	if x != nil {
		return x.Package
	}
	return nil
}

// PatchSelector represents selecting strategies used to match a bundle resource.
type PatchSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Match a package by using its path (secret path).
	MatchPath *PatchSelectorMatchPath `protobuf:"bytes,1,opt,name=matchPath,proto3" json:"matchPath,omitempty"`
	// Match a package using a JMESPath query.
	JmesPath string `protobuf:"bytes,2,opt,name=jmesPath,proto3" json:"jmesPath,omitempty"`
	// Match a package using a Rego policy.
	Rego string `protobuf:"bytes,3,opt,name=rego,proto3" json:"rego,omitempty"`
	// Match a package using a REgo policy stored in an external file.
	RegoFile string `protobuf:"bytes,4,opt,name=regoFile,proto3" json:"regoFile,omitempty"`
	// Match a package by secret.
	MatchSecret *PatchSelectorMatchSecret `protobuf:"bytes,5,opt,name=matchSecret,proto3" json:"matchSecret,omitempty"`
	// Match a package using CEL expressions.
	Cel []string `protobuf:"bytes,6,rep,name=cel,proto3" json:"cel,omitempty"`
}

func (x *PatchSelector) Reset() {
	*x = PatchSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchSelector) ProtoMessage() {}

func (x *PatchSelector) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchSelector.ProtoReflect.Descriptor instead.
func (*PatchSelector) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{5}
}

func (x *PatchSelector) GetMatchPath() *PatchSelectorMatchPath {
	if x != nil {
		return x.MatchPath
	}
	return nil
}

func (x *PatchSelector) GetJmesPath() string {
	if x != nil {
		return x.JmesPath
	}
	return ""
}

func (x *PatchSelector) GetRego() string {
	if x != nil {
		return x.Rego
	}
	return ""
}

func (x *PatchSelector) GetRegoFile() string {
	if x != nil {
		return x.RegoFile
	}
	return ""
}

func (x *PatchSelector) GetMatchSecret() *PatchSelectorMatchSecret {
	if x != nil {
		return x.MatchSecret
	}
	return nil
}

func (x *PatchSelector) GetCel() []string {
	if x != nil {
		return x.Cel
	}
	return nil
}

// PatchSelectorMatchPath represents package path matching strategies.
type PatchSelectorMatchPath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Strict case-sensitive path matching.
	// Value can be templatized.
	Strict string `protobuf:"bytes,1,opt,name=strict,proto3" json:"strict,omitempty"`
	// Regex path matching.
	// Value can be templatized.
	Regex string `protobuf:"bytes,2,opt,name=regex,proto3" json:"regex,omitempty"`
	// Glob path matching. - https://github.com/gobwas/glob
	// Value can be templatized.
	Glob string `protobuf:"bytes,3,opt,name=glob,proto3" json:"glob,omitempty"`
}

func (x *PatchSelectorMatchPath) Reset() {
	*x = PatchSelectorMatchPath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchSelectorMatchPath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchSelectorMatchPath) ProtoMessage() {}

func (x *PatchSelectorMatchPath) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchSelectorMatchPath.ProtoReflect.Descriptor instead.
func (*PatchSelectorMatchPath) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{6}
}

func (x *PatchSelectorMatchPath) GetStrict() string {
	if x != nil {
		return x.Strict
	}
	return ""
}

func (x *PatchSelectorMatchPath) GetRegex() string {
	if x != nil {
		return x.Regex
	}
	return ""
}

func (x *PatchSelectorMatchPath) GetGlob() string {
	if x != nil {
		return x.Glob
	}
	return ""
}

// PatchSelectorMatchPath represents package path matching strategies.
type PatchSelectorMatchSecret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Strict case-sensitive secret matching.
	// Value can be templatized.
	Strict string `protobuf:"bytes,1,opt,name=strict,proto3" json:"strict,omitempty"`
	// Regex secret matching.
	// Value can be templatized.
	Regex string `protobuf:"bytes,2,opt,name=regex,proto3" json:"regex,omitempty"`
	// Glob path matching. - https://github.com/gobwas/glob
	// Value can be templatized.
	Glob string `protobuf:"bytes,3,opt,name=glob,proto3" json:"glob,omitempty"`
}

func (x *PatchSelectorMatchSecret) Reset() {
	*x = PatchSelectorMatchSecret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchSelectorMatchSecret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchSelectorMatchSecret) ProtoMessage() {}

func (x *PatchSelectorMatchSecret) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchSelectorMatchSecret.ProtoReflect.Descriptor instead.
func (*PatchSelectorMatchSecret) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{7}
}

func (x *PatchSelectorMatchSecret) GetStrict() string {
	if x != nil {
		return x.Strict
	}
	return ""
}

func (x *PatchSelectorMatchSecret) GetRegex() string {
	if x != nil {
		return x.Regex
	}
	return ""
}

func (x *PatchSelectorMatchSecret) GetGlob() string {
	if x != nil {
		return x.Glob
	}
	return ""
}

// PatchPackagePath represents package path operations.
type PatchPackagePath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Template used to completely rewrite the package path.
	Template string `protobuf:"bytes,1,opt,name=template,proto3" json:"template,omitempty"`
}

func (x *PatchPackagePath) Reset() {
	*x = PatchPackagePath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchPackagePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchPackagePath) ProtoMessage() {}

func (x *PatchPackagePath) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchPackagePath.ProtoReflect.Descriptor instead.
func (*PatchPackagePath) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{8}
}

func (x *PatchPackagePath) GetTemplate() string {
	if x != nil {
		return x.Template
	}
	return ""
}

// PatchPackage represents package operations.
type PatchPackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path operations.
	Path *PatchPackagePath `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Annotation operations.
	Annotations *PatchOperation `protobuf:"bytes,2,opt,name=annotations,proto3" json:"annotations,omitempty"`
	// Label operations.
	Labels *PatchOperation `protobuf:"bytes,3,opt,name=labels,proto3" json:"labels,omitempty"`
	// Secret data operations.
	Data *PatchSecret `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	// Flag as remove.
	Remove bool `protobuf:"varint,5,opt,name=remove,proto3" json:"remove,omitempty"`
	// Flag to create if not exist.
	Create bool `protobuf:"varint,6,opt,name=create,proto3" json:"create,omitempty"`
}

func (x *PatchPackage) Reset() {
	*x = PatchPackage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchPackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchPackage) ProtoMessage() {}

func (x *PatchPackage) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchPackage.ProtoReflect.Descriptor instead.
func (*PatchPackage) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{9}
}

func (x *PatchPackage) GetPath() *PatchPackagePath {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *PatchPackage) GetAnnotations() *PatchOperation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PatchPackage) GetLabels() *PatchOperation {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PatchPackage) GetData() *PatchSecret {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *PatchPackage) GetRemove() bool {
	if x != nil {
		return x.Remove
	}
	return false
}

func (x *PatchPackage) GetCreate() bool {
	if x != nil {
		return x.Create
	}
	return false
}

// PatchSecret represents secret data operations.
type PatchSecret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Secret data annotation operations.
	Annotations *PatchOperation `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations,omitempty"`
	// Secret data label operations.
	Labels *PatchOperation `protobuf:"bytes,2,opt,name=labels,proto3" json:"labels,omitempty"`
	// Template to override secret data.
	Template string `protobuf:"bytes,3,opt,name=template,proto3" json:"template,omitempty"`
	// Used to target specific keys inside the secret data.
	Kv *PatchOperation `protobuf:"bytes,4,opt,name=kv,proto3" json:"kv,omitempty"`
}

func (x *PatchSecret) Reset() {
	*x = PatchSecret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchSecret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchSecret) ProtoMessage() {}

func (x *PatchSecret) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchSecret.ProtoReflect.Descriptor instead.
func (*PatchSecret) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{10}
}

func (x *PatchSecret) GetAnnotations() *PatchOperation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PatchSecret) GetLabels() *PatchOperation {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PatchSecret) GetTemplate() string {
	if x != nil {
		return x.Template
	}
	return ""
}

func (x *PatchSecret) GetKv() *PatchOperation {
	if x != nil {
		return x.Kv
	}
	return nil
}

// PatchOperation represents atomic patch operations executable on a k/v map.
type PatchOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Add a new case-sentitive key and value to related data map.
	// Key and Value can be templatized.
	Add map[string]string `protobuf:"bytes,1,rep,name=add,proto3" json:"add,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Remove a case-sensitive key from related data map.
	// Key and Value can be templatized.
	Remove []string `protobuf:"bytes,2,rep,name=remove,proto3" json:"remove,omitempty"`
	// Update case-sensitive existing key from related data map.
	// Key and Value can be templatized.
	Update map[string]string `protobuf:"bytes,3,rep,name=update,proto3" json:"update,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Replace case-sensitive existing key using the associated value.
	// Value can be templatized.
	ReplaceKeys map[string]string `protobuf:"bytes,4,rep,name=replaceKeys,proto3" json:"replaceKeys,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Remove all keys matching these given regexp.
	RemoveKeys []string `protobuf:"bytes,5,rep,name=removeKeys,proto3" json:"removeKeys,omitempty"`
}

func (x *PatchOperation) Reset() {
	*x = PatchOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_harp_bundle_v1_patch_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchOperation) ProtoMessage() {}

func (x *PatchOperation) ProtoReflect() protoreflect.Message {
	mi := &file_harp_bundle_v1_patch_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchOperation.ProtoReflect.Descriptor instead.
func (*PatchOperation) Descriptor() ([]byte, []int) {
	return file_harp_bundle_v1_patch_proto_rawDescGZIP(), []int{11}
}

func (x *PatchOperation) GetAdd() map[string]string {
	if x != nil {
		return x.Add
	}
	return nil
}

func (x *PatchOperation) GetRemove() []string {
	if x != nil {
		return x.Remove
	}
	return nil
}

func (x *PatchOperation) GetUpdate() map[string]string {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *PatchOperation) GetReplaceKeys() map[string]string {
	if x != nil {
		return x.ReplaceKeys
	}
	return nil
}

func (x *PatchOperation) GetRemoveKeys() []string {
	if x != nil {
		return x.RemoveKeys
	}
	return nil
}

var File_harp_bundle_v1_patch_proto protoreflect.FileDescriptor

var file_harp_bundle_v1_patch_proto_rawDesc = []byte{
	0x0a, 0x1a, 0x68, 0x61, 0x72, 0x70, 0x2f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x68, 0x61,
	0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x22, 0x9a, 0x01, 0x0a,
	0x05, 0x50, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x70, 0x69,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x2d, 0x0a, 0x04, 0x6d,
	0x65, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x68, 0x61, 0x72, 0x70,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68,
	0x4d, 0x65, 0x74, 0x61, 0x52, 0x04, 0x6d, 0x65, 0x74, 0x61, 0x12, 0x2d, 0x0a, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e,
	0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x22, 0x57, 0x0a, 0x09, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x77, 0x0a, 0x09, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x39, 0x0a, 0x08, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x52, 0x08, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x12, 0x2f, 0x0a, 0x05, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x68, 0x61, 0x72, 0x70,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x3f, 0x0a, 0x0d, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x12, 0x2e, 0x0a, 0x12,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8e, 0x01, 0x0a,
	0x09, 0x50, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x39, 0x0a, 0x08, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x68,
	0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x08, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x36, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x22, 0xff, 0x01,
	0x0a, 0x0d, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12,
	0x44, 0x0a, 0x09, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x52, 0x09, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x6a, 0x6d, 0x65, 0x73, 0x50, 0x61, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6a, 0x6d, 0x65, 0x73, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x65, 0x67, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x72, 0x65, 0x67, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x67, 0x6f, 0x46, 0x69, 0x6c,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x67, 0x6f, 0x46, 0x69, 0x6c,
	0x65, 0x12, 0x4a, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x52, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x63, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x03, 0x63, 0x65, 0x6c, 0x22,
	0x5a, 0x0a, 0x16, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x6c, 0x6f, 0x62, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x67, 0x6c, 0x6f, 0x62, 0x22, 0x5c, 0x0a, 0x18, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x72, 0x65, 0x67, 0x65, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x6c, 0x6f, 0x62, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x67, 0x6c, 0x6f, 0x62, 0x22, 0x2e, 0x0a, 0x10, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a,
	0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x9f, 0x02, 0x0a, 0x0c, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x34, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e,
	0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x50, 0x61, 0x74, 0x68, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x12, 0x40, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x36, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2f, 0x0a, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e,
	0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x22, 0xd3, 0x01, 0x0a, 0x0b,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x2e, 0x0a, 0x02, 0x6b, 0x76, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x02, 0x6b,
	0x76, 0x22, 0xcd, 0x03, 0x0a, 0x0e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x03, 0x61, 0x64, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x64, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x61, 0x64, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x51, 0x0a, 0x0b, 0x72,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1e,
	0x0a, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x1a, 0x36,
	0x0a, 0x08, 0x41, 0x64, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x42, 0x9e, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x65, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x65,
	0x63, 0x2e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x42, 0x0a, 0x50, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6c, 0x61, 0x73, 0x74,
	0x69, 0x63, 0x2f, 0x68, 0x61, 0x72, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x2f,
	0x67, 0x6f, 0x2f, 0x68, 0x61, 0x72, 0x70, 0x2f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2f, 0x76,
	0x31, 0x3b, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x76, 0x31, 0xa2, 0x02, 0x03, 0x53, 0x42, 0x58,
	0xaa, 0x02, 0x0e, 0x68, 0x61, 0x72, 0x70, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x0e, 0x68, 0x61, 0x72, 0x70, 0x5c, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5c,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_harp_bundle_v1_patch_proto_rawDescOnce sync.Once
	file_harp_bundle_v1_patch_proto_rawDescData = file_harp_bundle_v1_patch_proto_rawDesc
)

func file_harp_bundle_v1_patch_proto_rawDescGZIP() []byte {
	file_harp_bundle_v1_patch_proto_rawDescOnce.Do(func() {
		file_harp_bundle_v1_patch_proto_rawDescData = protoimpl.X.CompressGZIP(file_harp_bundle_v1_patch_proto_rawDescData)
	})
	return file_harp_bundle_v1_patch_proto_rawDescData
}

var (
	file_harp_bundle_v1_patch_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
	file_harp_bundle_v1_patch_proto_goTypes  = []interface{}{
		(*Patch)(nil),                    // 0: harp.bundle.v1.Patch
		(*PatchMeta)(nil),                // 1: harp.bundle.v1.PatchMeta
		(*PatchSpec)(nil),                // 2: harp.bundle.v1.PatchSpec
		(*PatchExecutor)(nil),            // 3: harp.bundle.v1.PatchExecutor
		(*PatchRule)(nil),                // 4: harp.bundle.v1.PatchRule
		(*PatchSelector)(nil),            // 5: harp.bundle.v1.PatchSelector
		(*PatchSelectorMatchPath)(nil),   // 6: harp.bundle.v1.PatchSelectorMatchPath
		(*PatchSelectorMatchSecret)(nil), // 7: harp.bundle.v1.PatchSelectorMatchSecret
		(*PatchPackagePath)(nil),         // 8: harp.bundle.v1.PatchPackagePath
		(*PatchPackage)(nil),             // 9: harp.bundle.v1.PatchPackage
		(*PatchSecret)(nil),              // 10: harp.bundle.v1.PatchSecret
		(*PatchOperation)(nil),           // 11: harp.bundle.v1.PatchOperation
		nil,                              // 12: harp.bundle.v1.PatchOperation.AddEntry
		nil,                              // 13: harp.bundle.v1.PatchOperation.UpdateEntry
		nil,                              // 14: harp.bundle.v1.PatchOperation.ReplaceKeysEntry
	}
)

var file_harp_bundle_v1_patch_proto_depIdxs = []int32{
	1,  // 0: harp.bundle.v1.Patch.meta:type_name -> harp.bundle.v1.PatchMeta
	2,  // 1: harp.bundle.v1.Patch.spec:type_name -> harp.bundle.v1.PatchSpec
	3,  // 2: harp.bundle.v1.PatchSpec.executor:type_name -> harp.bundle.v1.PatchExecutor
	4,  // 3: harp.bundle.v1.PatchSpec.rules:type_name -> harp.bundle.v1.PatchRule
	5,  // 4: harp.bundle.v1.PatchRule.selector:type_name -> harp.bundle.v1.PatchSelector
	9,  // 5: harp.bundle.v1.PatchRule.package:type_name -> harp.bundle.v1.PatchPackage
	6,  // 6: harp.bundle.v1.PatchSelector.matchPath:type_name -> harp.bundle.v1.PatchSelectorMatchPath
	7,  // 7: harp.bundle.v1.PatchSelector.matchSecret:type_name -> harp.bundle.v1.PatchSelectorMatchSecret
	8,  // 8: harp.bundle.v1.PatchPackage.path:type_name -> harp.bundle.v1.PatchPackagePath
	11, // 9: harp.bundle.v1.PatchPackage.annotations:type_name -> harp.bundle.v1.PatchOperation
	11, // 10: harp.bundle.v1.PatchPackage.labels:type_name -> harp.bundle.v1.PatchOperation
	10, // 11: harp.bundle.v1.PatchPackage.data:type_name -> harp.bundle.v1.PatchSecret
	11, // 12: harp.bundle.v1.PatchSecret.annotations:type_name -> harp.bundle.v1.PatchOperation
	11, // 13: harp.bundle.v1.PatchSecret.labels:type_name -> harp.bundle.v1.PatchOperation
	11, // 14: harp.bundle.v1.PatchSecret.kv:type_name -> harp.bundle.v1.PatchOperation
	12, // 15: harp.bundle.v1.PatchOperation.add:type_name -> harp.bundle.v1.PatchOperation.AddEntry
	13, // 16: harp.bundle.v1.PatchOperation.update:type_name -> harp.bundle.v1.PatchOperation.UpdateEntry
	14, // 17: harp.bundle.v1.PatchOperation.replaceKeys:type_name -> harp.bundle.v1.PatchOperation.ReplaceKeysEntry
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_harp_bundle_v1_patch_proto_init() }
func file_harp_bundle_v1_patch_proto_init() {
	if File_harp_bundle_v1_patch_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_harp_bundle_v1_patch_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Patch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchMeta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchExecutor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchSelectorMatchPath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchSelectorMatchSecret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchPackagePath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchPackage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchSecret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_harp_bundle_v1_patch_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_harp_bundle_v1_patch_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_harp_bundle_v1_patch_proto_goTypes,
		DependencyIndexes: file_harp_bundle_v1_patch_proto_depIdxs,
		MessageInfos:      file_harp_bundle_v1_patch_proto_msgTypes,
	}.Build()
	File_harp_bundle_v1_patch_proto = out.File
	file_harp_bundle_v1_patch_proto_rawDesc = nil
	file_harp_bundle_v1_patch_proto_goTypes = nil
	file_harp_bundle_v1_patch_proto_depIdxs = nil
}
