package db

import (
	"fmt"

	grypeDB "github.com/anchore/grype/grype/db/v4"
	"github.com/anchore/grype/grype/vulnerability"
)

var _ vulnerability.MetadataProvider = (*VulnerabilityMetadataProvider)(nil)

type VulnerabilityMetadataProvider struct {
	reader grypeDB.VulnerabilityMetadataStoreReader
}

func NewVulnerabilityMetadataProvider(reader grypeDB.VulnerabilityMetadataStoreReader) *VulnerabilityMetadataProvider {
	return &VulnerabilityMetadataProvider{
		reader: reader,
	}
}

func (pr *VulnerabilityMetadataProvider) GetMetadata(id, namespace string) (*vulnerability.Metadata, error) {
	metadata, err := pr.reader.GetVulnerabilityMetadata(id, namespace)
	if err != nil {
		return nil, fmt.Errorf("metadata provider failed to fetch id='%s' recordsource='%s': %w", id, namespace, err)
	}

	return vulnerability.NewMetadata(metadata)
}
