package v1

const VulnerabilityStoreFileName = "vulnerability.db"

type VulnerabilityStore interface {
	VulnerabilityStoreReader
	VulnerabilityStoreWriter
}

type VulnerabilityStoreReader interface {
	// GetVulnerability retrieves vulnerabilities associated with a namespace and a package name
	GetVulnerability(namespace, name string) ([]Vulnerability, error)
}

type VulnerabilityStoreWriter interface {
	// AddVulnerability inserts a new record of a vulnerability into the store
	AddVulnerability(vulnerabilities ...Vulnerability) error
}
