package vulnerability

import (
	"github.com/anchore/grype/grype/pkg"
	"github.com/anchore/syft/syft/distro"
	syftPkg "github.com/anchore/syft/syft/pkg"
)

type Provider interface {
	ProviderByDistro
	ProviderByLanguage
	ProviderByCPE
}

type ProviderByDistro interface {
	GetByDistro(*distro.Distro, pkg.Package) ([]Vulnerability, error)
}

type ProviderByLanguage interface {
	GetByLanguage(syftPkg.Language, pkg.Package) ([]Vulnerability, error)
}

type ProviderByCPE interface {
	GetByCPE(syftPkg.CPE) ([]Vulnerability, error)
}

type MetadataProvider interface {
	GetMetadata(id, namespace string) (*Metadata, error)
}
