// Code generated by protoc-gen-go. DO NOT EDIT.
// source: bank.proto

package main

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Account_Type int32

const (
	Account_UNKNOWN        Account_Type = 0
	Account_CHECKING       Account_Type = 1
	Account_SAVING         Account_Type = 2
	Account_MONEY_MARKET   Account_Type = 3
	Account_LINE_OF_CREDIT Account_Type = 4
	Account_LOAN           Account_Type = 5
	Account_EQUITIES       Account_Type = 6
)

var Account_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "CHECKING",
	2: "SAVING",
	3: "MONEY_MARKET",
	4: "LINE_OF_CREDIT",
	5: "LOAN",
	6: "EQUITIES",
}
var Account_Type_value = map[string]int32{
	"UNKNOWN":        0,
	"CHECKING":       1,
	"SAVING":         2,
	"MONEY_MARKET":   3,
	"LINE_OF_CREDIT": 4,
	"LOAN":           5,
	"EQUITIES":       6,
}

func (x Account_Type) String() string {
	return proto.EnumName(Account_Type_name, int32(x))
}
func (Account_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{3, 0}
}

type DepositRequest_Source int32

const (
	DepositRequest_UNKNOWN DepositRequest_Source = 0
	DepositRequest_CASH    DepositRequest_Source = 1
	DepositRequest_CHECK   DepositRequest_Source = 2
	DepositRequest_ACH     DepositRequest_Source = 3
	DepositRequest_WIRE    DepositRequest_Source = 4
)

var DepositRequest_Source_name = map[int32]string{
	0: "UNKNOWN",
	1: "CASH",
	2: "CHECK",
	3: "ACH",
	4: "WIRE",
}
var DepositRequest_Source_value = map[string]int32{
	"UNKNOWN": 0,
	"CASH":    1,
	"CHECK":   2,
	"ACH":     3,
	"WIRE":    4,
}

func (x DepositRequest_Source) String() string {
	return proto.EnumName(DepositRequest_Source_name, int32(x))
}
func (DepositRequest_Source) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{6, 0}
}

type OpenAccountRequest struct {
	InitialDepositCents  int32        `protobuf:"varint,1,opt,name=initial_deposit_cents,json=initialDepositCents,proto3" json:"initial_deposit_cents,omitempty"`
	Type                 Account_Type `protobuf:"varint,2,opt,name=type,proto3,enum=Account_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OpenAccountRequest) Reset()         { *m = OpenAccountRequest{} }
func (m *OpenAccountRequest) String() string { return proto.CompactTextString(m) }
func (*OpenAccountRequest) ProtoMessage()    {}
func (*OpenAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{0}
}
func (m *OpenAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OpenAccountRequest.Unmarshal(m, b)
}
func (m *OpenAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OpenAccountRequest.Marshal(b, m, deterministic)
}
func (dst *OpenAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OpenAccountRequest.Merge(dst, src)
}
func (m *OpenAccountRequest) XXX_Size() int {
	return xxx_messageInfo_OpenAccountRequest.Size(m)
}
func (m *OpenAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OpenAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OpenAccountRequest proto.InternalMessageInfo

func (m *OpenAccountRequest) GetInitialDepositCents() int32 {
	if m != nil {
		return m.InitialDepositCents
	}
	return 0
}

func (m *OpenAccountRequest) GetType() Account_Type {
	if m != nil {
		return m.Type
	}
	return Account_UNKNOWN
}

type CloseAccountRequest struct {
	AccountNumber        uint64   `protobuf:"varint,1,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloseAccountRequest) Reset()         { *m = CloseAccountRequest{} }
func (m *CloseAccountRequest) String() string { return proto.CompactTextString(m) }
func (*CloseAccountRequest) ProtoMessage()    {}
func (*CloseAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{1}
}
func (m *CloseAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloseAccountRequest.Unmarshal(m, b)
}
func (m *CloseAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloseAccountRequest.Marshal(b, m, deterministic)
}
func (dst *CloseAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseAccountRequest.Merge(dst, src)
}
func (m *CloseAccountRequest) XXX_Size() int {
	return xxx_messageInfo_CloseAccountRequest.Size(m)
}
func (m *CloseAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloseAccountRequest proto.InternalMessageInfo

func (m *CloseAccountRequest) GetAccountNumber() uint64 {
	if m != nil {
		return m.AccountNumber
	}
	return 0
}

type GetAccountsResponse struct {
	Accounts             []*Account `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetAccountsResponse) Reset()         { *m = GetAccountsResponse{} }
func (m *GetAccountsResponse) String() string { return proto.CompactTextString(m) }
func (*GetAccountsResponse) ProtoMessage()    {}
func (*GetAccountsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{2}
}
func (m *GetAccountsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAccountsResponse.Unmarshal(m, b)
}
func (m *GetAccountsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAccountsResponse.Marshal(b, m, deterministic)
}
func (dst *GetAccountsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAccountsResponse.Merge(dst, src)
}
func (m *GetAccountsResponse) XXX_Size() int {
	return xxx_messageInfo_GetAccountsResponse.Size(m)
}
func (m *GetAccountsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAccountsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetAccountsResponse proto.InternalMessageInfo

func (m *GetAccountsResponse) GetAccounts() []*Account {
	if m != nil {
		return m.Accounts
	}
	return nil
}

type Account struct {
	AccountNumber        uint64       `protobuf:"varint,1,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
	Type                 Account_Type `protobuf:"varint,2,opt,name=type,proto3,enum=Account_Type" json:"type,omitempty"`
	BalanceCents         int32        `protobuf:"varint,3,opt,name=balance_cents,json=balanceCents,proto3" json:"balance_cents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Account) Reset()         { *m = Account{} }
func (m *Account) String() string { return proto.CompactTextString(m) }
func (*Account) ProtoMessage()    {}
func (*Account) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{3}
}
func (m *Account) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Account.Unmarshal(m, b)
}
func (m *Account) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Account.Marshal(b, m, deterministic)
}
func (dst *Account) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Account.Merge(dst, src)
}
func (m *Account) XXX_Size() int {
	return xxx_messageInfo_Account.Size(m)
}
func (m *Account) XXX_DiscardUnknown() {
	xxx_messageInfo_Account.DiscardUnknown(m)
}

var xxx_messageInfo_Account proto.InternalMessageInfo

func (m *Account) GetAccountNumber() uint64 {
	if m != nil {
		return m.AccountNumber
	}
	return 0
}

func (m *Account) GetType() Account_Type {
	if m != nil {
		return m.Type
	}
	return Account_UNKNOWN
}

func (m *Account) GetBalanceCents() int32 {
	if m != nil {
		return m.BalanceCents
	}
	return 0
}

type GetTransactionsRequest struct {
	AccountNumber        uint64               `protobuf:"varint,1,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
	Start                *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start,proto3" json:"start,omitempty"`
	End                  *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end,proto3" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetTransactionsRequest) Reset()         { *m = GetTransactionsRequest{} }
func (m *GetTransactionsRequest) String() string { return proto.CompactTextString(m) }
func (*GetTransactionsRequest) ProtoMessage()    {}
func (*GetTransactionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{4}
}
func (m *GetTransactionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTransactionsRequest.Unmarshal(m, b)
}
func (m *GetTransactionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTransactionsRequest.Marshal(b, m, deterministic)
}
func (dst *GetTransactionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTransactionsRequest.Merge(dst, src)
}
func (m *GetTransactionsRequest) XXX_Size() int {
	return xxx_messageInfo_GetTransactionsRequest.Size(m)
}
func (m *GetTransactionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTransactionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTransactionsRequest proto.InternalMessageInfo

func (m *GetTransactionsRequest) GetAccountNumber() uint64 {
	if m != nil {
		return m.AccountNumber
	}
	return 0
}

func (m *GetTransactionsRequest) GetStart() *timestamp.Timestamp {
	if m != nil {
		return m.Start
	}
	return nil
}

func (m *GetTransactionsRequest) GetEnd() *timestamp.Timestamp {
	if m != nil {
		return m.End
	}
	return nil
}

type Transaction struct {
	AccountNumber        uint64               `protobuf:"varint,1,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
	SeqNumber            uint64               `protobuf:"varint,2,opt,name=seq_number,json=seqNumber,proto3" json:"seq_number,omitempty"`
	Date                 *timestamp.Timestamp `protobuf:"bytes,3,opt,name=date,proto3" json:"date,omitempty"`
	AmountCents          int32                `protobuf:"varint,4,opt,name=amount_cents,json=amountCents,proto3" json:"amount_cents,omitempty"`
	Desc                 string               `protobuf:"bytes,5,opt,name=desc,proto3" json:"desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Transaction) Reset()         { *m = Transaction{} }
func (m *Transaction) String() string { return proto.CompactTextString(m) }
func (*Transaction) ProtoMessage()    {}
func (*Transaction) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{5}
}
func (m *Transaction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Transaction.Unmarshal(m, b)
}
func (m *Transaction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Transaction.Marshal(b, m, deterministic)
}
func (dst *Transaction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Transaction.Merge(dst, src)
}
func (m *Transaction) XXX_Size() int {
	return xxx_messageInfo_Transaction.Size(m)
}
func (m *Transaction) XXX_DiscardUnknown() {
	xxx_messageInfo_Transaction.DiscardUnknown(m)
}

var xxx_messageInfo_Transaction proto.InternalMessageInfo

func (m *Transaction) GetAccountNumber() uint64 {
	if m != nil {
		return m.AccountNumber
	}
	return 0
}

func (m *Transaction) GetSeqNumber() uint64 {
	if m != nil {
		return m.SeqNumber
	}
	return 0
}

func (m *Transaction) GetDate() *timestamp.Timestamp {
	if m != nil {
		return m.Date
	}
	return nil
}

func (m *Transaction) GetAmountCents() int32 {
	if m != nil {
		return m.AmountCents
	}
	return 0
}

func (m *Transaction) GetDesc() string {
	if m != nil {
		return m.Desc
	}
	return ""
}

type DepositRequest struct {
	AccountNumber        uint64                `protobuf:"varint,1,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
	AmountCents          int32                 `protobuf:"varint,2,opt,name=amount_cents,json=amountCents,proto3" json:"amount_cents,omitempty"`
	Source               DepositRequest_Source `protobuf:"varint,3,opt,name=source,proto3,enum=DepositRequest_Source" json:"source,omitempty"`
	Desc                 string                `protobuf:"bytes,4,opt,name=desc,proto3" json:"desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DepositRequest) Reset()         { *m = DepositRequest{} }
func (m *DepositRequest) String() string { return proto.CompactTextString(m) }
func (*DepositRequest) ProtoMessage()    {}
func (*DepositRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{6}
}
func (m *DepositRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DepositRequest.Unmarshal(m, b)
}
func (m *DepositRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DepositRequest.Marshal(b, m, deterministic)
}
func (dst *DepositRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DepositRequest.Merge(dst, src)
}
func (m *DepositRequest) XXX_Size() int {
	return xxx_messageInfo_DepositRequest.Size(m)
}
func (m *DepositRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DepositRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DepositRequest proto.InternalMessageInfo

func (m *DepositRequest) GetAccountNumber() uint64 {
	if m != nil {
		return m.AccountNumber
	}
	return 0
}

func (m *DepositRequest) GetAmountCents() int32 {
	if m != nil {
		return m.AmountCents
	}
	return 0
}

func (m *DepositRequest) GetSource() DepositRequest_Source {
	if m != nil {
		return m.Source
	}
	return DepositRequest_UNKNOWN
}

func (m *DepositRequest) GetDesc() string {
	if m != nil {
		return m.Desc
	}
	return ""
}

type BalanceResponse struct {
	AccountNumber        uint64   `protobuf:"varint,1,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
	BalanceCents         int32    `protobuf:"varint,2,opt,name=balance_cents,json=balanceCents,proto3" json:"balance_cents,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BalanceResponse) Reset()         { *m = BalanceResponse{} }
func (m *BalanceResponse) String() string { return proto.CompactTextString(m) }
func (*BalanceResponse) ProtoMessage()    {}
func (*BalanceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{7}
}
func (m *BalanceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BalanceResponse.Unmarshal(m, b)
}
func (m *BalanceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BalanceResponse.Marshal(b, m, deterministic)
}
func (dst *BalanceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BalanceResponse.Merge(dst, src)
}
func (m *BalanceResponse) XXX_Size() int {
	return xxx_messageInfo_BalanceResponse.Size(m)
}
func (m *BalanceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BalanceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BalanceResponse proto.InternalMessageInfo

func (m *BalanceResponse) GetAccountNumber() uint64 {
	if m != nil {
		return m.AccountNumber
	}
	return 0
}

func (m *BalanceResponse) GetBalanceCents() int32 {
	if m != nil {
		return m.BalanceCents
	}
	return 0
}

type WithdrawRequest struct {
	AccountNumber        uint64   `protobuf:"varint,1,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
	AmountCents          int32    `protobuf:"varint,2,opt,name=amount_cents,json=amountCents,proto3" json:"amount_cents,omitempty"`
	Desc                 string   `protobuf:"bytes,3,opt,name=desc,proto3" json:"desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WithdrawRequest) Reset()         { *m = WithdrawRequest{} }
func (m *WithdrawRequest) String() string { return proto.CompactTextString(m) }
func (*WithdrawRequest) ProtoMessage()    {}
func (*WithdrawRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{8}
}
func (m *WithdrawRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WithdrawRequest.Unmarshal(m, b)
}
func (m *WithdrawRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WithdrawRequest.Marshal(b, m, deterministic)
}
func (dst *WithdrawRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WithdrawRequest.Merge(dst, src)
}
func (m *WithdrawRequest) XXX_Size() int {
	return xxx_messageInfo_WithdrawRequest.Size(m)
}
func (m *WithdrawRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WithdrawRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WithdrawRequest proto.InternalMessageInfo

func (m *WithdrawRequest) GetAccountNumber() uint64 {
	if m != nil {
		return m.AccountNumber
	}
	return 0
}

func (m *WithdrawRequest) GetAmountCents() int32 {
	if m != nil {
		return m.AmountCents
	}
	return 0
}

func (m *WithdrawRequest) GetDesc() string {
	if m != nil {
		return m.Desc
	}
	return ""
}

type TransferRequest struct {
	// Types that are valid to be assigned to Source:
	//	*TransferRequest_SourceAccountNumber
	//	*TransferRequest_ExternalSource
	Source isTransferRequest_Source `protobuf_oneof:"source"`
	// Types that are valid to be assigned to Dest:
	//	*TransferRequest_DestAccountNumber
	//	*TransferRequest_ExternalDest
	Dest                 isTransferRequest_Dest `protobuf_oneof:"dest"`
	AmountCents          int32                  `protobuf:"varint,5,opt,name=amount_cents,json=amountCents,proto3" json:"amount_cents,omitempty"`
	Desc                 string                 `protobuf:"bytes,6,opt,name=desc,proto3" json:"desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *TransferRequest) Reset()         { *m = TransferRequest{} }
func (m *TransferRequest) String() string { return proto.CompactTextString(m) }
func (*TransferRequest) ProtoMessage()    {}
func (*TransferRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{9}
}
func (m *TransferRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransferRequest.Unmarshal(m, b)
}
func (m *TransferRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransferRequest.Marshal(b, m, deterministic)
}
func (dst *TransferRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferRequest.Merge(dst, src)
}
func (m *TransferRequest) XXX_Size() int {
	return xxx_messageInfo_TransferRequest.Size(m)
}
func (m *TransferRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TransferRequest proto.InternalMessageInfo

type isTransferRequest_Source interface {
	isTransferRequest_Source()
}
type isTransferRequest_Dest interface {
	isTransferRequest_Dest()
}

type TransferRequest_SourceAccountNumber struct {
	SourceAccountNumber uint64 `protobuf:"varint,1,opt,name=source_account_number,json=sourceAccountNumber,proto3,oneof"`
}
type TransferRequest_ExternalSource struct {
	ExternalSource *TransferRequest_ExternalAccount `protobuf:"bytes,2,opt,name=external_source,json=externalSource,proto3,oneof"`
}
type TransferRequest_DestAccountNumber struct {
	DestAccountNumber uint64 `protobuf:"varint,3,opt,name=dest_account_number,json=destAccountNumber,proto3,oneof"`
}
type TransferRequest_ExternalDest struct {
	ExternalDest *TransferRequest_ExternalAccount `protobuf:"bytes,4,opt,name=external_dest,json=externalDest,proto3,oneof"`
}

func (*TransferRequest_SourceAccountNumber) isTransferRequest_Source() {}
func (*TransferRequest_ExternalSource) isTransferRequest_Source()      {}
func (*TransferRequest_DestAccountNumber) isTransferRequest_Dest()     {}
func (*TransferRequest_ExternalDest) isTransferRequest_Dest()          {}

func (m *TransferRequest) GetSource() isTransferRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}
func (m *TransferRequest) GetDest() isTransferRequest_Dest {
	if m != nil {
		return m.Dest
	}
	return nil
}

func (m *TransferRequest) GetSourceAccountNumber() uint64 {
	if x, ok := m.GetSource().(*TransferRequest_SourceAccountNumber); ok {
		return x.SourceAccountNumber
	}
	return 0
}

func (m *TransferRequest) GetExternalSource() *TransferRequest_ExternalAccount {
	if x, ok := m.GetSource().(*TransferRequest_ExternalSource); ok {
		return x.ExternalSource
	}
	return nil
}

func (m *TransferRequest) GetDestAccountNumber() uint64 {
	if x, ok := m.GetDest().(*TransferRequest_DestAccountNumber); ok {
		return x.DestAccountNumber
	}
	return 0
}

func (m *TransferRequest) GetExternalDest() *TransferRequest_ExternalAccount {
	if x, ok := m.GetDest().(*TransferRequest_ExternalDest); ok {
		return x.ExternalDest
	}
	return nil
}

func (m *TransferRequest) GetAmountCents() int32 {
	if m != nil {
		return m.AmountCents
	}
	return 0
}

func (m *TransferRequest) GetDesc() string {
	if m != nil {
		return m.Desc
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TransferRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TransferRequest_OneofMarshaler, _TransferRequest_OneofUnmarshaler, _TransferRequest_OneofSizer, []interface{}{
		(*TransferRequest_SourceAccountNumber)(nil),
		(*TransferRequest_ExternalSource)(nil),
		(*TransferRequest_DestAccountNumber)(nil),
		(*TransferRequest_ExternalDest)(nil),
	}
}

func _TransferRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TransferRequest)
	// source
	switch x := m.Source.(type) {
	case *TransferRequest_SourceAccountNumber:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.SourceAccountNumber))
	case *TransferRequest_ExternalSource:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExternalSource); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TransferRequest.Source has unexpected type %T", x)
	}
	// dest
	switch x := m.Dest.(type) {
	case *TransferRequest_DestAccountNumber:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.DestAccountNumber))
	case *TransferRequest_ExternalDest:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExternalDest); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TransferRequest.Dest has unexpected type %T", x)
	}
	return nil
}

func _TransferRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TransferRequest)
	switch tag {
	case 1: // source.source_account_number
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Source = &TransferRequest_SourceAccountNumber{x}
		return true, err
	case 2: // source.external_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransferRequest_ExternalAccount)
		err := b.DecodeMessage(msg)
		m.Source = &TransferRequest_ExternalSource{msg}
		return true, err
	case 3: // dest.dest_account_number
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Dest = &TransferRequest_DestAccountNumber{x}
		return true, err
	case 4: // dest.external_dest
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransferRequest_ExternalAccount)
		err := b.DecodeMessage(msg)
		m.Dest = &TransferRequest_ExternalDest{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TransferRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TransferRequest)
	// source
	switch x := m.Source.(type) {
	case *TransferRequest_SourceAccountNumber:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.SourceAccountNumber))
	case *TransferRequest_ExternalSource:
		s := proto.Size(x.ExternalSource)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// dest
	switch x := m.Dest.(type) {
	case *TransferRequest_DestAccountNumber:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.DestAccountNumber))
	case *TransferRequest_ExternalDest:
		s := proto.Size(x.ExternalDest)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type TransferRequest_ExternalAccount struct {
	AchRoutingNumber     uint64   `protobuf:"varint,1,opt,name=ach_routing_number,json=achRoutingNumber,proto3" json:"ach_routing_number,omitempty"`
	AchAccountNumber     uint64   `protobuf:"varint,2,opt,name=ach_account_number,json=achAccountNumber,proto3" json:"ach_account_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransferRequest_ExternalAccount) Reset()         { *m = TransferRequest_ExternalAccount{} }
func (m *TransferRequest_ExternalAccount) String() string { return proto.CompactTextString(m) }
func (*TransferRequest_ExternalAccount) ProtoMessage()    {}
func (*TransferRequest_ExternalAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{9, 0}
}
func (m *TransferRequest_ExternalAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransferRequest_ExternalAccount.Unmarshal(m, b)
}
func (m *TransferRequest_ExternalAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransferRequest_ExternalAccount.Marshal(b, m, deterministic)
}
func (dst *TransferRequest_ExternalAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferRequest_ExternalAccount.Merge(dst, src)
}
func (m *TransferRequest_ExternalAccount) XXX_Size() int {
	return xxx_messageInfo_TransferRequest_ExternalAccount.Size(m)
}
func (m *TransferRequest_ExternalAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferRequest_ExternalAccount.DiscardUnknown(m)
}

var xxx_messageInfo_TransferRequest_ExternalAccount proto.InternalMessageInfo

func (m *TransferRequest_ExternalAccount) GetAchRoutingNumber() uint64 {
	if m != nil {
		return m.AchRoutingNumber
	}
	return 0
}

func (m *TransferRequest_ExternalAccount) GetAchAccountNumber() uint64 {
	if m != nil {
		return m.AchAccountNumber
	}
	return 0
}

type TransferResponse struct {
	SrcAccountNumber     uint64   `protobuf:"varint,1,opt,name=src_account_number,json=srcAccountNumber,proto3" json:"src_account_number,omitempty"`
	SrcBalanceCents      int32    `protobuf:"varint,2,opt,name=src_balance_cents,json=srcBalanceCents,proto3" json:"src_balance_cents,omitempty"`
	DestAccountNumber    uint64   `protobuf:"varint,3,opt,name=dest_account_number,json=destAccountNumber,proto3" json:"dest_account_number,omitempty"`
	DestBalanceCents     int32    `protobuf:"varint,4,opt,name=dest_balance_cents,json=destBalanceCents,proto3" json:"dest_balance_cents,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransferResponse) Reset()         { *m = TransferResponse{} }
func (m *TransferResponse) String() string { return proto.CompactTextString(m) }
func (*TransferResponse) ProtoMessage()    {}
func (*TransferResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bank_485eb966c3eae5d1, []int{10}
}
func (m *TransferResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransferResponse.Unmarshal(m, b)
}
func (m *TransferResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransferResponse.Marshal(b, m, deterministic)
}
func (dst *TransferResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferResponse.Merge(dst, src)
}
func (m *TransferResponse) XXX_Size() int {
	return xxx_messageInfo_TransferResponse.Size(m)
}
func (m *TransferResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TransferResponse proto.InternalMessageInfo

func (m *TransferResponse) GetSrcAccountNumber() uint64 {
	if m != nil {
		return m.SrcAccountNumber
	}
	return 0
}

func (m *TransferResponse) GetSrcBalanceCents() int32 {
	if m != nil {
		return m.SrcBalanceCents
	}
	return 0
}

func (m *TransferResponse) GetDestAccountNumber() uint64 {
	if m != nil {
		return m.DestAccountNumber
	}
	return 0
}

func (m *TransferResponse) GetDestBalanceCents() int32 {
	if m != nil {
		return m.DestBalanceCents
	}
	return 0
}

func init() {
	proto.RegisterType((*OpenAccountRequest)(nil), "OpenAccountRequest")
	proto.RegisterType((*CloseAccountRequest)(nil), "CloseAccountRequest")
	proto.RegisterType((*GetAccountsResponse)(nil), "GetAccountsResponse")
	proto.RegisterType((*Account)(nil), "Account")
	proto.RegisterType((*GetTransactionsRequest)(nil), "GetTransactionsRequest")
	proto.RegisterType((*Transaction)(nil), "Transaction")
	proto.RegisterType((*DepositRequest)(nil), "DepositRequest")
	proto.RegisterType((*BalanceResponse)(nil), "BalanceResponse")
	proto.RegisterType((*WithdrawRequest)(nil), "WithdrawRequest")
	proto.RegisterType((*TransferRequest)(nil), "TransferRequest")
	proto.RegisterType((*TransferRequest_ExternalAccount)(nil), "TransferRequest.ExternalAccount")
	proto.RegisterType((*TransferResponse)(nil), "TransferResponse")
	proto.RegisterEnum("Account_Type", Account_Type_name, Account_Type_value)
	proto.RegisterEnum("DepositRequest_Source", DepositRequest_Source_name, DepositRequest_Source_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BankClient is the client API for Bank service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BankClient interface {
	// OpenAccount creates an account with the type and given initial deposit
	// as its balance.
	OpenAccount(ctx context.Context, in *OpenAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// CloseAccount closes the indicated account. An account can only be
	// closed if its balance is zero.
	CloseAccount(ctx context.Context, in *CloseAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetAccounts lists all accounts for the current customer.
	GetAccounts(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*GetAccountsResponse, error)
	// GetTransactions streams all transactions that match the given criteria.
	// If the given start date is not specified, transactions since beginning
	// of time are included. Similarly, if the given end date is not specified,
	// transactions all the way to the presnet are included.
	GetTransactions(ctx context.Context, in *GetTransactionsRequest, opts ...grpc.CallOption) (Bank_GetTransactionsClient, error)
	// Deposit increases the balance of an account by depositing funds into it.
	Deposit(ctx context.Context, in *DepositRequest, opts ...grpc.CallOption) (*BalanceResponse, error)
	// Withdraw decreases the balance of an account by withdrawing funds from it.
	Withdraw(ctx context.Context, in *WithdrawRequest, opts ...grpc.CallOption) (*BalanceResponse, error)
	// Transfer moves money from one account to another. The source and destination
	// accounts can be with this bank (e.g. "local" account numbers) or can be
	// external accounts, identified by their ACH routing and account numbers.
	Transfer(ctx context.Context, in *TransferRequest, opts ...grpc.CallOption) (*TransferResponse, error)
}

type bankClient struct {
	cc *grpc.ClientConn
}

func NewBankClient(cc *grpc.ClientConn) BankClient {
	return &bankClient{cc}
}

func (c *bankClient) OpenAccount(ctx context.Context, in *OpenAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/Bank/OpenAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bankClient) CloseAccount(ctx context.Context, in *CloseAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/Bank/CloseAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bankClient) GetAccounts(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*GetAccountsResponse, error) {
	out := new(GetAccountsResponse)
	err := c.cc.Invoke(ctx, "/Bank/GetAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bankClient) GetTransactions(ctx context.Context, in *GetTransactionsRequest, opts ...grpc.CallOption) (Bank_GetTransactionsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Bank_serviceDesc.Streams[0], "/Bank/GetTransactions", opts...)
	if err != nil {
		return nil, err
	}
	x := &bankGetTransactionsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Bank_GetTransactionsClient interface {
	Recv() (*Transaction, error)
	grpc.ClientStream
}

type bankGetTransactionsClient struct {
	grpc.ClientStream
}

func (x *bankGetTransactionsClient) Recv() (*Transaction, error) {
	m := new(Transaction)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bankClient) Deposit(ctx context.Context, in *DepositRequest, opts ...grpc.CallOption) (*BalanceResponse, error) {
	out := new(BalanceResponse)
	err := c.cc.Invoke(ctx, "/Bank/Deposit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bankClient) Withdraw(ctx context.Context, in *WithdrawRequest, opts ...grpc.CallOption) (*BalanceResponse, error) {
	out := new(BalanceResponse)
	err := c.cc.Invoke(ctx, "/Bank/Withdraw", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bankClient) Transfer(ctx context.Context, in *TransferRequest, opts ...grpc.CallOption) (*TransferResponse, error) {
	out := new(TransferResponse)
	err := c.cc.Invoke(ctx, "/Bank/Transfer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BankServer is the server API for Bank service.
type BankServer interface {
	// OpenAccount creates an account with the type and given initial deposit
	// as its balance.
	OpenAccount(context.Context, *OpenAccountRequest) (*Account, error)
	// CloseAccount closes the indicated account. An account can only be
	// closed if its balance is zero.
	CloseAccount(context.Context, *CloseAccountRequest) (*empty.Empty, error)
	// GetAccounts lists all accounts for the current customer.
	GetAccounts(context.Context, *empty.Empty) (*GetAccountsResponse, error)
	// GetTransactions streams all transactions that match the given criteria.
	// If the given start date is not specified, transactions since beginning
	// of time are included. Similarly, if the given end date is not specified,
	// transactions all the way to the presnet are included.
	GetTransactions(*GetTransactionsRequest, Bank_GetTransactionsServer) error
	// Deposit increases the balance of an account by depositing funds into it.
	Deposit(context.Context, *DepositRequest) (*BalanceResponse, error)
	// Withdraw decreases the balance of an account by withdrawing funds from it.
	Withdraw(context.Context, *WithdrawRequest) (*BalanceResponse, error)
	// Transfer moves money from one account to another. The source and destination
	// accounts can be with this bank (e.g. "local" account numbers) or can be
	// external accounts, identified by their ACH routing and account numbers.
	Transfer(context.Context, *TransferRequest) (*TransferResponse, error)
}

func RegisterBankServer(s *grpc.Server, srv BankServer) {
	s.RegisterService(&_Bank_serviceDesc, srv)
}

func _Bank_OpenAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BankServer).OpenAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/Bank/OpenAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BankServer).OpenAccount(ctx, req.(*OpenAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bank_CloseAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BankServer).CloseAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/Bank/CloseAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BankServer).CloseAccount(ctx, req.(*CloseAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bank_GetAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BankServer).GetAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/Bank/GetAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BankServer).GetAccounts(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bank_GetTransactions_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTransactionsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BankServer).GetTransactions(m, &bankGetTransactionsServer{stream})
}

type Bank_GetTransactionsServer interface {
	Send(*Transaction) error
	grpc.ServerStream
}

type bankGetTransactionsServer struct {
	grpc.ServerStream
}

func (x *bankGetTransactionsServer) Send(m *Transaction) error {
	return x.ServerStream.SendMsg(m)
}

func _Bank_Deposit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DepositRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BankServer).Deposit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/Bank/Deposit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BankServer).Deposit(ctx, req.(*DepositRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bank_Withdraw_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WithdrawRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BankServer).Withdraw(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/Bank/Withdraw",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BankServer).Withdraw(ctx, req.(*WithdrawRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bank_Transfer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BankServer).Transfer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/Bank/Transfer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BankServer).Transfer(ctx, req.(*TransferRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Bank_serviceDesc = grpc.ServiceDesc{
	ServiceName: "Bank",
	HandlerType: (*BankServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "OpenAccount",
			Handler:    _Bank_OpenAccount_Handler,
		},
		{
			MethodName: "CloseAccount",
			Handler:    _Bank_CloseAccount_Handler,
		},
		{
			MethodName: "GetAccounts",
			Handler:    _Bank_GetAccounts_Handler,
		},
		{
			MethodName: "Deposit",
			Handler:    _Bank_Deposit_Handler,
		},
		{
			MethodName: "Withdraw",
			Handler:    _Bank_Withdraw_Handler,
		},
		{
			MethodName: "Transfer",
			Handler:    _Bank_Transfer_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetTransactions",
			Handler:       _Bank_GetTransactions_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "bank.proto",
}

func init() { proto.RegisterFile("bank.proto", fileDescriptor_bank_485eb966c3eae5d1) }

var fileDescriptor_bank_485eb966c3eae5d1 = []byte{
	// 913 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xdd, 0x6e, 0xe2, 0x46,
	0x18, 0x8d, 0xb1, 0x21, 0xe4, 0x83, 0xc0, 0x64, 0xd8, 0x4d, 0x23, 0x57, 0x55, 0xb3, 0x6e, 0x2b,
	0x45, 0x15, 0x9a, 0x44, 0xb4, 0x57, 0xdd, 0xed, 0x05, 0x10, 0x37, 0xa0, 0xec, 0x82, 0x3a, 0x61,
	0x1b, 0xb5, 0x52, 0x65, 0x19, 0x33, 0x9b, 0x58, 0x01, 0x9b, 0x78, 0x06, 0xb5, 0x79, 0x9a, 0xbe,
	0x47, 0x5f, 0xa0, 0x52, 0xdf, 0xa1, 0x97, 0x7d, 0x89, 0x5e, 0x55, 0x1e, 0x8f, 0x59, 0xe3, 0x78,
	0x57, 0xac, 0xb4, 0x77, 0x66, 0xce, 0x99, 0x39, 0xdf, 0xcf, 0x99, 0xf9, 0x00, 0x98, 0xba, 0xc1,
	0x1d, 0x59, 0x46, 0xa1, 0x08, 0xcd, 0x4f, 0x6f, 0xc2, 0xf0, 0x66, 0xce, 0x4e, 0xe5, 0xaf, 0xe9,
	0xea, 0xcd, 0x29, 0x5b, 0x2c, 0xc5, 0x83, 0x02, 0x3f, 0xcf, 0x83, 0xc2, 0x5f, 0x30, 0x2e, 0xdc,
	0xc5, 0x32, 0x21, 0x58, 0x77, 0x80, 0xc7, 0x4b, 0x16, 0x74, 0x3d, 0x2f, 0x5c, 0x05, 0x82, 0xb2,
	0xfb, 0x15, 0xe3, 0x02, 0x77, 0xe0, 0xa9, 0x1f, 0xf8, 0xc2, 0x77, 0xe7, 0xce, 0x8c, 0x2d, 0x43,
	0xee, 0x0b, 0xc7, 0x63, 0x81, 0xe0, 0x47, 0xda, 0xb1, 0x76, 0x52, 0xa6, 0x2d, 0x05, 0x9e, 0x27,
	0x58, 0x3f, 0x86, 0xf0, 0x33, 0x30, 0xc4, 0xc3, 0x92, 0x1d, 0x95, 0x8e, 0xb5, 0x93, 0x46, 0x67,
	0x9f, 0xa8, 0x23, 0xc9, 0xe4, 0x61, 0xc9, 0xa8, 0x84, 0xac, 0x17, 0xd0, 0xea, 0xcf, 0x43, 0xce,
	0x72, 0x6a, 0x5f, 0x41, 0xc3, 0x4d, 0x56, 0x9c, 0x60, 0xb5, 0x98, 0xb2, 0x48, 0xca, 0x18, 0x74,
	0x5f, 0xad, 0x8e, 0xe4, 0xa2, 0xf5, 0x1c, 0x5a, 0x17, 0x4c, 0xa8, 0xbd, 0x9c, 0x32, 0xbe, 0x0c,
	0x03, 0xce, 0xf0, 0x97, 0x50, 0x55, 0xbc, 0x38, 0x3c, 0xfd, 0xa4, 0xd6, 0xa9, 0xa6, 0xda, 0x74,
	0x8d, 0x58, 0xff, 0x6a, 0xb0, 0xab, 0x56, 0xb7, 0xd4, 0xdb, 0x22, 0x21, 0xfc, 0x05, 0xec, 0x4f,
	0xdd, 0xb9, 0x1b, 0x78, 0x4c, 0xd5, 0x47, 0x97, 0xf5, 0xa9, 0xab, 0x45, 0x59, 0x18, 0xeb, 0x0e,
	0x8c, 0x78, 0x0b, 0xae, 0xc1, 0xee, 0xeb, 0xd1, 0xe5, 0x68, 0x7c, 0x3d, 0x42, 0x3b, 0xb8, 0x0e,
	0xd5, 0xfe, 0xc0, 0xee, 0x5f, 0x0e, 0x47, 0x17, 0x48, 0xc3, 0x00, 0x95, 0xab, 0xee, 0x4f, 0xf1,
	0x77, 0x09, 0x23, 0xa8, 0xbf, 0x1a, 0x8f, 0xec, 0x9f, 0x9d, 0x57, 0x5d, 0x7a, 0x69, 0x4f, 0x90,
	0x8e, 0x31, 0x34, 0x5e, 0x0e, 0x47, 0xb6, 0x33, 0xfe, 0xc1, 0xe9, 0x53, 0xfb, 0x7c, 0x38, 0x41,
	0x06, 0xae, 0x82, 0xf1, 0x72, 0xdc, 0x1d, 0xa1, 0x72, 0x7c, 0x92, 0xfd, 0xe3, 0xeb, 0xe1, 0x64,
	0x68, 0x5f, 0xa1, 0x8a, 0xf5, 0x87, 0x06, 0x87, 0x17, 0x4c, 0x4c, 0x22, 0x37, 0xe0, 0xae, 0x27,
	0xfc, 0x30, 0xe0, 0x1f, 0x56, 0x66, 0x7c, 0x06, 0x65, 0x2e, 0xdc, 0x48, 0xc8, 0xbc, 0x6b, 0x1d,
	0x93, 0x24, 0x16, 0x22, 0xa9, 0x85, 0xc8, 0x24, 0xb5, 0x10, 0x4d, 0x88, 0xb8, 0x0d, 0x3a, 0x0b,
	0x66, 0x32, 0xf7, 0xf7, 0xf3, 0x63, 0x9a, 0xf5, 0xa7, 0x06, 0xb5, 0x4c, 0x78, 0xdb, 0x86, 0xf5,
	0x19, 0x00, 0x67, 0xf7, 0x29, 0xa5, 0x24, 0x29, 0x7b, 0x9c, 0xdd, 0x2b, 0x98, 0x80, 0x31, 0x73,
	0x05, 0xdb, 0x22, 0x08, 0xc9, 0xc3, 0xcf, 0xa0, 0xee, 0x2e, 0xa4, 0x68, 0xd2, 0x38, 0x43, 0x36,
	0xae, 0x96, 0xac, 0x25, 0x86, 0xc6, 0x60, 0xcc, 0x18, 0xf7, 0x8e, 0xca, 0xc7, 0xda, 0xc9, 0x1e,
	0x95, 0xdf, 0xd6, 0x3f, 0x1a, 0x34, 0x94, 0xeb, 0x3f, 0xb0, 0xac, 0x79, 0xc1, 0xd2, 0x63, 0x41,
	0x02, 0x15, 0x1e, 0xae, 0x22, 0x2f, 0xc9, 0xa2, 0xd1, 0x39, 0x24, 0x9b, 0x52, 0xe4, 0x4a, 0xa2,
	0x54, 0xb1, 0xd6, 0x01, 0x1a, 0x99, 0x00, 0xbf, 0x87, 0x4a, 0xc2, 0xda, 0xb4, 0x5b, 0x15, 0x8c,
	0x7e, 0xf7, 0x6a, 0x80, 0x34, 0xbc, 0x07, 0x65, 0x69, 0x3c, 0x54, 0xc2, 0xbb, 0xa0, 0x77, 0xfb,
	0x03, 0xa4, 0xc7, 0xe8, 0xf5, 0x90, 0xda, 0xc8, 0xb0, 0x7e, 0x85, 0x66, 0x2f, 0xf1, 0xee, 0xfa,
	0x7e, 0x6d, 0x99, 0xdf, 0xa3, 0xab, 0x50, 0x2a, 0xb8, 0x0a, 0x21, 0x34, 0xaf, 0x7d, 0x71, 0x3b,
	0x8b, 0xdc, 0xdf, 0x3e, 0x7e, 0xf9, 0xd2, 0x72, 0xe8, 0x99, 0x72, 0xfc, 0xa5, 0x43, 0x53, 0x9a,
	0xed, 0x0d, 0x8b, 0x52, 0xc5, 0x6f, 0xe1, 0x69, 0x52, 0x40, 0xa7, 0x48, 0x78, 0xb0, 0x43, 0x5b,
	0x09, 0xdc, 0xdd, 0x08, 0xe0, 0x12, 0x9a, 0xec, 0x77, 0xc1, 0xa2, 0xc0, 0x9d, 0x3b, 0xaa, 0x4b,
	0xc9, 0x05, 0x39, 0x26, 0x39, 0x01, 0x62, 0x2b, 0x9e, 0x3a, 0x60, 0xb0, 0x43, 0x1b, 0xe9, 0x56,
	0xd5, 0x9b, 0x33, 0x68, 0xcd, 0x18, 0x17, 0xf9, 0x00, 0x74, 0x19, 0x80, 0x46, 0x0f, 0x62, 0x70,
	0x53, 0xfe, 0x02, 0xf6, 0xd7, 0xf2, 0x31, 0x2a, 0x9b, 0xbe, 0x8d, 0xb8, 0x46, 0xeb, 0xe9, 0xc6,
	0xf3, 0x38, 0xfb, 0x7c, 0x21, 0xcb, 0xef, 0x2e, 0x64, 0xe5, 0x6d, 0x21, 0xcd, 0x05, 0x34, 0x73,
	0x27, 0xe3, 0x36, 0x60, 0xd7, 0xbb, 0x75, 0xa2, 0x70, 0x25, 0xfc, 0xe0, 0x66, 0xb3, 0x7b, 0xc8,
	0xf5, 0x6e, 0x69, 0x02, 0xa8, 0x04, 0x14, 0x3b, 0x97, 0x71, 0x69, 0xcd, 0xde, 0x48, 0xb7, 0x57,
	0x4d, 0xaf, 0x42, 0xaf, 0x22, 0x83, 0x11, 0xd6, 0xdf, 0x1a, 0xa0, 0xb7, 0xb9, 0x2a, 0x6f, 0xb6,
	0x01, 0xf3, 0xc8, 0x2b, 0xec, 0x23, 0x45, 0x3c, 0xf2, 0x36, 0x6b, 0xf8, 0x35, 0x1c, 0xc4, 0xec,
	0x22, 0x9b, 0x36, 0x79, 0xe4, 0xf5, 0x32, 0x4e, 0xc5, 0xe4, 0x3d, 0x1d, 0x2a, 0xea, 0x4f, 0x1b,
	0xb0, 0xe4, 0x6f, 0x1e, 0x9e, 0xbc, 0x2a, 0x28, 0x46, 0xb2, 0xa7, 0x77, 0xfe, 0x2b, 0x81, 0xd1,
	0x73, 0x83, 0x3b, 0xdc, 0x86, 0x5a, 0x66, 0xfc, 0xe2, 0x16, 0x79, 0x3c, 0x8c, 0xcd, 0xf5, 0x38,
	0xc3, 0x2f, 0xa0, 0x9e, 0x9d, 0x9f, 0xf8, 0x09, 0x29, 0x18, 0xa7, 0xe6, 0xe1, 0xa3, 0xc7, 0xcf,
	0x8e, 0xff, 0x11, 0xe0, 0xe7, 0x50, 0xcb, 0xcc, 0x4f, 0xfc, 0x0e, 0x9a, 0xf9, 0x84, 0x14, 0x4d,
	0xd9, 0xef, 0xa0, 0x99, 0x1b, 0x2b, 0xf8, 0x13, 0x52, 0x3c, 0x68, 0xcc, 0x3a, 0xc9, 0xac, 0x9e,
	0x69, 0xb8, 0x0d, 0xbb, 0xea, 0x21, 0xc3, 0xcd, 0xdc, 0x93, 0x66, 0x22, 0x92, 0x7f, 0x6f, 0x08,
	0x54, 0xd3, 0x37, 0x02, 0x23, 0x92, 0x7b, 0x2e, 0x0a, 0xf8, 0xa7, 0x50, 0x4d, 0x7d, 0x81, 0x51,
	0xfe, 0x3a, 0x98, 0x07, 0x24, 0x6f, 0x9a, 0x5e, 0xe5, 0x17, 0x63, 0xe1, 0xfa, 0xc1, 0xb4, 0x22,
	0x13, 0xff, 0xe6, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xac, 0x47, 0x1e, 0xdd, 0x4d, 0x09, 0x00,
	0x00,
}
