// Copyright 2020 The gRPC Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.14.0
// source: grpc/tls/provider/meshca/experimental/config.proto

// NOTE: This proto will very likely move to a different namespace and a
// different git repo in the future.

package meshca_experimental

import (
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Type of key to be embedded in CSRs sent to the MeshCA.
type GoogleMeshCaConfig_KeyType int32

const (
	GoogleMeshCaConfig_KEY_TYPE_UNKNOWN GoogleMeshCaConfig_KeyType = 0
	GoogleMeshCaConfig_KEY_TYPE_RSA     GoogleMeshCaConfig_KeyType = 1
)

// Enum value maps for GoogleMeshCaConfig_KeyType.
var (
	GoogleMeshCaConfig_KeyType_name = map[int32]string{
		0: "KEY_TYPE_UNKNOWN",
		1: "KEY_TYPE_RSA",
	}
	GoogleMeshCaConfig_KeyType_value = map[string]int32{
		"KEY_TYPE_UNKNOWN": 0,
		"KEY_TYPE_RSA":     1,
	}
)

func (x GoogleMeshCaConfig_KeyType) Enum() *GoogleMeshCaConfig_KeyType {
	p := new(GoogleMeshCaConfig_KeyType)
	*p = x
	return p
}

func (x GoogleMeshCaConfig_KeyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GoogleMeshCaConfig_KeyType) Descriptor() protoreflect.EnumDescriptor {
	return file_grpc_tls_provider_meshca_experimental_config_proto_enumTypes[0].Descriptor()
}

func (GoogleMeshCaConfig_KeyType) Type() protoreflect.EnumType {
	return &file_grpc_tls_provider_meshca_experimental_config_proto_enumTypes[0]
}

func (x GoogleMeshCaConfig_KeyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GoogleMeshCaConfig_KeyType.Descriptor instead.
func (GoogleMeshCaConfig_KeyType) EnumDescriptor() ([]byte, []int) {
	return file_grpc_tls_provider_meshca_experimental_config_proto_rawDescGZIP(), []int{0, 0}
}

// GoogleMeshCaConfig contains all configuration parameters required by the
// MeshCA CertificateProvider plugin implementation.
type GoogleMeshCaConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// GoogleMeshCA server endpoint to get CSRs signed via the *CreateCertificate*
	// unary call. This must have :ref:`api_type
	// <envoy_api_field_config.core.v3.ApiConfigSource.api_type>` :ref:`GRPC
	// <envoy_api_enum_value_config.core.v3.ApiConfigSource.ApiType.GRPC>`.
	// STS based call credentials need to be supplied in :ref:`call_credentials
	// <envoy_api_field_config.core.v3.GrpcService.GoogleGrpc.call_credentials>`.
	//
	// If :ref:`timeout envoy_api_field_config.core.v3.GrpcService.timeout` is
	// left unspecified, a default value of 10s will be used.
	Server *v3.ApiConfigSource `protobuf:"bytes,1,opt,name=server,proto3" json:"server,omitempty"`
	// Certificate lifetime to request in CSRs sent to the MeshCA.
	//
	// A default value of 24h will be used if left unspecified.
	CertificateLifetime *durationpb.Duration `protobuf:"bytes,2,opt,name=certificate_lifetime,json=certificateLifetime,proto3" json:"certificate_lifetime,omitempty"`
	// How long before certificate expiration should the certificate be renewed.
	//
	// A default value of 12h will be used if left unspecified.
	RenewalGracePeriod *durationpb.Duration `protobuf:"bytes,3,opt,name=renewal_grace_period,json=renewalGracePeriod,proto3" json:"renewal_grace_period,omitempty"`
	// Type of key.
	//
	// RSA keys will be used if left unspecified.
	KeyType GoogleMeshCaConfig_KeyType `protobuf:"varint,4,opt,name=key_type,json=keyType,proto3,enum=grpc.tls.provider.meshca.experimental.GoogleMeshCaConfig_KeyType" json:"key_type,omitempty"`
	// Size of the key in bits.
	//
	// 2048 bit keys will be used if left unspecified.
	KeySize uint32 `protobuf:"varint,5,opt,name=key_size,json=keySize,proto3" json:"key_size,omitempty"`
	// GCE location (region/zone) where the workload is located.
	//
	// GCE/GKE Metadata Server will be contacted if left unspecified.
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *GoogleMeshCaConfig) Reset() {
	*x = GoogleMeshCaConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_tls_provider_meshca_experimental_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleMeshCaConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleMeshCaConfig) ProtoMessage() {}

func (x *GoogleMeshCaConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_tls_provider_meshca_experimental_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleMeshCaConfig.ProtoReflect.Descriptor instead.
func (*GoogleMeshCaConfig) Descriptor() ([]byte, []int) {
	return file_grpc_tls_provider_meshca_experimental_config_proto_rawDescGZIP(), []int{0}
}

func (x *GoogleMeshCaConfig) GetServer() *v3.ApiConfigSource {
	if x != nil {
		return x.Server
	}
	return nil
}

func (x *GoogleMeshCaConfig) GetCertificateLifetime() *durationpb.Duration {
	if x != nil {
		return x.CertificateLifetime
	}
	return nil
}

func (x *GoogleMeshCaConfig) GetRenewalGracePeriod() *durationpb.Duration {
	if x != nil {
		return x.RenewalGracePeriod
	}
	return nil
}

func (x *GoogleMeshCaConfig) GetKeyType() GoogleMeshCaConfig_KeyType {
	if x != nil {
		return x.KeyType
	}
	return GoogleMeshCaConfig_KEY_TYPE_UNKNOWN
}

func (x *GoogleMeshCaConfig) GetKeySize() uint32 {
	if x != nil {
		return x.KeySize
	}
	return 0
}

func (x *GoogleMeshCaConfig) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

var File_grpc_tls_provider_meshca_experimental_config_proto protoreflect.FileDescriptor

var file_grpc_tls_provider_meshca_experimental_config_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x72, 0x70, 0x63, 0x2f, 0x74, 0x6c, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x2f, 0x6d, 0x65, 0x73, 0x68, 0x63, 0x61, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x74, 0x6c, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x63, 0x61, 0x2e, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x1a, 0x28, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76,
	0x33, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x03, 0x0a, 0x12, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x4d, 0x65, 0x73, 0x68, 0x43, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x06,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x70, 0x69, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x4c, 0x0a, 0x14, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x14, 0x72, 0x65, 0x6e,
	0x65, 0x77, 0x61, 0x6c, 0x5f, 0x67, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x12, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x47, 0x72, 0x61, 0x63, 0x65,
	0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x5c, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e,
	0x74, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x6d, 0x65, 0x73,
	0x68, 0x63, 0x61, 0x2e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x61, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6b, 0x65, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x31, 0x0a, 0x07, 0x4b,
	0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4b, 0x45, 0x59, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x4b, 0x45, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x53, 0x41, 0x10, 0x01, 0x42, 0x98,
	0x01, 0x0a, 0x28, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x74, 0x6c, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x63, 0x61, 0x2e, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x42, 0x11, 0x4d, 0x65, 0x73,
	0x68, 0x43, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x57, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x2f, 0x74, 0x6c, 0x73, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x2f, 0x6d, 0x65, 0x73, 0x68, 0x63, 0x61, 0x2f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x6d, 0x65, 0x73, 0x68, 0x63, 0x61, 0x5f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_grpc_tls_provider_meshca_experimental_config_proto_rawDescOnce sync.Once
	file_grpc_tls_provider_meshca_experimental_config_proto_rawDescData = file_grpc_tls_provider_meshca_experimental_config_proto_rawDesc
)

func file_grpc_tls_provider_meshca_experimental_config_proto_rawDescGZIP() []byte {
	file_grpc_tls_provider_meshca_experimental_config_proto_rawDescOnce.Do(func() {
		file_grpc_tls_provider_meshca_experimental_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_grpc_tls_provider_meshca_experimental_config_proto_rawDescData)
	})
	return file_grpc_tls_provider_meshca_experimental_config_proto_rawDescData
}

var file_grpc_tls_provider_meshca_experimental_config_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_grpc_tls_provider_meshca_experimental_config_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_grpc_tls_provider_meshca_experimental_config_proto_goTypes = []interface{}{
	(GoogleMeshCaConfig_KeyType)(0), // 0: grpc.tls.provider.meshca.experimental.GoogleMeshCaConfig.KeyType
	(*GoogleMeshCaConfig)(nil),      // 1: grpc.tls.provider.meshca.experimental.GoogleMeshCaConfig
	(*v3.ApiConfigSource)(nil),      // 2: envoy.config.core.v3.ApiConfigSource
	(*durationpb.Duration)(nil),     // 3: google.protobuf.Duration
}
var file_grpc_tls_provider_meshca_experimental_config_proto_depIdxs = []int32{
	2, // 0: grpc.tls.provider.meshca.experimental.GoogleMeshCaConfig.server:type_name -> envoy.config.core.v3.ApiConfigSource
	3, // 1: grpc.tls.provider.meshca.experimental.GoogleMeshCaConfig.certificate_lifetime:type_name -> google.protobuf.Duration
	3, // 2: grpc.tls.provider.meshca.experimental.GoogleMeshCaConfig.renewal_grace_period:type_name -> google.protobuf.Duration
	0, // 3: grpc.tls.provider.meshca.experimental.GoogleMeshCaConfig.key_type:type_name -> grpc.tls.provider.meshca.experimental.GoogleMeshCaConfig.KeyType
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_grpc_tls_provider_meshca_experimental_config_proto_init() }
func file_grpc_tls_provider_meshca_experimental_config_proto_init() {
	if File_grpc_tls_provider_meshca_experimental_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_grpc_tls_provider_meshca_experimental_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleMeshCaConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_grpc_tls_provider_meshca_experimental_config_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_grpc_tls_provider_meshca_experimental_config_proto_goTypes,
		DependencyIndexes: file_grpc_tls_provider_meshca_experimental_config_proto_depIdxs,
		EnumInfos:         file_grpc_tls_provider_meshca_experimental_config_proto_enumTypes,
		MessageInfos:      file_grpc_tls_provider_meshca_experimental_config_proto_msgTypes,
	}.Build()
	File_grpc_tls_provider_meshca_experimental_config_proto = out.File
	file_grpc_tls_provider_meshca_experimental_config_proto_rawDesc = nil
	file_grpc_tls_provider_meshca_experimental_config_proto_goTypes = nil
	file_grpc_tls_provider_meshca_experimental_config_proto_depIdxs = nil
}
