/**
 * This script will generate TypeScript type definitions and a RTKQ clients for the alerting k8s APIs.
 *
 * Run `yarn run codegen` from the "grafana-alerting" package to invoke this script.
 *
 * API clients will be placed in "src/grafana/api/<version>/api.gen.ts"
 */
import type { ConfigFile } from '@rtk-query/codegen-openapi';

// ℹ️ append versions here to generate additional API clients
const VERSIONS = ['v0alpha1'] as const;
const GROUP = 'notifications.alerting.grafana.app' as const;

type OutputFile = Omit<ConfigFile, 'outputFile'>;
type OutputFiles = Record<string, OutputFile>;

const outputFiles = VERSIONS.reduce<OutputFiles>((acc, version) => {
  // we append the version here so we export versioned API clients from this package without having to re-export with an alias
  const exportName = 'alertingAPI';

  // ℹ️ these snapshots are generated by running "go test pkg/tests/apis/openapi_test.go" and "scripts/process-specs.ts",
  // see the README in the "openapi_snapshots" directory
  const schemaFile = `../../../data/openapi/${GROUP}-${version}.json`;

  // ℹ️ make sure there is a API file in each versioned directory
  const apiFile = `../src/grafana/api/${version}/api.ts`;

  // output each api client into a versioned directory
  const outputPath = `../src/grafana/api/${version}/api.gen.ts`;

  acc[outputPath] = {
    exportName,
    schemaFile,
    apiFile,
    tag: true, // generate tags for cache invalidation
  } satisfies OutputFile;

  return acc;
}, {});

export default {
  // these are intentionally empty but will be set for each versioned config file
  exportName: '',
  schemaFile: '',
  apiFile: '',

  outputFiles,
} satisfies ConfigFile;
