package constants

var NamespaceMetricsMap = map[string][]string{
	"AWS/ACMPrivateCA":            {"CRLGenerated", "Failure", "MisconfiguredCRLBucket", "Success", "Time"},
	"AWS/AmazonMQ":                {"AckRate", "BurstBalance", "ChannelCount", "ConfirmRate", "ConnectionCount", "ConsumerCount", "CpuCreditBalance", "CpuUtilization", "CurrentConnectionsCount", "DequeueCount", "DispatchCount", "EnqueueCount", "EnqueueTime", "EstablishedConnectionsCount", "ExchangeCount", "ExpiredCount", "HeapUsage", "InactiveDurableTopicSubscribersCount", "InFlightCount", "JobSchedulerStorePercentUsage", "JournalFilesForFastRecovery", "JournalFilesForFullRecovery", "MemoryUsage", "MessageCount", "MessageReadyCount", "MessageUnacknowledgedCount", "NetworkIn", "NetworkOut", "OpenTransactionCount", "ProducerCount", "PublishRate", "QueueCount", "QueueSize", "RabbitMQDiskFree", "RabbitMQDiskFreeLimit", "RabbitMQFdUsed", "RabbitMQMemLimit", "RabbitMQMemUsed", "ReceiveCount", "StorePercentUsage", "SystemCpuUtilization", "TempPercentUsage", "TotalConsumerCount", "TotalDequeueCount", "TotalEnqueueCount", "TotalMessageCount", "TotalProducerCount", "VolumeReadOps", "VolumeWriteOps"},
	"AWS/ApiGateway":              {"4xx", "4XXError", "5xx", "5XXError", "CacheHitCount", "CacheMissCount", "ClientError", "Count", "ConnectCount", "DataProcessed", "ExecutionError", "IntegrationError", "IntegrationLatency", "Latency", "MessageCount"},
	"AWS/AppFlow":                 {"FlowExecutionsStarted", "FlowExecutionsFailed", "FlowExecutionsSucceeded", "FlowExecutionTime", "FlowExecutionRecordsProcessed"},
	"AWS/AppRunner":               {"2xxStatusResponses", "4xxStatusResponses", "5xxStatusResponses", "ActiveInstances", "CPUUtilization", "MemoryUtilization", "Requests", "RequestLatency"},
	"AWS/AppStream":               {"ActualCapacity", "AvailableCapacity", "CapacityUtilization", "DesiredCapacity", "InUseCapacity", "InsufficientCapacityError", "PendingCapacity", "RunningCapacity"},
	"AWS/AppSync":                 {"4XXError", "5XXError", "Latency", "ActiveConnections", "ActiveSubscriptions", "ConnectClientError", "ConnectionDuration", "ConnectServerError", "ConnectSuccess", "DisconnectClientError", "DisconnectServerError", "DisconnectSuccess", "PublishDataMessageClientError", "PublishDataMessageServerError", "PublishDataMessageSize", "PublishDataMessageSuccess", "SubscribeClientError", "SubscribeServerError", "SubscribeSuccess", "UnsubscribeClientError", "UnsubscribeServerError", "UnsubscribeSuccess"},
	"AWS/ApplicationELB":          {"ActiveConnectionCount", "ClientTLSNegotiationErrorCount", "ConsumedLCUs", "DesyncMitigationMode_NonCompliant_Request_Count", "DroppedInvalidHeaderRequestCount", "ELBAuthError", "ELBAuthFailure", "ELBAuthLatency", "ELBAuthRefreshTokenSuccess", "ELBAuthSuccess", "ELBAuthUserClaimsSizeExceeded", "ForwardedInvalidHeaderRequestCount", "GrpcRequestCount", "HTTPCode_ELB_3XX_Count", "HTTPCode_ELB_4XX_Count", "HTTPCode_ELB_5XX_Count", "HTTPCode_ELB_500_Count", "HTTPCode_ELB_502_Count", "HTTPCode_ELB_503_Count", "HTTPCode_ELB_504_Count", "HTTPCode_Target_2XX_Count", "HTTPCode_Target_3XX_Count", "HTTPCode_Target_4XX_Count", "HTTPCode_Target_5XX_Count", "HTTP_Fixed_Response_Count", "HTTP_Redirect_Count", "HTTP_Redirect_Url_Limit_Exceeded_Count", "HealthyHostCount", "IPv6ProcessedBytes", "IPv6RequestCount", "LambdaInternalError", "LambdaTargetProcessedBytes", "LambdaUserError", "NewConnectionCount", "NonStickyRequestCount", "ProcessedBytes", "RejectedConnectionCount", "RequestCount", "RequestCountPerTarget", "RuleEvaluations", "StandardProcessedBytes", "TargetConnectionErrorCount", "TargetResponseTime", "TargetTLSNegotiationErrorCount", "UnHealthyHostCount"},
	"AWS/Athena":                  {"EngineExecutionTime", "QueryPlanningTime", "QueryQueueTime", "ProcessedBytes", "ServiceProcessingTime", "TotalExecutionTime"},
	"AWS/AutoScaling":             {"GroupDesiredCapacity", "GroupInServiceInstances", "GroupMaxSize", "GroupMinSize", "GroupPendingInstances", "GroupStandbyInstances", "GroupTerminatingInstances", "GroupTotalInstances"},
	"AWS/Billing":                 {"EstimatedCharges"},
	"AWS/Backup":                  {"NumberOfBackupJobsAborted", "NumberOfBackupJobsCompleted", "NumberOfBackupJobsCreated", "NumberOfBackupJobsExpired", "NumberOfBackupJobsFailed", "NumberOfBackupJobsPending", "NumberOfBackupJobsRunning", "NumberOfCopyJobsCompleted", "NumberOfCopyJobsCreated", "NumberOfCopyJobsFailed", "NumberOfCopyJobsRunning", "NumberOfRecoveryPointsCold", "NumberOfRecoveryPointsCompleted", "NumberOfRecoveryPointsDeleting", "NumberOfRecoveryPointsExpired", "NumberOfRecoveryPointsPartial", "NumberOfRestoreJobsCompleted", "NumberOfRestoreJobsFailed", "NumberOfRestoreJobsPending", "NumberOfRestoreJobsRunning"},
	"AWS/CertificateManager":      {"DaysToExpiry"},
	"AWS/Chatbot":                 {"EventsThrottled", "EventsProcessed", "MessageDeliverySuccess", "MessageDeliveryFailure", "UnsupportedEvents"},
	"AWS/ClientVPN":               {"ActiveConnectionsCount", "AuthenticationFailures", "CrlDaysToExpiry", "EgressBytes", "EgressPackets", "IngressBytes", "IngressPackets", "SelfServicePortalClientConfigurationDownloads"},
	"AWS/CloudFront":              {"4xxErrorRate", "5xxErrorRate", "BytesDownloaded", "BytesUploaded", "Requests", "TotalErrorRate", "CacheHitRate", "OriginLatency", "401ErrorRate", "403ErrorRate", "404ErrorRate", "502ErrorRate", "503ErrorRate", "504ErrorRate", "LambdaExecutionError", "LambdaValidationError", "LambdaLimitExceededErrors", "FunctionInvocations", "FunctionValidationErrors", "FunctionExecutionErrors", "FunctionComputeUtilization", "FunctionThrottles"},
	"AWS/CloudHSM":                {"HsmKeysSessionOccupied", "HsmKeysTokenOccupied", "HsmSessionCount", "HsmSslCtxsOccupied", "HsmTemperature", "HsmUnhealthy", "HsmUsersAvailable", "HsmUsersMax", "InterfaceEth2OctetsInput", "InterfaceEth2OctetsOutput"},
	"AWS/CloudSearch":             {"IndexUtilization", "Partitions", "SearchableDocuments", "SuccessfulRequests"},
	"AWS/CodeBuild":               {"BuildDuration", "Builds", "DownloadSourceDuration", "Duration", "FailedBuilds", "FinalizingDuration", "InstallDuration", "PostBuildDuration", "PreBuildDuration", "ProvisioningDuration", "QueuedDuration", "SubmittedDuration", "SucceededBuilds", "UploadArtifactsDuration"},
	"AWS/CodeGuruProfiler":        {"Recommendations"},
	"AWS/Cognito":                 {"AccountTakeOverRisk", "CompromisedCredentialsRisk", "NoRisk", "OverrideBlock", "Risk", "SignUpSuccesses", "SignUpThrottles", "SignInSuccesses", "SignInThrottles", "TokenRefreshSuccesses", "TokenRefreshThrottles", "FederationSuccesses", "FederationThrottles"},
	"AWS/Connect":                 {"CallBackNotDialableNumber", "CallRecordingUploadError", "CallsBreachingConcurrencyQuota", "CallsPerInterval", "ConcurrentCalls", "ConcurrentCallsPercentage", "ContactFlowErrors", "ContactFlowFatalErrors", "LongestQueueWaitTime", "MisconfiguredPhoneNumbers", "MissedCalls", "PublicSigningKeyUsage", "QueueCapacityExceededError", "QueueSize", "ThrottledCalls", "ToInstancePacketLossRate"},
	"AWS/DataLifecycleManager":    {"ResourcesTargeted", "SnapshotsCreateStarted", "SnapshotsCreateCompleted", "SnapshotsCreateFailed", "SnapshotsSharedCompleted", "SnapshotsDeleteCompleted", "SnapshotsDeleteFailed", "SnapshotsCopiedRegionStarted", "SnapshotsCopiedRegionCompleted", "SnapshotsCopiedRegionFailed", "SnapshotsCopiedRegionDeleteCompleted", "SnapshotsCopiedRegionDeleteFailed", "ImagesCreateStarted", "ImagesCreateCompleted", "ImagesCreateFailed", "ImagesDeregisterCompleted", "ImagesDeregisterFailed", "ImagesCopiedRegionStarted", "ImagesCopiedRegionCompleted", "ImagesCopiedRegionFailed", "ImagesCopiedRegionDeregisterCompleted", "ImagesCopiedRegionDeregisteredFailed", "EnableImageDeprecationCompleted", "EnableImageDeprecationFailed", "EnableCopiedImageDeprecationCompleted", "EnableCopiedImageDeprecationFailed", "SnapshotsCopiedAccountStarted", "SnapshotsCopiedAccountCompleted", "SnapshotsCopiedAccountFailed", "SnapshotsCopiedAccountDeleteCompleted", "SnapshotsCopiedAccountDeleteFailed"},
	"AWS/DataSync":                {"BytesVerifiedSource", "BytesPreparedSource", "FilesVerifiedSource", "FilesPreparedSource", "BytesVerifiedDestination", "BytesPreparedDestination", "FilesVerifiedDestination", "FilesPreparedDestination", "FilesTransferred", "BytesTransferred", "BytesWritten"},
	"AWS/DDoSProtection":          {"DDoSDetected", "DDoSAttackBitsPerSecond", "DDoSAttackPacketsPerSecond", "DDoSAttackRequestsPerSecond", "VolumeBitsPerSecond", "VolumePacketsPerSecond"},
	"AWS/DMS":                     {"CDCChangesDiskSource", "CDCChangesDiskTarget", "CDCChangesMemorySource", "CDCChangesMemoryTarget", "CDCIncomingChanges", "CDCLatencySource", "CDCLatencyTarget", "CDCThroughputBandwidthSource", "CDCThroughputBandwidthTarget", "CDCThroughputRowsSource", "CDCThroughputRowsTarget", "CPUUtilization", "FreeStorageSpace", "FreeableMemory", "FullLoadThroughputBandwidthSource", "FullLoadThroughputBandwidthTarget", "FullLoadThroughputRowsSource", "FullLoadThroughputRowsTarget", "NetworkReceiveThroughput", "NetworkTransmitThroughput", "ReadIOPS", "ReadLatency", "ReadThroughput", "SwapUsage", "WriteIOPS", "WriteLatency", "WriteThroughput"},
	"AWS/DocDB":                   {"BackupRetentionPeriodStorageUsed", "BufferCacheHitRatio", "ChangeStreamLogSize", "CPUUtilization", "DatabaseConnections", "DBInstanceReplicaLag", "DBClusterReplicaLagMaximum", "DBClusterReplicaLagMinimum", "DiskQueueDepth", "EngineUptime", "FreeableMemory", "FreeLocalStorage", "NetworkReceiveThroughput", "NetworkThroughput", "NetworkTransmitThroughput", "ReadIOPS", "ReadLatency", "ReadThroughput", "SnapshotStorageUsed", "SwapUsage", "TotalBackupStorageBilled", "VolumeBytesUsed", "VolumeReadIOPs", "VolumeWriteIOPs", "WriteIOPS", "WriteLatency", "WriteThroughput"},
	"AWS/DX":                      {"ConnectionEncryptionState", "ConnectionBpsEgress", "ConnectionBpsIngress", "ConnectionErrorCount", "ConnectionCRCErrorCount", "ConnectionLightLevelRx", "ConnectionLightLevelTx", "ConnectionPpsEgress", "ConnectionPpsIngress", "ConnectionState", "VirtualInterfaceBpsEgress", "VirtualInterfaceBpsIngress", "VirtualInterfacePpsEgress", "VirtualInterfacePpsIngress"},
	"AWS/DAX":                     {"CPUUtilization", "NetworkPacketsIn", "NetworkPacketsOut", "GetItemRequestCount", "BatchGetItemRequestCount", "BatchWriteItemRequestCount", "DeleteItemRequestCount", "PutItemRequestCount", "UpdateItemRequestCount", "TransactWriteItemsCount", "TransactGetItemsCount", "ItemCacheHits", "ItemCacheMisses", "QueryCacheHits", "QueryCacheMisses", "ScanCacheHits", "ScanCacheMisses", "TotalRequestCount", "ErrorRequestCount", "FaultRequestCount", "FailedRequestCount", "QueryRequestCount", "ScanRequestCount", "ClientConnections", "EstimatedDbSize", "EvictedSize"},
	"AWS/DynamoDB":                {"AccountMaxReads", "AccountMaxTableLevelReads", "AccountMaxTableLevelWrites", "AccountMaxWrites", "AccountProvisionedReadCapacityUtilization", "AccountProvisionedWriteCapacityUtilization", "AgeOfOldestUnreplicatedRecord", "ConditionalCheckFailedRequests", "ConsumedChangeDataCaptureUnits", "ConsumedReadCapacityUnits", "ConsumedWriteCapacityUnits", "FailedToReplicateRecordCount", "MaxProvisionedTableReadCapacityUtilization", "MaxProvisionedTableWriteCapacityUtilization", "OnlineIndexConsumedWriteCapacity", "OnlineIndexPercentageProgress", "OnlineIndexThrottleEvents", "PendingReplicationCount", "ProvisionedReadCapacityUnits", "ProvisionedWriteCapacityUnits", "ReadThrottleEvents", "ReplicationLatency", "ReturnedBytes", "ReturnedItemCount", "ReturnedRecordsCount", "SuccessfulRequestLatency", "SystemErrors", "TimeToLiveDeletedItemCount", "ThrottledPutRecordCount", "ThrottledRequests", "TransactionConflict", "UserErrors", "WriteThrottleEvents"},
	"AWS/EBS":                     {"BurstBalance", "VolumeConsumedReadWriteOps", "VolumeIdleTime", "VolumeQueueLength", "VolumeReadBytes", "VolumeReadOps", "VolumeThroughputPercentage", "VolumeTotalReadTime", "VolumeTotalWriteTime", "VolumeWriteBytes", "VolumeWriteOps"},
	"AWS/EC2":                     {"CPUCreditBalance", "CPUCreditUsage", "CPUSurplusCreditBalance", "CPUSurplusCreditsCharged", "CPUUtilization", "DiskReadBytes", "DiskReadOps", "DiskWriteBytes", "DiskWriteOps", "EBSByteBalance%", "EBSIOBalance%", "EBSReadBytes", "EBSReadOps", "EBSWriteBytes", "EBSWriteOps", "MetadataNoToken", "NetworkIn", "NetworkOut", "NetworkPacketsIn", "NetworkPacketsOut", "StatusCheckFailed", "StatusCheckFailed_Instance", "StatusCheckFailed_System"},
	"AWS/ElasticGPUs":             {"GPUConnectivityCheckFailed", "GPUHealthCheckFailed", "GPUMemoryUtilization"},
	"AWS/EC2/API":                 {"ClientErrors", "RequestLimitExceeded", "ServerErrors", "SuccessfulCalls"},
	"AWS/EC2CapacityReservations": {"AvailableInstanceCount", "InstanceUtilization", "TotalInstanceCount", "UsedInstanceCount"},
	"AWS/EC2Spot":                 {"AvailableInstancePoolsCount", "BidsSubmittedForCapacity", "EligibleInstancePoolCount", "FulfilledCapacity", "MaxPercentCapacityAllocation", "PendingCapacity", "PercentCapacityAllocation", "TargetCapacity", "TerminatingCapacity"},
	"AWS/ECS":                     {"CPUReservation", "CPUUtilization", "GPUReservation", "MemoryReservation", "MemoryUtilization"},
	"AWS/EFS":                     {"BurstCreditBalance", "ClientConnections", "DataReadIOBytes", "DataWriteIOBytes", "MetadataIOBytes", "PercentIOLimit", "PermittedThroughput", "TotalIOBytes", "StorageBytes", "MeteredIOBytes"},
	"AWS/ELB":                     {"BackendConnectionErrors", "EstimatedALBActiveConnectionCount", "EstimatedALBConsumedLCUs", "EstimatedALBNewConnectionCount", "EstimatedProcessedBytes", "HTTPCode_Backend_2XX", "HTTPCode_Backend_3XX", "HTTPCode_Backend_4XX", "HTTPCode_Backend_5XX", "HTTPCode_ELB_4XX", "HTTPCode_ELB_5XX", "HealthyHostCount", "Latency", "RequestCount", "SpilloverCount", "SurgeQueueLength", "UnHealthyHostCount"},
	"AWS/ES": {
		"2xx, 3xx, 4xx, 5xx",
		"ADAnomalyDetectorsIndexStatus.red",
		"ADAnomalyDetectorsIndexStatusIndexExists",
		"ADAnomalyResultsIndexStatus.red",
		"ADAnomalyResultsIndexStatusIndexExists",
		"ADExecuteFailureCount",
		"ADExecuteRequestCount",
		"ADHCExecuteFailureCount",
		"ADHCExecuteRequestCount",
		"ADModelsCheckpointIndexStatus.red",
		"ADModelsCheckpointIndexStatusIndexExists",
		"ADPluginUnhealthy",
		"AlertingDegraded",
		"AlertingIndexExists",
		"AlertingIndexStatus.green",
		"AlertingIndexStatus.red",
		"AlertingIndexStatus.yellow",
		"AlertingNodesNotOnSchedule",
		"AlertingNodesOnSchedule",
		"AlertingScheduledJobEnabled",
		"AsynchronousSearchCancelled",
		"AsynchronousSearchCompletionRate",
		"AsynchronousSearchFailureRate",
		"AsynchronousSearchInitializedRate",
		"AsynchronousSearchMaxRunningTime",
		"AsynchronousSearchPersistFailedRate",
		"AsynchronousSearchPersistRate",
		"AsynchronousSearchRejected",
		"AsynchronousSearchRunningCurrent",
		"AsynchronousSearchStoreHealth",
		"AsynchronousSearchStoreSize",
		"AsynchronousSearchStoredResponseCount",
		"AsynchronousSearchSubmissionRate",
		"AutomatedSnapshotFailure",
		"CPUCreditBalance",
		"CPUUtilization",
		"ClusterIndexWritesBlocked",
		"ClusterStatus.green",
		"ClusterStatus.red",
		"ClusterStatus.yellow",
		"ClusterUsedSpace",
		"ColdStorageSpaceUtilization",
		"ColdToWarmMigrationFailureCount",
		"ColdToWarmMigrationLatency",
		"ColdToWarmMigrationQueueSize",
		"ColdToWarmMigrationSuccessCount",
		"CoordinatingWriteRejected",
		"CrossClusterInboundRequests",
		"CrossClusterOutboundConnections",
		"CrossClusterOutboundRequests",
		"DeletedDocuments",
		"DiskQueueDepth",
		"FollowerCheckPoint",
		"FreeStorageSpace",
		"HotStorageSpaceUtilization",
		"HotToWarmMigrationFailureCount",
		"HotToWarmMigrationForceMergeLatency",
		"HotToWarmMigrationProcessingLatency",
		"HotToWarmMigrationQueueSize",
		"HotToWarmMigrationSnapshotLatency",
		"HotToWarmMigrationSuccessCount",
		"HotToWarmMigrationSuccessLatency",
		"IndexingLatency",
		"IndexingRate",
		"InvalidHostHeaderRequests",
		"JVMGCOldCollectionCount",
		"JVMGCOldCollectionTime",
		"JVMGCYoungCollectionCount",
		"JVMGCYoungCollectionTime",
		"JVMMemoryPressure",
		"KMSKeyError",
		"KMSKeyInaccessible",
		"KNNCacheCapacityReached",
		"KNNCircuitBreakerTriggered",
		"KNNEvictionCount",
		"KNNGraphIndexErrors",
		"KNNGraphIndexRequests",
		"KNNGraphMemoryUsage",
		"KNNGraphQueryErrors",
		"KNNGraphQueryRequests",
		"KNNHitCount",
		"KNNLoadExceptionCount",
		"KNNLoadSuccessCount",
		"KNNMissCount",
		"KNNQueryRequests",
		"KNNScriptCompilationErrors",
		"KNNScriptCompilations",
		"KNNScriptQueryErrors",
		"KNNScriptQueryRequests",
		"KNNTotalLoadTime",
		"KibanaReportingFailedRequestSysErrCount",
		"KibanaReportingFailedRequestUserErrCount",
		"KibanaReportingRequestCount",
		"KibanaReportingSuccessCount",
		"LTRFeatureMemoryUsageInBytes",
		"LTRFeaturesetMemoryUsageInBytes",
		"LTRMemoryUsage",
		"LTRModelMemoryUsageInBytes",
		"LTRRequestErrorCount",
		"LTRRequestTotalCount",
		"LTRStatus.red",
		"LeaderCheckPoint",
		"MasterCPUCreditBalance",
		"MasterCPUUtilization",
		"MasterFreeStorageSpace",
		"MasterJVMMemoryPressure",
		"MasterReachableFromNode",
		"MasterSysMemoryUtilization",
		"Nodes",
		"OpenSearchDashboardsConcurrentConnections",
		"OpenSearchDashboardsHealthyNode",
		"OpenSearchDashboardsHealthyNodes",
		"OpenSearchDashboardsHeapTotal",
		"OpenSearchDashboardsHeapUsed",
		"OpenSearchDashboardsHeapUtilization",
		"OpenSearchDashboardsOS1MinuteLoad",
		"OpenSearchDashboardsRequestTotal",
		"OpenSearchDashboardsResponseTimesMaxInMillis",
		"OpenSearchRequests",
		"PPLFailedRequestCountByCusErr",
		"PPLFailedRequestCountBySysErr",
		"PPLRequestCount",
		"PrimaryWriteRejected",
		"ReadIOPS",
		"ReadLatency",
		"ReadThroughput",
		"ReplicaWriteRejected",
		"ReplicationRate",
		"SQLDefaultCursorRequestCount",
		"SQLFailedRequestCountByCusErr",
		"SQLFailedRequestCountBySysErr",
		"SQLRequestCount",
		"SQLUnhealthy",
		"SearchLatency",
		"SearchRate",
		"SearchableDocuments",
		"SegmentCount",
		"Shards.active",
		"Shards.activePrimary",
		"Shards.delayedUnassigned",
		"Shards.initializing",
		"Shards.relocating",
		"Shards.unassigned",
		"SysMemoryUtilization",
		"ThreadpoolBulkQueue",
		"ThreadpoolBulkRejected",
		"ThreadpoolBulkThreads",
		"ThreadpoolForce_mergeQueue",
		"ThreadpoolForce_mergeRejected",
		"ThreadpoolForce_mergeThreads",
		"ThreadpoolIndexQueue",
		"ThreadpoolIndexRejected",
		"ThreadpoolIndexThreads",
		"ThreadpoolSearchQueue",
		"ThreadpoolSearchRejected",
		"ThreadpoolSearchThreads",
		"ThreadpoolWriteQueue",
		"ThreadpoolWriteRejected",
		"ThreadpoolWriteThreads",
		"Threadpoolsql-workerQueue",
		"Threadpoolsql-workerRejected",
		"Threadpoolsql-workerThreads",
		"WarmCPUUtilization",
		"WarmFreeStorageSpace",
		"WarmJVMGCOldCollectionCount",
		"WarmJVMGCYoungCollectionCount",
		"WarmJVMGCYoungCollectionTime",
		"WarmJVMMemoryPressure",
		"WarmSearchLatency",
		"WarmSearchRate",
		"WarmSearchableDocuments",
		"WarmStorageSpaceUtilization",
		"WarmSysMemoryUtilization",
		"WarmThreadpoolSearchQueue",
		"WarmThreadpoolSearchRejected",
		"WarmThreadpoolSearchThreads",
		"WarmToColdMigrationFailureCount",
		"WarmToColdMigrationLatency",
		"WarmToColdMigrationQueueSize",
		"WarmToColdMigrationSuccessCount",
		"WarmToHotMigrationQueueSize",
		"WriteIOPS",
		"WriteLatency",
		"WriteThroughput",
	},
	"AWS/ElastiCache": {
		"ActiveDefragHits",
		"AuthenticationFailures",
		"BytesReadIntoMemcached",
		"BytesUsedForCache",
		"BytesUsedForCacheItems",
		"BytesUsedForHash",
		"BytesReadFromDisk",
		"BytesWrittenToDisk",
		"BytesWrittenOutFromMemcached",
		"CPUUtilization",
		"CPUCreditBalance",
		"CPUCreditUsage",
		"CacheHitRate",
		"CacheHits",
		"CacheMisses",
		"CasBadval",
		"CasHits",
		"CasMisses",
		"CmdConfigGet",
		"CmdConfigSet",
		"CmdFlush",
		"CmdGet",
		"CmdSet",
		"CmdTouch",
		"CommandAuthorizationFailures",
		"CurrConfig",
		"CurrConnections",
		"CurrItems",
		"CurrVolatileItems",
		"DatabaseMemoryUsagePercentage",
		"DatabaseMemoryUsageCountedForEvictPercentage",
		"DB0AverageTTL",
		"DecrHits",
		"DecrMisses",
		"DeleteHits",
		"DeleteMisses",
		"EngineCPUUtilization",
		"EvalBasedCmds",
		"EvalBasedCmdsLatency",
		"EvictedUnfetched",
		"Evictions",
		"ExpiredUnfetched",
		"FreeableMemory",
		"GeoSpatialBasedCmds",
		"GeoSpatialBasedCmdsLatency",
		"GetHits",
		"GetMisses",
		"GetTypeCmds",
		"GetTypeCmdsLatency",
		"GlobalDatastoreReplicationLag",
		"IsMaster",
		"HashBasedCmds",
		"HashBasedCmdsLatency",
		"HyperLogLogBasedCmds",
		"HyperLogLogBasedCmdsLatency",
		"IsPrimary",
		"IncrHits",
		"IncrMisses",
		"KeyAuthorizationFailures",
		"KeyBasedCmds",
		"KeyBasedCmdsLatency",
		"KeysTracked",
		"ListBasedCmds",
		"ListBasedCmdsLatency",
		"MasterLinkHealthStatus",
		"MemoryFragmentationRatio",
		"NetworkBytesIn",
		"NetworkBytesOut",
		"NetworkPacketsIn",
		"NetworkPacketsOut",
		"NetworkBandwidthInAllowanceExceeded",
		"NetworkBandwidthOutAllowanceExceeded",
		"NetworkConntrackAllowanceExceeded",
		"NetworkLinkLocalAllowanceExceeded",
		"NetworkPacketsPerSecondAllowanceExceeded",
		"NewConnections",
		"NewItems",
		"NumItemsReadFromDisk",
		"NumItemsWrittenToDisk",
		"PrimaryLinkHealthStatus",
		"PubSubBasedCmds",
		"PubSubBasedCmdsLatency",
		"Reclaimed",
		"ReplicationBytes",
		"ReplicationLag",
		"SaveInProgress",
		"SetBasedCmds",
		"SetBasedCmdsLatency",
		"SetTypeCmds",
		"SetTypeCmdsLatency",
		"SlabsMoved",
		"SortedSetBasedCmds",
		"SortedSetBasedCmdsLatency",
		"StreamBasedCmds",
		"StreamBasedCmdsLatency",
		"StringBasedCmds",
		"StringBasedCmdsLatency",
		"SwapUsage",
		"TouchHits",
		"TouchMisses",
		"UnusedMemory",
	},
	"AWS/ElasticBeanstalk":     {"ApplicationLatencyP10", "ApplicationLatencyP50", "ApplicationLatencyP75", "ApplicationLatencyP85", "ApplicationLatencyP90", "ApplicationLatencyP95", "ApplicationLatencyP99", "ApplicationLatencyP99.9", "ApplicationRequests2xx", "ApplicationRequests3xx", "ApplicationRequests4xx", "ApplicationRequests5xx", "ApplicationRequestsTotal", "CPUIdle", "CPUIowait", "CPUIrq", "CPUNice", "CPUSoftirq", "CPUSystem", "CPUUser", "EnvironmentHealth", "InstanceHealth", "InstancesDegraded", "InstancesInfo", "InstancesNoData", "InstancesOk", "InstancesPending", "InstancesSevere", "InstancesUnknown", "InstancesWarning", "LoadAverage1min", "LoadAverage5min", "RootFilesystemUtil"},
	"AWS/ElasticInference":     {"AcceleratorHealthCheckFailed", "AcceleratorMemoryUsage", "ConnectivityCheckFailed"},
	"AWS/ElasticMapReduce":     {"AppsCompleted", "AppsFailed", "AppsKilled", "AppsPending", "AppsRunning", "AppsSubmitted", "BackupFailed", "CapacityRemainingGB", "Cluster Status", "ContainerAllocated", "ContainerPending", "ContainerPendingRatio", "ContainerReserved", "CoreNodesPending", "CoreNodesRunning", "CorruptBlocks", "DfsPendingReplicationBlocks", "HBase", "HDFSBytesRead", "HDFSBytesWritten", "HDFSUtilization", "HbaseBackupFailed", "IO", "IsIdle", "JobsFailed", "JobsRunning", "LiveDataNodes", "LiveTaskTrackers", "MRActiveNodes", "MRDecommissionedNodes", "MRLostNodes", "MRRebootedNodes", "MRTotalNodes", "MRUnhealthyNodes", "Map/Reduce", "MapSlotsOpen", "MapTasksRemaining", "MapTasksRunning", "MemoryAllocatedMB", "MemoryAvailableMB", "MemoryReservedMB", "MemoryTotalMB", "MissingBlocks", "MostRecentBackupDuration", "Node Status", "PendingDeletionBlocks", "ReduceSlotsOpen", "ReduceTasksRemaining", "ReduceTasksRunning", "RemainingMapTasksPerSlot", "S3BytesRead", "S3BytesWritten", "TaskNodesPending", "TaskNodesRunning", "TimeSinceLastSuccessfulBackup", "TotalLoad", "UnderReplicatedBlocks", "YARNMemoryAvailablePercentage"},
	"AWS/ElasticTranscoder":    {"Billed Audio Output", "Billed HD Output", "Billed SD Output", "Errors", "Jobs Completed", "Jobs Errored", "Outputs per Job", "Standby Time", "Throttles"},
	"AWS/EventBridge/Pipes":    {"Concurrency", "Duration", "EnrichmentStageDuration", "EnrichmentStageFailed", "EventCount", "EventSize", "ExecutionFailed", "ExecutionPartiallyFailed", "ExecutionThrottled", "ExecutionTimeout", "Invocations", "TargetStageDuration", "TargetStageFailed", "TargetStagePartiallyFailed", "TargetStageSkipped"},
	"AWS/Events":               {"DeadLetterInvocations", "Events", "FailedInvocations", "IngestionToInvocationStartLatency", "Invocations", "InvocationsFailedToBeSentToDlq", "InvocationsSentToDlq", "MatchedEvents", "ThrottledRules", "TriggeredRules"},
	"AWS/Firehose":             {"ActivePartitionsLimit", "BackupToS3.Bytes", "BackupToS3.DataFreshness", "BackupToS3.Records", "BackupToS3.Success", "DataReadFromKinesisStream.Bytes", "DataReadFromKinesisStream.Records", "DeliveryToElasticsearch.Bytes", "DeliveryToElasticsearch.Records", "DeliveryToElasticsearch.Success", "DeliveryToRedshift.Bytes", "DeliveryToRedshift.Records", "DeliveryToRedshift.Success", "DeliveryToS3.Bytes", "DeliveryToS3.DataFreshness", "DeliveryToS3.ObjectCount", "DeliveryToS3.Records", "DeliveryToS3.Success", "DeliveryToSplunk.Bytes", "DeliveryToSplunk.DataFreshness", "DeliveryToSplunk.Records", "DeliveryToSplunk.Success", "DescribeDeliveryStream.Latency", "DescribeDeliveryStream.Requests", "ExecuteProcessing.Duration", "ExecuteProcessing.Success", "FailedConversion.Bytes", "FailedConversion.Records", "IncomingBytes", "IncomingRecords", "JQProcessing.Duration", "KinesisMillisBehindLatest", "ListDeliveryStreams.Latency", "ListDeliveryStreams.Requests", "PartitionCount", "PartitionCountExceeded", "PerPartitionThroughput", "PutRecord.Bytes", "PutRecord.Latency", "PutRecord.Requests", "PutRecordBatch.Bytes", "PutRecordBatch.Latency", "PutRecordBatch.Records", "PutRecordBatch.Requests", "SucceedConversion.Bytes", "SucceedConversion.Records", "SucceedProcessing.Bytes", "SucceedProcessing.Records", "ThrottledDescribeStream", "ThrottledGetRecords", "ThrottledGetShardIterator", "UpdateDeliveryStream.Latency", "UpdateDeliveryStream.Requests"},
	"AWS/FSx":                  {"ClientConnections", "CPUUtilization", "DataReadBytes", "DataReadOperations", "DataWriteBytes", "DataWriteOperations", "DeduplicationSavedStorage", "DiskIopsUtilization", "DiskReadBytes", "DiskReadOperations", "DiskThroughputBalance", "DiskThroughputUtilization", "DiskWriteBytes", "DiskWriteOperations", "FileServerDiskIopsBalance", "FileServerDiskIopsUtilization", "FileServerDiskThroughputBalance", "FileServerDiskThroughputUtilization", "FreeDataStorageCapacity", "FreeStorageCapacity", "MemoryUtilization", "MetadataOperations", "NetworkThroughputUtilization", "StorageCapacityUtilization"},
	"AWS/FraudDetector":        {"GetEventPrediction", "GetEventPrediction4xxError", "GetEventPrediction5xxError", "GetEventPredictionLatency", "ModelInvocation", "ModelInvocationError", "ModelInvocationLatency", "OutcomeReturned", "Prediction", "PredictionError", "PredictionLatency", "RuleEvaluateError", "RuleEvaluateFalse", "RuleEvaluateTrue", "RuleNotEvaluated", "VariableDefaultReturned", "VariableUsed"},
	"AWS/GameLift":             {"ActivatingGameSessions", "ActiveGameSessions", "ActiveInstances", "ActiveServerProcesses", "AvailableGameSessions", "AverageWaitTime", "CurrentPlayerSessions", "CurrentTickets", "DesiredInstances", "FirstChoiceNotViable", "FirstChoiceOutOfCapacity", "GameSessionInterruptions", "HealthyServerProcesses", "IdleInstances", "InstanceInterruptions", "LowestLatencyPlacement", "LowestPricePlacement", "MatchAcceptancesTimedOut", "MatchesAccepted", "MatchesCreated", "MatchesPlaced", "MatchesRejected", "MaxInstances", "MinInstances", "PercentAvailableGameSessions", "PercentHealthyServerProcesses", "PercentIdleInstances", "Placement", "PlacementsCanceled", "PlacementsFailed", "PlacementsStarted", "PlacementsSucceeded", "PlacementsTimedOut", "PlayerSessionActivations", "PlayersStarted", "QueueDepth", "RuleEvaluationsFailed", "RuleEvaluationsPassed", "ServerProcessAbnormalTerminations", "ServerProcessActivations", "ServerProcessTerminations", "TicketsFailed", "TicketsStarted", "TicketsTimedOut", "TimeToMatch", "TimeToTicketSuccess"},
	"AWS/GlobalAccelerator":    {"NewFlowCount", "ProcessedBytesIn", "ProcessedBytesOut", "HealthyEndpointCount", "UnhealthyEndpointCount"},
	"AWS/Glue":                 {"glue.driver.BlockManager.disk.diskSpaceUsed_MB", "glue.driver.ExecutorAllocationManager.executors.numberAllExecutors", "glue.driver.ExecutorAllocationManager.executors.numberMaxNeededExecutors", "glue.driver.aggregate.bytesRead", "glue.driver.aggregate.elapsedTime", "glue.driver.aggregate.numCompletedStages", "glue.driver.aggregate.numCompletedTasks", "glue.driver.aggregate.numFailedTasks", "glue.driver.aggregate.numKilledTasks", "glue.driver.aggregate.recordsRead", "glue.driver.aggregate.shuffleBytesWritten", "glue.driver.aggregate.shuffleLocalBytesRead", "glue.driver.jvm.heap.usage  glue.executorId.jvm.heap.usage  glue.ALL.jvm.heap.usage", "glue.driver.jvm.heap.used  glue.executorId.jvm.heap.used  glue.ALL.jvm.heap.used", "glue.driver.s3.filesystem.read_bytes  glue.executorId.s3.filesystem.read_bytes  glue.ALL.s3.filesystem.read_bytes", "glue.driver.s3.filesystem.write_bytes  glue.executorId.s3.filesystem.write_bytes  glue.ALL.s3.filesystem.write_bytes", "glue.driver.system.cpuSystemLoad  glue.executorId.system.cpuSystemLoad  glue.ALL.system.cpuSystemLoad"},
	"AWS/GroundStation":        {"BitErrorRate", "BlockErrorRate", "ReceivedPower", "Es/N0"},
	"AWS/Inspector":            {"TotalAssessmentRunFindings", "TotalAssessmentRuns", "TotalHealthyAgents", "TotalMatchingAgents"},
	"AWS/IVS":                  {"ConcurrentViews", "ConcurrentStreams", "IngestAudioBitrate", "IngestFramerate", "IngestVideoBitrate", "KeyframeInterval", "LiveDeliveredTime", "LiveInputTime", "RecordedTime"},
	"AWS/IoT":                  {"CanceledJobExecutionCount", "CanceledJobExecutionTotalCount", "ClientError", "Connect.AuthError", "Connect.ClientError", "Connect.ServerError", "Connect.Success", "Connect.Throttle", "DeleteThingShadow.Accepted", "FailedJobExecutionCount", "FailedJobExecutionTotalCount", "Failure", "GetThingShadow.Accepted", "InProgressJobExecutionCount", "InProgressJobExecutionTotalCount", "NonCompliantResources", "NumLogBatchesFailedToPublishThrottled", "NumLogEventsFailedToPublishThrottled", "ParseError", "Ping.Success", "PublishIn.AuthError", "PublishIn.ClientError", "PublishIn.ServerError", "PublishIn.Success", "PublishIn.Throttle", "PublishOut.AuthError", "PublishOut.ClientError", "PublishOut.Success", "QueuedJobExecutionCount", "QueuedJobExecutionTotalCount", "RejectedJobExecutionCount", "RejectedJobExecutionTotalCount", "RemovedJobExecutionCount", "RemovedJobExecutionTotalCount", "ResourcesEvaluated", "RuleMessageThrottled", "RuleNotFound", "RulesExecuted", "ServerError", "Subscribe.AuthError", "Subscribe.ClientError", "Subscribe.ServerError", "Subscribe.Success", "Subscribe.Throttle", "SuccededJobExecutionCount", "SuccededJobExecutionTotalCount", "Success", "TopicMatch", "Unsubscribe.ClientError", "Unsubscribe.ServerError", "Unsubscribe.Success", "Unsubscribe.Throttle", "UpdateThingShadow.Accepted", "Violations", "ViolationsCleared", "ViolationsInvalidated"},
	"AWS/IoTAnalytics":         {"ActionExecution", "ActivityExecutionError", "IncomingMessages"},
	"AWS/IoTSiteWise":          {"Gateway.Heartbeat", "Gateway.PublishSuccessCount", "Gateway.PublishFailureCount", "Gateway.ProcessFailureCount", "OPCUACollector.Heartbeat", "OPCUACollector.ActiveDataStreamCount", "OPCUACollector.IncomingValuesCount"},
	"AWS/KMS":                  {"SecondsUntilKeyMaterialExpiration"},
	"AWS/Kafka":                {"ActiveControllerCount", "BytesInPerSec", "BytesOutPerSec", "CpuIdle", "CpuSystem", "CpuUser", "EstimatedMaxTimeLag", "EstimatedTimeLag", "FetchConsumerLocalTimeMsMean", "FetchConsumerRequestQueueTimeMsMean", "FetchConsumerResponseQueueTimeMsMean", "FetchConsumerResponseSendTimeMsMean", "FetchConsumerTotalTimeMsMean", "FetchFollowerLocalTimeMsMean", "FetchFollowerRequestQueueTimeMsMean", "FetchFollowerResponseQueueTimeMsMean", "FetchFollowerResponseSendTimeMsMean", "FetchFollowerTotalTimeMsMean", "FetchMessageConversionsPerSec", "FetchThrottleByteRate", "FetchThrottleQueueSize", "FetchThrottleTime", "GlobalPartitionCount", "GlobalTopicCount", "KafkaAppLogsDiskUsed", "KafkaDataLogsDiskUsed", "LeaderCount", "MaxOffsetLag", "MemoryBuffered", "MemoryCached", "MemoryFree", "MemoryUsed", "MessagesInPerSec", "NetworkProcessorAvgIdlePercent", "NetworkRxDropped", "NetworkRxErrors", "NetworkRxPackets", "NetworkTxDropped", "NetworkTxErrors", "NetworkTxPackets", "OfflinePartitionsCount", "PartitionCount", "ProduceLocalTimeMsMean", "ProduceMessageConversionsPerSec", "ProduceMessageConversionsTimeMsMean", "ProduceRequestQueueTimeMsMean", "ProduceResponseQueueTimeMsMean", "ProduceResponseSendTimeMsMean", "ProduceThrottleByteRate", "ProduceThrottleQueueSize", "ProduceThrottleTime", "ProduceTotalTimeMsMean", "ReplicationBytesInPerSec", "ReplicationBytesOutPerSec", "RequestBytesMean", "RequestExemptFromThrottleTime", "RequestHandlerAvgIdlePercent", "RequestThrottleQueueSize", "RequestThrottleTime", "RequestTime", "RootDiskUsed", "SumOffsetLag", "SwapFree", "SwapUsed", "OffsetLag", "UnderMinIsrPartitionCount", "UnderReplicatedPartitions", "ZooKeeperRequestLatencyMsMean", "ZooKeeperSessionState"},
	"AWS/Kinesis":              {"GetRecords.Bytes", "GetRecords.IteratorAge", "GetRecords.IteratorAgeMilliseconds", "GetRecords.Latency", "GetRecords.Records", "GetRecords.Success", "IncomingBytes", "IncomingRecords", "IteratorAgeMilliseconds", "OutgoingBytes", "OutgoingRecords", "PutRecord.Bytes", "PutRecord.Latency", "PutRecord.Success", "PutRecords.Bytes", "PutRecords.Latency", "PutRecords.Records", "PutRecords.Success", "ReadProvisionedThroughputExceeded", "SubscribeToShard.RateExceeded", "SubscribeToShard.Success", "SubscribeToShardEvent.Bytes", "SubscribeToShardEvent.MillisBehindLatest", "SubscribeToShardEvent.Records", "SubscribeToShardEvent.Success", "WriteProvisionedThroughputExceeded"},
	"AWS/KinesisAnalytics":     {"Bytes", "InputProcessing.DroppedRecords", "InputProcessing.Duration", "InputProcessing.OkBytes", "InputProcessing.OkRecords", "InputProcessing.ProcessingFailedRecords", "InputProcessing.Success", "KPUs", "LambdaDelivery.DeliveryFailedRecords", "LambdaDelivery.Duration", "LambdaDelivery.OkRecords", "MillisBehindLatest", "Records", "Success"},
	"AWS/KinesisVideo":         {"GetHLSMasterPlaylist.Latency", "GetHLSMasterPlaylist.Requests", "GetHLSMasterPlaylist.Success", "GetHLSMediaPlaylist.Latency", "GetHLSMediaPlaylist.Requests", "GetHLSMediaPlaylist.Success", "GetHLSStreamingSessionURL.Latency", "GetHLSStreamingSessionURL.Requests", "GetHLSStreamingSessionURL.Success", "GetMP4InitFragment.Latency", "GetMP4InitFragment.Requests", "GetMP4InitFragment.Success", "GetMP4MediaFragment.Latency", "GetMP4MediaFragment.OutgoingBytes", "GetMP4MediaFragment.Requests", "GetMP4MediaFragment.Success", "GetMedia.ConnectionErrors", "GetMedia.MillisBehindNow", "GetMedia.OutgoingBytes", "GetMedia.OutgoingFragments", "GetMedia.OutgoingFrames", "GetMedia.Requests", "GetMedia.Success", "GetMediaForFragmentList.OutgoingBytes", "GetMediaForFragmentList.OutgoingFragments", "GetMediaForFragmentList.OutgoingFrames", "GetMediaForFragmentList.Requests", "GetMediaForFragmentList.Success", "GetTSFragment.Latency", "GetTSFragment.OutgoingBytes", "GetTSFragment.Requests", "GetTSFragment.Success", "ListFragments.Latency", "PutMedia.ActiveConnections", "PutMedia.BufferingAckLatency", "PutMedia.ConnectionErrors", "PutMedia.ErrorAckCount", "PutMedia.FragmentIngestionLatency", "PutMedia.FragmentPersistLatency", "PutMedia.IncomingBytes", "PutMedia.IncomingFragments", "PutMedia.IncomingFrames", "PutMedia.Latency", "PutMedia.PersistedAckLatency", "PutMedia.ReceivedAckLatency", "PutMedia.Requests", "PutMedia.Success"},
	"AWS/Lambda":               {"ConcurrentExecutions", "DeadLetterErrors", "DestinationDeliveryFailures", "Duration", "Errors", "Invocations", "IteratorAge", "OffsetLag", "PostRuntimeExtensionsDuration", "ProvisionedConcurrencyInvocations", "ProvisionedConcurrencyUtilization", "ProvisionedConcurrentExecutions", "Throttles", "ProvisionedConcurrencySpilloverInvocations", "UnreservedConcurrentExecutions"},
	"AWS/Lex":                  {"BotChannelAuthErrors", "BotChannelConfigurationErrors", "BotChannelInboundThrottledEvents", "BotChannelOutboundThrottledEvents", "BotChannelRequestCount", "BotChannelResponseCardErrors", "BotChannelSystemErrors", "MissedUtteranceCount", "RuntimeInvalidLambdaResponses", "RuntimeLambdaErrors", "RuntimePollyErrors", "RuntimeRequestCount", "RuntimeSucessfulRequestLatency", "RuntimeSystemErrors", "RuntimeThrottledEvents", "RuntimeUserErrors"},
	"AWS/Logs":                 {"DeliveryErrors", "DeliveryThrottling", "ForwardedBytes", "ForwardedLogEvents", "IncomingBytes", "IncomingLogEvents"},
	"AWS/LookoutMetrics":       {"ExecutionsStarted", "ExecutionsSucceeded", "ExecutionsFailed", "Delivered", "Undelivered"},
	"AWS/ML":                   {"PredictCount", "PredictFailureCount"},
	"AWS/MediaConnect":         {"ARQRecovered", "ARQRequests", "BitRate", "CATError", "CRCError", "Connected", "ConnectedOutputs", "ConnectionAttempts", "ConsecutiveDrops", "ConsecutiveNotRecovered", "ContinuityCounter", "Disconnections", "DroppedPackets", "EgressBridgeBitRate", "EgressBridgeCATError", "EgressBridgeCRCError", "EgressBridgeContinuityCounter", "EgressBridgeDroppedPackets", "EgressBridgeFailoverSwitches", "EgressBridgeMergeActive", "EgressBridgeNotRecoveredPackets", "EgressBridgePATError", "EgressBridgePCRAccuracyError", "EgressBridgePCRError", "EgressBridgePIDError", "EgressBridgePMTError", "EgressBridgePTSError", "EgressBridgePacketLossPercent", "EgressBridgeRecoveredPackets", "EgressBridgeSourceBitRate", "EgressBridgeSourceCATError", "EgressBridgeSourceCRCError", "EgressBridgeSourceContinuityCounter", "EgressBridgeSourceDroppedPackets", "EgressBridgeSourceMergeActive", "EgressBridgeSourceMergeLatency", "EgressBridgeSourceNotRecoveredPackets", "EgressBridgeSourcePATError", "EgressBridgeSourcePCRAccuracyError", "EgressBridgeSourcePCRError", "EgressBridgeSourcePIDError", "EgressBridgeSourcePMTError", "EgressBridgeSourcePTSError", "EgressBridgeSourcePacketLossPercent", "EgressBridgeSourceRecoveredPackets", "EgressBridgeSourceTSByteError", "EgressBridgeSourceTSSyncLoss", "EgressBridgeSourceTotalPackets", "EgressBridgeSourceTransportError", "EgressBridgeTSByteError", "EgressBridgeTSSyncLoss", "EgressBridgeTotalPackets", "EgressBridgeTransportError", "FailoverSwitches", "IngressBridgeBitRate", "IngressBridgeCATError", "IngressBridgeCRCError", "IngressBridgeContinuityCounter", "IngressBridgeDroppedPackets", "IngressBridgeFailoverSwitches", "IngressBridgeMergeActive", "IngressBridgeNotRecoveredPackets", "IngressBridgePATError", "IngressBridgePCRAccuracyError", "IngressBridgePCRError", "IngressBridgePIDError", "IngressBridgePMTError", "IngressBridgePTSError", "IngressBridgePacketLossPercent", "IngressBridgeRecoveredPackets", "IngressBridgeSourceARQRecovered", "IngressBridgeSourceARQRequests", "IngressBridgeSourceBitRate", "IngressBridgeSourceCATError", "IngressBridgeSourceCRCError", "IngressBridgeSourceContinuityCounter", "IngressBridgeSourceDroppedPackets", "IngressBridgeSourceFECPackets", "IngressBridgeSourceFECRecovered", "IngressBridgeSourceMergeActive", "IngressBridgeSourceMergeLatency", "IngressBridgeSourceNotRecoveredPackets", "IngressBridgeSourceOverflowPackets", "IngressBridgeSourcePATError", "IngressBridgeSourcePCRAccuracyError", "IngressBridgeSourcePCRError", "IngressBridgeSourcePIDError", "IngressBridgeSourcePMTError", "IngressBridgeSourcePTSError", "IngressBridgeSourcePacketLossPercent", "IngressBridgeSourceRecoveredPackets", "IngressBridgeSourceRoundTripTime", "IngressBridgeSourceTotalPackets", "IngressBridgeSourceTSByteError", "IngressBridgeSourceTSSyncLoss", "IngressBridgeSourceTransportError", "IngressBridgeTSByteError", "IngressBridgeTSSyncLoss", "IngressBridgeTotalPackets", "IngressBridgeTransportError", "Jitter", "Latency", "MaintenanceCanceled", "MaintenanceFailed", "MaintenanceRescheduled", "MaintenanceScheduled", "MaintenanceStarted", "MaintenanceSucceeded", "MergeActive", "MergeLatency", "NotRecoveredPackets", "OutputConnected", "OutputDisconnections", "OutputDroppedPayloads", "OutputLatePayloads", "OutputTotalBytes", "OutputTotalPayloads", "OverflowPackets", "PATError", "PCRAccuracyError", "PCRError", "PIDError", "PMTError", "PTSError", "PacketLossPercent", "RecoveredPackets", "RoundTripTime", "SourceARQRecovered", "SourceARQRequests", "SourceBitRate", "SourceCATError", "SourceCRCError", "SourceConnected", "SourceContinuityCounter", "SourceDisconnections", "SourceDroppedPackets", "SourceDroppedPayloads", "SourceFECPackets", "SourceFECRecovered", "SourceLatePayloads", "SourceMergeActive", "SourceMergeLatency", "SourceMergeStatusWarnMismatch", "SourceMergeStatusWarnSolo", "SourceMissingPackets", "SourceNotRecoveredPackets", "SourceOverflowPackets", "SourcePATError", "SourcePCRAccuracyError", "SourcePCRError", "SourcePIDError", "SourcePMTError", "SourcePTSError", "SourcePacketLossPercent", "SourceRecoveredPackets", "SourceRoundTripTime", "SourceSelected", "SourceTSByteError", "SourceTSSyncLoss", "SourceTotalBytes", "SourceTotalPackets", "SourceTotalPayloads", "SourceTransportError", "TSByteError", "TSSyncLoss", "TotalPackets", "TransportError", "Uptime"},
	"AWS/MediaConvert":         {"AudioOutputSeconds", "Errors", "HDOutputSeconds", "JobsCompletedCount", "JobsErroredCount", "SDOutputSeconds", "StandbyTime", "TranscodingTime", "UHDOutputSeconds"},
	"AWS/MediaPackage":         {"ActiveInput", "EgressBytes", "EgressRequestCount", "EgressResponseTime", "IngressBytes", "IngressResponseTime"},
	"AWS/MediaStore":           {"RequestCount", "4xxErrorCount", "5xxErrorCount", "BytesUploaded", "BytesDownloaded", "TotalTime", "TurnaroundTime"},
	"AWS/MediaTailor":          {"AdDecisionServer.Ads", "AdDecisionServer.Duration", "AdDecisionServer.Errors", "AdDecisionServer.FillRate", "AdDecisionServer.Timeouts", "AdNotReady", "Avails.Duration", "Avails.FillRate", "Avails.FilledDuration", "GetManifest.Errors", "Origin.Errors", "Origin.Timeouts"},
	"AWS/MemoryDB":             {"ActiveDefragHits", "AuthenticationFailures", "BytesUsedForMemoryDB", "CommandAuthorizationFailures", "CPUUtilization", "CurrConnections", "CurrItems", "DatabaseMemoryUsagePercentage", "DB0AverageTTL", "EngineCPUUtilization", "EvalBasedCmds", "Evictions", "FreeableMemory", "GeoSpatialBasedCmds", "GetTypeCmds", "HashBasedCmds", "HyperLogLogBasedCmds", "IsPrimary", "KeyAuthorizationFailures", "KeyBasedCmds", "KeyspaceHits", "KeyspaceMisses", "KeysTracked", "ListBasedCmds", "MaxReplicationThroughput", "MemoryFragmentationRatio", "NetworkBandwidthInAllowanceExceeded", "NetworkBandwidthOutAllowanceExceeded", "NetworkBytesIn", "NetworkBytesOut", "NetworkConntrackAllowanceExceeded", "NetworkPacketsIn", "NetworkPacketsOut", "NetworkPacketsPerSecondAllowanceExceeded", "NewConnections", "PrimaryLinkHealthStatus", "PubSubBasedCmds", "Reclaimed", "ReplicationBytes", "ReplicationDelayedWriteCommands", "ReplicationLag", "SetBasedCmds", "SetTypeCmds", "SortedSetBasedCmds", "StringBasedCmds", "StreamBasedCmds", "SwapUsage"},
	"AWS/NATGateway":           {"ActiveConnectionCount", "BytesInFromDestination", "BytesInFromSource", "BytesOutToDestination", "BytesOutToSource", "ConnectionAttemptCount", "ConnectionEstablishedCount", "ErrorPortAllocation", "IdleTimeoutCount", "PacketsDropCount", "PacketsInFromDestination", "PacketsInFromSource", "PacketsOutToDestination", "PacketsOutToSource"},
	"AWS/Neptune":              {"CPUUtilization", "ClusterReplicaLag", "ClusterReplicaLagMaximum", "ClusterReplicaLagMinimum", "EngineUptime", "FreeLocalStorage", "FreeableMemory", "GremlinErrors", "GremlinHttp1xx", "GremlinHttp2xx", "GremlinHttp4xx", "GremlinHttp5xx", "GremlinRequests", "GremlinRequestsPerSec", "GremlinWebSocketAvailableConnections", "GremlinWebSocketClientErrors", "GremlinWebSocketServerErrors", "GremlinWebSocketSuccess", "Http100", "Http101", "Http1xx", "Http200", "Http2xx", "Http400", "Http403", "Http405", "Http413", "Http429", "Http4xx", "Http500", "Http501", "Http5xx", "LoaderErrors", "LoaderRequests", "NetworkReceiveThroughput", "NetworkThroughput", "NetworkTransmitThroughput", "SparqlErrors", "SparqlHttp1xx", "SparqlHttp2xx", "SparqlHttp4xx", "SparqlHttp5xx", "SparqlRequests", "SparqlRequestsPerSec", "StatusErrors", "StatusRequests", "VolumeBytesUsed", "VolumeReadIOPs", "VolumeWriteIOPs"},
	"AWS/NetworkELB":           {"ActiveFlowCount", "ActiveFlowCount_TLS", "ClientTLSNegotiationErrorCount", "ConsumedLCUs", "HealthyHostCount", "NewFlowCount", "NewFlowCount_TLS", "ProcessedBytes", "ProcessedBytes_TLS", "TCP_Client_Reset_Count", "TCP_ELB_Reset_Count", "TCP_Target_Reset_Count", "TargetTLSNegotiationErrorCount", "UnHealthyHostCount"},
	"AWS/GatewayELB":           {"ActiveFlowCount", "ConsumedLCUs", "HealthyHostCount", "NewFlowCount", "ProcessedBytes", "UnHealthyHostCount"},
	"AWS/NetworkFirewall":      {"DroppedPackets", "Packets", "PassedPackets", "ReceivedPacketCount"},
	"AWS/OpsWorks":             {"cpu_idle", "cpu_nice", "cpu_steal", "cpu_system", "cpu_user", "cpu_waitio", "load_1", "load_15", "load_5", "memory_buffers", "memory_cached", "memory_free", "memory_swap", "memory_total", "memory_used", "procs"},
	"AWS/Polly":                {"2XXCount", "4XXCount", "5XXCount", "RequestCharacters", "ResponseLatency"},
	"AWS/PrivateLinkEndpoints": {"ActiveConnections", "BytesProcessed", "NewConnections", "PacketsDropped", "RstPacketsReceived"},
	"AWS/PrivateLinkServices":  {"ActiveConnections", "BytesProcessed", "EndpointsCount", "NewConnections", "RstPacketsReceived"},
	"AWS/Prometheus":           {"AlertManagerAlertsReceived", "AlertManagerNotificationsFailed", "AlertManagerNotificationsThrottled", "DiscardedSamples", "RuleEvaluations", "RuleEvaluationFailures", "RuleGroupIterationsMissed"},
	"AWS/RDS":                  {"ActiveTransactions", "AuroraBinlogReplicaLag", "AuroraGlobalDBDataTransferBytes", "AuroraGlobalDBReplicatedWriteIO", "AuroraGlobalDBReplicationLag", "AuroraReplicaLag", "AuroraReplicaLagMaximum", "AuroraReplicaLagMinimum", "AvailabilityPercentage", "BacktrackChangeRecordsCreationRate", "BacktrackChangeRecordsStored", "BacktrackWindowActual", "BacktrackWindowAlert", "BackupRetentionPeriodStorageUsed", "BinLogDiskUsage", "BlockedTransactions", "BufferCacheHitRatio", "BurstBalance", "CPUCreditBalance", "CPUCreditUsage", "CPUUtilization", "ClientConnections", "ClientConnectionsClosed", "ClientConnectionsNoTLS", "ClientConnectionsReceived", "ClientConnectionsSetupFailedAuth", "ClientConnectionsSetupSucceeded", "ClientConnectionsTLS", "CommitLatency", "CommitThroughput", "DDLLatency", "DDLThroughput", "DMLLatency", "DMLThroughput", "DatabaseConnectionRequests", "DatabaseConnectionRequestsWithTLS", "DatabaseConnections", "DatabaseConnectionsBorrowLatency", "DatabaseConnectionsCurrentlyBorrowed", "DatabaseConnectionsCurrentlyInTransaction", "DatabaseConnectionsCurrentlySessionPinned", "DatabaseConnectionsSetupFailed", "DatabaseConnectionsSetupSucceeded", "DatabaseConnectionsWithTLS", "Deadlocks", "DeleteLatency", "DeleteThroughput", "DiskQueueDepth", "EBSByteBalance%", "EBSIOBalance%", "EngineUptime", "FailedSQLServerAgentJobsCount", "FreeLocalStorage", "FreeStorageSpace", "FreeableMemory", "InsertLatency", "InsertThroughput", "LoginFailures", "MaxDatabaseConnectionsAllowed", "MaximumUsedTransactionIDs", "NetworkReceiveThroughput", "NetworkThroughput", "NetworkTransmitThroughput", "OldestReplicationSlotLag", "Queries", "QueryDatabaseResponseLatency", "QueryRequests", "QueryRequestsNoTLS", "QueryRequestsTLS", "QueryResponseLatency", "RDSToAuroraPostgreSQLReplicaLag", "ReadIOPS", "ReadLatency", "ReadThroughput", "ReplicaLag", "ReplicationSlotDiskUsage", "ResultSetCacheHitRatio", "SelectLatency", "SelectThroughput", "ServerlessDatabaseCapacity", "SnapshotStorageUsed", "SwapUsage", "TotalBackupStorageBilled", "TransactionLogsDiskUsage", "TransactionLogsGeneration", "UpdateLatency", "UpdateThroughput", "VolumeBytesUsed", "VolumeReadIOPs", "VolumeWriteIOPs", "WriteIOPS", "WriteLatency", "WriteThroughput"},
	"AWS/Redshift":             {"CommitQueueLength", "ConcurrencyScalingActiveClusters", "ConcurrencyScalingSeconds", "CPUUtilization", "DatabaseConnections", "HealthStatus", "MaintenanceMode", "MaxConfiguredConcurrencyScalingClusters", "NetworkReceiveThroughput", "NetworkTransmitThroughput", "PercentageDiskSpaceUsed", "QueriesCompletedPerSecond", "QueryDuration", "QueryRuntimeBreakdown", "ReadIOPS", "ReadLatency", "ReadThroughput", "TotalTableCount", "WLMQueueLength", "WLMQueueWaitTime", "WLMQueriesCompletedPerSecond", "WLMQueryDuration", "WLMRunningQueries", "WriteIOPS", "WriteLatency", "WriteThroughput", "SchemaQuota", "NumExceededSchemaQuotas", "StorageUsed", "PercentageQuotaUsed"},
	"AWS/Robomaker":            {"RealTimeFactor", "vCPU", "Memory", "SimulationUnit"},
	"AWS/Route53":              {"ChildHealthCheckHealthyCount", "ConnectionTime", "DNSQueries", "HealthCheckPercentageHealthy", "HealthCheckStatus", "SSLHandshakeTime", "TimeToFirstByte"},
	"AWS/Route53Resolver":      {"InboundQueryVolume", "OutboundQueryVolume", "OutboundQueryAggregatedVolume"},
	"AWS/S3":                   {"4xxErrors", "5xxErrors", "AllRequests", "BucketSizeBytes", "BytesDownloaded", "BytesPendingReplication", "BytesUploaded", "DeleteRequests", "FirstByteLatency", "GetRequests", "HeadRequests", "ListRequests", "NumberOfObjects", "OperationsFailedReplication", "OperationsPendingReplication", "PostRequests", "PutRequests", "ReplicationLatency", "SelectRequests", "SelectReturnedBytes", "SelectScannedBytes", "TotalRequestLatency"},
	"AWS/SDKMetrics":           {"CallCount", "ClientErrorCount", "EndToEndLatency", "ConnectionErrorCount", "ServerErrorCount", "ThrottleCount"},
	"AWS/ServiceCatalog":       {"ProvisionedProductLaunch"},
	"AWS/SES":                  {"Bounce", "Clicks", "Complaint", "Delivery", "Opens", "Reject", "Rendering Failures", "Reputation.BounceRate", "Reputation.ComplaintRate", "Send"},
	"AWS/SNS":                  {"NumberOfMessagesPublished", "NumberOfNotificationsDelivered", "NumberOfNotificationsFailed", "NumberOfNotificationsFilteredOut", "NumberOfNotificationsFilteredOut-InvalidAttributes", "NumberOfNotificationsFilteredOut-NoMessageAttributes", "PublishSize", "SMSMonthToDateSpentUSD", "SMSSuccessRate"},
	"AWS/SQS":                  {"ApproximateAgeOfOldestMessage", "ApproximateNumberOfMessagesDelayed", "ApproximateNumberOfMessagesNotVisible", "ApproximateNumberOfMessagesVisible", "NumberOfEmptyReceives", "NumberOfMessagesDeleted", "NumberOfMessagesReceived", "NumberOfMessagesSent", "SentMessageSize"},
	"AWS/SWF":                  {"ActivityTaskScheduleToCloseTime", "ActivityTaskScheduleToStartTime", "ActivityTaskStartToCloseTime", "ActivityTasksCanceled", "ActivityTasksCompleted", "ActivityTasksFailed", "ConsumedCapacity", "DecisionTaskScheduleToStartTime", "DecisionTaskStartToCloseTime", "DecisionTasksCompleted", "PendingTasks", "ProvisionedBucketSize", "ProvisionedRefillRate", "ScheduledActivityTasksTimedOutOnClose", "ScheduledActivityTasksTimedOutOnStart", "StartedActivityTasksTimedOutOnClose", "StartedActivityTasksTimedOutOnHeartbeat", "StartedDecisionTasksTimedOutOnClose", "ThrottledEvents", "WorkflowStartToCloseTime", "WorkflowsCanceled", "WorkflowsCompleted", "WorkflowsContinuedAsNew", "WorkflowsFailed", "WorkflowsTerminated", "WorkflowsTimedOut"},
	"AWS/SageMaker":            {"CPUUtilization", "DatasetObjectsAutoAnnotated", "DatasetObjectsHumanAnnotated", "DatasetObjectsLabelingFailed", "DiskUtilization", "GPUMemoryUtilization", "GPUUtilization", "Invocation4XXErrors", "Invocation5XXErrors", "Invocations", "InvocationsPerInstance", "JobsFailed", "JobsStopped", "JobsSucceeded", "MemoryUtilization", "ModelLatency", "OverheadLatency", "TotalDatasetObjectsLabeled"},
	"AWS/States":               {"ActivitiesFailed", "ActivitiesHeartbeatTimedOut", "ActivitiesScheduled", "ActivitiesStarted", "ActivitiesSucceeded", "ActivitiesTimedOut", "ActivityRunTime", "ActivityScheduleTime", "ActivityTime", "ConsumedCapacity", "ConsumedCapacity", "ExecutionThrottled", "ExecutionTime", "ExecutionsAborted", "ExecutionsFailed", "ExecutionsStarted", "ExecutionsSucceeded", "ExecutionsTimedOut", "ExpressExecutionBilledDuration", "ExpressExecutionBilledMemory", "ExpressExecutionMemory", "LambdaFunctionRunTime", "LambdaFunctionScheduleTime", "LambdaFunctionTime", "LambdaFunctionsFailed", "LambdaFunctionsScheduled", "LambdaFunctionsStarted", "LambdaFunctionsSucceeded", "LambdaFunctionsTimedOut", "ProvisionedBucketSize", "ProvisionedRefillRate", "ServiceIntegrationRunTime", "ServiceIntegrationScheduleTime", "ServiceIntegrationTime", "ServiceIntegrationsFailed", "ServiceIntegrationsScheduled", "ServiceIntegrationsStarted", "ServiceIntegrationsSucceeded", "ServiceIntegrationsTimedOut", "ThrottledEvents"},
	"AWS/StorageGateway":       {"CacheFree", "CacheHitPercent", "CachePercentDirty", "CachePercentUsed", "CacheUsed", "CloudBytesDownloaded", "CloudBytesUploaded", "CloudDownloadLatency", "QueuedWrites", "ReadBytes", "ReadTime", "TimeSinceLastRecoveryPoint", "TotalCacheSize", "UploadBufferFree", "UploadBufferPercentUsed", "UploadBufferUsed", "WorkingStorageFree", "WorkingStoragePercentUsed", "WorkingStorageUsed", "WriteBytes", "WriteTime"},
	"AWS/Textract":             {"ResponseTime", "ServerErrorCount", "SuccessfulRequestCount", "ThrottledCount", "UserErrorCount"},
	"AWS/Timestream":           {"SuccessfulRequestLatency", "SystemErrors", "UserErrors", "DataScannedBytes"},
	"AWS/ThingsGraph":          {"EventStoreQueueSize", "FlowExecutionTime", "FlowExecutionsFailed", "FlowExecutionsStarted", "FlowExecutionsSucceeded", "FlowStepExecutionTime", "FlowStepExecutionsFailed", "FlowStepExecutionsStarted", "FlowStepExecutionsSucceeded"},
	"AWS/TransitGateway":       {"BytesIn", "BytesOut", "PacketDropCountBlackhole", "PacketDropCountNoRoute", "PacketsIn", "PacketsOut"},
	"AWS/Transfer":             {"BytesIn", "BytesOut", "FilesIn", "FilesOut", "InboundMessage", "InboundFailedMessage", "OnPartialUploadExecutionsStarted", "OnPartialUploadExecutionsSuccess", "OnPartialUploadExecutionsFailed", "OnUploadExecutionsStarted", "OnUploadExecutionsSuccess", "OnUploadExecutionsFailed"},
	"AWS/Translate":            {"CharacterCount", "ResponseTime", "ServerErrorCount", "SuccessfulRequestCount", "ThrottledCount", "UserErrorCount"},
	"AWS/TrustedAdvisor":       {"GreenChecks", "RedChecks", "RedResources", "ServiceLimitUsage", "YellowChecks", "YellowResources"},
	"AWS/Usage":                {"CallCount", "ResourceCount"},
	"AWS/VPN":                  {"TunnelDataIn", "TunnelDataOut", "TunnelState"},
	"AWS/WAF":                  {"AllowedRequests", "BlockedRequests", "CountedRequests", "PassedRequests"},
	"AWS/WAFV2":                {"AllowedRequests", "BlockedRequests", "CountedRequests", "PassedRequests"},
	"AWS/WorkSpaces":           {"Available", "ConnectionAttempt", "ConnectionFailure", "ConnectionSuccess", "InSessionLatency", "Maintenance", "SessionDisconnect", "SessionLaunchTime", "Stopped", "Unhealthy", "UserConnected"},
	"ECS/ContainerInsights":    {"ContainerInstanceCount", "CpuUtilized", "CpuReserved", "DeploymentCount", "DesiredTaskCount", "MemoryUtilized", "MemoryReserved", "NetworkRxBytes", "NetworkTxBytes", "PendingTaskCount", "RunningTaskCount", "ServiceCount", "StorageReadBytes", "StorageWriteBytes", "TaskCount", "TaskSetCount", "instance_cpu_limit", "instance_cpu_reserved_capacity", "instance_cpu_usage_total", "instance_cpu_utilization", "instance_filesystem_utilization", "instance_memory_limit", "instance_memory_reserved_capacity", "instance_memory_utliization", "instance_memory_working_set", "instance_network_total_bytes", "instance_number_of_running_tasks"},
	"ContainerInsights":        {"cluster_failed_node_count", "cluster_node_count", "namespace_number_of_running_pods", "node_cpu_limit", "node_cpu_reserved_capacity", "node_cpu_usage_total", "node_cpu_utilization", "node_filesystem_utilization", "node_memory_limit", "node_memory_reserved_capacity", "node_memory_utilization", "node_memory_working_set", "node_network_total_bytes", "node_number_of_running_containers", "node_number_of_running_pods", "pod_cpu_reserved_capacity", "pod_cpu_utilization", "pod_cpu_utilization_over_pod_limit", "pod_memory_reserved_capacity", "pod_memory_utilization", "pod_memory_utilization_over_pod_limit", "pod_number_of_container_restarts", "pod_network_rx_bytes", "pod_network_tx_bytes", "service_number_of_running_pods"},
	"AWS/Rekognition":          {"DetectedFaceCount", "DetectedLabelCount", "ResponseTime", "ServerErrorCount", "SuccessfulRequestCount", "ThrottledCount", "UserErrorCount"},
	"AWS/Cassandra":            {"AccountMaxReads", "AccountMaxTableLevelReads", "AccountMaxTableLevelWrites", "AccountMaxWrites", "AccountProvisionedReadCapacityUtilization", "AccountProvisionedWriteCapacityUtilization", "ConditionalCheckFailedRequests", "ConsumedReadCapacityUnits", "ConsumedWriteCapacityUnits", "MaxProvisionedTableReadCapacityUtilization", "MaxProvisionedTableWriteCapacityUtilization", "ReturnedItemCount", "ReturnedItemCountBySelect", "SuccessfulRequestCount", "SuccessfulRequestLatency", "SystemErrors", "UserErrors"},
	"AWS/AmplifyHosting":       {"Requests", "BytesDownloaded", "BytesUploaded", "4XXErrors", "5XXErrors", "Latency"},
	"CloudWatchSynthetics":     {"SuccessPercent", "Duration", "2xx", "4xx", "5xx", "Failed", "Failed requests", "VisualMonitoringSuccessPercent", "VisualMonitoringTotalComparisons"},
}

var NamespaceDimensionKeysMap = map[string][]string{
	"AWS/ACMPrivateCA":            {},
	"AWS/AmazonMQ":                {"Broker", "NetworkConnector", "Queue", "Topic", "Node", "Virtual host"},
	"AWS/ApiGateway":              {"ApiId", "ApiName", "Method", "Resource", "Route", "Stage"},
	"AWS/AppFlow":                 {"FlowName"},
	"AWS/AppRunner":               {"Instance", "ServiceID", "ServiceName"},
	"AWS/AppStream":               {"Fleet"},
	"AWS/AppSync":                 {"GraphQLAPIId"},
	"AWS/ApplicationELB":          {"AvailabilityZone", "LoadBalancer", "TargetGroup"},
	"AWS/Athena":                  {"QueryState", "QueryType", "WorkGroup"},
	"AWS/AutoScaling":             {"AutoScalingGroupName"},
	"AWS/Backup":                  {"BackupVaultName", "ResourceType"},
	"AWS/Billing":                 {"Currency", "LinkedAccount", "ServiceName"},
	"AWS/CertificateManager":      {},
	"AWS/Chatbot":                 {"ConfigurationName"},
	"AWS/ClientVPN":               {"Endpoint"},
	"AWS/CloudFront":              {"DistributionId", "Region"},
	"AWS/CloudHSM":                {"ClusterId", "HsmId", "Region"},
	"AWS/CloudSearch":             {"ClientId", "DomainName"},
	"AWS/CodeBuild":               {"ProjectName"},
	"AWS/CodeGuruProfiler":        {},
	"AWS/Cognito":                 {"Operation", "RiskLevel", "UserPoolId", "UserPool", "UserPoolClient", "IdentityProvider"},
	"AWS/Connect":                 {"InstanceId", "MetricGroup", "ContactFlowName", "SigningKeyId", "TypeOfConnection", "Participant", "QueueName", "StreamType"},
	"AWS/DataLifecycleManager":    {"DLMPolicyId"},
	"AWS/DataSync":                {"AgentId", "TaskId"},
	"AWS/DDoSProtection":          {"ResourceArn", "AttackVector", "MitigationAction", "Protocol", "SourcePort", "DestinationPort", "SourceIp", "SourceAsn", "TcpFlags"},
	"AWS/DMS":                     {"ReplicationInstanceIdentifier", "ReplicationTaskIdentifier"},
	"AWS/DocDB":                   {"DBClusterIdentifier", "DBInstanceIdentifier", "Role"},
	"AWS/DX":                      {"ConnectionId", "OpticalLaneNumber", "VirtualInterfaceId"},
	"AWS/DAX":                     {"Account", "ClusterId", "NodeId"},
	"AWS/DynamoDB":                {"DelegatedOperation", "GlobalSecondaryIndexName", "Operation", "OperationType", "ReceivingRegion", "StreamLabel", "TableName", "Verb"},
	"AWS/EBS":                     {"VolumeId"},
	"AWS/EC2":                     {"AutoScalingGroupName", "ImageId", "InstanceId", "InstanceType"},
	"AWS/ElasticGPUs":             {"EGPUId", "InstanceId"},
	"AWS/EC2/API":                 {},
	"AWS/EC2CapacityReservations": {"CapacityReservationId"},
	"AWS/EC2Spot":                 {"AvailabilityZone", "FleetRequestId", "InstanceType"},
	"AWS/ECS":                     {"ClusterName", "ServiceName"},
	"AWS/EFS":                     {"FileSystemId", "StorageClass"},
	"AWS/ELB":                     {"AvailabilityZone", "LoadBalancerName"},
	"AWS/ES":                      {"ClientId", "DomainName", "NodeId"},
	"AWS/ElastiCache":             {"CacheClusterId", "CacheNodeId"},
	"AWS/ElasticBeanstalk":        {"EnvironmentName", "InstanceId"},
	"AWS/ElasticInference":        {"ElasticInferenceAcceleratorId", "InstanceId"},
	"AWS/ElasticMapReduce":        {"ClusterId", "JobFlowId", "JobId"},
	"AWS/ElasticTranscoder":       {"Operation", "PipelineId"},
	"AWS/Events":                  {"EventBusName", "RuleName"},
	"AWS/FSx":                     {"FileSystemId"},
	"AWS/Firehose":                {"DeliveryStreamName"},
	"AWS/FraudDetector":           {"DetectorID", "DetectorVersionID", "ModelEndpoint", "ModelID", "ModelType", "OutcomeName", "RuleID", "VariableName"},
	"AWS/GameLift":                {"FleetId", "InstanceType", "MatchmakingConfigurationName", "MatchmakingConfigurationName-RuleName", "MetricGroups", "OperatingSystem", "QueueName"},
	"AWS/GlobalAccelerator":       {"Accelerator", "Listener", "EndpointGroup", "SourceRegion", "DestinationEdge", "TransportProtocol", "AcceleratorIPAddress"},
	"AWS/Glue":                    {"JobName", "JobRunId", "Type"},
	"AWS/GroundStation":           {"Channel", "Polarization", "SatelliteId"},
	"AWS/Inspector":               {},
	"AWS/IVS":                     {"Channel", "ViewerCountryCode"},
	"AWS/IoT":                     {"ActionType", "BehaviorName", "CheckName", "JobId", "Protocol", "RuleName", "ScheduledAuditName", "SecurityProfileName"},
	"AWS/IoTAnalytics":            {"ActionType", "ChannelName", "DatasetName", "DatastoreName", "PipelineActivityName", "PipelineActivityType", "PipelineName"},
	"AWS/IoTSiteWise":             {"GatewayId", "SourceName"},
	"AWS/KMS":                     {"KeyId"},
	"AWS/Kafka":                   {"Broker ID", "Cluster Name", "Consumer Group", "Topic"},
	"AWS/Kinesis":                 {"ShardId", "StreamName"},
	"AWS/KinesisAnalytics":        {"Application", "Flow", "Id"},
	"AWS/KinesisVideo":            {"StreamName"},
	"AWS/Lambda":                  {"ExecutedVersion", "FunctionName", "Resource"},
	"AWS/Lex":                     {"BotAlias", "BotChannelName", "BotName", "BotVersion", "InputMode", "Operation", "Source"},
	"AWS/Logs":                    {"DestinationType", "FilterName", "LogGroupName"},
	"AWS/LookoutMetrics":          {"AlertArn", "AnomalyDetectorArn"},
	"AWS/ML":                      {"MLModelId", "RequestMode"},
	"AWS/MediaConnect":            {"AvailabilityZone", "FlowARN", "SourceARN", "OutputARN"},
	"AWS/MediaConvert":            {"Job", "Operation", "Queue"},
	"AWS/MediaPackage":            {"Channel", "No Dimension", "OriginEndpoint", "StatusCodeRange"},
	"AWS/MediaStore":              {"ContainerName", "ObjectGroupName", "RequestType"},
	"AWS/MediaTailor":             {"ConfigurationName"},
	"AWS/MemoryDB":                {"ClusterName", "NodeName"},
	"AWS/NATGateway":              {"NatGatewayId"},
	"AWS/Neptune":                 {"DBClusterIdentifier", "DatabaseClass", "EngineName", "Role"},
	"AWS/NetworkELB":              {"AvailabilityZone", "LoadBalancer", "TargetGroup"},
	"AWS/GatewayELB":              {"AvailabilityZone", "LoadBalancer", "TargetGroup"},
	"AWS/NetworkFirewall":         {"AvailabilityZone", "CustomAction", "Engine", "FirewallName"},
	"AWS/OpsWorks":                {"InstanceId", "LayerId", "StackId"},
	"AWS/Polly":                   {"Operation"},
	"AWS/PrivateLinkEndpoints":    {"Endpoint Type", "Service Name", "Subnet Id", "VPC Endpoint Id", "VPC Id"},
	"AWS/PrivateLinkServices":     {"Az", "Load Balancer Arn", "Service Id", "VPC Endpoint Id"},
	"AWS/Prometheus":              {"Reason", "RuleGroup", "Workspace"},
	"AWS/RDS":                     {"DBClusterIdentifier", "DBInstanceIdentifier", "DatabaseClass", "DbClusterIdentifier", "EndpointName", "EngineName", "ProxyName", "Role", "SourceRegion", "Target", "TargetGroup", "TargetRole"},
	"AWS/Redshift":                {"ClusterIdentifier", "NodeID", "service class", "stage", "latency", "wlmid"},
	"AWS/Robomaker":               {"SimulationJobId"},
	"AWS/Route53":                 {"HealthCheckId", "Region", "HostedZoneId"},
	"AWS/Route53Resolver":         {"EndpointId"},
	"AWS/S3":                      {"BucketName", "DestinationBucket", "FilterId", "RuleId", "SourceBucket", "StorageType"},
	"AWS/SDKMetrics":              {"DestinationRegion", "Service"},
	"AWS/ServiceCatalog":          {"State", "ProductId", "ProvisioningArtifactId"},
	"AWS/SES":                     {},
	"AWS/SNS":                     {"Application", "Country", "Platform", "SMSType", "TopicName"},
	"AWS/SQS":                     {"QueueName"},
	"AWS/SWF":                     {"APIName", "ActivityTypeName", "ActivityTypeVersion", "DecisionName", "Domain", "TaskListName", "WorkflowTypeName", "WorkflowTypeVersion"},
	"AWS/SageMaker":               {"EndpointName", "Host", "LabelingJobName", "VariantName"},
	"AWS/States":                  {"APIName", "ActivityArn", "LambdaFunctionArn", "ServiceIntegrationResourceArn", "ServiceName", "StateMachineArn"},
	"AWS/StorageGateway":          {"GatewayId", "GatewayName", "VolumeId"},
	"AWS/Textract":                {},
	"AWS/Timestream":              {"Operation", "DatabaseName", "TableName"},
	"AWS/ThingsGraph":             {"FlowTemplateId", "StepName", "SystemTemplateId"},
	"AWS/TransitGateway":          {"TransitGateway", "TransitGatewayAttachment"},
	"AWS/Transfer":                {"ServerId"},
	"AWS/Translate":               {"LanguagePair", "Operation"},
	"AWS/TrustedAdvisor":          {},
	"AWS/Usage":                   {"Class", "Resource", "Service", "Type"},
	"AWS/VPN":                     {"TunnelIpAddress", "VpnId"},
	"AWS/WAF":                     {"Region", "Rule", "RuleGroup", "WebACL"},
	"AWS/WAFV2":                   {"Region", "Rule", "RuleGroup", "WebACL"},
	"AWS/WorkSpaces":              {"DirectoryId", "WorkspaceId"},
	"ECS/ContainerInsights":       {"ClusterName", "ServiceName", "TaskDefinitionFamily", "EC2InstanceId", "ContainerInstanceId"},
	"ContainerInsights":           {"ClusterName", "NodeName", "Namespace", "InstanceId", "PodName", "Service"},
	"AWS/Rekognition":             {},
	"AWS/Cassandra":               {"Keyspace", "Operation", "TableName"},
	"AWS/AmplifyHosting":          {"App"},
	"CloudWatchSynthetics":        {"CanaryName", "StepName"},
}

type RegionsSet map[string]struct{}

func Regions() RegionsSet {
	return RegionsSet{
		"af-south-1":     {},
		"ap-east-1":      {},
		"ap-northeast-1": {},
		"ap-northeast-2": {},
		"ap-northeast-3": {},
		"ap-south-1":     {},
		"ap-south-2":     {},
		"ap-southeast-1": {},
		"ap-southeast-2": {},
		"ap-southeast-3": {},
		"ap-southeast-4": {},
		"ca-central-1":   {},
		"cn-north-1":     {},
		"cn-northwest-1": {},
		"eu-central-1":   {},
		"eu-central-2":   {},
		"eu-north-1":     {},
		"eu-south-1":     {},
		"eu-south-2":     {},
		"eu-west-1":      {},
		"eu-west-2":      {},
		"eu-west-3":      {},
		"il-central-1":   {},
		"me-central-1":   {},
		"me-south-1":     {},
		"sa-east-1":      {},
		"us-east-1":      {},
		"us-east-2":      {},
		"us-gov-east-1":  {},
		"us-gov-west-1":  {},
		"us-iso-east-1":  {},
		"us-isob-east-1": {},
		"us-west-1":      {},
		"us-west-2":      {},
	}
}
