// Copyright 2018 The go-python Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Test data generated by make_symtable_test.py - do not edit

package symtable

import (
	"github.com/go-python/gpython/py"
)

var symtableTestData = []struct {
	in            string
	mode          py.CompileMode
	out           *SymTable
	exceptionType *py.Type
	errString     string
}{
	{"1", "eval", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols:           Symbols{},
		Children:          Children{},
	}, nil, ""},
	{"a*b*c", "eval", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"a": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"b": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"c": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{},
	}, nil, ""},
	{"def fn(): pass", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"fn": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "fn",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{},
				Symbols:           Symbols{},
				Children:          Children{},
			},
		},
	}, nil, ""},
	{"def fn(a,b):\n e=1\n return a*b*c*d*e", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"fn": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "fn",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      true,
				NeedsClassClosure: false,
				Varnames:          []string{"a", "b"},
				Symbols: Symbols{
					"a": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"b": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"c": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"d": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"e": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"def fn(*args,a=2,b=3,**kwargs): return (args,a,b,kwargs)", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"fn": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "fn",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           true,
				Varkeywords:       true,
				ReturnsValue:      true,
				NeedsClassClosure: false,
				Varnames:          []string{"a", "b", "args", "kwargs"},
				Symbols: Symbols{
					"a": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"args": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"b": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"kwargs": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"def fn(a,b):\n def nested(c,d):\n  return a*b*c*d*e", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         true,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"fn": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "fn",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         true,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{"a", "b"},
				Symbols: Symbols{
					"a": Symbol{
						Flags: DefParam,
						Scope: ScopeCell,
					},
					"b": Symbol{
						Flags: DefParam,
						Scope: ScopeCell,
					},
					"nested": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
				},
				Children: Children{
					&SymTable{
						Type:              FunctionBlock,
						Name:              "nested",
						Lineno:            2,
						Unoptimized:       0,
						Nested:            true,
						Free:              true,
						ChildFree:         false,
						Generator:         false,
						Varargs:           false,
						Varkeywords:       false,
						ReturnsValue:      true,
						NeedsClassClosure: false,
						Varnames:          []string{"c", "d"},
						Symbols: Symbols{
							"a": Symbol{
								Flags: DefUse,
								Scope: ScopeFree,
							},
							"b": Symbol{
								Flags: DefUse,
								Scope: ScopeFree,
							},
							"c": Symbol{
								Flags: DefParam | DefUse,
								Scope: ScopeLocal,
							},
							"d": Symbol{
								Flags: DefParam | DefUse,
								Scope: ScopeLocal,
							},
							"e": Symbol{
								Flags: DefUse,
								Scope: ScopeGlobalImplicit,
							},
						},
						Children: Children{},
					},
				},
			},
		},
	}, nil, ""},
	{"def fn(a:A,*arg:ARG,b:B=BB,c:C=CC,**kwargs:KW) -> RET:\n    def fn(A,b):\n        e=1\n        return a*arg*b*c*kwargs*A*e*glob", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         true,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"A": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"ARG": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"B": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"BB": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"C": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"CC": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"KW": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"RET": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"fn": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "fn",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         true,
				Generator:         false,
				Varargs:           true,
				Varkeywords:       true,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{"a", "b", "c", "arg", "kwargs"},
				Symbols: Symbols{
					"a": Symbol{
						Flags: DefParam,
						Scope: ScopeCell,
					},
					"arg": Symbol{
						Flags: DefParam,
						Scope: ScopeCell,
					},
					"b": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"c": Symbol{
						Flags: DefParam,
						Scope: ScopeCell,
					},
					"fn": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"kwargs": Symbol{
						Flags: DefParam,
						Scope: ScopeCell,
					},
				},
				Children: Children{
					&SymTable{
						Type:              FunctionBlock,
						Name:              "fn",
						Lineno:            2,
						Unoptimized:       0,
						Nested:            true,
						Free:              true,
						ChildFree:         false,
						Generator:         false,
						Varargs:           false,
						Varkeywords:       false,
						ReturnsValue:      true,
						NeedsClassClosure: false,
						Varnames:          []string{"A", "b"},
						Symbols: Symbols{
							"A": Symbol{
								Flags: DefParam | DefUse,
								Scope: ScopeLocal,
							},
							"a": Symbol{
								Flags: DefUse,
								Scope: ScopeFree,
							},
							"arg": Symbol{
								Flags: DefUse,
								Scope: ScopeFree,
							},
							"b": Symbol{
								Flags: DefParam | DefUse,
								Scope: ScopeLocal,
							},
							"c": Symbol{
								Flags: DefUse,
								Scope: ScopeFree,
							},
							"e": Symbol{
								Flags: DefLocal | DefUse,
								Scope: ScopeLocal,
							},
							"glob": Symbol{
								Flags: DefUse,
								Scope: ScopeGlobalImplicit,
							},
							"kwargs": Symbol{
								Flags: DefUse,
								Scope: ScopeFree,
							},
						},
						Children: Children{},
					},
				},
			},
		},
	}, nil, ""},
	{"def fn(a):\n    global b\n    b = a", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"b": Symbol{
				Flags: DefGlobal,
				Scope: ScopeGlobalExplicit,
			},
			"fn": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "fn",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{"a"},
				Symbols: Symbols{
					"a": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"b": Symbol{
						Flags: DefGlobal | DefLocal,
						Scope: ScopeGlobalExplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"def fn(a):\n    global b\n    global b\n    return b", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"b": Symbol{
				Flags: DefGlobal,
				Scope: ScopeGlobalExplicit,
			},
			"fn": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "fn",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      true,
				NeedsClassClosure: false,
				Varnames:          []string{"a"},
				Symbols: Symbols{
					"a": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"b": Symbol{
						Flags: DefGlobal | DefUse,
						Scope: ScopeGlobalExplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"def inner():\n  print(x)\n  global x\n", "exec", nil, py.SyntaxError, "name 'x' is used prior to global declaration"},
	{"def fn(a):\n    b = 6\n    global b\n    b = a", "exec", nil, py.SyntaxError, "name 'b' is assigned to before global declaration"},
	{"def fn(a=b,c=1):\n    return a+b", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"b": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"fn": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "fn",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      true,
				NeedsClassClosure: false,
				Varnames:          []string{"a", "c"},
				Symbols: Symbols{
					"a": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"b": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"c": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"@sausage\n@potato(beans)\ndef outer():\n   x = 1\n   def inner():\n       nonlocal x\n       x = 2", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         true,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"beans": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"outer": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
			"potato": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"sausage": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "outer",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         true,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{},
				Symbols: Symbols{
					"inner": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal,
						Scope: ScopeCell,
					},
				},
				Children: Children{
					&SymTable{
						Type:              FunctionBlock,
						Name:              "inner",
						Lineno:            5,
						Unoptimized:       0,
						Nested:            true,
						Free:              true,
						ChildFree:         false,
						Generator:         false,
						Varargs:           false,
						Varkeywords:       false,
						ReturnsValue:      false,
						NeedsClassClosure: false,
						Varnames:          []string{},
						Symbols: Symbols{
							"x": Symbol{
								Flags: DefLocal | DefNonlocal,
								Scope: ScopeFree,
							},
						},
						Children: Children{},
					},
				},
			},
		},
	}, nil, ""},
	{"def fn(a):\n    nonlocal b\n    ", "exec", nil, py.SyntaxError, "no binding for nonlocal 'b' found"},
	{"def outer():\n   def inner():\n       nonlocal x\n       x = 2", "exec", nil, py.SyntaxError, "no binding for nonlocal 'x' found"},
	{"def outer():\n   x = 1\n   def inner():\n       print(x)\n       nonlocal x\n", "exec", nil, py.SyntaxError, "name 'x' is used prior to nonlocal declaration"},
	{"def outer():\n   x = 1\n   def inner():\n       x = 2\n       nonlocal x", "exec", nil, py.SyntaxError, "name 'x' is assigned to before nonlocal declaration"},
	{"def outer():\n   x = 1\n   def inner(x):\n       nonlocal x", "exec", nil, py.SyntaxError, "name 'x' is parameter and nonlocal"},
	{"def outer():\n   x = 1\n   def inner(x):\n       global x", "exec", nil, py.SyntaxError, "name 'x' is parameter and global"},
	{"def outer():\n   def inner():\n       global x\n       nonlocal x\n       ", "exec", nil, py.SyntaxError, "name 'x' is nonlocal and global"},
	{"def outer():\n   x = 1\n   def inner():\n       y = 2\n       return x + y + z\n", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         true,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"outer": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "outer",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         true,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{},
				Symbols: Symbols{
					"inner": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal,
						Scope: ScopeCell,
					},
				},
				Children: Children{
					&SymTable{
						Type:              FunctionBlock,
						Name:              "inner",
						Lineno:            3,
						Unoptimized:       0,
						Nested:            true,
						Free:              true,
						ChildFree:         false,
						Generator:         false,
						Varargs:           false,
						Varkeywords:       false,
						ReturnsValue:      true,
						NeedsClassClosure: false,
						Varnames:          []string{},
						Symbols: Symbols{
							"x": Symbol{
								Flags: DefUse,
								Scope: ScopeFree,
							},
							"y": Symbol{
								Flags: DefLocal | DefUse,
								Scope: ScopeLocal,
							},
							"z": Symbol{
								Flags: DefUse,
								Scope: ScopeGlobalImplicit,
							},
						},
						Children: Children{},
					},
				},
			},
		},
	}, nil, ""},
	{"def outer():\n   global x\n   def inner():\n       return x\n", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"outer": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
			"x": Symbol{
				Flags: DefGlobal,
				Scope: ScopeGlobalExplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "outer",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{},
				Symbols: Symbols{
					"inner": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefGlobal,
						Scope: ScopeGlobalExplicit,
					},
				},
				Children: Children{
					&SymTable{
						Type:              FunctionBlock,
						Name:              "inner",
						Lineno:            3,
						Unoptimized:       0,
						Nested:            true,
						Free:              false,
						ChildFree:         false,
						Generator:         false,
						Varargs:           false,
						Varkeywords:       false,
						ReturnsValue:      true,
						NeedsClassClosure: false,
						Varnames:          []string{},
						Symbols: Symbols{
							"x": Symbol{
								Flags: DefUse,
								Scope: ScopeGlobalImplicit,
							},
						},
						Children: Children{},
					},
				},
			},
		},
	}, nil, ""},
	{"nonlocal x\n", "exec", nil, py.SyntaxError, "nonlocal declaration not allowed at module level"},
	{"def fn(a,a): pass", "exec", nil, py.SyntaxError, "duplicate argument 'a' in function definition"},
	{"[ x for x in xs ]", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "listcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"[ x+y for x in xs for y in ys ]", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "listcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"ys": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"[ x+y+z for x in xs if x if y if z if r for y in ys if x if y if z if p for z in zs if x if y if z if q]", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "listcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"p": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"q": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"r": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"ys": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"z": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"zs": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"[ x+y for x in [ x for x in xs ] ]", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "listcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
			&SymTable{
				Type:              FunctionBlock,
				Name:              "listcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"[ x for x in xs ]\n[ y for y in ys ]", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"ys": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "listcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
			&SymTable{
				Type:              FunctionBlock,
				Name:              "listcomp",
				Lineno:            2,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"( x for x in xs )", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "genexpr",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         true,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"( x+y for x in xs for y in ys )", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "genexpr",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         true,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"ys": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"( x+y+z for x in xs if x if y if z if r for y in ys if x if y if z if p for z in zs if x if y if z if q)", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "genexpr",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         true,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"p": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"q": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"r": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"ys": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"z": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"zs": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"( x+y for x in ( x for x in xs ) )", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "genexpr",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         true,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
			&SymTable{
				Type:              FunctionBlock,
				Name:              "genexpr",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         true,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"{ x for x in xs }", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "setcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"{ x+y for x in xs for y in ys }", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "setcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"ys": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"{ x+y+z for x in xs if x if y if z if r for y in ys if x if y if z if p for z in zs if x if y if z if q}", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "setcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"p": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"q": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"r": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"ys": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"z": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"zs": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"{ x+y for x in { x for x in xs } }", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "setcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
			&SymTable{
				Type:              FunctionBlock,
				Name:              "setcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"{ x:1 for x in xs }", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "dictcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"{ x+y:1 for x in xs for y in ys }", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "dictcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"ys": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"{ x+y+z:1 for x in xs if x if y if z if r for y in ys if x if y if z if p for z in zs if x if y if z if q}", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "dictcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"p": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"q": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"r": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"ys": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"z": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"zs": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"{ x+y:k for k, x in { x:1 for x in xs } }", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"xs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "dictcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
			&SymTable{
				Type:              FunctionBlock,
				Name:              "dictcomp",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{".0"},
				Symbols: Symbols{
					".0": Symbol{
						Flags: DefParam,
						Scope: ScopeLocal,
					},
					"_[1]": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"k": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefLocal | DefUse,
						Scope: ScopeLocal,
					},
					"y": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"@potato\n@sausage()\nclass A(a,b,c=\"1\",d=\"2\",*args,**kwargs):\n    VAR = x\n    def method(self):\n        super().method()\n        return VAR\n", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         true,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"A": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
			"a": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"args": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"b": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"kwargs": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"potato": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"sausage": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              ClassBlock,
				Name:              "A",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         true,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: true,
				Varnames:          []string{},
				Symbols: Symbols{
					"VAR": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"method": Symbol{
						Flags: DefLocal,
						Scope: ScopeLocal,
					},
					"x": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{
					&SymTable{
						Type:              FunctionBlock,
						Name:              "method",
						Lineno:            5,
						Unoptimized:       0,
						Nested:            false,
						Free:              true,
						ChildFree:         false,
						Generator:         false,
						Varargs:           false,
						Varkeywords:       false,
						ReturnsValue:      true,
						NeedsClassClosure: false,
						Varnames:          []string{"self"},
						Symbols: Symbols{
							"VAR": Symbol{
								Flags: DefUse,
								Scope: ScopeGlobalImplicit,
							},
							"__class__": Symbol{
								Flags: DefUse,
								Scope: ScopeFree,
							},
							"self": Symbol{
								Flags: DefParam,
								Scope: ScopeLocal,
							},
							"super": Symbol{
								Flags: DefUse,
								Scope: ScopeGlobalImplicit,
							},
						},
						Children: Children{},
					},
				},
			},
		},
	}, nil, ""},
	{"lambda: x", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols:           Symbols{},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "lambda",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{},
				Symbols: Symbols{
					"x": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"lambda y: x+y", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols:           Symbols{},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "lambda",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{"y"},
				Symbols: Symbols{
					"x": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"y": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"lambda a,*arg,b=BB,c=CC,**kwargs: POTATO+a+arg+b+c+kwargs", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"BB": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"CC": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "lambda",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         false,
				Varargs:           true,
				Varkeywords:       true,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{"a", "b", "c", "arg", "kwargs"},
				Symbols: Symbols{
					"POTATO": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
					"a": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"arg": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"b": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"c": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
					"kwargs": Symbol{
						Flags: DefParam | DefUse,
						Scope: ScopeLocal,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
	{"with x() as y:\n  y.floop()\nprint(y)\n", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"print": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"x": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"y": Symbol{
				Flags: DefLocal | DefUse,
				Scope: ScopeLocal,
			},
		},
		Children: Children{},
	}, nil, ""},
	{"try:\n  something()\nexcept RandomError as e:\n  print(e)\nprint(e)\n", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"RandomError": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"e": Symbol{
				Flags: DefLocal | DefUse,
				Scope: ScopeLocal,
			},
			"print": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
			"something": Symbol{
				Flags: DefUse,
				Scope: ScopeGlobalImplicit,
			},
		},
		Children: Children{},
	}, nil, ""},
	{"import potato", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"potato": Symbol{
				Flags: DefImport,
				Scope: ScopeLocal,
			},
		},
		Children: Children{},
	}, nil, ""},
	{"import potato.sausage", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"potato": Symbol{
				Flags: DefImport,
				Scope: ScopeLocal,
			},
		},
		Children: Children{},
	}, nil, ""},
	{"from potato import sausage", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"sausage": Symbol{
				Flags: DefImport,
				Scope: ScopeLocal,
			},
		},
		Children: Children{},
	}, nil, ""},
	{"from potato import sausage as salami", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"salami": Symbol{
				Flags: DefImport,
				Scope: ScopeLocal,
			},
		},
		Children: Children{},
	}, nil, ""},
	{"from potato import *", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optImportStar | optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols:           Symbols{},
		Children:          Children{},
	}, nil, ""},
	{"def fn():\n  from potato import *\n", "exec", nil, py.SyntaxError, "import * only allowed at module level"},
	{"def f():\n    yield\n    ", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"f": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "f",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         true,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{},
				Symbols:           Symbols{},
				Children:          Children{},
			},
		},
	}, nil, ""},
	{"def f():\n    yield from range(10)\n    ", "exec", &SymTable{
		Type:              ModuleBlock,
		Name:              "top",
		Lineno:            0,
		Unoptimized:       optTopLevel,
		Nested:            false,
		Free:              false,
		ChildFree:         false,
		Generator:         false,
		Varargs:           false,
		Varkeywords:       false,
		ReturnsValue:      false,
		NeedsClassClosure: false,
		Varnames:          []string{},
		Symbols: Symbols{
			"f": Symbol{
				Flags: DefLocal,
				Scope: ScopeLocal,
			},
		},
		Children: Children{
			&SymTable{
				Type:              FunctionBlock,
				Name:              "f",
				Lineno:            1,
				Unoptimized:       0,
				Nested:            false,
				Free:              false,
				ChildFree:         false,
				Generator:         true,
				Varargs:           false,
				Varkeywords:       false,
				ReturnsValue:      false,
				NeedsClassClosure: false,
				Varnames:          []string{},
				Symbols: Symbols{
					"range": Symbol{
						Flags: DefUse,
						Scope: ScopeGlobalImplicit,
					},
				},
				Children: Children{},
			},
		},
	}, nil, ""},
}
