---
date: 2025-02-10
slug: goreleaser-v2.7
categories: [announcements]
authors: [caarlos0]
---

# Announcing GoReleaser v2.7

Happy February! Another release is here with several improvements across the board.

<!-- more -->

Let's dig into some of the news!

## Simplified versioning

<!-- md:pro -->

GoReleaser Pro always had a `-pro` suffix in its versions.
This doesn't make a lot of sense, as the project is already called
`goreleaser-pro`.
So now, GoReleaser v2.7 is tagged `v2.7.0` - without the `-pro` suffix.

Our [GitHub Action](https://github.com/goreleaser/goreleaser-action) should
handle it seamlessly.

Regardless, let us know if you find any issues.

!!! warning

    Make sure to use the [latest action version](https://github.com/goreleaser/goreleaser-action/releases/latest).

## MSI Improvements

<!-- md:pro -->

The MSI builder got some nice improvements in this release:

- Added support for ARM64 architectures
- Added support for WiX 4+

## New Package Repository Features

<!-- md:pro -->

Package repository integrations got better:

- Added support for Fury APK packages
- Added Cloudsmith component/channel support
- Improved DockerHub integration with description from global `metadata`

## Conditional Hooks

<!-- md:pro -->

You can now use conditions in hooks with the new `if` property, allowing more
granular control over when hooks should run.

## Other Highlights

- **new**: allow OSS to use Pro configurations when `--snapshot` is set
- **new**: `artifactories.skip`
- **build**: fixed `ppc64le` builds
- **build**: improved logging
- improved error handling, specially around build errors

As always, the release includes numerous dependency updates, documentation
improvements, and general housekeeping changes.

## Other news

- GoReleaser now has ~14.2k stars and 419 contributors! Thanks, everyone!
- We eventually discuss new features in our Discord server. 
  [Join the conversation][discord]!
- nFPM had new releases as well, 
  [check it out](https://github.com/goreleaser/nfpm/releases).

## Download

You can [install][] or upgrade using your favorite package manager, or see the
full release notes and download the pre-compiled binaries [here][oss-rel] and
[here (for Pro)][pro-rel].

## Helping out

You can help by reporting issues, contributing features, documentation
improvements, and bug fixes.
You can also [sponsor the project](/sponsors), or get a
[GoReleaser Pro licence][pro].

[pro]: /pro
[install]: https://goreleaser.com/install
[pro-rel]: https://github.com/goreleaser/goreleaser-pro/releases/tag/v2.7.0-pro
[oss-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v2.7.0
[discord]: https://goreleaser.com/discord
[example-deno]: https://github.com/goreleaser/example-deno/
[example-bun]: https://github.com/goreleaser/example-bun/
