# goreleaser

Deliver Go binaries as fast and easily as possible

## Synopsis

GoReleaser is a release automation tool for Go projects.
Its goal is to simplify the build, release and publish steps while providing variant customization options for all steps.

GoReleaser is built for CI tools, you only need to download and execute it in your build script. Of course, you can also install it locally if you wish.

You can customize your entire release process through a single .goreleaser.yaml file.

Check out our website for more information, examples and documentation: https://goreleaser.com


## Options

```
  -h, --help      help for goreleaser
      --verbose   Enable verbose mode
```

## See also

* [goreleaser announce](goreleaser_announce.md)	 - Announces a previously prepared release
* [goreleaser build](goreleaser_build.md)	 - Builds the current project
* [goreleaser changelog](goreleaser_changelog.md)	 - Preview your changelog
* [goreleaser check](goreleaser_check.md)	 - Checks if configuration is valid
* [goreleaser completion](goreleaser_completion.md)	 - Generate the autocompletion script for the specified shell
* [goreleaser continue](goreleaser_continue.md)	 - Continues a previously prepared release
* [goreleaser healthcheck](goreleaser_healthcheck.md)	 - Checks if needed tools are installed
* [goreleaser init](goreleaser_init.md)	 - Generates a .goreleaser.yaml file
* [goreleaser jsonschema](goreleaser_jsonschema.md)	 - outputs goreleaser's JSON schema
* [goreleaser publish](goreleaser_publish.md)	 - Publishes a previously prepared release
* [goreleaser release](goreleaser_release.md)	 - Releases the current project
* [goreleaser subscribe](goreleaser_subscribe.md)	 - Subscribe to GoReleaser Pro, or manage your subscription
* [goreleaser verify-license](goreleaser_verify-license.md)	 - Verify if the given license is valid

