# Cataloging artifacts

Since: v1.2.

A Software Bill of Materials (SBOM) is a description of the components that make
up a software artifact.

Goreleaser can create one or more SBOMs for any artifacts generated by
Goreleaser.

## Usage

The artifact cataloging step can analyze one or more artifacts generated by
Goreleaser and output one or more SBOM files into the dist directory.

The default is configured to create an SBOM for each binary produced with
[Syft](https://github.com/anchore/syft). To enable artifact cataloging just add:

```yaml
# .goreleaser.yml
sboms:
  - artifacts: archive
```

To customize the artifact cataloging pipeline you can use the following options:

```yaml
# .goreleaser.yml
sboms:
  -
    # ID of the sbom config, must be unique.
    #
    # Defaults to "default".
    id: foo

    # List of Names/templates of the SBOM documents created at this step
    # (relative to the dist dir).
    #
    # Each element configured is made available as variables. For example:
    #   documents: ["foo", "bar"]
    #
    # would make the following variables that can be referenced as template keys:
    #   document0: "foo"
    #   document1: "bar"
    #
    # Default value is conditional based on the value of "artifacts"
    #   - "binary":   ["{{ .Binary }}_{{ .Version }}_{{ .Os }}_{{ .Arch }}.sbom"]
    #   - "any":      []
    #   - otherwise:  ["{{ .ArtifactName }}.sbom"]
    #
    # Note that multiple sbom values are only allowed if the value of
    # "artifacts" is "any".
    documents:
      - "${artifact}.spdx.sbom"

    # Path to the SBOM generator command
    #
    # Note: the process CWD will be set to the same location as "dist"
    #
    # Defaults to `syft`
    cmd: syft

    # Command line templateable arguments for the command
    #
    # Defaults to `["$artifact", "--file", "$document", "--output", "spdx-json"]`
    args: ["$artifact", "--file", "$sbom", "--output", "spdx-json"]

    # List of environment variables that will be passed to the SBOM command as
    # well as the templates.
    #
    # Defaults to [ "SYFT_FILE_METADATA_CATALOGER_ENABLED=true" ]
    env:
      - FOO=bar
      - HONK=honkhonk

    # Which artifacts to catalog
    #
    #   any:      let the SBOM tool decide what artifacts available in the cwd
    #             should be cataloged
    #   source:   source archive
    #   package:  linux packages (deb, rpm, apk)
    #   archive:  archives from archive pipe
    #   binary:   binaries output from the build stage
    #
    # Defaults to `archive`
    artifacts: archive

    # IDs of the artifacts to catalog.
    #
    # If `artifacts` is "source" or "any" then this fields has no effect.
    #
    # Defaults to empty (which implies no filtering).
    ids:
      - foo
      - bar
```

### Available variable names

These environment variables might be available in the fields that are
templateable:

- `${artifact}`: the path to the artifact that will be cataloged (unless
  "artifacts" config item is "any")
- `${artifactID}`: the ID of the artifact that will be cataloged (unless
  "artifacts" config item is "any")
- `${document}`:  the SBOM filename generated (corresponds to `${document0}` if
  the "artifacts" config item is "any")
- `${document#}`: the SBOM filenames generated, where `#` corresponds to the
  list index under the "documents" config item (e.g. `${document0}`)

## Limitations

Container images generated by Goreleaser are not available to be cataloged by
the SBOM tool.

