package brew

import "github.com/goreleaser/goreleaser/pkg/config"

type templateData struct {
	Name              string
	Desc              string
	Homepage          string
	Version           string
	License           string
	Caveats           []string
	Plist             string
	DownloadStrategy  string
	Install           []string
	PostInstall       string
	Dependencies      []config.HomebrewDependency
	Conflicts         []string
	Tests             []string
	CustomRequire     string
	CustomBlock       []string
	MacOSAmd64        downloadable
	MacOSArm64        downloadable
	LinuxAmd64        downloadable
	LinuxArm          downloadable
	LinuxArm64        downloadable
	HasMacOSDownloads bool
	HasLinuxDownloads bool
}

type downloadable struct {
	DownloadURL string
	SHA256      string
}

const formulaTemplate = `# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
{{ if .CustomRequire -}}
require_relative "{{ .CustomRequire }}"
{{ end -}}
class {{ .Name }} < Formula
  desc "{{ .Desc }}"
  homepage "{{ .Homepage }}"
  version "{{ .Version }}"
  {{ if .License -}}
  license "{{ .License }}"
  {{ end -}}
  bottle :unneeded
  {{- if and (not .HasLinuxDownloads) .HasMacOSDownloads }}
  depends_on :macos
  {{- end }}
  {{- if and (not .HasMacOSDownloads) .HasLinuxDownloads }}
  depends_on :linux
  {{- end }}
  {{- printf "\n" }}

  {{- if .HasMacOSDownloads }}
  on_macos do
    {{- if .MacOSAmd64.DownloadURL }}
    if Hardware::CPU.intel?
      url "{{ .MacOSAmd64.DownloadURL }}"
      {{- if .DownloadStrategy }}, :using => {{ .DownloadStrategy }}{{- end }}
      sha256 "{{ .MacOSAmd64.SHA256 }}"
    end
    {{- end }}
    {{- if .MacOSArm64.DownloadURL }}
    if Hardware::CPU.arm?
      url "{{ .MacOSArm64.DownloadURL }}"
      {{- if .DownloadStrategy }}, :using => {{ .DownloadStrategy }}{{- end }}
      sha256 "{{ .MacOSArm64.SHA256 }}"
    end
    {{- end }}
  end
  {{- end }}

  {{- if and .HasMacOSDownloads .HasLinuxDownloads }}{{ printf "\n" }}{{ end }}

  {{- if .HasLinuxDownloads }}
  on_linux do
    {{- if .LinuxAmd64.DownloadURL }}
    if Hardware::CPU.intel?
      url "{{ .LinuxAmd64.DownloadURL }}"
      {{- if .DownloadStrategy }}, :using => {{ .DownloadStrategy }}{{- end }}
      sha256 "{{ .LinuxAmd64.SHA256 }}"
    end
    {{- end }}
    {{- if .LinuxArm.DownloadURL }}
    if Hardware::CPU.arm? && !Hardware::CPU.is_64_bit?
      url "{{ .LinuxArm.DownloadURL }}"
      {{- if .DownloadStrategy }}, :using => {{ .DownloadStrategy }}{{- end }}
      sha256 "{{ .LinuxArm.SHA256 }}"
    end
    {{- end }}
    {{- if .LinuxArm64.DownloadURL }}
    if Hardware::CPU.arm? && Hardware::CPU.is_64_bit?
      url "{{ .LinuxArm64.DownloadURL }}"
      {{- if .DownloadStrategy }}, :using => {{ .DownloadStrategy }}{{- end }}
      sha256 "{{ .LinuxArm64.SHA256 }}"
    end
    {{- end }}
  end
  {{- end }}

  {{- with .CustomBlock }}
  {{ range $index, $element := . }}
  {{ . }}
  {{- end }}
  {{- end }}

  {{- with .Dependencies }}
  {{ range $index, $element := . }}
  depends_on "{{ .Name }}"
  {{- if .Type }} => :{{ .Type }}{{- end }}
  {{- end }}
  {{- end -}}

  {{- with .Conflicts }}
  {{ range $index, $element := . }}
  conflicts_with "{{ . }}"
  {{- end }}
  {{- end }}

  def install
    {{- range $index, $element := .Install }}
    {{ . -}}
    {{- end }}
  end

  {{- with .PostInstall }}

  def post_install
    {{ . }}
  end
  {{- end -}}

  {{- with .Caveats }}

  def caveats; <<~EOS
    {{- range $index, $element := . }}
    {{ . -}}
    {{- end }}
  EOS
  end
  {{- end -}}

  {{- with .Plist }}

  plist_options :startup => false

  def plist; <<~EOS
    {{ . }}
  EOS
  end
  {{- end -}}

  {{- if .Tests }}

  test do
    {{- range $index, $element := .Tests }}
    {{ . -}}
    {{- end }}
  end
  {{- end }}
end
`
