// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package kms_test

import (
	"context"

	kms "cloud.google.com/go/kms/apiv1"
	"google.golang.org/api/iterator"
	kmspb "google.golang.org/genproto/googleapis/cloud/kms/v1"
	iampb "google.golang.org/genproto/googleapis/iam/v1"
)

func ExampleNewKeyManagementClient() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleKeyManagementClient_ListKeyRings() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.ListKeyRingsRequest{
		// TODO: Fill request struct fields.
	}
	it := c.ListKeyRings(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleKeyManagementClient_ListCryptoKeys() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.ListCryptoKeysRequest{
		// TODO: Fill request struct fields.
	}
	it := c.ListCryptoKeys(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleKeyManagementClient_ListCryptoKeyVersions() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.ListCryptoKeyVersionsRequest{
		// TODO: Fill request struct fields.
	}
	it := c.ListCryptoKeyVersions(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleKeyManagementClient_ListImportJobs() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.ListImportJobsRequest{
		// TODO: Fill request struct fields.
	}
	it := c.ListImportJobs(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleKeyManagementClient_GetKeyRing() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.GetKeyRingRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetKeyRing(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_GetCryptoKey() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.GetCryptoKeyRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetCryptoKey(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_GetCryptoKeyVersion() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.GetCryptoKeyVersionRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetCryptoKeyVersion(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_GetPublicKey() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.GetPublicKeyRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetPublicKey(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_GetImportJob() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.GetImportJobRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetImportJob(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_CreateKeyRing() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.CreateKeyRingRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.CreateKeyRing(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_CreateCryptoKey() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.CreateCryptoKeyRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.CreateCryptoKey(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_CreateCryptoKeyVersion() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.CreateCryptoKeyVersionRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.CreateCryptoKeyVersion(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_ImportCryptoKeyVersion() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.ImportCryptoKeyVersionRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.ImportCryptoKeyVersion(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_CreateImportJob() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.CreateImportJobRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.CreateImportJob(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_UpdateCryptoKey() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.UpdateCryptoKeyRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.UpdateCryptoKey(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_UpdateCryptoKeyVersion() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.UpdateCryptoKeyVersionRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.UpdateCryptoKeyVersion(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_UpdateCryptoKeyPrimaryVersion() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.UpdateCryptoKeyPrimaryVersionRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.UpdateCryptoKeyPrimaryVersion(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_DestroyCryptoKeyVersion() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.DestroyCryptoKeyVersionRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.DestroyCryptoKeyVersion(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_RestoreCryptoKeyVersion() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.RestoreCryptoKeyVersionRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.RestoreCryptoKeyVersion(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_Encrypt() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.EncryptRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.Encrypt(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_Decrypt() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.DecryptRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.Decrypt(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_AsymmetricSign() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.AsymmetricSignRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.AsymmetricSign(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_AsymmetricDecrypt() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.AsymmetricDecryptRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.AsymmetricDecrypt(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_MacSign() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.MacSignRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.MacSign(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_MacVerify() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.MacVerifyRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.MacVerify(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_GenerateRandomBytes() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &kmspb.GenerateRandomBytesRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GenerateRandomBytes(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_GetIamPolicy() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &iampb.GetIamPolicyRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetIamPolicy(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_SetIamPolicy() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &iampb.SetIamPolicyRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.SetIamPolicy(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleKeyManagementClient_TestIamPermissions() {
	ctx := context.Background()
	c, err := kms.NewKeyManagementClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &iampb.TestIamPermissionsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.TestIamPermissions(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}
