## Cloud Datastore [![Go Reference](https://pkg.go.dev/badge/cloud.google.com/go/datastore.svg)](https://pkg.go.dev/cloud.google.com/go/datastore)

- [About Cloud Datastore](https://cloud.google.com/datastore/)
- [Activating the API for your project](https://cloud.google.com/datastore/docs/activate)
- [API documentation](https://cloud.google.com/datastore/docs)
- [Go client documentation](https://pkg.go.dev/cloud.google.com/go/datastore)
- [Complete sample program](https://github.com/GoogleCloudPlatform/golang-samples/tree/master/datastore/tasks)

### Example Usage

First create a `datastore.Client` to use throughout your application:

[snip]:# (datastore-1)
```go
client, err := datastore.NewClient(ctx, "my-project-id")
if err != nil {
	log.Fatal(err)
}
```

Then use that client to interact with the API:

[snip]:# (datastore-2)
```go
type Post struct {
	Title       string
	Body        string `datastore:",noindex"`
	PublishedAt time.Time
}
keys := []*datastore.Key{
	datastore.NameKey("Post", "post1", nil),
	datastore.NameKey("Post", "post2", nil),
}
posts := []*Post{
	{Title: "Post 1", Body: "...", PublishedAt: time.Now()},
	{Title: "Post 2", Body: "...", PublishedAt: time.Now()},
}
if _, err := client.PutMulti(ctx, keys, posts); err != nil {
	log.Fatal(err)
}
```
