// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/lfp/v1beta/lfpstore.proto

package lfppb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of matching `LfpStore` to a Google Business Profile.
type LfpStore_StoreMatchingState int32

const (
	// Store matching state unspecified.
	LfpStore_STORE_MATCHING_STATE_UNSPECIFIED LfpStore_StoreMatchingState = 0
	// The `LfpStore` is successfully matched with a Google Business Profile
	// store.
	LfpStore_STORE_MATCHING_STATE_MATCHED LfpStore_StoreMatchingState = 1
	// The `LfpStore` is not matched with a Google Business Profile store.
	LfpStore_STORE_MATCHING_STATE_FAILED LfpStore_StoreMatchingState = 2
)

// Enum value maps for LfpStore_StoreMatchingState.
var (
	LfpStore_StoreMatchingState_name = map[int32]string{
		0: "STORE_MATCHING_STATE_UNSPECIFIED",
		1: "STORE_MATCHING_STATE_MATCHED",
		2: "STORE_MATCHING_STATE_FAILED",
	}
	LfpStore_StoreMatchingState_value = map[string]int32{
		"STORE_MATCHING_STATE_UNSPECIFIED": 0,
		"STORE_MATCHING_STATE_MATCHED":     1,
		"STORE_MATCHING_STATE_FAILED":      2,
	}
)

func (x LfpStore_StoreMatchingState) Enum() *LfpStore_StoreMatchingState {
	p := new(LfpStore_StoreMatchingState)
	*p = x
	return p
}

func (x LfpStore_StoreMatchingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LfpStore_StoreMatchingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_enumTypes[0].Descriptor()
}

func (LfpStore_StoreMatchingState) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_enumTypes[0]
}

func (x LfpStore_StoreMatchingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LfpStore_StoreMatchingState.Descriptor instead.
func (LfpStore_StoreMatchingState) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescGZIP(), []int{0, 0}
}

// A store for the merchant. This will be used to match to a store under the
// Google Business Profile of the target merchant. If a matching store can't be
// found, the inventories or sales submitted with the store code will not be
// used.
type LfpStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The name of the `LfpStore` resource.
	// Format: `accounts/{account}/lfpStores/{target_merchant}~{store_code}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Merchant Center id of the merchant to submit the store for.
	TargetAccount int64 `protobuf:"varint,2,opt,name=target_account,json=targetAccount,proto3" json:"target_account,omitempty"`
	// Required. Immutable. A store identifier that is unique for the target
	// merchant.
	StoreCode string `protobuf:"bytes,3,opt,name=store_code,json=storeCode,proto3" json:"store_code,omitempty"`
	// Required. The street address of the store.
	// Example: 1600 Amphitheatre Pkwy, Mountain View, CA 94043, USA.
	StoreAddress string `protobuf:"bytes,4,opt,name=store_address,json=storeAddress,proto3" json:"store_address,omitempty"`
	// Optional. The merchant or store name.
	StoreName *string `protobuf:"bytes,5,opt,name=store_name,json=storeName,proto3,oneof" json:"store_name,omitempty"`
	// Optional. The store phone number in
	// [E.164](https://en.wikipedia.org/wiki/E.164) format. Example:
	// `+15556767888`
	PhoneNumber *string `protobuf:"bytes,6,opt,name=phone_number,json=phoneNumber,proto3,oneof" json:"phone_number,omitempty"`
	// Optional. The website URL for the store or merchant.
	WebsiteUri *string `protobuf:"bytes,7,opt,name=website_uri,json=websiteUri,proto3,oneof" json:"website_uri,omitempty"`
	// Optional. [Google My Business category
	// id](https://gcid-explorer.corp.google.com/static/gcid.html).
	GcidCategory []string `protobuf:"bytes,8,rep,name=gcid_category,json=gcidCategory,proto3" json:"gcid_category,omitempty"`
	// Optional. The [Google Place
	// Id](https://developers.google.com/maps/documentation/places/web-service/place-id#id-overview)
	// of the store location.
	PlaceId *string `protobuf:"bytes,9,opt,name=place_id,json=placeId,proto3,oneof" json:"place_id,omitempty"`
	// Optional. Output only. The state of matching to a Google Business Profile.
	// See
	// [matchingStateHint][google.shopping.merchant.lfp.v1beta.LfpStore.matching_state_hint]
	// for further details if no match is found.
	MatchingState LfpStore_StoreMatchingState `protobuf:"varint,10,opt,name=matching_state,json=matchingState,proto3,enum=google.shopping.merchant.lfp.v1beta.LfpStore_StoreMatchingState" json:"matching_state,omitempty"`
	// Optional. Output only. The hint of why the matching has failed. This is
	// only set when
	// [matchingState][google.shopping.merchant.lfp.v1beta.LfpStore.matching_state]=`STORE_MATCHING_STATE_FAILED`.
	//
	// Possible values are:
	//
	// - "`linked-store-not-found`": There aren't any Google Business
	// Profile stores available for matching.
	// - "`store-match-not-found`": The provided `LfpStore` couldn't be matched to
	// any of the connected Google Business Profile stores. Merchant Center
	// account is connected correctly and stores are available on Google Business
	// Profile, but the `LfpStore` location address does not match with Google
	// Business Profile stores' addresses. Update the `LfpStore` address or Google
	// Business Profile store address to match correctly.
	// - "`store-match-unverified`": The provided `LfpStore` couldn't be matched
	// to any of the connected Google Business Profile stores, as the matched
	// Google Business Profile store is unverified. Go through the Google Business
	// Profile verification process to match correctly.
	MatchingStateHint *string `protobuf:"bytes,11,opt,name=matching_state_hint,json=matchingStateHint,proto3,oneof" json:"matching_state_hint,omitempty"`
}

func (x *LfpStore) Reset() {
	*x = LfpStore{}
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LfpStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LfpStore) ProtoMessage() {}

func (x *LfpStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LfpStore.ProtoReflect.Descriptor instead.
func (*LfpStore) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescGZIP(), []int{0}
}

func (x *LfpStore) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LfpStore) GetTargetAccount() int64 {
	if x != nil {
		return x.TargetAccount
	}
	return 0
}

func (x *LfpStore) GetStoreCode() string {
	if x != nil {
		return x.StoreCode
	}
	return ""
}

func (x *LfpStore) GetStoreAddress() string {
	if x != nil {
		return x.StoreAddress
	}
	return ""
}

func (x *LfpStore) GetStoreName() string {
	if x != nil && x.StoreName != nil {
		return *x.StoreName
	}
	return ""
}

func (x *LfpStore) GetPhoneNumber() string {
	if x != nil && x.PhoneNumber != nil {
		return *x.PhoneNumber
	}
	return ""
}

func (x *LfpStore) GetWebsiteUri() string {
	if x != nil && x.WebsiteUri != nil {
		return *x.WebsiteUri
	}
	return ""
}

func (x *LfpStore) GetGcidCategory() []string {
	if x != nil {
		return x.GcidCategory
	}
	return nil
}

func (x *LfpStore) GetPlaceId() string {
	if x != nil && x.PlaceId != nil {
		return *x.PlaceId
	}
	return ""
}

func (x *LfpStore) GetMatchingState() LfpStore_StoreMatchingState {
	if x != nil {
		return x.MatchingState
	}
	return LfpStore_STORE_MATCHING_STATE_UNSPECIFIED
}

func (x *LfpStore) GetMatchingStateHint() string {
	if x != nil && x.MatchingStateHint != nil {
		return *x.MatchingStateHint
	}
	return ""
}

// Request message for the `GetLfpStore` method.
type GetLfpStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the store to retrieve.
	// Format: `accounts/{account}/lfpStores/{target_merchant}~{store_code}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLfpStoreRequest) Reset() {
	*x = GetLfpStoreRequest{}
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLfpStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLfpStoreRequest) ProtoMessage() {}

func (x *GetLfpStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLfpStoreRequest.ProtoReflect.Descriptor instead.
func (*GetLfpStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescGZIP(), []int{1}
}

func (x *GetLfpStoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the InsertLfpStore method.
type InsertLfpStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The LFP provider account
	// Format: `accounts/{account}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The store to insert.
	LfpStore *LfpStore `protobuf:"bytes,2,opt,name=lfp_store,json=lfpStore,proto3" json:"lfp_store,omitempty"`
}

func (x *InsertLfpStoreRequest) Reset() {
	*x = InsertLfpStoreRequest{}
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InsertLfpStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertLfpStoreRequest) ProtoMessage() {}

func (x *InsertLfpStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertLfpStoreRequest.ProtoReflect.Descriptor instead.
func (*InsertLfpStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescGZIP(), []int{2}
}

func (x *InsertLfpStoreRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InsertLfpStoreRequest) GetLfpStore() *LfpStore {
	if x != nil {
		return x.LfpStore
	}
	return nil
}

// Request message for the DeleteLfpStore method.
type DeleteLfpStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the store to delete for the target merchant account.
	// Format: `accounts/{account}/lfpStores/{target_merchant}~{store_code}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteLfpStoreRequest) Reset() {
	*x = DeleteLfpStoreRequest{}
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteLfpStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLfpStoreRequest) ProtoMessage() {}

func (x *DeleteLfpStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLfpStoreRequest.ProtoReflect.Descriptor instead.
func (*DeleteLfpStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteLfpStoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the ListLfpStores method.
type ListLfpStoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The LFP partner.
	// Format: `accounts/{account}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Merchant Center id of the merchant to list stores for.
	TargetAccount int64 `protobuf:"varint,2,opt,name=target_account,json=targetAccount,proto3" json:"target_account,omitempty"`
	// Optional. The maximum number of `LfpStore` resources for the given account
	// to return. The service returns fewer than this value if the number of
	// stores for the given account is less than the `pageSize`. The default value
	// is 250. The maximum value is 1000; If a value higher than the maximum is
	// specified, then the `pageSize` will default to the maximum.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListLfpStoresRequest`
	// call. Provide the page token to retrieve the subsequent page. When
	// paginating, all other parameters provided to `ListLfpStoresRequest` must
	// match the call that provided the page token. The token returned as
	// [nextPageToken][google.shopping.merchant.lfp.v1beta.ListLfpStoresResponse.next_page_token]
	// in the response to the previous request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListLfpStoresRequest) Reset() {
	*x = ListLfpStoresRequest{}
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLfpStoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLfpStoresRequest) ProtoMessage() {}

func (x *ListLfpStoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLfpStoresRequest.ProtoReflect.Descriptor instead.
func (*ListLfpStoresRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescGZIP(), []int{4}
}

func (x *ListLfpStoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLfpStoresRequest) GetTargetAccount() int64 {
	if x != nil {
		return x.TargetAccount
	}
	return 0
}

func (x *ListLfpStoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLfpStoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the ListLfpStores method.
type ListLfpStoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The stores from the specified merchant.
	LfpStores []*LfpStore `protobuf:"bytes,1,rep,name=lfp_stores,json=lfpStores,proto3" json:"lfp_stores,omitempty"`
	// A token, which can be sent as `pageToken` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLfpStoresResponse) Reset() {
	*x = ListLfpStoresResponse{}
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLfpStoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLfpStoresResponse) ProtoMessage() {}

func (x *ListLfpStoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLfpStoresResponse.ProtoReflect.Descriptor instead.
func (*ListLfpStoresResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescGZIP(), []int{5}
}

func (x *ListLfpStoresResponse) GetLfpStores() []*LfpStore {
	if x != nil {
		return x.LfpStores
	}
	return nil
}

func (x *ListLfpStoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_shopping_merchant_lfp_v1beta_lfpstore_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x6c, 0x66, 0x70, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x66, 0x70, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c,
	0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf1, 0x06, 0x0a, 0x08, 0x4c, 0x66,
	0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25,
	0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x27, 0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0c, 0x70, 0x68, 0x6f, 0x6e,
	0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0b, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0b, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x02, 0x52, 0x0a, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x55, 0x72, 0x69, 0x88, 0x01, 0x01,
	0x12, 0x28, 0x0a, 0x0d, 0x67, 0x63, 0x69, 0x64, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x67, 0x63,
	0x69, 0x64, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x08, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x03, 0x52, 0x07, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x6f, 0x0a, 0x0e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x66,
	0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x3b, 0x0a, 0x13, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x01, 0xe0, 0x41, 0x03, 0x48, 0x04, 0x52, 0x11, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x69, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x22, 0x7d, 0x0a,
	0x12, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x4d, 0x41, 0x54,
	0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x54, 0x4f,
	0x52, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x53,
	0x54, 0x4f, 0x52, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x7a, 0xea, 0x41,
	0x77, 0x0a, 0x23, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x66,
	0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6c, 0x66, 0x70, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x7d, 0x7e, 0x7b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x7d, 0x2a, 0x09, 0x6c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x32, 0x08,
	0x6c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x70, 0x68, 0x6f, 0x6e,
	0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x77, 0x65, 0x62,
	0x73, 0x69, 0x74, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x22, 0x55, 0x0a,
	0x12, 0x47, 0x65, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xad, 0x01, 0x0a, 0x15, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4c,
	0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x09, 0x6c, 0x66, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x66, 0x70,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6c, 0x66, 0x70, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x22, 0x58, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x66,
	0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcd,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12,
	0x23, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x66, 0x70, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x0e,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x6c, 0x66, 0x70, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x09, 0x6c, 0x66, 0x70,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xc8,
	0x06, 0x0a, 0x0f, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xaf, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66,
	0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x66, 0x70, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x38, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x6c, 0x66, 0x70, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4c,
	0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c,
	0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x22, 0x56, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x66,
	0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x09, 0x6c,
	0x66, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x30, 0x2f, 0x6c, 0x66, 0x70, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x66, 0x70, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x3a, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x9e, 0x01, 0x0a, 0x0e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x38, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b,
	0x2a, 0x29, 0x2f, 0x6c, 0x66, 0x70, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x0d,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x6c, 0x66, 0x70, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x7b, 0x0a, 0x27, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x42, 0x0d, 0x4c, 0x66, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x6c, 0x66, 0x70,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x66, 0x70, 0x70, 0x62,
	0x3b, 0x6c, 0x66, 0x70, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescData = file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDesc
)

func file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescData)
	})
	return file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDescData
}

var file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_goTypes = []any{
	(LfpStore_StoreMatchingState)(0), // 0: google.shopping.merchant.lfp.v1beta.LfpStore.StoreMatchingState
	(*LfpStore)(nil),                 // 1: google.shopping.merchant.lfp.v1beta.LfpStore
	(*GetLfpStoreRequest)(nil),       // 2: google.shopping.merchant.lfp.v1beta.GetLfpStoreRequest
	(*InsertLfpStoreRequest)(nil),    // 3: google.shopping.merchant.lfp.v1beta.InsertLfpStoreRequest
	(*DeleteLfpStoreRequest)(nil),    // 4: google.shopping.merchant.lfp.v1beta.DeleteLfpStoreRequest
	(*ListLfpStoresRequest)(nil),     // 5: google.shopping.merchant.lfp.v1beta.ListLfpStoresRequest
	(*ListLfpStoresResponse)(nil),    // 6: google.shopping.merchant.lfp.v1beta.ListLfpStoresResponse
	(*emptypb.Empty)(nil),            // 7: google.protobuf.Empty
}
var file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_depIdxs = []int32{
	0, // 0: google.shopping.merchant.lfp.v1beta.LfpStore.matching_state:type_name -> google.shopping.merchant.lfp.v1beta.LfpStore.StoreMatchingState
	1, // 1: google.shopping.merchant.lfp.v1beta.InsertLfpStoreRequest.lfp_store:type_name -> google.shopping.merchant.lfp.v1beta.LfpStore
	1, // 2: google.shopping.merchant.lfp.v1beta.ListLfpStoresResponse.lfp_stores:type_name -> google.shopping.merchant.lfp.v1beta.LfpStore
	2, // 3: google.shopping.merchant.lfp.v1beta.LfpStoreService.GetLfpStore:input_type -> google.shopping.merchant.lfp.v1beta.GetLfpStoreRequest
	3, // 4: google.shopping.merchant.lfp.v1beta.LfpStoreService.InsertLfpStore:input_type -> google.shopping.merchant.lfp.v1beta.InsertLfpStoreRequest
	4, // 5: google.shopping.merchant.lfp.v1beta.LfpStoreService.DeleteLfpStore:input_type -> google.shopping.merchant.lfp.v1beta.DeleteLfpStoreRequest
	5, // 6: google.shopping.merchant.lfp.v1beta.LfpStoreService.ListLfpStores:input_type -> google.shopping.merchant.lfp.v1beta.ListLfpStoresRequest
	1, // 7: google.shopping.merchant.lfp.v1beta.LfpStoreService.GetLfpStore:output_type -> google.shopping.merchant.lfp.v1beta.LfpStore
	1, // 8: google.shopping.merchant.lfp.v1beta.LfpStoreService.InsertLfpStore:output_type -> google.shopping.merchant.lfp.v1beta.LfpStore
	7, // 9: google.shopping.merchant.lfp.v1beta.LfpStoreService.DeleteLfpStore:output_type -> google.protobuf.Empty
	6, // 10: google.shopping.merchant.lfp.v1beta.LfpStoreService.ListLfpStores:output_type -> google.shopping.merchant.lfp.v1beta.ListLfpStoresResponse
	7, // [7:11] is the sub-list for method output_type
	3, // [3:7] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_init() }
func file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_init() {
	if File_google_shopping_merchant_lfp_v1beta_lfpstore_proto != nil {
		return
	}
	file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_lfp_v1beta_lfpstore_proto = out.File
	file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_rawDesc = nil
	file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_goTypes = nil
	file_google_shopping_merchant_lfp_v1beta_lfpstore_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LfpStoreServiceClient is the client API for LfpStoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LfpStoreServiceClient interface {
	// Retrieves information about a store.
	GetLfpStore(ctx context.Context, in *GetLfpStoreRequest, opts ...grpc.CallOption) (*LfpStore, error)
	// Inserts a store for the target merchant. If the store with the same store
	// code already exists, it will be replaced.
	InsertLfpStore(ctx context.Context, in *InsertLfpStoreRequest, opts ...grpc.CallOption) (*LfpStore, error)
	// Deletes a store for a target merchant.
	DeleteLfpStore(ctx context.Context, in *DeleteLfpStoreRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the stores of the target merchant, specified by the filter in
	// `ListLfpStoresRequest`.
	ListLfpStores(ctx context.Context, in *ListLfpStoresRequest, opts ...grpc.CallOption) (*ListLfpStoresResponse, error)
}

type lfpStoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLfpStoreServiceClient(cc grpc.ClientConnInterface) LfpStoreServiceClient {
	return &lfpStoreServiceClient{cc}
}

func (c *lfpStoreServiceClient) GetLfpStore(ctx context.Context, in *GetLfpStoreRequest, opts ...grpc.CallOption) (*LfpStore, error) {
	out := new(LfpStore)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.lfp.v1beta.LfpStoreService/GetLfpStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lfpStoreServiceClient) InsertLfpStore(ctx context.Context, in *InsertLfpStoreRequest, opts ...grpc.CallOption) (*LfpStore, error) {
	out := new(LfpStore)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.lfp.v1beta.LfpStoreService/InsertLfpStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lfpStoreServiceClient) DeleteLfpStore(ctx context.Context, in *DeleteLfpStoreRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.lfp.v1beta.LfpStoreService/DeleteLfpStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lfpStoreServiceClient) ListLfpStores(ctx context.Context, in *ListLfpStoresRequest, opts ...grpc.CallOption) (*ListLfpStoresResponse, error) {
	out := new(ListLfpStoresResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.lfp.v1beta.LfpStoreService/ListLfpStores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LfpStoreServiceServer is the server API for LfpStoreService service.
type LfpStoreServiceServer interface {
	// Retrieves information about a store.
	GetLfpStore(context.Context, *GetLfpStoreRequest) (*LfpStore, error)
	// Inserts a store for the target merchant. If the store with the same store
	// code already exists, it will be replaced.
	InsertLfpStore(context.Context, *InsertLfpStoreRequest) (*LfpStore, error)
	// Deletes a store for a target merchant.
	DeleteLfpStore(context.Context, *DeleteLfpStoreRequest) (*emptypb.Empty, error)
	// Lists the stores of the target merchant, specified by the filter in
	// `ListLfpStoresRequest`.
	ListLfpStores(context.Context, *ListLfpStoresRequest) (*ListLfpStoresResponse, error)
}

// UnimplementedLfpStoreServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLfpStoreServiceServer struct {
}

func (*UnimplementedLfpStoreServiceServer) GetLfpStore(context.Context, *GetLfpStoreRequest) (*LfpStore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLfpStore not implemented")
}
func (*UnimplementedLfpStoreServiceServer) InsertLfpStore(context.Context, *InsertLfpStoreRequest) (*LfpStore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertLfpStore not implemented")
}
func (*UnimplementedLfpStoreServiceServer) DeleteLfpStore(context.Context, *DeleteLfpStoreRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLfpStore not implemented")
}
func (*UnimplementedLfpStoreServiceServer) ListLfpStores(context.Context, *ListLfpStoresRequest) (*ListLfpStoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLfpStores not implemented")
}

func RegisterLfpStoreServiceServer(s *grpc.Server, srv LfpStoreServiceServer) {
	s.RegisterService(&_LfpStoreService_serviceDesc, srv)
}

func _LfpStoreService_GetLfpStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLfpStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LfpStoreServiceServer).GetLfpStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.lfp.v1beta.LfpStoreService/GetLfpStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LfpStoreServiceServer).GetLfpStore(ctx, req.(*GetLfpStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LfpStoreService_InsertLfpStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertLfpStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LfpStoreServiceServer).InsertLfpStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.lfp.v1beta.LfpStoreService/InsertLfpStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LfpStoreServiceServer).InsertLfpStore(ctx, req.(*InsertLfpStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LfpStoreService_DeleteLfpStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLfpStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LfpStoreServiceServer).DeleteLfpStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.lfp.v1beta.LfpStoreService/DeleteLfpStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LfpStoreServiceServer).DeleteLfpStore(ctx, req.(*DeleteLfpStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LfpStoreService_ListLfpStores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLfpStoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LfpStoreServiceServer).ListLfpStores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.lfp.v1beta.LfpStoreService/ListLfpStores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LfpStoreServiceServer).ListLfpStores(ctx, req.(*ListLfpStoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LfpStoreService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.lfp.v1beta.LfpStoreService",
	HandlerType: (*LfpStoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLfpStore",
			Handler:    _LfpStoreService_GetLfpStore_Handler,
		},
		{
			MethodName: "InsertLfpStore",
			Handler:    _LfpStoreService_InsertLfpStore_Handler,
		},
		{
			MethodName: "DeleteLfpStore",
			Handler:    _LfpStoreService_DeleteLfpStore_Handler,
		},
		{
			MethodName: "ListLfpStores",
			Handler:    _LfpStoreService_ListLfpStores_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/lfp/v1beta/lfpstore.proto",
}
