// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/datasources/v1beta/fileinputs.proto

package datasourcespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The method of file delivery.
type FileInput_FileInputType int32

const (
	// File input type unspecified.
	FileInput_FILE_INPUT_TYPE_UNSPECIFIED FileInput_FileInputType = 0
	// The file is uploaded through SFTP, Google Cloud Storage or manually in
	// the Merchant Center.
	FileInput_UPLOAD FileInput_FileInputType = 1
	// The file is fetched from the configured
	// [fetch_uri][google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.fetch_uri].
	FileInput_FETCH FileInput_FileInputType = 2
	// The file is fetched from Google Sheets specified in the
	// [fetch_uri][google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.fetch_uri].
	FileInput_GOOGLE_SHEETS FileInput_FileInputType = 3
)

// Enum value maps for FileInput_FileInputType.
var (
	FileInput_FileInputType_name = map[int32]string{
		0: "FILE_INPUT_TYPE_UNSPECIFIED",
		1: "UPLOAD",
		2: "FETCH",
		3: "GOOGLE_SHEETS",
	}
	FileInput_FileInputType_value = map[string]int32{
		"FILE_INPUT_TYPE_UNSPECIFIED": 0,
		"UPLOAD":                      1,
		"FETCH":                       2,
		"GOOGLE_SHEETS":               3,
	}
)

func (x FileInput_FileInputType) Enum() *FileInput_FileInputType {
	p := new(FileInput_FileInputType)
	*p = x
	return p
}

func (x FileInput_FileInputType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileInput_FileInputType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_enumTypes[0].Descriptor()
}

func (FileInput_FileInputType) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_enumTypes[0]
}

func (x FileInput_FileInputType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileInput_FileInputType.Descriptor instead.
func (FileInput_FileInputType) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescGZIP(), []int{0, 0}
}

// The required fields vary based on the frequency of fetching. For a
// monthly
// fetch schedule,
// [day of
// month][google.shopping.content.bundles.DataSources.FileInput.FetchSchedule.day_of_month]
// and
// [hour of
// day][google.shopping.content.bundles.DataSources.FileInput.FetchSchedule.time_of_day]
// are required. For a weekly fetch schedule,
// [day of
// week][google.shopping.content.bundles.DataSources.FileInput.FetchSchedule.day_of_week]
// and [hour of
// day][google.shopping.content.bundles.DataSources.FileInput.FetchSchedule.time_of_day]
// are required. For a daily fetch schedule, only an [hour of
// day][google.shopping.content.bundles.DataSources.FileInput.FetchSchedule.time_of_day]
// is required.
type FileInput_FetchSettings_Frequency int32

const (
	// Frequency unspecified.
	FileInput_FetchSettings_FREQUENCY_UNSPECIFIED FileInput_FetchSettings_Frequency = 0
	// The fetch happens every day.
	FileInput_FetchSettings_FREQUENCY_DAILY FileInput_FetchSettings_Frequency = 1
	// The fetch happens every week.
	FileInput_FetchSettings_FREQUENCY_WEEKLY FileInput_FetchSettings_Frequency = 2
	// The fetch happens every month.
	FileInput_FetchSettings_FREQUENCY_MONTHLY FileInput_FetchSettings_Frequency = 3
)

// Enum value maps for FileInput_FetchSettings_Frequency.
var (
	FileInput_FetchSettings_Frequency_name = map[int32]string{
		0: "FREQUENCY_UNSPECIFIED",
		1: "FREQUENCY_DAILY",
		2: "FREQUENCY_WEEKLY",
		3: "FREQUENCY_MONTHLY",
	}
	FileInput_FetchSettings_Frequency_value = map[string]int32{
		"FREQUENCY_UNSPECIFIED": 0,
		"FREQUENCY_DAILY":       1,
		"FREQUENCY_WEEKLY":      2,
		"FREQUENCY_MONTHLY":     3,
	}
)

func (x FileInput_FetchSettings_Frequency) Enum() *FileInput_FetchSettings_Frequency {
	p := new(FileInput_FetchSettings_Frequency)
	*p = x
	return p
}

func (x FileInput_FetchSettings_Frequency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileInput_FetchSettings_Frequency) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_enumTypes[1].Descriptor()
}

func (FileInput_FetchSettings_Frequency) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_enumTypes[1]
}

func (x FileInput_FetchSettings_Frequency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileInput_FetchSettings_Frequency.Descriptor instead.
func (FileInput_FetchSettings_Frequency) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescGZIP(), []int{0, 0, 0}
}

// The data specific for file data sources. This field is empty for other
// data source inputs.
type FileInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Fetch details to deliver the data source. It contains settings
	// for `FETCH` and `GOOGLE_SHEETS` file input types. The required fields vary
	// based on the frequency of fetching.
	FetchSettings *FileInput_FetchSettings `protobuf:"bytes,1,opt,name=fetch_settings,json=fetchSettings,proto3" json:"fetch_settings,omitempty"`
	// Optional. The file name of the data source. Required for `UPLOAD` file
	// input type.
	FileName string `protobuf:"bytes,2,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// Output only. The type of file input.
	FileInputType FileInput_FileInputType `protobuf:"varint,3,opt,name=file_input_type,json=fileInputType,proto3,enum=google.shopping.merchant.datasources.v1beta.FileInput_FileInputType" json:"file_input_type,omitempty"`
}

func (x *FileInput) Reset() {
	*x = FileInput{}
	mi := &file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileInput) ProtoMessage() {}

func (x *FileInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileInput.ProtoReflect.Descriptor instead.
func (*FileInput) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescGZIP(), []int{0}
}

func (x *FileInput) GetFetchSettings() *FileInput_FetchSettings {
	if x != nil {
		return x.FetchSettings
	}
	return nil
}

func (x *FileInput) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *FileInput) GetFileInputType() FileInput_FileInputType {
	if x != nil {
		return x.FileInputType
	}
	return FileInput_FILE_INPUT_TYPE_UNSPECIFIED
}

// Fetch details to deliver the data source.
type FileInput_FetchSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Enables or pauses the fetch schedule.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. The day of the month when the data source file should be
	// fetched (1-31). This field can only be set for monthly frequency.
	DayOfMonth int32 `protobuf:"varint,2,opt,name=day_of_month,json=dayOfMonth,proto3" json:"day_of_month,omitempty"`
	// Optional. The hour of the day when the data source file should be
	// fetched. Minutes and seconds are not supported and will be ignored.
	TimeOfDay *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=time_of_day,json=timeOfDay,proto3" json:"time_of_day,omitempty"`
	// Optional. The day of the week when the data source file should be
	// fetched. This field can only be set for weekly frequency.
	DayOfWeek dayofweek.DayOfWeek `protobuf:"varint,4,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
	// Optional. [Time zone](https://cldr.unicode.org) used for schedule. UTC by
	// default. For example, "America/Los_Angeles".
	TimeZone string `protobuf:"bytes,5,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Required. The frequency describing fetch schedule.
	Frequency FileInput_FetchSettings_Frequency `protobuf:"varint,6,opt,name=frequency,proto3,enum=google.shopping.merchant.datasources.v1beta.FileInput_FetchSettings_Frequency" json:"frequency,omitempty"`
	// Optional. The URL where the data source file can be fetched. Google
	// Merchant Center supports automatic scheduled uploads using the HTTP,
	// HTTPS or SFTP protocols, so the value will need to be a valid link using
	// one of those three protocols. Immutable for Google Sheets files.
	FetchUri string `protobuf:"bytes,7,opt,name=fetch_uri,json=fetchUri,proto3" json:"fetch_uri,omitempty"`
	// Optional. An optional user name for
	// [fetch_uri][google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.fetch_uri].
	// Used for [submitting data sources through
	// SFTP](https://support.google.com/merchants/answer/13813117).
	Username string `protobuf:"bytes,8,opt,name=username,proto3" json:"username,omitempty"`
	// Optional. An optional password for
	// [fetch_uri][google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.fetch_uri].
	// Used for [submitting data sources through
	// SFTP](https://support.google.com/merchants/answer/13813117).
	Password string `protobuf:"bytes,9,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *FileInput_FetchSettings) Reset() {
	*x = FileInput_FetchSettings{}
	mi := &file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileInput_FetchSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileInput_FetchSettings) ProtoMessage() {}

func (x *FileInput_FetchSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileInput_FetchSettings.ProtoReflect.Descriptor instead.
func (*FileInput_FetchSettings) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescGZIP(), []int{0, 0}
}

func (x *FileInput_FetchSettings) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *FileInput_FetchSettings) GetDayOfMonth() int32 {
	if x != nil {
		return x.DayOfMonth
	}
	return 0
}

func (x *FileInput_FetchSettings) GetTimeOfDay() *timeofday.TimeOfDay {
	if x != nil {
		return x.TimeOfDay
	}
	return nil
}

func (x *FileInput_FetchSettings) GetDayOfWeek() dayofweek.DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return dayofweek.DayOfWeek(0)
}

func (x *FileInput_FetchSettings) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *FileInput_FetchSettings) GetFrequency() FileInput_FetchSettings_Frequency {
	if x != nil {
		return x.Frequency
	}
	return FileInput_FetchSettings_FREQUENCY_UNSPECIFIED
}

func (x *FileInput_FetchSettings) GetFetchUri() string {
	if x != nil {
		return x.FetchUri
	}
	return ""
}

func (x *FileInput_FetchSettings) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *FileInput_FetchSettings) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

var File_google_shopping_merchant_datasources_v1beta_fileinputs_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x66, 0x69,
	0x6c, 0x65, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x79, 0x6f, 0x66, 0x77,
	0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa3, 0x07, 0x0a, 0x09, 0x46, 0x69, 0x6c, 0x65, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x70, 0x0a, 0x0e, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x66, 0x65, 0x74, 0x63, 0x68, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x71, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x69,
	0x6c, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xb2, 0x04, 0x0a, 0x0d,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1d, 0x0a,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0c,
	0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x61, 0x79, 0x4f, 0x66, 0x4d, 0x6f,
	0x6e, 0x74, 0x68, 0x12, 0x3b, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x64,
	0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79,
	0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x64, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x12, 0x20, 0x0a,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12,
	0x71, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x66, 0x65, 0x74, 0x63,
	0x68, 0x55, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x68, 0x0a, 0x09, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x52, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x46, 0x52, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x44, 0x41, 0x49, 0x4c,
	0x59, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x52, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x59,
	0x5f, 0x57, 0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x46, 0x52, 0x45,
	0x51, 0x55, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x03,
	0x22, 0x5a, 0x0a, 0x0d, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x4c, 0x4f, 0x41, 0x44, 0x10, 0x01, 0x12, 0x09,
	0x0a, 0x05, 0x46, 0x45, 0x54, 0x43, 0x48, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x47, 0x4f, 0x4f,
	0x47, 0x4c, 0x45, 0x5f, 0x53, 0x48, 0x45, 0x45, 0x54, 0x53, 0x10, 0x03, 0x42, 0xab, 0x02, 0x0a,
	0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x42, 0x0f, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x57, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x2b, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x4d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5c, 0x4d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x4d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescData = file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDesc
)

func file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescData)
	})
	return file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDescData
}

var file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_goTypes = []any{
	(FileInput_FileInputType)(0),           // 0: google.shopping.merchant.datasources.v1beta.FileInput.FileInputType
	(FileInput_FetchSettings_Frequency)(0), // 1: google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.Frequency
	(*FileInput)(nil),                      // 2: google.shopping.merchant.datasources.v1beta.FileInput
	(*FileInput_FetchSettings)(nil),        // 3: google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings
	(*timeofday.TimeOfDay)(nil),            // 4: google.type.TimeOfDay
	(dayofweek.DayOfWeek)(0),               // 5: google.type.DayOfWeek
}
var file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_depIdxs = []int32{
	3, // 0: google.shopping.merchant.datasources.v1beta.FileInput.fetch_settings:type_name -> google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings
	0, // 1: google.shopping.merchant.datasources.v1beta.FileInput.file_input_type:type_name -> google.shopping.merchant.datasources.v1beta.FileInput.FileInputType
	4, // 2: google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.time_of_day:type_name -> google.type.TimeOfDay
	5, // 3: google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.day_of_week:type_name -> google.type.DayOfWeek
	1, // 4: google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.frequency:type_name -> google.shopping.merchant.datasources.v1beta.FileInput.FetchSettings.Frequency
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_init() }
func file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_init() {
	if File_google_shopping_merchant_datasources_v1beta_fileinputs_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_datasources_v1beta_fileinputs_proto = out.File
	file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_rawDesc = nil
	file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_goTypes = nil
	file_google_shopping_merchant_datasources_v1beta_fileinputs_proto_depIdxs = nil
}
