// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package privilegedaccessmanager

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	privilegedaccessmanagerpb "cloud.google.com/go/privilegedaccessmanager/apiv1/privilegedaccessmanagerpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	CheckOnboardingStatus []gax.CallOption
	ListEntitlements      []gax.CallOption
	SearchEntitlements    []gax.CallOption
	GetEntitlement        []gax.CallOption
	CreateEntitlement     []gax.CallOption
	DeleteEntitlement     []gax.CallOption
	UpdateEntitlement     []gax.CallOption
	ListGrants            []gax.CallOption
	SearchGrants          []gax.CallOption
	GetGrant              []gax.CallOption
	CreateGrant           []gax.CallOption
	ApproveGrant          []gax.CallOption
	DenyGrant             []gax.CallOption
	RevokeGrant           []gax.CallOption
	GetLocation           []gax.CallOption
	ListLocations         []gax.CallOption
	DeleteOperation       []gax.CallOption
	GetOperation          []gax.CallOption
	ListOperations        []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("privilegedaccessmanager.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("privilegedaccessmanager.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("privilegedaccessmanager.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://privilegedaccessmanager.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		CheckOnboardingStatus: []gax.CallOption{},
		ListEntitlements:      []gax.CallOption{},
		SearchEntitlements:    []gax.CallOption{},
		GetEntitlement:        []gax.CallOption{},
		CreateEntitlement:     []gax.CallOption{},
		DeleteEntitlement:     []gax.CallOption{},
		UpdateEntitlement:     []gax.CallOption{},
		ListGrants:            []gax.CallOption{},
		SearchGrants:          []gax.CallOption{},
		GetGrant:              []gax.CallOption{},
		CreateGrant:           []gax.CallOption{},
		ApproveGrant:          []gax.CallOption{},
		DenyGrant:             []gax.CallOption{},
		RevokeGrant:           []gax.CallOption{},
		GetLocation:           []gax.CallOption{},
		ListLocations:         []gax.CallOption{},
		DeleteOperation:       []gax.CallOption{},
		GetOperation:          []gax.CallOption{},
		ListOperations:        []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		CheckOnboardingStatus: []gax.CallOption{},
		ListEntitlements:      []gax.CallOption{},
		SearchEntitlements:    []gax.CallOption{},
		GetEntitlement:        []gax.CallOption{},
		CreateEntitlement:     []gax.CallOption{},
		DeleteEntitlement:     []gax.CallOption{},
		UpdateEntitlement:     []gax.CallOption{},
		ListGrants:            []gax.CallOption{},
		SearchGrants:          []gax.CallOption{},
		GetGrant:              []gax.CallOption{},
		CreateGrant:           []gax.CallOption{},
		ApproveGrant:          []gax.CallOption{},
		DenyGrant:             []gax.CallOption{},
		RevokeGrant:           []gax.CallOption{},
		GetLocation:           []gax.CallOption{},
		ListLocations:         []gax.CallOption{},
		DeleteOperation:       []gax.CallOption{},
		GetOperation:          []gax.CallOption{},
		ListOperations:        []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Privileged Access Manager API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CheckOnboardingStatus(context.Context, *privilegedaccessmanagerpb.CheckOnboardingStatusRequest, ...gax.CallOption) (*privilegedaccessmanagerpb.CheckOnboardingStatusResponse, error)
	ListEntitlements(context.Context, *privilegedaccessmanagerpb.ListEntitlementsRequest, ...gax.CallOption) *EntitlementIterator
	SearchEntitlements(context.Context, *privilegedaccessmanagerpb.SearchEntitlementsRequest, ...gax.CallOption) *EntitlementIterator
	GetEntitlement(context.Context, *privilegedaccessmanagerpb.GetEntitlementRequest, ...gax.CallOption) (*privilegedaccessmanagerpb.Entitlement, error)
	CreateEntitlement(context.Context, *privilegedaccessmanagerpb.CreateEntitlementRequest, ...gax.CallOption) (*CreateEntitlementOperation, error)
	CreateEntitlementOperation(name string) *CreateEntitlementOperation
	DeleteEntitlement(context.Context, *privilegedaccessmanagerpb.DeleteEntitlementRequest, ...gax.CallOption) (*DeleteEntitlementOperation, error)
	DeleteEntitlementOperation(name string) *DeleteEntitlementOperation
	UpdateEntitlement(context.Context, *privilegedaccessmanagerpb.UpdateEntitlementRequest, ...gax.CallOption) (*UpdateEntitlementOperation, error)
	UpdateEntitlementOperation(name string) *UpdateEntitlementOperation
	ListGrants(context.Context, *privilegedaccessmanagerpb.ListGrantsRequest, ...gax.CallOption) *GrantIterator
	SearchGrants(context.Context, *privilegedaccessmanagerpb.SearchGrantsRequest, ...gax.CallOption) *GrantIterator
	GetGrant(context.Context, *privilegedaccessmanagerpb.GetGrantRequest, ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error)
	CreateGrant(context.Context, *privilegedaccessmanagerpb.CreateGrantRequest, ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error)
	ApproveGrant(context.Context, *privilegedaccessmanagerpb.ApproveGrantRequest, ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error)
	DenyGrant(context.Context, *privilegedaccessmanagerpb.DenyGrantRequest, ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error)
	RevokeGrant(context.Context, *privilegedaccessmanagerpb.RevokeGrantRequest, ...gax.CallOption) (*RevokeGrantOperation, error)
	RevokeGrantOperation(name string) *RevokeGrantOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// Client is a client for interacting with Privileged Access Manager API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// This API allows customers to manage temporary, request based privileged
// access to their resources.
//
// It defines the following resource model:
//
//	A collection of Entitlement resources. An entitlement allows configuring
//	(among other things):
//
//	  Some kind of privileged access that users can request.
//
//	  A set of users called requesters who can request this access.
//
//	  A maximum duration for which the access can be requested.
//
//	  An optional approval workflow which must be satisfied before access is
//	  granted.
//
//	A collection of Grant resources. A grant is a request by a requester to
//	get the privileged access specified in an entitlement for some duration.
//
// After the approval workflow as specified in the entitlement is satisfied,
//
//	the specified access is given to the requester. The access is automatically
//	taken back after the requested duration is over.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CheckOnboardingStatus CheckOnboardingStatus reports the onboarding status for a
// project/folder/organization. Any findings reported by this API need to be
// fixed before PAM can be used on the resource.
func (c *Client) CheckOnboardingStatus(ctx context.Context, req *privilegedaccessmanagerpb.CheckOnboardingStatusRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.CheckOnboardingStatusResponse, error) {
	return c.internalClient.CheckOnboardingStatus(ctx, req, opts...)
}

// ListEntitlements lists entitlements in a given project/folder/organization and location.
func (c *Client) ListEntitlements(ctx context.Context, req *privilegedaccessmanagerpb.ListEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	return c.internalClient.ListEntitlements(ctx, req, opts...)
}

// SearchEntitlements SearchEntitlements returns entitlements on which the caller has the
// specified access.
func (c *Client) SearchEntitlements(ctx context.Context, req *privilegedaccessmanagerpb.SearchEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	return c.internalClient.SearchEntitlements(ctx, req, opts...)
}

// GetEntitlement gets details of a single entitlement.
func (c *Client) GetEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.GetEntitlementRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Entitlement, error) {
	return c.internalClient.GetEntitlement(ctx, req, opts...)
}

// CreateEntitlement creates a new entitlement in a given project/folder/organization and
// location.
func (c *Client) CreateEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.CreateEntitlementRequest, opts ...gax.CallOption) (*CreateEntitlementOperation, error) {
	return c.internalClient.CreateEntitlement(ctx, req, opts...)
}

// CreateEntitlementOperation returns a new CreateEntitlementOperation from a given name.
// The name must be that of a previously created CreateEntitlementOperation, possibly from a different process.
func (c *Client) CreateEntitlementOperation(name string) *CreateEntitlementOperation {
	return c.internalClient.CreateEntitlementOperation(name)
}

// DeleteEntitlement deletes a single entitlement. This method can only be called when there
// are no in-progress (ACTIVE/ACTIVATING/REVOKING) grants under the
// entitlement.
func (c *Client) DeleteEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.DeleteEntitlementRequest, opts ...gax.CallOption) (*DeleteEntitlementOperation, error) {
	return c.internalClient.DeleteEntitlement(ctx, req, opts...)
}

// DeleteEntitlementOperation returns a new DeleteEntitlementOperation from a given name.
// The name must be that of a previously created DeleteEntitlementOperation, possibly from a different process.
func (c *Client) DeleteEntitlementOperation(name string) *DeleteEntitlementOperation {
	return c.internalClient.DeleteEntitlementOperation(name)
}

// UpdateEntitlement updates the entitlement specified in the request. Updated fields in the
// entitlement need to be specified in an update mask. The changes made to an
// entitlement are applicable only on future grants of the entitlement.
// However, if new approvers are added or existing approvers are removed from
// the approval workflow, the changes are effective on existing grants.
//
// The following fields are not supported for updates:
//
//	All immutable fields
//
//	Entitlement name
//
//	Resource name
//
//	Resource type
//
//	Adding an approval workflow in an entitlement which previously had no
//	approval workflow.
//
//	Deleting the approval workflow from an entitlement.
//
//	Adding or deleting a step in the approval workflow (only one step is
//	supported)
//
// Note that updates are allowed on the list of approvers in an approval
// workflow step.
func (c *Client) UpdateEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.UpdateEntitlementRequest, opts ...gax.CallOption) (*UpdateEntitlementOperation, error) {
	return c.internalClient.UpdateEntitlement(ctx, req, opts...)
}

// UpdateEntitlementOperation returns a new UpdateEntitlementOperation from a given name.
// The name must be that of a previously created UpdateEntitlementOperation, possibly from a different process.
func (c *Client) UpdateEntitlementOperation(name string) *UpdateEntitlementOperation {
	return c.internalClient.UpdateEntitlementOperation(name)
}

// ListGrants lists grants for a given entitlement.
func (c *Client) ListGrants(ctx context.Context, req *privilegedaccessmanagerpb.ListGrantsRequest, opts ...gax.CallOption) *GrantIterator {
	return c.internalClient.ListGrants(ctx, req, opts...)
}

// SearchGrants SearchGrants returns grants that are related to the calling user in the
// specified way.
func (c *Client) SearchGrants(ctx context.Context, req *privilegedaccessmanagerpb.SearchGrantsRequest, opts ...gax.CallOption) *GrantIterator {
	return c.internalClient.SearchGrants(ctx, req, opts...)
}

// GetGrant get details of a single grant.
func (c *Client) GetGrant(ctx context.Context, req *privilegedaccessmanagerpb.GetGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	return c.internalClient.GetGrant(ctx, req, opts...)
}

// CreateGrant creates a new grant in a given project/folder/organization and
// location.
func (c *Client) CreateGrant(ctx context.Context, req *privilegedaccessmanagerpb.CreateGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	return c.internalClient.CreateGrant(ctx, req, opts...)
}

// ApproveGrant ApproveGrant is used to approve a grant. This method can only be called
// on a grant when it’s in the APPROVAL_AWAITED state. This operation can’t
// be undone.
func (c *Client) ApproveGrant(ctx context.Context, req *privilegedaccessmanagerpb.ApproveGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	return c.internalClient.ApproveGrant(ctx, req, opts...)
}

// DenyGrant DenyGrant is used to deny a grant. This method can only be called on a
// grant when it’s in the APPROVAL_AWAITED state. This operation can’t be
// undone.
func (c *Client) DenyGrant(ctx context.Context, req *privilegedaccessmanagerpb.DenyGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	return c.internalClient.DenyGrant(ctx, req, opts...)
}

// RevokeGrant RevokeGrant is used to immediately revoke access for a grant. This method
// can be called when the grant is in a non-terminal state.
func (c *Client) RevokeGrant(ctx context.Context, req *privilegedaccessmanagerpb.RevokeGrantRequest, opts ...gax.CallOption) (*RevokeGrantOperation, error) {
	return c.internalClient.RevokeGrant(ctx, req, opts...)
}

// RevokeGrantOperation returns a new RevokeGrantOperation from a given name.
// The name must be that of a previously created RevokeGrantOperation, possibly from a different process.
func (c *Client) RevokeGrantOperation(name string) *RevokeGrantOperation {
	return c.internalClient.RevokeGrantOperation(name)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *Client) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *Client) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *Client) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Privileged Access Manager API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client privilegedaccessmanagerpb.PrivilegedAccessManagerClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewClient creates a new privileged access manager client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// This API allows customers to manage temporary, request based privileged
// access to their resources.
//
// It defines the following resource model:
//
//	A collection of Entitlement resources. An entitlement allows configuring
//	(among other things):
//
//	  Some kind of privileged access that users can request.
//
//	  A set of users called requesters who can request this access.
//
//	  A maximum duration for which the access can be requested.
//
//	  An optional approval workflow which must be satisfied before access is
//	  granted.
//
//	A collection of Grant resources. A grant is a request by a requester to
//	get the privileged access specified in an entitlement for some duration.
//
// After the approval workflow as specified in the entitlement is satisfied,
//
//	the specified access is given to the requester. The access is automatically
//	taken back after the requested duration is over.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		client:           privilegedaccessmanagerpb.NewPrivilegedAccessManagerClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	logger *slog.Logger
}

// NewRESTClient creates a new privileged access manager rest client.
//
// This API allows customers to manage temporary, request based privileged
// access to their resources.
//
// It defines the following resource model:
//
//	A collection of Entitlement resources. An entitlement allows configuring
//	(among other things):
//
//	  Some kind of privileged access that users can request.
//
//	  A set of users called requesters who can request this access.
//
//	  A maximum duration for which the access can be requested.
//
//	  An optional approval workflow which must be satisfied before access is
//	  granted.
//
//	A collection of Grant resources. A grant is a request by a requester to
//	get the privileged access specified in an entitlement for some duration.
//
// After the approval workflow as specified in the entitlement is satisfied,
//
//	the specified access is given to the requester. The access is automatically
//	taken back after the requested duration is over.
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://privilegedaccessmanager.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://privilegedaccessmanager.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://privilegedaccessmanager.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://privilegedaccessmanager.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) CheckOnboardingStatus(ctx context.Context, req *privilegedaccessmanagerpb.CheckOnboardingStatusRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.CheckOnboardingStatusResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CheckOnboardingStatus[0:len((*c.CallOptions).CheckOnboardingStatus):len((*c.CallOptions).CheckOnboardingStatus)], opts...)
	var resp *privilegedaccessmanagerpb.CheckOnboardingStatusResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CheckOnboardingStatus, req, settings.GRPC, c.logger, "CheckOnboardingStatus")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListEntitlements(ctx context.Context, req *privilegedaccessmanagerpb.ListEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEntitlements[0:len((*c.CallOptions).ListEntitlements):len((*c.CallOptions).ListEntitlements)], opts...)
	it := &EntitlementIterator{}
	req = proto.Clone(req).(*privilegedaccessmanagerpb.ListEntitlementsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*privilegedaccessmanagerpb.Entitlement, string, error) {
		resp := &privilegedaccessmanagerpb.ListEntitlementsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListEntitlements, req, settings.GRPC, c.logger, "ListEntitlements")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEntitlements(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) SearchEntitlements(ctx context.Context, req *privilegedaccessmanagerpb.SearchEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchEntitlements[0:len((*c.CallOptions).SearchEntitlements):len((*c.CallOptions).SearchEntitlements)], opts...)
	it := &EntitlementIterator{}
	req = proto.Clone(req).(*privilegedaccessmanagerpb.SearchEntitlementsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*privilegedaccessmanagerpb.Entitlement, string, error) {
		resp := &privilegedaccessmanagerpb.SearchEntitlementsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.SearchEntitlements, req, settings.GRPC, c.logger, "SearchEntitlements")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEntitlements(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.GetEntitlementRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Entitlement, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEntitlement[0:len((*c.CallOptions).GetEntitlement):len((*c.CallOptions).GetEntitlement)], opts...)
	var resp *privilegedaccessmanagerpb.Entitlement
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetEntitlement, req, settings.GRPC, c.logger, "GetEntitlement")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.CreateEntitlementRequest, opts ...gax.CallOption) (*CreateEntitlementOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateEntitlement[0:len((*c.CallOptions).CreateEntitlement):len((*c.CallOptions).CreateEntitlement)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateEntitlement, req, settings.GRPC, c.logger, "CreateEntitlement")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateEntitlementOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.DeleteEntitlementRequest, opts ...gax.CallOption) (*DeleteEntitlementOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteEntitlement[0:len((*c.CallOptions).DeleteEntitlement):len((*c.CallOptions).DeleteEntitlement)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteEntitlement, req, settings.GRPC, c.logger, "DeleteEntitlement")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteEntitlementOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.UpdateEntitlementRequest, opts ...gax.CallOption) (*UpdateEntitlementOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "entitlement.name", url.QueryEscape(req.GetEntitlement().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateEntitlement[0:len((*c.CallOptions).UpdateEntitlement):len((*c.CallOptions).UpdateEntitlement)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateEntitlement, req, settings.GRPC, c.logger, "UpdateEntitlement")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateEntitlementOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListGrants(ctx context.Context, req *privilegedaccessmanagerpb.ListGrantsRequest, opts ...gax.CallOption) *GrantIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGrants[0:len((*c.CallOptions).ListGrants):len((*c.CallOptions).ListGrants)], opts...)
	it := &GrantIterator{}
	req = proto.Clone(req).(*privilegedaccessmanagerpb.ListGrantsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*privilegedaccessmanagerpb.Grant, string, error) {
		resp := &privilegedaccessmanagerpb.ListGrantsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListGrants, req, settings.GRPC, c.logger, "ListGrants")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGrants(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) SearchGrants(ctx context.Context, req *privilegedaccessmanagerpb.SearchGrantsRequest, opts ...gax.CallOption) *GrantIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchGrants[0:len((*c.CallOptions).SearchGrants):len((*c.CallOptions).SearchGrants)], opts...)
	it := &GrantIterator{}
	req = proto.Clone(req).(*privilegedaccessmanagerpb.SearchGrantsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*privilegedaccessmanagerpb.Grant, string, error) {
		resp := &privilegedaccessmanagerpb.SearchGrantsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.SearchGrants, req, settings.GRPC, c.logger, "SearchGrants")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGrants(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetGrant(ctx context.Context, req *privilegedaccessmanagerpb.GetGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGrant[0:len((*c.CallOptions).GetGrant):len((*c.CallOptions).GetGrant)], opts...)
	var resp *privilegedaccessmanagerpb.Grant
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetGrant, req, settings.GRPC, c.logger, "GetGrant")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateGrant(ctx context.Context, req *privilegedaccessmanagerpb.CreateGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGrant[0:len((*c.CallOptions).CreateGrant):len((*c.CallOptions).CreateGrant)], opts...)
	var resp *privilegedaccessmanagerpb.Grant
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateGrant, req, settings.GRPC, c.logger, "CreateGrant")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ApproveGrant(ctx context.Context, req *privilegedaccessmanagerpb.ApproveGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ApproveGrant[0:len((*c.CallOptions).ApproveGrant):len((*c.CallOptions).ApproveGrant)], opts...)
	var resp *privilegedaccessmanagerpb.Grant
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ApproveGrant, req, settings.GRPC, c.logger, "ApproveGrant")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DenyGrant(ctx context.Context, req *privilegedaccessmanagerpb.DenyGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DenyGrant[0:len((*c.CallOptions).DenyGrant):len((*c.CallOptions).DenyGrant)], opts...)
	var resp *privilegedaccessmanagerpb.Grant
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DenyGrant, req, settings.GRPC, c.logger, "DenyGrant")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) RevokeGrant(ctx context.Context, req *privilegedaccessmanagerpb.RevokeGrantRequest, opts ...gax.CallOption) (*RevokeGrantOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RevokeGrant[0:len((*c.CallOptions).RevokeGrant):len((*c.CallOptions).RevokeGrant)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.RevokeGrant, req, settings.GRPC, c.logger, "RevokeGrant")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RevokeGrantOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CheckOnboardingStatus CheckOnboardingStatus reports the onboarding status for a
// project/folder/organization. Any findings reported by this API need to be
// fixed before PAM can be used on the resource.
func (c *restClient) CheckOnboardingStatus(ctx context.Context, req *privilegedaccessmanagerpb.CheckOnboardingStatusRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.CheckOnboardingStatusResponse, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:checkOnboardingStatus", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CheckOnboardingStatus[0:len((*c.CallOptions).CheckOnboardingStatus):len((*c.CallOptions).CheckOnboardingStatus)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &privilegedaccessmanagerpb.CheckOnboardingStatusResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "CheckOnboardingStatus")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListEntitlements lists entitlements in a given project/folder/organization and location.
func (c *restClient) ListEntitlements(ctx context.Context, req *privilegedaccessmanagerpb.ListEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	it := &EntitlementIterator{}
	req = proto.Clone(req).(*privilegedaccessmanagerpb.ListEntitlementsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*privilegedaccessmanagerpb.Entitlement, string, error) {
		resp := &privilegedaccessmanagerpb.ListEntitlementsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/entitlements", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListEntitlements")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEntitlements(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SearchEntitlements SearchEntitlements returns entitlements on which the caller has the
// specified access.
func (c *restClient) SearchEntitlements(ctx context.Context, req *privilegedaccessmanagerpb.SearchEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	it := &EntitlementIterator{}
	req = proto.Clone(req).(*privilegedaccessmanagerpb.SearchEntitlementsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*privilegedaccessmanagerpb.Entitlement, string, error) {
		resp := &privilegedaccessmanagerpb.SearchEntitlementsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/entitlements:search", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		params.Add("callerAccessType", fmt.Sprintf("%v", req.GetCallerAccessType()))
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "SearchEntitlements")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEntitlements(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetEntitlement gets details of a single entitlement.
func (c *restClient) GetEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.GetEntitlementRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Entitlement, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEntitlement[0:len((*c.CallOptions).GetEntitlement):len((*c.CallOptions).GetEntitlement)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &privilegedaccessmanagerpb.Entitlement{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetEntitlement")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateEntitlement creates a new entitlement in a given project/folder/organization and
// location.
func (c *restClient) CreateEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.CreateEntitlementRequest, opts ...gax.CallOption) (*CreateEntitlementOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEntitlement()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/entitlements", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("entitlementId", fmt.Sprintf("%v", req.GetEntitlementId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateEntitlement")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateEntitlementOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteEntitlement deletes a single entitlement. This method can only be called when there
// are no in-progress (ACTIVE/ACTIVATING/REVOKING) grants under the
// entitlement.
func (c *restClient) DeleteEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.DeleteEntitlementRequest, opts ...gax.CallOption) (*DeleteEntitlementOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteEntitlement")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteEntitlementOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateEntitlement updates the entitlement specified in the request. Updated fields in the
// entitlement need to be specified in an update mask. The changes made to an
// entitlement are applicable only on future grants of the entitlement.
// However, if new approvers are added or existing approvers are removed from
// the approval workflow, the changes are effective on existing grants.
//
// The following fields are not supported for updates:
//
//	All immutable fields
//
//	Entitlement name
//
//	Resource name
//
//	Resource type
//
//	Adding an approval workflow in an entitlement which previously had no
//	approval workflow.
//
//	Deleting the approval workflow from an entitlement.
//
//	Adding or deleting a step in the approval workflow (only one step is
//	supported)
//
// Note that updates are allowed on the list of approvers in an approval
// workflow step.
func (c *restClient) UpdateEntitlement(ctx context.Context, req *privilegedaccessmanagerpb.UpdateEntitlementRequest, opts ...gax.CallOption) (*UpdateEntitlementOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEntitlement()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetEntitlement().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "entitlement.name", url.QueryEscape(req.GetEntitlement().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateEntitlement")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateEntitlementOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListGrants lists grants for a given entitlement.
func (c *restClient) ListGrants(ctx context.Context, req *privilegedaccessmanagerpb.ListGrantsRequest, opts ...gax.CallOption) *GrantIterator {
	it := &GrantIterator{}
	req = proto.Clone(req).(*privilegedaccessmanagerpb.ListGrantsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*privilegedaccessmanagerpb.Grant, string, error) {
		resp := &privilegedaccessmanagerpb.ListGrantsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/grants", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListGrants")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGrants(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SearchGrants SearchGrants returns grants that are related to the calling user in the
// specified way.
func (c *restClient) SearchGrants(ctx context.Context, req *privilegedaccessmanagerpb.SearchGrantsRequest, opts ...gax.CallOption) *GrantIterator {
	it := &GrantIterator{}
	req = proto.Clone(req).(*privilegedaccessmanagerpb.SearchGrantsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*privilegedaccessmanagerpb.Grant, string, error) {
		resp := &privilegedaccessmanagerpb.SearchGrantsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/grants:search", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		params.Add("callerRelationship", fmt.Sprintf("%v", req.GetCallerRelationship()))
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "SearchGrants")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGrants(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetGrant get details of a single grant.
func (c *restClient) GetGrant(ctx context.Context, req *privilegedaccessmanagerpb.GetGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGrant[0:len((*c.CallOptions).GetGrant):len((*c.CallOptions).GetGrant)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &privilegedaccessmanagerpb.Grant{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetGrant")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateGrant creates a new grant in a given project/folder/organization and
// location.
func (c *restClient) CreateGrant(ctx context.Context, req *privilegedaccessmanagerpb.CreateGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGrant()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/grants", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateGrant[0:len((*c.CallOptions).CreateGrant):len((*c.CallOptions).CreateGrant)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &privilegedaccessmanagerpb.Grant{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateGrant")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ApproveGrant ApproveGrant is used to approve a grant. This method can only be called
// on a grant when it’s in the APPROVAL_AWAITED state. This operation can’t
// be undone.
func (c *restClient) ApproveGrant(ctx context.Context, req *privilegedaccessmanagerpb.ApproveGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:approve", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ApproveGrant[0:len((*c.CallOptions).ApproveGrant):len((*c.CallOptions).ApproveGrant)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &privilegedaccessmanagerpb.Grant{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ApproveGrant")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DenyGrant DenyGrant is used to deny a grant. This method can only be called on a
// grant when it’s in the APPROVAL_AWAITED state. This operation can’t be
// undone.
func (c *restClient) DenyGrant(ctx context.Context, req *privilegedaccessmanagerpb.DenyGrantRequest, opts ...gax.CallOption) (*privilegedaccessmanagerpb.Grant, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:deny", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).DenyGrant[0:len((*c.CallOptions).DenyGrant):len((*c.CallOptions).DenyGrant)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &privilegedaccessmanagerpb.Grant{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "DenyGrant")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RevokeGrant RevokeGrant is used to immediately revoke access for a grant. This method
// can be called when the grant is in a non-terminal state.
func (c *restClient) RevokeGrant(ctx context.Context, req *privilegedaccessmanagerpb.RevokeGrantRequest, opts ...gax.CallOption) (*RevokeGrantOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:revoke", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RevokeGrant")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RevokeGrantOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *restClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *restClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *restClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateEntitlementOperation returns a new CreateEntitlementOperation from a given name.
// The name must be that of a previously created CreateEntitlementOperation, possibly from a different process.
func (c *gRPCClient) CreateEntitlementOperation(name string) *CreateEntitlementOperation {
	return &CreateEntitlementOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateEntitlementOperation returns a new CreateEntitlementOperation from a given name.
// The name must be that of a previously created CreateEntitlementOperation, possibly from a different process.
func (c *restClient) CreateEntitlementOperation(name string) *CreateEntitlementOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateEntitlementOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteEntitlementOperation returns a new DeleteEntitlementOperation from a given name.
// The name must be that of a previously created DeleteEntitlementOperation, possibly from a different process.
func (c *gRPCClient) DeleteEntitlementOperation(name string) *DeleteEntitlementOperation {
	return &DeleteEntitlementOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteEntitlementOperation returns a new DeleteEntitlementOperation from a given name.
// The name must be that of a previously created DeleteEntitlementOperation, possibly from a different process.
func (c *restClient) DeleteEntitlementOperation(name string) *DeleteEntitlementOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteEntitlementOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RevokeGrantOperation returns a new RevokeGrantOperation from a given name.
// The name must be that of a previously created RevokeGrantOperation, possibly from a different process.
func (c *gRPCClient) RevokeGrantOperation(name string) *RevokeGrantOperation {
	return &RevokeGrantOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RevokeGrantOperation returns a new RevokeGrantOperation from a given name.
// The name must be that of a previously created RevokeGrantOperation, possibly from a different process.
func (c *restClient) RevokeGrantOperation(name string) *RevokeGrantOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RevokeGrantOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateEntitlementOperation returns a new UpdateEntitlementOperation from a given name.
// The name must be that of a previously created UpdateEntitlementOperation, possibly from a different process.
func (c *gRPCClient) UpdateEntitlementOperation(name string) *UpdateEntitlementOperation {
	return &UpdateEntitlementOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateEntitlementOperation returns a new UpdateEntitlementOperation from a given name.
// The name must be that of a previously created UpdateEntitlementOperation, possibly from a different process.
func (c *restClient) UpdateEntitlementOperation(name string) *UpdateEntitlementOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateEntitlementOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
