// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/oracledatabase/v1/autonomous_db_backup.proto

package oracledatabasepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// // The various lifecycle states of the Autonomous Database Backup.
type AutonomousDatabaseBackupProperties_State int32

const (
	// Default unspecified value.
	AutonomousDatabaseBackupProperties_STATE_UNSPECIFIED AutonomousDatabaseBackupProperties_State = 0
	// Indicates that the resource is in creating state.
	AutonomousDatabaseBackupProperties_CREATING AutonomousDatabaseBackupProperties_State = 1
	// Indicates that the resource is in active state.
	AutonomousDatabaseBackupProperties_ACTIVE AutonomousDatabaseBackupProperties_State = 2
	// Indicates that the resource is in deleting state.
	AutonomousDatabaseBackupProperties_DELETING AutonomousDatabaseBackupProperties_State = 3
	// Indicates that the resource is in deleted state.
	AutonomousDatabaseBackupProperties_DELETED AutonomousDatabaseBackupProperties_State = 4
	// Indicates that the resource is in failed state.
	AutonomousDatabaseBackupProperties_FAILED AutonomousDatabaseBackupProperties_State = 6
	// Indicates that the resource is in updating state.
	AutonomousDatabaseBackupProperties_UPDATING AutonomousDatabaseBackupProperties_State = 7
)

// Enum value maps for AutonomousDatabaseBackupProperties_State.
var (
	AutonomousDatabaseBackupProperties_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "DELETED",
		6: "FAILED",
		7: "UPDATING",
	}
	AutonomousDatabaseBackupProperties_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"DELETED":           4,
		"FAILED":            6,
		"UPDATING":          7,
	}
)

func (x AutonomousDatabaseBackupProperties_State) Enum() *AutonomousDatabaseBackupProperties_State {
	p := new(AutonomousDatabaseBackupProperties_State)
	*p = x
	return p
}

func (x AutonomousDatabaseBackupProperties_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseBackupProperties_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_enumTypes[0].Descriptor()
}

func (AutonomousDatabaseBackupProperties_State) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_enumTypes[0]
}

func (x AutonomousDatabaseBackupProperties_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseBackupProperties_State.Descriptor instead.
func (AutonomousDatabaseBackupProperties_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescGZIP(), []int{1, 0}
}

// The type of the backup.
type AutonomousDatabaseBackupProperties_Type int32

const (
	// Default unspecified value.
	AutonomousDatabaseBackupProperties_TYPE_UNSPECIFIED AutonomousDatabaseBackupProperties_Type = 0
	// Incremental backups.
	AutonomousDatabaseBackupProperties_INCREMENTAL AutonomousDatabaseBackupProperties_Type = 1
	// Full backups.
	AutonomousDatabaseBackupProperties_FULL AutonomousDatabaseBackupProperties_Type = 2
	// Long term backups.
	AutonomousDatabaseBackupProperties_LONG_TERM AutonomousDatabaseBackupProperties_Type = 3
)

// Enum value maps for AutonomousDatabaseBackupProperties_Type.
var (
	AutonomousDatabaseBackupProperties_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "INCREMENTAL",
		2: "FULL",
		3: "LONG_TERM",
	}
	AutonomousDatabaseBackupProperties_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"INCREMENTAL":      1,
		"FULL":             2,
		"LONG_TERM":        3,
	}
)

func (x AutonomousDatabaseBackupProperties_Type) Enum() *AutonomousDatabaseBackupProperties_Type {
	p := new(AutonomousDatabaseBackupProperties_Type)
	*p = x
	return p
}

func (x AutonomousDatabaseBackupProperties_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseBackupProperties_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_enumTypes[1].Descriptor()
}

func (AutonomousDatabaseBackupProperties_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_enumTypes[1]
}

func (x AutonomousDatabaseBackupProperties_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseBackupProperties_Type.Descriptor instead.
func (AutonomousDatabaseBackupProperties_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescGZIP(), []int{1, 1}
}

// Details of the Autonomous Database Backup resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseBackup/
type AutonomousDatabaseBackup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the Autonomous Database Backup resource with the
	// format:
	// projects/{project}/locations/{region}/autonomousDatabaseBackups/{autonomous_database_backup}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the Autonomous Database resource for which the backup
	// is being created. Format:
	// projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
	AutonomousDatabase string `protobuf:"bytes,2,opt,name=autonomous_database,json=autonomousDatabase,proto3" json:"autonomous_database,omitempty"`
	// Optional. User friendly name for the Backup. The name does not have to be
	// unique.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Various properties of the backup.
	Properties *AutonomousDatabaseBackupProperties `protobuf:"bytes,4,opt,name=properties,proto3" json:"properties,omitempty"`
	// Optional. labels or tags associated with the resource.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AutonomousDatabaseBackup) Reset() {
	*x = AutonomousDatabaseBackup{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabaseBackup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabaseBackup) ProtoMessage() {}

func (x *AutonomousDatabaseBackup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabaseBackup.ProtoReflect.Descriptor instead.
func (*AutonomousDatabaseBackup) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescGZIP(), []int{0}
}

func (x *AutonomousDatabaseBackup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AutonomousDatabaseBackup) GetAutonomousDatabase() string {
	if x != nil {
		return x.AutonomousDatabase
	}
	return ""
}

func (x *AutonomousDatabaseBackup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AutonomousDatabaseBackup) GetProperties() *AutonomousDatabaseBackupProperties {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *AutonomousDatabaseBackup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Properties of the Autonomous Database Backup resource.
type AutonomousDatabaseBackupProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. OCID of the Autonomous Database backup.
	// https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
	Ocid string `protobuf:"bytes,1,opt,name=ocid,proto3" json:"ocid,omitempty"`
	// Optional. Retention period in days for the backup.
	RetentionPeriodDays int32 `protobuf:"varint,2,opt,name=retention_period_days,json=retentionPeriodDays,proto3" json:"retention_period_days,omitempty"`
	// Output only. The OCID of the compartment.
	CompartmentId string `protobuf:"bytes,3,opt,name=compartment_id,json=compartmentId,proto3" json:"compartment_id,omitempty"`
	// Output only. The quantity of data in the database, in terabytes.
	DatabaseSizeTb float32 `protobuf:"fixed32,4,opt,name=database_size_tb,json=databaseSizeTb,proto3" json:"database_size_tb,omitempty"`
	// Output only. A valid Oracle Database version for Autonomous Database.
	DbVersion string `protobuf:"bytes,5,opt,name=db_version,json=dbVersion,proto3" json:"db_version,omitempty"`
	// Output only. Indicates if the backup is long term backup.
	IsLongTermBackup bool `protobuf:"varint,6,opt,name=is_long_term_backup,json=isLongTermBackup,proto3" json:"is_long_term_backup,omitempty"`
	// Output only. Indicates if the backup is automatic or user initiated.
	IsAutomaticBackup bool `protobuf:"varint,7,opt,name=is_automatic_backup,json=isAutomaticBackup,proto3" json:"is_automatic_backup,omitempty"`
	// Output only. Indicates if the backup can be used to restore the Autonomous
	// Database.
	IsRestorable bool `protobuf:"varint,8,opt,name=is_restorable,json=isRestorable,proto3" json:"is_restorable,omitempty"`
	// Optional. The OCID of the key store of Oracle Vault.
	KeyStoreId string `protobuf:"bytes,9,opt,name=key_store_id,json=keyStoreId,proto3" json:"key_store_id,omitempty"`
	// Optional. The wallet name for Oracle Key Vault.
	KeyStoreWallet string `protobuf:"bytes,10,opt,name=key_store_wallet,json=keyStoreWallet,proto3" json:"key_store_wallet,omitempty"`
	// Optional. The OCID of the key container that is used as the master
	// encryption key in database transparent data encryption (TDE) operations.
	KmsKeyId string `protobuf:"bytes,11,opt,name=kms_key_id,json=kmsKeyId,proto3" json:"kms_key_id,omitempty"`
	// Optional. The OCID of the key container version that is used in database
	// transparent data encryption (TDE) operations KMS Key can have multiple key
	// versions. If none is specified, the current key version (latest) of the Key
	// Id is used for the operation. Autonomous Database Serverless does not use
	// key versions, hence is not applicable for Autonomous Database Serverless
	// instances.
	KmsKeyVersionId string `protobuf:"bytes,12,opt,name=kms_key_version_id,json=kmsKeyVersionId,proto3" json:"kms_key_version_id,omitempty"`
	// Output only. Additional information about the current lifecycle state.
	LifecycleDetails string `protobuf:"bytes,13,opt,name=lifecycle_details,json=lifecycleDetails,proto3" json:"lifecycle_details,omitempty"`
	// Output only. The lifecycle state of the backup.
	LifecycleState AutonomousDatabaseBackupProperties_State `protobuf:"varint,14,opt,name=lifecycle_state,json=lifecycleState,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties_State" json:"lifecycle_state,omitempty"`
	// Output only. The backup size in terabytes.
	SizeTb float32 `protobuf:"fixed32,15,opt,name=size_tb,json=sizeTb,proto3" json:"size_tb,omitempty"`
	// Output only. Timestamp until when the backup will be available.
	AvailableTillTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=available_till_time,json=availableTillTime,proto3" json:"available_till_time,omitempty"`
	// Output only. The date and time the backup completed.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The date and time the backup started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,18,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The type of the backup.
	Type AutonomousDatabaseBackupProperties_Type `protobuf:"varint,19,opt,name=type,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties_Type" json:"type,omitempty"`
	// Optional. The OCID of the vault.
	VaultId string `protobuf:"bytes,20,opt,name=vault_id,json=vaultId,proto3" json:"vault_id,omitempty"`
}

func (x *AutonomousDatabaseBackupProperties) Reset() {
	*x = AutonomousDatabaseBackupProperties{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabaseBackupProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabaseBackupProperties) ProtoMessage() {}

func (x *AutonomousDatabaseBackupProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabaseBackupProperties.ProtoReflect.Descriptor instead.
func (*AutonomousDatabaseBackupProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescGZIP(), []int{1}
}

func (x *AutonomousDatabaseBackupProperties) GetOcid() string {
	if x != nil {
		return x.Ocid
	}
	return ""
}

func (x *AutonomousDatabaseBackupProperties) GetRetentionPeriodDays() int32 {
	if x != nil {
		return x.RetentionPeriodDays
	}
	return 0
}

func (x *AutonomousDatabaseBackupProperties) GetCompartmentId() string {
	if x != nil {
		return x.CompartmentId
	}
	return ""
}

func (x *AutonomousDatabaseBackupProperties) GetDatabaseSizeTb() float32 {
	if x != nil {
		return x.DatabaseSizeTb
	}
	return 0
}

func (x *AutonomousDatabaseBackupProperties) GetDbVersion() string {
	if x != nil {
		return x.DbVersion
	}
	return ""
}

func (x *AutonomousDatabaseBackupProperties) GetIsLongTermBackup() bool {
	if x != nil {
		return x.IsLongTermBackup
	}
	return false
}

func (x *AutonomousDatabaseBackupProperties) GetIsAutomaticBackup() bool {
	if x != nil {
		return x.IsAutomaticBackup
	}
	return false
}

func (x *AutonomousDatabaseBackupProperties) GetIsRestorable() bool {
	if x != nil {
		return x.IsRestorable
	}
	return false
}

func (x *AutonomousDatabaseBackupProperties) GetKeyStoreId() string {
	if x != nil {
		return x.KeyStoreId
	}
	return ""
}

func (x *AutonomousDatabaseBackupProperties) GetKeyStoreWallet() string {
	if x != nil {
		return x.KeyStoreWallet
	}
	return ""
}

func (x *AutonomousDatabaseBackupProperties) GetKmsKeyId() string {
	if x != nil {
		return x.KmsKeyId
	}
	return ""
}

func (x *AutonomousDatabaseBackupProperties) GetKmsKeyVersionId() string {
	if x != nil {
		return x.KmsKeyVersionId
	}
	return ""
}

func (x *AutonomousDatabaseBackupProperties) GetLifecycleDetails() string {
	if x != nil {
		return x.LifecycleDetails
	}
	return ""
}

func (x *AutonomousDatabaseBackupProperties) GetLifecycleState() AutonomousDatabaseBackupProperties_State {
	if x != nil {
		return x.LifecycleState
	}
	return AutonomousDatabaseBackupProperties_STATE_UNSPECIFIED
}

func (x *AutonomousDatabaseBackupProperties) GetSizeTb() float32 {
	if x != nil {
		return x.SizeTb
	}
	return 0
}

func (x *AutonomousDatabaseBackupProperties) GetAvailableTillTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AvailableTillTime
	}
	return nil
}

func (x *AutonomousDatabaseBackupProperties) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *AutonomousDatabaseBackupProperties) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *AutonomousDatabaseBackupProperties) GetType() AutonomousDatabaseBackupProperties_Type {
	if x != nil {
		return x.Type
	}
	return AutonomousDatabaseBackupProperties_TYPE_UNSPECIFIED
}

func (x *AutonomousDatabaseBackupProperties) GetVaultId() string {
	if x != nil {
		return x.VaultId
	}
	return ""
}

var File_google_cloud_oracledatabase_v1_autonomous_db_backup_proto protoreflect.FileDescriptor

var file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x62, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa1, 0x05, 0x0a, 0x18, 0x41, 0x75, 0x74,
	0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x69,
	0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x67, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xd1, 0x01, 0xea, 0x41, 0xcd, 0x01, 0x0a,
	0x36, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x5e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x7d, 0x2a, 0x19, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x73, 0x32, 0x18, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x81, 0x0a, 0x0a,
	0x22, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6f, 0x63, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6f, 0x63, 0x69, 0x64, 0x12, 0x37, 0x0a, 0x15,
	0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x13, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x44, 0x61, 0x79, 0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x12, 0x2d, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x74, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x54, 0x62,
	0x12, 0x22, 0x0a, 0x0a, 0x64, 0x62, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x64, 0x62, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x13, 0x69, 0x73, 0x5f, 0x6c, 0x6f, 0x6e, 0x67, 0x5f,
	0x74, 0x65, 0x72, 0x6d, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x69, 0x73, 0x4c, 0x6f, 0x6e, 0x67, 0x54, 0x65,
	0x72, 0x6d, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x33, 0x0a, 0x13, 0x69, 0x73, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x69, 0x73, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x28, 0x0a,
	0x0d, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x69, 0x73, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x6b, 0x65, 0x79, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x2d,
	0x0a, 0x10, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x77, 0x61, 0x6c, 0x6c,
	0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6b,
	0x65, 0x79, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x12, 0x21, 0x0a,
	0x0a, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x49, 0x64,
	0x12, 0x30, 0x0a, 0x12, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x30, 0x0a, 0x11, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x10, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x76, 0x0a, 0x0f, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c,
	0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x07,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x74, 0x62, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x54, 0x62, 0x12, 0x4f, 0x0a, 0x13, 0x61, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x54, 0x69, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x76, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x64, 0x22, 0x6d, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x03, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50,
	0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x22, 0x46, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x43, 0x52, 0x45, 0x4d,
	0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x4f, 0x4e, 0x47, 0x5f, 0x54, 0x45, 0x52, 0x4d, 0x10, 0x03,
	0x42, 0xf1, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x17, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x62, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0x3b, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0xaa, 0x02,
	0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescOnce sync.Once
	file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescData = file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDesc
)

func file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescGZIP() []byte {
	file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescOnce.Do(func() {
		file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescData)
	})
	return file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDescData
}

var file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_goTypes = []any{
	(AutonomousDatabaseBackupProperties_State)(0), // 0: google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.State
	(AutonomousDatabaseBackupProperties_Type)(0),  // 1: google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.Type
	(*AutonomousDatabaseBackup)(nil),              // 2: google.cloud.oracledatabase.v1.AutonomousDatabaseBackup
	(*AutonomousDatabaseBackupProperties)(nil),    // 3: google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties
	nil,                           // 4: google.cloud.oracledatabase.v1.AutonomousDatabaseBackup.LabelsEntry
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_depIdxs = []int32{
	3, // 0: google.cloud.oracledatabase.v1.AutonomousDatabaseBackup.properties:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties
	4, // 1: google.cloud.oracledatabase.v1.AutonomousDatabaseBackup.labels:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseBackup.LabelsEntry
	0, // 2: google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.lifecycle_state:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.State
	5, // 3: google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.available_till_time:type_name -> google.protobuf.Timestamp
	5, // 4: google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.end_time:type_name -> google.protobuf.Timestamp
	5, // 5: google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.start_time:type_name -> google.protobuf.Timestamp
	1, // 6: google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.type:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseBackupProperties.Type
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_init() }
func file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_init() {
	if File_google_cloud_oracledatabase_v1_autonomous_db_backup_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_goTypes,
		DependencyIndexes: file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_depIdxs,
		EnumInfos:         file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_enumTypes,
		MessageInfos:      file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_msgTypes,
	}.Build()
	File_google_cloud_oracledatabase_v1_autonomous_db_backup_proto = out.File
	file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_rawDesc = nil
	file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_goTypes = nil
	file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_depIdxs = nil
}
