// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/data_store.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Content config of the data store.
type DataStore_ContentConfig int32

const (
	// Default value.
	DataStore_CONTENT_CONFIG_UNSPECIFIED DataStore_ContentConfig = 0
	// Only contains documents without any
	// [Document.content][google.cloud.discoveryengine.v1beta.Document.content].
	DataStore_NO_CONTENT DataStore_ContentConfig = 1
	// Only contains documents with
	// [Document.content][google.cloud.discoveryengine.v1beta.Document.content].
	DataStore_CONTENT_REQUIRED DataStore_ContentConfig = 2
	// The data store is used for public website search.
	DataStore_PUBLIC_WEBSITE DataStore_ContentConfig = 3
	// The data store is used for workspace search. Details of workspace
	// data store are specified in the
	// [WorkspaceConfig][google.cloud.discoveryengine.v1beta.WorkspaceConfig].
	DataStore_GOOGLE_WORKSPACE DataStore_ContentConfig = 4
)

// Enum value maps for DataStore_ContentConfig.
var (
	DataStore_ContentConfig_name = map[int32]string{
		0: "CONTENT_CONFIG_UNSPECIFIED",
		1: "NO_CONTENT",
		2: "CONTENT_REQUIRED",
		3: "PUBLIC_WEBSITE",
		4: "GOOGLE_WORKSPACE",
	}
	DataStore_ContentConfig_value = map[string]int32{
		"CONTENT_CONFIG_UNSPECIFIED": 0,
		"NO_CONTENT":                 1,
		"CONTENT_REQUIRED":           2,
		"PUBLIC_WEBSITE":             3,
		"GOOGLE_WORKSPACE":           4,
	}
)

func (x DataStore_ContentConfig) Enum() *DataStore_ContentConfig {
	p := new(DataStore_ContentConfig)
	*p = x
	return p
}

func (x DataStore_ContentConfig) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataStore_ContentConfig) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_enumTypes[0].Descriptor()
}

func (DataStore_ContentConfig) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_data_store_proto_enumTypes[0]
}

func (x DataStore_ContentConfig) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataStore_ContentConfig.Descriptor instead.
func (DataStore_ContentConfig) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{0, 0}
}

// Mode of Natural Language Query Understanding. When the
// NaturalLanguageQueryUnderstandingConfig.Mode is ENABLED, the natural
// language understanding capabilities will be enabled for a search request if
// the NaturalLanguageQueryUnderstandingSpec.FilterExtractionCondition in the
// SearchRequest is ENABLED.
type NaturalLanguageQueryUnderstandingConfig_Mode int32

const (
	// Default value.
	NaturalLanguageQueryUnderstandingConfig_MODE_UNSPECIFIED NaturalLanguageQueryUnderstandingConfig_Mode = 0
	// Natural Language Query Understanding is disabled.
	NaturalLanguageQueryUnderstandingConfig_DISABLED NaturalLanguageQueryUnderstandingConfig_Mode = 1
	// Natural Language Query Understanding is enabled.
	NaturalLanguageQueryUnderstandingConfig_ENABLED NaturalLanguageQueryUnderstandingConfig_Mode = 2
)

// Enum value maps for NaturalLanguageQueryUnderstandingConfig_Mode.
var (
	NaturalLanguageQueryUnderstandingConfig_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "ENABLED",
	}
	NaturalLanguageQueryUnderstandingConfig_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"DISABLED":         1,
		"ENABLED":          2,
	}
)

func (x NaturalLanguageQueryUnderstandingConfig_Mode) Enum() *NaturalLanguageQueryUnderstandingConfig_Mode {
	p := new(NaturalLanguageQueryUnderstandingConfig_Mode)
	*p = x
	return p
}

func (x NaturalLanguageQueryUnderstandingConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NaturalLanguageQueryUnderstandingConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_enumTypes[1].Descriptor()
}

func (NaturalLanguageQueryUnderstandingConfig_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_data_store_proto_enumTypes[1]
}

func (x NaturalLanguageQueryUnderstandingConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NaturalLanguageQueryUnderstandingConfig_Mode.Descriptor instead.
func (NaturalLanguageQueryUnderstandingConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{2, 0}
}

// Specifies the type of Workspace App supported by this DataStore
type WorkspaceConfig_Type int32

const (
	// Defaults to an unspecified Workspace type.
	WorkspaceConfig_TYPE_UNSPECIFIED WorkspaceConfig_Type = 0
	// Workspace Data Store contains Drive data
	WorkspaceConfig_GOOGLE_DRIVE WorkspaceConfig_Type = 1
	// Workspace Data Store contains Mail data
	WorkspaceConfig_GOOGLE_MAIL WorkspaceConfig_Type = 2
	// Workspace Data Store contains Sites data
	WorkspaceConfig_GOOGLE_SITES WorkspaceConfig_Type = 3
	// Workspace Data Store contains Calendar data
	WorkspaceConfig_GOOGLE_CALENDAR WorkspaceConfig_Type = 4
	// Workspace Data Store contains Chat data
	WorkspaceConfig_GOOGLE_CHAT WorkspaceConfig_Type = 5
	// Workspace Data Store contains Groups data
	WorkspaceConfig_GOOGLE_GROUPS WorkspaceConfig_Type = 6
	// Workspace Data Store contains Keep data
	WorkspaceConfig_GOOGLE_KEEP WorkspaceConfig_Type = 7
)

// Enum value maps for WorkspaceConfig_Type.
var (
	WorkspaceConfig_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GOOGLE_DRIVE",
		2: "GOOGLE_MAIL",
		3: "GOOGLE_SITES",
		4: "GOOGLE_CALENDAR",
		5: "GOOGLE_CHAT",
		6: "GOOGLE_GROUPS",
		7: "GOOGLE_KEEP",
	}
	WorkspaceConfig_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"GOOGLE_DRIVE":     1,
		"GOOGLE_MAIL":      2,
		"GOOGLE_SITES":     3,
		"GOOGLE_CALENDAR":  4,
		"GOOGLE_CHAT":      5,
		"GOOGLE_GROUPS":    6,
		"GOOGLE_KEEP":      7,
	}
)

func (x WorkspaceConfig_Type) Enum() *WorkspaceConfig_Type {
	p := new(WorkspaceConfig_Type)
	*p = x
	return p
}

func (x WorkspaceConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkspaceConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_enumTypes[2].Descriptor()
}

func (WorkspaceConfig_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_data_store_proto_enumTypes[2]
}

func (x WorkspaceConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkspaceConfig_Type.Descriptor instead.
func (WorkspaceConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{3, 0}
}

// DataStore captures global settings and configs at the DataStore level.
type DataStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The full resource name of the data store.
	// Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
	//
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The data store display name.
	//
	// This field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Immutable. The industry vertical that the data store registers.
	IndustryVertical IndustryVertical `protobuf:"varint,3,opt,name=industry_vertical,json=industryVertical,proto3,enum=google.cloud.discoveryengine.v1beta.IndustryVertical" json:"industry_vertical,omitempty"`
	// The solutions that the data store enrolls. Available solutions for each
	// [industry_vertical][google.cloud.discoveryengine.v1beta.DataStore.industry_vertical]:
	//
	//   - `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`.
	//   - `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other
	//     solutions cannot be enrolled.
	SolutionTypes []SolutionType `protobuf:"varint,5,rep,packed,name=solution_types,json=solutionTypes,proto3,enum=google.cloud.discoveryengine.v1beta.SolutionType" json:"solution_types,omitempty"`
	// Output only. The id of the default
	// [Schema][google.cloud.discoveryengine.v1beta.Schema] asscociated to this
	// data store.
	DefaultSchemaId string `protobuf:"bytes,7,opt,name=default_schema_id,json=defaultSchemaId,proto3" json:"default_schema_id,omitempty"`
	// Immutable. The content config of the data store. If this field is unset,
	// the server behavior defaults to
	// [ContentConfig.NO_CONTENT][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.NO_CONTENT].
	ContentConfig DataStore_ContentConfig `protobuf:"varint,6,opt,name=content_config,json=contentConfig,proto3,enum=google.cloud.discoveryengine.v1beta.DataStore_ContentConfig" json:"content_config,omitempty"`
	// Output only. Timestamp the
	// [DataStore][google.cloud.discoveryengine.v1beta.DataStore] was created at.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Language info for DataStore.
	LanguageInfo *LanguageInfo `protobuf:"bytes,14,opt,name=language_info,json=languageInfo,proto3" json:"language_info,omitempty"`
	// Optional. Configuration for Natural Language Query Understanding.
	NaturalLanguageQueryUnderstandingConfig *NaturalLanguageQueryUnderstandingConfig `protobuf:"bytes,34,opt,name=natural_language_query_understanding_config,json=naturalLanguageQueryUnderstandingConfig,proto3" json:"natural_language_query_understanding_config,omitempty"`
	// Output only. Data size estimation for billing.
	BillingEstimation *DataStore_BillingEstimation `protobuf:"bytes,23,opt,name=billing_estimation,json=billingEstimation,proto3" json:"billing_estimation,omitempty"`
	// Config to store data store type configuration for workspace data. This
	// must be set when
	// [DataStore.content_config][google.cloud.discoveryengine.v1beta.DataStore.content_config]
	// is set as
	// [DataStore.ContentConfig.GOOGLE_WORKSPACE][google.cloud.discoveryengine.v1beta.DataStore.ContentConfig.GOOGLE_WORKSPACE].
	WorkspaceConfig *WorkspaceConfig `protobuf:"bytes,25,opt,name=workspace_config,json=workspaceConfig,proto3" json:"workspace_config,omitempty"`
	// Configuration for Document understanding and enrichment.
	DocumentProcessingConfig *DocumentProcessingConfig `protobuf:"bytes,27,opt,name=document_processing_config,json=documentProcessingConfig,proto3" json:"document_processing_config,omitempty"`
	// The start schema to use for this
	// [DataStore][google.cloud.discoveryengine.v1beta.DataStore] when
	// provisioning it. If unset, a default vertical specialized schema will be
	// used.
	//
	// This field is only used by [CreateDataStore][] API, and will be ignored if
	// used in other APIs. This field will be omitted from all API responses
	// including [CreateDataStore][] API. To retrieve a schema of a
	// [DataStore][google.cloud.discoveryengine.v1beta.DataStore], use
	// [SchemaService.GetSchema][google.cloud.discoveryengine.v1beta.SchemaService.GetSchema]
	// API instead.
	//
	// The provided schema will be validated against certain rules on schema.
	// Learn more from [this
	// doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
	StartingSchema *Schema `protobuf:"bytes,28,opt,name=starting_schema,json=startingSchema,proto3" json:"starting_schema,omitempty"`
	// Optional. Stores serving config at DataStore level.
	ServingConfigDataStore *DataStore_ServingConfigDataStore `protobuf:"bytes,30,opt,name=serving_config_data_store,json=servingConfigDataStore,proto3" json:"serving_config_data_store,omitempty"`
}

func (x *DataStore) Reset() {
	*x = DataStore{}
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStore) ProtoMessage() {}

func (x *DataStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStore.ProtoReflect.Descriptor instead.
func (*DataStore) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{0}
}

func (x *DataStore) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataStore) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DataStore) GetIndustryVertical() IndustryVertical {
	if x != nil {
		return x.IndustryVertical
	}
	return IndustryVertical_INDUSTRY_VERTICAL_UNSPECIFIED
}

func (x *DataStore) GetSolutionTypes() []SolutionType {
	if x != nil {
		return x.SolutionTypes
	}
	return nil
}

func (x *DataStore) GetDefaultSchemaId() string {
	if x != nil {
		return x.DefaultSchemaId
	}
	return ""
}

func (x *DataStore) GetContentConfig() DataStore_ContentConfig {
	if x != nil {
		return x.ContentConfig
	}
	return DataStore_CONTENT_CONFIG_UNSPECIFIED
}

func (x *DataStore) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DataStore) GetLanguageInfo() *LanguageInfo {
	if x != nil {
		return x.LanguageInfo
	}
	return nil
}

func (x *DataStore) GetNaturalLanguageQueryUnderstandingConfig() *NaturalLanguageQueryUnderstandingConfig {
	if x != nil {
		return x.NaturalLanguageQueryUnderstandingConfig
	}
	return nil
}

func (x *DataStore) GetBillingEstimation() *DataStore_BillingEstimation {
	if x != nil {
		return x.BillingEstimation
	}
	return nil
}

func (x *DataStore) GetWorkspaceConfig() *WorkspaceConfig {
	if x != nil {
		return x.WorkspaceConfig
	}
	return nil
}

func (x *DataStore) GetDocumentProcessingConfig() *DocumentProcessingConfig {
	if x != nil {
		return x.DocumentProcessingConfig
	}
	return nil
}

func (x *DataStore) GetStartingSchema() *Schema {
	if x != nil {
		return x.StartingSchema
	}
	return nil
}

func (x *DataStore) GetServingConfigDataStore() *DataStore_ServingConfigDataStore {
	if x != nil {
		return x.ServingConfigDataStore
	}
	return nil
}

// Language info for DataStore.
type LanguageInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The language code for the DataStore.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Output only. This is the normalized form of language_code.
	// E.g.: language_code of `en-GB`, `en_GB`, `en-UK` or `en-gb`
	// will have normalized_language_code of `en-GB`.
	NormalizedLanguageCode string `protobuf:"bytes,2,opt,name=normalized_language_code,json=normalizedLanguageCode,proto3" json:"normalized_language_code,omitempty"`
	// Output only. Language part of normalized_language_code.
	// E.g.: `en-US` -> `en`, `zh-Hans-HK` -> `zh`, `en` -> `en`.
	Language string `protobuf:"bytes,3,opt,name=language,proto3" json:"language,omitempty"`
	// Output only. Region part of normalized_language_code, if present.
	// E.g.: `en-US` -> `US`, `zh-Hans-HK` -> `HK`, `en` -> “.
	Region string `protobuf:"bytes,4,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *LanguageInfo) Reset() {
	*x = LanguageInfo{}
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LanguageInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LanguageInfo) ProtoMessage() {}

func (x *LanguageInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LanguageInfo.ProtoReflect.Descriptor instead.
func (*LanguageInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{1}
}

func (x *LanguageInfo) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *LanguageInfo) GetNormalizedLanguageCode() string {
	if x != nil {
		return x.NormalizedLanguageCode
	}
	return ""
}

func (x *LanguageInfo) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

func (x *LanguageInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// Configuration for Natural Language Query Understanding.
type NaturalLanguageQueryUnderstandingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode of Natural Language Query Understanding. If this field is unset, the
	// behavior defaults to
	// [NaturalLanguageQueryUnderstandingConfig.Mode.DISABLED][google.cloud.discoveryengine.v1beta.NaturalLanguageQueryUnderstandingConfig.Mode.DISABLED].
	Mode NaturalLanguageQueryUnderstandingConfig_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.discoveryengine.v1beta.NaturalLanguageQueryUnderstandingConfig_Mode" json:"mode,omitempty"`
}

func (x *NaturalLanguageQueryUnderstandingConfig) Reset() {
	*x = NaturalLanguageQueryUnderstandingConfig{}
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NaturalLanguageQueryUnderstandingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NaturalLanguageQueryUnderstandingConfig) ProtoMessage() {}

func (x *NaturalLanguageQueryUnderstandingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NaturalLanguageQueryUnderstandingConfig.ProtoReflect.Descriptor instead.
func (*NaturalLanguageQueryUnderstandingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{2}
}

func (x *NaturalLanguageQueryUnderstandingConfig) GetMode() NaturalLanguageQueryUnderstandingConfig_Mode {
	if x != nil {
		return x.Mode
	}
	return NaturalLanguageQueryUnderstandingConfig_MODE_UNSPECIFIED
}

// Config to store data store type configuration for workspace data
type WorkspaceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Workspace data source.
	Type WorkspaceConfig_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.discoveryengine.v1beta.WorkspaceConfig_Type" json:"type,omitempty"`
	// Obfuscated Dasher customer ID.
	DasherCustomerId string `protobuf:"bytes,2,opt,name=dasher_customer_id,json=dasherCustomerId,proto3" json:"dasher_customer_id,omitempty"`
	// Optional. The super admin service account for the workspace that will be
	// used for access token generation. For now we only use it for Native Google
	// Drive connector data ingestion.
	SuperAdminServiceAccount string `protobuf:"bytes,4,opt,name=super_admin_service_account,json=superAdminServiceAccount,proto3" json:"super_admin_service_account,omitempty"`
	// Optional. The super admin email address for the workspace that will be used
	// for access token generation. For now we only use it for Native Google Drive
	// connector data ingestion.
	SuperAdminEmailAddress string `protobuf:"bytes,5,opt,name=super_admin_email_address,json=superAdminEmailAddress,proto3" json:"super_admin_email_address,omitempty"`
}

func (x *WorkspaceConfig) Reset() {
	*x = WorkspaceConfig{}
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkspaceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkspaceConfig) ProtoMessage() {}

func (x *WorkspaceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkspaceConfig.ProtoReflect.Descriptor instead.
func (*WorkspaceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{3}
}

func (x *WorkspaceConfig) GetType() WorkspaceConfig_Type {
	if x != nil {
		return x.Type
	}
	return WorkspaceConfig_TYPE_UNSPECIFIED
}

func (x *WorkspaceConfig) GetDasherCustomerId() string {
	if x != nil {
		return x.DasherCustomerId
	}
	return ""
}

func (x *WorkspaceConfig) GetSuperAdminServiceAccount() string {
	if x != nil {
		return x.SuperAdminServiceAccount
	}
	return ""
}

func (x *WorkspaceConfig) GetSuperAdminEmailAddress() string {
	if x != nil {
		return x.SuperAdminEmailAddress
	}
	return ""
}

// Estimation of data size per data store.
type DataStore_BillingEstimation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data size for structured data in terms of bytes.
	StructuredDataSize int64 `protobuf:"varint,1,opt,name=structured_data_size,json=structuredDataSize,proto3" json:"structured_data_size,omitempty"`
	// Data size for unstructured data in terms of bytes.
	UnstructuredDataSize int64 `protobuf:"varint,2,opt,name=unstructured_data_size,json=unstructuredDataSize,proto3" json:"unstructured_data_size,omitempty"`
	// Data size for websites in terms of bytes.
	WebsiteDataSize int64 `protobuf:"varint,3,opt,name=website_data_size,json=websiteDataSize,proto3" json:"website_data_size,omitempty"`
	// Last updated timestamp for structured data.
	StructuredDataUpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=structured_data_update_time,json=structuredDataUpdateTime,proto3" json:"structured_data_update_time,omitempty"`
	// Last updated timestamp for unstructured data.
	UnstructuredDataUpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=unstructured_data_update_time,json=unstructuredDataUpdateTime,proto3" json:"unstructured_data_update_time,omitempty"`
	// Last updated timestamp for websites.
	WebsiteDataUpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=website_data_update_time,json=websiteDataUpdateTime,proto3" json:"website_data_update_time,omitempty"`
}

func (x *DataStore_BillingEstimation) Reset() {
	*x = DataStore_BillingEstimation{}
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStore_BillingEstimation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStore_BillingEstimation) ProtoMessage() {}

func (x *DataStore_BillingEstimation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStore_BillingEstimation.ProtoReflect.Descriptor instead.
func (*DataStore_BillingEstimation) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{0, 0}
}

func (x *DataStore_BillingEstimation) GetStructuredDataSize() int64 {
	if x != nil {
		return x.StructuredDataSize
	}
	return 0
}

func (x *DataStore_BillingEstimation) GetUnstructuredDataSize() int64 {
	if x != nil {
		return x.UnstructuredDataSize
	}
	return 0
}

func (x *DataStore_BillingEstimation) GetWebsiteDataSize() int64 {
	if x != nil {
		return x.WebsiteDataSize
	}
	return 0
}

func (x *DataStore_BillingEstimation) GetStructuredDataUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StructuredDataUpdateTime
	}
	return nil
}

func (x *DataStore_BillingEstimation) GetUnstructuredDataUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UnstructuredDataUpdateTime
	}
	return nil
}

func (x *DataStore_BillingEstimation) GetWebsiteDataUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.WebsiteDataUpdateTime
	}
	return nil
}

// Stores information regarding the serving configurations at DataStore level.
type DataStore_ServingConfigDataStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set true, the DataStore will not be available for serving search
	// requests.
	DisabledForServing bool `protobuf:"varint,1,opt,name=disabled_for_serving,json=disabledForServing,proto3" json:"disabled_for_serving,omitempty"`
}

func (x *DataStore_ServingConfigDataStore) Reset() {
	*x = DataStore_ServingConfigDataStore{}
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataStore_ServingConfigDataStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataStore_ServingConfigDataStore) ProtoMessage() {}

func (x *DataStore_ServingConfigDataStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataStore_ServingConfigDataStore.ProtoReflect.Descriptor instead.
func (*DataStore_ServingConfigDataStore) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP(), []int{0, 1}
}

func (x *DataStore_ServingConfigDataStore) GetDisabledForServing() bool {
	if x != nil {
		return x.DisabledForServing
	}
	return false
}

var File_google_cloud_discoveryengine_v1beta_data_store_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xfa, 0x10, 0x0a, 0x09, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x67, 0x0a, 0x11, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x56, 0x65, 0x72, 0x74, 0x69,
	0x63, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x10, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74,
	0x72, 0x79, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x49, 0x64, 0x12, 0x68, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x56, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0xaf, 0x01, 0x0a, 0x2b, 0x6e, 0x61,
	0x74, 0x75, 0x72, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x4c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x73,
	0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x27, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x12, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x45,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5f, 0x0a, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x7b, 0x0a, 0x1a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x54, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x85, 0x01, 0x0a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x1a, 0xb6, 0x03,
	0x0a, 0x11, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x12, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x75, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x75, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x77,
	0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x59, 0x0a, 0x1b, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x18, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x1d, 0x75, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x1a, 0x75, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x53, 0x0a, 0x18, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x15, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x4a, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x12, 0x30, 0x0a, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x72,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x46, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x22, 0x7f, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e,
	0x54, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x52,
	0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x55, 0x42,
	0x4c, 0x49, 0x43, 0x5f, 0x57, 0x45, 0x42, 0x53, 0x49, 0x54, 0x45, 0x10, 0x03, 0x12, 0x14, 0x0a,
	0x10, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x10, 0x04, 0x3a, 0xc9, 0x01, 0xea, 0x41, 0xc5, 0x01, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x7d, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x22,
	0xb0, 0x01, 0x0a, 0x0c, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3d, 0x0a, 0x18, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x6e, 0x6f,
	0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x22, 0xc9, 0x01, 0x0a, 0x27, 0x4e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x72,
	0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65,
	0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x37, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0xb0,
	0x03, 0x0a, 0x0f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x61, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64,
	0x61, 0x73, 0x68, 0x65, 0x72, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x42, 0x0a, 0x1b, 0x73, 0x75, 0x70, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x75, 0x70, 0x65, 0x72,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x19, 0x73, 0x75, 0x70, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x73, 0x75, 0x70,
	0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x22, 0x9b, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x44, 0x52, 0x49,
	0x56, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d,
	0x41, 0x49, 0x4c, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f,
	0x53, 0x49, 0x54, 0x45, 0x53, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x4f, 0x4f, 0x47, 0x4c,
	0x45, 0x5f, 0x43, 0x41, 0x4c, 0x45, 0x4e, 0x44, 0x41, 0x52, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b,
	0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x54, 0x10, 0x05, 0x12, 0x11, 0x0a,
	0x0d, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x53, 0x10, 0x06,
	0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4b, 0x45, 0x45, 0x50, 0x10,
	0x07, 0x42, 0x95, 0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62,
	0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e,
	0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_data_store_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_discoveryengine_v1beta_data_store_proto_goTypes = []any{
	(DataStore_ContentConfig)(0),                      // 0: google.cloud.discoveryengine.v1beta.DataStore.ContentConfig
	(NaturalLanguageQueryUnderstandingConfig_Mode)(0), // 1: google.cloud.discoveryengine.v1beta.NaturalLanguageQueryUnderstandingConfig.Mode
	(WorkspaceConfig_Type)(0),                         // 2: google.cloud.discoveryengine.v1beta.WorkspaceConfig.Type
	(*DataStore)(nil),                                 // 3: google.cloud.discoveryengine.v1beta.DataStore
	(*LanguageInfo)(nil),                              // 4: google.cloud.discoveryengine.v1beta.LanguageInfo
	(*NaturalLanguageQueryUnderstandingConfig)(nil),   // 5: google.cloud.discoveryengine.v1beta.NaturalLanguageQueryUnderstandingConfig
	(*WorkspaceConfig)(nil),                           // 6: google.cloud.discoveryengine.v1beta.WorkspaceConfig
	(*DataStore_BillingEstimation)(nil),               // 7: google.cloud.discoveryengine.v1beta.DataStore.BillingEstimation
	(*DataStore_ServingConfigDataStore)(nil),          // 8: google.cloud.discoveryengine.v1beta.DataStore.ServingConfigDataStore
	(IndustryVertical)(0),                             // 9: google.cloud.discoveryengine.v1beta.IndustryVertical
	(SolutionType)(0),                                 // 10: google.cloud.discoveryengine.v1beta.SolutionType
	(*timestamppb.Timestamp)(nil),                     // 11: google.protobuf.Timestamp
	(*DocumentProcessingConfig)(nil),                  // 12: google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
	(*Schema)(nil),                                    // 13: google.cloud.discoveryengine.v1beta.Schema
}
var file_google_cloud_discoveryengine_v1beta_data_store_proto_depIdxs = []int32{
	9,  // 0: google.cloud.discoveryengine.v1beta.DataStore.industry_vertical:type_name -> google.cloud.discoveryengine.v1beta.IndustryVertical
	10, // 1: google.cloud.discoveryengine.v1beta.DataStore.solution_types:type_name -> google.cloud.discoveryengine.v1beta.SolutionType
	0,  // 2: google.cloud.discoveryengine.v1beta.DataStore.content_config:type_name -> google.cloud.discoveryengine.v1beta.DataStore.ContentConfig
	11, // 3: google.cloud.discoveryengine.v1beta.DataStore.create_time:type_name -> google.protobuf.Timestamp
	4,  // 4: google.cloud.discoveryengine.v1beta.DataStore.language_info:type_name -> google.cloud.discoveryengine.v1beta.LanguageInfo
	5,  // 5: google.cloud.discoveryengine.v1beta.DataStore.natural_language_query_understanding_config:type_name -> google.cloud.discoveryengine.v1beta.NaturalLanguageQueryUnderstandingConfig
	7,  // 6: google.cloud.discoveryengine.v1beta.DataStore.billing_estimation:type_name -> google.cloud.discoveryengine.v1beta.DataStore.BillingEstimation
	6,  // 7: google.cloud.discoveryengine.v1beta.DataStore.workspace_config:type_name -> google.cloud.discoveryengine.v1beta.WorkspaceConfig
	12, // 8: google.cloud.discoveryengine.v1beta.DataStore.document_processing_config:type_name -> google.cloud.discoveryengine.v1beta.DocumentProcessingConfig
	13, // 9: google.cloud.discoveryengine.v1beta.DataStore.starting_schema:type_name -> google.cloud.discoveryengine.v1beta.Schema
	8,  // 10: google.cloud.discoveryengine.v1beta.DataStore.serving_config_data_store:type_name -> google.cloud.discoveryengine.v1beta.DataStore.ServingConfigDataStore
	1,  // 11: google.cloud.discoveryengine.v1beta.NaturalLanguageQueryUnderstandingConfig.mode:type_name -> google.cloud.discoveryengine.v1beta.NaturalLanguageQueryUnderstandingConfig.Mode
	2,  // 12: google.cloud.discoveryengine.v1beta.WorkspaceConfig.type:type_name -> google.cloud.discoveryengine.v1beta.WorkspaceConfig.Type
	11, // 13: google.cloud.discoveryengine.v1beta.DataStore.BillingEstimation.structured_data_update_time:type_name -> google.protobuf.Timestamp
	11, // 14: google.cloud.discoveryengine.v1beta.DataStore.BillingEstimation.unstructured_data_update_time:type_name -> google.protobuf.Timestamp
	11, // 15: google.cloud.discoveryengine.v1beta.DataStore.BillingEstimation.website_data_update_time:type_name -> google.protobuf.Timestamp
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_data_store_proto_init() }
func file_google_cloud_discoveryengine_v1beta_data_store_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_data_store_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_common_proto_init()
	file_google_cloud_discoveryengine_v1beta_document_processing_config_proto_init()
	file_google_cloud_discoveryengine_v1beta_schema_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_data_store_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_data_store_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1beta_data_store_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_data_store_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_data_store_proto = out.File
	file_google_cloud_discoveryengine_v1beta_data_store_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_data_store_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_data_store_proto_depIdxs = nil
}
