// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1/document_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of the [Document][google.cloud.discoveryengine.v1.Document].
type BatchGetDocumentsMetadataResponse_State int32

const (
	// Should never be set.
	BatchGetDocumentsMetadataResponse_STATE_UNSPECIFIED BatchGetDocumentsMetadataResponse_State = 0
	// The [Document][google.cloud.discoveryengine.v1.Document] is indexed.
	BatchGetDocumentsMetadataResponse_INDEXED BatchGetDocumentsMetadataResponse_State = 1
	// The [Document][google.cloud.discoveryengine.v1.Document] is not indexed
	// because its URI is not in the
	// [TargetSite][google.cloud.discoveryengine.v1.TargetSite].
	BatchGetDocumentsMetadataResponse_NOT_IN_TARGET_SITE BatchGetDocumentsMetadataResponse_State = 2
	// The [Document][google.cloud.discoveryengine.v1.Document] is not indexed.
	BatchGetDocumentsMetadataResponse_NOT_IN_INDEX BatchGetDocumentsMetadataResponse_State = 3
)

// Enum value maps for BatchGetDocumentsMetadataResponse_State.
var (
	BatchGetDocumentsMetadataResponse_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INDEXED",
		2: "NOT_IN_TARGET_SITE",
		3: "NOT_IN_INDEX",
	}
	BatchGetDocumentsMetadataResponse_State_value = map[string]int32{
		"STATE_UNSPECIFIED":  0,
		"INDEXED":            1,
		"NOT_IN_TARGET_SITE": 2,
		"NOT_IN_INDEX":       3,
	}
)

func (x BatchGetDocumentsMetadataResponse_State) Enum() *BatchGetDocumentsMetadataResponse_State {
	p := new(BatchGetDocumentsMetadataResponse_State)
	*p = x
	return p
}

func (x BatchGetDocumentsMetadataResponse_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchGetDocumentsMetadataResponse_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1_document_service_proto_enumTypes[0].Descriptor()
}

func (BatchGetDocumentsMetadataResponse_State) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1_document_service_proto_enumTypes[0]
}

func (x BatchGetDocumentsMetadataResponse_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchGetDocumentsMetadataResponse_State.Descriptor instead.
func (BatchGetDocumentsMetadataResponse_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{7, 0}
}

// Request message for
// [DocumentService.GetDocument][google.cloud.discoveryengine.v1.DocumentService.GetDocument]
// method.
type GetDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [Document][google.cloud.discoveryengine.v1.Document], such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
	//
	// If the caller does not have permission to access the
	// [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
	// or not it exists, a `PERMISSION_DENIED` error is returned.
	//
	// If the requested [Document][google.cloud.discoveryengine.v1.Document] does
	// not exist, a `NOT_FOUND` error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDocumentRequest) Reset() {
	*x = GetDocumentRequest{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDocumentRequest) ProtoMessage() {}

func (x *GetDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDocumentRequest.ProtoReflect.Descriptor instead.
func (*GetDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetDocumentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments]
// method.
type ListDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent branch resource name, such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
	// Use `default_branch` as the branch ID, to list documents under the default
	// branch.
	//
	// If the caller does not have permission to list
	// [Document][google.cloud.discoveryengine.v1.Document]s under this branch,
	// regardless of whether or not this branch exists, a `PERMISSION_DENIED`
	// error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of [Document][google.cloud.discoveryengine.v1.Document]s to
	// return. If unspecified, defaults to 100. The maximum allowed value is 1000.
	// Values above 1000 are set to 1000.
	//
	// If this field is negative, an `INVALID_ARGUMENT` error is returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token
	// [ListDocumentsResponse.next_page_token][google.cloud.discoveryengine.v1.ListDocumentsResponse.next_page_token],
	// received from a previous
	// [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments]
	// must match the call that provided the page token. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDocumentsRequest) Reset() {
	*x = ListDocumentsRequest{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsRequest) ProtoMessage() {}

func (x *ListDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListDocumentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDocumentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDocumentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments]
// method.
type ListDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [Document][google.cloud.discoveryengine.v1.Document]s.
	Documents []*Document `protobuf:"bytes,1,rep,name=documents,proto3" json:"documents,omitempty"`
	// A token that can be sent as
	// [ListDocumentsRequest.page_token][google.cloud.discoveryengine.v1.ListDocumentsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDocumentsResponse) Reset() {
	*x = ListDocumentsResponse{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsResponse) ProtoMessage() {}

func (x *ListDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListDocumentsResponse) GetDocuments() []*Document {
	if x != nil {
		return x.Documents
	}
	return nil
}

func (x *ListDocumentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [DocumentService.CreateDocument][google.cloud.discoveryengine.v1.DocumentService.CreateDocument]
// method.
type CreateDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name, such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [Document][google.cloud.discoveryengine.v1.Document] to
	// create.
	Document *Document `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
	// Required. The ID to use for the
	// [Document][google.cloud.discoveryengine.v1.Document], which becomes the
	// final component of the
	// [Document.name][google.cloud.discoveryengine.v1.Document.name].
	//
	// If the caller does not have permission to create the
	// [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
	// or not it exists, a `PERMISSION_DENIED` error is returned.
	//
	// This field must be unique among all
	// [Document][google.cloud.discoveryengine.v1.Document]s with the same
	// [parent][google.cloud.discoveryengine.v1.CreateDocumentRequest.parent].
	// Otherwise, an `ALREADY_EXISTS` error is returned.
	//
	// This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
	// standard with a length limit of 63 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	DocumentId string `protobuf:"bytes,3,opt,name=document_id,json=documentId,proto3" json:"document_id,omitempty"`
}

func (x *CreateDocumentRequest) Reset() {
	*x = CreateDocumentRequest{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDocumentRequest) ProtoMessage() {}

func (x *CreateDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDocumentRequest.ProtoReflect.Descriptor instead.
func (*CreateDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateDocumentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDocumentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *CreateDocumentRequest) GetDocumentId() string {
	if x != nil {
		return x.DocumentId
	}
	return ""
}

// Request message for
// [DocumentService.UpdateDocument][google.cloud.discoveryengine.v1.DocumentService.UpdateDocument]
// method.
type UpdateDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The document to update/create.
	//
	// If the caller does not have permission to update the
	// [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
	// or not it exists, a `PERMISSION_DENIED` error is returned.
	//
	// If the [Document][google.cloud.discoveryengine.v1.Document] to update does
	// not exist and
	// [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
	// is not set, a `NOT_FOUND` error is returned.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// If set to `true` and the
	// [Document][google.cloud.discoveryengine.v1.Document] is not found, a new
	// [Document][google.cloud.discoveryengine.v1.Document] is be created.
	AllowMissing bool `protobuf:"varint,2,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Indicates which fields in the provided imported 'document' to update. If
	// not set, by default updates all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDocumentRequest) Reset() {
	*x = UpdateDocumentRequest{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDocumentRequest) ProtoMessage() {}

func (x *UpdateDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDocumentRequest.ProtoReflect.Descriptor instead.
func (*UpdateDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateDocumentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *UpdateDocumentRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateDocumentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DocumentService.DeleteDocument][google.cloud.discoveryengine.v1.DocumentService.DeleteDocument]
// method.
type DeleteDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [Document][google.cloud.discoveryengine.v1.Document], such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
	//
	// If the caller does not have permission to delete the
	// [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
	// or not it exists, a `PERMISSION_DENIED` error is returned.
	//
	// If the [Document][google.cloud.discoveryengine.v1.Document] to delete does
	// not exist, a `NOT_FOUND` error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDocumentRequest) Reset() {
	*x = DeleteDocumentRequest{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentRequest) ProtoMessage() {}

func (x *DeleteDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentRequest.ProtoReflect.Descriptor instead.
func (*DeleteDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteDocumentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [DocumentService.BatchGetDocumentsMetadata][google.cloud.discoveryengine.v1.DocumentService.BatchGetDocumentsMetadata]
// method.
type BatchGetDocumentsMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent branch resource name, such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Matcher for the
	// [Document][google.cloud.discoveryengine.v1.Document]s.
	Matcher *BatchGetDocumentsMetadataRequest_Matcher `protobuf:"bytes,2,opt,name=matcher,proto3" json:"matcher,omitempty"`
}

func (x *BatchGetDocumentsMetadataRequest) Reset() {
	*x = BatchGetDocumentsMetadataRequest{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetDocumentsMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsMetadataRequest) ProtoMessage() {}

func (x *BatchGetDocumentsMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsMetadataRequest.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{6}
}

func (x *BatchGetDocumentsMetadataRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetDocumentsMetadataRequest) GetMatcher() *BatchGetDocumentsMetadataRequest_Matcher {
	if x != nil {
		return x.Matcher
	}
	return nil
}

// Response message for
// [DocumentService.BatchGetDocumentsMetadata][google.cloud.discoveryengine.v1.DocumentService.BatchGetDocumentsMetadata]
// method.
type BatchGetDocumentsMetadataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata of the [Document][google.cloud.discoveryengine.v1.Document]s.
	DocumentsMetadata []*BatchGetDocumentsMetadataResponse_DocumentMetadata `protobuf:"bytes,1,rep,name=documents_metadata,json=documentsMetadata,proto3" json:"documents_metadata,omitempty"`
}

func (x *BatchGetDocumentsMetadataResponse) Reset() {
	*x = BatchGetDocumentsMetadataResponse{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetDocumentsMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsMetadataResponse) ProtoMessage() {}

func (x *BatchGetDocumentsMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsMetadataResponse.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsMetadataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{7}
}

func (x *BatchGetDocumentsMetadataResponse) GetDocumentsMetadata() []*BatchGetDocumentsMetadataResponse_DocumentMetadata {
	if x != nil {
		return x.DocumentsMetadata
	}
	return nil
}

// Matcher for the [Document][google.cloud.discoveryengine.v1.Document]s by
// exact uris.
type BatchGetDocumentsMetadataRequest_UrisMatcher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exact URIs to match by.
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
}

func (x *BatchGetDocumentsMetadataRequest_UrisMatcher) Reset() {
	*x = BatchGetDocumentsMetadataRequest_UrisMatcher{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetDocumentsMetadataRequest_UrisMatcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsMetadataRequest_UrisMatcher) ProtoMessage() {}

func (x *BatchGetDocumentsMetadataRequest_UrisMatcher) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsMetadataRequest_UrisMatcher.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsMetadataRequest_UrisMatcher) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *BatchGetDocumentsMetadataRequest_UrisMatcher) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

// Matcher for the [Document][google.cloud.discoveryengine.v1.Document]s by
// FHIR resource names.
type BatchGetDocumentsMetadataRequest_FhirMatcher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The FHIR resources to match by.
	// Format:
	// projects/{project}/locations/{location}/datasets/{dataset}/fhirStores/{fhir_store}/fhir/{resource_type}/{fhir_resource_id}
	FhirResources []string `protobuf:"bytes,1,rep,name=fhir_resources,json=fhirResources,proto3" json:"fhir_resources,omitempty"`
}

func (x *BatchGetDocumentsMetadataRequest_FhirMatcher) Reset() {
	*x = BatchGetDocumentsMetadataRequest_FhirMatcher{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetDocumentsMetadataRequest_FhirMatcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsMetadataRequest_FhirMatcher) ProtoMessage() {}

func (x *BatchGetDocumentsMetadataRequest_FhirMatcher) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsMetadataRequest_FhirMatcher.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsMetadataRequest_FhirMatcher) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{6, 1}
}

func (x *BatchGetDocumentsMetadataRequest_FhirMatcher) GetFhirResources() []string {
	if x != nil {
		return x.FhirResources
	}
	return nil
}

// Matcher for the [Document][google.cloud.discoveryengine.v1.Document]s.
// Currently supports matching by exact URIs.
type BatchGetDocumentsMetadataRequest_Matcher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Matcher for the [Document][google.cloud.discoveryengine.v1.Document]s.
	//
	// Types that are assignable to Matcher:
	//
	//	*BatchGetDocumentsMetadataRequest_Matcher_UrisMatcher
	//	*BatchGetDocumentsMetadataRequest_Matcher_FhirMatcher
	Matcher isBatchGetDocumentsMetadataRequest_Matcher_Matcher `protobuf_oneof:"matcher"`
}

func (x *BatchGetDocumentsMetadataRequest_Matcher) Reset() {
	*x = BatchGetDocumentsMetadataRequest_Matcher{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetDocumentsMetadataRequest_Matcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsMetadataRequest_Matcher) ProtoMessage() {}

func (x *BatchGetDocumentsMetadataRequest_Matcher) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsMetadataRequest_Matcher.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsMetadataRequest_Matcher) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{6, 2}
}

func (m *BatchGetDocumentsMetadataRequest_Matcher) GetMatcher() isBatchGetDocumentsMetadataRequest_Matcher_Matcher {
	if m != nil {
		return m.Matcher
	}
	return nil
}

func (x *BatchGetDocumentsMetadataRequest_Matcher) GetUrisMatcher() *BatchGetDocumentsMetadataRequest_UrisMatcher {
	if x, ok := x.GetMatcher().(*BatchGetDocumentsMetadataRequest_Matcher_UrisMatcher); ok {
		return x.UrisMatcher
	}
	return nil
}

func (x *BatchGetDocumentsMetadataRequest_Matcher) GetFhirMatcher() *BatchGetDocumentsMetadataRequest_FhirMatcher {
	if x, ok := x.GetMatcher().(*BatchGetDocumentsMetadataRequest_Matcher_FhirMatcher); ok {
		return x.FhirMatcher
	}
	return nil
}

type isBatchGetDocumentsMetadataRequest_Matcher_Matcher interface {
	isBatchGetDocumentsMetadataRequest_Matcher_Matcher()
}

type BatchGetDocumentsMetadataRequest_Matcher_UrisMatcher struct {
	// Matcher by exact URIs.
	UrisMatcher *BatchGetDocumentsMetadataRequest_UrisMatcher `protobuf:"bytes,1,opt,name=uris_matcher,json=urisMatcher,proto3,oneof"`
}

type BatchGetDocumentsMetadataRequest_Matcher_FhirMatcher struct {
	// Matcher by FHIR resource names.
	FhirMatcher *BatchGetDocumentsMetadataRequest_FhirMatcher `protobuf:"bytes,2,opt,name=fhir_matcher,json=fhirMatcher,proto3,oneof"`
}

func (*BatchGetDocumentsMetadataRequest_Matcher_UrisMatcher) isBatchGetDocumentsMetadataRequest_Matcher_Matcher() {
}

func (*BatchGetDocumentsMetadataRequest_Matcher_FhirMatcher) isBatchGetDocumentsMetadataRequest_Matcher_Matcher() {
}

// The metadata of a [Document][google.cloud.discoveryengine.v1.Document].
type BatchGetDocumentsMetadataResponse_DocumentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the matcher that was used to match the
	// [Document][google.cloud.discoveryengine.v1.Document].
	MatcherValue *BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue `protobuf:"bytes,2,opt,name=matcher_value,json=matcherValue,proto3" json:"matcher_value,omitempty"`
	// The state of the document.
	State BatchGetDocumentsMetadataResponse_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse_State" json:"state,omitempty"`
	// The timestamp of the last time the
	// [Document][google.cloud.discoveryengine.v1.Document] was last indexed.
	LastRefreshedTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_refreshed_time,json=lastRefreshedTime,proto3" json:"last_refreshed_time,omitempty"`
	// The data ingestion source of the
	// [Document][google.cloud.discoveryengine.v1.Document].
	//
	// Allowed values are:
	//
	// * `batch`: Data ingested via Batch API, e.g., ImportDocuments.
	// * `streaming` Data ingested via Streaming API, e.g., FHIR streaming.
	DataIngestionSource string `protobuf:"bytes,5,opt,name=data_ingestion_source,json=dataIngestionSource,proto3" json:"data_ingestion_source,omitempty"`
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata) Reset() {
	*x = BatchGetDocumentsMetadataResponse_DocumentMetadata{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsMetadataResponse_DocumentMetadata) ProtoMessage() {}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsMetadataResponse_DocumentMetadata.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsMetadataResponse_DocumentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{7, 0}
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata) GetMatcherValue() *BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue {
	if x != nil {
		return x.MatcherValue
	}
	return nil
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata) GetState() BatchGetDocumentsMetadataResponse_State {
	if x != nil {
		return x.State
	}
	return BatchGetDocumentsMetadataResponse_STATE_UNSPECIFIED
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata) GetLastRefreshedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastRefreshedTime
	}
	return nil
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata) GetDataIngestionSource() string {
	if x != nil {
		return x.DataIngestionSource
	}
	return ""
}

// The value of the matcher that was used to match the
// [Document][google.cloud.discoveryengine.v1.Document].
type BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the matcher that was used to match the
	// [Document][google.cloud.discoveryengine.v1.Document].
	//
	// Types that are assignable to MatcherValue:
	//
	//	*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_Uri
	//	*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_FhirResource
	MatcherValue isBatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_MatcherValue `protobuf_oneof:"matcher_value"`
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue) Reset() {
	*x = BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue{}
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue) ProtoMessage() {}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue.ProtoReflect.Descriptor instead.
func (*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP(), []int{7, 0, 0}
}

func (m *BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue) GetMatcherValue() isBatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_MatcherValue {
	if m != nil {
		return m.MatcherValue
	}
	return nil
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue) GetUri() string {
	if x, ok := x.GetMatcherValue().(*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue) GetFhirResource() string {
	if x, ok := x.GetMatcherValue().(*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_FhirResource); ok {
		return x.FhirResource
	}
	return ""
}

type isBatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_MatcherValue interface {
	isBatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_MatcherValue()
}

type BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_Uri struct {
	// If match by URI, the URI of the
	// [Document][google.cloud.discoveryengine.v1.Document].
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_FhirResource struct {
	// Format:
	// projects/{project}/locations/{location}/datasets/{dataset}/fhirStores/{fhir_store}/fhir/{resource_type}/{fhir_resource_id}
	FhirResource string `protobuf:"bytes,2,opt,name=fhir_resource,json=fhirResource,proto3,oneof"`
}

func (*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_Uri) isBatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_MatcherValue() {
}

func (*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_FhirResource) isBatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_MatcherValue() {
}

var File_google_cloud_discoveryengine_v1_document_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1_document_service_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x59, 0x0a, 0x12, 0x47, 0x65,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x88, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x09, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd0, 0x01, 0x0a,
	0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22,
	0xc5, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5c, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdb, 0x04, 0x0a, 0x20, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47,
	0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x68, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x1a, 0x21, 0x0a, 0x0b, 0x55,
	0x72, 0x69, 0x73, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x72,
	0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x1a, 0x64,
	0x0a, 0x0b, 0x46, 0x68, 0x69, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x55, 0x0a,
	0x0e, 0x66, 0x68, 0x69, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x68, 0x69, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0d, 0x66, 0x68, 0x69, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x1a, 0xfc, 0x01, 0x0a, 0x07, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x12, 0x72, 0x0a, 0x0c, 0x75, 0x72, 0x69, 0x73, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55, 0x72, 0x69, 0x73, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x72, 0x69, 0x73, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x12, 0x72, 0x0a, 0x0c, 0x66, 0x68, 0x69, 0x72, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x68,
	0x69, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x66, 0x68, 0x69,
	0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x22, 0x86, 0x06, 0x0a, 0x21, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x12, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x84,
	0x04, 0x0a, 0x10, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x85, 0x01, 0x0a, 0x0d, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x60, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x5e, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4a, 0x0a, 0x13, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73,
	0x68, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x87, 0x01, 0x0a, 0x0c,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x52, 0x0a, 0x0d, 0x66, 0x68, 0x69, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x68, 0x69, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x68, 0x69, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x55, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x54, 0x41, 0x52,
	0x47, 0x45, 0x54, 0x5f, 0x53, 0x49, 0x54, 0x45, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f,
	0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x10, 0x03, 0x32, 0x9d, 0x16, 0x0a,
	0x0f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x9c, 0x02, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0xac, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9e,
	0x01, 0x5a, 0x55, 0x12, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xaf, 0x02, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xae, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x9e, 0x01, 0x5a, 0x55, 0x12, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xcd, 0x02, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xd7, 0x01, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb2, 0x01, 0x3a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5a, 0x5f, 0x3a, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xd8, 0x02, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xe2, 0x01, 0xda, 0x41, 0x14, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc4, 0x01, 0x3a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x5a, 0x68, 0x3a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x5c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x4e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8f, 0x02, 0x0a,
	0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0xac, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9e, 0x01,
	0x5a, 0x55, 0x2a, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9a,
	0x03, 0x0a, 0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xae, 0x02, 0xca, 0x41, 0x72,
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb2, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5f, 0x3a, 0x01,
	0x2a, 0x22, 0x5a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x4c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x94, 0x03, 0x0a, 0x0e,
	0x50, 0x75, 0x72, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaa, 0x02, 0xca, 0x41, 0x70, 0x0a, 0x36, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x72,
	0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xb0, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5e, 0x3a, 0x01, 0x2a, 0x22, 0x59, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a,
	0x70, 0x75, 0x72, 0x67, 0x65, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x72,
	0x67, 0x65, 0x12, 0xf3, 0x02, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xce, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbe, 0x01, 0x5a, 0x65, 0x12, 0x63, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x55, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x87, 0x02, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49,
	0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1_document_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1_document_service_proto_rawDescData = file_google_cloud_discoveryengine_v1_document_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1_document_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1_document_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1_document_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1_document_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1_document_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1_document_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_discoveryengine_v1_document_service_proto_goTypes = []any{
	(BatchGetDocumentsMetadataResponse_State)(0),                            // 0: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.State
	(*GetDocumentRequest)(nil),                                              // 1: google.cloud.discoveryengine.v1.GetDocumentRequest
	(*ListDocumentsRequest)(nil),                                            // 2: google.cloud.discoveryengine.v1.ListDocumentsRequest
	(*ListDocumentsResponse)(nil),                                           // 3: google.cloud.discoveryengine.v1.ListDocumentsResponse
	(*CreateDocumentRequest)(nil),                                           // 4: google.cloud.discoveryengine.v1.CreateDocumentRequest
	(*UpdateDocumentRequest)(nil),                                           // 5: google.cloud.discoveryengine.v1.UpdateDocumentRequest
	(*DeleteDocumentRequest)(nil),                                           // 6: google.cloud.discoveryengine.v1.DeleteDocumentRequest
	(*BatchGetDocumentsMetadataRequest)(nil),                                // 7: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest
	(*BatchGetDocumentsMetadataResponse)(nil),                               // 8: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse
	(*BatchGetDocumentsMetadataRequest_UrisMatcher)(nil),                    // 9: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.UrisMatcher
	(*BatchGetDocumentsMetadataRequest_FhirMatcher)(nil),                    // 10: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.FhirMatcher
	(*BatchGetDocumentsMetadataRequest_Matcher)(nil),                        // 11: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.Matcher
	(*BatchGetDocumentsMetadataResponse_DocumentMetadata)(nil),              // 12: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.DocumentMetadata
	(*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue)(nil), // 13: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue
	(*Document)(nil),                                                        // 14: google.cloud.discoveryengine.v1.Document
	(*fieldmaskpb.FieldMask)(nil),                                           // 15: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                                           // 16: google.protobuf.Timestamp
	(*ImportDocumentsRequest)(nil),                                          // 17: google.cloud.discoveryengine.v1.ImportDocumentsRequest
	(*PurgeDocumentsRequest)(nil),                                           // 18: google.cloud.discoveryengine.v1.PurgeDocumentsRequest
	(*emptypb.Empty)(nil),                                                   // 19: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                                         // 20: google.longrunning.Operation
}
var file_google_cloud_discoveryengine_v1_document_service_proto_depIdxs = []int32{
	14, // 0: google.cloud.discoveryengine.v1.ListDocumentsResponse.documents:type_name -> google.cloud.discoveryengine.v1.Document
	14, // 1: google.cloud.discoveryengine.v1.CreateDocumentRequest.document:type_name -> google.cloud.discoveryengine.v1.Document
	14, // 2: google.cloud.discoveryengine.v1.UpdateDocumentRequest.document:type_name -> google.cloud.discoveryengine.v1.Document
	15, // 3: google.cloud.discoveryengine.v1.UpdateDocumentRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 4: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.matcher:type_name -> google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.Matcher
	12, // 5: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.documents_metadata:type_name -> google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.DocumentMetadata
	9,  // 6: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.Matcher.uris_matcher:type_name -> google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.UrisMatcher
	10, // 7: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.Matcher.fhir_matcher:type_name -> google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest.FhirMatcher
	13, // 8: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.DocumentMetadata.matcher_value:type_name -> google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue
	0,  // 9: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.DocumentMetadata.state:type_name -> google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.State
	16, // 10: google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse.DocumentMetadata.last_refreshed_time:type_name -> google.protobuf.Timestamp
	1,  // 11: google.cloud.discoveryengine.v1.DocumentService.GetDocument:input_type -> google.cloud.discoveryengine.v1.GetDocumentRequest
	2,  // 12: google.cloud.discoveryengine.v1.DocumentService.ListDocuments:input_type -> google.cloud.discoveryengine.v1.ListDocumentsRequest
	4,  // 13: google.cloud.discoveryengine.v1.DocumentService.CreateDocument:input_type -> google.cloud.discoveryengine.v1.CreateDocumentRequest
	5,  // 14: google.cloud.discoveryengine.v1.DocumentService.UpdateDocument:input_type -> google.cloud.discoveryengine.v1.UpdateDocumentRequest
	6,  // 15: google.cloud.discoveryengine.v1.DocumentService.DeleteDocument:input_type -> google.cloud.discoveryengine.v1.DeleteDocumentRequest
	17, // 16: google.cloud.discoveryengine.v1.DocumentService.ImportDocuments:input_type -> google.cloud.discoveryengine.v1.ImportDocumentsRequest
	18, // 17: google.cloud.discoveryengine.v1.DocumentService.PurgeDocuments:input_type -> google.cloud.discoveryengine.v1.PurgeDocumentsRequest
	7,  // 18: google.cloud.discoveryengine.v1.DocumentService.BatchGetDocumentsMetadata:input_type -> google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataRequest
	14, // 19: google.cloud.discoveryengine.v1.DocumentService.GetDocument:output_type -> google.cloud.discoveryengine.v1.Document
	3,  // 20: google.cloud.discoveryengine.v1.DocumentService.ListDocuments:output_type -> google.cloud.discoveryengine.v1.ListDocumentsResponse
	14, // 21: google.cloud.discoveryengine.v1.DocumentService.CreateDocument:output_type -> google.cloud.discoveryengine.v1.Document
	14, // 22: google.cloud.discoveryengine.v1.DocumentService.UpdateDocument:output_type -> google.cloud.discoveryengine.v1.Document
	19, // 23: google.cloud.discoveryengine.v1.DocumentService.DeleteDocument:output_type -> google.protobuf.Empty
	20, // 24: google.cloud.discoveryengine.v1.DocumentService.ImportDocuments:output_type -> google.longrunning.Operation
	20, // 25: google.cloud.discoveryengine.v1.DocumentService.PurgeDocuments:output_type -> google.longrunning.Operation
	8,  // 26: google.cloud.discoveryengine.v1.DocumentService.BatchGetDocumentsMetadata:output_type -> google.cloud.discoveryengine.v1.BatchGetDocumentsMetadataResponse
	19, // [19:27] is the sub-list for method output_type
	11, // [11:19] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1_document_service_proto_init() }
func file_google_cloud_discoveryengine_v1_document_service_proto_init() {
	if File_google_cloud_discoveryengine_v1_document_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1_document_proto_init()
	file_google_cloud_discoveryengine_v1_import_config_proto_init()
	file_google_cloud_discoveryengine_v1_purge_config_proto_init()
	file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[10].OneofWrappers = []any{
		(*BatchGetDocumentsMetadataRequest_Matcher_UrisMatcher)(nil),
		(*BatchGetDocumentsMetadataRequest_Matcher_FhirMatcher)(nil),
	}
	file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes[12].OneofWrappers = []any{
		(*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_Uri)(nil),
		(*BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_FhirResource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1_document_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1_document_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1_document_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1_document_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1_document_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1_document_service_proto = out.File
	file_google_cloud_discoveryengine_v1_document_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1_document_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1_document_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentServiceClient is the client API for DocumentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentServiceClient interface {
	// Gets a [Document][google.cloud.discoveryengine.v1.Document].
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Gets a list of [Document][google.cloud.discoveryengine.v1.Document]s.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Creates a [Document][google.cloud.discoveryengine.v1.Document].
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Updates a [Document][google.cloud.discoveryengine.v1.Document].
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Deletes a [Document][google.cloud.discoveryengine.v1.Document].
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Bulk import of multiple
	// [Document][google.cloud.discoveryengine.v1.Document]s. Request processing
	// may be synchronous. Non-existing items are created.
	//
	// Note: It is possible for a subset of the
	// [Document][google.cloud.discoveryengine.v1.Document]s to be successfully
	// updated.
	ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Permanently deletes all selected
	// [Document][google.cloud.discoveryengine.v1.Document]s in a branch.
	//
	// This process is asynchronous. Depending on the number of
	// [Document][google.cloud.discoveryengine.v1.Document]s to be deleted, this
	// operation can take hours to complete. Before the delete operation
	// completes, some [Document][google.cloud.discoveryengine.v1.Document]s might
	// still be returned by
	// [DocumentService.GetDocument][google.cloud.discoveryengine.v1.DocumentService.GetDocument]
	// or
	// [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments].
	//
	// To get a list of the [Document][google.cloud.discoveryengine.v1.Document]s
	// to be deleted, set
	// [PurgeDocumentsRequest.force][google.cloud.discoveryengine.v1.PurgeDocumentsRequest.force]
	// to false.
	PurgeDocuments(ctx context.Context, in *PurgeDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets index freshness metadata for
	// [Document][google.cloud.discoveryengine.v1.Document]s. Supported for
	// website search only.
	BatchGetDocumentsMetadata(ctx context.Context, in *BatchGetDocumentsMetadataRequest, opts ...grpc.CallOption) (*BatchGetDocumentsMetadataResponse, error)
}

type documentServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentServiceClient(cc grpc.ClientConnInterface) DocumentServiceClient {
	return &documentServiceClient{cc}
}

func (c *documentServiceClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.DocumentService/GetDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.DocumentService/ListDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.DocumentService/CreateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.DocumentService/UpdateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.DocumentService/DeleteDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.DocumentService/ImportDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) PurgeDocuments(ctx context.Context, in *PurgeDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.DocumentService/PurgeDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentServiceClient) BatchGetDocumentsMetadata(ctx context.Context, in *BatchGetDocumentsMetadataRequest, opts ...grpc.CallOption) (*BatchGetDocumentsMetadataResponse, error) {
	out := new(BatchGetDocumentsMetadataResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1.DocumentService/BatchGetDocumentsMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentServiceServer is the server API for DocumentService service.
type DocumentServiceServer interface {
	// Gets a [Document][google.cloud.discoveryengine.v1.Document].
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Gets a list of [Document][google.cloud.discoveryengine.v1.Document]s.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Creates a [Document][google.cloud.discoveryengine.v1.Document].
	CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error)
	// Updates a [Document][google.cloud.discoveryengine.v1.Document].
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error)
	// Deletes a [Document][google.cloud.discoveryengine.v1.Document].
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error)
	// Bulk import of multiple
	// [Document][google.cloud.discoveryengine.v1.Document]s. Request processing
	// may be synchronous. Non-existing items are created.
	//
	// Note: It is possible for a subset of the
	// [Document][google.cloud.discoveryengine.v1.Document]s to be successfully
	// updated.
	ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error)
	// Permanently deletes all selected
	// [Document][google.cloud.discoveryengine.v1.Document]s in a branch.
	//
	// This process is asynchronous. Depending on the number of
	// [Document][google.cloud.discoveryengine.v1.Document]s to be deleted, this
	// operation can take hours to complete. Before the delete operation
	// completes, some [Document][google.cloud.discoveryengine.v1.Document]s might
	// still be returned by
	// [DocumentService.GetDocument][google.cloud.discoveryengine.v1.DocumentService.GetDocument]
	// or
	// [DocumentService.ListDocuments][google.cloud.discoveryengine.v1.DocumentService.ListDocuments].
	//
	// To get a list of the [Document][google.cloud.discoveryengine.v1.Document]s
	// to be deleted, set
	// [PurgeDocumentsRequest.force][google.cloud.discoveryengine.v1.PurgeDocumentsRequest.force]
	// to false.
	PurgeDocuments(context.Context, *PurgeDocumentsRequest) (*longrunningpb.Operation, error)
	// Gets index freshness metadata for
	// [Document][google.cloud.discoveryengine.v1.Document]s. Supported for
	// website search only.
	BatchGetDocumentsMetadata(context.Context, *BatchGetDocumentsMetadataRequest) (*BatchGetDocumentsMetadataResponse, error)
}

// UnimplementedDocumentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentServiceServer struct {
}

func (*UnimplementedDocumentServiceServer) GetDocument(context.Context, *GetDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (*UnimplementedDocumentServiceServer) ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (*UnimplementedDocumentServiceServer) CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDocument not implemented")
}
func (*UnimplementedDocumentServiceServer) UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDocument not implemented")
}
func (*UnimplementedDocumentServiceServer) DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDocument not implemented")
}
func (*UnimplementedDocumentServiceServer) ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportDocuments not implemented")
}
func (*UnimplementedDocumentServiceServer) PurgeDocuments(context.Context, *PurgeDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeDocuments not implemented")
}
func (*UnimplementedDocumentServiceServer) BatchGetDocumentsMetadata(context.Context, *BatchGetDocumentsMetadataRequest) (*BatchGetDocumentsMetadataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetDocumentsMetadata not implemented")
}

func RegisterDocumentServiceServer(s *grpc.Server, srv DocumentServiceServer) {
	s.RegisterService(&_DocumentService_serviceDesc, srv)
}

func _DocumentService_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.DocumentService/GetDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.DocumentService/ListDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.DocumentService/CreateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.DocumentService/UpdateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.DocumentService/DeleteDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_ImportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).ImportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.DocumentService/ImportDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).ImportDocuments(ctx, req.(*ImportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_PurgeDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).PurgeDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.DocumentService/PurgeDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).PurgeDocuments(ctx, req.(*PurgeDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentService_BatchGetDocumentsMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetDocumentsMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentServiceServer).BatchGetDocumentsMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1.DocumentService/BatchGetDocumentsMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentServiceServer).BatchGetDocumentsMetadata(ctx, req.(*BatchGetDocumentsMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1.DocumentService",
	HandlerType: (*DocumentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDocument",
			Handler:    _DocumentService_GetDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _DocumentService_ListDocuments_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _DocumentService_CreateDocument_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _DocumentService_UpdateDocument_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _DocumentService_DeleteDocument_Handler,
		},
		{
			MethodName: "ImportDocuments",
			Handler:    _DocumentService_ImportDocuments_Handler,
		},
		{
			MethodName: "PurgeDocuments",
			Handler:    _DocumentService_PurgeDocuments_Handler,
		},
		{
			MethodName: "BatchGetDocumentsMetadata",
			Handler:    _DocumentService_BatchGetDocumentsMetadata_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1/document_service.proto",
}
