// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/commerce/consumer/procurement/v1/procurement_service.proto

package procurementpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the auto renewal behavior customer specifies on subscription.
type AutoRenewalBehavior int32

const (
	// If unspecified, the auto renewal behavior will follow the default config.
	AutoRenewalBehavior_AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED AutoRenewalBehavior = 0
	// Auto Renewal will be enabled on subscription.
	AutoRenewalBehavior_AUTO_RENEWAL_BEHAVIOR_ENABLE AutoRenewalBehavior = 1
	// Auto Renewal will be disabled on subscription.
	AutoRenewalBehavior_AUTO_RENEWAL_BEHAVIOR_DISABLE AutoRenewalBehavior = 2
)

// Enum value maps for AutoRenewalBehavior.
var (
	AutoRenewalBehavior_name = map[int32]string{
		0: "AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED",
		1: "AUTO_RENEWAL_BEHAVIOR_ENABLE",
		2: "AUTO_RENEWAL_BEHAVIOR_DISABLE",
	}
	AutoRenewalBehavior_value = map[string]int32{
		"AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED": 0,
		"AUTO_RENEWAL_BEHAVIOR_ENABLE":      1,
		"AUTO_RENEWAL_BEHAVIOR_DISABLE":     2,
	}
)

func (x AutoRenewalBehavior) Enum() *AutoRenewalBehavior {
	p := new(AutoRenewalBehavior)
	*p = x
	return p
}

func (x AutoRenewalBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoRenewalBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_enumTypes[0].Descriptor()
}

func (AutoRenewalBehavior) Type() protoreflect.EnumType {
	return &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_enumTypes[0]
}

func (x AutoRenewalBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoRenewalBehavior.Descriptor instead.
func (AutoRenewalBehavior) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{0}
}

// Indicates the cancellation policy the customer uses to cancel the order.
type CancelOrderRequest_CancellationPolicy int32

const (
	// If unspecified, cancellation will try to cancel the order, if order
	// cannot be immediately cancelled, auto renewal will be turned off.
	// However, caller should avoid using the value as it will yield a
	// non-deterministic result. This is still supported mainly to maintain
	// existing integrated usages and ensure backwards compatibility.
	CancelOrderRequest_CANCELLATION_POLICY_UNSPECIFIED CancelOrderRequest_CancellationPolicy = 0
	// Request will cancel the whole order immediately, if order cannot be
	// immediately cancelled, the request will fail.
	CancelOrderRequest_CANCELLATION_POLICY_CANCEL_IMMEDIATELY CancelOrderRequest_CancellationPolicy = 1
	// Request will cancel the auto renewal, if order is not subscription based,
	// the request will fail.
	CancelOrderRequest_CANCELLATION_POLICY_CANCEL_AT_TERM_END CancelOrderRequest_CancellationPolicy = 2
)

// Enum value maps for CancelOrderRequest_CancellationPolicy.
var (
	CancelOrderRequest_CancellationPolicy_name = map[int32]string{
		0: "CANCELLATION_POLICY_UNSPECIFIED",
		1: "CANCELLATION_POLICY_CANCEL_IMMEDIATELY",
		2: "CANCELLATION_POLICY_CANCEL_AT_TERM_END",
	}
	CancelOrderRequest_CancellationPolicy_value = map[string]int32{
		"CANCELLATION_POLICY_UNSPECIFIED":        0,
		"CANCELLATION_POLICY_CANCEL_IMMEDIATELY": 1,
		"CANCELLATION_POLICY_CANCEL_AT_TERM_END": 2,
	}
)

func (x CancelOrderRequest_CancellationPolicy) Enum() *CancelOrderRequest_CancellationPolicy {
	p := new(CancelOrderRequest_CancellationPolicy)
	*p = x
	return p
}

func (x CancelOrderRequest_CancellationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CancelOrderRequest_CancellationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_enumTypes[1].Descriptor()
}

func (CancelOrderRequest_CancellationPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_enumTypes[1]
}

func (x CancelOrderRequest_CancellationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CancelOrderRequest_CancellationPolicy.Descriptor instead.
func (CancelOrderRequest_CancellationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{7, 0}
}

// Request message for
// [ConsumerProcurementService.PlaceOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.PlaceOrder].
type PlaceOrderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent resource.
	// This field has the form  `billingAccounts/{billing-account-id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-specified name of the order being placed.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Places order for offer. Required when an offer-based order is
	// being placed.
	LineItemInfo []*LineItemInfo `protobuf:"bytes,10,rep,name=line_item_info,json=lineItemInfo,proto3" json:"line_item_info,omitempty"`
	// Optional. A unique identifier for this request.
	// The server will ignore subsequent requests that provide a duplicate request
	// ID for at least 24 hours after the first request.
	//
	// The request ID must be a valid
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Format).
	RequestId string `protobuf:"bytes,7,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *PlaceOrderRequest) Reset() {
	*x = PlaceOrderRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaceOrderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaceOrderRequest) ProtoMessage() {}

func (x *PlaceOrderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaceOrderRequest.ProtoReflect.Descriptor instead.
func (*PlaceOrderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{0}
}

func (x *PlaceOrderRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *PlaceOrderRequest) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PlaceOrderRequest) GetLineItemInfo() []*LineItemInfo {
	if x != nil {
		return x.LineItemInfo
	}
	return nil
}

func (x *PlaceOrderRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message stored in the metadata field of the Operation returned by
// [ConsumerProcurementService.PlaceOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.PlaceOrder].
type PlaceOrderMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PlaceOrderMetadata) Reset() {
	*x = PlaceOrderMetadata{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaceOrderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaceOrderMetadata) ProtoMessage() {}

func (x *PlaceOrderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaceOrderMetadata.ProtoReflect.Descriptor instead.
func (*PlaceOrderMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{1}
}

// Request message for
// [ConsumerProcurementService.GetOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.GetOrder]
type GetOrderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the order to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOrderRequest) Reset() {
	*x = GetOrderRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrderRequest) ProtoMessage() {}

func (x *GetOrderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOrderRequest.ProtoReflect.Descriptor instead.
func (*GetOrderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetOrderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ConsumerProcurementService.ListOrders][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.ListOrders].
type ListOrdersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource to query for orders.
	// This field has the form `billingAccounts/{billing-account-id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of entries requested.
	// The default page size is 25 and the maximum page size is 200.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token for fetching the next page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter that you can use to limit the list request.
	//
	// A query string that can match a selected set of attributes
	// with string values. For example, `display_name=abc`.
	// Supported query attributes are
	//
	// * `display_name`
	//
	// If the query contains special characters other than letters,
	// underscore, or digits, the phrase must be quoted with double quotes. For
	// example, `display_name="foo:bar"`, where the display name needs to be
	// quoted because it contains special character colon.
	//
	// Queries can be combined with `OR`, and `NOT` to form more complex queries.
	// You can also group them to force a desired evaluation order.
	// For example, `display_name=abc OR display_name=def`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListOrdersRequest) Reset() {
	*x = ListOrdersRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrdersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrdersRequest) ProtoMessage() {}

func (x *ListOrdersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrdersRequest.ProtoReflect.Descriptor instead.
func (*ListOrdersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListOrdersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOrdersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOrdersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOrdersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [ConsumerProcurementService.ListOrders][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.ListOrders].
type ListOrdersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of orders in this response.
	Orders []*Order `protobuf:"bytes,1,rep,name=orders,proto3" json:"orders,omitempty"`
	// The token for fetching the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOrdersResponse) Reset() {
	*x = ListOrdersResponse{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrdersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrdersResponse) ProtoMessage() {}

func (x *ListOrdersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrdersResponse.ProtoReflect.Descriptor instead.
func (*ListOrdersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListOrdersResponse) GetOrders() []*Order {
	if x != nil {
		return x.Orders
	}
	return nil
}

func (x *ListOrdersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [ConsumerProcurementService.ModifyOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.ModifyOrder].
type ModifyOrderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the order to update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Modifications for an existing Order created by an Offer.
	// Required when Offer based Order is being modified, except for when going
	// from an offer to a public plan.
	Modifications []*ModifyOrderRequest_Modification `protobuf:"bytes,6,rep,name=modifications,proto3" json:"modifications,omitempty"`
	// Optional. Updated display name of the order, leave as empty if you do not
	// want to update current display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The weak etag, which can be optionally populated, of the order
	// that this modify request is based on. Validation checking will only happen
	// if the invoker supplies this field.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *ModifyOrderRequest) Reset() {
	*x = ModifyOrderRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModifyOrderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyOrderRequest) ProtoMessage() {}

func (x *ModifyOrderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyOrderRequest.ProtoReflect.Descriptor instead.
func (*ModifyOrderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{5}
}

func (x *ModifyOrderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModifyOrderRequest) GetModifications() []*ModifyOrderRequest_Modification {
	if x != nil {
		return x.Modifications
	}
	return nil
}

func (x *ModifyOrderRequest) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ModifyOrderRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Message stored in the metadata field of the Operation returned by
// [ConsumerProcurementService.ModifyOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.ModifyOrder].
type ModifyOrderMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ModifyOrderMetadata) Reset() {
	*x = ModifyOrderMetadata{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModifyOrderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyOrderMetadata) ProtoMessage() {}

func (x *ModifyOrderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyOrderMetadata.ProtoReflect.Descriptor instead.
func (*ModifyOrderMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{6}
}

// Request message for
// [ConsumerProcurementService.CancelOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.CancelOrder].
type CancelOrderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the order.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The weak etag, which can be optionally populated, of the order
	// that this cancel request is based on. Validation checking will only happen
	// if the invoker supplies this field.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Cancellation policy of this request.
	CancellationPolicy CancelOrderRequest_CancellationPolicy `protobuf:"varint,3,opt,name=cancellation_policy,json=cancellationPolicy,proto3,enum=google.cloud.commerce.consumer.procurement.v1.CancelOrderRequest_CancellationPolicy" json:"cancellation_policy,omitempty"`
}

func (x *CancelOrderRequest) Reset() {
	*x = CancelOrderRequest{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelOrderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelOrderRequest) ProtoMessage() {}

func (x *CancelOrderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelOrderRequest.ProtoReflect.Descriptor instead.
func (*CancelOrderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{7}
}

func (x *CancelOrderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CancelOrderRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *CancelOrderRequest) GetCancellationPolicy() CancelOrderRequest_CancellationPolicy {
	if x != nil {
		return x.CancellationPolicy
	}
	return CancelOrderRequest_CANCELLATION_POLICY_UNSPECIFIED
}

// Message stored in the metadata field of the Operation returned by
// [ConsumerProcurementService.CancelOrder][google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.CancelOrder].
type CancelOrderMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelOrderMetadata) Reset() {
	*x = CancelOrderMetadata{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelOrderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelOrderMetadata) ProtoMessage() {}

func (x *CancelOrderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelOrderMetadata.ProtoReflect.Descriptor instead.
func (*CancelOrderMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{8}
}

// Modifications to make on the order.
type ModifyOrderRequest_Modification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the existing line item to make change to.
	// Required when change type is
	// [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE] or
	// [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_CANCEL].
	LineItemId string `protobuf:"bytes,1,opt,name=line_item_id,json=lineItemId,proto3" json:"line_item_id,omitempty"`
	// Required. Type of change to make.
	ChangeType LineItemChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=google.cloud.commerce.consumer.procurement.v1.LineItemChangeType" json:"change_type,omitempty"`
	// Optional. The line item to update to.
	// Required when change_type is
	// [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_CREATE] or
	// [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE].
	NewLineItemInfo *LineItemInfo `protobuf:"bytes,3,opt,name=new_line_item_info,json=newLineItemInfo,proto3" json:"new_line_item_info,omitempty"`
	// Optional. Auto renewal behavior of the subscription for the update.
	// Applied when change_type is
	// [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE]. Follows plan default
	// config when this field is not specified.
	AutoRenewalBehavior AutoRenewalBehavior `protobuf:"varint,4,opt,name=auto_renewal_behavior,json=autoRenewalBehavior,proto3,enum=google.cloud.commerce.consumer.procurement.v1.AutoRenewalBehavior" json:"auto_renewal_behavior,omitempty"`
}

func (x *ModifyOrderRequest_Modification) Reset() {
	*x = ModifyOrderRequest_Modification{}
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModifyOrderRequest_Modification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyOrderRequest_Modification) ProtoMessage() {}

func (x *ModifyOrderRequest_Modification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyOrderRequest_Modification.ProtoReflect.Descriptor instead.
func (*ModifyOrderRequest_Modification) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ModifyOrderRequest_Modification) GetLineItemId() string {
	if x != nil {
		return x.LineItemId
	}
	return ""
}

func (x *ModifyOrderRequest_Modification) GetChangeType() LineItemChangeType {
	if x != nil {
		return x.ChangeType
	}
	return LineItemChangeType_LINE_ITEM_CHANGE_TYPE_UNSPECIFIED
}

func (x *ModifyOrderRequest_Modification) GetNewLineItemInfo() *LineItemInfo {
	if x != nil {
		return x.NewLineItemInfo
	}
	return nil
}

func (x *ModifyOrderRequest_Modification) GetAutoRenewalBehavior() AutoRenewalBehavior {
	if x != nil {
		return x.AutoRenewalBehavior
	}
	return AutoRenewalBehavior_AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED
}

var File_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto protoreflect.FileDescriptor

var file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDesc = []byte{
	0x0a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x2f, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72,
	0x63, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x93, 0x02, 0x0a, 0x11,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x66, 0x0a, 0x0e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x74,
	0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x6c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x14, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x2a, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8a, 0x01, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4c, 0x0a, 0x06, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x06, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf6, 0x04, 0x0a, 0x12, 0x4d, 0x6f, 0x64, 0x69,
	0x66, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x79, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x64, 0x69, 0x66, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x1a, 0x8a, 0x03, 0x0a, 0x0c, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x6c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x67, 0x0a, 0x0b, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x6d, 0x0a, 0x12, 0x6e, 0x65, 0x77, 0x5f, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x6e, 0x65, 0x77, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x7b, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x6e, 0x65,
	0x77, 0x61, 0x6c, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x42, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x61, 0x75, 0x74,
	0x6f, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x22, 0x15, 0x0a, 0x13, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xe7, 0x02, 0x0a, 0x12, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x12, 0x8a, 0x01, 0x0a, 0x13, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x91, 0x01,
	0x0a, 0x12, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2a, 0x0a, 0x26, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x5f, 0x49, 0x4d, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54,
	0x45, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x2a, 0x0a, 0x26, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x5f, 0x41, 0x54, 0x5f, 0x54, 0x45, 0x52, 0x4d, 0x5f, 0x45, 0x4e, 0x44, 0x10,
	0x02, 0x22, 0x15, 0x0a, 0x13, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2a, 0x81, 0x01, 0x0a, 0x13, 0x41, 0x75, 0x74,
	0x6f, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x12, 0x25, 0x0a, 0x21, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x52, 0x45, 0x4e, 0x45, 0x57, 0x41, 0x4c,
	0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x55, 0x54, 0x4f, 0x5f,
	0x52, 0x45, 0x4e, 0x45, 0x57, 0x41, 0x4c, 0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49, 0x4f, 0x52,
	0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x55, 0x54,
	0x4f, 0x5f, 0x52, 0x45, 0x4e, 0x45, 0x57, 0x41, 0x4c, 0x5f, 0x42, 0x45, 0x48, 0x41, 0x56, 0x49,
	0x4f, 0x52, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x32, 0xe0, 0x08, 0x0a,
	0x1a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc3, 0x01, 0x0a, 0x0a,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72,
	0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x54, 0xca, 0x41, 0x1b,
	0x0a, 0x05, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x12, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x30, 0x3a, 0x01, 0x2a, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x3a, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x12, 0xb6, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x22, 0x34, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc9, 0x01, 0x0a, 0x0a, 0x4c,
	0x69, 0x73, 0x74, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x36,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x12,
	0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x12, 0xc7, 0x01, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x69, 0x66,
	0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x56, 0xca, 0x41, 0x1c, 0x0a, 0x05, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x12, 0x13, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a,
	0x01, 0x2a, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x62, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	0x12, 0xc7, 0x01, 0x0a, 0x0b, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x56, 0xca, 0x41, 0x1c, 0x0a, 0x05, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x13,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a, 0x01, 0x2a, 0x22, 0x2c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x1a, 0x63, 0xca, 0x41, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x9f, 0x02, 0x0a, 0x31, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x72, 0x63, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2f, 0x70,
	0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x70,
	0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xaa, 0x02, 0x2d, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x65, 0x72, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x2d, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6f, 0x6d, 0x6d,
	0x65, 0x72, 0x63, 0x65, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5c, 0x50, 0x72,
	0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x32, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6f,
	0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescOnce sync.Once
	file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescData = file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDesc
)

func file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescGZIP() []byte {
	file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescData)
	})
	return file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDescData
}

var file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_goTypes = []any{
	(AutoRenewalBehavior)(0),                   // 0: google.cloud.commerce.consumer.procurement.v1.AutoRenewalBehavior
	(CancelOrderRequest_CancellationPolicy)(0), // 1: google.cloud.commerce.consumer.procurement.v1.CancelOrderRequest.CancellationPolicy
	(*PlaceOrderRequest)(nil),                  // 2: google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
	(*PlaceOrderMetadata)(nil),                 // 3: google.cloud.commerce.consumer.procurement.v1.PlaceOrderMetadata
	(*GetOrderRequest)(nil),                    // 4: google.cloud.commerce.consumer.procurement.v1.GetOrderRequest
	(*ListOrdersRequest)(nil),                  // 5: google.cloud.commerce.consumer.procurement.v1.ListOrdersRequest
	(*ListOrdersResponse)(nil),                 // 6: google.cloud.commerce.consumer.procurement.v1.ListOrdersResponse
	(*ModifyOrderRequest)(nil),                 // 7: google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest
	(*ModifyOrderMetadata)(nil),                // 8: google.cloud.commerce.consumer.procurement.v1.ModifyOrderMetadata
	(*CancelOrderRequest)(nil),                 // 9: google.cloud.commerce.consumer.procurement.v1.CancelOrderRequest
	(*CancelOrderMetadata)(nil),                // 10: google.cloud.commerce.consumer.procurement.v1.CancelOrderMetadata
	(*ModifyOrderRequest_Modification)(nil),    // 11: google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest.Modification
	(*LineItemInfo)(nil),                       // 12: google.cloud.commerce.consumer.procurement.v1.LineItemInfo
	(*Order)(nil),                              // 13: google.cloud.commerce.consumer.procurement.v1.Order
	(LineItemChangeType)(0),                    // 14: google.cloud.commerce.consumer.procurement.v1.LineItemChangeType
	(*longrunningpb.Operation)(nil),            // 15: google.longrunning.Operation
}
var file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_depIdxs = []int32{
	12, // 0: google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest.line_item_info:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemInfo
	13, // 1: google.cloud.commerce.consumer.procurement.v1.ListOrdersResponse.orders:type_name -> google.cloud.commerce.consumer.procurement.v1.Order
	11, // 2: google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest.modifications:type_name -> google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest.Modification
	1,  // 3: google.cloud.commerce.consumer.procurement.v1.CancelOrderRequest.cancellation_policy:type_name -> google.cloud.commerce.consumer.procurement.v1.CancelOrderRequest.CancellationPolicy
	14, // 4: google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest.Modification.change_type:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemChangeType
	12, // 5: google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest.Modification.new_line_item_info:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemInfo
	0,  // 6: google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest.Modification.auto_renewal_behavior:type_name -> google.cloud.commerce.consumer.procurement.v1.AutoRenewalBehavior
	2,  // 7: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.PlaceOrder:input_type -> google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest
	4,  // 8: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.GetOrder:input_type -> google.cloud.commerce.consumer.procurement.v1.GetOrderRequest
	5,  // 9: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.ListOrders:input_type -> google.cloud.commerce.consumer.procurement.v1.ListOrdersRequest
	7,  // 10: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.ModifyOrder:input_type -> google.cloud.commerce.consumer.procurement.v1.ModifyOrderRequest
	9,  // 11: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.CancelOrder:input_type -> google.cloud.commerce.consumer.procurement.v1.CancelOrderRequest
	15, // 12: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.PlaceOrder:output_type -> google.longrunning.Operation
	13, // 13: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.GetOrder:output_type -> google.cloud.commerce.consumer.procurement.v1.Order
	6,  // 14: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.ListOrders:output_type -> google.cloud.commerce.consumer.procurement.v1.ListOrdersResponse
	15, // 15: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.ModifyOrder:output_type -> google.longrunning.Operation
	15, // 16: google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService.CancelOrder:output_type -> google.longrunning.Operation
	12, // [12:17] is the sub-list for method output_type
	7,  // [7:12] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_init() }
func file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_init() {
	if File_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto != nil {
		return
	}
	file_google_cloud_commerce_consumer_procurement_v1_order_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_msgTypes,
	}.Build()
	File_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto = out.File
	file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_rawDesc = nil
	file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_goTypes = nil
	file_google_cloud_commerce_consumer_procurement_v1_procurement_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConsumerProcurementServiceClient is the client API for ConsumerProcurementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConsumerProcurementServiceClient interface {
	// Creates a new [Order][google.cloud.commerce.consumer.procurement.v1.Order].
	//
	// This API only supports GCP spend-based committed use
	// discounts specified by GCP documentation.
	//
	// The returned long-running operation is in-progress until the backend
	// completes the creation of the resource. Once completed, the order is
	// in
	// [OrderState.ORDER_STATE_ACTIVE][google.cloud.commerce.consumer.procurement.v1.OrderState.ORDER_STATE_ACTIVE].
	// In case of failure, the order resource will be removed.
	PlaceOrder(ctx context.Context, in *PlaceOrderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the requested
	// [Order][google.cloud.commerce.consumer.procurement.v1.Order] resource.
	GetOrder(ctx context.Context, in *GetOrderRequest, opts ...grpc.CallOption) (*Order, error)
	// Lists [Order][google.cloud.commerce.consumer.procurement.v1.Order]
	// resources that the user has access to, within the scope of the parent
	// resource.
	ListOrders(ctx context.Context, in *ListOrdersRequest, opts ...grpc.CallOption) (*ListOrdersResponse, error)
	// Modifies an existing
	// [Order][google.cloud.commerce.consumer.procurement.v1.Order] resource.
	ModifyOrder(ctx context.Context, in *ModifyOrderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels an existing
	// [Order][google.cloud.commerce.consumer.procurement.v1.Order]. Every product
	// procured in the Order will be cancelled.
	CancelOrder(ctx context.Context, in *CancelOrderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type consumerProcurementServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConsumerProcurementServiceClient(cc grpc.ClientConnInterface) ConsumerProcurementServiceClient {
	return &consumerProcurementServiceClient{cc}
}

func (c *consumerProcurementServiceClient) PlaceOrder(ctx context.Context, in *PlaceOrderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/PlaceOrder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumerProcurementServiceClient) GetOrder(ctx context.Context, in *GetOrderRequest, opts ...grpc.CallOption) (*Order, error) {
	out := new(Order)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/GetOrder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumerProcurementServiceClient) ListOrders(ctx context.Context, in *ListOrdersRequest, opts ...grpc.CallOption) (*ListOrdersResponse, error) {
	out := new(ListOrdersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/ListOrders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumerProcurementServiceClient) ModifyOrder(ctx context.Context, in *ModifyOrderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/ModifyOrder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumerProcurementServiceClient) CancelOrder(ctx context.Context, in *CancelOrderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/CancelOrder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConsumerProcurementServiceServer is the server API for ConsumerProcurementService service.
type ConsumerProcurementServiceServer interface {
	// Creates a new [Order][google.cloud.commerce.consumer.procurement.v1.Order].
	//
	// This API only supports GCP spend-based committed use
	// discounts specified by GCP documentation.
	//
	// The returned long-running operation is in-progress until the backend
	// completes the creation of the resource. Once completed, the order is
	// in
	// [OrderState.ORDER_STATE_ACTIVE][google.cloud.commerce.consumer.procurement.v1.OrderState.ORDER_STATE_ACTIVE].
	// In case of failure, the order resource will be removed.
	PlaceOrder(context.Context, *PlaceOrderRequest) (*longrunningpb.Operation, error)
	// Returns the requested
	// [Order][google.cloud.commerce.consumer.procurement.v1.Order] resource.
	GetOrder(context.Context, *GetOrderRequest) (*Order, error)
	// Lists [Order][google.cloud.commerce.consumer.procurement.v1.Order]
	// resources that the user has access to, within the scope of the parent
	// resource.
	ListOrders(context.Context, *ListOrdersRequest) (*ListOrdersResponse, error)
	// Modifies an existing
	// [Order][google.cloud.commerce.consumer.procurement.v1.Order] resource.
	ModifyOrder(context.Context, *ModifyOrderRequest) (*longrunningpb.Operation, error)
	// Cancels an existing
	// [Order][google.cloud.commerce.consumer.procurement.v1.Order]. Every product
	// procured in the Order will be cancelled.
	CancelOrder(context.Context, *CancelOrderRequest) (*longrunningpb.Operation, error)
}

// UnimplementedConsumerProcurementServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConsumerProcurementServiceServer struct {
}

func (*UnimplementedConsumerProcurementServiceServer) PlaceOrder(context.Context, *PlaceOrderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlaceOrder not implemented")
}
func (*UnimplementedConsumerProcurementServiceServer) GetOrder(context.Context, *GetOrderRequest) (*Order, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrder not implemented")
}
func (*UnimplementedConsumerProcurementServiceServer) ListOrders(context.Context, *ListOrdersRequest) (*ListOrdersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrders not implemented")
}
func (*UnimplementedConsumerProcurementServiceServer) ModifyOrder(context.Context, *ModifyOrderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyOrder not implemented")
}
func (*UnimplementedConsumerProcurementServiceServer) CancelOrder(context.Context, *CancelOrderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelOrder not implemented")
}

func RegisterConsumerProcurementServiceServer(s *grpc.Server, srv ConsumerProcurementServiceServer) {
	s.RegisterService(&_ConsumerProcurementService_serviceDesc, srv)
}

func _ConsumerProcurementService_PlaceOrder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlaceOrderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumerProcurementServiceServer).PlaceOrder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/PlaceOrder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumerProcurementServiceServer).PlaceOrder(ctx, req.(*PlaceOrderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumerProcurementService_GetOrder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumerProcurementServiceServer).GetOrder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/GetOrder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumerProcurementServiceServer).GetOrder(ctx, req.(*GetOrderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumerProcurementService_ListOrders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrdersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumerProcurementServiceServer).ListOrders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/ListOrders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumerProcurementServiceServer).ListOrders(ctx, req.(*ListOrdersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumerProcurementService_ModifyOrder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyOrderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumerProcurementServiceServer).ModifyOrder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/ModifyOrder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumerProcurementServiceServer).ModifyOrder(ctx, req.(*ModifyOrderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumerProcurementService_CancelOrder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOrderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumerProcurementServiceServer).CancelOrder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/CancelOrder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumerProcurementServiceServer).CancelOrder(ctx, req.(*CancelOrderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConsumerProcurementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService",
	HandlerType: (*ConsumerProcurementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PlaceOrder",
			Handler:    _ConsumerProcurementService_PlaceOrder_Handler,
		},
		{
			MethodName: "GetOrder",
			Handler:    _ConsumerProcurementService_GetOrder_Handler,
		},
		{
			MethodName: "ListOrders",
			Handler:    _ConsumerProcurementService_ListOrders_Handler,
		},
		{
			MethodName: "ModifyOrder",
			Handler:    _ConsumerProcurementService_ModifyOrder_Handler,
		},
		{
			MethodName: "CancelOrder",
			Handler:    _ConsumerProcurementService_CancelOrder_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/commerce/consumer/procurement/v1/procurement_service.proto",
}
