// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package cloudquotas

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	cloudquotaspb "cloud.google.com/go/cloudquotas/apiv1beta/cloudquotaspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
)

var newQuotaAdjusterSettingsManagerClientHook clientHook

// QuotaAdjusterSettingsManagerCallOptions contains the retry settings for each method of QuotaAdjusterSettingsManagerClient.
type QuotaAdjusterSettingsManagerCallOptions struct {
	UpdateQuotaAdjusterSettings []gax.CallOption
	GetQuotaAdjusterSettings    []gax.CallOption
}

func defaultQuotaAdjusterSettingsManagerGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("cloudquotas.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("cloudquotas.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("cloudquotas.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://cloudquotas.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultQuotaAdjusterSettingsManagerCallOptions() *QuotaAdjusterSettingsManagerCallOptions {
	return &QuotaAdjusterSettingsManagerCallOptions{
		UpdateQuotaAdjusterSettings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetQuotaAdjusterSettings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultQuotaAdjusterSettingsManagerRESTCallOptions() *QuotaAdjusterSettingsManagerCallOptions {
	return &QuotaAdjusterSettingsManagerCallOptions{
		UpdateQuotaAdjusterSettings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetQuotaAdjusterSettings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalQuotaAdjusterSettingsManagerClient is an interface that defines the methods available from Cloud Quotas API.
type internalQuotaAdjusterSettingsManagerClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	UpdateQuotaAdjusterSettings(context.Context, *cloudquotaspb.UpdateQuotaAdjusterSettingsRequest, ...gax.CallOption) (*cloudquotaspb.QuotaAdjusterSettings, error)
	GetQuotaAdjusterSettings(context.Context, *cloudquotaspb.GetQuotaAdjusterSettingsRequest, ...gax.CallOption) (*cloudquotaspb.QuotaAdjusterSettings, error)
}

// QuotaAdjusterSettingsManagerClient is a client for interacting with Cloud Quotas API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The Quotas Adjuster Settings API is an infrastructure service for Google
// Cloud that lets service consumers view and update their quota adjuster
// settings.
//
//	Update quota adjuster settings.
//
//	Get the name of the configurations.
type QuotaAdjusterSettingsManagerClient struct {
	// The internal transport-dependent client.
	internalClient internalQuotaAdjusterSettingsManagerClient

	// The call options for this service.
	CallOptions *QuotaAdjusterSettingsManagerCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *QuotaAdjusterSettingsManagerClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *QuotaAdjusterSettingsManagerClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *QuotaAdjusterSettingsManagerClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// UpdateQuotaAdjusterSettings rPC Method for updating QuotaAdjusterSettings based on the request
func (c *QuotaAdjusterSettingsManagerClient) UpdateQuotaAdjusterSettings(ctx context.Context, req *cloudquotaspb.UpdateQuotaAdjusterSettingsRequest, opts ...gax.CallOption) (*cloudquotaspb.QuotaAdjusterSettings, error) {
	return c.internalClient.UpdateQuotaAdjusterSettings(ctx, req, opts...)
}

// GetQuotaAdjusterSettings rPC Method for getting QuotaAdjusterSettings based on the request
func (c *QuotaAdjusterSettingsManagerClient) GetQuotaAdjusterSettings(ctx context.Context, req *cloudquotaspb.GetQuotaAdjusterSettingsRequest, opts ...gax.CallOption) (*cloudquotaspb.QuotaAdjusterSettings, error) {
	return c.internalClient.GetQuotaAdjusterSettings(ctx, req, opts...)
}

// quotaAdjusterSettingsManagerGRPCClient is a client for interacting with Cloud Quotas API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type quotaAdjusterSettingsManagerGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing QuotaAdjusterSettingsManagerClient
	CallOptions **QuotaAdjusterSettingsManagerCallOptions

	// The gRPC API client.
	quotaAdjusterSettingsManagerClient cloudquotaspb.QuotaAdjusterSettingsManagerClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewQuotaAdjusterSettingsManagerClient creates a new quota adjuster settings manager client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The Quotas Adjuster Settings API is an infrastructure service for Google
// Cloud that lets service consumers view and update their quota adjuster
// settings.
//
//	Update quota adjuster settings.
//
//	Get the name of the configurations.
func NewQuotaAdjusterSettingsManagerClient(ctx context.Context, opts ...option.ClientOption) (*QuotaAdjusterSettingsManagerClient, error) {
	clientOpts := defaultQuotaAdjusterSettingsManagerGRPCClientOptions()
	if newQuotaAdjusterSettingsManagerClientHook != nil {
		hookOpts, err := newQuotaAdjusterSettingsManagerClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := QuotaAdjusterSettingsManagerClient{CallOptions: defaultQuotaAdjusterSettingsManagerCallOptions()}

	c := &quotaAdjusterSettingsManagerGRPCClient{
		connPool:                           connPool,
		quotaAdjusterSettingsManagerClient: cloudquotaspb.NewQuotaAdjusterSettingsManagerClient(connPool),
		CallOptions:                        &client.CallOptions,
		logger:                             internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *quotaAdjusterSettingsManagerGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *quotaAdjusterSettingsManagerGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *quotaAdjusterSettingsManagerGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type quotaAdjusterSettingsManagerRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing QuotaAdjusterSettingsManagerClient
	CallOptions **QuotaAdjusterSettingsManagerCallOptions

	logger *slog.Logger
}

// NewQuotaAdjusterSettingsManagerRESTClient creates a new quota adjuster settings manager rest client.
//
// The Quotas Adjuster Settings API is an infrastructure service for Google
// Cloud that lets service consumers view and update their quota adjuster
// settings.
//
//	Update quota adjuster settings.
//
//	Get the name of the configurations.
func NewQuotaAdjusterSettingsManagerRESTClient(ctx context.Context, opts ...option.ClientOption) (*QuotaAdjusterSettingsManagerClient, error) {
	clientOpts := append(defaultQuotaAdjusterSettingsManagerRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultQuotaAdjusterSettingsManagerRESTCallOptions()
	c := &quotaAdjusterSettingsManagerRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &QuotaAdjusterSettingsManagerClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultQuotaAdjusterSettingsManagerRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://cloudquotas.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://cloudquotas.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://cloudquotas.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://cloudquotas.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *quotaAdjusterSettingsManagerRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *quotaAdjusterSettingsManagerRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *quotaAdjusterSettingsManagerRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *quotaAdjusterSettingsManagerGRPCClient) UpdateQuotaAdjusterSettings(ctx context.Context, req *cloudquotaspb.UpdateQuotaAdjusterSettingsRequest, opts ...gax.CallOption) (*cloudquotaspb.QuotaAdjusterSettings, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "quota_adjuster_settings.name", url.QueryEscape(req.GetQuotaAdjusterSettings().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateQuotaAdjusterSettings[0:len((*c.CallOptions).UpdateQuotaAdjusterSettings):len((*c.CallOptions).UpdateQuotaAdjusterSettings)], opts...)
	var resp *cloudquotaspb.QuotaAdjusterSettings
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.quotaAdjusterSettingsManagerClient.UpdateQuotaAdjusterSettings, req, settings.GRPC, c.logger, "UpdateQuotaAdjusterSettings")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *quotaAdjusterSettingsManagerGRPCClient) GetQuotaAdjusterSettings(ctx context.Context, req *cloudquotaspb.GetQuotaAdjusterSettingsRequest, opts ...gax.CallOption) (*cloudquotaspb.QuotaAdjusterSettings, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetQuotaAdjusterSettings[0:len((*c.CallOptions).GetQuotaAdjusterSettings):len((*c.CallOptions).GetQuotaAdjusterSettings)], opts...)
	var resp *cloudquotaspb.QuotaAdjusterSettings
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.quotaAdjusterSettingsManagerClient.GetQuotaAdjusterSettings, req, settings.GRPC, c.logger, "GetQuotaAdjusterSettings")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// UpdateQuotaAdjusterSettings rPC Method for updating QuotaAdjusterSettings based on the request
func (c *quotaAdjusterSettingsManagerRESTClient) UpdateQuotaAdjusterSettings(ctx context.Context, req *cloudquotaspb.UpdateQuotaAdjusterSettingsRequest, opts ...gax.CallOption) (*cloudquotaspb.QuotaAdjusterSettings, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetQuotaAdjusterSettings()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetQuotaAdjusterSettings().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "quota_adjuster_settings.name", url.QueryEscape(req.GetQuotaAdjusterSettings().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateQuotaAdjusterSettings[0:len((*c.CallOptions).UpdateQuotaAdjusterSettings):len((*c.CallOptions).UpdateQuotaAdjusterSettings)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudquotaspb.QuotaAdjusterSettings{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateQuotaAdjusterSettings")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetQuotaAdjusterSettings rPC Method for getting QuotaAdjusterSettings based on the request
func (c *quotaAdjusterSettingsManagerRESTClient) GetQuotaAdjusterSettings(ctx context.Context, req *cloudquotaspb.GetQuotaAdjusterSettingsRequest, opts ...gax.CallOption) (*cloudquotaspb.QuotaAdjusterSettings, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetQuotaAdjusterSettings[0:len((*c.CallOptions).GetQuotaAdjusterSettings):len((*c.CallOptions).GetQuotaAdjusterSettings)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudquotaspb.QuotaAdjusterSettings{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetQuotaAdjusterSettings")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
