// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package cloudcontrolspartner

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	cloudcontrolspartnerpb "cloud.google.com/go/cloudcontrolspartner/apiv1beta/cloudcontrolspartnerpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newCloudControlsPartnerCoreClientHook clientHook

// CloudControlsPartnerCoreCallOptions contains the retry settings for each method of CloudControlsPartnerCoreClient.
type CloudControlsPartnerCoreCallOptions struct {
	GetWorkload                []gax.CallOption
	ListWorkloads              []gax.CallOption
	GetCustomer                []gax.CallOption
	ListCustomers              []gax.CallOption
	GetEkmConnections          []gax.CallOption
	GetPartnerPermissions      []gax.CallOption
	ListAccessApprovalRequests []gax.CallOption
	GetPartner                 []gax.CallOption
	CreateCustomer             []gax.CallOption
	UpdateCustomer             []gax.CallOption
	DeleteCustomer             []gax.CallOption
}

func defaultCloudControlsPartnerCoreGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("cloudcontrolspartner.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("cloudcontrolspartner.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("cloudcontrolspartner.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://cloudcontrolspartner.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCloudControlsPartnerCoreCallOptions() *CloudControlsPartnerCoreCallOptions {
	return &CloudControlsPartnerCoreCallOptions{
		GetWorkload: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListWorkloads: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetCustomer: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListCustomers: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetEkmConnections: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetPartnerPermissions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListAccessApprovalRequests: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetPartner:     []gax.CallOption{},
		CreateCustomer: []gax.CallOption{},
		UpdateCustomer: []gax.CallOption{},
		DeleteCustomer: []gax.CallOption{},
	}
}

func defaultCloudControlsPartnerCoreRESTCallOptions() *CloudControlsPartnerCoreCallOptions {
	return &CloudControlsPartnerCoreCallOptions{
		GetWorkload: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListWorkloads: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetCustomer: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListCustomers: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetEkmConnections: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetPartnerPermissions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListAccessApprovalRequests: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetPartner:     []gax.CallOption{},
		CreateCustomer: []gax.CallOption{},
		UpdateCustomer: []gax.CallOption{},
		DeleteCustomer: []gax.CallOption{},
	}
}

// internalCloudControlsPartnerCoreClient is an interface that defines the methods available from Cloud Controls Partner API.
type internalCloudControlsPartnerCoreClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetWorkload(context.Context, *cloudcontrolspartnerpb.GetWorkloadRequest, ...gax.CallOption) (*cloudcontrolspartnerpb.Workload, error)
	ListWorkloads(context.Context, *cloudcontrolspartnerpb.ListWorkloadsRequest, ...gax.CallOption) *WorkloadIterator
	GetCustomer(context.Context, *cloudcontrolspartnerpb.GetCustomerRequest, ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error)
	ListCustomers(context.Context, *cloudcontrolspartnerpb.ListCustomersRequest, ...gax.CallOption) *CustomerIterator
	GetEkmConnections(context.Context, *cloudcontrolspartnerpb.GetEkmConnectionsRequest, ...gax.CallOption) (*cloudcontrolspartnerpb.EkmConnections, error)
	GetPartnerPermissions(context.Context, *cloudcontrolspartnerpb.GetPartnerPermissionsRequest, ...gax.CallOption) (*cloudcontrolspartnerpb.PartnerPermissions, error)
	ListAccessApprovalRequests(context.Context, *cloudcontrolspartnerpb.ListAccessApprovalRequestsRequest, ...gax.CallOption) *AccessApprovalRequestIterator
	GetPartner(context.Context, *cloudcontrolspartnerpb.GetPartnerRequest, ...gax.CallOption) (*cloudcontrolspartnerpb.Partner, error)
	CreateCustomer(context.Context, *cloudcontrolspartnerpb.CreateCustomerRequest, ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error)
	UpdateCustomer(context.Context, *cloudcontrolspartnerpb.UpdateCustomerRequest, ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error)
	DeleteCustomer(context.Context, *cloudcontrolspartnerpb.DeleteCustomerRequest, ...gax.CallOption) error
}

// CloudControlsPartnerCoreClient is a client for interacting with Cloud Controls Partner API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service describing handlers for resources
type CloudControlsPartnerCoreClient struct {
	// The internal transport-dependent client.
	internalClient internalCloudControlsPartnerCoreClient

	// The call options for this service.
	CallOptions *CloudControlsPartnerCoreCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *CloudControlsPartnerCoreClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *CloudControlsPartnerCoreClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *CloudControlsPartnerCoreClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetWorkload gets details of a single workload
func (c *CloudControlsPartnerCoreClient) GetWorkload(ctx context.Context, req *cloudcontrolspartnerpb.GetWorkloadRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Workload, error) {
	return c.internalClient.GetWorkload(ctx, req, opts...)
}

// ListWorkloads lists customer workloads for a given customer org id
func (c *CloudControlsPartnerCoreClient) ListWorkloads(ctx context.Context, req *cloudcontrolspartnerpb.ListWorkloadsRequest, opts ...gax.CallOption) *WorkloadIterator {
	return c.internalClient.ListWorkloads(ctx, req, opts...)
}

// GetCustomer gets details of a single customer
func (c *CloudControlsPartnerCoreClient) GetCustomer(ctx context.Context, req *cloudcontrolspartnerpb.GetCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	return c.internalClient.GetCustomer(ctx, req, opts...)
}

// ListCustomers lists customers of a partner identified by its Google Cloud organization ID
func (c *CloudControlsPartnerCoreClient) ListCustomers(ctx context.Context, req *cloudcontrolspartnerpb.ListCustomersRequest, opts ...gax.CallOption) *CustomerIterator {
	return c.internalClient.ListCustomers(ctx, req, opts...)
}

// GetEkmConnections gets the EKM connections associated with a workload
func (c *CloudControlsPartnerCoreClient) GetEkmConnections(ctx context.Context, req *cloudcontrolspartnerpb.GetEkmConnectionsRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.EkmConnections, error) {
	return c.internalClient.GetEkmConnections(ctx, req, opts...)
}

// GetPartnerPermissions gets the partner permissions granted for a workload
func (c *CloudControlsPartnerCoreClient) GetPartnerPermissions(ctx context.Context, req *cloudcontrolspartnerpb.GetPartnerPermissionsRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.PartnerPermissions, error) {
	return c.internalClient.GetPartnerPermissions(ctx, req, opts...)
}

// ListAccessApprovalRequests deprecated: Only returns access approval requests directly associated with
// an assured workload folder.
//
// Deprecated: ListAccessApprovalRequests may be removed in a future version.
func (c *CloudControlsPartnerCoreClient) ListAccessApprovalRequests(ctx context.Context, req *cloudcontrolspartnerpb.ListAccessApprovalRequestsRequest, opts ...gax.CallOption) *AccessApprovalRequestIterator {
	return c.internalClient.ListAccessApprovalRequests(ctx, req, opts...)
}

// GetPartner get details of a Partner.
func (c *CloudControlsPartnerCoreClient) GetPartner(ctx context.Context, req *cloudcontrolspartnerpb.GetPartnerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Partner, error) {
	return c.internalClient.GetPartner(ctx, req, opts...)
}

// CreateCustomer creates a new customer.
func (c *CloudControlsPartnerCoreClient) CreateCustomer(ctx context.Context, req *cloudcontrolspartnerpb.CreateCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	return c.internalClient.CreateCustomer(ctx, req, opts...)
}

// UpdateCustomer update details of a single customer
func (c *CloudControlsPartnerCoreClient) UpdateCustomer(ctx context.Context, req *cloudcontrolspartnerpb.UpdateCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	return c.internalClient.UpdateCustomer(ctx, req, opts...)
}

// DeleteCustomer delete details of a single customer
func (c *CloudControlsPartnerCoreClient) DeleteCustomer(ctx context.Context, req *cloudcontrolspartnerpb.DeleteCustomerRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteCustomer(ctx, req, opts...)
}

// cloudControlsPartnerCoreGRPCClient is a client for interacting with Cloud Controls Partner API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type cloudControlsPartnerCoreGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing CloudControlsPartnerCoreClient
	CallOptions **CloudControlsPartnerCoreCallOptions

	// The gRPC API client.
	cloudControlsPartnerCoreClient cloudcontrolspartnerpb.CloudControlsPartnerCoreClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewCloudControlsPartnerCoreClient creates a new cloud controls partner core client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service describing handlers for resources
func NewCloudControlsPartnerCoreClient(ctx context.Context, opts ...option.ClientOption) (*CloudControlsPartnerCoreClient, error) {
	clientOpts := defaultCloudControlsPartnerCoreGRPCClientOptions()
	if newCloudControlsPartnerCoreClientHook != nil {
		hookOpts, err := newCloudControlsPartnerCoreClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := CloudControlsPartnerCoreClient{CallOptions: defaultCloudControlsPartnerCoreCallOptions()}

	c := &cloudControlsPartnerCoreGRPCClient{
		connPool:                       connPool,
		cloudControlsPartnerCoreClient: cloudcontrolspartnerpb.NewCloudControlsPartnerCoreClient(connPool),
		CallOptions:                    &client.CallOptions,
		logger:                         internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *cloudControlsPartnerCoreGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *cloudControlsPartnerCoreGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *cloudControlsPartnerCoreGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type cloudControlsPartnerCoreRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing CloudControlsPartnerCoreClient
	CallOptions **CloudControlsPartnerCoreCallOptions

	logger *slog.Logger
}

// NewCloudControlsPartnerCoreRESTClient creates a new cloud controls partner core rest client.
//
// Service describing handlers for resources
func NewCloudControlsPartnerCoreRESTClient(ctx context.Context, opts ...option.ClientOption) (*CloudControlsPartnerCoreClient, error) {
	clientOpts := append(defaultCloudControlsPartnerCoreRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultCloudControlsPartnerCoreRESTCallOptions()
	c := &cloudControlsPartnerCoreRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &CloudControlsPartnerCoreClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultCloudControlsPartnerCoreRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://cloudcontrolspartner.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://cloudcontrolspartner.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://cloudcontrolspartner.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://cloudcontrolspartner.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *cloudControlsPartnerCoreRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *cloudControlsPartnerCoreRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *cloudControlsPartnerCoreRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *cloudControlsPartnerCoreGRPCClient) GetWorkload(ctx context.Context, req *cloudcontrolspartnerpb.GetWorkloadRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Workload, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetWorkload[0:len((*c.CallOptions).GetWorkload):len((*c.CallOptions).GetWorkload)], opts...)
	var resp *cloudcontrolspartnerpb.Workload
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.GetWorkload, req, settings.GRPC, c.logger, "GetWorkload")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudControlsPartnerCoreGRPCClient) ListWorkloads(ctx context.Context, req *cloudcontrolspartnerpb.ListWorkloadsRequest, opts ...gax.CallOption) *WorkloadIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListWorkloads[0:len((*c.CallOptions).ListWorkloads):len((*c.CallOptions).ListWorkloads)], opts...)
	it := &WorkloadIterator{}
	req = proto.Clone(req).(*cloudcontrolspartnerpb.ListWorkloadsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*cloudcontrolspartnerpb.Workload, string, error) {
		resp := &cloudcontrolspartnerpb.ListWorkloadsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.ListWorkloads, req, settings.GRPC, c.logger, "ListWorkloads")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetWorkloads(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *cloudControlsPartnerCoreGRPCClient) GetCustomer(ctx context.Context, req *cloudcontrolspartnerpb.GetCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetCustomer[0:len((*c.CallOptions).GetCustomer):len((*c.CallOptions).GetCustomer)], opts...)
	var resp *cloudcontrolspartnerpb.Customer
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.GetCustomer, req, settings.GRPC, c.logger, "GetCustomer")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudControlsPartnerCoreGRPCClient) ListCustomers(ctx context.Context, req *cloudcontrolspartnerpb.ListCustomersRequest, opts ...gax.CallOption) *CustomerIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListCustomers[0:len((*c.CallOptions).ListCustomers):len((*c.CallOptions).ListCustomers)], opts...)
	it := &CustomerIterator{}
	req = proto.Clone(req).(*cloudcontrolspartnerpb.ListCustomersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*cloudcontrolspartnerpb.Customer, string, error) {
		resp := &cloudcontrolspartnerpb.ListCustomersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.ListCustomers, req, settings.GRPC, c.logger, "ListCustomers")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCustomers(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *cloudControlsPartnerCoreGRPCClient) GetEkmConnections(ctx context.Context, req *cloudcontrolspartnerpb.GetEkmConnectionsRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.EkmConnections, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEkmConnections[0:len((*c.CallOptions).GetEkmConnections):len((*c.CallOptions).GetEkmConnections)], opts...)
	var resp *cloudcontrolspartnerpb.EkmConnections
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.GetEkmConnections, req, settings.GRPC, c.logger, "GetEkmConnections")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudControlsPartnerCoreGRPCClient) GetPartnerPermissions(ctx context.Context, req *cloudcontrolspartnerpb.GetPartnerPermissionsRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.PartnerPermissions, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetPartnerPermissions[0:len((*c.CallOptions).GetPartnerPermissions):len((*c.CallOptions).GetPartnerPermissions)], opts...)
	var resp *cloudcontrolspartnerpb.PartnerPermissions
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.GetPartnerPermissions, req, settings.GRPC, c.logger, "GetPartnerPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudControlsPartnerCoreGRPCClient) ListAccessApprovalRequests(ctx context.Context, req *cloudcontrolspartnerpb.ListAccessApprovalRequestsRequest, opts ...gax.CallOption) *AccessApprovalRequestIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListAccessApprovalRequests[0:len((*c.CallOptions).ListAccessApprovalRequests):len((*c.CallOptions).ListAccessApprovalRequests)], opts...)
	it := &AccessApprovalRequestIterator{}
	req = proto.Clone(req).(*cloudcontrolspartnerpb.ListAccessApprovalRequestsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*cloudcontrolspartnerpb.AccessApprovalRequest, string, error) {
		resp := &cloudcontrolspartnerpb.ListAccessApprovalRequestsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.ListAccessApprovalRequests, req, settings.GRPC, c.logger, "ListAccessApprovalRequests")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAccessApprovalRequests(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *cloudControlsPartnerCoreGRPCClient) GetPartner(ctx context.Context, req *cloudcontrolspartnerpb.GetPartnerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Partner, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetPartner[0:len((*c.CallOptions).GetPartner):len((*c.CallOptions).GetPartner)], opts...)
	var resp *cloudcontrolspartnerpb.Partner
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.GetPartner, req, settings.GRPC, c.logger, "GetPartner")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudControlsPartnerCoreGRPCClient) CreateCustomer(ctx context.Context, req *cloudcontrolspartnerpb.CreateCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateCustomer[0:len((*c.CallOptions).CreateCustomer):len((*c.CallOptions).CreateCustomer)], opts...)
	var resp *cloudcontrolspartnerpb.Customer
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.CreateCustomer, req, settings.GRPC, c.logger, "CreateCustomer")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudControlsPartnerCoreGRPCClient) UpdateCustomer(ctx context.Context, req *cloudcontrolspartnerpb.UpdateCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "customer.name", url.QueryEscape(req.GetCustomer().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateCustomer[0:len((*c.CallOptions).UpdateCustomer):len((*c.CallOptions).UpdateCustomer)], opts...)
	var resp *cloudcontrolspartnerpb.Customer
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.UpdateCustomer, req, settings.GRPC, c.logger, "UpdateCustomer")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *cloudControlsPartnerCoreGRPCClient) DeleteCustomer(ctx context.Context, req *cloudcontrolspartnerpb.DeleteCustomerRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteCustomer[0:len((*c.CallOptions).DeleteCustomer):len((*c.CallOptions).DeleteCustomer)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.cloudControlsPartnerCoreClient.DeleteCustomer, req, settings.GRPC, c.logger, "DeleteCustomer")
		return err
	}, opts...)
	return err
}

// GetWorkload gets details of a single workload
func (c *cloudControlsPartnerCoreRESTClient) GetWorkload(ctx context.Context, req *cloudcontrolspartnerpb.GetWorkloadRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Workload, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetWorkload[0:len((*c.CallOptions).GetWorkload):len((*c.CallOptions).GetWorkload)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudcontrolspartnerpb.Workload{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetWorkload")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListWorkloads lists customer workloads for a given customer org id
func (c *cloudControlsPartnerCoreRESTClient) ListWorkloads(ctx context.Context, req *cloudcontrolspartnerpb.ListWorkloadsRequest, opts ...gax.CallOption) *WorkloadIterator {
	it := &WorkloadIterator{}
	req = proto.Clone(req).(*cloudcontrolspartnerpb.ListWorkloadsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*cloudcontrolspartnerpb.Workload, string, error) {
		resp := &cloudcontrolspartnerpb.ListWorkloadsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1beta/%v/workloads", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListWorkloads")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetWorkloads(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetCustomer gets details of a single customer
func (c *cloudControlsPartnerCoreRESTClient) GetCustomer(ctx context.Context, req *cloudcontrolspartnerpb.GetCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetCustomer[0:len((*c.CallOptions).GetCustomer):len((*c.CallOptions).GetCustomer)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudcontrolspartnerpb.Customer{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetCustomer")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListCustomers lists customers of a partner identified by its Google Cloud organization ID
func (c *cloudControlsPartnerCoreRESTClient) ListCustomers(ctx context.Context, req *cloudcontrolspartnerpb.ListCustomersRequest, opts ...gax.CallOption) *CustomerIterator {
	it := &CustomerIterator{}
	req = proto.Clone(req).(*cloudcontrolspartnerpb.ListCustomersRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*cloudcontrolspartnerpb.Customer, string, error) {
		resp := &cloudcontrolspartnerpb.ListCustomersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1beta/%v/customers", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListCustomers")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetCustomers(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetEkmConnections gets the EKM connections associated with a workload
func (c *cloudControlsPartnerCoreRESTClient) GetEkmConnections(ctx context.Context, req *cloudcontrolspartnerpb.GetEkmConnectionsRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.EkmConnections, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEkmConnections[0:len((*c.CallOptions).GetEkmConnections):len((*c.CallOptions).GetEkmConnections)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudcontrolspartnerpb.EkmConnections{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetEkmConnections")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetPartnerPermissions gets the partner permissions granted for a workload
func (c *cloudControlsPartnerCoreRESTClient) GetPartnerPermissions(ctx context.Context, req *cloudcontrolspartnerpb.GetPartnerPermissionsRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.PartnerPermissions, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetPartnerPermissions[0:len((*c.CallOptions).GetPartnerPermissions):len((*c.CallOptions).GetPartnerPermissions)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudcontrolspartnerpb.PartnerPermissions{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetPartnerPermissions")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListAccessApprovalRequests deprecated: Only returns access approval requests directly associated with
// an assured workload folder.
//
// Deprecated: ListAccessApprovalRequests may be removed in a future version.
func (c *cloudControlsPartnerCoreRESTClient) ListAccessApprovalRequests(ctx context.Context, req *cloudcontrolspartnerpb.ListAccessApprovalRequestsRequest, opts ...gax.CallOption) *AccessApprovalRequestIterator {
	it := &AccessApprovalRequestIterator{}
	req = proto.Clone(req).(*cloudcontrolspartnerpb.ListAccessApprovalRequestsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*cloudcontrolspartnerpb.AccessApprovalRequest, string, error) {
		resp := &cloudcontrolspartnerpb.ListAccessApprovalRequestsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1beta/%v/accessApprovalRequests", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAccessApprovalRequests")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAccessApprovalRequests(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetPartner get details of a Partner.
func (c *cloudControlsPartnerCoreRESTClient) GetPartner(ctx context.Context, req *cloudcontrolspartnerpb.GetPartnerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Partner, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetPartner[0:len((*c.CallOptions).GetPartner):len((*c.CallOptions).GetPartner)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudcontrolspartnerpb.Partner{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetPartner")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateCustomer creates a new customer.
func (c *cloudControlsPartnerCoreRESTClient) CreateCustomer(ctx context.Context, req *cloudcontrolspartnerpb.CreateCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCustomer()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v/customers", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("customerId", fmt.Sprintf("%v", req.GetCustomerId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateCustomer[0:len((*c.CallOptions).CreateCustomer):len((*c.CallOptions).CreateCustomer)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudcontrolspartnerpb.Customer{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateCustomer")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateCustomer update details of a single customer
func (c *cloudControlsPartnerCoreRESTClient) UpdateCustomer(ctx context.Context, req *cloudcontrolspartnerpb.UpdateCustomerRequest, opts ...gax.CallOption) (*cloudcontrolspartnerpb.Customer, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCustomer()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetCustomer().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "customer.name", url.QueryEscape(req.GetCustomer().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateCustomer[0:len((*c.CallOptions).UpdateCustomer):len((*c.CallOptions).UpdateCustomer)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &cloudcontrolspartnerpb.Customer{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateCustomer")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteCustomer delete details of a single customer
func (c *cloudControlsPartnerCoreRESTClient) DeleteCustomer(ctx context.Context, req *cloudcontrolspartnerpb.DeleteCustomerRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteCustomer")
		return err
	}, opts...)
}
