// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/bigtable/admin/v2/instance.proto

package adminpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible states of an instance.
type Instance_State int32

const (
	// The state of the instance could not be determined.
	Instance_STATE_NOT_KNOWN Instance_State = 0
	// The instance has been successfully created and can serve requests
	// to its tables.
	Instance_READY Instance_State = 1
	// The instance is currently being created, and may be destroyed
	// if the creation process encounters an error.
	Instance_CREATING Instance_State = 2
)

// Enum value maps for Instance_State.
var (
	Instance_State_name = map[int32]string{
		0: "STATE_NOT_KNOWN",
		1: "READY",
		2: "CREATING",
	}
	Instance_State_value = map[string]int32{
		"STATE_NOT_KNOWN": 0,
		"READY":           1,
		"CREATING":        2,
	}
)

func (x Instance_State) Enum() *Instance_State {
	p := new(Instance_State)
	*p = x
	return p
}

func (x Instance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_admin_v2_instance_proto_enumTypes[0].Descriptor()
}

func (Instance_State) Type() protoreflect.EnumType {
	return &file_google_bigtable_admin_v2_instance_proto_enumTypes[0]
}

func (x Instance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_State.Descriptor instead.
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{0, 0}
}

// The type of the instance.
type Instance_Type int32

const (
	// The type of the instance is unspecified. If set when creating an
	// instance, a `PRODUCTION` instance will be created. If set when updating
	// an instance, the type will be left unchanged.
	Instance_TYPE_UNSPECIFIED Instance_Type = 0
	// An instance meant for production use. `serve_nodes` must be set
	// on the cluster.
	Instance_PRODUCTION Instance_Type = 1
	// DEPRECATED: Prefer PRODUCTION for all use cases, as it no longer enforces
	// a higher minimum node count than DEVELOPMENT.
	Instance_DEVELOPMENT Instance_Type = 2
)

// Enum value maps for Instance_Type.
var (
	Instance_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PRODUCTION",
		2: "DEVELOPMENT",
	}
	Instance_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"PRODUCTION":       1,
		"DEVELOPMENT":      2,
	}
)

func (x Instance_Type) Enum() *Instance_Type {
	p := new(Instance_Type)
	*p = x
	return p
}

func (x Instance_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_admin_v2_instance_proto_enumTypes[1].Descriptor()
}

func (Instance_Type) Type() protoreflect.EnumType {
	return &file_google_bigtable_admin_v2_instance_proto_enumTypes[1]
}

func (x Instance_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_Type.Descriptor instead.
func (Instance_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{0, 1}
}

// Possible states of a cluster.
type Cluster_State int32

const (
	// The state of the cluster could not be determined.
	Cluster_STATE_NOT_KNOWN Cluster_State = 0
	// The cluster has been successfully created and is ready to serve requests.
	Cluster_READY Cluster_State = 1
	// The cluster is currently being created, and may be destroyed
	// if the creation process encounters an error.
	// A cluster may not be able to serve requests while being created.
	Cluster_CREATING Cluster_State = 2
	// The cluster is currently being resized, and may revert to its previous
	// node count if the process encounters an error.
	// A cluster is still capable of serving requests while being resized,
	// but may exhibit performance as if its number of allocated nodes is
	// between the starting and requested states.
	Cluster_RESIZING Cluster_State = 3
	// The cluster has no backing nodes. The data (tables) still
	// exist, but no operations can be performed on the cluster.
	Cluster_DISABLED Cluster_State = 4
)

// Enum value maps for Cluster_State.
var (
	Cluster_State_name = map[int32]string{
		0: "STATE_NOT_KNOWN",
		1: "READY",
		2: "CREATING",
		3: "RESIZING",
		4: "DISABLED",
	}
	Cluster_State_value = map[string]int32{
		"STATE_NOT_KNOWN": 0,
		"READY":           1,
		"CREATING":        2,
		"RESIZING":        3,
		"DISABLED":        4,
	}
)

func (x Cluster_State) Enum() *Cluster_State {
	p := new(Cluster_State)
	*p = x
	return p
}

func (x Cluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_admin_v2_instance_proto_enumTypes[2].Descriptor()
}

func (Cluster_State) Type() protoreflect.EnumType {
	return &file_google_bigtable_admin_v2_instance_proto_enumTypes[2]
}

func (x Cluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_State.Descriptor instead.
func (Cluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{3, 0}
}

// Possible node scaling factors of the clusters. Node scaling delivers better
// latency and more throughput by removing node boundaries.
type Cluster_NodeScalingFactor int32

const (
	// No node scaling specified. Defaults to NODE_SCALING_FACTOR_1X.
	Cluster_NODE_SCALING_FACTOR_UNSPECIFIED Cluster_NodeScalingFactor = 0
	// The cluster is running with a scaling factor of 1.
	Cluster_NODE_SCALING_FACTOR_1X Cluster_NodeScalingFactor = 1
	// The cluster is running with a scaling factor of 2.
	// All node count values must be in increments of 2 with this scaling factor
	// enabled, otherwise an INVALID_ARGUMENT error will be returned.
	Cluster_NODE_SCALING_FACTOR_2X Cluster_NodeScalingFactor = 2
)

// Enum value maps for Cluster_NodeScalingFactor.
var (
	Cluster_NodeScalingFactor_name = map[int32]string{
		0: "NODE_SCALING_FACTOR_UNSPECIFIED",
		1: "NODE_SCALING_FACTOR_1X",
		2: "NODE_SCALING_FACTOR_2X",
	}
	Cluster_NodeScalingFactor_value = map[string]int32{
		"NODE_SCALING_FACTOR_UNSPECIFIED": 0,
		"NODE_SCALING_FACTOR_1X":          1,
		"NODE_SCALING_FACTOR_2X":          2,
	}
)

func (x Cluster_NodeScalingFactor) Enum() *Cluster_NodeScalingFactor {
	p := new(Cluster_NodeScalingFactor)
	*p = x
	return p
}

func (x Cluster_NodeScalingFactor) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_NodeScalingFactor) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_admin_v2_instance_proto_enumTypes[3].Descriptor()
}

func (Cluster_NodeScalingFactor) Type() protoreflect.EnumType {
	return &file_google_bigtable_admin_v2_instance_proto_enumTypes[3]
}

func (x Cluster_NodeScalingFactor) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_NodeScalingFactor.Descriptor instead.
func (Cluster_NodeScalingFactor) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{3, 1}
}

// Possible priorities for an app profile. Note that higher priority writes
// can sometimes queue behind lower priority writes to the same tablet, as
// writes must be strictly sequenced in the durability log.
type AppProfile_Priority int32

const (
	// Default value. Mapped to PRIORITY_HIGH (the legacy behavior) on creation.
	AppProfile_PRIORITY_UNSPECIFIED AppProfile_Priority = 0
	AppProfile_PRIORITY_LOW         AppProfile_Priority = 1
	AppProfile_PRIORITY_MEDIUM      AppProfile_Priority = 2
	AppProfile_PRIORITY_HIGH        AppProfile_Priority = 3
)

// Enum value maps for AppProfile_Priority.
var (
	AppProfile_Priority_name = map[int32]string{
		0: "PRIORITY_UNSPECIFIED",
		1: "PRIORITY_LOW",
		2: "PRIORITY_MEDIUM",
		3: "PRIORITY_HIGH",
	}
	AppProfile_Priority_value = map[string]int32{
		"PRIORITY_UNSPECIFIED": 0,
		"PRIORITY_LOW":         1,
		"PRIORITY_MEDIUM":      2,
		"PRIORITY_HIGH":        3,
	}
)

func (x AppProfile_Priority) Enum() *AppProfile_Priority {
	p := new(AppProfile_Priority)
	*p = x
	return p
}

func (x AppProfile_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppProfile_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_admin_v2_instance_proto_enumTypes[4].Descriptor()
}

func (AppProfile_Priority) Type() protoreflect.EnumType {
	return &file_google_bigtable_admin_v2_instance_proto_enumTypes[4]
}

func (x AppProfile_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppProfile_Priority.Descriptor instead.
func (AppProfile_Priority) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{4, 0}
}

// Compute Billing Owner specifies how usage should be accounted when using
// Data Boost. Compute Billing Owner also configures which Cloud Project is
// charged for relevant quota.
type AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner int32

const (
	// Unspecified value.
	AppProfile_DataBoostIsolationReadOnly_COMPUTE_BILLING_OWNER_UNSPECIFIED AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner = 0
	// The host Cloud Project containing the targeted Bigtable Instance /
	// Table pays for compute.
	AppProfile_DataBoostIsolationReadOnly_HOST_PAYS AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner = 1
)

// Enum value maps for AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner.
var (
	AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner_name = map[int32]string{
		0: "COMPUTE_BILLING_OWNER_UNSPECIFIED",
		1: "HOST_PAYS",
	}
	AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner_value = map[string]int32{
		"COMPUTE_BILLING_OWNER_UNSPECIFIED": 0,
		"HOST_PAYS":                         1,
	}
)

func (x AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner) Enum() *AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner {
	p := new(AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner)
	*p = x
	return p
}

func (x AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_admin_v2_instance_proto_enumTypes[5].Descriptor()
}

func (AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner) Type() protoreflect.EnumType {
	return &file_google_bigtable_admin_v2_instance_proto_enumTypes[5]
}

func (x AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner.Descriptor instead.
func (AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{4, 3, 0}
}

// A collection of Bigtable [Tables][google.bigtable.admin.v2.Table] and
// the resources that serve them.
// All tables in an instance are served from all
// [Clusters][google.bigtable.admin.v2.Cluster] in the instance.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the instance. Values are of the form
	// `projects/{project}/instances/[a-z][a-z0-9\\-]+[a-z0-9]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The descriptive name for this instance as it appears in UIs.
	// Can be changed at any time, but should be kept globally unique
	// to avoid confusion.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The current state of the instance.
	State Instance_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.bigtable.admin.v2.Instance_State" json:"state,omitempty"`
	// The type of the instance. Defaults to `PRODUCTION`.
	Type Instance_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.bigtable.admin.v2.Instance_Type" json:"type,omitempty"`
	// Labels are a flexible and lightweight mechanism for organizing cloud
	// resources into groups that reflect a customer's organizational needs and
	// deployment strategies. They can be used to filter resources and aggregate
	// metrics.
	//
	//   - Label keys must be between 1 and 63 characters long and must conform to
	//     the regular expression: `[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}`.
	//   - Label values must be between 0 and 63 characters long and must conform to
	//     the regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`.
	//   - No more than 64 labels can be associated with a given resource.
	//   - Keys and values must both be under 128 bytes.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. A commit timestamp representing when this Instance was
	// created. For instances created before this field was added (August 2021),
	// this value is `seconds: 0, nanos: 1`.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs *bool `protobuf:"varint,8,opt,name=satisfies_pzs,json=satisfiesPzs,proto3,oneof" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi *bool `protobuf:"varint,11,opt,name=satisfies_pzi,json=satisfiesPzi,proto3,oneof" json:"satisfies_pzi,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{0}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Instance) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Instance) GetState() Instance_State {
	if x != nil {
		return x.State
	}
	return Instance_STATE_NOT_KNOWN
}

func (x *Instance) GetType() Instance_Type {
	if x != nil {
		return x.Type
	}
	return Instance_TYPE_UNSPECIFIED
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetSatisfiesPzs() bool {
	if x != nil && x.SatisfiesPzs != nil {
		return *x.SatisfiesPzs
	}
	return false
}

func (x *Instance) GetSatisfiesPzi() bool {
	if x != nil && x.SatisfiesPzi != nil {
		return *x.SatisfiesPzi
	}
	return false
}

// The Autoscaling targets for a Cluster. These determine the recommended nodes.
type AutoscalingTargets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cpu utilization that the Autoscaler should be trying to achieve.
	// This number is on a scale from 0 (no utilization) to
	// 100 (total utilization), and is limited between 10 and 80, otherwise it
	// will return INVALID_ARGUMENT error.
	CpuUtilizationPercent int32 `protobuf:"varint,2,opt,name=cpu_utilization_percent,json=cpuUtilizationPercent,proto3" json:"cpu_utilization_percent,omitempty"`
	// The storage utilization that the Autoscaler should be trying to achieve.
	// This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD
	// cluster and between 8192 (8TiB) and 16384 (16TiB) for an HDD cluster,
	// otherwise it will return INVALID_ARGUMENT error. If this value is set to 0,
	// it will be treated as if it were set to the default value: 2560 for SSD,
	// 8192 for HDD.
	StorageUtilizationGibPerNode int32 `protobuf:"varint,3,opt,name=storage_utilization_gib_per_node,json=storageUtilizationGibPerNode,proto3" json:"storage_utilization_gib_per_node,omitempty"`
}

func (x *AutoscalingTargets) Reset() {
	*x = AutoscalingTargets{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingTargets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingTargets) ProtoMessage() {}

func (x *AutoscalingTargets) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingTargets.ProtoReflect.Descriptor instead.
func (*AutoscalingTargets) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{1}
}

func (x *AutoscalingTargets) GetCpuUtilizationPercent() int32 {
	if x != nil {
		return x.CpuUtilizationPercent
	}
	return 0
}

func (x *AutoscalingTargets) GetStorageUtilizationGibPerNode() int32 {
	if x != nil {
		return x.StorageUtilizationGibPerNode
	}
	return 0
}

// Limits for the number of nodes a Cluster can autoscale up/down to.
type AutoscalingLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Minimum number of nodes to scale down to.
	MinServeNodes int32 `protobuf:"varint,1,opt,name=min_serve_nodes,json=minServeNodes,proto3" json:"min_serve_nodes,omitempty"`
	// Required. Maximum number of nodes to scale up to.
	MaxServeNodes int32 `protobuf:"varint,2,opt,name=max_serve_nodes,json=maxServeNodes,proto3" json:"max_serve_nodes,omitempty"`
}

func (x *AutoscalingLimits) Reset() {
	*x = AutoscalingLimits{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingLimits) ProtoMessage() {}

func (x *AutoscalingLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingLimits.ProtoReflect.Descriptor instead.
func (*AutoscalingLimits) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{2}
}

func (x *AutoscalingLimits) GetMinServeNodes() int32 {
	if x != nil {
		return x.MinServeNodes
	}
	return 0
}

func (x *AutoscalingLimits) GetMaxServeNodes() int32 {
	if x != nil {
		return x.MaxServeNodes
	}
	return 0
}

// A resizable group of nodes in a particular cloud location, capable
// of serving all [Tables][google.bigtable.admin.v2.Table] in the parent
// [Instance][google.bigtable.admin.v2.Instance].
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the cluster. Values are of the form
	// `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The location where this cluster's nodes and storage reside. For
	// best performance, clients should be located as close as possible to this
	// cluster. Currently only zones are supported, so values should be of the
	// form `projects/{project}/locations/{zone}`.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Output only. The current state of the cluster.
	State Cluster_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.bigtable.admin.v2.Cluster_State" json:"state,omitempty"`
	// The number of nodes in the cluster. If no value is set,
	// Cloud Bigtable automatically allocates nodes based on your data footprint
	// and optimized for 50% storage utilization.
	ServeNodes int32 `protobuf:"varint,4,opt,name=serve_nodes,json=serveNodes,proto3" json:"serve_nodes,omitempty"`
	// Immutable. The node scaling factor of this cluster.
	NodeScalingFactor Cluster_NodeScalingFactor `protobuf:"varint,9,opt,name=node_scaling_factor,json=nodeScalingFactor,proto3,enum=google.bigtable.admin.v2.Cluster_NodeScalingFactor" json:"node_scaling_factor,omitempty"`
	// Types that are assignable to Config:
	//
	//	*Cluster_ClusterConfig_
	Config isCluster_Config `protobuf_oneof:"config"`
	// Immutable. The type of storage used by this cluster to serve its
	// parent instance's tables, unless explicitly overridden.
	DefaultStorageType StorageType `protobuf:"varint,5,opt,name=default_storage_type,json=defaultStorageType,proto3,enum=google.bigtable.admin.v2.StorageType" json:"default_storage_type,omitempty"`
	// Immutable. The encryption configuration for CMEK-protected clusters.
	EncryptionConfig *Cluster_EncryptionConfig `protobuf:"bytes,6,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{3}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Cluster) GetState() Cluster_State {
	if x != nil {
		return x.State
	}
	return Cluster_STATE_NOT_KNOWN
}

func (x *Cluster) GetServeNodes() int32 {
	if x != nil {
		return x.ServeNodes
	}
	return 0
}

func (x *Cluster) GetNodeScalingFactor() Cluster_NodeScalingFactor {
	if x != nil {
		return x.NodeScalingFactor
	}
	return Cluster_NODE_SCALING_FACTOR_UNSPECIFIED
}

func (m *Cluster) GetConfig() isCluster_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *Cluster) GetClusterConfig() *Cluster_ClusterConfig {
	if x, ok := x.GetConfig().(*Cluster_ClusterConfig_); ok {
		return x.ClusterConfig
	}
	return nil
}

func (x *Cluster) GetDefaultStorageType() StorageType {
	if x != nil {
		return x.DefaultStorageType
	}
	return StorageType_STORAGE_TYPE_UNSPECIFIED
}

func (x *Cluster) GetEncryptionConfig() *Cluster_EncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

type isCluster_Config interface {
	isCluster_Config()
}

type Cluster_ClusterConfig_ struct {
	// Configuration for this cluster.
	ClusterConfig *Cluster_ClusterConfig `protobuf:"bytes,7,opt,name=cluster_config,json=clusterConfig,proto3,oneof"`
}

func (*Cluster_ClusterConfig_) isCluster_Config() {}

// A configuration object describing how Cloud Bigtable should treat traffic
// from a particular end user application.
type AppProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the app profile. Values are of the form
	// `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Strongly validated etag for optimistic concurrency control. Preserve the
	// value returned from `GetAppProfile` when calling `UpdateAppProfile` to
	// fail the request if there has been a modification in the mean time. The
	// `update_mask` of the request need not include `etag` for this protection
	// to apply.
	// See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
	// [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
	// details.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Long form description of the use case for this AppProfile.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The routing policy for all read/write requests that use this app profile.
	// A value must be explicitly set.
	//
	// Types that are assignable to RoutingPolicy:
	//
	//	*AppProfile_MultiClusterRoutingUseAny_
	//	*AppProfile_SingleClusterRouting_
	RoutingPolicy isAppProfile_RoutingPolicy `protobuf_oneof:"routing_policy"`
	// Options for isolating this app profile's traffic from other use cases.
	//
	// Types that are assignable to Isolation:
	//
	//	*AppProfile_Priority_
	//	*AppProfile_StandardIsolation_
	//	*AppProfile_DataBoostIsolationReadOnly_
	Isolation isAppProfile_Isolation `protobuf_oneof:"isolation"`
}

func (x *AppProfile) Reset() {
	*x = AppProfile{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppProfile) ProtoMessage() {}

func (x *AppProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppProfile.ProtoReflect.Descriptor instead.
func (*AppProfile) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{4}
}

func (x *AppProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AppProfile) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AppProfile) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *AppProfile) GetRoutingPolicy() isAppProfile_RoutingPolicy {
	if m != nil {
		return m.RoutingPolicy
	}
	return nil
}

func (x *AppProfile) GetMultiClusterRoutingUseAny() *AppProfile_MultiClusterRoutingUseAny {
	if x, ok := x.GetRoutingPolicy().(*AppProfile_MultiClusterRoutingUseAny_); ok {
		return x.MultiClusterRoutingUseAny
	}
	return nil
}

func (x *AppProfile) GetSingleClusterRouting() *AppProfile_SingleClusterRouting {
	if x, ok := x.GetRoutingPolicy().(*AppProfile_SingleClusterRouting_); ok {
		return x.SingleClusterRouting
	}
	return nil
}

func (m *AppProfile) GetIsolation() isAppProfile_Isolation {
	if m != nil {
		return m.Isolation
	}
	return nil
}

// Deprecated: Marked as deprecated in google/bigtable/admin/v2/instance.proto.
func (x *AppProfile) GetPriority() AppProfile_Priority {
	if x, ok := x.GetIsolation().(*AppProfile_Priority_); ok {
		return x.Priority
	}
	return AppProfile_PRIORITY_UNSPECIFIED
}

func (x *AppProfile) GetStandardIsolation() *AppProfile_StandardIsolation {
	if x, ok := x.GetIsolation().(*AppProfile_StandardIsolation_); ok {
		return x.StandardIsolation
	}
	return nil
}

func (x *AppProfile) GetDataBoostIsolationReadOnly() *AppProfile_DataBoostIsolationReadOnly {
	if x, ok := x.GetIsolation().(*AppProfile_DataBoostIsolationReadOnly_); ok {
		return x.DataBoostIsolationReadOnly
	}
	return nil
}

type isAppProfile_RoutingPolicy interface {
	isAppProfile_RoutingPolicy()
}

type AppProfile_MultiClusterRoutingUseAny_ struct {
	// Use a multi-cluster routing policy.
	MultiClusterRoutingUseAny *AppProfile_MultiClusterRoutingUseAny `protobuf:"bytes,5,opt,name=multi_cluster_routing_use_any,json=multiClusterRoutingUseAny,proto3,oneof"`
}

type AppProfile_SingleClusterRouting_ struct {
	// Use a single-cluster routing policy.
	SingleClusterRouting *AppProfile_SingleClusterRouting `protobuf:"bytes,6,opt,name=single_cluster_routing,json=singleClusterRouting,proto3,oneof"`
}

func (*AppProfile_MultiClusterRoutingUseAny_) isAppProfile_RoutingPolicy() {}

func (*AppProfile_SingleClusterRouting_) isAppProfile_RoutingPolicy() {}

type isAppProfile_Isolation interface {
	isAppProfile_Isolation()
}

type AppProfile_Priority_ struct {
	// This field has been deprecated in favor of `standard_isolation.priority`.
	// If you set this field, `standard_isolation.priority` will be set instead.
	//
	// The priority of requests sent using this app profile.
	//
	// Deprecated: Marked as deprecated in google/bigtable/admin/v2/instance.proto.
	Priority AppProfile_Priority `protobuf:"varint,7,opt,name=priority,proto3,enum=google.bigtable.admin.v2.AppProfile_Priority,oneof"`
}

type AppProfile_StandardIsolation_ struct {
	// The standard options used for isolating this app profile's traffic from
	// other use cases.
	StandardIsolation *AppProfile_StandardIsolation `protobuf:"bytes,11,opt,name=standard_isolation,json=standardIsolation,proto3,oneof"`
}

type AppProfile_DataBoostIsolationReadOnly_ struct {
	// Specifies that this app profile is intended for read-only usage via the
	// Data Boost feature.
	DataBoostIsolationReadOnly *AppProfile_DataBoostIsolationReadOnly `protobuf:"bytes,10,opt,name=data_boost_isolation_read_only,json=dataBoostIsolationReadOnly,proto3,oneof"`
}

func (*AppProfile_Priority_) isAppProfile_Isolation() {}

func (*AppProfile_StandardIsolation_) isAppProfile_Isolation() {}

func (*AppProfile_DataBoostIsolationReadOnly_) isAppProfile_Isolation() {}

// A tablet is a defined by a start and end key and is explained in
// https://cloud.google.com/bigtable/docs/overview#architecture and
// https://cloud.google.com/bigtable/docs/performance#optimization.
// A Hot tablet is a tablet that exhibits high average cpu usage during the time
// interval from start time to end time.
type HotTablet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the hot tablet. Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}/hotTablets/[a-zA-Z0-9_-]*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Name of the table that contains the tablet. Values are of the form
	// `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
	TableName string `protobuf:"bytes,2,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Output only. The start time of the hot tablet.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The end time of the hot tablet.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Tablet Start Key (inclusive).
	StartKey string `protobuf:"bytes,5,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	// Tablet End Key (inclusive).
	EndKey string `protobuf:"bytes,6,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	// Output only. The average CPU usage spent by a node on this tablet over the
	// start_time to end_time time range. The percentage is the amount of CPU used
	// by the node to serve the tablet, from 0% (tablet was not interacted with)
	// to 100% (the node spent all cycles serving the hot tablet).
	NodeCpuUsagePercent float32 `protobuf:"fixed32,7,opt,name=node_cpu_usage_percent,json=nodeCpuUsagePercent,proto3" json:"node_cpu_usage_percent,omitempty"`
}

func (x *HotTablet) Reset() {
	*x = HotTablet{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HotTablet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HotTablet) ProtoMessage() {}

func (x *HotTablet) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HotTablet.ProtoReflect.Descriptor instead.
func (*HotTablet) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{5}
}

func (x *HotTablet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HotTablet) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *HotTablet) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *HotTablet) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *HotTablet) GetStartKey() string {
	if x != nil {
		return x.StartKey
	}
	return ""
}

func (x *HotTablet) GetEndKey() string {
	if x != nil {
		return x.EndKey
	}
	return ""
}

func (x *HotTablet) GetNodeCpuUsagePercent() float32 {
	if x != nil {
		return x.NodeCpuUsagePercent
	}
	return 0
}

// A SQL logical view object that can be referenced in SQL queries.
type LogicalView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The unique name of the logical view.
	// Format:
	// `projects/{project}/instances/{instance}/logicalViews/{logical_view}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The logical view's select query.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The etag for this logical view.
	// This may be sent on update requests to ensure that the client has an
	// up-to-date value before proceeding. The server returns an ABORTED error on
	// a mismatched etag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *LogicalView) Reset() {
	*x = LogicalView{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogicalView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalView) ProtoMessage() {}

func (x *LogicalView) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalView.ProtoReflect.Descriptor instead.
func (*LogicalView) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{6}
}

func (x *LogicalView) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LogicalView) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *LogicalView) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A materialized view object that can be referenced in SQL queries.
type MaterializedView struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The unique name of the materialized view.
	// Format:
	// `projects/{project}/instances/{instance}/materializedViews/{materialized_view}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The materialized view's select query.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The etag for this materialized view.
	// This may be sent on update requests to ensure that the client has an
	// up-to-date value before proceeding. The server returns an ABORTED error on
	// a mismatched etag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// Set to true to make the MaterializedView protected against deletion.
	DeletionProtection bool `protobuf:"varint,6,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
}

func (x *MaterializedView) Reset() {
	*x = MaterializedView{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaterializedView) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaterializedView) ProtoMessage() {}

func (x *MaterializedView) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaterializedView.ProtoReflect.Descriptor instead.
func (*MaterializedView) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{7}
}

func (x *MaterializedView) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MaterializedView) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *MaterializedView) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *MaterializedView) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

// Autoscaling config for a cluster.
type Cluster_ClusterAutoscalingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Autoscaling limits for this cluster.
	AutoscalingLimits *AutoscalingLimits `protobuf:"bytes,1,opt,name=autoscaling_limits,json=autoscalingLimits,proto3" json:"autoscaling_limits,omitempty"`
	// Required. Autoscaling targets for this cluster.
	AutoscalingTargets *AutoscalingTargets `protobuf:"bytes,2,opt,name=autoscaling_targets,json=autoscalingTargets,proto3" json:"autoscaling_targets,omitempty"`
}

func (x *Cluster_ClusterAutoscalingConfig) Reset() {
	*x = Cluster_ClusterAutoscalingConfig{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_ClusterAutoscalingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_ClusterAutoscalingConfig) ProtoMessage() {}

func (x *Cluster_ClusterAutoscalingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_ClusterAutoscalingConfig.ProtoReflect.Descriptor instead.
func (*Cluster_ClusterAutoscalingConfig) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Cluster_ClusterAutoscalingConfig) GetAutoscalingLimits() *AutoscalingLimits {
	if x != nil {
		return x.AutoscalingLimits
	}
	return nil
}

func (x *Cluster_ClusterAutoscalingConfig) GetAutoscalingTargets() *AutoscalingTargets {
	if x != nil {
		return x.AutoscalingTargets
	}
	return nil
}

// Configuration for a cluster.
type Cluster_ClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Autoscaling configuration for this cluster.
	ClusterAutoscalingConfig *Cluster_ClusterAutoscalingConfig `protobuf:"bytes,1,opt,name=cluster_autoscaling_config,json=clusterAutoscalingConfig,proto3" json:"cluster_autoscaling_config,omitempty"`
}

func (x *Cluster_ClusterConfig) Reset() {
	*x = Cluster_ClusterConfig{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_ClusterConfig) ProtoMessage() {}

func (x *Cluster_ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_ClusterConfig.ProtoReflect.Descriptor instead.
func (*Cluster_ClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{3, 1}
}

func (x *Cluster_ClusterConfig) GetClusterAutoscalingConfig() *Cluster_ClusterAutoscalingConfig {
	if x != nil {
		return x.ClusterAutoscalingConfig
	}
	return nil
}

// Cloud Key Management Service (Cloud KMS) settings for a CMEK-protected
// cluster.
type Cluster_EncryptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes the Cloud KMS encryption key that will be used to protect the
	// destination Bigtable cluster. The requirements for this key are:
	//  1. The Cloud Bigtable service account associated with the project that
	//     contains this cluster must be granted the
	//     `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
	//  2. Only regional keys can be used and the region of the CMEK key must
	//     match the region of the cluster.
	//
	// Values are of the form
	// `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *Cluster_EncryptionConfig) Reset() {
	*x = Cluster_EncryptionConfig{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_EncryptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_EncryptionConfig) ProtoMessage() {}

func (x *Cluster_EncryptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_EncryptionConfig.ProtoReflect.Descriptor instead.
func (*Cluster_EncryptionConfig) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{3, 2}
}

func (x *Cluster_EncryptionConfig) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// Read/write requests are routed to the nearest cluster in the instance, and
// will fail over to the nearest cluster that is available in the event of
// transient errors or delays. Clusters in a region are considered
// equidistant. Choosing this option sacrifices read-your-writes consistency
// to improve availability.
type AppProfile_MultiClusterRoutingUseAny struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of clusters to route to. The order is ignored; clusters will be
	// tried in order of distance. If left empty, all clusters are eligible.
	ClusterIds []string `protobuf:"bytes,1,rep,name=cluster_ids,json=clusterIds,proto3" json:"cluster_ids,omitempty"`
	// Possible algorithms for routing affinity. If enabled, Bigtable will
	// route between equidistant clusters in a deterministic order rather than
	// choosing randomly.
	//
	// This mechanism gives read-your-writes consistency for *most* requests
	// under *most* circumstances, without sacrificing availability. Consistency
	// is *not* guaranteed, as requests might still fail over between clusters
	// in the event of errors or latency.
	//
	// Types that are assignable to Affinity:
	//
	//	*AppProfile_MultiClusterRoutingUseAny_RowAffinity_
	Affinity isAppProfile_MultiClusterRoutingUseAny_Affinity `protobuf_oneof:"affinity"`
}

func (x *AppProfile_MultiClusterRoutingUseAny) Reset() {
	*x = AppProfile_MultiClusterRoutingUseAny{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppProfile_MultiClusterRoutingUseAny) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppProfile_MultiClusterRoutingUseAny) ProtoMessage() {}

func (x *AppProfile_MultiClusterRoutingUseAny) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppProfile_MultiClusterRoutingUseAny.ProtoReflect.Descriptor instead.
func (*AppProfile_MultiClusterRoutingUseAny) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{4, 0}
}

func (x *AppProfile_MultiClusterRoutingUseAny) GetClusterIds() []string {
	if x != nil {
		return x.ClusterIds
	}
	return nil
}

func (m *AppProfile_MultiClusterRoutingUseAny) GetAffinity() isAppProfile_MultiClusterRoutingUseAny_Affinity {
	if m != nil {
		return m.Affinity
	}
	return nil
}

func (x *AppProfile_MultiClusterRoutingUseAny) GetRowAffinity() *AppProfile_MultiClusterRoutingUseAny_RowAffinity {
	if x, ok := x.GetAffinity().(*AppProfile_MultiClusterRoutingUseAny_RowAffinity_); ok {
		return x.RowAffinity
	}
	return nil
}

type isAppProfile_MultiClusterRoutingUseAny_Affinity interface {
	isAppProfile_MultiClusterRoutingUseAny_Affinity()
}

type AppProfile_MultiClusterRoutingUseAny_RowAffinity_ struct {
	// Row affinity sticky routing based on the row key of the request.
	// Requests that span multiple rows are routed non-deterministically.
	RowAffinity *AppProfile_MultiClusterRoutingUseAny_RowAffinity `protobuf:"bytes,3,opt,name=row_affinity,json=rowAffinity,proto3,oneof"`
}

func (*AppProfile_MultiClusterRoutingUseAny_RowAffinity_) isAppProfile_MultiClusterRoutingUseAny_Affinity() {
}

// Unconditionally routes all read/write requests to a specific cluster.
// This option preserves read-your-writes consistency but does not improve
// availability.
type AppProfile_SingleClusterRouting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cluster to which read/write requests should be routed.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
	// allowed by this app profile. It is unsafe to send these requests to
	// the same table/row/column in multiple clusters.
	AllowTransactionalWrites bool `protobuf:"varint,2,opt,name=allow_transactional_writes,json=allowTransactionalWrites,proto3" json:"allow_transactional_writes,omitempty"`
}

func (x *AppProfile_SingleClusterRouting) Reset() {
	*x = AppProfile_SingleClusterRouting{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppProfile_SingleClusterRouting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppProfile_SingleClusterRouting) ProtoMessage() {}

func (x *AppProfile_SingleClusterRouting) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppProfile_SingleClusterRouting.ProtoReflect.Descriptor instead.
func (*AppProfile_SingleClusterRouting) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{4, 1}
}

func (x *AppProfile_SingleClusterRouting) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *AppProfile_SingleClusterRouting) GetAllowTransactionalWrites() bool {
	if x != nil {
		return x.AllowTransactionalWrites
	}
	return false
}

// Standard options for isolating this app profile's traffic from other use
// cases.
type AppProfile_StandardIsolation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The priority of requests sent using this app profile.
	Priority AppProfile_Priority `protobuf:"varint,1,opt,name=priority,proto3,enum=google.bigtable.admin.v2.AppProfile_Priority" json:"priority,omitempty"`
}

func (x *AppProfile_StandardIsolation) Reset() {
	*x = AppProfile_StandardIsolation{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppProfile_StandardIsolation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppProfile_StandardIsolation) ProtoMessage() {}

func (x *AppProfile_StandardIsolation) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppProfile_StandardIsolation.ProtoReflect.Descriptor instead.
func (*AppProfile_StandardIsolation) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{4, 2}
}

func (x *AppProfile_StandardIsolation) GetPriority() AppProfile_Priority {
	if x != nil {
		return x.Priority
	}
	return AppProfile_PRIORITY_UNSPECIFIED
}

// Data Boost is a serverless compute capability that lets you run
// high-throughput read jobs and queries on your Bigtable data, without
// impacting the performance of the clusters that handle your application
// traffic. Data Boost supports read-only use cases with single-cluster
// routing.
type AppProfile_DataBoostIsolationReadOnly struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Compute Billing Owner for this Data Boost App Profile.
	ComputeBillingOwner *AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner `protobuf:"varint,1,opt,name=compute_billing_owner,json=computeBillingOwner,proto3,enum=google.bigtable.admin.v2.AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner,oneof" json:"compute_billing_owner,omitempty"`
}

func (x *AppProfile_DataBoostIsolationReadOnly) Reset() {
	*x = AppProfile_DataBoostIsolationReadOnly{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppProfile_DataBoostIsolationReadOnly) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppProfile_DataBoostIsolationReadOnly) ProtoMessage() {}

func (x *AppProfile_DataBoostIsolationReadOnly) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppProfile_DataBoostIsolationReadOnly.ProtoReflect.Descriptor instead.
func (*AppProfile_DataBoostIsolationReadOnly) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{4, 3}
}

func (x *AppProfile_DataBoostIsolationReadOnly) GetComputeBillingOwner() AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner {
	if x != nil && x.ComputeBillingOwner != nil {
		return *x.ComputeBillingOwner
	}
	return AppProfile_DataBoostIsolationReadOnly_COMPUTE_BILLING_OWNER_UNSPECIFIED
}

// If enabled, Bigtable will route the request based on the row key of the
// request, rather than randomly. Instead, each row key will be assigned
// to a cluster, and will stick to that cluster. If clusters are added or
// removed, then this may affect which row keys stick to which clusters.
// To avoid this, users can use a cluster group to specify which clusters
// are to be used. In this case, new clusters that are not a part of the
// cluster group will not be routed to, and routing will be unaffected by
// the new cluster. Moreover, clusters specified in the cluster group cannot
// be deleted unless removed from the cluster group.
type AppProfile_MultiClusterRoutingUseAny_RowAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AppProfile_MultiClusterRoutingUseAny_RowAffinity) Reset() {
	*x = AppProfile_MultiClusterRoutingUseAny_RowAffinity{}
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppProfile_MultiClusterRoutingUseAny_RowAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppProfile_MultiClusterRoutingUseAny_RowAffinity) ProtoMessage() {}

func (x *AppProfile_MultiClusterRoutingUseAny_RowAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_admin_v2_instance_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppProfile_MultiClusterRoutingUseAny_RowAffinity.ProtoReflect.Descriptor instead.
func (*AppProfile_MultiClusterRoutingUseAny_RowAffinity) Descriptor() ([]byte, []int) {
	return file_google_bigtable_admin_v2_instance_proto_rawDescGZIP(), []int{4, 0, 0}
}

var File_google_bigtable_admin_v2_instance_proto protoreflect.FileDescriptor

var file_google_bigtable_admin_v2_instance_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xef, 0x05, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x0d,
	0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0d, 0x73,
	0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73,
	0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x88, 0x01, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x35, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x13,
	0x0a, 0x0f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0x3d, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52,
	0x4f, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45,
	0x56, 0x45, 0x4c, 0x4f, 0x50, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x3a, 0x68, 0xea, 0x41, 0x65,
	0x0a, 0x25, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d,
	0x2a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x32, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66,
	0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x22, 0x94, 0x01, 0x0a, 0x12, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x12, 0x36, 0x0a, 0x17, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x15, 0x63, 0x70, 0x75, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x20, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x67, 0x69, 0x62, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x1c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x69, 0x62, 0x50, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65,
	0x22, 0x6d, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x72, 0x76, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x22,
	0xe6, 0x0a, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x68, 0x0a, 0x13, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x74,
	0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x11, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x46,
	0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x58, 0x0a, 0x0e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00,
	0x52, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5c, 0x0a, 0x14, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x64, 0x0a,
	0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0xdf, 0x01, 0x0a, 0x18, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x5f, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x12, 0x62, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x1a, 0x89, 0x01, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x78, 0x0a, 0x1a, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x1a, 0x5c, 0x0a, 0x10, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0x51, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x49, 0x5a, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x04, 0x22, 0x70, 0x0a, 0x11, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x23, 0x0a, 0x1f, 0x4e, 0x4f, 0x44, 0x45, 0x5f,
	0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16,
	0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x41, 0x43,
	0x54, 0x4f, 0x52, 0x5f, 0x31, 0x58, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x4e, 0x4f, 0x44, 0x45,
	0x5f, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f,
	0x32, 0x58, 0x10, 0x02, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x24, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2a, 0x08, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x32, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x08,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd0, 0x0c, 0x0a, 0x0a, 0x41, 0x70, 0x70,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x82, 0x01, 0x0a, 0x1d, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x73, 0x65, 0x5f,
	0x61, 0x6e, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x41, 0x6e, 0x79, 0x48, 0x00, 0x52, 0x19, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x55, 0x73, 0x65, 0x41, 0x6e, 0x79, 0x12, 0x71, 0x0a, 0x16, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x48, 0x00, 0x52, 0x14, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x4f, 0x0a, 0x08, 0x70, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x42, 0x02, 0x18, 0x01, 0x48, 0x01,
	0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x67, 0x0a, 0x12, 0x73, 0x74,
	0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61,
	0x6e, 0x64, 0x61, 0x72, 0x64, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01,
	0x52, 0x11, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x85, 0x01, 0x0a, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x62, 0x6f, 0x6f,
	0x73, 0x74, 0x5f, 0x69, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x49, 0x73, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x48, 0x01, 0x52,
	0x1a, 0x64, 0x61, 0x74, 0x61, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x1a, 0xc8, 0x01, 0x0a, 0x19,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x41, 0x6e, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x73, 0x12, 0x6f, 0x0a, 0x0c, 0x72, 0x6f,
	0x77, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x41, 0x6e, 0x79,
	0x2e, 0x52, 0x6f, 0x77, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0b,
	0x72, 0x6f, 0x77, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x1a, 0x0d, 0x0a, 0x0b, 0x52,
	0x6f, 0x77, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x42, 0x0a, 0x0a, 0x08, 0x61, 0x66,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x1a, 0x73, 0x0a, 0x14, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x3c, 0x0a,
	0x1a, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x18, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x57, 0x72, 0x69, 0x74, 0x65, 0x73, 0x1a, 0x5e, 0x0a, 0x11, 0x53,
	0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x49, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70,
	0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x1a, 0x92, 0x02, 0x0a, 0x1a,
	0x44, 0x61, 0x74, 0x61, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x8c, 0x01, 0x0a, 0x15, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x48,
	0x00, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x88, 0x01, 0x01, 0x22, 0x4b, 0x0a, 0x13, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4f, 0x77, 0x6e, 0x65, 0x72,
	0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x42, 0x49, 0x4c, 0x4c,
	0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x57, 0x4e, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x48, 0x4f, 0x53, 0x54, 0x5f,
	0x50, 0x41, 0x59, 0x53, 0x10, 0x01, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x22, 0x5e, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14,
	0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49,
	0x54, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x52, 0x49, 0x4f,
	0x52, 0x49, 0x54, 0x59, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x11, 0x0a,
	0x0d, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03,
	0x3a, 0x89, 0x01, 0xea, 0x41, 0x85, 0x01, 0x0a, 0x27, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x7d, 0x2a, 0x0b, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x32, 0x0a, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x10, 0x0a, 0x0e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x0b,
	0x0a, 0x09, 0x69, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xed, 0x03, 0x0a, 0x09,
	0x48, 0x6f, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a,
	0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x17,
	0x0a, 0x07, 0x65, 0x6e, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x65, 0x6e, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x38, 0x0a, 0x16, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x6e, 0x6f,
	0x64, 0x65, 0x43, 0x70, 0x75, 0x55, 0x73, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x3a, 0x97, 0x01, 0xea, 0x41, 0x93, 0x01, 0x0a, 0x26, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x6f, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74,
	0x12, 0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x68, 0x6f, 0x74,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x68, 0x6f, 0x74, 0x5f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x74, 0x7d, 0x2a, 0x0a, 0x68, 0x6f, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x73,
	0x32, 0x09, 0x68, 0x6f, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x74, 0x22, 0xeb, 0x01, 0x0a, 0x0b,
	0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x3a, 0x8e, 0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a,
	0x28, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x67, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x7d, 0x2a, 0x0c,
	0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x73, 0x32, 0x0b, 0x6c, 0x6f,
	0x67, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x22, 0xbd, 0x02, 0x0a, 0x10, 0x4d, 0x61,
	0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x2f,
	0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
	0xa7, 0x01, 0xea, 0x41, 0xa3, 0x01, 0x0a, 0x2d, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x56, 0x69, 0x65, 0x77, 0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x6d,
	0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73,
	0x2f, 0x7b, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x7d, 0x2a, 0x11, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73, 0x32, 0x10, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x42, 0xcb, 0x02, 0xea, 0x41, 0x78, 0x0a,
	0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b,
	0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x0d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62,
	0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x56,
	0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c,
	0x56, 0x32, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_admin_v2_instance_proto_rawDescOnce sync.Once
	file_google_bigtable_admin_v2_instance_proto_rawDescData = file_google_bigtable_admin_v2_instance_proto_rawDesc
)

func file_google_bigtable_admin_v2_instance_proto_rawDescGZIP() []byte {
	file_google_bigtable_admin_v2_instance_proto_rawDescOnce.Do(func() {
		file_google_bigtable_admin_v2_instance_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_admin_v2_instance_proto_rawDescData)
	})
	return file_google_bigtable_admin_v2_instance_proto_rawDescData
}

var file_google_bigtable_admin_v2_instance_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_bigtable_admin_v2_instance_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_bigtable_admin_v2_instance_proto_goTypes = []any{
	(Instance_State)(0),            // 0: google.bigtable.admin.v2.Instance.State
	(Instance_Type)(0),             // 1: google.bigtable.admin.v2.Instance.Type
	(Cluster_State)(0),             // 2: google.bigtable.admin.v2.Cluster.State
	(Cluster_NodeScalingFactor)(0), // 3: google.bigtable.admin.v2.Cluster.NodeScalingFactor
	(AppProfile_Priority)(0),       // 4: google.bigtable.admin.v2.AppProfile.Priority
	(AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner)(0), // 5: google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
	(*Instance)(nil),                                         // 6: google.bigtable.admin.v2.Instance
	(*AutoscalingTargets)(nil),                               // 7: google.bigtable.admin.v2.AutoscalingTargets
	(*AutoscalingLimits)(nil),                                // 8: google.bigtable.admin.v2.AutoscalingLimits
	(*Cluster)(nil),                                          // 9: google.bigtable.admin.v2.Cluster
	(*AppProfile)(nil),                                       // 10: google.bigtable.admin.v2.AppProfile
	(*HotTablet)(nil),                                        // 11: google.bigtable.admin.v2.HotTablet
	(*LogicalView)(nil),                                      // 12: google.bigtable.admin.v2.LogicalView
	(*MaterializedView)(nil),                                 // 13: google.bigtable.admin.v2.MaterializedView
	nil,                                                      // 14: google.bigtable.admin.v2.Instance.LabelsEntry
	(*Cluster_ClusterAutoscalingConfig)(nil),                 // 15: google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
	(*Cluster_ClusterConfig)(nil),                            // 16: google.bigtable.admin.v2.Cluster.ClusterConfig
	(*Cluster_EncryptionConfig)(nil),                         // 17: google.bigtable.admin.v2.Cluster.EncryptionConfig
	(*AppProfile_MultiClusterRoutingUseAny)(nil),             // 18: google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
	(*AppProfile_SingleClusterRouting)(nil),                  // 19: google.bigtable.admin.v2.AppProfile.SingleClusterRouting
	(*AppProfile_StandardIsolation)(nil),                     // 20: google.bigtable.admin.v2.AppProfile.StandardIsolation
	(*AppProfile_DataBoostIsolationReadOnly)(nil),            // 21: google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
	(*AppProfile_MultiClusterRoutingUseAny_RowAffinity)(nil), // 22: google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
	(*timestamppb.Timestamp)(nil),                            // 23: google.protobuf.Timestamp
	(StorageType)(0),                                         // 24: google.bigtable.admin.v2.StorageType
}
var file_google_bigtable_admin_v2_instance_proto_depIdxs = []int32{
	0,  // 0: google.bigtable.admin.v2.Instance.state:type_name -> google.bigtable.admin.v2.Instance.State
	1,  // 1: google.bigtable.admin.v2.Instance.type:type_name -> google.bigtable.admin.v2.Instance.Type
	14, // 2: google.bigtable.admin.v2.Instance.labels:type_name -> google.bigtable.admin.v2.Instance.LabelsEntry
	23, // 3: google.bigtable.admin.v2.Instance.create_time:type_name -> google.protobuf.Timestamp
	2,  // 4: google.bigtable.admin.v2.Cluster.state:type_name -> google.bigtable.admin.v2.Cluster.State
	3,  // 5: google.bigtable.admin.v2.Cluster.node_scaling_factor:type_name -> google.bigtable.admin.v2.Cluster.NodeScalingFactor
	16, // 6: google.bigtable.admin.v2.Cluster.cluster_config:type_name -> google.bigtable.admin.v2.Cluster.ClusterConfig
	24, // 7: google.bigtable.admin.v2.Cluster.default_storage_type:type_name -> google.bigtable.admin.v2.StorageType
	17, // 8: google.bigtable.admin.v2.Cluster.encryption_config:type_name -> google.bigtable.admin.v2.Cluster.EncryptionConfig
	18, // 9: google.bigtable.admin.v2.AppProfile.multi_cluster_routing_use_any:type_name -> google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny
	19, // 10: google.bigtable.admin.v2.AppProfile.single_cluster_routing:type_name -> google.bigtable.admin.v2.AppProfile.SingleClusterRouting
	4,  // 11: google.bigtable.admin.v2.AppProfile.priority:type_name -> google.bigtable.admin.v2.AppProfile.Priority
	20, // 12: google.bigtable.admin.v2.AppProfile.standard_isolation:type_name -> google.bigtable.admin.v2.AppProfile.StandardIsolation
	21, // 13: google.bigtable.admin.v2.AppProfile.data_boost_isolation_read_only:type_name -> google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly
	23, // 14: google.bigtable.admin.v2.HotTablet.start_time:type_name -> google.protobuf.Timestamp
	23, // 15: google.bigtable.admin.v2.HotTablet.end_time:type_name -> google.protobuf.Timestamp
	8,  // 16: google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.autoscaling_limits:type_name -> google.bigtable.admin.v2.AutoscalingLimits
	7,  // 17: google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig.autoscaling_targets:type_name -> google.bigtable.admin.v2.AutoscalingTargets
	15, // 18: google.bigtable.admin.v2.Cluster.ClusterConfig.cluster_autoscaling_config:type_name -> google.bigtable.admin.v2.Cluster.ClusterAutoscalingConfig
	22, // 19: google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.row_affinity:type_name -> google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny.RowAffinity
	4,  // 20: google.bigtable.admin.v2.AppProfile.StandardIsolation.priority:type_name -> google.bigtable.admin.v2.AppProfile.Priority
	5,  // 21: google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.compute_billing_owner:type_name -> google.bigtable.admin.v2.AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_bigtable_admin_v2_instance_proto_init() }
func file_google_bigtable_admin_v2_instance_proto_init() {
	if File_google_bigtable_admin_v2_instance_proto != nil {
		return
	}
	file_google_bigtable_admin_v2_common_proto_init()
	file_google_bigtable_admin_v2_instance_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_bigtable_admin_v2_instance_proto_msgTypes[3].OneofWrappers = []any{
		(*Cluster_ClusterConfig_)(nil),
	}
	file_google_bigtable_admin_v2_instance_proto_msgTypes[4].OneofWrappers = []any{
		(*AppProfile_MultiClusterRoutingUseAny_)(nil),
		(*AppProfile_SingleClusterRouting_)(nil),
		(*AppProfile_Priority_)(nil),
		(*AppProfile_StandardIsolation_)(nil),
		(*AppProfile_DataBoostIsolationReadOnly_)(nil),
	}
	file_google_bigtable_admin_v2_instance_proto_msgTypes[12].OneofWrappers = []any{
		(*AppProfile_MultiClusterRoutingUseAny_RowAffinity_)(nil),
	}
	file_google_bigtable_admin_v2_instance_proto_msgTypes[15].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_admin_v2_instance_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_bigtable_admin_v2_instance_proto_goTypes,
		DependencyIndexes: file_google_bigtable_admin_v2_instance_proto_depIdxs,
		EnumInfos:         file_google_bigtable_admin_v2_instance_proto_enumTypes,
		MessageInfos:      file_google_bigtable_admin_v2_instance_proto_msgTypes,
	}.Build()
	File_google_bigtable_admin_v2_instance_proto = out.File
	file_google_bigtable_admin_v2_instance_proto_rawDesc = nil
	file_google_bigtable_admin_v2_instance_proto_goTypes = nil
	file_google_bigtable_admin_v2_instance_proto_depIdxs = nil
}
