// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/apihub/v1/common_fields.proto

package apihubpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Lint state represents success or failure for linting.
type LintState int32

const (
	// Lint state unspecified.
	LintState_LINT_STATE_UNSPECIFIED LintState = 0
	// Linting was completed successfully.
	LintState_LINT_STATE_SUCCESS LintState = 1
	// Linting encountered errors.
	LintState_LINT_STATE_ERROR LintState = 2
)

// Enum value maps for LintState.
var (
	LintState_name = map[int32]string{
		0: "LINT_STATE_UNSPECIFIED",
		1: "LINT_STATE_SUCCESS",
		2: "LINT_STATE_ERROR",
	}
	LintState_value = map[string]int32{
		"LINT_STATE_UNSPECIFIED": 0,
		"LINT_STATE_SUCCESS":     1,
		"LINT_STATE_ERROR":       2,
	}
)

func (x LintState) Enum() *LintState {
	p := new(LintState)
	*p = x
	return p
}

func (x LintState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LintState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[0].Descriptor()
}

func (LintState) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[0]
}

func (x LintState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LintState.Descriptor instead.
func (LintState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{0}
}

// Enumeration of linter types.
type Linter int32

const (
	// Linter type unspecified.
	Linter_LINTER_UNSPECIFIED Linter = 0
	// Linter type spectral.
	Linter_SPECTRAL Linter = 1
	// Linter type other.
	Linter_OTHER Linter = 2
)

// Enum value maps for Linter.
var (
	Linter_name = map[int32]string{
		0: "LINTER_UNSPECIFIED",
		1: "SPECTRAL",
		2: "OTHER",
	}
	Linter_value = map[string]int32{
		"LINTER_UNSPECIFIED": 0,
		"SPECTRAL":           1,
		"OTHER":              2,
	}
)

func (x Linter) Enum() *Linter {
	p := new(Linter)
	*p = x
	return p
}

func (x Linter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Linter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[1].Descriptor()
}

func (Linter) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[1]
}

func (x Linter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Linter.Descriptor instead.
func (Linter) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{1}
}

// Severity of the issue.
type Severity int32

const (
	// Severity unspecified.
	Severity_SEVERITY_UNSPECIFIED Severity = 0
	// Severity error.
	Severity_SEVERITY_ERROR Severity = 1
	// Severity warning.
	Severity_SEVERITY_WARNING Severity = 2
	// Severity info.
	Severity_SEVERITY_INFO Severity = 3
	// Severity hint.
	Severity_SEVERITY_HINT Severity = 4
)

// Enum value maps for Severity.
var (
	Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "SEVERITY_ERROR",
		2: "SEVERITY_WARNING",
		3: "SEVERITY_INFO",
		4: "SEVERITY_HINT",
	}
	Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"SEVERITY_ERROR":       1,
		"SEVERITY_WARNING":     2,
		"SEVERITY_INFO":        3,
		"SEVERITY_HINT":        4,
	}
)

func (x Severity) Enum() *Severity {
	p := new(Severity)
	*p = x
	return p
}

func (x Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[2].Descriptor()
}

func (Severity) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[2]
}

func (x Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Severity.Descriptor instead.
func (Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{2}
}

// Specifies the parsing mode for API specifications during creation and
// update.
// - `RELAXED`: Parsing errors in the specification content do not fail the
// API call.
// - `STRICT`: Parsing errors in the specification content result in failure
// of the API call.
// If not specified, defaults to `RELAXED`.
type Spec_ParsingMode int32

const (
	// Defaults to `RELAXED`.
	Spec_PARSING_MODE_UNSPECIFIED Spec_ParsingMode = 0
	// Parsing of the Spec on create and update is relaxed, meaning that
	// parsing errors the spec contents will not fail the API call.
	Spec_RELAXED Spec_ParsingMode = 1
	// Parsing of the Spec on create and update is strict, meaning that
	// parsing errors in the spec contents will fail the API call.
	Spec_STRICT Spec_ParsingMode = 2
)

// Enum value maps for Spec_ParsingMode.
var (
	Spec_ParsingMode_name = map[int32]string{
		0: "PARSING_MODE_UNSPECIFIED",
		1: "RELAXED",
		2: "STRICT",
	}
	Spec_ParsingMode_value = map[string]int32{
		"PARSING_MODE_UNSPECIFIED": 0,
		"RELAXED":                  1,
		"STRICT":                   2,
	}
)

func (x Spec_ParsingMode) Enum() *Spec_ParsingMode {
	p := new(Spec_ParsingMode)
	*p = x
	return p
}

func (x Spec_ParsingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Spec_ParsingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[3].Descriptor()
}

func (Spec_ParsingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[3]
}

func (x Spec_ParsingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Spec_ParsingMode.Descriptor instead.
func (Spec_ParsingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{2, 0}
}

// Enumeration of definition types.
type Definition_Type int32

const (
	// Definition type unspecified.
	Definition_TYPE_UNSPECIFIED Definition_Type = 0
	// Definition type schema.
	Definition_SCHEMA Definition_Type = 1
)

// Enum value maps for Definition_Type.
var (
	Definition_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SCHEMA",
	}
	Definition_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SCHEMA":           1,
	}
)

func (x Definition_Type) Enum() *Definition_Type {
	p := new(Definition_Type)
	*p = x
	return p
}

func (x Definition_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Definition_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[4].Descriptor()
}

func (Definition_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[4]
}

func (x Definition_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Definition_Type.Descriptor instead.
func (Definition_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{5, 0}
}

// Enumeration of attribute definition types.
type Attribute_DefinitionType int32

const (
	// Attribute definition type unspecified.
	Attribute_DEFINITION_TYPE_UNSPECIFIED Attribute_DefinitionType = 0
	// The attribute is predefined by the API Hub. Note that only the list of
	// allowed values can be updated in this case via UpdateAttribute method.
	Attribute_SYSTEM_DEFINED Attribute_DefinitionType = 1
	// The attribute is defined by the user.
	Attribute_USER_DEFINED Attribute_DefinitionType = 2
)

// Enum value maps for Attribute_DefinitionType.
var (
	Attribute_DefinitionType_name = map[int32]string{
		0: "DEFINITION_TYPE_UNSPECIFIED",
		1: "SYSTEM_DEFINED",
		2: "USER_DEFINED",
	}
	Attribute_DefinitionType_value = map[string]int32{
		"DEFINITION_TYPE_UNSPECIFIED": 0,
		"SYSTEM_DEFINED":              1,
		"USER_DEFINED":                2,
	}
)

func (x Attribute_DefinitionType) Enum() *Attribute_DefinitionType {
	p := new(Attribute_DefinitionType)
	*p = x
	return p
}

func (x Attribute_DefinitionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Attribute_DefinitionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[5].Descriptor()
}

func (Attribute_DefinitionType) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[5]
}

func (x Attribute_DefinitionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Attribute_DefinitionType.Descriptor instead.
func (Attribute_DefinitionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{6, 0}
}

// Enumeration for the scope of the attribute representing the resource in the
// API Hub to which the attribute can be linked.
type Attribute_Scope int32

const (
	// Scope Unspecified.
	Attribute_SCOPE_UNSPECIFIED Attribute_Scope = 0
	// Attribute can be linked to an API.
	Attribute_API Attribute_Scope = 1
	// Attribute can be linked to an API version.
	Attribute_VERSION Attribute_Scope = 2
	// Attribute can be linked to a Spec.
	Attribute_SPEC Attribute_Scope = 3
	// Attribute can be linked to an API Operation.
	Attribute_API_OPERATION Attribute_Scope = 4
	// Attribute can be linked to a Deployment.
	Attribute_DEPLOYMENT Attribute_Scope = 5
	// Attribute can be linked to a Dependency.
	Attribute_DEPENDENCY Attribute_Scope = 6
	// Attribute can be linked to a definition.
	Attribute_DEFINITION Attribute_Scope = 7
	// Attribute can be linked to a ExternalAPI.
	Attribute_EXTERNAL_API Attribute_Scope = 8
	// Attribute can be linked to a Plugin.
	Attribute_PLUGIN Attribute_Scope = 9
)

// Enum value maps for Attribute_Scope.
var (
	Attribute_Scope_name = map[int32]string{
		0: "SCOPE_UNSPECIFIED",
		1: "API",
		2: "VERSION",
		3: "SPEC",
		4: "API_OPERATION",
		5: "DEPLOYMENT",
		6: "DEPENDENCY",
		7: "DEFINITION",
		8: "EXTERNAL_API",
		9: "PLUGIN",
	}
	Attribute_Scope_value = map[string]int32{
		"SCOPE_UNSPECIFIED": 0,
		"API":               1,
		"VERSION":           2,
		"SPEC":              3,
		"API_OPERATION":     4,
		"DEPLOYMENT":        5,
		"DEPENDENCY":        6,
		"DEFINITION":        7,
		"EXTERNAL_API":      8,
		"PLUGIN":            9,
	}
)

func (x Attribute_Scope) Enum() *Attribute_Scope {
	p := new(Attribute_Scope)
	*p = x
	return p
}

func (x Attribute_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Attribute_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[6].Descriptor()
}

func (Attribute_Scope) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[6]
}

func (x Attribute_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Attribute_Scope.Descriptor instead.
func (Attribute_Scope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{6, 1}
}

// Enumeration of attribute's data type.
type Attribute_DataType int32

const (
	// Attribute data type unspecified.
	Attribute_DATA_TYPE_UNSPECIFIED Attribute_DataType = 0
	// Attribute's value is of type enum.
	Attribute_ENUM Attribute_DataType = 1
	// Attribute's value is of type json.
	Attribute_JSON Attribute_DataType = 2
	// Attribute's value is of type string.
	Attribute_STRING Attribute_DataType = 3
)

// Enum value maps for Attribute_DataType.
var (
	Attribute_DataType_name = map[int32]string{
		0: "DATA_TYPE_UNSPECIFIED",
		1: "ENUM",
		2: "JSON",
		3: "STRING",
	}
	Attribute_DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"ENUM":                  1,
		"JSON":                  2,
		"STRING":                3,
	}
)

func (x Attribute_DataType) Enum() *Attribute_DataType {
	p := new(Attribute_DataType)
	*p = x
	return p
}

func (x Attribute_DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Attribute_DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[7].Descriptor()
}

func (Attribute_DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[7]
}

func (x Attribute_DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Attribute_DataType.Descriptor instead.
func (Attribute_DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{6, 2}
}

// Enumeration of spec formats.
type OpenApiSpecDetails_Format int32

const (
	// SpecFile type unspecified.
	OpenApiSpecDetails_FORMAT_UNSPECIFIED OpenApiSpecDetails_Format = 0
	// OpenAPI Spec v2.0.
	OpenApiSpecDetails_OPEN_API_SPEC_2_0 OpenApiSpecDetails_Format = 1
	// OpenAPI Spec v3.0.
	OpenApiSpecDetails_OPEN_API_SPEC_3_0 OpenApiSpecDetails_Format = 2
	// OpenAPI Spec v3.1.
	OpenApiSpecDetails_OPEN_API_SPEC_3_1 OpenApiSpecDetails_Format = 3
)

// Enum value maps for OpenApiSpecDetails_Format.
var (
	OpenApiSpecDetails_Format_name = map[int32]string{
		0: "FORMAT_UNSPECIFIED",
		1: "OPEN_API_SPEC_2_0",
		2: "OPEN_API_SPEC_3_0",
		3: "OPEN_API_SPEC_3_1",
	}
	OpenApiSpecDetails_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"OPEN_API_SPEC_2_0":  1,
		"OPEN_API_SPEC_3_0":  2,
		"OPEN_API_SPEC_3_1":  3,
	}
)

func (x OpenApiSpecDetails_Format) Enum() *OpenApiSpecDetails_Format {
	p := new(OpenApiSpecDetails_Format)
	*p = x
	return p
}

func (x OpenApiSpecDetails_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OpenApiSpecDetails_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[8].Descriptor()
}

func (OpenApiSpecDetails_Format) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[8]
}

func (x OpenApiSpecDetails_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OpenApiSpecDetails_Format.Descriptor instead.
func (OpenApiSpecDetails_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{9, 0}
}

// Enumeration of Method types.
type HttpOperation_Method int32

const (
	// Method unspecified.
	HttpOperation_METHOD_UNSPECIFIED HttpOperation_Method = 0
	// Get Operation type.
	HttpOperation_GET HttpOperation_Method = 1
	// Put Operation type.
	HttpOperation_PUT HttpOperation_Method = 2
	// Post Operation type.
	HttpOperation_POST HttpOperation_Method = 3
	// Delete Operation type.
	HttpOperation_DELETE HttpOperation_Method = 4
	// Options Operation type.
	HttpOperation_OPTIONS HttpOperation_Method = 5
	// Head Operation type.
	HttpOperation_HEAD HttpOperation_Method = 6
	// Patch Operation type.
	HttpOperation_PATCH HttpOperation_Method = 7
	// Trace Operation type.
	HttpOperation_TRACE HttpOperation_Method = 8
)

// Enum value maps for HttpOperation_Method.
var (
	HttpOperation_Method_name = map[int32]string{
		0: "METHOD_UNSPECIFIED",
		1: "GET",
		2: "PUT",
		3: "POST",
		4: "DELETE",
		5: "OPTIONS",
		6: "HEAD",
		7: "PATCH",
		8: "TRACE",
	}
	HttpOperation_Method_value = map[string]int32{
		"METHOD_UNSPECIFIED": 0,
		"GET":                1,
		"PUT":                2,
		"POST":               3,
		"DELETE":             4,
		"OPTIONS":            5,
		"HEAD":               6,
		"PATCH":              7,
		"TRACE":              8,
	}
)

func (x HttpOperation_Method) Enum() *HttpOperation_Method {
	p := new(HttpOperation_Method)
	*p = x
	return p
}

func (x HttpOperation_Method) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpOperation_Method) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[9].Descriptor()
}

func (HttpOperation_Method) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[9]
}

func (x HttpOperation_Method) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpOperation_Method.Descriptor instead.
func (HttpOperation_Method) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{11, 0}
}

// Possible states for a dependency.
type Dependency_State int32

const (
	// Default value. This value is unused.
	Dependency_STATE_UNSPECIFIED Dependency_State = 0
	// Dependency will be in a proposed state when it is newly identified by the
	// API hub on its own.
	Dependency_PROPOSED Dependency_State = 1
	// Dependency will be in a validated state when it is validated by the
	// admin or manually created in the API hub.
	Dependency_VALIDATED Dependency_State = 2
)

// Enum value maps for Dependency_State.
var (
	Dependency_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROPOSED",
		2: "VALIDATED",
	}
	Dependency_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROPOSED":          1,
		"VALIDATED":         2,
	}
)

func (x Dependency_State) Enum() *Dependency_State {
	p := new(Dependency_State)
	*p = x
	return p
}

func (x Dependency_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Dependency_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[10].Descriptor()
}

func (Dependency_State) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[10]
}

func (x Dependency_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Dependency_State.Descriptor instead.
func (Dependency_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{17, 0}
}

// Possible modes of discovering the dependency.
type Dependency_DiscoveryMode int32

const (
	// Default value. This value is unused.
	Dependency_DISCOVERY_MODE_UNSPECIFIED Dependency_DiscoveryMode = 0
	// Manual mode of discovery when the dependency is defined by the user.
	Dependency_MANUAL Dependency_DiscoveryMode = 1
)

// Enum value maps for Dependency_DiscoveryMode.
var (
	Dependency_DiscoveryMode_name = map[int32]string{
		0: "DISCOVERY_MODE_UNSPECIFIED",
		1: "MANUAL",
	}
	Dependency_DiscoveryMode_value = map[string]int32{
		"DISCOVERY_MODE_UNSPECIFIED": 0,
		"MANUAL":                     1,
	}
)

func (x Dependency_DiscoveryMode) Enum() *Dependency_DiscoveryMode {
	p := new(Dependency_DiscoveryMode)
	*p = x
	return p
}

func (x Dependency_DiscoveryMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Dependency_DiscoveryMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[11].Descriptor()
}

func (Dependency_DiscoveryMode) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[11]
}

func (x Dependency_DiscoveryMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Dependency_DiscoveryMode.Descriptor instead.
func (Dependency_DiscoveryMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{17, 1}
}

// Possible values representing an error in the dependency.
type DependencyErrorDetail_Error int32

const (
	// Default value used for no error in the dependency.
	DependencyErrorDetail_ERROR_UNSPECIFIED DependencyErrorDetail_Error = 0
	// Supplier entity has been deleted.
	DependencyErrorDetail_SUPPLIER_NOT_FOUND DependencyErrorDetail_Error = 1
	// Supplier entity has been recreated.
	DependencyErrorDetail_SUPPLIER_RECREATED DependencyErrorDetail_Error = 2
)

// Enum value maps for DependencyErrorDetail_Error.
var (
	DependencyErrorDetail_Error_name = map[int32]string{
		0: "ERROR_UNSPECIFIED",
		1: "SUPPLIER_NOT_FOUND",
		2: "SUPPLIER_RECREATED",
	}
	DependencyErrorDetail_Error_value = map[string]int32{
		"ERROR_UNSPECIFIED":  0,
		"SUPPLIER_NOT_FOUND": 1,
		"SUPPLIER_RECREATED": 2,
	}
)

func (x DependencyErrorDetail_Error) Enum() *DependencyErrorDetail_Error {
	p := new(DependencyErrorDetail_Error)
	*p = x
	return p
}

func (x DependencyErrorDetail_Error) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DependencyErrorDetail_Error) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[12].Descriptor()
}

func (DependencyErrorDetail_Error) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[12]
}

func (x DependencyErrorDetail_Error) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DependencyErrorDetail_Error.Descriptor instead.
func (DependencyErrorDetail_Error) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{19, 0}
}

// State of the ApiHub Instance.
type ApiHubInstance_State int32

const (
	// The default value. This value is used if the state is omitted.
	ApiHubInstance_STATE_UNSPECIFIED ApiHubInstance_State = 0
	// The ApiHub instance has not been initialized or has been deleted.
	ApiHubInstance_INACTIVE ApiHubInstance_State = 1
	// The ApiHub instance is being created.
	ApiHubInstance_CREATING ApiHubInstance_State = 2
	// The ApiHub instance has been created and is ready for use.
	ApiHubInstance_ACTIVE ApiHubInstance_State = 3
	// The ApiHub instance is being updated.
	ApiHubInstance_UPDATING ApiHubInstance_State = 4
	// The ApiHub instance is being deleted.
	ApiHubInstance_DELETING ApiHubInstance_State = 5
	// The ApiHub instance encountered an error during a state change.
	ApiHubInstance_FAILED ApiHubInstance_State = 6
)

// Enum value maps for ApiHubInstance_State.
var (
	ApiHubInstance_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INACTIVE",
		2: "CREATING",
		3: "ACTIVE",
		4: "UPDATING",
		5: "DELETING",
		6: "FAILED",
	}
	ApiHubInstance_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"INACTIVE":          1,
		"CREATING":          2,
		"ACTIVE":            3,
		"UPDATING":          4,
		"DELETING":          5,
		"FAILED":            6,
	}
)

func (x ApiHubInstance_State) Enum() *ApiHubInstance_State {
	p := new(ApiHubInstance_State)
	*p = x
	return p
}

func (x ApiHubInstance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApiHubInstance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_common_fields_proto_enumTypes[13].Descriptor()
}

func (ApiHubInstance_State) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_common_fields_proto_enumTypes[13]
}

func (x ApiHubInstance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApiHubInstance_State.Descriptor instead.
func (ApiHubInstance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{25, 0}
}

// An API resource in the API Hub.
type Api struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the API resource in the API Hub.
	//
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the API resource.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the API resource.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The documentation for the API resource.
	Documentation *Documentation `protobuf:"bytes,4,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Optional. Owner details for the API resource.
	Owner *Owner `protobuf:"bytes,5,opt,name=owner,proto3" json:"owner,omitempty"`
	// Output only. The list of versions present in an API resource.
	// Note: An API resource can be associated with more than 1 version.
	// Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Versions []string `protobuf:"bytes,6,rep,name=versions,proto3" json:"versions,omitempty"`
	// Output only. The time at which the API resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the API resource was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The target users for the API.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-target-user`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	TargetUser *AttributeValues `protobuf:"bytes,9,opt,name=target_user,json=targetUser,proto3" json:"target_user,omitempty"`
	// Optional. The team owning the API.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-team`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Team *AttributeValues `protobuf:"bytes,10,opt,name=team,proto3" json:"team,omitempty"`
	// Optional. The business unit owning the API.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-business-unit`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	BusinessUnit *AttributeValues `protobuf:"bytes,11,opt,name=business_unit,json=businessUnit,proto3" json:"business_unit,omitempty"`
	// Optional. The maturity level of the API.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-maturity-level`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	MaturityLevel *AttributeValues `protobuf:"bytes,12,opt,name=maturity_level,json=maturityLevel,proto3" json:"maturity_level,omitempty"`
	// Optional. The list of user defined attributes associated with the API
	// resource. The key is the attribute name. It will be of the format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]*AttributeValues `protobuf:"bytes,13,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The style of the API.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-api-style`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	ApiStyle *AttributeValues `protobuf:"bytes,14,opt,name=api_style,json=apiStyle,proto3" json:"api_style,omitempty"`
	// Optional. The selected version for an API resource.
	// This can be used when special handling is needed on client side for
	// particular version of the API. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	SelectedVersion string `protobuf:"bytes,15,opt,name=selected_version,json=selectedVersion,proto3" json:"selected_version,omitempty"`
}

func (x *Api) Reset() {
	*x = Api{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Api) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Api) ProtoMessage() {}

func (x *Api) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Api.ProtoReflect.Descriptor instead.
func (*Api) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{0}
}

func (x *Api) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Api) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Api) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Api) GetDocumentation() *Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *Api) GetOwner() *Owner {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *Api) GetVersions() []string {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *Api) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Api) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Api) GetTargetUser() *AttributeValues {
	if x != nil {
		return x.TargetUser
	}
	return nil
}

func (x *Api) GetTeam() *AttributeValues {
	if x != nil {
		return x.Team
	}
	return nil
}

func (x *Api) GetBusinessUnit() *AttributeValues {
	if x != nil {
		return x.BusinessUnit
	}
	return nil
}

func (x *Api) GetMaturityLevel() *AttributeValues {
	if x != nil {
		return x.MaturityLevel
	}
	return nil
}

func (x *Api) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Api) GetApiStyle() *AttributeValues {
	if x != nil {
		return x.ApiStyle
	}
	return nil
}

func (x *Api) GetSelectedVersion() string {
	if x != nil {
		return x.SelectedVersion
	}
	return ""
}

// Represents a version of the API resource in API hub. This is also referred
// to as the API version.
type Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the version.
	//
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the version.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the version.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The documentation of the version.
	Documentation *Documentation `protobuf:"bytes,4,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Output only. The specs associated with this version.
	// Note that an API version can be associated with multiple specs.
	// Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Specs []string `protobuf:"bytes,5,rep,name=specs,proto3" json:"specs,omitempty"`
	// Output only. The operations contained in the API version.
	// These operations will be added to the version when a new spec is
	// added or when an existing spec is updated. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
	ApiOperations []string `protobuf:"bytes,6,rep,name=api_operations,json=apiOperations,proto3" json:"api_operations,omitempty"`
	// Output only. The definitions contained in the API version.
	// These definitions will be added to the version when a new spec is
	// added or when an existing spec is updated. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
	Definitions []string `protobuf:"bytes,7,rep,name=definitions,proto3" json:"definitions,omitempty"`
	// Optional. The deployments linked to this API version.
	// Note: A particular API version could be deployed to multiple deployments
	// (for dev deployment, UAT deployment, etc)
	// Format is
	// `projects/{project}/locations/{location}/deployments/{deployment}`
	Deployments []string `protobuf:"bytes,8,rep,name=deployments,proto3" json:"deployments,omitempty"`
	// Output only. The time at which the version was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the version was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The lifecycle of the API version.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-lifecycle`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Lifecycle *AttributeValues `protobuf:"bytes,11,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// Optional. The compliance associated with the API version.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-compliance`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Compliance *AttributeValues `protobuf:"bytes,12,opt,name=compliance,proto3" json:"compliance,omitempty"`
	// Optional. The accreditations associated with the API version.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-accreditation`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Accreditation *AttributeValues `protobuf:"bytes,13,opt,name=accreditation,proto3" json:"accreditation,omitempty"`
	// Optional. The list of user defined attributes associated with the Version
	// resource. The key is the attribute name. It will be of the format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]*AttributeValues `protobuf:"bytes,14,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The selected deployment for a Version resource.
	// This can be used when special handling is needed on client side for a
	// particular deployment linked to the version.
	// Format is
	// `projects/{project}/locations/{location}/deployments/{deployment}`
	SelectedDeployment string `protobuf:"bytes,16,opt,name=selected_deployment,json=selectedDeployment,proto3" json:"selected_deployment,omitempty"`
}

func (x *Version) Reset() {
	*x = Version{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Version) ProtoMessage() {}

func (x *Version) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Version.ProtoReflect.Descriptor instead.
func (*Version) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{1}
}

func (x *Version) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Version) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Version) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Version) GetDocumentation() *Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *Version) GetSpecs() []string {
	if x != nil {
		return x.Specs
	}
	return nil
}

func (x *Version) GetApiOperations() []string {
	if x != nil {
		return x.ApiOperations
	}
	return nil
}

func (x *Version) GetDefinitions() []string {
	if x != nil {
		return x.Definitions
	}
	return nil
}

func (x *Version) GetDeployments() []string {
	if x != nil {
		return x.Deployments
	}
	return nil
}

func (x *Version) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Version) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Version) GetLifecycle() *AttributeValues {
	if x != nil {
		return x.Lifecycle
	}
	return nil
}

func (x *Version) GetCompliance() *AttributeValues {
	if x != nil {
		return x.Compliance
	}
	return nil
}

func (x *Version) GetAccreditation() *AttributeValues {
	if x != nil {
		return x.Accreditation
	}
	return nil
}

func (x *Version) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Version) GetSelectedDeployment() string {
	if x != nil {
		return x.SelectedDeployment
	}
	return ""
}

// Represents a spec associated with an API version in the API
// Hub. Note that specs of various types can be uploaded, however
// parsing of details is supported for OpenAPI spec currently.
type Spec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the spec.
	//
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the spec.
	// This can contain the file name of the spec.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The type of spec.
	// The value should be one of the allowed values defined for
	// `projects/{project}/locations/{location}/attributes/system-spec-type`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API.
	//
	// Note, this field is mandatory if content is provided.
	SpecType *AttributeValues `protobuf:"bytes,3,opt,name=spec_type,json=specType,proto3" json:"spec_type,omitempty"`
	// Optional. Input only. The contents of the uploaded spec.
	Contents *SpecContents `protobuf:"bytes,4,opt,name=contents,proto3" json:"contents,omitempty"`
	// Output only. Details parsed from the spec.
	Details *SpecDetails `protobuf:"bytes,5,opt,name=details,proto3" json:"details,omitempty"`
	// Optional. The URI of the spec source in case file is uploaded
	// from an external version control system.
	SourceUri string `protobuf:"bytes,6,opt,name=source_uri,json=sourceUri,proto3" json:"source_uri,omitempty"`
	// Output only. The time at which the spec was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the spec was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The lint response for the spec.
	LintResponse *LintResponse `protobuf:"bytes,9,opt,name=lint_response,json=lintResponse,proto3" json:"lint_response,omitempty"`
	// Optional. The list of user defined attributes associated with the spec.
	// The key is the attribute name. It will be of the format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]*AttributeValues `protobuf:"bytes,10,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The documentation of the spec.
	// For OpenAPI spec, this will be populated from `externalDocs` in OpenAPI
	// spec.
	Documentation *Documentation `protobuf:"bytes,11,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Optional. Input only. Enum specifying the parsing mode for OpenAPI
	// Specification (OAS) parsing.
	ParsingMode Spec_ParsingMode `protobuf:"varint,12,opt,name=parsing_mode,json=parsingMode,proto3,enum=google.cloud.apihub.v1.Spec_ParsingMode" json:"parsing_mode,omitempty"`
}

func (x *Spec) Reset() {
	*x = Spec{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Spec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Spec) ProtoMessage() {}

func (x *Spec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Spec.ProtoReflect.Descriptor instead.
func (*Spec) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{2}
}

func (x *Spec) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Spec) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Spec) GetSpecType() *AttributeValues {
	if x != nil {
		return x.SpecType
	}
	return nil
}

func (x *Spec) GetContents() *SpecContents {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *Spec) GetDetails() *SpecDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *Spec) GetSourceUri() string {
	if x != nil {
		return x.SourceUri
	}
	return ""
}

func (x *Spec) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Spec) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Spec) GetLintResponse() *LintResponse {
	if x != nil {
		return x.LintResponse
	}
	return nil
}

func (x *Spec) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Spec) GetDocumentation() *Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *Spec) GetParsingMode() Spec_ParsingMode {
	if x != nil {
		return x.ParsingMode
	}
	return Spec_PARSING_MODE_UNSPECIFIED
}

// Details of the deployment where APIs are hosted.
// A deployment could represent an Apigee proxy, API gateway, other Google Cloud
// services or non-Google Cloud services as well. A deployment entity is a root
// level entity in the API hub and exists independent of any API.
type Deployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the deployment.
	//
	// Format:
	// `projects/{project}/locations/{location}/deployments/{deployment}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the deployment.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the deployment.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The documentation of the deployment.
	Documentation *Documentation `protobuf:"bytes,4,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Required. The type of deployment.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-deployment-type`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	DeploymentType *AttributeValues `protobuf:"bytes,5,opt,name=deployment_type,json=deploymentType,proto3" json:"deployment_type,omitempty"`
	// Required. A URI to the runtime resource. This URI can be used to manage the
	// resource. For example, if the runtime resource is of type APIGEE_PROXY,
	// then this field will contain the URI to the management UI of the proxy.
	ResourceUri string `protobuf:"bytes,6,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// Required. The endpoints at which this deployment resource is listening for
	// API requests. This could be a list of complete URIs, hostnames or an IP
	// addresses.
	Endpoints []string `protobuf:"bytes,7,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Output only. The API versions linked to this deployment.
	// Note: A particular deployment could be linked to multiple different API
	// versions (of same or different APIs).
	ApiVersions []string `protobuf:"bytes,8,rep,name=api_versions,json=apiVersions,proto3" json:"api_versions,omitempty"`
	// Output only. The time at which the deployment was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the deployment was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The SLO for this deployment.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-slo`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Slo *AttributeValues `protobuf:"bytes,11,opt,name=slo,proto3" json:"slo,omitempty"`
	// Optional. The environment mapping to this deployment.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-environment`
	// attribute.
	// The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Environment *AttributeValues `protobuf:"bytes,12,opt,name=environment,proto3" json:"environment,omitempty"`
	// Optional. The list of user defined attributes associated with the
	// deployment resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]*AttributeValues `protobuf:"bytes,13,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Deployment) Reset() {
	*x = Deployment{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Deployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Deployment) ProtoMessage() {}

func (x *Deployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Deployment.ProtoReflect.Descriptor instead.
func (*Deployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{3}
}

func (x *Deployment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Deployment) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Deployment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Deployment) GetDocumentation() *Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *Deployment) GetDeploymentType() *AttributeValues {
	if x != nil {
		return x.DeploymentType
	}
	return nil
}

func (x *Deployment) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *Deployment) GetEndpoints() []string {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *Deployment) GetApiVersions() []string {
	if x != nil {
		return x.ApiVersions
	}
	return nil
}

func (x *Deployment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Deployment) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Deployment) GetSlo() *AttributeValues {
	if x != nil {
		return x.Slo
	}
	return nil
}

func (x *Deployment) GetEnvironment() *AttributeValues {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *Deployment) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Represents an operation contained in an API version in the API Hub.
// An operation is added/updated/deleted in an API version when a new spec is
// added or an existing spec is updated/deleted in a version.
// Currently, an operation will be created only corresponding to OpenAPI spec as
// parsing is supported for OpenAPI spec.
type ApiOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the operation.
	//
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The name of the spec from where the operation was parsed.
	// Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Spec string `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// Output only. Operation details.
	Details *OperationDetails `protobuf:"bytes,3,opt,name=details,proto3" json:"details,omitempty"`
	// Output only. The time at which the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the operation was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The list of user defined attributes associated with the API
	// operation resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]*AttributeValues `protobuf:"bytes,6,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ApiOperation) Reset() {
	*x = ApiOperation{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApiOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiOperation) ProtoMessage() {}

func (x *ApiOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiOperation.ProtoReflect.Descriptor instead.
func (*ApiOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{4}
}

func (x *ApiOperation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApiOperation) GetSpec() string {
	if x != nil {
		return x.Spec
	}
	return ""
}

func (x *ApiOperation) GetDetails() *OperationDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *ApiOperation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ApiOperation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ApiOperation) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Represents a definition for example schema, request, response definitions
// contained in an API version.
// A definition is added/updated/deleted in an API version when a new spec is
// added or an existing spec is updated/deleted in a version. Currently,
// definition will be created only corresponding to OpenAPI spec as parsing is
// supported for OpenAPI spec. Also, within OpenAPI spec, only `schema` object
// is supported.
type Definition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*Definition_Schema
	Value isDefinition_Value `protobuf_oneof:"value"`
	// Identifier. The name of the definition.
	//
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The name of the spec from where the definition was parsed.
	// Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
	Spec string `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// Output only. The type of the definition.
	Type Definition_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.apihub.v1.Definition_Type" json:"type,omitempty"`
	// Output only. The time at which the definition was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the definition was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The list of user defined attributes associated with the
	// definition resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]*AttributeValues `protobuf:"bytes,7,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Definition) Reset() {
	*x = Definition{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Definition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Definition) ProtoMessage() {}

func (x *Definition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Definition.ProtoReflect.Descriptor instead.
func (*Definition) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{5}
}

func (m *Definition) GetValue() isDefinition_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Definition) GetSchema() *Schema {
	if x, ok := x.GetValue().(*Definition_Schema); ok {
		return x.Schema
	}
	return nil
}

func (x *Definition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Definition) GetSpec() string {
	if x != nil {
		return x.Spec
	}
	return ""
}

func (x *Definition) GetType() Definition_Type {
	if x != nil {
		return x.Type
	}
	return Definition_TYPE_UNSPECIFIED
}

func (x *Definition) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Definition) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Definition) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

type isDefinition_Value interface {
	isDefinition_Value()
}

type Definition_Schema struct {
	// Output only. The value of a schema definition.
	Schema *Schema `protobuf:"bytes,4,opt,name=schema,proto3,oneof"`
}

func (*Definition_Schema) isDefinition_Value() {}

// An attribute in the API Hub.
// An attribute is a name value pair which can be attached to different
// resources in the API hub based on the scope of the attribute. Attributes can
// either be pre-defined by the API Hub or created by users.
type Attribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the attribute in the API Hub.
	//
	// Format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the attribute.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the attribute.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The definition type of the attribute.
	DefinitionType Attribute_DefinitionType `protobuf:"varint,4,opt,name=definition_type,json=definitionType,proto3,enum=google.cloud.apihub.v1.Attribute_DefinitionType" json:"definition_type,omitempty"`
	// Required. The scope of the attribute. It represents the resource in the API
	// Hub to which the attribute can be linked.
	Scope Attribute_Scope `protobuf:"varint,5,opt,name=scope,proto3,enum=google.cloud.apihub.v1.Attribute_Scope" json:"scope,omitempty"`
	// Required. The type of the data of the attribute.
	DataType Attribute_DataType `protobuf:"varint,6,opt,name=data_type,json=dataType,proto3,enum=google.cloud.apihub.v1.Attribute_DataType" json:"data_type,omitempty"`
	// Optional. The list of allowed values when the attribute value is of type
	// enum. This is required when the data_type of the attribute is ENUM. The
	// maximum number of allowed values of an attribute will be 1000.
	AllowedValues []*Attribute_AllowedValue `protobuf:"bytes,7,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	// Optional. The maximum number of values that the attribute can have when
	// associated with an API Hub resource. Cardinality 1 would represent a
	// single-valued attribute. It must not be less than 1 or greater than 20. If
	// not specified, the cardinality would be set to 1 by default and represent a
	// single-valued attribute.
	Cardinality int32 `protobuf:"varint,8,opt,name=cardinality,proto3" json:"cardinality,omitempty"`
	// Output only. When mandatory is true, the attribute is mandatory for the
	// resource specified in the scope. Only System defined attributes can be
	// mandatory.
	Mandatory bool `protobuf:"varint,9,opt,name=mandatory,proto3" json:"mandatory,omitempty"`
	// Output only. The time at which the attribute was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the attribute was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Attribute) Reset() {
	*x = Attribute{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Attribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attribute) ProtoMessage() {}

func (x *Attribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attribute.ProtoReflect.Descriptor instead.
func (*Attribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{6}
}

func (x *Attribute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Attribute) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Attribute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Attribute) GetDefinitionType() Attribute_DefinitionType {
	if x != nil {
		return x.DefinitionType
	}
	return Attribute_DEFINITION_TYPE_UNSPECIFIED
}

func (x *Attribute) GetScope() Attribute_Scope {
	if x != nil {
		return x.Scope
	}
	return Attribute_SCOPE_UNSPECIFIED
}

func (x *Attribute) GetDataType() Attribute_DataType {
	if x != nil {
		return x.DataType
	}
	return Attribute_DATA_TYPE_UNSPECIFIED
}

func (x *Attribute) GetAllowedValues() []*Attribute_AllowedValue {
	if x != nil {
		return x.AllowedValues
	}
	return nil
}

func (x *Attribute) GetCardinality() int32 {
	if x != nil {
		return x.Cardinality
	}
	return 0
}

func (x *Attribute) GetMandatory() bool {
	if x != nil {
		return x.Mandatory
	}
	return false
}

func (x *Attribute) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Attribute) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The spec contents.
type SpecContents struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The contents of the spec.
	Contents []byte `protobuf:"bytes,1,opt,name=contents,proto3" json:"contents,omitempty"`
	// Required. The mime type of the content for example application/json,
	// application/yaml, application/wsdl etc.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *SpecContents) Reset() {
	*x = SpecContents{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpecContents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpecContents) ProtoMessage() {}

func (x *SpecContents) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpecContents.ProtoReflect.Descriptor instead.
func (*SpecContents) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{7}
}

func (x *SpecContents) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *SpecContents) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// SpecDetails contains the details parsed from supported
// spec types.
type SpecDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Details:
	//
	//	*SpecDetails_OpenApiSpecDetails
	Details isSpecDetails_Details `protobuf_oneof:"details"`
	// Output only. The description of the spec.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *SpecDetails) Reset() {
	*x = SpecDetails{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpecDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpecDetails) ProtoMessage() {}

func (x *SpecDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpecDetails.ProtoReflect.Descriptor instead.
func (*SpecDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{8}
}

func (m *SpecDetails) GetDetails() isSpecDetails_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *SpecDetails) GetOpenApiSpecDetails() *OpenApiSpecDetails {
	if x, ok := x.GetDetails().(*SpecDetails_OpenApiSpecDetails); ok {
		return x.OpenApiSpecDetails
	}
	return nil
}

func (x *SpecDetails) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

type isSpecDetails_Details interface {
	isSpecDetails_Details()
}

type SpecDetails_OpenApiSpecDetails struct {
	// Output only. Additional details apart from `OperationDetails` parsed from
	// an OpenAPI spec. The OperationDetails parsed from the spec can be
	// obtained by using
	// [ListAPIOperations][google.cloud.apihub.v1.ApiHub.ListApiOperations]
	// method.
	OpenApiSpecDetails *OpenApiSpecDetails `protobuf:"bytes,2,opt,name=open_api_spec_details,json=openApiSpecDetails,proto3,oneof"`
}

func (*SpecDetails_OpenApiSpecDetails) isSpecDetails_Details() {}

// OpenApiSpecDetails contains the details parsed from an OpenAPI spec in
// addition to the fields mentioned in
// [SpecDetails][google.cloud.apihub.v1.SpecDetails].
type OpenApiSpecDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The format of the spec.
	Format OpenApiSpecDetails_Format `protobuf:"varint,1,opt,name=format,proto3,enum=google.cloud.apihub.v1.OpenApiSpecDetails_Format" json:"format,omitempty"`
	// Output only. The version in the spec.
	// This maps to `info.version` in OpenAPI spec.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. Owner details for the spec.
	// This maps to `info.contact` in OpenAPI spec.
	Owner *Owner `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
}

func (x *OpenApiSpecDetails) Reset() {
	*x = OpenApiSpecDetails{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenApiSpecDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenApiSpecDetails) ProtoMessage() {}

func (x *OpenApiSpecDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenApiSpecDetails.ProtoReflect.Descriptor instead.
func (*OpenApiSpecDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{9}
}

func (x *OpenApiSpecDetails) GetFormat() OpenApiSpecDetails_Format {
	if x != nil {
		return x.Format
	}
	return OpenApiSpecDetails_FORMAT_UNSPECIFIED
}

func (x *OpenApiSpecDetails) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *OpenApiSpecDetails) GetOwner() *Owner {
	if x != nil {
		return x.Owner
	}
	return nil
}

// The operation details parsed from the spec.
type OperationDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Operation:
	//
	//	*OperationDetails_HttpOperation
	Operation isOperationDetails_Operation `protobuf_oneof:"operation"`
	// Output only. Description of the operation behavior.
	// For OpenAPI spec, this will map to `operation.description` in the
	// spec, in case description is empty, `operation.summary` will be used.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Additional external documentation for this operation.
	// For OpenAPI spec, this will map to `operation.documentation` in the spec.
	Documentation *Documentation `protobuf:"bytes,2,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Output only. For OpenAPI spec, this will be set if `operation.deprecated`is
	// marked as `true` in the spec.
	Deprecated bool `protobuf:"varint,3,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
}

func (x *OperationDetails) Reset() {
	*x = OperationDetails{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationDetails) ProtoMessage() {}

func (x *OperationDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationDetails.ProtoReflect.Descriptor instead.
func (*OperationDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{10}
}

func (m *OperationDetails) GetOperation() isOperationDetails_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *OperationDetails) GetHttpOperation() *HttpOperation {
	if x, ok := x.GetOperation().(*OperationDetails_HttpOperation); ok {
		return x.HttpOperation
	}
	return nil
}

func (x *OperationDetails) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *OperationDetails) GetDocumentation() *Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *OperationDetails) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

type isOperationDetails_Operation interface {
	isOperationDetails_Operation()
}

type OperationDetails_HttpOperation struct {
	// The HTTP Operation.
	HttpOperation *HttpOperation `protobuf:"bytes,4,opt,name=http_operation,json=httpOperation,proto3,oneof"`
}

func (*OperationDetails_HttpOperation) isOperationDetails_Operation() {}

// The HTTP Operation.
type HttpOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The path details for the Operation.
	Path *Path `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Output only. Operation method
	Method HttpOperation_Method `protobuf:"varint,2,opt,name=method,proto3,enum=google.cloud.apihub.v1.HttpOperation_Method" json:"method,omitempty"`
}

func (x *HttpOperation) Reset() {
	*x = HttpOperation{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpOperation) ProtoMessage() {}

func (x *HttpOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpOperation.ProtoReflect.Descriptor instead.
func (*HttpOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{11}
}

func (x *HttpOperation) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *HttpOperation) GetMethod() HttpOperation_Method {
	if x != nil {
		return x.Method
	}
	return HttpOperation_METHOD_UNSPECIFIED
}

// The path details derived from the spec.
type Path struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Complete path relative to server endpoint.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Output only. A short description for the path applicable to all operations.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Path) Reset() {
	*x = Path{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Path) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Path) ProtoMessage() {}

func (x *Path) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Path.ProtoReflect.Descriptor instead.
func (*Path) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{12}
}

func (x *Path) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Path) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// The schema details derived from the spec. Currently, this entity is supported
// for OpenAPI spec only.
// For OpenAPI spec, this maps to the schema defined in
// the  `definitions` section for OpenAPI 2.0 version and in
// `components.schemas` section for OpenAPI 3.0 and 3.1 version.
type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The display name of the schema.
	// This will map to the name of the schema in the spec.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The raw value of the schema definition corresponding to the
	// schema name in the spec.
	RawValue []byte `protobuf:"bytes,2,opt,name=raw_value,json=rawValue,proto3" json:"raw_value,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{13}
}

func (x *Schema) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Schema) GetRawValue() []byte {
	if x != nil {
		return x.RawValue
	}
	return nil
}

// Owner details.
type Owner struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the owner.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The email of the owner.
	Email string `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
}

func (x *Owner) Reset() {
	*x = Owner{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Owner) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Owner) ProtoMessage() {}

func (x *Owner) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Owner.ProtoReflect.Descriptor instead.
func (*Owner) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{14}
}

func (x *Owner) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Owner) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

// Documentation details.
type Documentation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The uri of the externally hosted documentation.
	ExternalUri string `protobuf:"bytes,1,opt,name=external_uri,json=externalUri,proto3" json:"external_uri,omitempty"`
}

func (x *Documentation) Reset() {
	*x = Documentation{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Documentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Documentation) ProtoMessage() {}

func (x *Documentation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Documentation.ProtoReflect.Descriptor instead.
func (*Documentation) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{15}
}

func (x *Documentation) GetExternalUri() string {
	if x != nil {
		return x.ExternalUri
	}
	return ""
}

// The attribute values associated with resource.
type AttributeValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The attribute values associated with the resource.
	//
	// Types that are assignable to Value:
	//
	//	*AttributeValues_EnumValues
	//	*AttributeValues_StringValues
	//	*AttributeValues_JsonValues
	Value isAttributeValues_Value `protobuf_oneof:"Value"`
	// Output only. The name of the attribute.
	// Format: projects/{project}/locations/{location}/attributes/{attribute}
	Attribute string `protobuf:"bytes,1,opt,name=attribute,proto3" json:"attribute,omitempty"`
}

func (x *AttributeValues) Reset() {
	*x = AttributeValues{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributeValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeValues) ProtoMessage() {}

func (x *AttributeValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeValues.ProtoReflect.Descriptor instead.
func (*AttributeValues) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{16}
}

func (m *AttributeValues) GetValue() isAttributeValues_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *AttributeValues) GetEnumValues() *AttributeValues_EnumAttributeValues {
	if x, ok := x.GetValue().(*AttributeValues_EnumValues); ok {
		return x.EnumValues
	}
	return nil
}

func (x *AttributeValues) GetStringValues() *AttributeValues_StringAttributeValues {
	if x, ok := x.GetValue().(*AttributeValues_StringValues); ok {
		return x.StringValues
	}
	return nil
}

func (x *AttributeValues) GetJsonValues() *AttributeValues_StringAttributeValues {
	if x, ok := x.GetValue().(*AttributeValues_JsonValues); ok {
		return x.JsonValues
	}
	return nil
}

func (x *AttributeValues) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

type isAttributeValues_Value interface {
	isAttributeValues_Value()
}

type AttributeValues_EnumValues struct {
	// The attribute values associated with a resource in case attribute data
	// type is enum.
	EnumValues *AttributeValues_EnumAttributeValues `protobuf:"bytes,2,opt,name=enum_values,json=enumValues,proto3,oneof"`
}

type AttributeValues_StringValues struct {
	// The attribute values associated with a resource in case attribute data
	// type is string.
	StringValues *AttributeValues_StringAttributeValues `protobuf:"bytes,3,opt,name=string_values,json=stringValues,proto3,oneof"`
}

type AttributeValues_JsonValues struct {
	// The attribute values associated with a resource in case attribute data
	// type is JSON.
	JsonValues *AttributeValues_StringAttributeValues `protobuf:"bytes,4,opt,name=json_values,json=jsonValues,proto3,oneof"`
}

func (*AttributeValues_EnumValues) isAttributeValues_Value() {}

func (*AttributeValues_StringValues) isAttributeValues_Value() {}

func (*AttributeValues_JsonValues) isAttributeValues_Value() {}

// A dependency resource defined in the API hub describes a dependency directed
// from a consumer to a supplier entity. A dependency can be defined between two
// [Operations][google.cloud.apihub.v1.Operation] or between
// an [Operation][google.cloud.apihub.v1.Operation] and [External
// API][google.cloud.apihub.v1.ExternalApi].
type Dependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the dependency in the API Hub.
	//
	// Format: `projects/{project}/locations/{location}/dependencies/{dependency}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The entity acting as the consumer in the dependency.
	Consumer *DependencyEntityReference `protobuf:"bytes,2,opt,name=consumer,proto3" json:"consumer,omitempty"`
	// Required. Immutable. The entity acting as the supplier in the dependency.
	Supplier *DependencyEntityReference `protobuf:"bytes,3,opt,name=supplier,proto3" json:"supplier,omitempty"`
	// Output only. State of the dependency.
	State Dependency_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.apihub.v1.Dependency_State" json:"state,omitempty"`
	// Optional. Human readable description corresponding of the dependency.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Discovery mode of the dependency.
	DiscoveryMode Dependency_DiscoveryMode `protobuf:"varint,6,opt,name=discovery_mode,json=discoveryMode,proto3,enum=google.cloud.apihub.v1.Dependency_DiscoveryMode" json:"discovery_mode,omitempty"`
	// Output only. Error details of a dependency if the system has detected it
	// internally.
	ErrorDetail *DependencyErrorDetail `protobuf:"bytes,7,opt,name=error_detail,json=errorDetail,proto3" json:"error_detail,omitempty"`
	// Output only. The time at which the dependency was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the dependency was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The list of user defined attributes associated with the
	// dependency resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]*AttributeValues `protobuf:"bytes,10,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Dependency) Reset() {
	*x = Dependency{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Dependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dependency) ProtoMessage() {}

func (x *Dependency) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dependency.ProtoReflect.Descriptor instead.
func (*Dependency) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{17}
}

func (x *Dependency) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Dependency) GetConsumer() *DependencyEntityReference {
	if x != nil {
		return x.Consumer
	}
	return nil
}

func (x *Dependency) GetSupplier() *DependencyEntityReference {
	if x != nil {
		return x.Supplier
	}
	return nil
}

func (x *Dependency) GetState() Dependency_State {
	if x != nil {
		return x.State
	}
	return Dependency_STATE_UNSPECIFIED
}

func (x *Dependency) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Dependency) GetDiscoveryMode() Dependency_DiscoveryMode {
	if x != nil {
		return x.DiscoveryMode
	}
	return Dependency_DISCOVERY_MODE_UNSPECIFIED
}

func (x *Dependency) GetErrorDetail() *DependencyErrorDetail {
	if x != nil {
		return x.ErrorDetail
	}
	return nil
}

func (x *Dependency) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Dependency) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Dependency) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Reference to an entity participating in a dependency.
type DependencyEntityReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique identifier for the participating entity.
	//
	// Types that are assignable to Identifier:
	//
	//	*DependencyEntityReference_OperationResourceName
	//	*DependencyEntityReference_ExternalApiResourceName
	Identifier isDependencyEntityReference_Identifier `protobuf_oneof:"identifier"`
	// Output only. Display name of the entity.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *DependencyEntityReference) Reset() {
	*x = DependencyEntityReference{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DependencyEntityReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DependencyEntityReference) ProtoMessage() {}

func (x *DependencyEntityReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DependencyEntityReference.ProtoReflect.Descriptor instead.
func (*DependencyEntityReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{18}
}

func (m *DependencyEntityReference) GetIdentifier() isDependencyEntityReference_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (x *DependencyEntityReference) GetOperationResourceName() string {
	if x, ok := x.GetIdentifier().(*DependencyEntityReference_OperationResourceName); ok {
		return x.OperationResourceName
	}
	return ""
}

func (x *DependencyEntityReference) GetExternalApiResourceName() string {
	if x, ok := x.GetIdentifier().(*DependencyEntityReference_ExternalApiResourceName); ok {
		return x.ExternalApiResourceName
	}
	return ""
}

func (x *DependencyEntityReference) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

type isDependencyEntityReference_Identifier interface {
	isDependencyEntityReference_Identifier()
}

type DependencyEntityReference_OperationResourceName struct {
	// The resource name of an operation in the API Hub.
	//
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
	OperationResourceName string `protobuf:"bytes,2,opt,name=operation_resource_name,json=operationResourceName,proto3,oneof"`
}

type DependencyEntityReference_ExternalApiResourceName struct {
	// The resource name of an external API in the API Hub.
	//
	// Format:
	// `projects/{project}/locations/{location}/externalApis/{external_api}`
	ExternalApiResourceName string `protobuf:"bytes,3,opt,name=external_api_resource_name,json=externalApiResourceName,proto3,oneof"`
}

func (*DependencyEntityReference_OperationResourceName) isDependencyEntityReference_Identifier() {}

func (*DependencyEntityReference_ExternalApiResourceName) isDependencyEntityReference_Identifier() {}

// Details describing error condition of a dependency.
type DependencyErrorDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Error in the dependency.
	Error DependencyErrorDetail_Error `protobuf:"varint,1,opt,name=error,proto3,enum=google.cloud.apihub.v1.DependencyErrorDetail_Error" json:"error,omitempty"`
	// Optional. Timestamp at which the error was found.
	ErrorTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=error_time,json=errorTime,proto3" json:"error_time,omitempty"`
}

func (x *DependencyErrorDetail) Reset() {
	*x = DependencyErrorDetail{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DependencyErrorDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DependencyErrorDetail) ProtoMessage() {}

func (x *DependencyErrorDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DependencyErrorDetail.ProtoReflect.Descriptor instead.
func (*DependencyErrorDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{19}
}

func (x *DependencyErrorDetail) GetError() DependencyErrorDetail_Error {
	if x != nil {
		return x.Error
	}
	return DependencyErrorDetail_ERROR_UNSPECIFIED
}

func (x *DependencyErrorDetail) GetErrorTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ErrorTime
	}
	return nil
}

// LintResponse contains the response from the linter.
type LintResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Array of issues found in the analyzed document.
	Issues []*Issue `protobuf:"bytes,1,rep,name=issues,proto3" json:"issues,omitempty"`
	// Optional. Summary of all issue types and counts for each severity level.
	Summary []*LintResponse_SummaryEntry `protobuf:"bytes,2,rep,name=summary,proto3" json:"summary,omitempty"`
	// Required. Lint state represents success or failure for linting.
	State LintState `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.apihub.v1.LintState" json:"state,omitempty"`
	// Required. Name of the linting application.
	Source string `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	// Required. Name of the linter used.
	Linter Linter `protobuf:"varint,5,opt,name=linter,proto3,enum=google.cloud.apihub.v1.Linter" json:"linter,omitempty"`
	// Required. Timestamp when the linting response was generated.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *LintResponse) Reset() {
	*x = LintResponse{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LintResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LintResponse) ProtoMessage() {}

func (x *LintResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LintResponse.ProtoReflect.Descriptor instead.
func (*LintResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{20}
}

func (x *LintResponse) GetIssues() []*Issue {
	if x != nil {
		return x.Issues
	}
	return nil
}

func (x *LintResponse) GetSummary() []*LintResponse_SummaryEntry {
	if x != nil {
		return x.Summary
	}
	return nil
}

func (x *LintResponse) GetState() LintState {
	if x != nil {
		return x.State
	}
	return LintState_LINT_STATE_UNSPECIFIED
}

func (x *LintResponse) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *LintResponse) GetLinter() Linter {
	if x != nil {
		return x.Linter
	}
	return Linter_LINTER_UNSPECIFIED
}

func (x *LintResponse) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Issue contains the details of a single issue found by the linter.
type Issue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Rule code unique to each rule defined in linter.
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	// Required. An array of strings indicating the location in the analyzed
	// document where the rule was triggered.
	Path []string `protobuf:"bytes,2,rep,name=path,proto3" json:"path,omitempty"`
	// Required. Human-readable message describing the issue found by the linter.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// Required. Severity level of the rule violation.
	Severity Severity `protobuf:"varint,4,opt,name=severity,proto3,enum=google.cloud.apihub.v1.Severity" json:"severity,omitempty"`
	// Required. Object describing where in the file the issue was found.
	Range *Range `protobuf:"bytes,5,opt,name=range,proto3" json:"range,omitempty"`
}

func (x *Issue) Reset() {
	*x = Issue{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Issue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Issue) ProtoMessage() {}

func (x *Issue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Issue.ProtoReflect.Descriptor instead.
func (*Issue) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{21}
}

func (x *Issue) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *Issue) GetPath() []string {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *Issue) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Issue) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *Issue) GetRange() *Range {
	if x != nil {
		return x.Range
	}
	return nil
}

// Object describing where in the file the issue was found.
type Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Start of the issue.
	Start *Point `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// Required. End of the issue.
	End *Point `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *Range) Reset() {
	*x = Range{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Range) ProtoMessage() {}

func (x *Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Range.ProtoReflect.Descriptor instead.
func (*Range) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{22}
}

func (x *Range) GetStart() *Point {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *Range) GetEnd() *Point {
	if x != nil {
		return x.End
	}
	return nil
}

// Point within the file (line and character).
type Point struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Line number (zero-indexed).
	Line int32 `protobuf:"varint,1,opt,name=line,proto3" json:"line,omitempty"`
	// Required. Character position within the line (zero-indexed).
	Character int32 `protobuf:"varint,2,opt,name=character,proto3" json:"character,omitempty"`
}

func (x *Point) Reset() {
	*x = Point{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Point) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Point) ProtoMessage() {}

func (x *Point) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Point.ProtoReflect.Descriptor instead.
func (*Point) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{23}
}

func (x *Point) GetLine() int32 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *Point) GetCharacter() int32 {
	if x != nil {
		return x.Character
	}
	return 0
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{24}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// An ApiHubInstance represents the instance resources of the API Hub.
// Currently, only one ApiHub instance is allowed for each project.
type ApiHubInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Format:
	// `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The current state of the ApiHub instance.
	State ApiHubInstance_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.apihub.v1.ApiHubInstance_State" json:"state,omitempty"`
	// Output only. Extra information about ApiHub instance state. Currently the
	// message would be populated when state is `FAILED`.
	StateMessage string `protobuf:"bytes,5,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Required. Config of the ApiHub instance.
	Config *ApiHubInstance_Config `protobuf:"bytes,6,opt,name=config,proto3" json:"config,omitempty"`
	// Optional. Instance labels to represent user-provided metadata.
	// Refer to cloud documentation on labels for more details.
	// https://cloud.google.com/compute/docs/labeling-resources
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the ApiHub instance.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *ApiHubInstance) Reset() {
	*x = ApiHubInstance{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApiHubInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiHubInstance) ProtoMessage() {}

func (x *ApiHubInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiHubInstance.ProtoReflect.Descriptor instead.
func (*ApiHubInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{25}
}

func (x *ApiHubInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApiHubInstance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ApiHubInstance) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ApiHubInstance) GetState() ApiHubInstance_State {
	if x != nil {
		return x.State
	}
	return ApiHubInstance_STATE_UNSPECIFIED
}

func (x *ApiHubInstance) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *ApiHubInstance) GetConfig() *ApiHubInstance_Config {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ApiHubInstance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ApiHubInstance) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// An external API represents an API being provided by external sources. This
// can be used to model third-party APIs and can be used to define dependencies.
type ExternalApi struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Format:
	// `projects/{project}/locations/{location}/externalApi/{externalApi}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Display name of the external API. Max length is 63 characters
	// (Unicode Code Points).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description of the external API. Max length is 2000 characters
	// (Unicode Code Points).
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. List of endpoints on which this API is accessible.
	Endpoints []string `protobuf:"bytes,4,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Optional. List of paths served by this API.
	Paths []string `protobuf:"bytes,5,rep,name=paths,proto3" json:"paths,omitempty"`
	// Optional. Documentation of the external API.
	Documentation *Documentation `protobuf:"bytes,6,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Optional. The list of user defined attributes associated with the Version
	// resource. The key is the attribute name. It will be of the format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]*AttributeValues `protobuf:"bytes,7,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *ExternalApi) Reset() {
	*x = ExternalApi{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExternalApi) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalApi) ProtoMessage() {}

func (x *ExternalApi) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalApi.ProtoReflect.Descriptor instead.
func (*ExternalApi) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{26}
}

func (x *ExternalApi) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExternalApi) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ExternalApi) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ExternalApi) GetEndpoints() []string {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *ExternalApi) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *ExternalApi) GetDocumentation() *Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *ExternalApi) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *ExternalApi) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExternalApi) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The value that can be assigned to the attribute when the data type is
// enum.
type Attribute_AllowedValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the allowed value.
	// * If provided, the same will be used. The service will throw an error if
	// the specified id is already used by another allowed value in the same
	// attribute resource.
	// * If not provided, a system generated id derived from the display name
	// will be used. In this case, the service will handle conflict resolution
	// by adding a system generated suffix in case of duplicates.
	//
	// This value should be 4-63 characters, and valid characters
	// are /[a-z][0-9]-/.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Required. The display name of the allowed value.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The detailed description of the allowed value.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. When set to true, the allowed value cannot be updated or
	// deleted by the user. It can only be true for System defined attributes.
	Immutable bool `protobuf:"varint,4,opt,name=immutable,proto3" json:"immutable,omitempty"`
}

func (x *Attribute_AllowedValue) Reset() {
	*x = Attribute_AllowedValue{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Attribute_AllowedValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attribute_AllowedValue) ProtoMessage() {}

func (x *Attribute_AllowedValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attribute_AllowedValue.ProtoReflect.Descriptor instead.
func (*Attribute_AllowedValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Attribute_AllowedValue) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Attribute_AllowedValue) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Attribute_AllowedValue) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Attribute_AllowedValue) GetImmutable() bool {
	if x != nil {
		return x.Immutable
	}
	return false
}

// The attribute values of data type enum.
type AttributeValues_EnumAttributeValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The attribute values in case attribute data type is enum.
	Values []*Attribute_AllowedValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *AttributeValues_EnumAttributeValues) Reset() {
	*x = AttributeValues_EnumAttributeValues{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributeValues_EnumAttributeValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeValues_EnumAttributeValues) ProtoMessage() {}

func (x *AttributeValues_EnumAttributeValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeValues_EnumAttributeValues.ProtoReflect.Descriptor instead.
func (*AttributeValues_EnumAttributeValues) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{16, 0}
}

func (x *AttributeValues_EnumAttributeValues) GetValues() []*Attribute_AllowedValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// The attribute values of data type string or JSON.
type AttributeValues_StringAttributeValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The attribute values in case attribute data type is string or
	// JSON.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *AttributeValues_StringAttributeValues) Reset() {
	*x = AttributeValues_StringAttributeValues{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributeValues_StringAttributeValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeValues_StringAttributeValues) ProtoMessage() {}

func (x *AttributeValues_StringAttributeValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeValues_StringAttributeValues.ProtoReflect.Descriptor instead.
func (*AttributeValues_StringAttributeValues) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{16, 1}
}

func (x *AttributeValues_StringAttributeValues) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Count of issues with a given severity.
type LintResponse_SummaryEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Severity of the issue.
	Severity Severity `protobuf:"varint,1,opt,name=severity,proto3,enum=google.cloud.apihub.v1.Severity" json:"severity,omitempty"`
	// Required. Count of issues with the given severity.
	Count int32 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *LintResponse_SummaryEntry) Reset() {
	*x = LintResponse_SummaryEntry{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LintResponse_SummaryEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LintResponse_SummaryEntry) ProtoMessage() {}

func (x *LintResponse_SummaryEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LintResponse_SummaryEntry.ProtoReflect.Descriptor instead.
func (*LintResponse_SummaryEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{20, 0}
}

func (x *LintResponse_SummaryEntry) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *LintResponse_SummaryEntry) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Available configurations to provision an ApiHub Instance.
type ApiHubInstance_Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Customer Managed Encryption Key (CMEK) used for data
	// encryption. The CMEK name should follow the format of
	// `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`,
	// where the location must match the instance location.
	CmekKeyName string `protobuf:"bytes,1,opt,name=cmek_key_name,json=cmekKeyName,proto3" json:"cmek_key_name,omitempty"`
}

func (x *ApiHubInstance_Config) Reset() {
	*x = ApiHubInstance_Config{}
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApiHubInstance_Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiHubInstance_Config) ProtoMessage() {}

func (x *ApiHubInstance_Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_common_fields_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiHubInstance_Config.ProtoReflect.Descriptor instead.
func (*ApiHubInstance_Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP(), []int{25, 0}
}

func (x *ApiHubInstance_Config) GetCmekKeyName() string {
	if x != nil {
		return x.CmekKeyName
	}
	return ""
}

var File_google_cloud_apihub_v1_common_fields_proto protoreflect.FileDescriptor

var file_google_cloud_apihub_v1_common_fields_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xaf, 0x09, 0x0a, 0x03, 0x41, 0x70, 0x69, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x50, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x77, 0x6e, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x41, 0x0a,
	0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x65, 0x61, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x74, 0x65, 0x61, 0x6d, 0x12, 0x51, 0x0a, 0x0d, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x62, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x53, 0x0a, 0x0e, 0x6d, 0x61, 0x74, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d,
	0x6d, 0x61, 0x74, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x50, 0x0a,
	0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x2e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x49, 0x0a, 0x09, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x61, 0x70, 0x69, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x50, 0x0a, 0x10, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x66, 0x0a, 0x0f,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x5d, 0xea, 0x41, 0x5a, 0x0a, 0x19, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x70, 0x69, 0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x69, 0x7d, 0x2a, 0x04, 0x61, 0x70, 0x69, 0x73, 0x32, 0x03,
	0x61, 0x70, 0x69, 0x22, 0xf1, 0x09, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x05, 0x73, 0x70, 0x65,
	0x63, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1c,
	0x0a, 0x1a, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x73, 0x70,
	0x65, 0x63, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x61, 0x70, 0x69, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x69, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x61, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x4c,
	0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x0d,
	0x61, 0x63, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0d, 0x61, 0x63, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x54, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0e,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x13, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x1a, 0x66, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7c, 0xea, 0x41, 0x79, 0x0a, 0x1d,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x69,
	0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xc3, 0x08, 0x0a, 0x04, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x49, 0x0a, 0x09, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x73, 0x70, 0x65, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x48, 0x0a, 0x08,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x04, 0x52, 0x08, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x70, 0x65, 0x63, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x6c, 0x69, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x51, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x73, 0x69,
	0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x73,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x04, 0x52,
	0x0b, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x1a, 0x66, 0x0a, 0x0f,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x44, 0x0a, 0x0b, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x41, 0x52, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4c, 0x41, 0x58, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x10, 0x02, 0x3a, 0x80, 0x01, 0xea, 0x41, 0x7d,
	0x0a, 0x1a, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63, 0x12, 0x52, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x69, 0x7d,
	0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x65, 0x63, 0x7d,
	0x2a, 0x05, 0x73, 0x70, 0x65, 0x63, 0x73, 0x32, 0x04, 0x73, 0x70, 0x65, 0x63, 0x22, 0xe8, 0x07,
	0x0a, 0x0a, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x21, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x70, 0x69, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x03, 0x73, 0x6c, 0x6f, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x03, 0x73, 0x6c, 0x6f, 0x12, 0x4e, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x66, 0x0a,
	0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x20, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2a,
	0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x0a, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x95, 0x05, 0x0a, 0x0c, 0x41, 0x70, 0x69,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x36, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x22, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x47, 0x0a, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x1a, 0x66, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xa3, 0x01, 0xea, 0x41, 0x9f,
	0x01, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x69, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2a, 0x0d, 0x61, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x32, 0x0c, 0x61, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xf8, 0x05, 0x0a, 0x0a, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3d, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12,
	0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x66,
	0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x28, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x10, 0x01,
	0x3a, 0x9f, 0x01, 0xea, 0x41, 0x9b, 0x01, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x69, 0x7d, 0x2f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x0b, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe6, 0x09, 0x0a, 0x09,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x44, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x4c, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x41,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x25, 0x0a, 0x0b, 0x63, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x61, 0x72, 0x64, 0x69,
	0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x09, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x95, 0x01,
	0x0a, 0x0c, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x13,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x69, 0x6d, 0x6d, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x69, 0x6d, 0x6d, 0x75,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x57, 0x0a, 0x0e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x45, 0x46, 0x49, 0x4e,
	0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x59, 0x53, 0x54,
	0x45, 0x4d, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x02, 0x22, 0x9f,
	0x01, 0x0a, 0x05, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x43, 0x4f, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x41, 0x50, 0x49, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x50, 0x45, 0x43, 0x10, 0x03, 0x12,
	0x11, 0x0a, 0x0d, 0x41, 0x50, 0x49, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54,
	0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x43, 0x59,
	0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x41,
	0x50, 0x49, 0x10, 0x08, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x10, 0x09,
	0x22, 0x45, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x45, 0x4e, 0x55, 0x4d, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x3a, 0x7b, 0xea, 0x41, 0x78, 0x0a, 0x1f, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x3e, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x7d, 0x2a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x32, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x22, 0x51, 0x0a, 0x0c, 0x53, 0x70, 0x65, 0x63, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x0b, 0x53, 0x70, 0x65, 0x63,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x6f, 0x70, 0x65, 0x6e, 0x5f,
	0x61, 0x70, 0x69, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x53, 0x70, 0x65, 0x63, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x12, 0x6f, 0x70, 0x65, 0x6e, 0x41,
	0x70, 0x69, 0x53, 0x70, 0x65, 0x63, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22,
	0xa4, 0x02, 0x0a, 0x12, 0x4f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x53, 0x70, 0x65, 0x63, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x53, 0x70, 0x65, 0x63, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x22,
	0x65, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x4f, 0x52,
	0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x50, 0x45, 0x4e, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x53, 0x50,
	0x45, 0x43, 0x5f, 0x32, 0x5f, 0x30, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x50, 0x45, 0x4e,
	0x5f, 0x41, 0x50, 0x49, 0x5f, 0x53, 0x50, 0x45, 0x43, 0x5f, 0x33, 0x5f, 0x30, 0x10, 0x02, 0x12,
	0x15, 0x0a, 0x11, 0x4f, 0x50, 0x45, 0x4e, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x53, 0x50, 0x45, 0x43,
	0x5f, 0x33, 0x5f, 0x31, 0x10, 0x03, 0x22, 0x8d, 0x02, 0x0a, 0x10, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x0e, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74,
	0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x68, 0x74,
	0x74, 0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x02, 0x0a, 0x0d, 0x48, 0x74, 0x74, 0x70, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x74, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12,
	0x49, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x75, 0x0a, 0x06, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x47, 0x45, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x55, 0x54, 0x10, 0x02, 0x12, 0x08,
	0x0a, 0x04, 0x50, 0x4f, 0x53, 0x54, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10,
	0x05, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x45, 0x41, 0x44, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x50,
	0x41, 0x54, 0x43, 0x48, 0x10, 0x07, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x52, 0x41, 0x43, 0x45, 0x10,
	0x08, 0x22, 0x46, 0x0a, 0x04, 0x50, 0x61, 0x74, 0x68, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x52, 0x0a, 0x06, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x72,
	0x61, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x61, 0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x4a, 0x0a,
	0x05, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19,
	0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x22, 0x37, 0x0a, 0x0d, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x55,
	0x72, 0x69, 0x22, 0xa3, 0x04, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x5e, 0x0a, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x65, 0x6e, 0x75, 0x6d,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0c,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x0b,
	0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x48, 0x00, 0x52, 0x0a, 0x6a, 0x73, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x45,
	0x0a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x1a, 0x62, 0x0a, 0x13, 0x45, 0x6e, 0x75, 0x6d, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x34, 0x0a, 0x15, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42,
	0x07, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xb8, 0x08, 0x0a, 0x0a, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x55, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x08, 0x73, 0x75, 0x70, 0x70, 0x6c,
	0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x06, 0xe0, 0x41,
	0x05, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x12, 0x43,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x0e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x55, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x2e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x66, 0x0a, 0x0f,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x3b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x52, 0x4f, 0x50, 0x4f, 0x53, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10,
	0x02, 0x22, 0x3b, 0x0a, 0x0d, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x3a, 0x82,
	0x01, 0xea, 0x41, 0x7f, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x7d, 0x2a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x32, 0x0a, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x22, 0xca, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x38, 0x0a, 0x17, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x15, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x1a, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x17, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x22, 0xf7, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x4e, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3e, 0x0a, 0x0a, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x4e, 0x0a, 0x05, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x55,
	0x50, 0x50, 0x4c, 0x49, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44,
	0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x55, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x52, 0x5f, 0x52,
	0x45, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x22, 0xe4, 0x03, 0x0a, 0x0c, 0x4c,
	0x69, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x06, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x06, 0x6c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6c, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0x6c, 0x0a, 0x0c, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x41, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0xd5, 0x01, 0x0a, 0x05, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x63, 0x6f, 0x64, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1d, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x41, 0x0a, 0x08,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x38, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x77, 0x0a, 0x05, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x38, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x34, 0x0a, 0x03,
	0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x65,
	0x6e, 0x64, 0x22, 0x43, 0x0a, 0x05, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6c,
	0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x6c, 0x69, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72,
	0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a,
	0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xdc, 0x06, 0x0a, 0x0e, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x48,
	0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x31, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x27, 0x0a, 0x0d, 0x63, 0x6d, 0x65, 0x6b, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x6d,
	0x65, 0x6b, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x6e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x06, 0x3a, 0x97, 0x01, 0xea, 0x41, 0x93, 0x01, 0x0a, 0x24, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x4a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x70, 0x69, 0x48, 0x75,
	0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x69, 0x5f,
	0x68, 0x75, 0x62, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2a, 0x0f, 0x61,
	0x70, 0x69, 0x48, 0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x32, 0x0e,
	0x61, 0x70, 0x69, 0x48, 0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xd5,
	0x05, 0x0a, 0x0b, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x61, 0x74,
	0x68, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x70,
	0x61, 0x74, 0x68, 0x73, 0x12, 0x50, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x2e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0x66, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x87, 0x01, 0xea,
	0x41, 0x83, 0x01, 0x0a, 0x21, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x2f, 0x7b, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x7d, 0x2a, 0x0c, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x73, 0x32, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x41, 0x70, 0x69, 0x2a, 0x55, 0x0a, 0x09, 0x4c, 0x69, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4c, 0x49, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x16, 0x0a, 0x12, 0x4c, 0x49, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x49, 0x4e, 0x54, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x2a, 0x39, 0x0a,
	0x06, 0x4c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x53, 0x50, 0x45, 0x43, 0x54, 0x52, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x02, 0x2a, 0x74, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12,
	0x0a, 0x0e, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x57,
	0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x45, 0x56, 0x45,
	0x52, 0x49, 0x54, 0x59, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x53,
	0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x48, 0x49, 0x4e, 0x54, 0x10, 0x04, 0x42, 0x9b,
	0x02, 0xea, 0x41, 0x65, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x70, 0x62, 0x3b, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x70, 0x62, 0xaa, 0x02,
	0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70,
	0x69, 0x48, 0x75, 0x62, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_apihub_v1_common_fields_proto_rawDescOnce sync.Once
	file_google_cloud_apihub_v1_common_fields_proto_rawDescData = file_google_cloud_apihub_v1_common_fields_proto_rawDesc
)

func file_google_cloud_apihub_v1_common_fields_proto_rawDescGZIP() []byte {
	file_google_cloud_apihub_v1_common_fields_proto_rawDescOnce.Do(func() {
		file_google_cloud_apihub_v1_common_fields_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_apihub_v1_common_fields_proto_rawDescData)
	})
	return file_google_cloud_apihub_v1_common_fields_proto_rawDescData
}

var file_google_cloud_apihub_v1_common_fields_proto_enumTypes = make([]protoimpl.EnumInfo, 14)
var file_google_cloud_apihub_v1_common_fields_proto_msgTypes = make([]protoimpl.MessageInfo, 41)
var file_google_cloud_apihub_v1_common_fields_proto_goTypes = []any{
	(LintState)(0),                    // 0: google.cloud.apihub.v1.LintState
	(Linter)(0),                       // 1: google.cloud.apihub.v1.Linter
	(Severity)(0),                     // 2: google.cloud.apihub.v1.Severity
	(Spec_ParsingMode)(0),             // 3: google.cloud.apihub.v1.Spec.ParsingMode
	(Definition_Type)(0),              // 4: google.cloud.apihub.v1.Definition.Type
	(Attribute_DefinitionType)(0),     // 5: google.cloud.apihub.v1.Attribute.DefinitionType
	(Attribute_Scope)(0),              // 6: google.cloud.apihub.v1.Attribute.Scope
	(Attribute_DataType)(0),           // 7: google.cloud.apihub.v1.Attribute.DataType
	(OpenApiSpecDetails_Format)(0),    // 8: google.cloud.apihub.v1.OpenApiSpecDetails.Format
	(HttpOperation_Method)(0),         // 9: google.cloud.apihub.v1.HttpOperation.Method
	(Dependency_State)(0),             // 10: google.cloud.apihub.v1.Dependency.State
	(Dependency_DiscoveryMode)(0),     // 11: google.cloud.apihub.v1.Dependency.DiscoveryMode
	(DependencyErrorDetail_Error)(0),  // 12: google.cloud.apihub.v1.DependencyErrorDetail.Error
	(ApiHubInstance_State)(0),         // 13: google.cloud.apihub.v1.ApiHubInstance.State
	(*Api)(nil),                       // 14: google.cloud.apihub.v1.Api
	(*Version)(nil),                   // 15: google.cloud.apihub.v1.Version
	(*Spec)(nil),                      // 16: google.cloud.apihub.v1.Spec
	(*Deployment)(nil),                // 17: google.cloud.apihub.v1.Deployment
	(*ApiOperation)(nil),              // 18: google.cloud.apihub.v1.ApiOperation
	(*Definition)(nil),                // 19: google.cloud.apihub.v1.Definition
	(*Attribute)(nil),                 // 20: google.cloud.apihub.v1.Attribute
	(*SpecContents)(nil),              // 21: google.cloud.apihub.v1.SpecContents
	(*SpecDetails)(nil),               // 22: google.cloud.apihub.v1.SpecDetails
	(*OpenApiSpecDetails)(nil),        // 23: google.cloud.apihub.v1.OpenApiSpecDetails
	(*OperationDetails)(nil),          // 24: google.cloud.apihub.v1.OperationDetails
	(*HttpOperation)(nil),             // 25: google.cloud.apihub.v1.HttpOperation
	(*Path)(nil),                      // 26: google.cloud.apihub.v1.Path
	(*Schema)(nil),                    // 27: google.cloud.apihub.v1.Schema
	(*Owner)(nil),                     // 28: google.cloud.apihub.v1.Owner
	(*Documentation)(nil),             // 29: google.cloud.apihub.v1.Documentation
	(*AttributeValues)(nil),           // 30: google.cloud.apihub.v1.AttributeValues
	(*Dependency)(nil),                // 31: google.cloud.apihub.v1.Dependency
	(*DependencyEntityReference)(nil), // 32: google.cloud.apihub.v1.DependencyEntityReference
	(*DependencyErrorDetail)(nil),     // 33: google.cloud.apihub.v1.DependencyErrorDetail
	(*LintResponse)(nil),              // 34: google.cloud.apihub.v1.LintResponse
	(*Issue)(nil),                     // 35: google.cloud.apihub.v1.Issue
	(*Range)(nil),                     // 36: google.cloud.apihub.v1.Range
	(*Point)(nil),                     // 37: google.cloud.apihub.v1.Point
	(*OperationMetadata)(nil),         // 38: google.cloud.apihub.v1.OperationMetadata
	(*ApiHubInstance)(nil),            // 39: google.cloud.apihub.v1.ApiHubInstance
	(*ExternalApi)(nil),               // 40: google.cloud.apihub.v1.ExternalApi
	nil,                               // 41: google.cloud.apihub.v1.Api.AttributesEntry
	nil,                               // 42: google.cloud.apihub.v1.Version.AttributesEntry
	nil,                               // 43: google.cloud.apihub.v1.Spec.AttributesEntry
	nil,                               // 44: google.cloud.apihub.v1.Deployment.AttributesEntry
	nil,                               // 45: google.cloud.apihub.v1.ApiOperation.AttributesEntry
	nil,                               // 46: google.cloud.apihub.v1.Definition.AttributesEntry
	(*Attribute_AllowedValue)(nil),    // 47: google.cloud.apihub.v1.Attribute.AllowedValue
	(*AttributeValues_EnumAttributeValues)(nil),   // 48: google.cloud.apihub.v1.AttributeValues.EnumAttributeValues
	(*AttributeValues_StringAttributeValues)(nil), // 49: google.cloud.apihub.v1.AttributeValues.StringAttributeValues
	nil,                               // 50: google.cloud.apihub.v1.Dependency.AttributesEntry
	(*LintResponse_SummaryEntry)(nil), // 51: google.cloud.apihub.v1.LintResponse.SummaryEntry
	(*ApiHubInstance_Config)(nil),     // 52: google.cloud.apihub.v1.ApiHubInstance.Config
	nil,                               // 53: google.cloud.apihub.v1.ApiHubInstance.LabelsEntry
	nil,                               // 54: google.cloud.apihub.v1.ExternalApi.AttributesEntry
	(*timestamppb.Timestamp)(nil),     // 55: google.protobuf.Timestamp
}
var file_google_cloud_apihub_v1_common_fields_proto_depIdxs = []int32{
	29, // 0: google.cloud.apihub.v1.Api.documentation:type_name -> google.cloud.apihub.v1.Documentation
	28, // 1: google.cloud.apihub.v1.Api.owner:type_name -> google.cloud.apihub.v1.Owner
	55, // 2: google.cloud.apihub.v1.Api.create_time:type_name -> google.protobuf.Timestamp
	55, // 3: google.cloud.apihub.v1.Api.update_time:type_name -> google.protobuf.Timestamp
	30, // 4: google.cloud.apihub.v1.Api.target_user:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 5: google.cloud.apihub.v1.Api.team:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 6: google.cloud.apihub.v1.Api.business_unit:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 7: google.cloud.apihub.v1.Api.maturity_level:type_name -> google.cloud.apihub.v1.AttributeValues
	41, // 8: google.cloud.apihub.v1.Api.attributes:type_name -> google.cloud.apihub.v1.Api.AttributesEntry
	30, // 9: google.cloud.apihub.v1.Api.api_style:type_name -> google.cloud.apihub.v1.AttributeValues
	29, // 10: google.cloud.apihub.v1.Version.documentation:type_name -> google.cloud.apihub.v1.Documentation
	55, // 11: google.cloud.apihub.v1.Version.create_time:type_name -> google.protobuf.Timestamp
	55, // 12: google.cloud.apihub.v1.Version.update_time:type_name -> google.protobuf.Timestamp
	30, // 13: google.cloud.apihub.v1.Version.lifecycle:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 14: google.cloud.apihub.v1.Version.compliance:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 15: google.cloud.apihub.v1.Version.accreditation:type_name -> google.cloud.apihub.v1.AttributeValues
	42, // 16: google.cloud.apihub.v1.Version.attributes:type_name -> google.cloud.apihub.v1.Version.AttributesEntry
	30, // 17: google.cloud.apihub.v1.Spec.spec_type:type_name -> google.cloud.apihub.v1.AttributeValues
	21, // 18: google.cloud.apihub.v1.Spec.contents:type_name -> google.cloud.apihub.v1.SpecContents
	22, // 19: google.cloud.apihub.v1.Spec.details:type_name -> google.cloud.apihub.v1.SpecDetails
	55, // 20: google.cloud.apihub.v1.Spec.create_time:type_name -> google.protobuf.Timestamp
	55, // 21: google.cloud.apihub.v1.Spec.update_time:type_name -> google.protobuf.Timestamp
	34, // 22: google.cloud.apihub.v1.Spec.lint_response:type_name -> google.cloud.apihub.v1.LintResponse
	43, // 23: google.cloud.apihub.v1.Spec.attributes:type_name -> google.cloud.apihub.v1.Spec.AttributesEntry
	29, // 24: google.cloud.apihub.v1.Spec.documentation:type_name -> google.cloud.apihub.v1.Documentation
	3,  // 25: google.cloud.apihub.v1.Spec.parsing_mode:type_name -> google.cloud.apihub.v1.Spec.ParsingMode
	29, // 26: google.cloud.apihub.v1.Deployment.documentation:type_name -> google.cloud.apihub.v1.Documentation
	30, // 27: google.cloud.apihub.v1.Deployment.deployment_type:type_name -> google.cloud.apihub.v1.AttributeValues
	55, // 28: google.cloud.apihub.v1.Deployment.create_time:type_name -> google.protobuf.Timestamp
	55, // 29: google.cloud.apihub.v1.Deployment.update_time:type_name -> google.protobuf.Timestamp
	30, // 30: google.cloud.apihub.v1.Deployment.slo:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 31: google.cloud.apihub.v1.Deployment.environment:type_name -> google.cloud.apihub.v1.AttributeValues
	44, // 32: google.cloud.apihub.v1.Deployment.attributes:type_name -> google.cloud.apihub.v1.Deployment.AttributesEntry
	24, // 33: google.cloud.apihub.v1.ApiOperation.details:type_name -> google.cloud.apihub.v1.OperationDetails
	55, // 34: google.cloud.apihub.v1.ApiOperation.create_time:type_name -> google.protobuf.Timestamp
	55, // 35: google.cloud.apihub.v1.ApiOperation.update_time:type_name -> google.protobuf.Timestamp
	45, // 36: google.cloud.apihub.v1.ApiOperation.attributes:type_name -> google.cloud.apihub.v1.ApiOperation.AttributesEntry
	27, // 37: google.cloud.apihub.v1.Definition.schema:type_name -> google.cloud.apihub.v1.Schema
	4,  // 38: google.cloud.apihub.v1.Definition.type:type_name -> google.cloud.apihub.v1.Definition.Type
	55, // 39: google.cloud.apihub.v1.Definition.create_time:type_name -> google.protobuf.Timestamp
	55, // 40: google.cloud.apihub.v1.Definition.update_time:type_name -> google.protobuf.Timestamp
	46, // 41: google.cloud.apihub.v1.Definition.attributes:type_name -> google.cloud.apihub.v1.Definition.AttributesEntry
	5,  // 42: google.cloud.apihub.v1.Attribute.definition_type:type_name -> google.cloud.apihub.v1.Attribute.DefinitionType
	6,  // 43: google.cloud.apihub.v1.Attribute.scope:type_name -> google.cloud.apihub.v1.Attribute.Scope
	7,  // 44: google.cloud.apihub.v1.Attribute.data_type:type_name -> google.cloud.apihub.v1.Attribute.DataType
	47, // 45: google.cloud.apihub.v1.Attribute.allowed_values:type_name -> google.cloud.apihub.v1.Attribute.AllowedValue
	55, // 46: google.cloud.apihub.v1.Attribute.create_time:type_name -> google.protobuf.Timestamp
	55, // 47: google.cloud.apihub.v1.Attribute.update_time:type_name -> google.protobuf.Timestamp
	23, // 48: google.cloud.apihub.v1.SpecDetails.open_api_spec_details:type_name -> google.cloud.apihub.v1.OpenApiSpecDetails
	8,  // 49: google.cloud.apihub.v1.OpenApiSpecDetails.format:type_name -> google.cloud.apihub.v1.OpenApiSpecDetails.Format
	28, // 50: google.cloud.apihub.v1.OpenApiSpecDetails.owner:type_name -> google.cloud.apihub.v1.Owner
	25, // 51: google.cloud.apihub.v1.OperationDetails.http_operation:type_name -> google.cloud.apihub.v1.HttpOperation
	29, // 52: google.cloud.apihub.v1.OperationDetails.documentation:type_name -> google.cloud.apihub.v1.Documentation
	26, // 53: google.cloud.apihub.v1.HttpOperation.path:type_name -> google.cloud.apihub.v1.Path
	9,  // 54: google.cloud.apihub.v1.HttpOperation.method:type_name -> google.cloud.apihub.v1.HttpOperation.Method
	48, // 55: google.cloud.apihub.v1.AttributeValues.enum_values:type_name -> google.cloud.apihub.v1.AttributeValues.EnumAttributeValues
	49, // 56: google.cloud.apihub.v1.AttributeValues.string_values:type_name -> google.cloud.apihub.v1.AttributeValues.StringAttributeValues
	49, // 57: google.cloud.apihub.v1.AttributeValues.json_values:type_name -> google.cloud.apihub.v1.AttributeValues.StringAttributeValues
	32, // 58: google.cloud.apihub.v1.Dependency.consumer:type_name -> google.cloud.apihub.v1.DependencyEntityReference
	32, // 59: google.cloud.apihub.v1.Dependency.supplier:type_name -> google.cloud.apihub.v1.DependencyEntityReference
	10, // 60: google.cloud.apihub.v1.Dependency.state:type_name -> google.cloud.apihub.v1.Dependency.State
	11, // 61: google.cloud.apihub.v1.Dependency.discovery_mode:type_name -> google.cloud.apihub.v1.Dependency.DiscoveryMode
	33, // 62: google.cloud.apihub.v1.Dependency.error_detail:type_name -> google.cloud.apihub.v1.DependencyErrorDetail
	55, // 63: google.cloud.apihub.v1.Dependency.create_time:type_name -> google.protobuf.Timestamp
	55, // 64: google.cloud.apihub.v1.Dependency.update_time:type_name -> google.protobuf.Timestamp
	50, // 65: google.cloud.apihub.v1.Dependency.attributes:type_name -> google.cloud.apihub.v1.Dependency.AttributesEntry
	12, // 66: google.cloud.apihub.v1.DependencyErrorDetail.error:type_name -> google.cloud.apihub.v1.DependencyErrorDetail.Error
	55, // 67: google.cloud.apihub.v1.DependencyErrorDetail.error_time:type_name -> google.protobuf.Timestamp
	35, // 68: google.cloud.apihub.v1.LintResponse.issues:type_name -> google.cloud.apihub.v1.Issue
	51, // 69: google.cloud.apihub.v1.LintResponse.summary:type_name -> google.cloud.apihub.v1.LintResponse.SummaryEntry
	0,  // 70: google.cloud.apihub.v1.LintResponse.state:type_name -> google.cloud.apihub.v1.LintState
	1,  // 71: google.cloud.apihub.v1.LintResponse.linter:type_name -> google.cloud.apihub.v1.Linter
	55, // 72: google.cloud.apihub.v1.LintResponse.create_time:type_name -> google.protobuf.Timestamp
	2,  // 73: google.cloud.apihub.v1.Issue.severity:type_name -> google.cloud.apihub.v1.Severity
	36, // 74: google.cloud.apihub.v1.Issue.range:type_name -> google.cloud.apihub.v1.Range
	37, // 75: google.cloud.apihub.v1.Range.start:type_name -> google.cloud.apihub.v1.Point
	37, // 76: google.cloud.apihub.v1.Range.end:type_name -> google.cloud.apihub.v1.Point
	55, // 77: google.cloud.apihub.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	55, // 78: google.cloud.apihub.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	55, // 79: google.cloud.apihub.v1.ApiHubInstance.create_time:type_name -> google.protobuf.Timestamp
	55, // 80: google.cloud.apihub.v1.ApiHubInstance.update_time:type_name -> google.protobuf.Timestamp
	13, // 81: google.cloud.apihub.v1.ApiHubInstance.state:type_name -> google.cloud.apihub.v1.ApiHubInstance.State
	52, // 82: google.cloud.apihub.v1.ApiHubInstance.config:type_name -> google.cloud.apihub.v1.ApiHubInstance.Config
	53, // 83: google.cloud.apihub.v1.ApiHubInstance.labels:type_name -> google.cloud.apihub.v1.ApiHubInstance.LabelsEntry
	29, // 84: google.cloud.apihub.v1.ExternalApi.documentation:type_name -> google.cloud.apihub.v1.Documentation
	54, // 85: google.cloud.apihub.v1.ExternalApi.attributes:type_name -> google.cloud.apihub.v1.ExternalApi.AttributesEntry
	55, // 86: google.cloud.apihub.v1.ExternalApi.create_time:type_name -> google.protobuf.Timestamp
	55, // 87: google.cloud.apihub.v1.ExternalApi.update_time:type_name -> google.protobuf.Timestamp
	30, // 88: google.cloud.apihub.v1.Api.AttributesEntry.value:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 89: google.cloud.apihub.v1.Version.AttributesEntry.value:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 90: google.cloud.apihub.v1.Spec.AttributesEntry.value:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 91: google.cloud.apihub.v1.Deployment.AttributesEntry.value:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 92: google.cloud.apihub.v1.ApiOperation.AttributesEntry.value:type_name -> google.cloud.apihub.v1.AttributeValues
	30, // 93: google.cloud.apihub.v1.Definition.AttributesEntry.value:type_name -> google.cloud.apihub.v1.AttributeValues
	47, // 94: google.cloud.apihub.v1.AttributeValues.EnumAttributeValues.values:type_name -> google.cloud.apihub.v1.Attribute.AllowedValue
	30, // 95: google.cloud.apihub.v1.Dependency.AttributesEntry.value:type_name -> google.cloud.apihub.v1.AttributeValues
	2,  // 96: google.cloud.apihub.v1.LintResponse.SummaryEntry.severity:type_name -> google.cloud.apihub.v1.Severity
	30, // 97: google.cloud.apihub.v1.ExternalApi.AttributesEntry.value:type_name -> google.cloud.apihub.v1.AttributeValues
	98, // [98:98] is the sub-list for method output_type
	98, // [98:98] is the sub-list for method input_type
	98, // [98:98] is the sub-list for extension type_name
	98, // [98:98] is the sub-list for extension extendee
	0,  // [0:98] is the sub-list for field type_name
}

func init() { file_google_cloud_apihub_v1_common_fields_proto_init() }
func file_google_cloud_apihub_v1_common_fields_proto_init() {
	if File_google_cloud_apihub_v1_common_fields_proto != nil {
		return
	}
	file_google_cloud_apihub_v1_common_fields_proto_msgTypes[5].OneofWrappers = []any{
		(*Definition_Schema)(nil),
	}
	file_google_cloud_apihub_v1_common_fields_proto_msgTypes[8].OneofWrappers = []any{
		(*SpecDetails_OpenApiSpecDetails)(nil),
	}
	file_google_cloud_apihub_v1_common_fields_proto_msgTypes[10].OneofWrappers = []any{
		(*OperationDetails_HttpOperation)(nil),
	}
	file_google_cloud_apihub_v1_common_fields_proto_msgTypes[16].OneofWrappers = []any{
		(*AttributeValues_EnumValues)(nil),
		(*AttributeValues_StringValues)(nil),
		(*AttributeValues_JsonValues)(nil),
	}
	file_google_cloud_apihub_v1_common_fields_proto_msgTypes[18].OneofWrappers = []any{
		(*DependencyEntityReference_OperationResourceName)(nil),
		(*DependencyEntityReference_ExternalApiResourceName)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_apihub_v1_common_fields_proto_rawDesc,
			NumEnums:      14,
			NumMessages:   41,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_apihub_v1_common_fields_proto_goTypes,
		DependencyIndexes: file_google_cloud_apihub_v1_common_fields_proto_depIdxs,
		EnumInfos:         file_google_cloud_apihub_v1_common_fields_proto_enumTypes,
		MessageInfos:      file_google_cloud_apihub_v1_common_fields_proto_msgTypes,
	}.Build()
	File_google_cloud_apihub_v1_common_fields_proto = out.File
	file_google_cloud_apihub_v1_common_fields_proto_rawDesc = nil
	file_google_cloud_apihub_v1_common_fields_proto_goTypes = nil
	file_google_cloud_apihub_v1_common_fields_proto_depIdxs = nil
}
