// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [VertexRagDataService.CreateRagCorpus][google.cloud.aiplatform.v1beta1.VertexRagDataService.CreateRagCorpus].
type CreateRagCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the RagCorpus in.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The RagCorpus to create.
	RagCorpus *RagCorpus `protobuf:"bytes,2,opt,name=rag_corpus,json=ragCorpus,proto3" json:"rag_corpus,omitempty"`
}

func (x *CreateRagCorpusRequest) Reset() {
	*x = CreateRagCorpusRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRagCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRagCorpusRequest) ProtoMessage() {}

func (x *CreateRagCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRagCorpusRequest.ProtoReflect.Descriptor instead.
func (*CreateRagCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateRagCorpusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRagCorpusRequest) GetRagCorpus() *RagCorpus {
	if x != nil {
		return x.RagCorpus
	}
	return nil
}

// Request message for
// [VertexRagDataService.GetRagCorpus][google.cloud.aiplatform.v1beta1.VertexRagDataService.GetRagCorpus]
type GetRagCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the RagCorpus resource.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRagCorpusRequest) Reset() {
	*x = GetRagCorpusRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRagCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRagCorpusRequest) ProtoMessage() {}

func (x *GetRagCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRagCorpusRequest.ProtoReflect.Descriptor instead.
func (*GetRagCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetRagCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VertexRagDataService.ListRagCorpora][google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagCorpora].
type ListRagCorporaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location from which to list the
	// RagCorpora. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The standard list page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard list page token.
	// Typically obtained via
	// [ListRagCorporaResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListRagCorporaResponse.next_page_token]
	// of the previous
	// [VertexRagDataService.ListRagCorpora][google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagCorpora]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRagCorporaRequest) Reset() {
	*x = ListRagCorporaRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRagCorporaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRagCorporaRequest) ProtoMessage() {}

func (x *ListRagCorporaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRagCorporaRequest.ProtoReflect.Descriptor instead.
func (*ListRagCorporaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListRagCorporaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRagCorporaRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRagCorporaRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [VertexRagDataService.ListRagCorpora][google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagCorpora].
type ListRagCorporaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of RagCorpora in the requested page.
	RagCorpora []*RagCorpus `protobuf:"bytes,1,rep,name=rag_corpora,json=ragCorpora,proto3" json:"rag_corpora,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListRagCorporaRequest.page_token][google.cloud.aiplatform.v1beta1.ListRagCorporaRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRagCorporaResponse) Reset() {
	*x = ListRagCorporaResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRagCorporaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRagCorporaResponse) ProtoMessage() {}

func (x *ListRagCorporaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRagCorporaResponse.ProtoReflect.Descriptor instead.
func (*ListRagCorporaResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListRagCorporaResponse) GetRagCorpora() []*RagCorpus {
	if x != nil {
		return x.RagCorpora
	}
	return nil
}

func (x *ListRagCorporaResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [VertexRagDataService.DeleteRagCorpus][google.cloud.aiplatform.v1beta1.VertexRagDataService.DeleteRagCorpus].
type DeleteRagCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the RagCorpus resource to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, any RagFiles in this RagCorpus will also be
	// deleted. Otherwise, the request will only work if the RagCorpus has no
	// RagFiles.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteRagCorpusRequest) Reset() {
	*x = DeleteRagCorpusRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRagCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRagCorpusRequest) ProtoMessage() {}

func (x *DeleteRagCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRagCorpusRequest.ProtoReflect.Descriptor instead.
func (*DeleteRagCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteRagCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRagCorpusRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [VertexRagDataService.UploadRagFile][google.cloud.aiplatform.v1beta1.VertexRagDataService.UploadRagFile].
type UploadRagFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the RagCorpus resource into which to upload the file.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The RagFile to upload.
	RagFile *RagFile `protobuf:"bytes,2,opt,name=rag_file,json=ragFile,proto3" json:"rag_file,omitempty"`
	// Required. The config for the RagFiles to be uploaded into the RagCorpus.
	// [VertexRagDataService.UploadRagFile][google.cloud.aiplatform.v1beta1.VertexRagDataService.UploadRagFile].
	UploadRagFileConfig *UploadRagFileConfig `protobuf:"bytes,5,opt,name=upload_rag_file_config,json=uploadRagFileConfig,proto3" json:"upload_rag_file_config,omitempty"`
}

func (x *UploadRagFileRequest) Reset() {
	*x = UploadRagFileRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadRagFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRagFileRequest) ProtoMessage() {}

func (x *UploadRagFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRagFileRequest.ProtoReflect.Descriptor instead.
func (*UploadRagFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{5}
}

func (x *UploadRagFileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *UploadRagFileRequest) GetRagFile() *RagFile {
	if x != nil {
		return x.RagFile
	}
	return nil
}

func (x *UploadRagFileRequest) GetUploadRagFileConfig() *UploadRagFileConfig {
	if x != nil {
		return x.UploadRagFileConfig
	}
	return nil
}

// Response message for
// [VertexRagDataService.UploadRagFile][google.cloud.aiplatform.v1beta1.VertexRagDataService.UploadRagFile].
type UploadRagFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the upload.
	//
	// Types that are assignable to Result:
	//
	//	*UploadRagFileResponse_RagFile
	//	*UploadRagFileResponse_Error
	Result isUploadRagFileResponse_Result `protobuf_oneof:"result"`
}

func (x *UploadRagFileResponse) Reset() {
	*x = UploadRagFileResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadRagFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRagFileResponse) ProtoMessage() {}

func (x *UploadRagFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRagFileResponse.ProtoReflect.Descriptor instead.
func (*UploadRagFileResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{6}
}

func (m *UploadRagFileResponse) GetResult() isUploadRagFileResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *UploadRagFileResponse) GetRagFile() *RagFile {
	if x, ok := x.GetResult().(*UploadRagFileResponse_RagFile); ok {
		return x.RagFile
	}
	return nil
}

func (x *UploadRagFileResponse) GetError() *status.Status {
	if x, ok := x.GetResult().(*UploadRagFileResponse_Error); ok {
		return x.Error
	}
	return nil
}

type isUploadRagFileResponse_Result interface {
	isUploadRagFileResponse_Result()
}

type UploadRagFileResponse_RagFile struct {
	// The RagFile that had been uploaded into the RagCorpus.
	RagFile *RagFile `protobuf:"bytes,1,opt,name=rag_file,json=ragFile,proto3,oneof"`
}

type UploadRagFileResponse_Error struct {
	// The error that occurred while processing the RagFile.
	Error *status.Status `protobuf:"bytes,4,opt,name=error,proto3,oneof"`
}

func (*UploadRagFileResponse_RagFile) isUploadRagFileResponse_Result() {}

func (*UploadRagFileResponse_Error) isUploadRagFileResponse_Result() {}

// Request message for
// [VertexRagDataService.ImportRagFiles][google.cloud.aiplatform.v1beta1.VertexRagDataService.ImportRagFiles].
type ImportRagFilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the RagCorpus resource into which to import files.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The config for the RagFiles to be synced and imported into the
	// RagCorpus.
	// [VertexRagDataService.ImportRagFiles][google.cloud.aiplatform.v1beta1.VertexRagDataService.ImportRagFiles].
	ImportRagFilesConfig *ImportRagFilesConfig `protobuf:"bytes,2,opt,name=import_rag_files_config,json=importRagFilesConfig,proto3" json:"import_rag_files_config,omitempty"`
}

func (x *ImportRagFilesRequest) Reset() {
	*x = ImportRagFilesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportRagFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportRagFilesRequest) ProtoMessage() {}

func (x *ImportRagFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportRagFilesRequest.ProtoReflect.Descriptor instead.
func (*ImportRagFilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{7}
}

func (x *ImportRagFilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportRagFilesRequest) GetImportRagFilesConfig() *ImportRagFilesConfig {
	if x != nil {
		return x.ImportRagFilesConfig
	}
	return nil
}

// Response message for
// [VertexRagDataService.ImportRagFiles][google.cloud.aiplatform.v1beta1.VertexRagDataService.ImportRagFiles].
type ImportRagFilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location into which the partial failures were written.
	//
	// Types that are assignable to PartialFailureSink:
	//
	//	*ImportRagFilesResponse_PartialFailuresGcsPath
	//	*ImportRagFilesResponse_PartialFailuresBigqueryTable
	PartialFailureSink isImportRagFilesResponse_PartialFailureSink `protobuf_oneof:"partial_failure_sink"`
	// The number of RagFiles that had been imported into the RagCorpus.
	ImportedRagFilesCount int64 `protobuf:"varint,1,opt,name=imported_rag_files_count,json=importedRagFilesCount,proto3" json:"imported_rag_files_count,omitempty"`
	// The number of RagFiles that had failed while importing into the RagCorpus.
	FailedRagFilesCount int64 `protobuf:"varint,2,opt,name=failed_rag_files_count,json=failedRagFilesCount,proto3" json:"failed_rag_files_count,omitempty"`
	// The number of RagFiles that was skipped while importing into the RagCorpus.
	SkippedRagFilesCount int64 `protobuf:"varint,3,opt,name=skipped_rag_files_count,json=skippedRagFilesCount,proto3" json:"skipped_rag_files_count,omitempty"`
}

func (x *ImportRagFilesResponse) Reset() {
	*x = ImportRagFilesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportRagFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportRagFilesResponse) ProtoMessage() {}

func (x *ImportRagFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportRagFilesResponse.ProtoReflect.Descriptor instead.
func (*ImportRagFilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{8}
}

func (m *ImportRagFilesResponse) GetPartialFailureSink() isImportRagFilesResponse_PartialFailureSink {
	if m != nil {
		return m.PartialFailureSink
	}
	return nil
}

func (x *ImportRagFilesResponse) GetPartialFailuresGcsPath() string {
	if x, ok := x.GetPartialFailureSink().(*ImportRagFilesResponse_PartialFailuresGcsPath); ok {
		return x.PartialFailuresGcsPath
	}
	return ""
}

func (x *ImportRagFilesResponse) GetPartialFailuresBigqueryTable() string {
	if x, ok := x.GetPartialFailureSink().(*ImportRagFilesResponse_PartialFailuresBigqueryTable); ok {
		return x.PartialFailuresBigqueryTable
	}
	return ""
}

func (x *ImportRagFilesResponse) GetImportedRagFilesCount() int64 {
	if x != nil {
		return x.ImportedRagFilesCount
	}
	return 0
}

func (x *ImportRagFilesResponse) GetFailedRagFilesCount() int64 {
	if x != nil {
		return x.FailedRagFilesCount
	}
	return 0
}

func (x *ImportRagFilesResponse) GetSkippedRagFilesCount() int64 {
	if x != nil {
		return x.SkippedRagFilesCount
	}
	return 0
}

type isImportRagFilesResponse_PartialFailureSink interface {
	isImportRagFilesResponse_PartialFailureSink()
}

type ImportRagFilesResponse_PartialFailuresGcsPath struct {
	// The Google Cloud Storage path into which the partial failures were
	// written.
	PartialFailuresGcsPath string `protobuf:"bytes,4,opt,name=partial_failures_gcs_path,json=partialFailuresGcsPath,proto3,oneof"`
}

type ImportRagFilesResponse_PartialFailuresBigqueryTable struct {
	// The BigQuery table into which the partial failures were written.
	PartialFailuresBigqueryTable string `protobuf:"bytes,5,opt,name=partial_failures_bigquery_table,json=partialFailuresBigqueryTable,proto3,oneof"`
}

func (*ImportRagFilesResponse_PartialFailuresGcsPath) isImportRagFilesResponse_PartialFailureSink() {}

func (*ImportRagFilesResponse_PartialFailuresBigqueryTable) isImportRagFilesResponse_PartialFailureSink() {
}

// Request message for
// [VertexRagDataService.GetRagFile][google.cloud.aiplatform.v1beta1.VertexRagDataService.GetRagFile]
type GetRagFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the RagFile resource.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}/ragFiles/{rag_file}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRagFileRequest) Reset() {
	*x = GetRagFileRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRagFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRagFileRequest) ProtoMessage() {}

func (x *GetRagFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRagFileRequest.ProtoReflect.Descriptor instead.
func (*GetRagFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{9}
}

func (x *GetRagFileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VertexRagDataService.ListRagFiles][google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagFiles].
type ListRagFilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the RagCorpus from which to list the
	// RagFiles. Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The standard list page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard list page token.
	// Typically obtained via
	// [ListRagFilesResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListRagFilesResponse.next_page_token]
	// of the previous
	// [VertexRagDataService.ListRagFiles][google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagFiles]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRagFilesRequest) Reset() {
	*x = ListRagFilesRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRagFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRagFilesRequest) ProtoMessage() {}

func (x *ListRagFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRagFilesRequest.ProtoReflect.Descriptor instead.
func (*ListRagFilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListRagFilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRagFilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRagFilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [VertexRagDataService.ListRagFiles][google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagFiles].
type ListRagFilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of RagFiles in the requested page.
	RagFiles []*RagFile `protobuf:"bytes,1,rep,name=rag_files,json=ragFiles,proto3" json:"rag_files,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListRagFilesRequest.page_token][google.cloud.aiplatform.v1beta1.ListRagFilesRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRagFilesResponse) Reset() {
	*x = ListRagFilesResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRagFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRagFilesResponse) ProtoMessage() {}

func (x *ListRagFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRagFilesResponse.ProtoReflect.Descriptor instead.
func (*ListRagFilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListRagFilesResponse) GetRagFiles() []*RagFile {
	if x != nil {
		return x.RagFiles
	}
	return nil
}

func (x *ListRagFilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [VertexRagDataService.DeleteRagFile][google.cloud.aiplatform.v1beta1.VertexRagDataService.DeleteRagFile].
type DeleteRagFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the RagFile resource to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}/ragFiles/{rag_file}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRagFileRequest) Reset() {
	*x = DeleteRagFileRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRagFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRagFileRequest) ProtoMessage() {}

func (x *DeleteRagFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRagFileRequest.ProtoReflect.Descriptor instead.
func (*DeleteRagFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteRagFileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Runtime operation information for
// [VertexRagDataService.CreateRagCorpus][google.cloud.aiplatform.v1beta1.VertexRagDataService.CreateRagCorpus].
type CreateRagCorpusOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateRagCorpusOperationMetadata) Reset() {
	*x = CreateRagCorpusOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRagCorpusOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRagCorpusOperationMetadata) ProtoMessage() {}

func (x *CreateRagCorpusOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRagCorpusOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateRagCorpusOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{13}
}

func (x *CreateRagCorpusOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [VertexRagDataService.UpdateRagCorpus][google.cloud.aiplatform.v1beta1.VertexRagDataService.UpdateRagCorpus].
type UpdateRagCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The RagCorpus which replaces the resource on the server.
	RagCorpus *RagCorpus `protobuf:"bytes,1,opt,name=rag_corpus,json=ragCorpus,proto3" json:"rag_corpus,omitempty"`
}

func (x *UpdateRagCorpusRequest) Reset() {
	*x = UpdateRagCorpusRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRagCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRagCorpusRequest) ProtoMessage() {}

func (x *UpdateRagCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRagCorpusRequest.ProtoReflect.Descriptor instead.
func (*UpdateRagCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateRagCorpusRequest) GetRagCorpus() *RagCorpus {
	if x != nil {
		return x.RagCorpus
	}
	return nil
}

// Runtime operation information for
// [VertexRagDataService.UpdateRagCorpus][google.cloud.aiplatform.v1beta1.VertexRagDataService.UpdateRagCorpus].
type UpdateRagCorpusOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateRagCorpusOperationMetadata) Reset() {
	*x = UpdateRagCorpusOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRagCorpusOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRagCorpusOperationMetadata) ProtoMessage() {}

func (x *UpdateRagCorpusOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRagCorpusOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateRagCorpusOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateRagCorpusOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Runtime operation information for
// [VertexRagDataService.ImportRagFiles][google.cloud.aiplatform.v1beta1.VertexRagDataService.ImportRagFiles].
type ImportRagFilesOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// The resource ID of RagCorpus that this operation is executed on.
	RagCorpusId int64 `protobuf:"varint,2,opt,name=rag_corpus_id,json=ragCorpusId,proto3" json:"rag_corpus_id,omitempty"`
	// Output only. The config that was passed in the ImportRagFilesRequest.
	ImportRagFilesConfig *ImportRagFilesConfig `protobuf:"bytes,3,opt,name=import_rag_files_config,json=importRagFilesConfig,proto3" json:"import_rag_files_config,omitempty"`
	// The progress percentage of the operation. Value is in the range [0, 100].
	// This percentage is calculated as follows:
	//
	//	progress_percentage = 100 * (successes + failures + skips) / total
	ProgressPercentage int32 `protobuf:"varint,4,opt,name=progress_percentage,json=progressPercentage,proto3" json:"progress_percentage,omitempty"`
}

func (x *ImportRagFilesOperationMetadata) Reset() {
	*x = ImportRagFilesOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportRagFilesOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportRagFilesOperationMetadata) ProtoMessage() {}

func (x *ImportRagFilesOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportRagFilesOperationMetadata.ProtoReflect.Descriptor instead.
func (*ImportRagFilesOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP(), []int{16}
}

func (x *ImportRagFilesOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *ImportRagFilesOperationMetadata) GetRagCorpusId() int64 {
	if x != nil {
		return x.RagCorpusId
	}
	return 0
}

func (x *ImportRagFilesOperationMetadata) GetImportRagFilesConfig() *ImportRagFilesConfig {
	if x != nil {
		return x.ImportRagFilesConfig
	}
	return nil
}

func (x *ImportRagFilesOperationMetadata) GetProgressPercentage() int32 {
	if x != nil {
		return x.ProgressPercentage
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xab, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x22, 0x56, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x52, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x8d, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x72, 0x61,
	0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x0a, 0x72, 0x61, 0x67,
	0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x74, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x95, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x6e, 0x0a,
	0x16, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x94, 0x01,
	0x0a, 0x15, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x72, 0x61, 0x67, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x07, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x2a,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x22, 0xcf, 0x01, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x71, 0x0a, 0x17, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61,
	0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x14, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xdb, 0x02, 0x0a, 0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3b, 0x0a, 0x19, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x73, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x16, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x47, 0x63, 0x73, 0x50, 0x61, 0x74, 0x68, 0x12, 0x47,
	0x0a, 0x1f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x73, 0x5f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x1c, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x18, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x33, 0x0a, 0x16, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x13, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x17, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64,
	0x5f, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x52,
	0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x16, 0x0a, 0x14,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f,
	0x73, 0x69, 0x6e, 0x6b, 0x22, 0x52, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x85, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x08, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x55, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x88, 0x01, 0x0a, 0x20, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x68, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22,
	0x88, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xcf, 0x02, 0x0a, 0x1f, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64,
	0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x22, 0x0a, 0x0d, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x72, 0x61, 0x67,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x49, 0x64, 0x12, 0x71, 0x0a, 0x17, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2f, 0x0a, 0x13, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
	0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x32, 0xcd, 0x12, 0x0a,
	0x14, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf7, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x8b, 0x01, 0xca, 0x41, 0x2d, 0x0a, 0x09, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x12, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x61,
	0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x0a,
	0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12,
	0xfb, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x01, 0xca, 0x41,
	0x2d, 0x0a, 0x09, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x20, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4c, 0x3a, 0x0a, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x32, 0x3e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x12, 0xb4, 0x01,
	0x0a, 0x0c, 0x47, 0x65, 0x74, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12,
	0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x2f, 0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x61, 0x67,
	0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x61,
	0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0xe0,
	0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x30, 0x0a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a,
	0x7d, 0x12, 0xf9, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x79, 0xda, 0x41, 0x26, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x61,
	0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x2c, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x61,
	0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4a, 0x3a, 0x01, 0x2a, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x61,
	0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x3a, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x97, 0x02,
	0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0xca, 0x41, 0x39, 0x0a, 0x16, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x01, 0x2a,
	0x22, 0x45, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xb9, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52,
	0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x61, 0x67, 0x43,
	0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x12, 0xe8, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0xca, 0x41, 0x30,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x2a, 0x3e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f,
	0x2a, 0x2f, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4d, 0xca,
	0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xf0, 0x01, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x42, 0x19, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_goTypes = []any{
	(*CreateRagCorpusRequest)(nil),           // 0: google.cloud.aiplatform.v1beta1.CreateRagCorpusRequest
	(*GetRagCorpusRequest)(nil),              // 1: google.cloud.aiplatform.v1beta1.GetRagCorpusRequest
	(*ListRagCorporaRequest)(nil),            // 2: google.cloud.aiplatform.v1beta1.ListRagCorporaRequest
	(*ListRagCorporaResponse)(nil),           // 3: google.cloud.aiplatform.v1beta1.ListRagCorporaResponse
	(*DeleteRagCorpusRequest)(nil),           // 4: google.cloud.aiplatform.v1beta1.DeleteRagCorpusRequest
	(*UploadRagFileRequest)(nil),             // 5: google.cloud.aiplatform.v1beta1.UploadRagFileRequest
	(*UploadRagFileResponse)(nil),            // 6: google.cloud.aiplatform.v1beta1.UploadRagFileResponse
	(*ImportRagFilesRequest)(nil),            // 7: google.cloud.aiplatform.v1beta1.ImportRagFilesRequest
	(*ImportRagFilesResponse)(nil),           // 8: google.cloud.aiplatform.v1beta1.ImportRagFilesResponse
	(*GetRagFileRequest)(nil),                // 9: google.cloud.aiplatform.v1beta1.GetRagFileRequest
	(*ListRagFilesRequest)(nil),              // 10: google.cloud.aiplatform.v1beta1.ListRagFilesRequest
	(*ListRagFilesResponse)(nil),             // 11: google.cloud.aiplatform.v1beta1.ListRagFilesResponse
	(*DeleteRagFileRequest)(nil),             // 12: google.cloud.aiplatform.v1beta1.DeleteRagFileRequest
	(*CreateRagCorpusOperationMetadata)(nil), // 13: google.cloud.aiplatform.v1beta1.CreateRagCorpusOperationMetadata
	(*UpdateRagCorpusRequest)(nil),           // 14: google.cloud.aiplatform.v1beta1.UpdateRagCorpusRequest
	(*UpdateRagCorpusOperationMetadata)(nil), // 15: google.cloud.aiplatform.v1beta1.UpdateRagCorpusOperationMetadata
	(*ImportRagFilesOperationMetadata)(nil),  // 16: google.cloud.aiplatform.v1beta1.ImportRagFilesOperationMetadata
	(*RagCorpus)(nil),                        // 17: google.cloud.aiplatform.v1beta1.RagCorpus
	(*RagFile)(nil),                          // 18: google.cloud.aiplatform.v1beta1.RagFile
	(*UploadRagFileConfig)(nil),              // 19: google.cloud.aiplatform.v1beta1.UploadRagFileConfig
	(*status.Status)(nil),                    // 20: google.rpc.Status
	(*ImportRagFilesConfig)(nil),             // 21: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig
	(*GenericOperationMetadata)(nil),         // 22: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*longrunningpb.Operation)(nil),          // 23: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_depIdxs = []int32{
	17, // 0: google.cloud.aiplatform.v1beta1.CreateRagCorpusRequest.rag_corpus:type_name -> google.cloud.aiplatform.v1beta1.RagCorpus
	17, // 1: google.cloud.aiplatform.v1beta1.ListRagCorporaResponse.rag_corpora:type_name -> google.cloud.aiplatform.v1beta1.RagCorpus
	18, // 2: google.cloud.aiplatform.v1beta1.UploadRagFileRequest.rag_file:type_name -> google.cloud.aiplatform.v1beta1.RagFile
	19, // 3: google.cloud.aiplatform.v1beta1.UploadRagFileRequest.upload_rag_file_config:type_name -> google.cloud.aiplatform.v1beta1.UploadRagFileConfig
	18, // 4: google.cloud.aiplatform.v1beta1.UploadRagFileResponse.rag_file:type_name -> google.cloud.aiplatform.v1beta1.RagFile
	20, // 5: google.cloud.aiplatform.v1beta1.UploadRagFileResponse.error:type_name -> google.rpc.Status
	21, // 6: google.cloud.aiplatform.v1beta1.ImportRagFilesRequest.import_rag_files_config:type_name -> google.cloud.aiplatform.v1beta1.ImportRagFilesConfig
	18, // 7: google.cloud.aiplatform.v1beta1.ListRagFilesResponse.rag_files:type_name -> google.cloud.aiplatform.v1beta1.RagFile
	22, // 8: google.cloud.aiplatform.v1beta1.CreateRagCorpusOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	17, // 9: google.cloud.aiplatform.v1beta1.UpdateRagCorpusRequest.rag_corpus:type_name -> google.cloud.aiplatform.v1beta1.RagCorpus
	22, // 10: google.cloud.aiplatform.v1beta1.UpdateRagCorpusOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	22, // 11: google.cloud.aiplatform.v1beta1.ImportRagFilesOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	21, // 12: google.cloud.aiplatform.v1beta1.ImportRagFilesOperationMetadata.import_rag_files_config:type_name -> google.cloud.aiplatform.v1beta1.ImportRagFilesConfig
	0,  // 13: google.cloud.aiplatform.v1beta1.VertexRagDataService.CreateRagCorpus:input_type -> google.cloud.aiplatform.v1beta1.CreateRagCorpusRequest
	14, // 14: google.cloud.aiplatform.v1beta1.VertexRagDataService.UpdateRagCorpus:input_type -> google.cloud.aiplatform.v1beta1.UpdateRagCorpusRequest
	1,  // 15: google.cloud.aiplatform.v1beta1.VertexRagDataService.GetRagCorpus:input_type -> google.cloud.aiplatform.v1beta1.GetRagCorpusRequest
	2,  // 16: google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagCorpora:input_type -> google.cloud.aiplatform.v1beta1.ListRagCorporaRequest
	4,  // 17: google.cloud.aiplatform.v1beta1.VertexRagDataService.DeleteRagCorpus:input_type -> google.cloud.aiplatform.v1beta1.DeleteRagCorpusRequest
	5,  // 18: google.cloud.aiplatform.v1beta1.VertexRagDataService.UploadRagFile:input_type -> google.cloud.aiplatform.v1beta1.UploadRagFileRequest
	7,  // 19: google.cloud.aiplatform.v1beta1.VertexRagDataService.ImportRagFiles:input_type -> google.cloud.aiplatform.v1beta1.ImportRagFilesRequest
	9,  // 20: google.cloud.aiplatform.v1beta1.VertexRagDataService.GetRagFile:input_type -> google.cloud.aiplatform.v1beta1.GetRagFileRequest
	10, // 21: google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagFiles:input_type -> google.cloud.aiplatform.v1beta1.ListRagFilesRequest
	12, // 22: google.cloud.aiplatform.v1beta1.VertexRagDataService.DeleteRagFile:input_type -> google.cloud.aiplatform.v1beta1.DeleteRagFileRequest
	23, // 23: google.cloud.aiplatform.v1beta1.VertexRagDataService.CreateRagCorpus:output_type -> google.longrunning.Operation
	23, // 24: google.cloud.aiplatform.v1beta1.VertexRagDataService.UpdateRagCorpus:output_type -> google.longrunning.Operation
	17, // 25: google.cloud.aiplatform.v1beta1.VertexRagDataService.GetRagCorpus:output_type -> google.cloud.aiplatform.v1beta1.RagCorpus
	3,  // 26: google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagCorpora:output_type -> google.cloud.aiplatform.v1beta1.ListRagCorporaResponse
	23, // 27: google.cloud.aiplatform.v1beta1.VertexRagDataService.DeleteRagCorpus:output_type -> google.longrunning.Operation
	6,  // 28: google.cloud.aiplatform.v1beta1.VertexRagDataService.UploadRagFile:output_type -> google.cloud.aiplatform.v1beta1.UploadRagFileResponse
	23, // 29: google.cloud.aiplatform.v1beta1.VertexRagDataService.ImportRagFiles:output_type -> google.longrunning.Operation
	18, // 30: google.cloud.aiplatform.v1beta1.VertexRagDataService.GetRagFile:output_type -> google.cloud.aiplatform.v1beta1.RagFile
	11, // 31: google.cloud.aiplatform.v1beta1.VertexRagDataService.ListRagFiles:output_type -> google.cloud.aiplatform.v1beta1.ListRagFilesResponse
	23, // 32: google.cloud.aiplatform.v1beta1.VertexRagDataService.DeleteRagFile:output_type -> google.longrunning.Operation
	23, // [23:33] is the sub-list for method output_type
	13, // [13:23] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_init()
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[6].OneofWrappers = []any{
		(*UploadRagFileResponse_RagFile)(nil),
		(*UploadRagFileResponse_Error)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes[8].OneofWrappers = []any{
		(*ImportRagFilesResponse_PartialFailuresGcsPath)(nil),
		(*ImportRagFilesResponse_PartialFailuresBigqueryTable)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VertexRagDataServiceClient is the client API for VertexRagDataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VertexRagDataServiceClient interface {
	// Creates a RagCorpus.
	CreateRagCorpus(ctx context.Context, in *CreateRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a RagCorpus.
	UpdateRagCorpus(ctx context.Context, in *UpdateRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a RagCorpus.
	GetRagCorpus(ctx context.Context, in *GetRagCorpusRequest, opts ...grpc.CallOption) (*RagCorpus, error)
	// Lists RagCorpora in a Location.
	ListRagCorpora(ctx context.Context, in *ListRagCorporaRequest, opts ...grpc.CallOption) (*ListRagCorporaResponse, error)
	// Deletes a RagCorpus.
	DeleteRagCorpus(ctx context.Context, in *DeleteRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Upload a file into a RagCorpus.
	UploadRagFile(ctx context.Context, in *UploadRagFileRequest, opts ...grpc.CallOption) (*UploadRagFileResponse, error)
	// Import files from Google Cloud Storage or Google Drive into a RagCorpus.
	ImportRagFiles(ctx context.Context, in *ImportRagFilesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a RagFile.
	GetRagFile(ctx context.Context, in *GetRagFileRequest, opts ...grpc.CallOption) (*RagFile, error)
	// Lists RagFiles in a RagCorpus.
	ListRagFiles(ctx context.Context, in *ListRagFilesRequest, opts ...grpc.CallOption) (*ListRagFilesResponse, error)
	// Deletes a RagFile.
	DeleteRagFile(ctx context.Context, in *DeleteRagFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type vertexRagDataServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVertexRagDataServiceClient(cc grpc.ClientConnInterface) VertexRagDataServiceClient {
	return &vertexRagDataServiceClient{cc}
}

func (c *vertexRagDataServiceClient) CreateRagCorpus(ctx context.Context, in *CreateRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/CreateRagCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) UpdateRagCorpus(ctx context.Context, in *UpdateRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/UpdateRagCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) GetRagCorpus(ctx context.Context, in *GetRagCorpusRequest, opts ...grpc.CallOption) (*RagCorpus, error) {
	out := new(RagCorpus)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/GetRagCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) ListRagCorpora(ctx context.Context, in *ListRagCorporaRequest, opts ...grpc.CallOption) (*ListRagCorporaResponse, error) {
	out := new(ListRagCorporaResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/ListRagCorpora", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) DeleteRagCorpus(ctx context.Context, in *DeleteRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/DeleteRagCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) UploadRagFile(ctx context.Context, in *UploadRagFileRequest, opts ...grpc.CallOption) (*UploadRagFileResponse, error) {
	out := new(UploadRagFileResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/UploadRagFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) ImportRagFiles(ctx context.Context, in *ImportRagFilesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/ImportRagFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) GetRagFile(ctx context.Context, in *GetRagFileRequest, opts ...grpc.CallOption) (*RagFile, error) {
	out := new(RagFile)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/GetRagFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) ListRagFiles(ctx context.Context, in *ListRagFilesRequest, opts ...grpc.CallOption) (*ListRagFilesResponse, error) {
	out := new(ListRagFilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/ListRagFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) DeleteRagFile(ctx context.Context, in *DeleteRagFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VertexRagDataService/DeleteRagFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VertexRagDataServiceServer is the server API for VertexRagDataService service.
type VertexRagDataServiceServer interface {
	// Creates a RagCorpus.
	CreateRagCorpus(context.Context, *CreateRagCorpusRequest) (*longrunningpb.Operation, error)
	// Updates a RagCorpus.
	UpdateRagCorpus(context.Context, *UpdateRagCorpusRequest) (*longrunningpb.Operation, error)
	// Gets a RagCorpus.
	GetRagCorpus(context.Context, *GetRagCorpusRequest) (*RagCorpus, error)
	// Lists RagCorpora in a Location.
	ListRagCorpora(context.Context, *ListRagCorporaRequest) (*ListRagCorporaResponse, error)
	// Deletes a RagCorpus.
	DeleteRagCorpus(context.Context, *DeleteRagCorpusRequest) (*longrunningpb.Operation, error)
	// Upload a file into a RagCorpus.
	UploadRagFile(context.Context, *UploadRagFileRequest) (*UploadRagFileResponse, error)
	// Import files from Google Cloud Storage or Google Drive into a RagCorpus.
	ImportRagFiles(context.Context, *ImportRagFilesRequest) (*longrunningpb.Operation, error)
	// Gets a RagFile.
	GetRagFile(context.Context, *GetRagFileRequest) (*RagFile, error)
	// Lists RagFiles in a RagCorpus.
	ListRagFiles(context.Context, *ListRagFilesRequest) (*ListRagFilesResponse, error)
	// Deletes a RagFile.
	DeleteRagFile(context.Context, *DeleteRagFileRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVertexRagDataServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVertexRagDataServiceServer struct {
}

func (*UnimplementedVertexRagDataServiceServer) CreateRagCorpus(context.Context, *CreateRagCorpusRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateRagCorpus not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) UpdateRagCorpus(context.Context, *UpdateRagCorpusRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateRagCorpus not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) GetRagCorpus(context.Context, *GetRagCorpusRequest) (*RagCorpus, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetRagCorpus not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) ListRagCorpora(context.Context, *ListRagCorporaRequest) (*ListRagCorporaResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListRagCorpora not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) DeleteRagCorpus(context.Context, *DeleteRagCorpusRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteRagCorpus not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) UploadRagFile(context.Context, *UploadRagFileRequest) (*UploadRagFileResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UploadRagFile not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) ImportRagFiles(context.Context, *ImportRagFilesRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ImportRagFiles not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) GetRagFile(context.Context, *GetRagFileRequest) (*RagFile, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetRagFile not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) ListRagFiles(context.Context, *ListRagFilesRequest) (*ListRagFilesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListRagFiles not implemented")
}
func (*UnimplementedVertexRagDataServiceServer) DeleteRagFile(context.Context, *DeleteRagFileRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteRagFile not implemented")
}

func RegisterVertexRagDataServiceServer(s *grpc.Server, srv VertexRagDataServiceServer) {
	s.RegisterService(&_VertexRagDataService_serviceDesc, srv)
}

func _VertexRagDataService_CreateRagCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRagCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).CreateRagCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/CreateRagCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).CreateRagCorpus(ctx, req.(*CreateRagCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_UpdateRagCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRagCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).UpdateRagCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/UpdateRagCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).UpdateRagCorpus(ctx, req.(*UpdateRagCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_GetRagCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRagCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).GetRagCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/GetRagCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).GetRagCorpus(ctx, req.(*GetRagCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_ListRagCorpora_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRagCorporaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).ListRagCorpora(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/ListRagCorpora",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).ListRagCorpora(ctx, req.(*ListRagCorporaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_DeleteRagCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRagCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).DeleteRagCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/DeleteRagCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).DeleteRagCorpus(ctx, req.(*DeleteRagCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_UploadRagFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadRagFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).UploadRagFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/UploadRagFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).UploadRagFile(ctx, req.(*UploadRagFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_ImportRagFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportRagFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).ImportRagFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/ImportRagFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).ImportRagFiles(ctx, req.(*ImportRagFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_GetRagFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRagFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).GetRagFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/GetRagFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).GetRagFile(ctx, req.(*GetRagFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_ListRagFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRagFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).ListRagFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/ListRagFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).ListRagFiles(ctx, req.(*ListRagFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_DeleteRagFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRagFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).DeleteRagFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VertexRagDataService/DeleteRagFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).DeleteRagFile(ctx, req.(*DeleteRagFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VertexRagDataService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.VertexRagDataService",
	HandlerType: (*VertexRagDataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateRagCorpus",
			Handler:    _VertexRagDataService_CreateRagCorpus_Handler,
		},
		{
			MethodName: "UpdateRagCorpus",
			Handler:    _VertexRagDataService_UpdateRagCorpus_Handler,
		},
		{
			MethodName: "GetRagCorpus",
			Handler:    _VertexRagDataService_GetRagCorpus_Handler,
		},
		{
			MethodName: "ListRagCorpora",
			Handler:    _VertexRagDataService_ListRagCorpora_Handler,
		},
		{
			MethodName: "DeleteRagCorpus",
			Handler:    _VertexRagDataService_DeleteRagCorpus_Handler,
		},
		{
			MethodName: "UploadRagFile",
			Handler:    _VertexRagDataService_UploadRagFile_Handler,
		},
		{
			MethodName: "ImportRagFiles",
			Handler:    _VertexRagDataService_ImportRagFiles_Handler,
		},
		{
			MethodName: "GetRagFile",
			Handler:    _VertexRagDataService_GetRagFile_Handler,
		},
		{
			MethodName: "ListRagFiles",
			Handler:    _VertexRagDataService_ListRagFiles_Handler,
		},
		{
			MethodName: "DeleteRagFile",
			Handler:    _VertexRagDataService_DeleteRagFile_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/vertex_rag_data_service.proto",
}
