// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/discoveryengine/v1alpha/site_search_engine_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// CorpusType for the failed crawling operation.
type RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType int32

const (
	// Default value.
	RecrawlUrisResponse_FailureInfo_FailureReason_CORPUS_TYPE_UNSPECIFIED RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType = 0
	// Denotes a crawling attempt for the desktop version of a page.
	RecrawlUrisResponse_FailureInfo_FailureReason_DESKTOP RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType = 1
	// Denotes a crawling attempt for the mobile version of a page.
	RecrawlUrisResponse_FailureInfo_FailureReason_MOBILE RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType = 2
)

// Enum value maps for RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType.
var (
	RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType_name = map[int32]string{
		0: "CORPUS_TYPE_UNSPECIFIED",
		1: "DESKTOP",
		2: "MOBILE",
	}
	RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType_value = map[string]int32{
		"CORPUS_TYPE_UNSPECIFIED": 0,
		"DESKTOP":                 1,
		"MOBILE":                  2,
	}
)

func (x RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType) Enum() *RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType {
	p := new(RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType)
	*p = x
	return p
}

func (x RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_enumTypes[0].Descriptor()
}

func (RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_enumTypes[0]
}

func (x RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType.Descriptor instead.
func (RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{20, 0, 0, 0}
}

// Request message for
// [SiteSearchEngineService.GetSiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.GetSiteSearchEngine]
// method.
type GetSiteSearchEngineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of
	// [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
	// such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
	//
	// If the caller does not have permission to access the [SiteSearchEngine],
	// regardless of whether or not it exists, a PERMISSION_DENIED error is
	// returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSiteSearchEngineRequest) Reset() {
	*x = GetSiteSearchEngineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSiteSearchEngineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSiteSearchEngineRequest) ProtoMessage() {}

func (x *GetSiteSearchEngineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSiteSearchEngineRequest.ProtoReflect.Descriptor instead.
func (*GetSiteSearchEngineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetSiteSearchEngineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [SiteSearchEngineService.CreateTargetSite][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.CreateTargetSite]
// method.
type CreateTargetSiteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name of
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite], such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite]
	// to create.
	TargetSite *TargetSite `protobuf:"bytes,2,opt,name=target_site,json=targetSite,proto3" json:"target_site,omitempty"`
}

func (x *CreateTargetSiteRequest) Reset() {
	*x = CreateTargetSiteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTargetSiteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTargetSiteRequest) ProtoMessage() {}

func (x *CreateTargetSiteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTargetSiteRequest.ProtoReflect.Descriptor instead.
func (*CreateTargetSiteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateTargetSiteRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTargetSiteRequest) GetTargetSite() *TargetSite {
	if x != nil {
		return x.TargetSite
	}
	return nil
}

// Metadata related to the progress of the
// [SiteSearchEngineService.CreateTargetSite][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.CreateTargetSite]
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type CreateTargetSiteMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *CreateTargetSiteMetadata) Reset() {
	*x = CreateTargetSiteMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTargetSiteMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTargetSiteMetadata) ProtoMessage() {}

func (x *CreateTargetSiteMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTargetSiteMetadata.ProtoReflect.Descriptor instead.
func (*CreateTargetSiteMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{2}
}

func (x *CreateTargetSiteMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateTargetSiteMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for [SiteSearchEngineService.s][] method.
type BatchCreateTargetSitesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource shared by all TargetSites being created.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
	// The parent field in the CreateBookRequest messages must either be empty or
	// match this field.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message specifying the resources to create.
	// A maximum of 20 TargetSites can be created in a batch.
	Requests []*CreateTargetSiteRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateTargetSitesRequest) Reset() {
	*x = BatchCreateTargetSitesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTargetSitesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTargetSitesRequest) ProtoMessage() {}

func (x *BatchCreateTargetSitesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTargetSitesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateTargetSitesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{3}
}

func (x *BatchCreateTargetSitesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateTargetSitesRequest) GetRequests() []*CreateTargetSiteRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Request message for
// [SiteSearchEngineService.GetTargetSite][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.GetTargetSite]
// method.
type GetTargetSiteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite], such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`.
	//
	// If the caller does not have permission to access the
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite], regardless
	// of whether or not it exists, a PERMISSION_DENIED error is returned.
	//
	// If the requested
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite] does not
	// exist, a NOT_FOUND error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTargetSiteRequest) Reset() {
	*x = GetTargetSiteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTargetSiteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTargetSiteRequest) ProtoMessage() {}

func (x *GetTargetSiteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTargetSiteRequest.ProtoReflect.Descriptor instead.
func (*GetTargetSiteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{4}
}

func (x *GetTargetSiteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [SiteSearchEngineService.UpdateTargetSite][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.UpdateTargetSite]
// method.
type UpdateTargetSiteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The target site to update.
	// If the caller does not have permission to update the
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite], regardless
	// of whether or not it exists, a PERMISSION_DENIED error is returned.
	//
	// If the [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite] to
	// update does not exist, a NOT_FOUND error is returned.
	TargetSite *TargetSite `protobuf:"bytes,1,opt,name=target_site,json=targetSite,proto3" json:"target_site,omitempty"`
}

func (x *UpdateTargetSiteRequest) Reset() {
	*x = UpdateTargetSiteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTargetSiteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTargetSiteRequest) ProtoMessage() {}

func (x *UpdateTargetSiteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTargetSiteRequest.ProtoReflect.Descriptor instead.
func (*UpdateTargetSiteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateTargetSiteRequest) GetTargetSite() *TargetSite {
	if x != nil {
		return x.TargetSite
	}
	return nil
}

// Metadata related to the progress of the
// [SiteSearchEngineService.UpdateTargetSite][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.UpdateTargetSite]
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type UpdateTargetSiteMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *UpdateTargetSiteMetadata) Reset() {
	*x = UpdateTargetSiteMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTargetSiteMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTargetSiteMetadata) ProtoMessage() {}

func (x *UpdateTargetSiteMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTargetSiteMetadata.ProtoReflect.Descriptor instead.
func (*UpdateTargetSiteMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateTargetSiteMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UpdateTargetSiteMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for
// [SiteSearchEngineService.DeleteTargetSite][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DeleteTargetSite]
// method.
type DeleteTargetSiteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite], such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`.
	//
	// If the caller does not have permission to access the
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite], regardless
	// of whether or not it exists, a PERMISSION_DENIED error is returned.
	//
	// If the requested
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite] does not
	// exist, a NOT_FOUND error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTargetSiteRequest) Reset() {
	*x = DeleteTargetSiteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTargetSiteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTargetSiteRequest) ProtoMessage() {}

func (x *DeleteTargetSiteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTargetSiteRequest.ProtoReflect.Descriptor instead.
func (*DeleteTargetSiteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteTargetSiteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata related to the progress of the
// [SiteSearchEngineService.DeleteTargetSite][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DeleteTargetSite]
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type DeleteTargetSiteMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *DeleteTargetSiteMetadata) Reset() {
	*x = DeleteTargetSiteMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTargetSiteMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTargetSiteMetadata) ProtoMessage() {}

func (x *DeleteTargetSiteMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTargetSiteMetadata.ProtoReflect.Descriptor instead.
func (*DeleteTargetSiteMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteTargetSiteMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeleteTargetSiteMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for
// [SiteSearchEngineService.ListTargetSites][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.ListTargetSites]
// method.
type ListTargetSitesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent site search engine resource name, such as
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
	//
	// If the caller does not have permission to list
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite]s under this
	// site search engine, regardless of whether or not this branch exists, a
	// PERMISSION_DENIED error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested. If
	// unspecified, server will pick an appropriate default. The maximum value is
	// 1000; values above 1000 will be coerced to 1000.
	//
	// If this field is negative, an INVALID_ARGUMENT error is returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListTargetSites` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListTargetSites`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTargetSitesRequest) Reset() {
	*x = ListTargetSitesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetSitesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetSitesRequest) ProtoMessage() {}

func (x *ListTargetSitesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetSitesRequest.ProtoReflect.Descriptor instead.
func (*ListTargetSitesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListTargetSitesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTargetSitesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTargetSitesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [SiteSearchEngineService.ListTargetSites][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.ListTargetSites]
// method.
type ListTargetSitesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of TargetSites.
	TargetSites []*TargetSite `protobuf:"bytes,1,rep,name=target_sites,json=targetSites,proto3" json:"target_sites,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of items matching the request.
	// This will always be populated in the response.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListTargetSitesResponse) Reset() {
	*x = ListTargetSitesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTargetSitesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetSitesResponse) ProtoMessage() {}

func (x *ListTargetSitesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetSitesResponse.ProtoReflect.Descriptor instead.
func (*ListTargetSitesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListTargetSitesResponse) GetTargetSites() []*TargetSite {
	if x != nil {
		return x.TargetSites
	}
	return nil
}

func (x *ListTargetSitesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTargetSitesResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Metadata related to the progress of the
// [SiteSearchEngineService.BatchCreateTargetSite][] operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type BatchCreateTargetSiteMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *BatchCreateTargetSiteMetadata) Reset() {
	*x = BatchCreateTargetSiteMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTargetSiteMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTargetSiteMetadata) ProtoMessage() {}

func (x *BatchCreateTargetSiteMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTargetSiteMetadata.ProtoReflect.Descriptor instead.
func (*BatchCreateTargetSiteMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{11}
}

func (x *BatchCreateTargetSiteMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BatchCreateTargetSiteMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Response message for
// [SiteSearchEngineService.BatchCreateTargetSites][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.BatchCreateTargetSites]
// method.
type BatchCreateTargetSitesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TargetSites created.
	TargetSites []*TargetSite `protobuf:"bytes,1,rep,name=target_sites,json=targetSites,proto3" json:"target_sites,omitempty"`
}

func (x *BatchCreateTargetSitesResponse) Reset() {
	*x = BatchCreateTargetSitesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTargetSitesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTargetSitesResponse) ProtoMessage() {}

func (x *BatchCreateTargetSitesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTargetSitesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateTargetSitesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{12}
}

func (x *BatchCreateTargetSitesResponse) GetTargetSites() []*TargetSite {
	if x != nil {
		return x.TargetSites
	}
	return nil
}

// Request message for
// [SiteSearchEngineService.EnableAdvancedSiteSearch][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.EnableAdvancedSiteSearch]
// method.
type EnableAdvancedSiteSearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of the
	// [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
	// such as
	// `projects/{project}/locations/{location}/dataStores/{data_store_id}/siteSearchEngine`.
	SiteSearchEngine string `protobuf:"bytes,1,opt,name=site_search_engine,json=siteSearchEngine,proto3" json:"site_search_engine,omitempty"`
}

func (x *EnableAdvancedSiteSearchRequest) Reset() {
	*x = EnableAdvancedSiteSearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableAdvancedSiteSearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableAdvancedSiteSearchRequest) ProtoMessage() {}

func (x *EnableAdvancedSiteSearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableAdvancedSiteSearchRequest.ProtoReflect.Descriptor instead.
func (*EnableAdvancedSiteSearchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{13}
}

func (x *EnableAdvancedSiteSearchRequest) GetSiteSearchEngine() string {
	if x != nil {
		return x.SiteSearchEngine
	}
	return ""
}

// Response message for
// [SiteSearchEngineService.EnableAdvancedSiteSearch][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.EnableAdvancedSiteSearch]
// method.
type EnableAdvancedSiteSearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EnableAdvancedSiteSearchResponse) Reset() {
	*x = EnableAdvancedSiteSearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableAdvancedSiteSearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableAdvancedSiteSearchResponse) ProtoMessage() {}

func (x *EnableAdvancedSiteSearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableAdvancedSiteSearchResponse.ProtoReflect.Descriptor instead.
func (*EnableAdvancedSiteSearchResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{14}
}

// Metadata related to the progress of the
// [SiteSearchEngineService.EnableAdvancedSiteSearch][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.EnableAdvancedSiteSearch]
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type EnableAdvancedSiteSearchMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *EnableAdvancedSiteSearchMetadata) Reset() {
	*x = EnableAdvancedSiteSearchMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableAdvancedSiteSearchMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableAdvancedSiteSearchMetadata) ProtoMessage() {}

func (x *EnableAdvancedSiteSearchMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableAdvancedSiteSearchMetadata.ProtoReflect.Descriptor instead.
func (*EnableAdvancedSiteSearchMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{15}
}

func (x *EnableAdvancedSiteSearchMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EnableAdvancedSiteSearchMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for
// [SiteSearchEngineService.DisableAdvancedSiteSearch][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DisableAdvancedSiteSearch]
// method.
type DisableAdvancedSiteSearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of the
	// [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
	// such as
	// `projects/{project}/locations/{location}/dataStores/{data_store_id}/siteSearchEngine`.
	SiteSearchEngine string `protobuf:"bytes,1,opt,name=site_search_engine,json=siteSearchEngine,proto3" json:"site_search_engine,omitempty"`
}

func (x *DisableAdvancedSiteSearchRequest) Reset() {
	*x = DisableAdvancedSiteSearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableAdvancedSiteSearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableAdvancedSiteSearchRequest) ProtoMessage() {}

func (x *DisableAdvancedSiteSearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableAdvancedSiteSearchRequest.ProtoReflect.Descriptor instead.
func (*DisableAdvancedSiteSearchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{16}
}

func (x *DisableAdvancedSiteSearchRequest) GetSiteSearchEngine() string {
	if x != nil {
		return x.SiteSearchEngine
	}
	return ""
}

// Response message for
// [SiteSearchEngineService.DisableAdvancedSiteSearch][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DisableAdvancedSiteSearch]
// method.
type DisableAdvancedSiteSearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisableAdvancedSiteSearchResponse) Reset() {
	*x = DisableAdvancedSiteSearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableAdvancedSiteSearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableAdvancedSiteSearchResponse) ProtoMessage() {}

func (x *DisableAdvancedSiteSearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableAdvancedSiteSearchResponse.ProtoReflect.Descriptor instead.
func (*DisableAdvancedSiteSearchResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{17}
}

// Metadata related to the progress of the
// [SiteSearchEngineService.DisableAdvancedSiteSearch][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DisableAdvancedSiteSearch]
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type DisableAdvancedSiteSearchMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *DisableAdvancedSiteSearchMetadata) Reset() {
	*x = DisableAdvancedSiteSearchMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableAdvancedSiteSearchMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableAdvancedSiteSearchMetadata) ProtoMessage() {}

func (x *DisableAdvancedSiteSearchMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableAdvancedSiteSearchMetadata.ProtoReflect.Descriptor instead.
func (*DisableAdvancedSiteSearchMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{18}
}

func (x *DisableAdvancedSiteSearchMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DisableAdvancedSiteSearchMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for
// [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.RecrawlUris]
// method.
type RecrawlUrisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of the
	// [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine],
	// such as
	// `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine`.
	SiteSearchEngine string `protobuf:"bytes,1,opt,name=site_search_engine,json=siteSearchEngine,proto3" json:"site_search_engine,omitempty"`
	// Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
	// an INVALID_ARGUMENT error is thrown. Each URI should match at least one
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite] in
	// `site_search_engine`.
	Uris []string `protobuf:"bytes,2,rep,name=uris,proto3" json:"uris,omitempty"`
}

func (x *RecrawlUrisRequest) Reset() {
	*x = RecrawlUrisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecrawlUrisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecrawlUrisRequest) ProtoMessage() {}

func (x *RecrawlUrisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecrawlUrisRequest.ProtoReflect.Descriptor instead.
func (*RecrawlUrisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{19}
}

func (x *RecrawlUrisRequest) GetSiteSearchEngine() string {
	if x != nil {
		return x.SiteSearchEngine
	}
	return ""
}

func (x *RecrawlUrisRequest) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

// Response message for
// [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.RecrawlUris]
// method.
type RecrawlUrisResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details for a sample of up to 10 `failed_uris`.
	FailureSamples []*RecrawlUrisResponse_FailureInfo `protobuf:"bytes,1,rep,name=failure_samples,json=failureSamples,proto3" json:"failure_samples,omitempty"`
	// URIs that were not crawled before the LRO terminated.
	FailedUris []string `protobuf:"bytes,2,rep,name=failed_uris,json=failedUris,proto3" json:"failed_uris,omitempty"`
}

func (x *RecrawlUrisResponse) Reset() {
	*x = RecrawlUrisResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecrawlUrisResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecrawlUrisResponse) ProtoMessage() {}

func (x *RecrawlUrisResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecrawlUrisResponse.ProtoReflect.Descriptor instead.
func (*RecrawlUrisResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{20}
}

func (x *RecrawlUrisResponse) GetFailureSamples() []*RecrawlUrisResponse_FailureInfo {
	if x != nil {
		return x.FailureSamples
	}
	return nil
}

func (x *RecrawlUrisResponse) GetFailedUris() []string {
	if x != nil {
		return x.FailedUris
	}
	return nil
}

// Metadata related to the progress of the
// [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.RecrawlUris]
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type RecrawlUrisMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Unique URIs in the request that don't match any TargetSite in the
	// DataStore, only match TargetSites that haven't been fully indexed, or match
	// a TargetSite with type EXCLUDE.
	InvalidUris []string `protobuf:"bytes,3,rep,name=invalid_uris,json=invalidUris,proto3" json:"invalid_uris,omitempty"`
	// Total number of unique URIs in the request that are not in invalid_uris.
	ValidUrisCount int32 `protobuf:"varint,4,opt,name=valid_uris_count,json=validUrisCount,proto3" json:"valid_uris_count,omitempty"`
	// Total number of URIs that have been crawled so far.
	SuccessCount int32 `protobuf:"varint,5,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Total number of URIs that have yet to be crawled.
	PendingCount int32 `protobuf:"varint,6,opt,name=pending_count,json=pendingCount,proto3" json:"pending_count,omitempty"`
	// Total number of URIs that were rejected due to insufficient indexing
	// resources.
	QuotaExceededCount int32 `protobuf:"varint,7,opt,name=quota_exceeded_count,json=quotaExceededCount,proto3" json:"quota_exceeded_count,omitempty"`
}

func (x *RecrawlUrisMetadata) Reset() {
	*x = RecrawlUrisMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecrawlUrisMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecrawlUrisMetadata) ProtoMessage() {}

func (x *RecrawlUrisMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecrawlUrisMetadata.ProtoReflect.Descriptor instead.
func (*RecrawlUrisMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{21}
}

func (x *RecrawlUrisMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *RecrawlUrisMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *RecrawlUrisMetadata) GetInvalidUris() []string {
	if x != nil {
		return x.InvalidUris
	}
	return nil
}

func (x *RecrawlUrisMetadata) GetValidUrisCount() int32 {
	if x != nil {
		return x.ValidUrisCount
	}
	return 0
}

func (x *RecrawlUrisMetadata) GetSuccessCount() int32 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *RecrawlUrisMetadata) GetPendingCount() int32 {
	if x != nil {
		return x.PendingCount
	}
	return 0
}

func (x *RecrawlUrisMetadata) GetQuotaExceededCount() int32 {
	if x != nil {
		return x.QuotaExceededCount
	}
	return 0
}

// Request message for
// [SiteSearchEngineService.BatchVerifyTargetSites][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.BatchVerifyTargetSites]
// method.
type BatchVerifyTargetSitesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource shared by all TargetSites being verified.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *BatchVerifyTargetSitesRequest) Reset() {
	*x = BatchVerifyTargetSitesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchVerifyTargetSitesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchVerifyTargetSitesRequest) ProtoMessage() {}

func (x *BatchVerifyTargetSitesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchVerifyTargetSitesRequest.ProtoReflect.Descriptor instead.
func (*BatchVerifyTargetSitesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{22}
}

func (x *BatchVerifyTargetSitesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for
// [SiteSearchEngineService.BatchVerifyTargetSites][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.BatchVerifyTargetSites]
// method.
type BatchVerifyTargetSitesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BatchVerifyTargetSitesResponse) Reset() {
	*x = BatchVerifyTargetSitesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchVerifyTargetSitesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchVerifyTargetSitesResponse) ProtoMessage() {}

func (x *BatchVerifyTargetSitesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchVerifyTargetSitesResponse.ProtoReflect.Descriptor instead.
func (*BatchVerifyTargetSitesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{23}
}

// Metadata related to the progress of the
// [SiteSearchEngineService.BatchVerifyTargetSites][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.BatchVerifyTargetSites]
// operation. This will be returned by the google.longrunning.Operation.metadata
// field.
type BatchVerifyTargetSitesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *BatchVerifyTargetSitesMetadata) Reset() {
	*x = BatchVerifyTargetSitesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchVerifyTargetSitesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchVerifyTargetSitesMetadata) ProtoMessage() {}

func (x *BatchVerifyTargetSitesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchVerifyTargetSitesMetadata.ProtoReflect.Descriptor instead.
func (*BatchVerifyTargetSitesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{24}
}

func (x *BatchVerifyTargetSitesMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BatchVerifyTargetSitesMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for
// [SiteSearchEngineService.FetchDomainVerificationStatus][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.FetchDomainVerificationStatus]
// method.
type FetchDomainVerificationStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The site search engine resource under which we fetch all the
	// domain verification status.
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.
	SiteSearchEngine string `protobuf:"bytes,1,opt,name=site_search_engine,json=siteSearchEngine,proto3" json:"site_search_engine,omitempty"`
	// Requested page size. Server may return fewer items than requested. If
	// unspecified, server will pick an appropriate default. The maximum value is
	// 1000; values above 1000 will be coerced to 1000.
	//
	// If this field is negative, an INVALID_ARGUMENT error is returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `FetchDomainVerificationStatus`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `FetchDomainVerificationStatus` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *FetchDomainVerificationStatusRequest) Reset() {
	*x = FetchDomainVerificationStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDomainVerificationStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDomainVerificationStatusRequest) ProtoMessage() {}

func (x *FetchDomainVerificationStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDomainVerificationStatusRequest.ProtoReflect.Descriptor instead.
func (*FetchDomainVerificationStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{25}
}

func (x *FetchDomainVerificationStatusRequest) GetSiteSearchEngine() string {
	if x != nil {
		return x.SiteSearchEngine
	}
	return ""
}

func (x *FetchDomainVerificationStatusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchDomainVerificationStatusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [SiteSearchEngineService.FetchDomainVerificationStatus][google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.FetchDomainVerificationStatus]
// method.
type FetchDomainVerificationStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of TargetSites containing the site verification status.
	TargetSites []*TargetSite `protobuf:"bytes,1,rep,name=target_sites,json=targetSites,proto3" json:"target_sites,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of items matching the request.
	// This will always be populated in the response.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *FetchDomainVerificationStatusResponse) Reset() {
	*x = FetchDomainVerificationStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDomainVerificationStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDomainVerificationStatusResponse) ProtoMessage() {}

func (x *FetchDomainVerificationStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDomainVerificationStatusResponse.ProtoReflect.Descriptor instead.
func (*FetchDomainVerificationStatusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{26}
}

func (x *FetchDomainVerificationStatusResponse) GetTargetSites() []*TargetSite {
	if x != nil {
		return x.TargetSites
	}
	return nil
}

func (x *FetchDomainVerificationStatusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *FetchDomainVerificationStatusResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Details about why a particular URI failed to be crawled. Each FailureInfo
// contains one FailureReason per CorpusType.
type RecrawlUrisResponse_FailureInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI that failed to be crawled.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// List of failure reasons by corpus type (e.g. desktop, mobile).
	FailureReasons []*RecrawlUrisResponse_FailureInfo_FailureReason `protobuf:"bytes,2,rep,name=failure_reasons,json=failureReasons,proto3" json:"failure_reasons,omitempty"`
}

func (x *RecrawlUrisResponse_FailureInfo) Reset() {
	*x = RecrawlUrisResponse_FailureInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecrawlUrisResponse_FailureInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecrawlUrisResponse_FailureInfo) ProtoMessage() {}

func (x *RecrawlUrisResponse_FailureInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecrawlUrisResponse_FailureInfo.ProtoReflect.Descriptor instead.
func (*RecrawlUrisResponse_FailureInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{20, 0}
}

func (x *RecrawlUrisResponse_FailureInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *RecrawlUrisResponse_FailureInfo) GetFailureReasons() []*RecrawlUrisResponse_FailureInfo_FailureReason {
	if x != nil {
		return x.FailureReasons
	}
	return nil
}

// Details about why crawling failed for a particular CorpusType, e.g.
// DESKTOP and MOBILE crawling may fail for different reasons.
type RecrawlUrisResponse_FailureInfo_FailureReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
	CorpusType RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType `protobuf:"varint,1,opt,name=corpus_type,json=corpusType,proto3,enum=google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType" json:"corpus_type,omitempty"`
	// Reason why the URI was not crawled.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *RecrawlUrisResponse_FailureInfo_FailureReason) Reset() {
	*x = RecrawlUrisResponse_FailureInfo_FailureReason{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecrawlUrisResponse_FailureInfo_FailureReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecrawlUrisResponse_FailureInfo_FailureReason) ProtoMessage() {}

func (x *RecrawlUrisResponse_FailureInfo_FailureReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecrawlUrisResponse_FailureInfo_FailureReason.ProtoReflect.Descriptor instead.
func (*RecrawlUrisResponse_FailureInfo_FailureReason) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP(), []int{20, 0, 0}
}

func (x *RecrawlUrisResponse_FailureInfo_FailureReason) GetCorpusType() RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType {
	if x != nil {
		return x.CorpusType
	}
	return RecrawlUrisResponse_FailureInfo_FailureReason_CORPUS_TYPE_UNSPECIFIED
}

func (x *RecrawlUrisResponse_FailureInfo_FailureReason) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

var File_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDesc = []byte{
	0x0a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x69, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc2, 0x01,
	0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0b, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69,
	0x74, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x1d, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53,
	0x69, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x5d, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x69, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x71, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x73, 0x69, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x22, 0x94,
	0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53,
	0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xa5,
	0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x53, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x99,
	0x01, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x75, 0x0a, 0x1e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53,
	0x69, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0c,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x53, 0x69, 0x74, 0x65, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65,
	0x73, 0x22, 0x88, 0x01, 0x0a, 0x1f, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x12, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x10, 0x73, 0x69, 0x74, 0x65,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0x22, 0x0a, 0x20,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x9c, 0x01, 0x0a, 0x20, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x89, 0x01, 0x0a, 0x20, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x12, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x10, 0x73, 0x69, 0x74, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0x23, 0x0a, 0x21, 0x44,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x9d, 0x01, 0x0a, 0x21, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x94, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x12, 0x73, 0x69, 0x74, 0x65, 0x5f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x10, 0x73, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x22, 0xc2, 0x04, 0x0a, 0x13, 0x52, 0x65, 0x63, 0x72,
	0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x6e, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x52, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x55, 0x72, 0x69, 0x73,
	0x1a, 0x99, 0x03, 0x0a, 0x0b, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x69, 0x12, 0x7c, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x52, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73,
	0x1a, 0xf9, 0x01, 0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x12, 0x7f, 0x0a, 0x0b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52,
	0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x42, 0x0a, 0x0a, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x52, 0x50, 0x55, 0x53,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x53, 0x4b, 0x54, 0x4f, 0x50, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x42, 0x49, 0x4c, 0x45, 0x10, 0x02, 0x22, 0xd8, 0x02, 0x0a,
	0x13, 0x52, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x55, 0x72, 0x69,
	0x73, 0x12, 0x28, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x55, 0x72, 0x69, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0c, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x65,
	0x78, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x12, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x45, 0x78, 0x63, 0x65, 0x65, 0x64,
	0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x70, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31,
	0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x20, 0x0a, 0x1e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69,
	0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x1e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x24, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x65, 0x0a, 0x12, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x10, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc3, 0x01, 0x0a, 0x25, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53,
	0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69,
	0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x32, 0xc0, 0x28, 0x0a, 0x17, 0x53,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xbc, 0x02, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x53, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0xaa, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9c, 0x01, 0x5a, 0x54, 0x12, 0x52, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x12,
	0x44, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x7d, 0x12, 0xd4, 0x03, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe1, 0x02, 0xca, 0x41, 0x70, 0x0a, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x12,
	0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73,
	0x69, 0x74, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd2, 0x01, 0x3a, 0x0b, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5a, 0x6f, 0x3a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x22, 0x60, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d,
	0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x12, 0xe9, 0x03, 0x0a,
	0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x53, 0x69, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xea, 0x02, 0xca, 0x41,
	0x89, 0x01, 0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53,
	0x69, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xd6, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x71, 0x3a, 0x01, 0x2a, 0x22, 0x6c, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d,
	0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x22, 0x5e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d,
	0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0xc6, 0x02, 0x0a, 0x0d, 0x47, 0x65, 0x74,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x22, 0xc6, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb8, 0x01, 0x5a, 0x62, 0x12, 0x60, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x52, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xe5, 0x03, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf2, 0x02, 0xca, 0x41, 0x70, 0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x12, 0x3d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69,
	0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0b, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xea, 0x01, 0x3a,
	0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5a, 0x7b, 0x3a, 0x0b,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x32, 0x6c, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69,
	0x74, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x5e, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x92, 0x03, 0x0a, 0x10, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x12, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x02, 0xca,
	0x41, 0x56, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0xb8, 0x01, 0x5a, 0x62, 0x2a, 0x60, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x52, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd9,
	0x02, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74,
	0x65, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xc8, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xb8, 0x01, 0x5a, 0x62, 0x12, 0x60, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x12, 0x52, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74,
	0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x12, 0x8c, 0x04, 0x0a, 0x18, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74,
	0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74,
	0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x03,
	0xca, 0x41, 0x8e, 0x01, 0x0a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf0, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x7e, 0x3a, 0x01,
	0x2a, 0x22, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x69, 0x74,
	0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x7d, 0x3a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x6b, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d,
	0x3a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53,
	0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x92, 0x04, 0x0a, 0x19, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74,
	0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69,
	0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d,
	0x03, 0xca, 0x41, 0x90, 0x01, 0x0a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf2, 0x01, 0x3a, 0x01, 0x2a, 0x5a,
	0x7f, 0x3a, 0x01, 0x2a, 0x22, 0x7a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b,
	0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x3a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x22, 0x6c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x7d, 0x3a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x53, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0xbd,
	0x03, 0x0a, 0x0b, 0x52, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd4, 0x02, 0xca, 0x41, 0x74, 0x0a, 0x38, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65,
	0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd6, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x71, 0x3a, 0x01, 0x2a,
	0x22, 0x6c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x7d, 0x3a, 0x72, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x22, 0x5e,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x7d, 0x3a, 0x72, 0x65, 0x63, 0x72, 0x61, 0x77, 0x6c, 0x55, 0x72, 0x69, 0x73, 0x12, 0x83,
	0x03, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x02,
	0xca, 0x41, 0x8a, 0x01, 0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x69, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x69, 0x74, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x70, 0x3a, 0x01, 0x2a, 0x22, 0x6b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x3a, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53,
	0x69, 0x74, 0x65, 0x73, 0x12, 0xc2, 0x02, 0x0a, 0x1d, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x87, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x80, 0x01, 0x12, 0x7e, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63,
	0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa8, 0x02,
	0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x1c, 0x53, 0x69, 0x74, 0x65,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02,
	0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45,
	0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02,
	0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a,
	0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_goTypes = []interface{}{
	(RecrawlUrisResponse_FailureInfo_FailureReason_CorpusType)(0), // 0: google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType
	(*GetSiteSearchEngineRequest)(nil),                            // 1: google.cloud.discoveryengine.v1alpha.GetSiteSearchEngineRequest
	(*CreateTargetSiteRequest)(nil),                               // 2: google.cloud.discoveryengine.v1alpha.CreateTargetSiteRequest
	(*CreateTargetSiteMetadata)(nil),                              // 3: google.cloud.discoveryengine.v1alpha.CreateTargetSiteMetadata
	(*BatchCreateTargetSitesRequest)(nil),                         // 4: google.cloud.discoveryengine.v1alpha.BatchCreateTargetSitesRequest
	(*GetTargetSiteRequest)(nil),                                  // 5: google.cloud.discoveryengine.v1alpha.GetTargetSiteRequest
	(*UpdateTargetSiteRequest)(nil),                               // 6: google.cloud.discoveryengine.v1alpha.UpdateTargetSiteRequest
	(*UpdateTargetSiteMetadata)(nil),                              // 7: google.cloud.discoveryengine.v1alpha.UpdateTargetSiteMetadata
	(*DeleteTargetSiteRequest)(nil),                               // 8: google.cloud.discoveryengine.v1alpha.DeleteTargetSiteRequest
	(*DeleteTargetSiteMetadata)(nil),                              // 9: google.cloud.discoveryengine.v1alpha.DeleteTargetSiteMetadata
	(*ListTargetSitesRequest)(nil),                                // 10: google.cloud.discoveryengine.v1alpha.ListTargetSitesRequest
	(*ListTargetSitesResponse)(nil),                               // 11: google.cloud.discoveryengine.v1alpha.ListTargetSitesResponse
	(*BatchCreateTargetSiteMetadata)(nil),                         // 12: google.cloud.discoveryengine.v1alpha.BatchCreateTargetSiteMetadata
	(*BatchCreateTargetSitesResponse)(nil),                        // 13: google.cloud.discoveryengine.v1alpha.BatchCreateTargetSitesResponse
	(*EnableAdvancedSiteSearchRequest)(nil),                       // 14: google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchRequest
	(*EnableAdvancedSiteSearchResponse)(nil),                      // 15: google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchResponse
	(*EnableAdvancedSiteSearchMetadata)(nil),                      // 16: google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchMetadata
	(*DisableAdvancedSiteSearchRequest)(nil),                      // 17: google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchRequest
	(*DisableAdvancedSiteSearchResponse)(nil),                     // 18: google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchResponse
	(*DisableAdvancedSiteSearchMetadata)(nil),                     // 19: google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchMetadata
	(*RecrawlUrisRequest)(nil),                                    // 20: google.cloud.discoveryengine.v1alpha.RecrawlUrisRequest
	(*RecrawlUrisResponse)(nil),                                   // 21: google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse
	(*RecrawlUrisMetadata)(nil),                                   // 22: google.cloud.discoveryengine.v1alpha.RecrawlUrisMetadata
	(*BatchVerifyTargetSitesRequest)(nil),                         // 23: google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesRequest
	(*BatchVerifyTargetSitesResponse)(nil),                        // 24: google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesResponse
	(*BatchVerifyTargetSitesMetadata)(nil),                        // 25: google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesMetadata
	(*FetchDomainVerificationStatusRequest)(nil),                  // 26: google.cloud.discoveryengine.v1alpha.FetchDomainVerificationStatusRequest
	(*FetchDomainVerificationStatusResponse)(nil),                 // 27: google.cloud.discoveryengine.v1alpha.FetchDomainVerificationStatusResponse
	(*RecrawlUrisResponse_FailureInfo)(nil),                       // 28: google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
	(*RecrawlUrisResponse_FailureInfo_FailureReason)(nil),         // 29: google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
	(*TargetSite)(nil),                                            // 30: google.cloud.discoveryengine.v1alpha.TargetSite
	(*timestamppb.Timestamp)(nil),                                 // 31: google.protobuf.Timestamp
	(*SiteSearchEngine)(nil),                                      // 32: google.cloud.discoveryengine.v1alpha.SiteSearchEngine
	(*longrunningpb.Operation)(nil),                               // 33: google.longrunning.Operation
}
var file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_depIdxs = []int32{
	30, // 0: google.cloud.discoveryengine.v1alpha.CreateTargetSiteRequest.target_site:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite
	31, // 1: google.cloud.discoveryengine.v1alpha.CreateTargetSiteMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 2: google.cloud.discoveryengine.v1alpha.CreateTargetSiteMetadata.update_time:type_name -> google.protobuf.Timestamp
	2,  // 3: google.cloud.discoveryengine.v1alpha.BatchCreateTargetSitesRequest.requests:type_name -> google.cloud.discoveryengine.v1alpha.CreateTargetSiteRequest
	30, // 4: google.cloud.discoveryengine.v1alpha.UpdateTargetSiteRequest.target_site:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite
	31, // 5: google.cloud.discoveryengine.v1alpha.UpdateTargetSiteMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 6: google.cloud.discoveryengine.v1alpha.UpdateTargetSiteMetadata.update_time:type_name -> google.protobuf.Timestamp
	31, // 7: google.cloud.discoveryengine.v1alpha.DeleteTargetSiteMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 8: google.cloud.discoveryengine.v1alpha.DeleteTargetSiteMetadata.update_time:type_name -> google.protobuf.Timestamp
	30, // 9: google.cloud.discoveryengine.v1alpha.ListTargetSitesResponse.target_sites:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite
	31, // 10: google.cloud.discoveryengine.v1alpha.BatchCreateTargetSiteMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 11: google.cloud.discoveryengine.v1alpha.BatchCreateTargetSiteMetadata.update_time:type_name -> google.protobuf.Timestamp
	30, // 12: google.cloud.discoveryengine.v1alpha.BatchCreateTargetSitesResponse.target_sites:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite
	31, // 13: google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 14: google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchMetadata.update_time:type_name -> google.protobuf.Timestamp
	31, // 15: google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 16: google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchMetadata.update_time:type_name -> google.protobuf.Timestamp
	28, // 17: google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.failure_samples:type_name -> google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo
	31, // 18: google.cloud.discoveryengine.v1alpha.RecrawlUrisMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 19: google.cloud.discoveryengine.v1alpha.RecrawlUrisMetadata.update_time:type_name -> google.protobuf.Timestamp
	31, // 20: google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 21: google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesMetadata.update_time:type_name -> google.protobuf.Timestamp
	30, // 22: google.cloud.discoveryengine.v1alpha.FetchDomainVerificationStatusResponse.target_sites:type_name -> google.cloud.discoveryengine.v1alpha.TargetSite
	29, // 23: google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.failure_reasons:type_name -> google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason
	0,  // 24: google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.corpus_type:type_name -> google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse.FailureInfo.FailureReason.CorpusType
	1,  // 25: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.GetSiteSearchEngine:input_type -> google.cloud.discoveryengine.v1alpha.GetSiteSearchEngineRequest
	2,  // 26: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.CreateTargetSite:input_type -> google.cloud.discoveryengine.v1alpha.CreateTargetSiteRequest
	4,  // 27: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.BatchCreateTargetSites:input_type -> google.cloud.discoveryengine.v1alpha.BatchCreateTargetSitesRequest
	5,  // 28: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.GetTargetSite:input_type -> google.cloud.discoveryengine.v1alpha.GetTargetSiteRequest
	6,  // 29: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.UpdateTargetSite:input_type -> google.cloud.discoveryengine.v1alpha.UpdateTargetSiteRequest
	8,  // 30: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DeleteTargetSite:input_type -> google.cloud.discoveryengine.v1alpha.DeleteTargetSiteRequest
	10, // 31: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.ListTargetSites:input_type -> google.cloud.discoveryengine.v1alpha.ListTargetSitesRequest
	14, // 32: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.EnableAdvancedSiteSearch:input_type -> google.cloud.discoveryengine.v1alpha.EnableAdvancedSiteSearchRequest
	17, // 33: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DisableAdvancedSiteSearch:input_type -> google.cloud.discoveryengine.v1alpha.DisableAdvancedSiteSearchRequest
	20, // 34: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.RecrawlUris:input_type -> google.cloud.discoveryengine.v1alpha.RecrawlUrisRequest
	23, // 35: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.BatchVerifyTargetSites:input_type -> google.cloud.discoveryengine.v1alpha.BatchVerifyTargetSitesRequest
	26, // 36: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.FetchDomainVerificationStatus:input_type -> google.cloud.discoveryengine.v1alpha.FetchDomainVerificationStatusRequest
	32, // 37: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.GetSiteSearchEngine:output_type -> google.cloud.discoveryengine.v1alpha.SiteSearchEngine
	33, // 38: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.CreateTargetSite:output_type -> google.longrunning.Operation
	33, // 39: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.BatchCreateTargetSites:output_type -> google.longrunning.Operation
	30, // 40: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.GetTargetSite:output_type -> google.cloud.discoveryengine.v1alpha.TargetSite
	33, // 41: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.UpdateTargetSite:output_type -> google.longrunning.Operation
	33, // 42: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DeleteTargetSite:output_type -> google.longrunning.Operation
	11, // 43: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.ListTargetSites:output_type -> google.cloud.discoveryengine.v1alpha.ListTargetSitesResponse
	33, // 44: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.EnableAdvancedSiteSearch:output_type -> google.longrunning.Operation
	33, // 45: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.DisableAdvancedSiteSearch:output_type -> google.longrunning.Operation
	33, // 46: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.RecrawlUris:output_type -> google.longrunning.Operation
	33, // 47: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.BatchVerifyTargetSites:output_type -> google.longrunning.Operation
	27, // 48: google.cloud.discoveryengine.v1alpha.SiteSearchEngineService.FetchDomainVerificationStatus:output_type -> google.cloud.discoveryengine.v1alpha.FetchDomainVerificationStatusResponse
	37, // [37:49] is the sub-list for method output_type
	25, // [25:37] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSiteSearchEngineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTargetSiteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTargetSiteMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateTargetSitesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTargetSiteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTargetSiteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTargetSiteMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTargetSiteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTargetSiteMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetSitesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTargetSitesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateTargetSiteMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateTargetSitesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableAdvancedSiteSearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableAdvancedSiteSearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableAdvancedSiteSearchMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableAdvancedSiteSearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableAdvancedSiteSearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableAdvancedSiteSearchMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecrawlUrisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecrawlUrisResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecrawlUrisMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchVerifyTargetSitesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchVerifyTargetSitesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchVerifyTargetSitesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchDomainVerificationStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchDomainVerificationStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecrawlUrisResponse_FailureInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecrawlUrisResponse_FailureInfo_FailureReason); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_site_search_engine_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SiteSearchEngineServiceClient is the client API for SiteSearchEngineService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SiteSearchEngineServiceClient interface {
	// Gets the
	// [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine].
	GetSiteSearchEngine(ctx context.Context, in *GetSiteSearchEngineRequest, opts ...grpc.CallOption) (*SiteSearchEngine, error)
	// Creates a [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
	CreateTargetSite(ctx context.Context, in *CreateTargetSiteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite] in a
	// batch.
	BatchCreateTargetSites(ctx context.Context, in *BatchCreateTargetSitesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
	GetTargetSite(ctx context.Context, in *GetTargetSiteRequest, opts ...grpc.CallOption) (*TargetSite, error)
	// Updates a [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
	UpdateTargetSite(ctx context.Context, in *UpdateTargetSiteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
	DeleteTargetSite(ctx context.Context, in *DeleteTargetSiteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a list of
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite]s.
	ListTargetSites(ctx context.Context, in *ListTargetSitesRequest, opts ...grpc.CallOption) (*ListTargetSitesResponse, error)
	// Upgrade from basic site search to advanced site search.
	EnableAdvancedSiteSearch(ctx context.Context, in *EnableAdvancedSiteSearchRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Downgrade from advanced site search to basic site search.
	DisableAdvancedSiteSearch(ctx context.Context, in *DisableAdvancedSiteSearchRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Request on-demand recrawl for a list of URIs.
	RecrawlUris(ctx context.Context, in *RecrawlUrisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Verify target sites' ownership and validity.
	// This API sends all the target sites under site search engine for
	// verification.
	BatchVerifyTargetSites(ctx context.Context, in *BatchVerifyTargetSitesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns list of target sites with its domain verification status.
	// This method can only be called under data store with BASIC_SITE_SEARCH
	// state at the moment.
	FetchDomainVerificationStatus(ctx context.Context, in *FetchDomainVerificationStatusRequest, opts ...grpc.CallOption) (*FetchDomainVerificationStatusResponse, error)
}

type siteSearchEngineServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSiteSearchEngineServiceClient(cc grpc.ClientConnInterface) SiteSearchEngineServiceClient {
	return &siteSearchEngineServiceClient{cc}
}

func (c *siteSearchEngineServiceClient) GetSiteSearchEngine(ctx context.Context, in *GetSiteSearchEngineRequest, opts ...grpc.CallOption) (*SiteSearchEngine, error) {
	out := new(SiteSearchEngine)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/GetSiteSearchEngine", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) CreateTargetSite(ctx context.Context, in *CreateTargetSiteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/CreateTargetSite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) BatchCreateTargetSites(ctx context.Context, in *BatchCreateTargetSitesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/BatchCreateTargetSites", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) GetTargetSite(ctx context.Context, in *GetTargetSiteRequest, opts ...grpc.CallOption) (*TargetSite, error) {
	out := new(TargetSite)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/GetTargetSite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) UpdateTargetSite(ctx context.Context, in *UpdateTargetSiteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/UpdateTargetSite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) DeleteTargetSite(ctx context.Context, in *DeleteTargetSiteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/DeleteTargetSite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) ListTargetSites(ctx context.Context, in *ListTargetSitesRequest, opts ...grpc.CallOption) (*ListTargetSitesResponse, error) {
	out := new(ListTargetSitesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/ListTargetSites", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) EnableAdvancedSiteSearch(ctx context.Context, in *EnableAdvancedSiteSearchRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/EnableAdvancedSiteSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) DisableAdvancedSiteSearch(ctx context.Context, in *DisableAdvancedSiteSearchRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/DisableAdvancedSiteSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) RecrawlUris(ctx context.Context, in *RecrawlUrisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/RecrawlUris", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) BatchVerifyTargetSites(ctx context.Context, in *BatchVerifyTargetSitesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/BatchVerifyTargetSites", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *siteSearchEngineServiceClient) FetchDomainVerificationStatus(ctx context.Context, in *FetchDomainVerificationStatusRequest, opts ...grpc.CallOption) (*FetchDomainVerificationStatusResponse, error) {
	out := new(FetchDomainVerificationStatusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/FetchDomainVerificationStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SiteSearchEngineServiceServer is the server API for SiteSearchEngineService service.
type SiteSearchEngineServiceServer interface {
	// Gets the
	// [SiteSearchEngine][google.cloud.discoveryengine.v1alpha.SiteSearchEngine].
	GetSiteSearchEngine(context.Context, *GetSiteSearchEngineRequest) (*SiteSearchEngine, error)
	// Creates a [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
	CreateTargetSite(context.Context, *CreateTargetSiteRequest) (*longrunningpb.Operation, error)
	// Creates [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite] in a
	// batch.
	BatchCreateTargetSites(context.Context, *BatchCreateTargetSitesRequest) (*longrunningpb.Operation, error)
	// Gets a [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
	GetTargetSite(context.Context, *GetTargetSiteRequest) (*TargetSite, error)
	// Updates a [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
	UpdateTargetSite(context.Context, *UpdateTargetSiteRequest) (*longrunningpb.Operation, error)
	// Deletes a [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
	DeleteTargetSite(context.Context, *DeleteTargetSiteRequest) (*longrunningpb.Operation, error)
	// Gets a list of
	// [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite]s.
	ListTargetSites(context.Context, *ListTargetSitesRequest) (*ListTargetSitesResponse, error)
	// Upgrade from basic site search to advanced site search.
	EnableAdvancedSiteSearch(context.Context, *EnableAdvancedSiteSearchRequest) (*longrunningpb.Operation, error)
	// Downgrade from advanced site search to basic site search.
	DisableAdvancedSiteSearch(context.Context, *DisableAdvancedSiteSearchRequest) (*longrunningpb.Operation, error)
	// Request on-demand recrawl for a list of URIs.
	RecrawlUris(context.Context, *RecrawlUrisRequest) (*longrunningpb.Operation, error)
	// Verify target sites' ownership and validity.
	// This API sends all the target sites under site search engine for
	// verification.
	BatchVerifyTargetSites(context.Context, *BatchVerifyTargetSitesRequest) (*longrunningpb.Operation, error)
	// Returns list of target sites with its domain verification status.
	// This method can only be called under data store with BASIC_SITE_SEARCH
	// state at the moment.
	FetchDomainVerificationStatus(context.Context, *FetchDomainVerificationStatusRequest) (*FetchDomainVerificationStatusResponse, error)
}

// UnimplementedSiteSearchEngineServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSiteSearchEngineServiceServer struct {
}

func (*UnimplementedSiteSearchEngineServiceServer) GetSiteSearchEngine(context.Context, *GetSiteSearchEngineRequest) (*SiteSearchEngine, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSiteSearchEngine not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) CreateTargetSite(context.Context, *CreateTargetSiteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTargetSite not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) BatchCreateTargetSites(context.Context, *BatchCreateTargetSitesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateTargetSites not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) GetTargetSite(context.Context, *GetTargetSiteRequest) (*TargetSite, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTargetSite not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) UpdateTargetSite(context.Context, *UpdateTargetSiteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTargetSite not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) DeleteTargetSite(context.Context, *DeleteTargetSiteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTargetSite not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) ListTargetSites(context.Context, *ListTargetSitesRequest) (*ListTargetSitesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTargetSites not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) EnableAdvancedSiteSearch(context.Context, *EnableAdvancedSiteSearchRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableAdvancedSiteSearch not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) DisableAdvancedSiteSearch(context.Context, *DisableAdvancedSiteSearchRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableAdvancedSiteSearch not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) RecrawlUris(context.Context, *RecrawlUrisRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecrawlUris not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) BatchVerifyTargetSites(context.Context, *BatchVerifyTargetSitesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchVerifyTargetSites not implemented")
}
func (*UnimplementedSiteSearchEngineServiceServer) FetchDomainVerificationStatus(context.Context, *FetchDomainVerificationStatusRequest) (*FetchDomainVerificationStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchDomainVerificationStatus not implemented")
}

func RegisterSiteSearchEngineServiceServer(s *grpc.Server, srv SiteSearchEngineServiceServer) {
	s.RegisterService(&_SiteSearchEngineService_serviceDesc, srv)
}

func _SiteSearchEngineService_GetSiteSearchEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSiteSearchEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).GetSiteSearchEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/GetSiteSearchEngine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).GetSiteSearchEngine(ctx, req.(*GetSiteSearchEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_CreateTargetSite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetSiteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).CreateTargetSite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/CreateTargetSite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).CreateTargetSite(ctx, req.(*CreateTargetSiteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_BatchCreateTargetSites_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateTargetSitesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).BatchCreateTargetSites(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/BatchCreateTargetSites",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).BatchCreateTargetSites(ctx, req.(*BatchCreateTargetSitesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_GetTargetSite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetSiteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).GetTargetSite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/GetTargetSite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).GetTargetSite(ctx, req.(*GetTargetSiteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_UpdateTargetSite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetSiteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).UpdateTargetSite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/UpdateTargetSite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).UpdateTargetSite(ctx, req.(*UpdateTargetSiteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_DeleteTargetSite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTargetSiteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).DeleteTargetSite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/DeleteTargetSite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).DeleteTargetSite(ctx, req.(*DeleteTargetSiteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_ListTargetSites_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetSitesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).ListTargetSites(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/ListTargetSites",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).ListTargetSites(ctx, req.(*ListTargetSitesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_EnableAdvancedSiteSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableAdvancedSiteSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).EnableAdvancedSiteSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/EnableAdvancedSiteSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).EnableAdvancedSiteSearch(ctx, req.(*EnableAdvancedSiteSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_DisableAdvancedSiteSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableAdvancedSiteSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).DisableAdvancedSiteSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/DisableAdvancedSiteSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).DisableAdvancedSiteSearch(ctx, req.(*DisableAdvancedSiteSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_RecrawlUris_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecrawlUrisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).RecrawlUris(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/RecrawlUris",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).RecrawlUris(ctx, req.(*RecrawlUrisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_BatchVerifyTargetSites_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchVerifyTargetSitesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).BatchVerifyTargetSites(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/BatchVerifyTargetSites",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).BatchVerifyTargetSites(ctx, req.(*BatchVerifyTargetSitesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SiteSearchEngineService_FetchDomainVerificationStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchDomainVerificationStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SiteSearchEngineServiceServer).FetchDomainVerificationStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SiteSearchEngineService/FetchDomainVerificationStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SiteSearchEngineServiceServer).FetchDomainVerificationStatus(ctx, req.(*FetchDomainVerificationStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SiteSearchEngineService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1alpha.SiteSearchEngineService",
	HandlerType: (*SiteSearchEngineServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSiteSearchEngine",
			Handler:    _SiteSearchEngineService_GetSiteSearchEngine_Handler,
		},
		{
			MethodName: "CreateTargetSite",
			Handler:    _SiteSearchEngineService_CreateTargetSite_Handler,
		},
		{
			MethodName: "BatchCreateTargetSites",
			Handler:    _SiteSearchEngineService_BatchCreateTargetSites_Handler,
		},
		{
			MethodName: "GetTargetSite",
			Handler:    _SiteSearchEngineService_GetTargetSite_Handler,
		},
		{
			MethodName: "UpdateTargetSite",
			Handler:    _SiteSearchEngineService_UpdateTargetSite_Handler,
		},
		{
			MethodName: "DeleteTargetSite",
			Handler:    _SiteSearchEngineService_DeleteTargetSite_Handler,
		},
		{
			MethodName: "ListTargetSites",
			Handler:    _SiteSearchEngineService_ListTargetSites_Handler,
		},
		{
			MethodName: "EnableAdvancedSiteSearch",
			Handler:    _SiteSearchEngineService_EnableAdvancedSiteSearch_Handler,
		},
		{
			MethodName: "DisableAdvancedSiteSearch",
			Handler:    _SiteSearchEngineService_DisableAdvancedSiteSearch_Handler,
		},
		{
			MethodName: "RecrawlUris",
			Handler:    _SiteSearchEngineService_RecrawlUris_Handler,
		},
		{
			MethodName: "BatchVerifyTargetSites",
			Handler:    _SiteSearchEngineService_BatchVerifyTargetSites_Handler,
		},
		{
			MethodName: "FetchDomainVerificationStatus",
			Handler:    _SiteSearchEngineService_FetchDomainVerificationStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1alpha/site_search_engine_service.proto",
}
