// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

package speechpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Message sent by the client for the `CreatePhraseSet` method.
type CreatePhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this phrase set will be created.
	// Format:
	//
	// `projects/{project}/locations/{location}`
	//
	// Speech-to-Text supports three locations: `global`, `us` (US North America),
	// and `eu` (Europe). If you are calling the `speech.googleapis.com`
	// endpoint, use the `global` location. To specify a region, use a
	// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
	// with matching `us` or `eu` location value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the phrase set, which will become the final
	// component of the phrase set's resource name.
	//
	// This value should restrict to letters, numbers, and hyphens, with the first
	// character a letter, the last a letter or a number, and be 4-63 characters.
	PhraseSetId string `protobuf:"bytes,2,opt,name=phrase_set_id,json=phraseSetId,proto3" json:"phrase_set_id,omitempty"`
	// Required. The phrase set to create.
	PhraseSet *PhraseSet `protobuf:"bytes,3,opt,name=phrase_set,json=phraseSet,proto3" json:"phrase_set,omitempty"`
}

func (x *CreatePhraseSetRequest) Reset() {
	*x = CreatePhraseSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePhraseSetRequest) ProtoMessage() {}

func (x *CreatePhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePhraseSetRequest.ProtoReflect.Descriptor instead.
func (*CreatePhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{0}
}

func (x *CreatePhraseSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePhraseSetRequest) GetPhraseSetId() string {
	if x != nil {
		return x.PhraseSetId
	}
	return ""
}

func (x *CreatePhraseSetRequest) GetPhraseSet() *PhraseSet {
	if x != nil {
		return x.PhraseSet
	}
	return nil
}

// Message sent by the client for the `UpdatePhraseSet` method.
type UpdatePhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The phrase set to update.
	//
	// The phrase set's `name` field is used to identify the set to be
	// updated. Format:
	//
	// `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
	//
	// Speech-to-Text supports three locations: `global`, `us` (US North America),
	// and `eu` (Europe). If you are calling the `speech.googleapis.com`
	// endpoint, use the `global` location. To specify a region, use a
	// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
	// with matching `us` or `eu` location value.
	PhraseSet *PhraseSet `protobuf:"bytes,1,opt,name=phrase_set,json=phraseSet,proto3" json:"phrase_set,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePhraseSetRequest) Reset() {
	*x = UpdatePhraseSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePhraseSetRequest) ProtoMessage() {}

func (x *UpdatePhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePhraseSetRequest.ProtoReflect.Descriptor instead.
func (*UpdatePhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{1}
}

func (x *UpdatePhraseSetRequest) GetPhraseSet() *PhraseSet {
	if x != nil {
		return x.PhraseSet
	}
	return nil
}

func (x *UpdatePhraseSetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Message sent by the client for the `GetPhraseSet` method.
type GetPhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the phrase set to retrieve. Format:
	//
	// `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
	//
	// Speech-to-Text supports three locations: `global`, `us` (US North America),
	// and `eu` (Europe). If you are calling the `speech.googleapis.com`
	// endpoint, use the `global` location. To specify a region, use a
	// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
	// with matching `us` or `eu` location value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPhraseSetRequest) Reset() {
	*x = GetPhraseSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhraseSetRequest) ProtoMessage() {}

func (x *GetPhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhraseSetRequest.ProtoReflect.Descriptor instead.
func (*GetPhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{2}
}

func (x *GetPhraseSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message sent by the client for the `ListPhraseSet` method.
type ListPhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of phrase set. Format:
	//
	// `projects/{project}/locations/{location}`
	//
	// Speech-to-Text supports three locations: `global`, `us` (US North America),
	// and `eu` (Europe). If you are calling the `speech.googleapis.com`
	// endpoint, use the `global` location. To specify a region, use a
	// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
	// with matching `us` or `eu` location value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of phrase sets to return. The service may return
	// fewer than this value. If unspecified, at most 50 phrase sets will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListPhraseSet` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListPhraseSet` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPhraseSetRequest) Reset() {
	*x = ListPhraseSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseSetRequest) ProtoMessage() {}

func (x *ListPhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseSetRequest.ProtoReflect.Descriptor instead.
func (*ListPhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{3}
}

func (x *ListPhraseSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPhraseSetRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPhraseSetRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message returned to the client by the `ListPhraseSet` method.
type ListPhraseSetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The phrase set.
	PhraseSets []*PhraseSet `protobuf:"bytes,1,rep,name=phrase_sets,json=phraseSets,proto3" json:"phrase_sets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPhraseSetResponse) Reset() {
	*x = ListPhraseSetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPhraseSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseSetResponse) ProtoMessage() {}

func (x *ListPhraseSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseSetResponse.ProtoReflect.Descriptor instead.
func (*ListPhraseSetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{4}
}

func (x *ListPhraseSetResponse) GetPhraseSets() []*PhraseSet {
	if x != nil {
		return x.PhraseSets
	}
	return nil
}

func (x *ListPhraseSetResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message sent by the client for the `DeletePhraseSet` method.
type DeletePhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the phrase set to delete. Format:
	//
	// `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePhraseSetRequest) Reset() {
	*x = DeletePhraseSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePhraseSetRequest) ProtoMessage() {}

func (x *DeletePhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePhraseSetRequest.ProtoReflect.Descriptor instead.
func (*DeletePhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{5}
}

func (x *DeletePhraseSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message sent by the client for the `CreateCustomClass` method.
type CreateCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this custom class will be created.
	// Format:
	//
	// `projects/{project}/locations/{location}/customClasses`
	//
	// Speech-to-Text supports three locations: `global`, `us` (US North America),
	// and `eu` (Europe). If you are calling the `speech.googleapis.com`
	// endpoint, use the `global` location. To specify a region, use a
	// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
	// with matching `us` or `eu` location value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the custom class, which will become the final
	// component of the custom class' resource name.
	//
	// This value should restrict to letters, numbers, and hyphens, with the first
	// character a letter, the last a letter or a number, and be 4-63 characters.
	CustomClassId string `protobuf:"bytes,2,opt,name=custom_class_id,json=customClassId,proto3" json:"custom_class_id,omitempty"`
	// Required. The custom class to create.
	CustomClass *CustomClass `protobuf:"bytes,3,opt,name=custom_class,json=customClass,proto3" json:"custom_class,omitempty"`
}

func (x *CreateCustomClassRequest) Reset() {
	*x = CreateCustomClassRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomClassRequest) ProtoMessage() {}

func (x *CreateCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomClassRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{6}
}

func (x *CreateCustomClassRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomClassRequest) GetCustomClassId() string {
	if x != nil {
		return x.CustomClassId
	}
	return ""
}

func (x *CreateCustomClassRequest) GetCustomClass() *CustomClass {
	if x != nil {
		return x.CustomClass
	}
	return nil
}

// Message sent by the client for the `UpdateCustomClass` method.
type UpdateCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The custom class to update.
	//
	// The custom class's `name` field is used to identify the custom class to be
	// updated. Format:
	//
	// `projects/{project}/locations/{location}/customClasses/{custom_class}`
	//
	// Speech-to-Text supports three locations: `global`, `us` (US North America),
	// and `eu` (Europe). If you are calling the `speech.googleapis.com`
	// endpoint, use the `global` location. To specify a region, use a
	// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
	// with matching `us` or `eu` location value.
	CustomClass *CustomClass `protobuf:"bytes,1,opt,name=custom_class,json=customClass,proto3" json:"custom_class,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomClassRequest) Reset() {
	*x = UpdateCustomClassRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomClassRequest) ProtoMessage() {}

func (x *UpdateCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomClassRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateCustomClassRequest) GetCustomClass() *CustomClass {
	if x != nil {
		return x.CustomClass
	}
	return nil
}

func (x *UpdateCustomClassRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Message sent by the client for the `GetCustomClass` method.
type GetCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the custom class to retrieve. Format:
	//
	// `projects/{project}/locations/{location}/customClasses/{custom_class}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomClassRequest) Reset() {
	*x = GetCustomClassRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomClassRequest) ProtoMessage() {}

func (x *GetCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomClassRequest.ProtoReflect.Descriptor instead.
func (*GetCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{8}
}

func (x *GetCustomClassRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message sent by the client for the `ListCustomClasses` method.
type ListCustomClassesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of custom classes. Format:
	//
	// `projects/{project}/locations/{location}/customClasses`
	//
	// Speech-to-Text supports three locations: `global`, `us` (US North America),
	// and `eu` (Europe). If you are calling the `speech.googleapis.com`
	// endpoint, use the `global` location. To specify a region, use a
	// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
	// with matching `us` or `eu` location value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of custom classes to return. The service may return
	// fewer than this value. If unspecified, at most 50 custom classes will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomClass` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomClass` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomClassesRequest) Reset() {
	*x = ListCustomClassesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomClassesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomClassesRequest) ProtoMessage() {}

func (x *ListCustomClassesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomClassesRequest.ProtoReflect.Descriptor instead.
func (*ListCustomClassesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{9}
}

func (x *ListCustomClassesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomClassesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomClassesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message returned to the client by the `ListCustomClasses` method.
type ListCustomClassesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The custom classes.
	CustomClasses []*CustomClass `protobuf:"bytes,1,rep,name=custom_classes,json=customClasses,proto3" json:"custom_classes,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomClassesResponse) Reset() {
	*x = ListCustomClassesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomClassesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomClassesResponse) ProtoMessage() {}

func (x *ListCustomClassesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomClassesResponse.ProtoReflect.Descriptor instead.
func (*ListCustomClassesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{10}
}

func (x *ListCustomClassesResponse) GetCustomClasses() []*CustomClass {
	if x != nil {
		return x.CustomClasses
	}
	return nil
}

func (x *ListCustomClassesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message sent by the client for the `DeleteCustomClass` method.
type DeleteCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the custom class to delete. Format:
	//
	// `projects/{project}/locations/{location}/customClasses/{custom_class}`
	//
	// Speech-to-Text supports three locations: `global`, `us` (US North America),
	// and `eu` (Europe). If you are calling the `speech.googleapis.com`
	// endpoint, use the `global` location. To specify a region, use a
	// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
	// with matching `us` or `eu` location value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCustomClassRequest) Reset() {
	*x = DeleteCustomClassRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCustomClassRequest) ProtoMessage() {}

func (x *DeleteCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCustomClassRequest.ProtoReflect.Descriptor instead.
func (*DeleteCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteCustomClassRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_speech_v1_cloud_speech_adaptation_proto protoreflect.FileDescriptor

var file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc9, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x0a,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x22, 0x9c, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x0a, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x52, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x83, 0x01, 0x0a,
	0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0a,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x55, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x18, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x22, 0xa4, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x56, 0x0a, 0x15, 0x47, 0x65,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x99, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f,
	0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0e,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x59, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x8e, 0x0f, 0x0a, 0x0a,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc1, 0x01, 0x0a, 0x0f, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65,
	0x74, 0x22, 0x5b, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x2c, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x01, 0x2a, 0x22, 0x2e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x9d,
	0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x22,
	0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xad,
	0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74,
	0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0xcc,
	0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53,
	0x65, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x74, 0x22, 0x66, 0xda, 0x41, 0x16, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x0a, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x01,
	0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65,
	0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x62, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x2c, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0xa6, 0x01, 0x0a, 0x0e, 0x47, 0x65,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xbc, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65,
	0x73, 0x12, 0xdb, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x6f,
	0xda, 0x41, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4e, 0x3a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x32,
	0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x9f, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x72, 0x0a, 0x1a,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x15, 0x53, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x70, 0x62, 0x3b, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x03, 0x47, 0x43, 0x53,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescOnce sync.Once
	file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescData = file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDesc
)

func file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescGZIP() []byte {
	file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescOnce.Do(func() {
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescData)
	})
	return file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDescData
}

var file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_speech_v1_cloud_speech_adaptation_proto_goTypes = []interface{}{
	(*CreatePhraseSetRequest)(nil),    // 0: google.cloud.speech.v1.CreatePhraseSetRequest
	(*UpdatePhraseSetRequest)(nil),    // 1: google.cloud.speech.v1.UpdatePhraseSetRequest
	(*GetPhraseSetRequest)(nil),       // 2: google.cloud.speech.v1.GetPhraseSetRequest
	(*ListPhraseSetRequest)(nil),      // 3: google.cloud.speech.v1.ListPhraseSetRequest
	(*ListPhraseSetResponse)(nil),     // 4: google.cloud.speech.v1.ListPhraseSetResponse
	(*DeletePhraseSetRequest)(nil),    // 5: google.cloud.speech.v1.DeletePhraseSetRequest
	(*CreateCustomClassRequest)(nil),  // 6: google.cloud.speech.v1.CreateCustomClassRequest
	(*UpdateCustomClassRequest)(nil),  // 7: google.cloud.speech.v1.UpdateCustomClassRequest
	(*GetCustomClassRequest)(nil),     // 8: google.cloud.speech.v1.GetCustomClassRequest
	(*ListCustomClassesRequest)(nil),  // 9: google.cloud.speech.v1.ListCustomClassesRequest
	(*ListCustomClassesResponse)(nil), // 10: google.cloud.speech.v1.ListCustomClassesResponse
	(*DeleteCustomClassRequest)(nil),  // 11: google.cloud.speech.v1.DeleteCustomClassRequest
	(*PhraseSet)(nil),                 // 12: google.cloud.speech.v1.PhraseSet
	(*fieldmaskpb.FieldMask)(nil),     // 13: google.protobuf.FieldMask
	(*CustomClass)(nil),               // 14: google.cloud.speech.v1.CustomClass
	(*emptypb.Empty)(nil),             // 15: google.protobuf.Empty
}
var file_google_cloud_speech_v1_cloud_speech_adaptation_proto_depIdxs = []int32{
	12, // 0: google.cloud.speech.v1.CreatePhraseSetRequest.phrase_set:type_name -> google.cloud.speech.v1.PhraseSet
	12, // 1: google.cloud.speech.v1.UpdatePhraseSetRequest.phrase_set:type_name -> google.cloud.speech.v1.PhraseSet
	13, // 2: google.cloud.speech.v1.UpdatePhraseSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 3: google.cloud.speech.v1.ListPhraseSetResponse.phrase_sets:type_name -> google.cloud.speech.v1.PhraseSet
	14, // 4: google.cloud.speech.v1.CreateCustomClassRequest.custom_class:type_name -> google.cloud.speech.v1.CustomClass
	14, // 5: google.cloud.speech.v1.UpdateCustomClassRequest.custom_class:type_name -> google.cloud.speech.v1.CustomClass
	13, // 6: google.cloud.speech.v1.UpdateCustomClassRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 7: google.cloud.speech.v1.ListCustomClassesResponse.custom_classes:type_name -> google.cloud.speech.v1.CustomClass
	0,  // 8: google.cloud.speech.v1.Adaptation.CreatePhraseSet:input_type -> google.cloud.speech.v1.CreatePhraseSetRequest
	2,  // 9: google.cloud.speech.v1.Adaptation.GetPhraseSet:input_type -> google.cloud.speech.v1.GetPhraseSetRequest
	3,  // 10: google.cloud.speech.v1.Adaptation.ListPhraseSet:input_type -> google.cloud.speech.v1.ListPhraseSetRequest
	1,  // 11: google.cloud.speech.v1.Adaptation.UpdatePhraseSet:input_type -> google.cloud.speech.v1.UpdatePhraseSetRequest
	5,  // 12: google.cloud.speech.v1.Adaptation.DeletePhraseSet:input_type -> google.cloud.speech.v1.DeletePhraseSetRequest
	6,  // 13: google.cloud.speech.v1.Adaptation.CreateCustomClass:input_type -> google.cloud.speech.v1.CreateCustomClassRequest
	8,  // 14: google.cloud.speech.v1.Adaptation.GetCustomClass:input_type -> google.cloud.speech.v1.GetCustomClassRequest
	9,  // 15: google.cloud.speech.v1.Adaptation.ListCustomClasses:input_type -> google.cloud.speech.v1.ListCustomClassesRequest
	7,  // 16: google.cloud.speech.v1.Adaptation.UpdateCustomClass:input_type -> google.cloud.speech.v1.UpdateCustomClassRequest
	11, // 17: google.cloud.speech.v1.Adaptation.DeleteCustomClass:input_type -> google.cloud.speech.v1.DeleteCustomClassRequest
	12, // 18: google.cloud.speech.v1.Adaptation.CreatePhraseSet:output_type -> google.cloud.speech.v1.PhraseSet
	12, // 19: google.cloud.speech.v1.Adaptation.GetPhraseSet:output_type -> google.cloud.speech.v1.PhraseSet
	4,  // 20: google.cloud.speech.v1.Adaptation.ListPhraseSet:output_type -> google.cloud.speech.v1.ListPhraseSetResponse
	12, // 21: google.cloud.speech.v1.Adaptation.UpdatePhraseSet:output_type -> google.cloud.speech.v1.PhraseSet
	15, // 22: google.cloud.speech.v1.Adaptation.DeletePhraseSet:output_type -> google.protobuf.Empty
	14, // 23: google.cloud.speech.v1.Adaptation.CreateCustomClass:output_type -> google.cloud.speech.v1.CustomClass
	14, // 24: google.cloud.speech.v1.Adaptation.GetCustomClass:output_type -> google.cloud.speech.v1.CustomClass
	10, // 25: google.cloud.speech.v1.Adaptation.ListCustomClasses:output_type -> google.cloud.speech.v1.ListCustomClassesResponse
	14, // 26: google.cloud.speech.v1.Adaptation.UpdateCustomClass:output_type -> google.cloud.speech.v1.CustomClass
	15, // 27: google.cloud.speech.v1.Adaptation.DeleteCustomClass:output_type -> google.protobuf.Empty
	18, // [18:28] is the sub-list for method output_type
	8,  // [8:18] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_speech_v1_cloud_speech_adaptation_proto_init() }
func file_google_cloud_speech_v1_cloud_speech_adaptation_proto_init() {
	if File_google_cloud_speech_v1_cloud_speech_adaptation_proto != nil {
		return
	}
	file_google_cloud_speech_v1_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePhraseSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePhraseSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPhraseSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPhraseSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPhraseSetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePhraseSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomClassRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomClassRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomClassRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomClassesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomClassesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCustomClassRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_speech_v1_cloud_speech_adaptation_proto_goTypes,
		DependencyIndexes: file_google_cloud_speech_v1_cloud_speech_adaptation_proto_depIdxs,
		MessageInfos:      file_google_cloud_speech_v1_cloud_speech_adaptation_proto_msgTypes,
	}.Build()
	File_google_cloud_speech_v1_cloud_speech_adaptation_proto = out.File
	file_google_cloud_speech_v1_cloud_speech_adaptation_proto_rawDesc = nil
	file_google_cloud_speech_v1_cloud_speech_adaptation_proto_goTypes = nil
	file_google_cloud_speech_v1_cloud_speech_adaptation_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AdaptationClient is the client API for Adaptation service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdaptationClient interface {
	// Create a set of phrase hints. Each item in the set can be a single word or
	// a multi-word phrase. The items in the PhraseSet are favored by the
	// recognition model when you send a call that includes the PhraseSet.
	CreatePhraseSet(ctx context.Context, in *CreatePhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error)
	// Get a phrase set.
	GetPhraseSet(ctx context.Context, in *GetPhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error)
	// List phrase sets.
	ListPhraseSet(ctx context.Context, in *ListPhraseSetRequest, opts ...grpc.CallOption) (*ListPhraseSetResponse, error)
	// Update a phrase set.
	UpdatePhraseSet(ctx context.Context, in *UpdatePhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error)
	// Delete a phrase set.
	DeletePhraseSet(ctx context.Context, in *DeletePhraseSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a custom class.
	CreateCustomClass(ctx context.Context, in *CreateCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error)
	// Get a custom class.
	GetCustomClass(ctx context.Context, in *GetCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error)
	// List custom classes.
	ListCustomClasses(ctx context.Context, in *ListCustomClassesRequest, opts ...grpc.CallOption) (*ListCustomClassesResponse, error)
	// Update a custom class.
	UpdateCustomClass(ctx context.Context, in *UpdateCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error)
	// Delete a custom class.
	DeleteCustomClass(ctx context.Context, in *DeleteCustomClassRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type adaptationClient struct {
	cc grpc.ClientConnInterface
}

func NewAdaptationClient(cc grpc.ClientConnInterface) AdaptationClient {
	return &adaptationClient{cc}
}

func (c *adaptationClient) CreatePhraseSet(ctx context.Context, in *CreatePhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error) {
	out := new(PhraseSet)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/CreatePhraseSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) GetPhraseSet(ctx context.Context, in *GetPhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error) {
	out := new(PhraseSet)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/GetPhraseSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) ListPhraseSet(ctx context.Context, in *ListPhraseSetRequest, opts ...grpc.CallOption) (*ListPhraseSetResponse, error) {
	out := new(ListPhraseSetResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/ListPhraseSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) UpdatePhraseSet(ctx context.Context, in *UpdatePhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error) {
	out := new(PhraseSet)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/UpdatePhraseSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) DeletePhraseSet(ctx context.Context, in *DeletePhraseSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/DeletePhraseSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) CreateCustomClass(ctx context.Context, in *CreateCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error) {
	out := new(CustomClass)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/CreateCustomClass", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) GetCustomClass(ctx context.Context, in *GetCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error) {
	out := new(CustomClass)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/GetCustomClass", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) ListCustomClasses(ctx context.Context, in *ListCustomClassesRequest, opts ...grpc.CallOption) (*ListCustomClassesResponse, error) {
	out := new(ListCustomClassesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/ListCustomClasses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) UpdateCustomClass(ctx context.Context, in *UpdateCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error) {
	out := new(CustomClass)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/UpdateCustomClass", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adaptationClient) DeleteCustomClass(ctx context.Context, in *DeleteCustomClassRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Adaptation/DeleteCustomClass", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdaptationServer is the server API for Adaptation service.
type AdaptationServer interface {
	// Create a set of phrase hints. Each item in the set can be a single word or
	// a multi-word phrase. The items in the PhraseSet are favored by the
	// recognition model when you send a call that includes the PhraseSet.
	CreatePhraseSet(context.Context, *CreatePhraseSetRequest) (*PhraseSet, error)
	// Get a phrase set.
	GetPhraseSet(context.Context, *GetPhraseSetRequest) (*PhraseSet, error)
	// List phrase sets.
	ListPhraseSet(context.Context, *ListPhraseSetRequest) (*ListPhraseSetResponse, error)
	// Update a phrase set.
	UpdatePhraseSet(context.Context, *UpdatePhraseSetRequest) (*PhraseSet, error)
	// Delete a phrase set.
	DeletePhraseSet(context.Context, *DeletePhraseSetRequest) (*emptypb.Empty, error)
	// Create a custom class.
	CreateCustomClass(context.Context, *CreateCustomClassRequest) (*CustomClass, error)
	// Get a custom class.
	GetCustomClass(context.Context, *GetCustomClassRequest) (*CustomClass, error)
	// List custom classes.
	ListCustomClasses(context.Context, *ListCustomClassesRequest) (*ListCustomClassesResponse, error)
	// Update a custom class.
	UpdateCustomClass(context.Context, *UpdateCustomClassRequest) (*CustomClass, error)
	// Delete a custom class.
	DeleteCustomClass(context.Context, *DeleteCustomClassRequest) (*emptypb.Empty, error)
}

// UnimplementedAdaptationServer can be embedded to have forward compatible implementations.
type UnimplementedAdaptationServer struct {
}

func (*UnimplementedAdaptationServer) CreatePhraseSet(context.Context, *CreatePhraseSetRequest) (*PhraseSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePhraseSet not implemented")
}
func (*UnimplementedAdaptationServer) GetPhraseSet(context.Context, *GetPhraseSetRequest) (*PhraseSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPhraseSet not implemented")
}
func (*UnimplementedAdaptationServer) ListPhraseSet(context.Context, *ListPhraseSetRequest) (*ListPhraseSetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPhraseSet not implemented")
}
func (*UnimplementedAdaptationServer) UpdatePhraseSet(context.Context, *UpdatePhraseSetRequest) (*PhraseSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePhraseSet not implemented")
}
func (*UnimplementedAdaptationServer) DeletePhraseSet(context.Context, *DeletePhraseSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePhraseSet not implemented")
}
func (*UnimplementedAdaptationServer) CreateCustomClass(context.Context, *CreateCustomClassRequest) (*CustomClass, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomClass not implemented")
}
func (*UnimplementedAdaptationServer) GetCustomClass(context.Context, *GetCustomClassRequest) (*CustomClass, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomClass not implemented")
}
func (*UnimplementedAdaptationServer) ListCustomClasses(context.Context, *ListCustomClassesRequest) (*ListCustomClassesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomClasses not implemented")
}
func (*UnimplementedAdaptationServer) UpdateCustomClass(context.Context, *UpdateCustomClassRequest) (*CustomClass, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomClass not implemented")
}
func (*UnimplementedAdaptationServer) DeleteCustomClass(context.Context, *DeleteCustomClassRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomClass not implemented")
}

func RegisterAdaptationServer(s *grpc.Server, srv AdaptationServer) {
	s.RegisterService(&_Adaptation_serviceDesc, srv)
}

func _Adaptation_CreatePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).CreatePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/CreatePhraseSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).CreatePhraseSet(ctx, req.(*CreatePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_GetPhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).GetPhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/GetPhraseSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).GetPhraseSet(ctx, req.(*GetPhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_ListPhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).ListPhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/ListPhraseSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).ListPhraseSet(ctx, req.(*ListPhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_UpdatePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).UpdatePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/UpdatePhraseSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).UpdatePhraseSet(ctx, req.(*UpdatePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_DeletePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).DeletePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/DeletePhraseSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).DeletePhraseSet(ctx, req.(*DeletePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_CreateCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).CreateCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/CreateCustomClass",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).CreateCustomClass(ctx, req.(*CreateCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_GetCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).GetCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/GetCustomClass",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).GetCustomClass(ctx, req.(*GetCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_ListCustomClasses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomClassesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).ListCustomClasses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/ListCustomClasses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).ListCustomClasses(ctx, req.(*ListCustomClassesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_UpdateCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).UpdateCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/UpdateCustomClass",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).UpdateCustomClass(ctx, req.(*UpdateCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adaptation_DeleteCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdaptationServer).DeleteCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Adaptation/DeleteCustomClass",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdaptationServer).DeleteCustomClass(ctx, req.(*DeleteCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Adaptation_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v1.Adaptation",
	HandlerType: (*AdaptationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePhraseSet",
			Handler:    _Adaptation_CreatePhraseSet_Handler,
		},
		{
			MethodName: "GetPhraseSet",
			Handler:    _Adaptation_GetPhraseSet_Handler,
		},
		{
			MethodName: "ListPhraseSet",
			Handler:    _Adaptation_ListPhraseSet_Handler,
		},
		{
			MethodName: "UpdatePhraseSet",
			Handler:    _Adaptation_UpdatePhraseSet_Handler,
		},
		{
			MethodName: "DeletePhraseSet",
			Handler:    _Adaptation_DeletePhraseSet_Handler,
		},
		{
			MethodName: "CreateCustomClass",
			Handler:    _Adaptation_CreateCustomClass_Handler,
		},
		{
			MethodName: "GetCustomClass",
			Handler:    _Adaptation_GetCustomClass_Handler,
		},
		{
			MethodName: "ListCustomClasses",
			Handler:    _Adaptation_ListCustomClasses_Handler,
		},
		{
			MethodName: "UpdateCustomClass",
			Handler:    _Adaptation_UpdateCustomClass_Handler,
		},
		{
			MethodName: "DeleteCustomClass",
			Handler:    _Adaptation_DeleteCustomClass_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/speech/v1/cloud_speech_adaptation.proto",
}
