// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/netapp/v1/cloud_netapp_service.proto

package netapppb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been canceled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_netapp_v1_cloud_netapp_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_cloud_netapp_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDescGZIP(), []int{0}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

var File_google_cloud_netapp_v1_cloud_netapp_service_proto protoreflect.FileDescriptor

var file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x6b, 0x6d, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a,
	0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0xf3, 0x3b, 0x0a, 0x06,
	0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x12, 0xb8, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x12, 0xf6, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x0e, 0x47,
	0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xf8, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0xca, 0x41, 0x20, 0x0a,
	0x0b, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x18, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d,
	0x3a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x32, 0x3d,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01,
	0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xa4, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x09, 0x47, 0x65,
	0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d,
	0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcf, 0x01,
	0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x1b, 0x0a,
	0x06, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2c, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12,
	0xd1, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41,
	0x1b, 0x0a, 0x06, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x32,
	0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x67, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb7, 0x01, 0x0a, 0x0c, 0x52, 0x65,
	0x76, 0x65, 0x72, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x65, 0x72, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5b, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22,
	0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x76,
	0x65, 0x72, 0x74, 0x12, 0xb6, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x48, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0xa3, 0x01, 0x0a,
	0x0b, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x08, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0xd3, 0x01,
	0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73,
	0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x14, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x32, 0x40,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xcc, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12,
	0xb6, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x93, 0x02, 0x0a, 0x15, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0xca, 0x41, 0x24, 0x0a, 0x0f, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x2b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2c, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x95,
	0x02, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa6, 0x01,
	0xca, 0x41, 0x24, 0x0a, 0x0f, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1c, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x10, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x32, 0x46,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73,
	0x74, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xe8, 0x01, 0x0a, 0x0f,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4b,
	0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85,
	0x01, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6b, 0x6d, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x6b, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x0a, 0x6b, 0x6d, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6b, 0x6d, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x9d, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x4b, 0x6d,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x6d,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x1e, 0x0a,
	0x09, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x16,
	0x6b, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x0a, 0x6b, 0x6d,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6b,
	0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x62, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x4b, 0x6d, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a,
	0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x12, 0xb4, 0x01, 0x0a, 0x0f, 0x56, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4b, 0x6d, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4b, 0x6d, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x6d, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12,
	0xcc, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x6a, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2,
	0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfd, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x01, 0xca,
	0x41, 0x20, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x0b, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xdc, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x76, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xff, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0xca, 0x41,
	0x20, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x17, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x55, 0x3a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x46,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcf, 0x01, 0x0a, 0x0f, 0x53, 0x74, 0x6f, 0x70, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xca, 0x41, 0x20, 0x0a, 0x0b,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70, 0x12, 0xd5, 0x01, 0x0a, 0x11, 0x52, 0x65, 0x73,
	0x75, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x6f, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x12, 0xf3, 0x01, 0x0a, 0x1b, 0x52, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x65, 0x72, 0x73,
	0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x79, 0xca, 0x41, 0x20,
	0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x01, 0x2a, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0x8a, 0x02, 0xea, 0x41, 0x4e, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76,
	0x31, 0x42, 0x17, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x4e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x70, 0x62,
	0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDescOnce sync.Once
	file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDescData = file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDesc
)

func file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDescGZIP() []byte {
	file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDescData)
	})
	return file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDescData
}

var file_google_cloud_netapp_v1_cloud_netapp_service_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_netapp_v1_cloud_netapp_service_proto_goTypes = []interface{}{
	(*OperationMetadata)(nil),                  // 0: google.cloud.netapp.v1.OperationMetadata
	(*timestamppb.Timestamp)(nil),              // 1: google.protobuf.Timestamp
	(*ListStoragePoolsRequest)(nil),            // 2: google.cloud.netapp.v1.ListStoragePoolsRequest
	(*CreateStoragePoolRequest)(nil),           // 3: google.cloud.netapp.v1.CreateStoragePoolRequest
	(*GetStoragePoolRequest)(nil),              // 4: google.cloud.netapp.v1.GetStoragePoolRequest
	(*UpdateStoragePoolRequest)(nil),           // 5: google.cloud.netapp.v1.UpdateStoragePoolRequest
	(*DeleteStoragePoolRequest)(nil),           // 6: google.cloud.netapp.v1.DeleteStoragePoolRequest
	(*ListVolumesRequest)(nil),                 // 7: google.cloud.netapp.v1.ListVolumesRequest
	(*GetVolumeRequest)(nil),                   // 8: google.cloud.netapp.v1.GetVolumeRequest
	(*CreateVolumeRequest)(nil),                // 9: google.cloud.netapp.v1.CreateVolumeRequest
	(*UpdateVolumeRequest)(nil),                // 10: google.cloud.netapp.v1.UpdateVolumeRequest
	(*DeleteVolumeRequest)(nil),                // 11: google.cloud.netapp.v1.DeleteVolumeRequest
	(*RevertVolumeRequest)(nil),                // 12: google.cloud.netapp.v1.RevertVolumeRequest
	(*ListSnapshotsRequest)(nil),               // 13: google.cloud.netapp.v1.ListSnapshotsRequest
	(*GetSnapshotRequest)(nil),                 // 14: google.cloud.netapp.v1.GetSnapshotRequest
	(*CreateSnapshotRequest)(nil),              // 15: google.cloud.netapp.v1.CreateSnapshotRequest
	(*DeleteSnapshotRequest)(nil),              // 16: google.cloud.netapp.v1.DeleteSnapshotRequest
	(*UpdateSnapshotRequest)(nil),              // 17: google.cloud.netapp.v1.UpdateSnapshotRequest
	(*ListActiveDirectoriesRequest)(nil),       // 18: google.cloud.netapp.v1.ListActiveDirectoriesRequest
	(*GetActiveDirectoryRequest)(nil),          // 19: google.cloud.netapp.v1.GetActiveDirectoryRequest
	(*CreateActiveDirectoryRequest)(nil),       // 20: google.cloud.netapp.v1.CreateActiveDirectoryRequest
	(*UpdateActiveDirectoryRequest)(nil),       // 21: google.cloud.netapp.v1.UpdateActiveDirectoryRequest
	(*DeleteActiveDirectoryRequest)(nil),       // 22: google.cloud.netapp.v1.DeleteActiveDirectoryRequest
	(*ListKmsConfigsRequest)(nil),              // 23: google.cloud.netapp.v1.ListKmsConfigsRequest
	(*CreateKmsConfigRequest)(nil),             // 24: google.cloud.netapp.v1.CreateKmsConfigRequest
	(*GetKmsConfigRequest)(nil),                // 25: google.cloud.netapp.v1.GetKmsConfigRequest
	(*UpdateKmsConfigRequest)(nil),             // 26: google.cloud.netapp.v1.UpdateKmsConfigRequest
	(*EncryptVolumesRequest)(nil),              // 27: google.cloud.netapp.v1.EncryptVolumesRequest
	(*VerifyKmsConfigRequest)(nil),             // 28: google.cloud.netapp.v1.VerifyKmsConfigRequest
	(*DeleteKmsConfigRequest)(nil),             // 29: google.cloud.netapp.v1.DeleteKmsConfigRequest
	(*ListReplicationsRequest)(nil),            // 30: google.cloud.netapp.v1.ListReplicationsRequest
	(*GetReplicationRequest)(nil),              // 31: google.cloud.netapp.v1.GetReplicationRequest
	(*CreateReplicationRequest)(nil),           // 32: google.cloud.netapp.v1.CreateReplicationRequest
	(*DeleteReplicationRequest)(nil),           // 33: google.cloud.netapp.v1.DeleteReplicationRequest
	(*UpdateReplicationRequest)(nil),           // 34: google.cloud.netapp.v1.UpdateReplicationRequest
	(*StopReplicationRequest)(nil),             // 35: google.cloud.netapp.v1.StopReplicationRequest
	(*ResumeReplicationRequest)(nil),           // 36: google.cloud.netapp.v1.ResumeReplicationRequest
	(*ReverseReplicationDirectionRequest)(nil), // 37: google.cloud.netapp.v1.ReverseReplicationDirectionRequest
	(*ListStoragePoolsResponse)(nil),           // 38: google.cloud.netapp.v1.ListStoragePoolsResponse
	(*longrunningpb.Operation)(nil),            // 39: google.longrunning.Operation
	(*StoragePool)(nil),                        // 40: google.cloud.netapp.v1.StoragePool
	(*ListVolumesResponse)(nil),                // 41: google.cloud.netapp.v1.ListVolumesResponse
	(*Volume)(nil),                             // 42: google.cloud.netapp.v1.Volume
	(*ListSnapshotsResponse)(nil),              // 43: google.cloud.netapp.v1.ListSnapshotsResponse
	(*Snapshot)(nil),                           // 44: google.cloud.netapp.v1.Snapshot
	(*ListActiveDirectoriesResponse)(nil),      // 45: google.cloud.netapp.v1.ListActiveDirectoriesResponse
	(*ActiveDirectory)(nil),                    // 46: google.cloud.netapp.v1.ActiveDirectory
	(*ListKmsConfigsResponse)(nil),             // 47: google.cloud.netapp.v1.ListKmsConfigsResponse
	(*KmsConfig)(nil),                          // 48: google.cloud.netapp.v1.KmsConfig
	(*VerifyKmsConfigResponse)(nil),            // 49: google.cloud.netapp.v1.VerifyKmsConfigResponse
	(*ListReplicationsResponse)(nil),           // 50: google.cloud.netapp.v1.ListReplicationsResponse
	(*Replication)(nil),                        // 51: google.cloud.netapp.v1.Replication
}
var file_google_cloud_netapp_v1_cloud_netapp_service_proto_depIdxs = []int32{
	1,  // 0: google.cloud.netapp.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	1,  // 1: google.cloud.netapp.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	2,  // 2: google.cloud.netapp.v1.NetApp.ListStoragePools:input_type -> google.cloud.netapp.v1.ListStoragePoolsRequest
	3,  // 3: google.cloud.netapp.v1.NetApp.CreateStoragePool:input_type -> google.cloud.netapp.v1.CreateStoragePoolRequest
	4,  // 4: google.cloud.netapp.v1.NetApp.GetStoragePool:input_type -> google.cloud.netapp.v1.GetStoragePoolRequest
	5,  // 5: google.cloud.netapp.v1.NetApp.UpdateStoragePool:input_type -> google.cloud.netapp.v1.UpdateStoragePoolRequest
	6,  // 6: google.cloud.netapp.v1.NetApp.DeleteStoragePool:input_type -> google.cloud.netapp.v1.DeleteStoragePoolRequest
	7,  // 7: google.cloud.netapp.v1.NetApp.ListVolumes:input_type -> google.cloud.netapp.v1.ListVolumesRequest
	8,  // 8: google.cloud.netapp.v1.NetApp.GetVolume:input_type -> google.cloud.netapp.v1.GetVolumeRequest
	9,  // 9: google.cloud.netapp.v1.NetApp.CreateVolume:input_type -> google.cloud.netapp.v1.CreateVolumeRequest
	10, // 10: google.cloud.netapp.v1.NetApp.UpdateVolume:input_type -> google.cloud.netapp.v1.UpdateVolumeRequest
	11, // 11: google.cloud.netapp.v1.NetApp.DeleteVolume:input_type -> google.cloud.netapp.v1.DeleteVolumeRequest
	12, // 12: google.cloud.netapp.v1.NetApp.RevertVolume:input_type -> google.cloud.netapp.v1.RevertVolumeRequest
	13, // 13: google.cloud.netapp.v1.NetApp.ListSnapshots:input_type -> google.cloud.netapp.v1.ListSnapshotsRequest
	14, // 14: google.cloud.netapp.v1.NetApp.GetSnapshot:input_type -> google.cloud.netapp.v1.GetSnapshotRequest
	15, // 15: google.cloud.netapp.v1.NetApp.CreateSnapshot:input_type -> google.cloud.netapp.v1.CreateSnapshotRequest
	16, // 16: google.cloud.netapp.v1.NetApp.DeleteSnapshot:input_type -> google.cloud.netapp.v1.DeleteSnapshotRequest
	17, // 17: google.cloud.netapp.v1.NetApp.UpdateSnapshot:input_type -> google.cloud.netapp.v1.UpdateSnapshotRequest
	18, // 18: google.cloud.netapp.v1.NetApp.ListActiveDirectories:input_type -> google.cloud.netapp.v1.ListActiveDirectoriesRequest
	19, // 19: google.cloud.netapp.v1.NetApp.GetActiveDirectory:input_type -> google.cloud.netapp.v1.GetActiveDirectoryRequest
	20, // 20: google.cloud.netapp.v1.NetApp.CreateActiveDirectory:input_type -> google.cloud.netapp.v1.CreateActiveDirectoryRequest
	21, // 21: google.cloud.netapp.v1.NetApp.UpdateActiveDirectory:input_type -> google.cloud.netapp.v1.UpdateActiveDirectoryRequest
	22, // 22: google.cloud.netapp.v1.NetApp.DeleteActiveDirectory:input_type -> google.cloud.netapp.v1.DeleteActiveDirectoryRequest
	23, // 23: google.cloud.netapp.v1.NetApp.ListKmsConfigs:input_type -> google.cloud.netapp.v1.ListKmsConfigsRequest
	24, // 24: google.cloud.netapp.v1.NetApp.CreateKmsConfig:input_type -> google.cloud.netapp.v1.CreateKmsConfigRequest
	25, // 25: google.cloud.netapp.v1.NetApp.GetKmsConfig:input_type -> google.cloud.netapp.v1.GetKmsConfigRequest
	26, // 26: google.cloud.netapp.v1.NetApp.UpdateKmsConfig:input_type -> google.cloud.netapp.v1.UpdateKmsConfigRequest
	27, // 27: google.cloud.netapp.v1.NetApp.EncryptVolumes:input_type -> google.cloud.netapp.v1.EncryptVolumesRequest
	28, // 28: google.cloud.netapp.v1.NetApp.VerifyKmsConfig:input_type -> google.cloud.netapp.v1.VerifyKmsConfigRequest
	29, // 29: google.cloud.netapp.v1.NetApp.DeleteKmsConfig:input_type -> google.cloud.netapp.v1.DeleteKmsConfigRequest
	30, // 30: google.cloud.netapp.v1.NetApp.ListReplications:input_type -> google.cloud.netapp.v1.ListReplicationsRequest
	31, // 31: google.cloud.netapp.v1.NetApp.GetReplication:input_type -> google.cloud.netapp.v1.GetReplicationRequest
	32, // 32: google.cloud.netapp.v1.NetApp.CreateReplication:input_type -> google.cloud.netapp.v1.CreateReplicationRequest
	33, // 33: google.cloud.netapp.v1.NetApp.DeleteReplication:input_type -> google.cloud.netapp.v1.DeleteReplicationRequest
	34, // 34: google.cloud.netapp.v1.NetApp.UpdateReplication:input_type -> google.cloud.netapp.v1.UpdateReplicationRequest
	35, // 35: google.cloud.netapp.v1.NetApp.StopReplication:input_type -> google.cloud.netapp.v1.StopReplicationRequest
	36, // 36: google.cloud.netapp.v1.NetApp.ResumeReplication:input_type -> google.cloud.netapp.v1.ResumeReplicationRequest
	37, // 37: google.cloud.netapp.v1.NetApp.ReverseReplicationDirection:input_type -> google.cloud.netapp.v1.ReverseReplicationDirectionRequest
	38, // 38: google.cloud.netapp.v1.NetApp.ListStoragePools:output_type -> google.cloud.netapp.v1.ListStoragePoolsResponse
	39, // 39: google.cloud.netapp.v1.NetApp.CreateStoragePool:output_type -> google.longrunning.Operation
	40, // 40: google.cloud.netapp.v1.NetApp.GetStoragePool:output_type -> google.cloud.netapp.v1.StoragePool
	39, // 41: google.cloud.netapp.v1.NetApp.UpdateStoragePool:output_type -> google.longrunning.Operation
	39, // 42: google.cloud.netapp.v1.NetApp.DeleteStoragePool:output_type -> google.longrunning.Operation
	41, // 43: google.cloud.netapp.v1.NetApp.ListVolumes:output_type -> google.cloud.netapp.v1.ListVolumesResponse
	42, // 44: google.cloud.netapp.v1.NetApp.GetVolume:output_type -> google.cloud.netapp.v1.Volume
	39, // 45: google.cloud.netapp.v1.NetApp.CreateVolume:output_type -> google.longrunning.Operation
	39, // 46: google.cloud.netapp.v1.NetApp.UpdateVolume:output_type -> google.longrunning.Operation
	39, // 47: google.cloud.netapp.v1.NetApp.DeleteVolume:output_type -> google.longrunning.Operation
	39, // 48: google.cloud.netapp.v1.NetApp.RevertVolume:output_type -> google.longrunning.Operation
	43, // 49: google.cloud.netapp.v1.NetApp.ListSnapshots:output_type -> google.cloud.netapp.v1.ListSnapshotsResponse
	44, // 50: google.cloud.netapp.v1.NetApp.GetSnapshot:output_type -> google.cloud.netapp.v1.Snapshot
	39, // 51: google.cloud.netapp.v1.NetApp.CreateSnapshot:output_type -> google.longrunning.Operation
	39, // 52: google.cloud.netapp.v1.NetApp.DeleteSnapshot:output_type -> google.longrunning.Operation
	39, // 53: google.cloud.netapp.v1.NetApp.UpdateSnapshot:output_type -> google.longrunning.Operation
	45, // 54: google.cloud.netapp.v1.NetApp.ListActiveDirectories:output_type -> google.cloud.netapp.v1.ListActiveDirectoriesResponse
	46, // 55: google.cloud.netapp.v1.NetApp.GetActiveDirectory:output_type -> google.cloud.netapp.v1.ActiveDirectory
	39, // 56: google.cloud.netapp.v1.NetApp.CreateActiveDirectory:output_type -> google.longrunning.Operation
	39, // 57: google.cloud.netapp.v1.NetApp.UpdateActiveDirectory:output_type -> google.longrunning.Operation
	39, // 58: google.cloud.netapp.v1.NetApp.DeleteActiveDirectory:output_type -> google.longrunning.Operation
	47, // 59: google.cloud.netapp.v1.NetApp.ListKmsConfigs:output_type -> google.cloud.netapp.v1.ListKmsConfigsResponse
	39, // 60: google.cloud.netapp.v1.NetApp.CreateKmsConfig:output_type -> google.longrunning.Operation
	48, // 61: google.cloud.netapp.v1.NetApp.GetKmsConfig:output_type -> google.cloud.netapp.v1.KmsConfig
	39, // 62: google.cloud.netapp.v1.NetApp.UpdateKmsConfig:output_type -> google.longrunning.Operation
	39, // 63: google.cloud.netapp.v1.NetApp.EncryptVolumes:output_type -> google.longrunning.Operation
	49, // 64: google.cloud.netapp.v1.NetApp.VerifyKmsConfig:output_type -> google.cloud.netapp.v1.VerifyKmsConfigResponse
	39, // 65: google.cloud.netapp.v1.NetApp.DeleteKmsConfig:output_type -> google.longrunning.Operation
	50, // 66: google.cloud.netapp.v1.NetApp.ListReplications:output_type -> google.cloud.netapp.v1.ListReplicationsResponse
	51, // 67: google.cloud.netapp.v1.NetApp.GetReplication:output_type -> google.cloud.netapp.v1.Replication
	39, // 68: google.cloud.netapp.v1.NetApp.CreateReplication:output_type -> google.longrunning.Operation
	39, // 69: google.cloud.netapp.v1.NetApp.DeleteReplication:output_type -> google.longrunning.Operation
	39, // 70: google.cloud.netapp.v1.NetApp.UpdateReplication:output_type -> google.longrunning.Operation
	39, // 71: google.cloud.netapp.v1.NetApp.StopReplication:output_type -> google.longrunning.Operation
	39, // 72: google.cloud.netapp.v1.NetApp.ResumeReplication:output_type -> google.longrunning.Operation
	39, // 73: google.cloud.netapp.v1.NetApp.ReverseReplicationDirection:output_type -> google.longrunning.Operation
	38, // [38:74] is the sub-list for method output_type
	2,  // [2:38] is the sub-list for method input_type
	2,  // [2:2] is the sub-list for extension type_name
	2,  // [2:2] is the sub-list for extension extendee
	0,  // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_netapp_v1_cloud_netapp_service_proto_init() }
func file_google_cloud_netapp_v1_cloud_netapp_service_proto_init() {
	if File_google_cloud_netapp_v1_cloud_netapp_service_proto != nil {
		return
	}
	file_google_cloud_netapp_v1_active_directory_proto_init()
	file_google_cloud_netapp_v1_kms_proto_init()
	file_google_cloud_netapp_v1_replication_proto_init()
	file_google_cloud_netapp_v1_snapshot_proto_init()
	file_google_cloud_netapp_v1_storage_pool_proto_init()
	file_google_cloud_netapp_v1_volume_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_netapp_v1_cloud_netapp_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_netapp_v1_cloud_netapp_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_netapp_v1_cloud_netapp_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_netapp_v1_cloud_netapp_service_proto_msgTypes,
	}.Build()
	File_google_cloud_netapp_v1_cloud_netapp_service_proto = out.File
	file_google_cloud_netapp_v1_cloud_netapp_service_proto_rawDesc = nil
	file_google_cloud_netapp_v1_cloud_netapp_service_proto_goTypes = nil
	file_google_cloud_netapp_v1_cloud_netapp_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NetAppClient is the client API for NetApp service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NetAppClient interface {
	// Returns descriptions of all storage pools owned by the caller.
	ListStoragePools(ctx context.Context, in *ListStoragePoolsRequest, opts ...grpc.CallOption) (*ListStoragePoolsResponse, error)
	// Creates a new storage pool.
	CreateStoragePool(ctx context.Context, in *CreateStoragePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the description of the specified storage pool by poolId.
	GetStoragePool(ctx context.Context, in *GetStoragePoolRequest, opts ...grpc.CallOption) (*StoragePool, error)
	// Updates the storage pool properties with the full spec
	UpdateStoragePool(ctx context.Context, in *UpdateStoragePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Warning! This operation will permanently delete the storage pool.
	DeleteStoragePool(ctx context.Context, in *DeleteStoragePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Volumes in a given project.
	ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error)
	// Gets details of a single Volume.
	GetVolume(ctx context.Context, in *GetVolumeRequest, opts ...grpc.CallOption) (*Volume, error)
	// Creates a new Volume in a given project and location.
	CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Volume.
	UpdateVolume(ctx context.Context, in *UpdateVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Volume.
	DeleteVolume(ctx context.Context, in *DeleteVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Revert an existing volume to a specified snapshot.
	// Warning! This operation will permanently revert all changes made after the
	// snapshot was created.
	RevertVolume(ctx context.Context, in *RevertVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns descriptions of all snapshots for a volume.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Describe a snapshot for a volume.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Create a new snapshot for a volume.
	CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a snapshot.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the settings of a specific snapshot.
	UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists active directories.
	ListActiveDirectories(ctx context.Context, in *ListActiveDirectoriesRequest, opts ...grpc.CallOption) (*ListActiveDirectoriesResponse, error)
	// Describes a specified active directory.
	GetActiveDirectory(ctx context.Context, in *GetActiveDirectoryRequest, opts ...grpc.CallOption) (*ActiveDirectory, error)
	// CreateActiveDirectory
	// Creates the active directory specified in the request.
	CreateActiveDirectory(ctx context.Context, in *CreateActiveDirectoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update the parameters of an active directories.
	UpdateActiveDirectory(ctx context.Context, in *UpdateActiveDirectoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete the active directory specified in the request.
	DeleteActiveDirectory(ctx context.Context, in *DeleteActiveDirectoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns descriptions of all KMS configs owned by the caller.
	ListKmsConfigs(ctx context.Context, in *ListKmsConfigsRequest, opts ...grpc.CallOption) (*ListKmsConfigsResponse, error)
	// Creates a new KMS config.
	CreateKmsConfig(ctx context.Context, in *CreateKmsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the description of the specified KMS config by kms_config_id.
	GetKmsConfig(ctx context.Context, in *GetKmsConfigRequest, opts ...grpc.CallOption) (*KmsConfig, error)
	// Updates the Kms config properties with the full spec
	UpdateKmsConfig(ctx context.Context, in *UpdateKmsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Encrypt the existing volumes without CMEK encryption with the desired the
	// KMS config for the whole region.
	EncryptVolumes(ctx context.Context, in *EncryptVolumesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Verifies KMS config reachability.
	VerifyKmsConfig(ctx context.Context, in *VerifyKmsConfigRequest, opts ...grpc.CallOption) (*VerifyKmsConfigResponse, error)
	// Warning! This operation will permanently delete the Kms config.
	DeleteKmsConfig(ctx context.Context, in *DeleteKmsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns descriptions of all replications for a volume.
	ListReplications(ctx context.Context, in *ListReplicationsRequest, opts ...grpc.CallOption) (*ListReplicationsResponse, error)
	// Describe a replication for a volume.
	GetReplication(ctx context.Context, in *GetReplicationRequest, opts ...grpc.CallOption) (*Replication, error)
	// Create a new replication for a volume.
	CreateReplication(ctx context.Context, in *CreateReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a replication.
	DeleteReplication(ctx context.Context, in *DeleteReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the settings of a specific replication.
	UpdateReplication(ctx context.Context, in *UpdateReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stop Cross Region Replication.
	StopReplication(ctx context.Context, in *StopReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resume Cross Region Replication.
	ResumeReplication(ctx context.Context, in *ResumeReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Reverses direction of replication. Source becomes destination and
	// destination becomes source.
	ReverseReplicationDirection(ctx context.Context, in *ReverseReplicationDirectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type netAppClient struct {
	cc grpc.ClientConnInterface
}

func NewNetAppClient(cc grpc.ClientConnInterface) NetAppClient {
	return &netAppClient{cc}
}

func (c *netAppClient) ListStoragePools(ctx context.Context, in *ListStoragePoolsRequest, opts ...grpc.CallOption) (*ListStoragePoolsResponse, error) {
	out := new(ListStoragePoolsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/ListStoragePools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) CreateStoragePool(ctx context.Context, in *CreateStoragePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/CreateStoragePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) GetStoragePool(ctx context.Context, in *GetStoragePoolRequest, opts ...grpc.CallOption) (*StoragePool, error) {
	out := new(StoragePool)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/GetStoragePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) UpdateStoragePool(ctx context.Context, in *UpdateStoragePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/UpdateStoragePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) DeleteStoragePool(ctx context.Context, in *DeleteStoragePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/DeleteStoragePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error) {
	out := new(ListVolumesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/ListVolumes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) GetVolume(ctx context.Context, in *GetVolumeRequest, opts ...grpc.CallOption) (*Volume, error) {
	out := new(Volume)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/GetVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/CreateVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) UpdateVolume(ctx context.Context, in *UpdateVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/UpdateVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) DeleteVolume(ctx context.Context, in *DeleteVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/DeleteVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) RevertVolume(ctx context.Context, in *RevertVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/RevertVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/ListSnapshots", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/GetSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/CreateSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/DeleteSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/UpdateSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) ListActiveDirectories(ctx context.Context, in *ListActiveDirectoriesRequest, opts ...grpc.CallOption) (*ListActiveDirectoriesResponse, error) {
	out := new(ListActiveDirectoriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/ListActiveDirectories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) GetActiveDirectory(ctx context.Context, in *GetActiveDirectoryRequest, opts ...grpc.CallOption) (*ActiveDirectory, error) {
	out := new(ActiveDirectory)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/GetActiveDirectory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) CreateActiveDirectory(ctx context.Context, in *CreateActiveDirectoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/CreateActiveDirectory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) UpdateActiveDirectory(ctx context.Context, in *UpdateActiveDirectoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/UpdateActiveDirectory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) DeleteActiveDirectory(ctx context.Context, in *DeleteActiveDirectoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/DeleteActiveDirectory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) ListKmsConfigs(ctx context.Context, in *ListKmsConfigsRequest, opts ...grpc.CallOption) (*ListKmsConfigsResponse, error) {
	out := new(ListKmsConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/ListKmsConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) CreateKmsConfig(ctx context.Context, in *CreateKmsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/CreateKmsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) GetKmsConfig(ctx context.Context, in *GetKmsConfigRequest, opts ...grpc.CallOption) (*KmsConfig, error) {
	out := new(KmsConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/GetKmsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) UpdateKmsConfig(ctx context.Context, in *UpdateKmsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/UpdateKmsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) EncryptVolumes(ctx context.Context, in *EncryptVolumesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/EncryptVolumes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) VerifyKmsConfig(ctx context.Context, in *VerifyKmsConfigRequest, opts ...grpc.CallOption) (*VerifyKmsConfigResponse, error) {
	out := new(VerifyKmsConfigResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/VerifyKmsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) DeleteKmsConfig(ctx context.Context, in *DeleteKmsConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/DeleteKmsConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) ListReplications(ctx context.Context, in *ListReplicationsRequest, opts ...grpc.CallOption) (*ListReplicationsResponse, error) {
	out := new(ListReplicationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/ListReplications", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) GetReplication(ctx context.Context, in *GetReplicationRequest, opts ...grpc.CallOption) (*Replication, error) {
	out := new(Replication)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/GetReplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) CreateReplication(ctx context.Context, in *CreateReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/CreateReplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) DeleteReplication(ctx context.Context, in *DeleteReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/DeleteReplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) UpdateReplication(ctx context.Context, in *UpdateReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/UpdateReplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) StopReplication(ctx context.Context, in *StopReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/StopReplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) ResumeReplication(ctx context.Context, in *ResumeReplicationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/ResumeReplication", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *netAppClient) ReverseReplicationDirection(ctx context.Context, in *ReverseReplicationDirectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.netapp.v1.NetApp/ReverseReplicationDirection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetAppServer is the server API for NetApp service.
type NetAppServer interface {
	// Returns descriptions of all storage pools owned by the caller.
	ListStoragePools(context.Context, *ListStoragePoolsRequest) (*ListStoragePoolsResponse, error)
	// Creates a new storage pool.
	CreateStoragePool(context.Context, *CreateStoragePoolRequest) (*longrunningpb.Operation, error)
	// Returns the description of the specified storage pool by poolId.
	GetStoragePool(context.Context, *GetStoragePoolRequest) (*StoragePool, error)
	// Updates the storage pool properties with the full spec
	UpdateStoragePool(context.Context, *UpdateStoragePoolRequest) (*longrunningpb.Operation, error)
	// Warning! This operation will permanently delete the storage pool.
	DeleteStoragePool(context.Context, *DeleteStoragePoolRequest) (*longrunningpb.Operation, error)
	// Lists Volumes in a given project.
	ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error)
	// Gets details of a single Volume.
	GetVolume(context.Context, *GetVolumeRequest) (*Volume, error)
	// Creates a new Volume in a given project and location.
	CreateVolume(context.Context, *CreateVolumeRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Volume.
	UpdateVolume(context.Context, *UpdateVolumeRequest) (*longrunningpb.Operation, error)
	// Deletes a single Volume.
	DeleteVolume(context.Context, *DeleteVolumeRequest) (*longrunningpb.Operation, error)
	// Revert an existing volume to a specified snapshot.
	// Warning! This operation will permanently revert all changes made after the
	// snapshot was created.
	RevertVolume(context.Context, *RevertVolumeRequest) (*longrunningpb.Operation, error)
	// Returns descriptions of all snapshots for a volume.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Describe a snapshot for a volume.
	GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Create a new snapshot for a volume.
	CreateSnapshot(context.Context, *CreateSnapshotRequest) (*longrunningpb.Operation, error)
	// Deletes a snapshot.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*longrunningpb.Operation, error)
	// Updates the settings of a specific snapshot.
	UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*longrunningpb.Operation, error)
	// Lists active directories.
	ListActiveDirectories(context.Context, *ListActiveDirectoriesRequest) (*ListActiveDirectoriesResponse, error)
	// Describes a specified active directory.
	GetActiveDirectory(context.Context, *GetActiveDirectoryRequest) (*ActiveDirectory, error)
	// CreateActiveDirectory
	// Creates the active directory specified in the request.
	CreateActiveDirectory(context.Context, *CreateActiveDirectoryRequest) (*longrunningpb.Operation, error)
	// Update the parameters of an active directories.
	UpdateActiveDirectory(context.Context, *UpdateActiveDirectoryRequest) (*longrunningpb.Operation, error)
	// Delete the active directory specified in the request.
	DeleteActiveDirectory(context.Context, *DeleteActiveDirectoryRequest) (*longrunningpb.Operation, error)
	// Returns descriptions of all KMS configs owned by the caller.
	ListKmsConfigs(context.Context, *ListKmsConfigsRequest) (*ListKmsConfigsResponse, error)
	// Creates a new KMS config.
	CreateKmsConfig(context.Context, *CreateKmsConfigRequest) (*longrunningpb.Operation, error)
	// Returns the description of the specified KMS config by kms_config_id.
	GetKmsConfig(context.Context, *GetKmsConfigRequest) (*KmsConfig, error)
	// Updates the Kms config properties with the full spec
	UpdateKmsConfig(context.Context, *UpdateKmsConfigRequest) (*longrunningpb.Operation, error)
	// Encrypt the existing volumes without CMEK encryption with the desired the
	// KMS config for the whole region.
	EncryptVolumes(context.Context, *EncryptVolumesRequest) (*longrunningpb.Operation, error)
	// Verifies KMS config reachability.
	VerifyKmsConfig(context.Context, *VerifyKmsConfigRequest) (*VerifyKmsConfigResponse, error)
	// Warning! This operation will permanently delete the Kms config.
	DeleteKmsConfig(context.Context, *DeleteKmsConfigRequest) (*longrunningpb.Operation, error)
	// Returns descriptions of all replications for a volume.
	ListReplications(context.Context, *ListReplicationsRequest) (*ListReplicationsResponse, error)
	// Describe a replication for a volume.
	GetReplication(context.Context, *GetReplicationRequest) (*Replication, error)
	// Create a new replication for a volume.
	CreateReplication(context.Context, *CreateReplicationRequest) (*longrunningpb.Operation, error)
	// Deletes a replication.
	DeleteReplication(context.Context, *DeleteReplicationRequest) (*longrunningpb.Operation, error)
	// Updates the settings of a specific replication.
	UpdateReplication(context.Context, *UpdateReplicationRequest) (*longrunningpb.Operation, error)
	// Stop Cross Region Replication.
	StopReplication(context.Context, *StopReplicationRequest) (*longrunningpb.Operation, error)
	// Resume Cross Region Replication.
	ResumeReplication(context.Context, *ResumeReplicationRequest) (*longrunningpb.Operation, error)
	// Reverses direction of replication. Source becomes destination and
	// destination becomes source.
	ReverseReplicationDirection(context.Context, *ReverseReplicationDirectionRequest) (*longrunningpb.Operation, error)
}

// UnimplementedNetAppServer can be embedded to have forward compatible implementations.
type UnimplementedNetAppServer struct {
}

func (*UnimplementedNetAppServer) ListStoragePools(context.Context, *ListStoragePoolsRequest) (*ListStoragePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListStoragePools not implemented")
}
func (*UnimplementedNetAppServer) CreateStoragePool(context.Context, *CreateStoragePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateStoragePool not implemented")
}
func (*UnimplementedNetAppServer) GetStoragePool(context.Context, *GetStoragePoolRequest) (*StoragePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStoragePool not implemented")
}
func (*UnimplementedNetAppServer) UpdateStoragePool(context.Context, *UpdateStoragePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateStoragePool not implemented")
}
func (*UnimplementedNetAppServer) DeleteStoragePool(context.Context, *DeleteStoragePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteStoragePool not implemented")
}
func (*UnimplementedNetAppServer) ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumes not implemented")
}
func (*UnimplementedNetAppServer) GetVolume(context.Context, *GetVolumeRequest) (*Volume, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolume not implemented")
}
func (*UnimplementedNetAppServer) CreateVolume(context.Context, *CreateVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVolume not implemented")
}
func (*UnimplementedNetAppServer) UpdateVolume(context.Context, *UpdateVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVolume not implemented")
}
func (*UnimplementedNetAppServer) DeleteVolume(context.Context, *DeleteVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVolume not implemented")
}
func (*UnimplementedNetAppServer) RevertVolume(context.Context, *RevertVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevertVolume not implemented")
}
func (*UnimplementedNetAppServer) ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnapshots not implemented")
}
func (*UnimplementedNetAppServer) GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (*UnimplementedNetAppServer) CreateSnapshot(context.Context, *CreateSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSnapshot not implemented")
}
func (*UnimplementedNetAppServer) DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSnapshot not implemented")
}
func (*UnimplementedNetAppServer) UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSnapshot not implemented")
}
func (*UnimplementedNetAppServer) ListActiveDirectories(context.Context, *ListActiveDirectoriesRequest) (*ListActiveDirectoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListActiveDirectories not implemented")
}
func (*UnimplementedNetAppServer) GetActiveDirectory(context.Context, *GetActiveDirectoryRequest) (*ActiveDirectory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActiveDirectory not implemented")
}
func (*UnimplementedNetAppServer) CreateActiveDirectory(context.Context, *CreateActiveDirectoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateActiveDirectory not implemented")
}
func (*UnimplementedNetAppServer) UpdateActiveDirectory(context.Context, *UpdateActiveDirectoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateActiveDirectory not implemented")
}
func (*UnimplementedNetAppServer) DeleteActiveDirectory(context.Context, *DeleteActiveDirectoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteActiveDirectory not implemented")
}
func (*UnimplementedNetAppServer) ListKmsConfigs(context.Context, *ListKmsConfigsRequest) (*ListKmsConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKmsConfigs not implemented")
}
func (*UnimplementedNetAppServer) CreateKmsConfig(context.Context, *CreateKmsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKmsConfig not implemented")
}
func (*UnimplementedNetAppServer) GetKmsConfig(context.Context, *GetKmsConfigRequest) (*KmsConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKmsConfig not implemented")
}
func (*UnimplementedNetAppServer) UpdateKmsConfig(context.Context, *UpdateKmsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKmsConfig not implemented")
}
func (*UnimplementedNetAppServer) EncryptVolumes(context.Context, *EncryptVolumesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EncryptVolumes not implemented")
}
func (*UnimplementedNetAppServer) VerifyKmsConfig(context.Context, *VerifyKmsConfigRequest) (*VerifyKmsConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyKmsConfig not implemented")
}
func (*UnimplementedNetAppServer) DeleteKmsConfig(context.Context, *DeleteKmsConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKmsConfig not implemented")
}
func (*UnimplementedNetAppServer) ListReplications(context.Context, *ListReplicationsRequest) (*ListReplicationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReplications not implemented")
}
func (*UnimplementedNetAppServer) GetReplication(context.Context, *GetReplicationRequest) (*Replication, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReplication not implemented")
}
func (*UnimplementedNetAppServer) CreateReplication(context.Context, *CreateReplicationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReplication not implemented")
}
func (*UnimplementedNetAppServer) DeleteReplication(context.Context, *DeleteReplicationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReplication not implemented")
}
func (*UnimplementedNetAppServer) UpdateReplication(context.Context, *UpdateReplicationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReplication not implemented")
}
func (*UnimplementedNetAppServer) StopReplication(context.Context, *StopReplicationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopReplication not implemented")
}
func (*UnimplementedNetAppServer) ResumeReplication(context.Context, *ResumeReplicationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeReplication not implemented")
}
func (*UnimplementedNetAppServer) ReverseReplicationDirection(context.Context, *ReverseReplicationDirectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReverseReplicationDirection not implemented")
}

func RegisterNetAppServer(s *grpc.Server, srv NetAppServer) {
	s.RegisterService(&_NetApp_serviceDesc, srv)
}

func _NetApp_ListStoragePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStoragePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).ListStoragePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/ListStoragePools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).ListStoragePools(ctx, req.(*ListStoragePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_CreateStoragePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateStoragePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).CreateStoragePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/CreateStoragePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).CreateStoragePool(ctx, req.(*CreateStoragePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_GetStoragePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStoragePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).GetStoragePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/GetStoragePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).GetStoragePool(ctx, req.(*GetStoragePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_UpdateStoragePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStoragePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).UpdateStoragePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/UpdateStoragePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).UpdateStoragePool(ctx, req.(*UpdateStoragePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_DeleteStoragePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStoragePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).DeleteStoragePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/DeleteStoragePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).DeleteStoragePool(ctx, req.(*DeleteStoragePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_ListVolumes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).ListVolumes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/ListVolumes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).ListVolumes(ctx, req.(*ListVolumesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_GetVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).GetVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/GetVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).GetVolume(ctx, req.(*GetVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_CreateVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).CreateVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/CreateVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).CreateVolume(ctx, req.(*CreateVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_UpdateVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).UpdateVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/UpdateVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).UpdateVolume(ctx, req.(*UpdateVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_DeleteVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).DeleteVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/DeleteVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).DeleteVolume(ctx, req.(*DeleteVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_RevertVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevertVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).RevertVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/RevertVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).RevertVolume(ctx, req.(*RevertVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/ListSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_GetSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).GetSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/GetSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).GetSnapshot(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_CreateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).CreateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/CreateSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).CreateSnapshot(ctx, req.(*CreateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/DeleteSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_UpdateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).UpdateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/UpdateSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).UpdateSnapshot(ctx, req.(*UpdateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_ListActiveDirectories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListActiveDirectoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).ListActiveDirectories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/ListActiveDirectories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).ListActiveDirectories(ctx, req.(*ListActiveDirectoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_GetActiveDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActiveDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).GetActiveDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/GetActiveDirectory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).GetActiveDirectory(ctx, req.(*GetActiveDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_CreateActiveDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateActiveDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).CreateActiveDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/CreateActiveDirectory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).CreateActiveDirectory(ctx, req.(*CreateActiveDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_UpdateActiveDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActiveDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).UpdateActiveDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/UpdateActiveDirectory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).UpdateActiveDirectory(ctx, req.(*UpdateActiveDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_DeleteActiveDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteActiveDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).DeleteActiveDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/DeleteActiveDirectory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).DeleteActiveDirectory(ctx, req.(*DeleteActiveDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_ListKmsConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKmsConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).ListKmsConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/ListKmsConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).ListKmsConfigs(ctx, req.(*ListKmsConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_CreateKmsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKmsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).CreateKmsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/CreateKmsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).CreateKmsConfig(ctx, req.(*CreateKmsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_GetKmsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKmsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).GetKmsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/GetKmsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).GetKmsConfig(ctx, req.(*GetKmsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_UpdateKmsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKmsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).UpdateKmsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/UpdateKmsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).UpdateKmsConfig(ctx, req.(*UpdateKmsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_EncryptVolumes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EncryptVolumesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).EncryptVolumes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/EncryptVolumes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).EncryptVolumes(ctx, req.(*EncryptVolumesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_VerifyKmsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyKmsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).VerifyKmsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/VerifyKmsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).VerifyKmsConfig(ctx, req.(*VerifyKmsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_DeleteKmsConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKmsConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).DeleteKmsConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/DeleteKmsConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).DeleteKmsConfig(ctx, req.(*DeleteKmsConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_ListReplications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReplicationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).ListReplications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/ListReplications",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).ListReplications(ctx, req.(*ListReplicationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_GetReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).GetReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/GetReplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).GetReplication(ctx, req.(*GetReplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_CreateReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).CreateReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/CreateReplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).CreateReplication(ctx, req.(*CreateReplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_DeleteReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).DeleteReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/DeleteReplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).DeleteReplication(ctx, req.(*DeleteReplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_UpdateReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).UpdateReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/UpdateReplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).UpdateReplication(ctx, req.(*UpdateReplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_StopReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopReplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).StopReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/StopReplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).StopReplication(ctx, req.(*StopReplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_ResumeReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeReplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).ResumeReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/ResumeReplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).ResumeReplication(ctx, req.(*ResumeReplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetApp_ReverseReplicationDirection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReverseReplicationDirectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetAppServer).ReverseReplicationDirection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.netapp.v1.NetApp/ReverseReplicationDirection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetAppServer).ReverseReplicationDirection(ctx, req.(*ReverseReplicationDirectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NetApp_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.netapp.v1.NetApp",
	HandlerType: (*NetAppServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListStoragePools",
			Handler:    _NetApp_ListStoragePools_Handler,
		},
		{
			MethodName: "CreateStoragePool",
			Handler:    _NetApp_CreateStoragePool_Handler,
		},
		{
			MethodName: "GetStoragePool",
			Handler:    _NetApp_GetStoragePool_Handler,
		},
		{
			MethodName: "UpdateStoragePool",
			Handler:    _NetApp_UpdateStoragePool_Handler,
		},
		{
			MethodName: "DeleteStoragePool",
			Handler:    _NetApp_DeleteStoragePool_Handler,
		},
		{
			MethodName: "ListVolumes",
			Handler:    _NetApp_ListVolumes_Handler,
		},
		{
			MethodName: "GetVolume",
			Handler:    _NetApp_GetVolume_Handler,
		},
		{
			MethodName: "CreateVolume",
			Handler:    _NetApp_CreateVolume_Handler,
		},
		{
			MethodName: "UpdateVolume",
			Handler:    _NetApp_UpdateVolume_Handler,
		},
		{
			MethodName: "DeleteVolume",
			Handler:    _NetApp_DeleteVolume_Handler,
		},
		{
			MethodName: "RevertVolume",
			Handler:    _NetApp_RevertVolume_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _NetApp_ListSnapshots_Handler,
		},
		{
			MethodName: "GetSnapshot",
			Handler:    _NetApp_GetSnapshot_Handler,
		},
		{
			MethodName: "CreateSnapshot",
			Handler:    _NetApp_CreateSnapshot_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _NetApp_DeleteSnapshot_Handler,
		},
		{
			MethodName: "UpdateSnapshot",
			Handler:    _NetApp_UpdateSnapshot_Handler,
		},
		{
			MethodName: "ListActiveDirectories",
			Handler:    _NetApp_ListActiveDirectories_Handler,
		},
		{
			MethodName: "GetActiveDirectory",
			Handler:    _NetApp_GetActiveDirectory_Handler,
		},
		{
			MethodName: "CreateActiveDirectory",
			Handler:    _NetApp_CreateActiveDirectory_Handler,
		},
		{
			MethodName: "UpdateActiveDirectory",
			Handler:    _NetApp_UpdateActiveDirectory_Handler,
		},
		{
			MethodName: "DeleteActiveDirectory",
			Handler:    _NetApp_DeleteActiveDirectory_Handler,
		},
		{
			MethodName: "ListKmsConfigs",
			Handler:    _NetApp_ListKmsConfigs_Handler,
		},
		{
			MethodName: "CreateKmsConfig",
			Handler:    _NetApp_CreateKmsConfig_Handler,
		},
		{
			MethodName: "GetKmsConfig",
			Handler:    _NetApp_GetKmsConfig_Handler,
		},
		{
			MethodName: "UpdateKmsConfig",
			Handler:    _NetApp_UpdateKmsConfig_Handler,
		},
		{
			MethodName: "EncryptVolumes",
			Handler:    _NetApp_EncryptVolumes_Handler,
		},
		{
			MethodName: "VerifyKmsConfig",
			Handler:    _NetApp_VerifyKmsConfig_Handler,
		},
		{
			MethodName: "DeleteKmsConfig",
			Handler:    _NetApp_DeleteKmsConfig_Handler,
		},
		{
			MethodName: "ListReplications",
			Handler:    _NetApp_ListReplications_Handler,
		},
		{
			MethodName: "GetReplication",
			Handler:    _NetApp_GetReplication_Handler,
		},
		{
			MethodName: "CreateReplication",
			Handler:    _NetApp_CreateReplication_Handler,
		},
		{
			MethodName: "DeleteReplication",
			Handler:    _NetApp_DeleteReplication_Handler,
		},
		{
			MethodName: "UpdateReplication",
			Handler:    _NetApp_UpdateReplication_Handler,
		},
		{
			MethodName: "StopReplication",
			Handler:    _NetApp_StopReplication_Handler,
		},
		{
			MethodName: "ResumeReplication",
			Handler:    _NetApp_ResumeReplication_Handler,
		},
		{
			MethodName: "ReverseReplicationDirection",
			Handler:    _NetApp_ReverseReplicationDirection_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/netapp/v1/cloud_netapp_service.proto",
}
