// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/dataqna/v1alpha/question.proto

package dataqnapb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Query entities of an interpretation.
type InterpretEntity int32

const (
	// No interpret entity was specified.
	InterpretEntity_INTERPRET_ENTITY_UNSPECIFIED InterpretEntity = 0
	// A dimenstion entity.
	InterpretEntity_DIMENSION InterpretEntity = 1
	// A metric entity.
	InterpretEntity_METRIC InterpretEntity = 2
)

// Enum value maps for InterpretEntity.
var (
	InterpretEntity_name = map[int32]string{
		0: "INTERPRET_ENTITY_UNSPECIFIED",
		1: "DIMENSION",
		2: "METRIC",
	}
	InterpretEntity_value = map[string]int32{
		"INTERPRET_ENTITY_UNSPECIFIED": 0,
		"DIMENSION":                    1,
		"METRIC":                       2,
	}
)

func (x InterpretEntity) Enum() *InterpretEntity {
	p := new(InterpretEntity)
	*p = x
	return p
}

func (x InterpretEntity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterpretEntity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataqna_v1alpha_question_proto_enumTypes[0].Descriptor()
}

func (InterpretEntity) Type() protoreflect.EnumType {
	return &file_google_cloud_dataqna_v1alpha_question_proto_enumTypes[0]
}

func (x InterpretEntity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterpretEntity.Descriptor instead.
func (InterpretEntity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{0}
}

// The interpret error code provides an error category why the interpretation
// failed.
type InterpretError_InterpretErrorCode int32

const (
	// No interpret error code was specified.
	InterpretError_INTERPRET_ERROR_CODE_UNSPECIFIED InterpretError_InterpretErrorCode = 0
	// The query is not valid.
	InterpretError_INVALID_QUERY InterpretError_InterpretErrorCode = 1
	// The interpreter failed to understand the question. For example, because
	// it was too ambiguous.
	InterpretError_FAILED_TO_UNDERSTAND InterpretError_InterpretErrorCode = 2
	// The interpreter could understand the question, but was not able to arrive
	// at an answer. For example, because a requested operation is not
	// supported.
	InterpretError_FAILED_TO_ANSWER InterpretError_InterpretErrorCode = 3
)

// Enum value maps for InterpretError_InterpretErrorCode.
var (
	InterpretError_InterpretErrorCode_name = map[int32]string{
		0: "INTERPRET_ERROR_CODE_UNSPECIFIED",
		1: "INVALID_QUERY",
		2: "FAILED_TO_UNDERSTAND",
		3: "FAILED_TO_ANSWER",
	}
	InterpretError_InterpretErrorCode_value = map[string]int32{
		"INTERPRET_ERROR_CODE_UNSPECIFIED": 0,
		"INVALID_QUERY":                    1,
		"FAILED_TO_UNDERSTAND":             2,
		"FAILED_TO_ANSWER":                 3,
	}
)

func (x InterpretError_InterpretErrorCode) Enum() *InterpretError_InterpretErrorCode {
	p := new(InterpretError_InterpretErrorCode)
	*p = x
	return p
}

func (x InterpretError_InterpretErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterpretError_InterpretErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataqna_v1alpha_question_proto_enumTypes[1].Descriptor()
}

func (InterpretError_InterpretErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_dataqna_v1alpha_question_proto_enumTypes[1]
}

func (x InterpretError_InterpretErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterpretError_InterpretErrorCode.Descriptor instead.
func (InterpretError_InterpretErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{1, 0}
}

// Enum of possible job execution statuses.
type ExecutionInfo_JobExecutionState int32

const (
	// No job execution was specified.
	ExecutionInfo_JOB_EXECUTION_STATE_UNSPECIFIED ExecutionInfo_JobExecutionState = 0
	// No job execution was requested, yet.
	ExecutionInfo_NOT_EXECUTED ExecutionInfo_JobExecutionState = 1
	// The job is running.
	ExecutionInfo_RUNNING ExecutionInfo_JobExecutionState = 2
	// The job completed successfully.
	ExecutionInfo_SUCCEEDED ExecutionInfo_JobExecutionState = 3
	// The job completed unsuccessfully.
	ExecutionInfo_FAILED ExecutionInfo_JobExecutionState = 4
)

// Enum value maps for ExecutionInfo_JobExecutionState.
var (
	ExecutionInfo_JobExecutionState_name = map[int32]string{
		0: "JOB_EXECUTION_STATE_UNSPECIFIED",
		1: "NOT_EXECUTED",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
	}
	ExecutionInfo_JobExecutionState_value = map[string]int32{
		"JOB_EXECUTION_STATE_UNSPECIFIED": 0,
		"NOT_EXECUTED":                    1,
		"RUNNING":                         2,
		"SUCCEEDED":                       3,
		"FAILED":                          4,
	}
)

func (x ExecutionInfo_JobExecutionState) Enum() *ExecutionInfo_JobExecutionState {
	p := new(ExecutionInfo_JobExecutionState)
	*p = x
	return p
}

func (x ExecutionInfo_JobExecutionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionInfo_JobExecutionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataqna_v1alpha_question_proto_enumTypes[2].Descriptor()
}

func (ExecutionInfo_JobExecutionState) Type() protoreflect.EnumType {
	return &file_google_cloud_dataqna_v1alpha_question_proto_enumTypes[2]
}

func (x ExecutionInfo_JobExecutionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionInfo_JobExecutionState.Descriptor instead.
func (ExecutionInfo_JobExecutionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{2, 0}
}

// Enumeration of visualzation types to use for query response data.
type InterpretationStructure_VisualizationType int32

const (
	// No visualization type was specified.
	InterpretationStructure_VISUALIZATION_TYPE_UNSPECIFIED InterpretationStructure_VisualizationType = 0
	// Show a table.
	InterpretationStructure_TABLE InterpretationStructure_VisualizationType = 1
	// Show a [bar
	// chart](https://developers.google.com/chart/interactive/docs/gallery/barchart).
	InterpretationStructure_BAR_CHART InterpretationStructure_VisualizationType = 2
	// Show a [column
	// chart](https://developers.google.com/chart/interactive/docs/gallery/columnchart).
	InterpretationStructure_COLUMN_CHART InterpretationStructure_VisualizationType = 3
	// Show a
	// [timeline](https://developers.google.com/chart/interactive/docs/gallery/timeline).
	InterpretationStructure_TIMELINE InterpretationStructure_VisualizationType = 4
	// Show a [scatter
	// plot](https://developers.google.com/chart/interactive/docs/gallery/scatterchart).
	InterpretationStructure_SCATTER_PLOT InterpretationStructure_VisualizationType = 5
	// Show a [pie
	// chart](https://developers.google.com/chart/interactive/docs/gallery/piechart).
	InterpretationStructure_PIE_CHART InterpretationStructure_VisualizationType = 6
	// Show a [line
	// chart](https://developers.google.com/chart/interactive/docs/gallery/linechart).
	InterpretationStructure_LINE_CHART InterpretationStructure_VisualizationType = 7
	// Show an [area
	// chart](https://developers.google.com/chart/interactive/docs/gallery/areachart).
	InterpretationStructure_AREA_CHART InterpretationStructure_VisualizationType = 8
	// Show a [combo
	// chart](https://developers.google.com/chart/interactive/docs/gallery/combochart).
	InterpretationStructure_COMBO_CHART InterpretationStructure_VisualizationType = 9
	// Show a
	// [histogram](https://developers.google.com/chart/interactive/docs/gallery/histogram).
	InterpretationStructure_HISTOGRAM InterpretationStructure_VisualizationType = 10
	// This denotes queries when the user has not specified the particular type
	// of chart and has mentioned only a generic chart name such as "Chart",
	// "Plot", "Graph", etc. This will differentiate it from specific charting
	// terms such as "Bar chart", "Pie chart", etc.
	InterpretationStructure_GENERIC_CHART InterpretationStructure_VisualizationType = 11
	// The user tried to specify a chart type, but the interpreter could not
	// understand the type. The client should display a generic chart and may
	// give a hint to the user that the requested type was not understood.
	InterpretationStructure_CHART_NOT_UNDERSTOOD InterpretationStructure_VisualizationType = 12
)

// Enum value maps for InterpretationStructure_VisualizationType.
var (
	InterpretationStructure_VisualizationType_name = map[int32]string{
		0:  "VISUALIZATION_TYPE_UNSPECIFIED",
		1:  "TABLE",
		2:  "BAR_CHART",
		3:  "COLUMN_CHART",
		4:  "TIMELINE",
		5:  "SCATTER_PLOT",
		6:  "PIE_CHART",
		7:  "LINE_CHART",
		8:  "AREA_CHART",
		9:  "COMBO_CHART",
		10: "HISTOGRAM",
		11: "GENERIC_CHART",
		12: "CHART_NOT_UNDERSTOOD",
	}
	InterpretationStructure_VisualizationType_value = map[string]int32{
		"VISUALIZATION_TYPE_UNSPECIFIED": 0,
		"TABLE":                          1,
		"BAR_CHART":                      2,
		"COLUMN_CHART":                   3,
		"TIMELINE":                       4,
		"SCATTER_PLOT":                   5,
		"PIE_CHART":                      6,
		"LINE_CHART":                     7,
		"AREA_CHART":                     8,
		"COMBO_CHART":                    9,
		"HISTOGRAM":                      10,
		"GENERIC_CHART":                  11,
		"CHART_NOT_UNDERSTOOD":           12,
	}
)

func (x InterpretationStructure_VisualizationType) Enum() *InterpretationStructure_VisualizationType {
	p := new(InterpretationStructure_VisualizationType)
	*p = x
	return p
}

func (x InterpretationStructure_VisualizationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterpretationStructure_VisualizationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataqna_v1alpha_question_proto_enumTypes[3].Descriptor()
}

func (InterpretationStructure_VisualizationType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataqna_v1alpha_question_proto_enumTypes[3]
}

func (x InterpretationStructure_VisualizationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterpretationStructure_VisualizationType.Descriptor instead.
func (InterpretationStructure_VisualizationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{7, 0}
}

// The question resource represents a natural language query, its settings,
// understanding generated by the system, and answer retrieval status.
// A question cannot be modified.
type Question struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. The unique identifier for the Question. The ID is server-generated.
	// Example: `projects/foo/locations/bar/questions/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. Scopes to be used for the question. A scope defines the relevant data set
	// scope. It can be a reference to a specific data source or a collection of
	// data sources. Currently, support is limited to a single BigQuery table.
	// There must be exactly one `scopes` element.
	//
	// Example:
	// `//bigquery.googleapis.com/projects/test-project/datasets/foo/tables/bar`
	Scopes []string `protobuf:"bytes,2,rep,name=scopes,proto3" json:"scopes,omitempty"`
	// Required. Immutable. The query in natural language.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// A list of annotations to use instead of the default annotation of a data
	// source (set in the data source reference resource). There must not be
	// more than one annotation with the same data source reference.
	DataSourceAnnotations []string `protobuf:"bytes,4,rep,name=data_source_annotations,json=dataSourceAnnotations,proto3" json:"data_source_annotations,omitempty"`
	// An error field explaining why interpretation failed. This is only populated
	// if the interpretation failed.
	//
	// Note: This is different from getting a status error on the request itself.
	// This is not a client or server error and the Question resource is still
	// persisted, but the service could not interpret the question. Clients should
	// present the error to the user so the user can rephrase the question.
	InterpretError *InterpretError `protobuf:"bytes,5,opt,name=interpret_error,json=interpretError,proto3" json:"interpret_error,omitempty"`
	// A list of interpretations for this question.
	Interpretations []*Interpretation `protobuf:"bytes,6,rep,name=interpretations,proto3" json:"interpretations,omitempty"`
	// Time when the question was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The e-mail address of the user that created this question.
	UserEmail string `protobuf:"bytes,8,opt,name=user_email,json=userEmail,proto3" json:"user_email,omitempty"`
	// Input only. Immutable. Flags to request additional information for debugging purposes.
	DebugFlags *DebugFlags `protobuf:"bytes,9,opt,name=debug_flags,json=debugFlags,proto3" json:"debug_flags,omitempty"`
	// Top level debug information.
	// This will be stored as the type DebugInformation.
	// Using Any so clients don't need to pull in anything
	// inside the debug message.
	DebugInfo *anypb.Any `protobuf:"bytes,10,opt,name=debug_info,json=debugInfo,proto3" json:"debug_info,omitempty"`
}

func (x *Question) Reset() {
	*x = Question{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Question) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Question) ProtoMessage() {}

func (x *Question) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Question.ProtoReflect.Descriptor instead.
func (*Question) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{0}
}

func (x *Question) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Question) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

func (x *Question) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *Question) GetDataSourceAnnotations() []string {
	if x != nil {
		return x.DataSourceAnnotations
	}
	return nil
}

func (x *Question) GetInterpretError() *InterpretError {
	if x != nil {
		return x.InterpretError
	}
	return nil
}

func (x *Question) GetInterpretations() []*Interpretation {
	if x != nil {
		return x.Interpretations
	}
	return nil
}

func (x *Question) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Question) GetUserEmail() string {
	if x != nil {
		return x.UserEmail
	}
	return ""
}

func (x *Question) GetDebugFlags() *DebugFlags {
	if x != nil {
		return x.DebugFlags
	}
	return nil
}

func (x *Question) GetDebugInfo() *anypb.Any {
	if x != nil {
		return x.DebugInfo
	}
	return nil
}

// Details on the failure to interpret the question.
type InterpretError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error message explaining why this question could not be interpreted.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// The code for the error category why the interpretation failed.
	Code InterpretError_InterpretErrorCode `protobuf:"varint,2,opt,name=code,proto3,enum=google.cloud.dataqna.v1alpha.InterpretError_InterpretErrorCode" json:"code,omitempty"`
	// Details on interpretation failure.
	Details *InterpretError_InterpretErrorDetails `protobuf:"bytes,3,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *InterpretError) Reset() {
	*x = InterpretError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterpretError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterpretError) ProtoMessage() {}

func (x *InterpretError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterpretError.ProtoReflect.Descriptor instead.
func (*InterpretError) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{1}
}

func (x *InterpretError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *InterpretError) GetCode() InterpretError_InterpretErrorCode {
	if x != nil {
		return x.Code
	}
	return InterpretError_INTERPRET_ERROR_CODE_UNSPECIFIED
}

func (x *InterpretError) GetDetails() *InterpretError_InterpretErrorDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

// Information about the backend status (such as BigQuery) of the execution.
type ExecutionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Status returned by the backend when the job was created.
	JobCreationStatus *status.Status `protobuf:"bytes,1,opt,name=job_creation_status,json=jobCreationStatus,proto3" json:"job_creation_status,omitempty"`
	// Status of the job execution.
	JobExecutionState ExecutionInfo_JobExecutionState `protobuf:"varint,2,opt,name=job_execution_state,json=jobExecutionState,proto3,enum=google.cloud.dataqna.v1alpha.ExecutionInfo_JobExecutionState" json:"job_execution_state,omitempty"`
	// Time when the execution was triggered.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// BigQuery job information.
	// Future versions will have different backends. Hence, clients must make sure
	// they can handle it when this field is not populated.
	BigqueryJob *BigQueryJob `protobuf:"bytes,4,opt,name=bigquery_job,json=bigqueryJob,proto3" json:"bigquery_job,omitempty"`
}

func (x *ExecutionInfo) Reset() {
	*x = ExecutionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionInfo) ProtoMessage() {}

func (x *ExecutionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionInfo.ProtoReflect.Descriptor instead.
func (*ExecutionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{2}
}

func (x *ExecutionInfo) GetJobCreationStatus() *status.Status {
	if x != nil {
		return x.JobCreationStatus
	}
	return nil
}

func (x *ExecutionInfo) GetJobExecutionState() ExecutionInfo_JobExecutionState {
	if x != nil {
		return x.JobExecutionState
	}
	return ExecutionInfo_JOB_EXECUTION_STATE_UNSPECIFIED
}

func (x *ExecutionInfo) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ExecutionInfo) GetBigqueryJob() *BigQueryJob {
	if x != nil {
		return x.BigqueryJob
	}
	return nil
}

// BigQuery job information. This can be used to query the BigQuery API and
// retrieve the current job's status (using
// [jobs.get](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/get)).
type BigQueryJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The job ID.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The project ID of the job.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The location where the job is running.
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *BigQueryJob) Reset() {
	*x = BigQueryJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryJob) ProtoMessage() {}

func (x *BigQueryJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryJob.ProtoReflect.Descriptor instead.
func (*BigQueryJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{3}
}

func (x *BigQueryJob) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *BigQueryJob) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *BigQueryJob) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// An interpretation of a natural language query.
type Interpretation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of data sources used in the current understanding.
	DataSources []string `protobuf:"bytes,1,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	// The level of confidence that one of the interpretations is correct. This is
	// a value in the range [0, 1] where a value of 0.5 or below is to be
	// considered a low confidence.
	Confidence float64 `protobuf:"fixed64,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// A list of unused phrases. Clients should display a Did You Mean (DYM)
	//  dialog if this is non-empty, even if this is the only interpretation.
	UnusedPhrases []string `protobuf:"bytes,3,rep,name=unused_phrases,json=unusedPhrases,proto3" json:"unused_phrases,omitempty"`
	// Human readable representation of the query.
	HumanReadable *HumanReadable `protobuf:"bytes,4,opt,name=human_readable,json=humanReadable,proto3" json:"human_readable,omitempty"`
	// Information about the interpretation structure that helps to understand and
	// visualize the response.
	InterpretationStructure *InterpretationStructure `protobuf:"bytes,5,opt,name=interpretation_structure,json=interpretationStructure,proto3" json:"interpretation_structure,omitempty"`
	// Representation of the data query to be sent to the backend.
	DataQuery *DataQuery `protobuf:"bytes,6,opt,name=data_query,json=dataQuery,proto3" json:"data_query,omitempty"`
	// Information about the backend response. This is populated only if execution
	// of an interpretation was requested.
	ExecutionInfo *ExecutionInfo `protobuf:"bytes,7,opt,name=execution_info,json=executionInfo,proto3" json:"execution_info,omitempty"`
}

func (x *Interpretation) Reset() {
	*x = Interpretation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Interpretation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Interpretation) ProtoMessage() {}

func (x *Interpretation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Interpretation.ProtoReflect.Descriptor instead.
func (*Interpretation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{4}
}

func (x *Interpretation) GetDataSources() []string {
	if x != nil {
		return x.DataSources
	}
	return nil
}

func (x *Interpretation) GetConfidence() float64 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *Interpretation) GetUnusedPhrases() []string {
	if x != nil {
		return x.UnusedPhrases
	}
	return nil
}

func (x *Interpretation) GetHumanReadable() *HumanReadable {
	if x != nil {
		return x.HumanReadable
	}
	return nil
}

func (x *Interpretation) GetInterpretationStructure() *InterpretationStructure {
	if x != nil {
		return x.InterpretationStructure
	}
	return nil
}

func (x *Interpretation) GetDataQuery() *DataQuery {
	if x != nil {
		return x.DataQuery
	}
	return nil
}

func (x *Interpretation) GetExecutionInfo() *ExecutionInfo {
	if x != nil {
		return x.ExecutionInfo
	}
	return nil
}

// Representation of the data query for the backend.
// This is provided for informational purposes only. Clients should not use
// it to send it to the backend directly, but rather use the `execute` RPC
// to trigger the execution. Using the `execute` RPC is needed in order to
// track the state of a question and report on it correctly to the data
// administrators.
type DataQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated SQL query to be sent to the backend.
	Sql string `protobuf:"bytes,1,opt,name=sql,proto3" json:"sql,omitempty"`
}

func (x *DataQuery) Reset() {
	*x = DataQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQuery) ProtoMessage() {}

func (x *DataQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQuery.ProtoReflect.Descriptor instead.
func (*DataQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{5}
}

func (x *DataQuery) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

// Human readable interpretation.
type HumanReadable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generated query explaining the interpretation.
	GeneratedInterpretation *AnnotatedString `protobuf:"bytes,1,opt,name=generated_interpretation,json=generatedInterpretation,proto3" json:"generated_interpretation,omitempty"`
	// Annotations on the original query.
	OriginalQuestion *AnnotatedString `protobuf:"bytes,2,opt,name=original_question,json=originalQuestion,proto3" json:"original_question,omitempty"`
}

func (x *HumanReadable) Reset() {
	*x = HumanReadable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanReadable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanReadable) ProtoMessage() {}

func (x *HumanReadable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanReadable.ProtoReflect.Descriptor instead.
func (*HumanReadable) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{6}
}

func (x *HumanReadable) GetGeneratedInterpretation() *AnnotatedString {
	if x != nil {
		return x.GeneratedInterpretation
	}
	return nil
}

func (x *HumanReadable) GetOriginalQuestion() *AnnotatedString {
	if x != nil {
		return x.OriginalQuestion
	}
	return nil
}

// Information about the interpretation structure that helps to understand and
// visualize the response.
type InterpretationStructure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of possible visualization types to apply for this interpretation. The
	// order has no relevance.
	VisualizationTypes []InterpretationStructure_VisualizationType `protobuf:"varint,1,rep,packed,name=visualization_types,json=visualizationTypes,proto3,enum=google.cloud.dataqna.v1alpha.InterpretationStructure_VisualizationType" json:"visualization_types,omitempty"`
	// Information about the output columns, that is, the columns that will be
	// returned by the backend.
	ColumnInfo []*InterpretationStructure_ColumnInfo `protobuf:"bytes,2,rep,name=column_info,json=columnInfo,proto3" json:"column_info,omitempty"`
}

func (x *InterpretationStructure) Reset() {
	*x = InterpretationStructure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterpretationStructure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterpretationStructure) ProtoMessage() {}

func (x *InterpretationStructure) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterpretationStructure.ProtoReflect.Descriptor instead.
func (*InterpretationStructure) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{7}
}

func (x *InterpretationStructure) GetVisualizationTypes() []InterpretationStructure_VisualizationType {
	if x != nil {
		return x.VisualizationTypes
	}
	return nil
}

func (x *InterpretationStructure) GetColumnInfo() []*InterpretationStructure_ColumnInfo {
	if x != nil {
		return x.ColumnInfo
	}
	return nil
}

// Configuriation of debug flags.
type DebugFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to include the original VAQuery.
	IncludeVaQuery bool `protobuf:"varint,1,opt,name=include_va_query,json=includeVaQuery,proto3" json:"include_va_query,omitempty"`
	// Whether to include the original nested VAQuery.
	IncludeNestedVaQuery bool `protobuf:"varint,2,opt,name=include_nested_va_query,json=includeNestedVaQuery,proto3" json:"include_nested_va_query,omitempty"`
	// Whether to include the original human interpretation strings generated
	// by Analyza.
	IncludeHumanInterpretation bool `protobuf:"varint,3,opt,name=include_human_interpretation,json=includeHumanInterpretation,proto3" json:"include_human_interpretation,omitempty"`
	// Whether to include the Aqua debug response.
	IncludeAquaDebugResponse bool `protobuf:"varint,4,opt,name=include_aqua_debug_response,json=includeAquaDebugResponse,proto3" json:"include_aqua_debug_response,omitempty"`
	// The time in milliseconds from Unix epoch to be used
	// to process the query. This is useful for testing
	// the queries at different time period.
	// If not set or time_override <= 0, then the current
	// time is used.
	TimeOverride int64 `protobuf:"varint,5,opt,name=time_override,json=timeOverride,proto3" json:"time_override,omitempty"`
	// Set to true if request is initiated by an internal Google user.
	IsInternalGoogleUser bool `protobuf:"varint,6,opt,name=is_internal_google_user,json=isInternalGoogleUser,proto3" json:"is_internal_google_user,omitempty"`
	// Determines whether cache needs to be ignored. If set to
	// true, cache won't be queried and updated.
	IgnoreCache bool `protobuf:"varint,7,opt,name=ignore_cache,json=ignoreCache,proto3" json:"ignore_cache,omitempty"`
	// Whether to include the request/response pair from the call to the
	// EntityIndex for SearchEntities.
	IncludeSearchEntitiesRpc bool `protobuf:"varint,8,opt,name=include_search_entities_rpc,json=includeSearchEntitiesRpc,proto3" json:"include_search_entities_rpc,omitempty"`
	// Whether to include the request/response pair from the call to the
	// Annotations service for ListColumnAnnotations.
	IncludeListColumnAnnotationsRpc bool `protobuf:"varint,9,opt,name=include_list_column_annotations_rpc,json=includeListColumnAnnotationsRpc,proto3" json:"include_list_column_annotations_rpc,omitempty"`
	// Whether to include the entity list passed to Analyza.
	IncludeVirtualAnalystEntities bool `protobuf:"varint,10,opt,name=include_virtual_analyst_entities,json=includeVirtualAnalystEntities,proto3" json:"include_virtual_analyst_entities,omitempty"`
	// Whether to include the table list.
	IncludeTableList bool `protobuf:"varint,11,opt,name=include_table_list,json=includeTableList,proto3" json:"include_table_list,omitempty"`
	// Whether to include the domain list.
	IncludeDomainList bool `protobuf:"varint,12,opt,name=include_domain_list,json=includeDomainList,proto3" json:"include_domain_list,omitempty"`
}

func (x *DebugFlags) Reset() {
	*x = DebugFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DebugFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugFlags) ProtoMessage() {}

func (x *DebugFlags) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugFlags.ProtoReflect.Descriptor instead.
func (*DebugFlags) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{8}
}

func (x *DebugFlags) GetIncludeVaQuery() bool {
	if x != nil {
		return x.IncludeVaQuery
	}
	return false
}

func (x *DebugFlags) GetIncludeNestedVaQuery() bool {
	if x != nil {
		return x.IncludeNestedVaQuery
	}
	return false
}

func (x *DebugFlags) GetIncludeHumanInterpretation() bool {
	if x != nil {
		return x.IncludeHumanInterpretation
	}
	return false
}

func (x *DebugFlags) GetIncludeAquaDebugResponse() bool {
	if x != nil {
		return x.IncludeAquaDebugResponse
	}
	return false
}

func (x *DebugFlags) GetTimeOverride() int64 {
	if x != nil {
		return x.TimeOverride
	}
	return 0
}

func (x *DebugFlags) GetIsInternalGoogleUser() bool {
	if x != nil {
		return x.IsInternalGoogleUser
	}
	return false
}

func (x *DebugFlags) GetIgnoreCache() bool {
	if x != nil {
		return x.IgnoreCache
	}
	return false
}

func (x *DebugFlags) GetIncludeSearchEntitiesRpc() bool {
	if x != nil {
		return x.IncludeSearchEntitiesRpc
	}
	return false
}

func (x *DebugFlags) GetIncludeListColumnAnnotationsRpc() bool {
	if x != nil {
		return x.IncludeListColumnAnnotationsRpc
	}
	return false
}

func (x *DebugFlags) GetIncludeVirtualAnalystEntities() bool {
	if x != nil {
		return x.IncludeVirtualAnalystEntities
	}
	return false
}

func (x *DebugFlags) GetIncludeTableList() bool {
	if x != nil {
		return x.IncludeTableList
	}
	return false
}

func (x *DebugFlags) GetIncludeDomainList() bool {
	if x != nil {
		return x.IncludeDomainList
	}
	return false
}

// Details on interpretation failure.
type InterpretError_InterpretErrorDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Populated if parts of the query are unsupported.
	UnsupportedDetails *InterpretError_InterpretUnsupportedDetails `protobuf:"bytes,1,opt,name=unsupported_details,json=unsupportedDetails,proto3" json:"unsupported_details,omitempty"`
	// Populated if the query is incomplete.
	IncompleteQueryDetails *InterpretError_InterpretIncompleteQueryDetails `protobuf:"bytes,2,opt,name=incomplete_query_details,json=incompleteQueryDetails,proto3" json:"incomplete_query_details,omitempty"`
	// Populated if the query was too ambiguous.
	AmbiguityDetails *InterpretError_InterpretAmbiguityDetails `protobuf:"bytes,3,opt,name=ambiguity_details,json=ambiguityDetails,proto3" json:"ambiguity_details,omitempty"`
}

func (x *InterpretError_InterpretErrorDetails) Reset() {
	*x = InterpretError_InterpretErrorDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterpretError_InterpretErrorDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterpretError_InterpretErrorDetails) ProtoMessage() {}

func (x *InterpretError_InterpretErrorDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterpretError_InterpretErrorDetails.ProtoReflect.Descriptor instead.
func (*InterpretError_InterpretErrorDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{1, 0}
}

func (x *InterpretError_InterpretErrorDetails) GetUnsupportedDetails() *InterpretError_InterpretUnsupportedDetails {
	if x != nil {
		return x.UnsupportedDetails
	}
	return nil
}

func (x *InterpretError_InterpretErrorDetails) GetIncompleteQueryDetails() *InterpretError_InterpretIncompleteQueryDetails {
	if x != nil {
		return x.IncompleteQueryDetails
	}
	return nil
}

func (x *InterpretError_InterpretErrorDetails) GetAmbiguityDetails() *InterpretError_InterpretAmbiguityDetails {
	if x != nil {
		return x.AmbiguityDetails
	}
	return nil
}

// Details about unsupported parts in a query.
type InterpretError_InterpretUnsupportedDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unsupported operators. For example: median.
	Operators []string `protobuf:"bytes,1,rep,name=operators,proto3" json:"operators,omitempty"`
	// Unsupported intents.
	Intent []string `protobuf:"bytes,2,rep,name=intent,proto3" json:"intent,omitempty"`
}

func (x *InterpretError_InterpretUnsupportedDetails) Reset() {
	*x = InterpretError_InterpretUnsupportedDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterpretError_InterpretUnsupportedDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterpretError_InterpretUnsupportedDetails) ProtoMessage() {}

func (x *InterpretError_InterpretUnsupportedDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterpretError_InterpretUnsupportedDetails.ProtoReflect.Descriptor instead.
func (*InterpretError_InterpretUnsupportedDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{1, 1}
}

func (x *InterpretError_InterpretUnsupportedDetails) GetOperators() []string {
	if x != nil {
		return x.Operators
	}
	return nil
}

func (x *InterpretError_InterpretUnsupportedDetails) GetIntent() []string {
	if x != nil {
		return x.Intent
	}
	return nil
}

// Details about an incomplete query.
type InterpretError_InterpretIncompleteQueryDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of missing interpret entities.
	Entities []InterpretEntity `protobuf:"varint,1,rep,packed,name=entities,proto3,enum=google.cloud.dataqna.v1alpha.InterpretEntity" json:"entities,omitempty"`
}

func (x *InterpretError_InterpretIncompleteQueryDetails) Reset() {
	*x = InterpretError_InterpretIncompleteQueryDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterpretError_InterpretIncompleteQueryDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterpretError_InterpretIncompleteQueryDetails) ProtoMessage() {}

func (x *InterpretError_InterpretIncompleteQueryDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterpretError_InterpretIncompleteQueryDetails.ProtoReflect.Descriptor instead.
func (*InterpretError_InterpretIncompleteQueryDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{1, 2}
}

func (x *InterpretError_InterpretIncompleteQueryDetails) GetEntities() []InterpretEntity {
	if x != nil {
		return x.Entities
	}
	return nil
}

// Details about a query that was too ambiguous. Currently, the message
// has no fields and its presence signals that there was ambiguity.
type InterpretError_InterpretAmbiguityDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InterpretError_InterpretAmbiguityDetails) Reset() {
	*x = InterpretError_InterpretAmbiguityDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterpretError_InterpretAmbiguityDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterpretError_InterpretAmbiguityDetails) ProtoMessage() {}

func (x *InterpretError_InterpretAmbiguityDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterpretError_InterpretAmbiguityDetails.ProtoReflect.Descriptor instead.
func (*InterpretError_InterpretAmbiguityDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{1, 3}
}

// Information about a column.
type InterpretationStructure_ColumnInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The alias of the output column as used by the backend. For example, the
	// field name in the schema provided in the query response in BigQuery.
	OutputAlias string `protobuf:"bytes,1,opt,name=output_alias,json=outputAlias,proto3" json:"output_alias,omitempty"`
	// Human readable name of the output column.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *InterpretationStructure_ColumnInfo) Reset() {
	*x = InterpretationStructure_ColumnInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterpretationStructure_ColumnInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterpretationStructure_ColumnInfo) ProtoMessage() {}

func (x *InterpretationStructure_ColumnInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterpretationStructure_ColumnInfo.ProtoReflect.Descriptor instead.
func (*InterpretationStructure_ColumnInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP(), []int{7, 0}
}

func (x *InterpretationStructure_ColumnInfo) GetOutputAlias() string {
	if x != nil {
		return x.OutputAlias
	}
	return ""
}

func (x *InterpretationStructure_ColumnInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_dataqna_v1alpha_question_proto protoreflect.FileDescriptor

var file_google_cloud_dataqna_v1alpha_question_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x98, 0x05, 0x0a, 0x08, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x06, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0,
	0x41, 0x05, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41,
	0x05, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x55, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x56, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c,
	0x12, 0x51, 0x0a, 0x0b, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x42,
	0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x04, 0x52, 0x0a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x46, 0x6c,
	0x61, 0x67, 0x73, 0x12, 0x33, 0x0a, 0x0a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x09, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x3a, 0x62, 0xea, 0x41, 0x5f, 0x0a, 0x1f, 0x64,
	0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xcf, 0x07, 0x0a,
	0x0e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x53, 0x0a, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x5c,
	0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x90, 0x03, 0x0a,
	0x15, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x79, 0x0a, 0x13, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x55, 0x6e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x12, 0x75,
	0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x86, 0x01, 0x0a, 0x18, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x52, 0x16, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x73, 0x0a, 0x11, 0x61, 0x6d,
	0x62, 0x69, 0x67, 0x75, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x41, 0x6d, 0x62,
	0x69, 0x67, 0x75, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x10, 0x61,
	0x6d, 0x62, 0x69, 0x67, 0x75, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a,
	0x53, 0x0a, 0x1b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x55, 0x6e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1c,
	0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x16, 0x0a, 0x06,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x1a, 0x6c, 0x0a, 0x1f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
	0x74, 0x49, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x49, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x1a, 0x1b, 0x0a, 0x19, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x41,
	0x6d, 0x62, 0x69, 0x67, 0x75, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22,
	0x7d, 0x0a, 0x12, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52,
	0x45, 0x54, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x18,
	0x0a, 0x14, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x5f, 0x55, 0x4e, 0x44, 0x45,
	0x52, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x5f, 0x54, 0x4f, 0x5f, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x10, 0x03, 0x22, 0xc1,
	0x03, 0x0a, 0x0d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x42, 0x0a, 0x13, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x11, 0x6a, 0x6f, 0x62, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x6d, 0x0a, 0x13, 0x6a, 0x6f, 0x62, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4a,
	0x6f, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x11, 0x6a, 0x6f, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4c, 0x0a, 0x0c, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6a, 0x6f, 0x62,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4a, 0x6f,
	0x62, 0x52, 0x0b, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x22, 0x72,
	0x0a, 0x11, 0x4a, 0x6f, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x4a, 0x4f, 0x42, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f,
	0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x04, 0x22, 0x5f, 0x0a, 0x0b, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4a, 0x6f,
	0x62, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xdc, 0x03, 0x0a, 0x0e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x6e, 0x75,
	0x73, 0x65, 0x64, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0d, 0x75, 0x6e, 0x75, 0x73, 0x65, 0x64, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73,
	0x12, 0x52, 0x0a, 0x0e, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x61,
	0x64, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0d, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x61, 0x64,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x70, 0x0a, 0x18, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x17, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x52,
	0x0a, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x22, 0x1d, 0x0a, 0x09, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x71,
	0x6c, 0x22, 0xd5, 0x01, 0x0a, 0x0d, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x68, 0x0a, 0x18, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x52, 0x17, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a,
	0x11, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x64, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x10, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xcc, 0x04, 0x0a, 0x17, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x78, 0x0a, 0x13, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12,
	0x61, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x1a, 0x52, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x6c,
	0x69, 0x61, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xff, 0x01, 0x0a, 0x11, 0x56, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e,
	0x56, 0x49, 0x53, 0x55, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x42,
	0x41, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x54, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4f,
	0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x54, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08,
	0x54, 0x49, 0x4d, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x43,
	0x41, 0x54, 0x54, 0x45, 0x52, 0x5f, 0x50, 0x4c, 0x4f, 0x54, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09,
	0x50, 0x49, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x54, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x4c,
	0x49, 0x4e, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x54, 0x10, 0x07, 0x12, 0x0e, 0x0a, 0x0a, 0x41,
	0x52, 0x45, 0x41, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x54, 0x10, 0x08, 0x12, 0x0f, 0x0a, 0x0b, 0x43,
	0x4f, 0x4d, 0x42, 0x4f, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x54, 0x10, 0x09, 0x12, 0x0d, 0x0a, 0x09,
	0x48, 0x49, 0x53, 0x54, 0x4f, 0x47, 0x52, 0x41, 0x4d, 0x10, 0x0a, 0x12, 0x11, 0x0a, 0x0d, 0x47,
	0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x43, 0x48, 0x41, 0x52, 0x54, 0x10, 0x0b, 0x12, 0x18,
	0x0a, 0x14, 0x43, 0x48, 0x41, 0x52, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x55, 0x4e, 0x44, 0x45,
	0x52, 0x53, 0x54, 0x4f, 0x4f, 0x44, 0x10, 0x0c, 0x22, 0xa1, 0x05, 0x0a, 0x0a, 0x44, 0x65, 0x62,
	0x75, 0x67, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x76, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x56, 0x61, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x35, 0x0a, 0x17, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6e, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x14, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4e, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x56, 0x61, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x1c, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x1b, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x61, 0x71, 0x75, 0x61, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x41, 0x71, 0x75, 0x61, 0x44, 0x65, 0x62, 0x75,
	0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x35,
	0x0a, 0x17, 0x69, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x69, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f,
	0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x3d, 0x0a, 0x1b, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x5f, 0x72, 0x70, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x52, 0x70, 0x63, 0x12, 0x4c, 0x0a, 0x23, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x70, 0x63, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x1f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x70, 0x63, 0x12, 0x47, 0x0a, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x5f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x74,
	0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x1d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x2c,
	0x0a, 0x12, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2e, 0x0a, 0x13,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6c,
	0x69, 0x73, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x2a, 0x4e, 0x0a, 0x0f,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x45, 0x54, 0x5f, 0x45, 0x4e, 0x54,
	0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x4d, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x10, 0x02, 0x42, 0xcf, 0x01, 0x0a,
	0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x42, 0x0d, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x3a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x71,
	0x6e, 0x61, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x71, 0x6e, 0x61, 0x70, 0x62, 0xaa, 0x02,
	0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x51, 0x6e, 0x41, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x1c,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74,
	0x61, 0x51, 0x6e, 0x41, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61,
	0x74, 0x61, 0x51, 0x6e, 0x41, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataqna_v1alpha_question_proto_rawDescOnce sync.Once
	file_google_cloud_dataqna_v1alpha_question_proto_rawDescData = file_google_cloud_dataqna_v1alpha_question_proto_rawDesc
)

func file_google_cloud_dataqna_v1alpha_question_proto_rawDescGZIP() []byte {
	file_google_cloud_dataqna_v1alpha_question_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataqna_v1alpha_question_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataqna_v1alpha_question_proto_rawDescData)
	})
	return file_google_cloud_dataqna_v1alpha_question_proto_rawDescData
}

var file_google_cloud_dataqna_v1alpha_question_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dataqna_v1alpha_question_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_dataqna_v1alpha_question_proto_goTypes = []interface{}{
	(InterpretEntity)(0),                                   // 0: google.cloud.dataqna.v1alpha.InterpretEntity
	(InterpretError_InterpretErrorCode)(0),                 // 1: google.cloud.dataqna.v1alpha.InterpretError.InterpretErrorCode
	(ExecutionInfo_JobExecutionState)(0),                   // 2: google.cloud.dataqna.v1alpha.ExecutionInfo.JobExecutionState
	(InterpretationStructure_VisualizationType)(0),         // 3: google.cloud.dataqna.v1alpha.InterpretationStructure.VisualizationType
	(*Question)(nil),                                       // 4: google.cloud.dataqna.v1alpha.Question
	(*InterpretError)(nil),                                 // 5: google.cloud.dataqna.v1alpha.InterpretError
	(*ExecutionInfo)(nil),                                  // 6: google.cloud.dataqna.v1alpha.ExecutionInfo
	(*BigQueryJob)(nil),                                    // 7: google.cloud.dataqna.v1alpha.BigQueryJob
	(*Interpretation)(nil),                                 // 8: google.cloud.dataqna.v1alpha.Interpretation
	(*DataQuery)(nil),                                      // 9: google.cloud.dataqna.v1alpha.DataQuery
	(*HumanReadable)(nil),                                  // 10: google.cloud.dataqna.v1alpha.HumanReadable
	(*InterpretationStructure)(nil),                        // 11: google.cloud.dataqna.v1alpha.InterpretationStructure
	(*DebugFlags)(nil),                                     // 12: google.cloud.dataqna.v1alpha.DebugFlags
	(*InterpretError_InterpretErrorDetails)(nil),           // 13: google.cloud.dataqna.v1alpha.InterpretError.InterpretErrorDetails
	(*InterpretError_InterpretUnsupportedDetails)(nil),     // 14: google.cloud.dataqna.v1alpha.InterpretError.InterpretUnsupportedDetails
	(*InterpretError_InterpretIncompleteQueryDetails)(nil), // 15: google.cloud.dataqna.v1alpha.InterpretError.InterpretIncompleteQueryDetails
	(*InterpretError_InterpretAmbiguityDetails)(nil),       // 16: google.cloud.dataqna.v1alpha.InterpretError.InterpretAmbiguityDetails
	(*InterpretationStructure_ColumnInfo)(nil),             // 17: google.cloud.dataqna.v1alpha.InterpretationStructure.ColumnInfo
	(*timestamppb.Timestamp)(nil),                          // 18: google.protobuf.Timestamp
	(*anypb.Any)(nil),                                      // 19: google.protobuf.Any
	(*status.Status)(nil),                                  // 20: google.rpc.Status
	(*AnnotatedString)(nil),                                // 21: google.cloud.dataqna.v1alpha.AnnotatedString
}
var file_google_cloud_dataqna_v1alpha_question_proto_depIdxs = []int32{
	5,  // 0: google.cloud.dataqna.v1alpha.Question.interpret_error:type_name -> google.cloud.dataqna.v1alpha.InterpretError
	8,  // 1: google.cloud.dataqna.v1alpha.Question.interpretations:type_name -> google.cloud.dataqna.v1alpha.Interpretation
	18, // 2: google.cloud.dataqna.v1alpha.Question.create_time:type_name -> google.protobuf.Timestamp
	12, // 3: google.cloud.dataqna.v1alpha.Question.debug_flags:type_name -> google.cloud.dataqna.v1alpha.DebugFlags
	19, // 4: google.cloud.dataqna.v1alpha.Question.debug_info:type_name -> google.protobuf.Any
	1,  // 5: google.cloud.dataqna.v1alpha.InterpretError.code:type_name -> google.cloud.dataqna.v1alpha.InterpretError.InterpretErrorCode
	13, // 6: google.cloud.dataqna.v1alpha.InterpretError.details:type_name -> google.cloud.dataqna.v1alpha.InterpretError.InterpretErrorDetails
	20, // 7: google.cloud.dataqna.v1alpha.ExecutionInfo.job_creation_status:type_name -> google.rpc.Status
	2,  // 8: google.cloud.dataqna.v1alpha.ExecutionInfo.job_execution_state:type_name -> google.cloud.dataqna.v1alpha.ExecutionInfo.JobExecutionState
	18, // 9: google.cloud.dataqna.v1alpha.ExecutionInfo.create_time:type_name -> google.protobuf.Timestamp
	7,  // 10: google.cloud.dataqna.v1alpha.ExecutionInfo.bigquery_job:type_name -> google.cloud.dataqna.v1alpha.BigQueryJob
	10, // 11: google.cloud.dataqna.v1alpha.Interpretation.human_readable:type_name -> google.cloud.dataqna.v1alpha.HumanReadable
	11, // 12: google.cloud.dataqna.v1alpha.Interpretation.interpretation_structure:type_name -> google.cloud.dataqna.v1alpha.InterpretationStructure
	9,  // 13: google.cloud.dataqna.v1alpha.Interpretation.data_query:type_name -> google.cloud.dataqna.v1alpha.DataQuery
	6,  // 14: google.cloud.dataqna.v1alpha.Interpretation.execution_info:type_name -> google.cloud.dataqna.v1alpha.ExecutionInfo
	21, // 15: google.cloud.dataqna.v1alpha.HumanReadable.generated_interpretation:type_name -> google.cloud.dataqna.v1alpha.AnnotatedString
	21, // 16: google.cloud.dataqna.v1alpha.HumanReadable.original_question:type_name -> google.cloud.dataqna.v1alpha.AnnotatedString
	3,  // 17: google.cloud.dataqna.v1alpha.InterpretationStructure.visualization_types:type_name -> google.cloud.dataqna.v1alpha.InterpretationStructure.VisualizationType
	17, // 18: google.cloud.dataqna.v1alpha.InterpretationStructure.column_info:type_name -> google.cloud.dataqna.v1alpha.InterpretationStructure.ColumnInfo
	14, // 19: google.cloud.dataqna.v1alpha.InterpretError.InterpretErrorDetails.unsupported_details:type_name -> google.cloud.dataqna.v1alpha.InterpretError.InterpretUnsupportedDetails
	15, // 20: google.cloud.dataqna.v1alpha.InterpretError.InterpretErrorDetails.incomplete_query_details:type_name -> google.cloud.dataqna.v1alpha.InterpretError.InterpretIncompleteQueryDetails
	16, // 21: google.cloud.dataqna.v1alpha.InterpretError.InterpretErrorDetails.ambiguity_details:type_name -> google.cloud.dataqna.v1alpha.InterpretError.InterpretAmbiguityDetails
	0,  // 22: google.cloud.dataqna.v1alpha.InterpretError.InterpretIncompleteQueryDetails.entities:type_name -> google.cloud.dataqna.v1alpha.InterpretEntity
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_dataqna_v1alpha_question_proto_init() }
func file_google_cloud_dataqna_v1alpha_question_proto_init() {
	if File_google_cloud_dataqna_v1alpha_question_proto != nil {
		return
	}
	file_google_cloud_dataqna_v1alpha_annotated_string_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Question); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterpretError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Interpretation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HumanReadable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterpretationStructure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DebugFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterpretError_InterpretErrorDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterpretError_InterpretUnsupportedDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterpretError_InterpretIncompleteQueryDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterpretError_InterpretAmbiguityDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataqna_v1alpha_question_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterpretationStructure_ColumnInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataqna_v1alpha_question_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataqna_v1alpha_question_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataqna_v1alpha_question_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataqna_v1alpha_question_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataqna_v1alpha_question_proto_msgTypes,
	}.Build()
	File_google_cloud_dataqna_v1alpha_question_proto = out.File
	file_google_cloud_dataqna_v1alpha_question_proto_rawDesc = nil
	file_google_cloud_dataqna_v1alpha_question_proto_goTypes = nil
	file_google_cloud_dataqna_v1alpha_question_proto_depIdxs = nil
}
