// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/commerce/consumer/procurement/v1/order.proto

package procurementpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of a line item change.
type LineItemChangeType int32

const (
	// Sentinel value. Do not use.
	LineItemChangeType_LINE_ITEM_CHANGE_TYPE_UNSPECIFIED LineItemChangeType = 0
	// The change is to create a new line item.
	LineItemChangeType_LINE_ITEM_CHANGE_TYPE_CREATE LineItemChangeType = 1
	// The change is to update an existing line item.
	LineItemChangeType_LINE_ITEM_CHANGE_TYPE_UPDATE LineItemChangeType = 2
	// The change is to cancel an existing line item.
	LineItemChangeType_LINE_ITEM_CHANGE_TYPE_CANCEL LineItemChangeType = 3
	// The change is to revert a cancellation.
	LineItemChangeType_LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION LineItemChangeType = 4
)

// Enum value maps for LineItemChangeType.
var (
	LineItemChangeType_name = map[int32]string{
		0: "LINE_ITEM_CHANGE_TYPE_UNSPECIFIED",
		1: "LINE_ITEM_CHANGE_TYPE_CREATE",
		2: "LINE_ITEM_CHANGE_TYPE_UPDATE",
		3: "LINE_ITEM_CHANGE_TYPE_CANCEL",
		4: "LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION",
	}
	LineItemChangeType_value = map[string]int32{
		"LINE_ITEM_CHANGE_TYPE_UNSPECIFIED":         0,
		"LINE_ITEM_CHANGE_TYPE_CREATE":              1,
		"LINE_ITEM_CHANGE_TYPE_UPDATE":              2,
		"LINE_ITEM_CHANGE_TYPE_CANCEL":              3,
		"LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION": 4,
	}
)

func (x LineItemChangeType) Enum() *LineItemChangeType {
	p := new(LineItemChangeType)
	*p = x
	return p
}

func (x LineItemChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LineItemChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_enumTypes[0].Descriptor()
}

func (LineItemChangeType) Type() protoreflect.EnumType {
	return &file_google_cloud_commerce_consumer_procurement_v1_order_proto_enumTypes[0]
}

func (x LineItemChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LineItemChangeType.Descriptor instead.
func (LineItemChangeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{0}
}

// State of a change.
type LineItemChangeState int32

const (
	// Sentinel value. Do not use.
	LineItemChangeState_LINE_ITEM_CHANGE_STATE_UNSPECIFIED LineItemChangeState = 0
	// Change is in this state when a change is initiated and waiting for
	// partner approval.
	LineItemChangeState_LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL LineItemChangeState = 1
	// Change is in this state after it's approved by the partner or auto-approved
	// but before it takes effect. The change can be overwritten
	// or cancelled depending on the new line item info property (pending Private
	// Offer change cannot be cancelled and can only be overwritten by another
	// Private Offer).
	LineItemChangeState_LINE_ITEM_CHANGE_STATE_APPROVED LineItemChangeState = 2
	// Change is in this state after it's been activated.
	LineItemChangeState_LINE_ITEM_CHANGE_STATE_COMPLETED LineItemChangeState = 3
	// Change is in this state if it was rejected by the partner.
	LineItemChangeState_LINE_ITEM_CHANGE_STATE_REJECTED LineItemChangeState = 4
	// Change is in this state if it was abandoned by the user.
	LineItemChangeState_LINE_ITEM_CHANGE_STATE_ABANDONED LineItemChangeState = 5
	// Change is in this state if it's currently being provisioned downstream. The
	// change can't be overwritten or cancelled when it's in this state.
	LineItemChangeState_LINE_ITEM_CHANGE_STATE_ACTIVATING LineItemChangeState = 6
)

// Enum value maps for LineItemChangeState.
var (
	LineItemChangeState_name = map[int32]string{
		0: "LINE_ITEM_CHANGE_STATE_UNSPECIFIED",
		1: "LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL",
		2: "LINE_ITEM_CHANGE_STATE_APPROVED",
		3: "LINE_ITEM_CHANGE_STATE_COMPLETED",
		4: "LINE_ITEM_CHANGE_STATE_REJECTED",
		5: "LINE_ITEM_CHANGE_STATE_ABANDONED",
		6: "LINE_ITEM_CHANGE_STATE_ACTIVATING",
	}
	LineItemChangeState_value = map[string]int32{
		"LINE_ITEM_CHANGE_STATE_UNSPECIFIED":      0,
		"LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL": 1,
		"LINE_ITEM_CHANGE_STATE_APPROVED":         2,
		"LINE_ITEM_CHANGE_STATE_COMPLETED":        3,
		"LINE_ITEM_CHANGE_STATE_REJECTED":         4,
		"LINE_ITEM_CHANGE_STATE_ABANDONED":        5,
		"LINE_ITEM_CHANGE_STATE_ACTIVATING":       6,
	}
)

func (x LineItemChangeState) Enum() *LineItemChangeState {
	p := new(LineItemChangeState)
	*p = x
	return p
}

func (x LineItemChangeState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LineItemChangeState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_enumTypes[1].Descriptor()
}

func (LineItemChangeState) Type() protoreflect.EnumType {
	return &file_google_cloud_commerce_consumer_procurement_v1_order_proto_enumTypes[1]
}

func (x LineItemChangeState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LineItemChangeState.Descriptor instead.
func (LineItemChangeState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{1}
}

// Predefined types for line item change state reason.
type LineItemChangeStateReasonType int32

const (
	// Default value, indicating there's no predefined type for change state
	// reason.
	LineItemChangeStateReasonType_LINE_ITEM_CHANGE_STATE_REASON_TYPE_UNSPECIFIED LineItemChangeStateReasonType = 0
	// Change is in current state due to term expiration.
	LineItemChangeStateReasonType_LINE_ITEM_CHANGE_STATE_REASON_TYPE_EXPIRED LineItemChangeStateReasonType = 1
	// Change is in current state due to user-initiated cancellation.
	LineItemChangeStateReasonType_LINE_ITEM_CHANGE_STATE_REASON_TYPE_USER_CANCELLED LineItemChangeStateReasonType = 2
	// Change is in current state due to system-initiated cancellation.
	LineItemChangeStateReasonType_LINE_ITEM_CHANGE_STATE_REASON_TYPE_SYSTEM_CANCELLED LineItemChangeStateReasonType = 3
)

// Enum value maps for LineItemChangeStateReasonType.
var (
	LineItemChangeStateReasonType_name = map[int32]string{
		0: "LINE_ITEM_CHANGE_STATE_REASON_TYPE_UNSPECIFIED",
		1: "LINE_ITEM_CHANGE_STATE_REASON_TYPE_EXPIRED",
		2: "LINE_ITEM_CHANGE_STATE_REASON_TYPE_USER_CANCELLED",
		3: "LINE_ITEM_CHANGE_STATE_REASON_TYPE_SYSTEM_CANCELLED",
	}
	LineItemChangeStateReasonType_value = map[string]int32{
		"LINE_ITEM_CHANGE_STATE_REASON_TYPE_UNSPECIFIED":      0,
		"LINE_ITEM_CHANGE_STATE_REASON_TYPE_EXPIRED":          1,
		"LINE_ITEM_CHANGE_STATE_REASON_TYPE_USER_CANCELLED":   2,
		"LINE_ITEM_CHANGE_STATE_REASON_TYPE_SYSTEM_CANCELLED": 3,
	}
)

func (x LineItemChangeStateReasonType) Enum() *LineItemChangeStateReasonType {
	p := new(LineItemChangeStateReasonType)
	*p = x
	return p
}

func (x LineItemChangeStateReasonType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LineItemChangeStateReasonType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_enumTypes[2].Descriptor()
}

func (LineItemChangeStateReasonType) Type() protoreflect.EnumType {
	return &file_google_cloud_commerce_consumer_procurement_v1_order_proto_enumTypes[2]
}

func (x LineItemChangeStateReasonType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LineItemChangeStateReasonType.Descriptor instead.
func (LineItemChangeStateReasonType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{2}
}

// Represents a purchase made by a customer on Cloud Marketplace.
// Creating an order makes sure that both the Google backend systems
// as well as external service provider's systems (if needed) allow use of
// purchased products and ensures the appropriate billing events occur.
//
// An Order can be made against one Product with multiple add-ons (optional) or
// one Quote which might reference multiple products.
//
// Customers typically choose a price plan for each Product purchased when
// they create an order and can change their plan later, if the product allows.
type Order struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the order.
	// Has the form
	// `billingAccounts/{billing_account}/orders/{order}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user-specified name of the order.
	DisplayName string `protobuf:"bytes,10,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The items being purchased.
	LineItems []*LineItem `protobuf:"bytes,6,rep,name=line_items,json=lineItems,proto3" json:"line_items,omitempty"`
	// Output only. Line items that were cancelled.
	CancelledLineItems []*LineItem `protobuf:"bytes,7,rep,name=cancelled_line_items,json=cancelledLineItems,proto3" json:"cancelled_line_items,omitempty"`
	// Output only. The creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The weak etag of the order.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Order) Reset() {
	*x = Order{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Order) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Order) ProtoMessage() {}

func (x *Order) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Order.ProtoReflect.Descriptor instead.
func (*Order) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{0}
}

func (x *Order) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Order) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Order) GetLineItems() []*LineItem {
	if x != nil {
		return x.LineItems
	}
	return nil
}

func (x *Order) GetCancelledLineItems() []*LineItem {
	if x != nil {
		return x.CancelledLineItems
	}
	return nil
}

func (x *Order) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Order) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Order) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A single item within an order.
type LineItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Line item ID.
	LineItemId string `protobuf:"bytes,1,opt,name=line_item_id,json=lineItemId,proto3" json:"line_item_id,omitempty"`
	// Output only. Current state and information of this item. It tells what,
	// e.g. which offer, is currently effective.
	LineItemInfo *LineItemInfo `protobuf:"bytes,2,opt,name=line_item_info,json=lineItemInfo,proto3" json:"line_item_info,omitempty"`
	// Output only. A change made on the item which is pending and not yet
	// effective. Absence of this field indicates the line item is not undergoing
	// a change.
	PendingChange *LineItemChange `protobuf:"bytes,3,opt,name=pending_change,json=pendingChange,proto3" json:"pending_change,omitempty"`
	// Output only. Changes made on the item that are not pending anymore which
	// might be because they already took effect, were reverted by the customer,
	// or were rejected by the partner. No more operations are allowed on these
	// changes.
	ChangeHistory []*LineItemChange `protobuf:"bytes,4,rep,name=change_history,json=changeHistory,proto3" json:"change_history,omitempty"`
}

func (x *LineItem) Reset() {
	*x = LineItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LineItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LineItem) ProtoMessage() {}

func (x *LineItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LineItem.ProtoReflect.Descriptor instead.
func (*LineItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{1}
}

func (x *LineItem) GetLineItemId() string {
	if x != nil {
		return x.LineItemId
	}
	return ""
}

func (x *LineItem) GetLineItemInfo() *LineItemInfo {
	if x != nil {
		return x.LineItemInfo
	}
	return nil
}

func (x *LineItem) GetPendingChange() *LineItemChange {
	if x != nil {
		return x.PendingChange
	}
	return nil
}

func (x *LineItem) GetChangeHistory() []*LineItemChange {
	if x != nil {
		return x.ChangeHistory
	}
	return nil
}

// A change made on a line item.
type LineItemChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Change ID.
	// All changes made within one order update operation have the same change_id.
	ChangeId string `protobuf:"bytes,1,opt,name=change_id,json=changeId,proto3" json:"change_id,omitempty"`
	// Required. Type of the change to make.
	ChangeType LineItemChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=google.cloud.commerce.consumer.procurement.v1.LineItemChangeType" json:"change_type,omitempty"`
	// Output only. Line item info before the change.
	OldLineItemInfo *LineItemInfo `protobuf:"bytes,3,opt,name=old_line_item_info,json=oldLineItemInfo,proto3" json:"old_line_item_info,omitempty"`
	// Line item info after the change.
	NewLineItemInfo *LineItemInfo `protobuf:"bytes,4,opt,name=new_line_item_info,json=newLineItemInfo,proto3" json:"new_line_item_info,omitempty"`
	// Output only. State of the change.
	ChangeState LineItemChangeState `protobuf:"varint,5,opt,name=change_state,json=changeState,proto3,enum=google.cloud.commerce.consumer.procurement.v1.LineItemChangeState" json:"change_state,omitempty"`
	// Output only. Provider-supplied message explaining the LineItemChange's
	// state. Mainly used to communicate progress and ETA for provisioning in the
	// case of `PENDING_APPROVAL`, and to explain why the change request was
	// denied or canceled in the case of `REJECTED` and `CANCELED` states.
	StateReason string `protobuf:"bytes,6,opt,name=state_reason,json=stateReason,proto3" json:"state_reason,omitempty"`
	// Output only. Predefined enum types for why this line item change is in
	// current state. For example, a line item change's state could be
	// `LINE_ITEM_CHANGE_STATE_COMPLETED` because of end-of-term expiration,
	// immediate cancellation initiated by the user, or system-initiated
	// cancellation.
	ChangeStateReasonType LineItemChangeStateReasonType `protobuf:"varint,10,opt,name=change_state_reason_type,json=changeStateReasonType,proto3,enum=google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType" json:"change_state_reason_type,omitempty"`
	// Output only. A time at which the change became or will become (in case of
	// pending change) effective.
	ChangeEffectiveTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=change_effective_time,json=changeEffectiveTime,proto3" json:"change_effective_time,omitempty"`
	// Output only. The time when change was initiated.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when change was updated, e.g. approved/rejected by
	// partners or cancelled by the user.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *LineItemChange) Reset() {
	*x = LineItemChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LineItemChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LineItemChange) ProtoMessage() {}

func (x *LineItemChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LineItemChange.ProtoReflect.Descriptor instead.
func (*LineItemChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{2}
}

func (x *LineItemChange) GetChangeId() string {
	if x != nil {
		return x.ChangeId
	}
	return ""
}

func (x *LineItemChange) GetChangeType() LineItemChangeType {
	if x != nil {
		return x.ChangeType
	}
	return LineItemChangeType_LINE_ITEM_CHANGE_TYPE_UNSPECIFIED
}

func (x *LineItemChange) GetOldLineItemInfo() *LineItemInfo {
	if x != nil {
		return x.OldLineItemInfo
	}
	return nil
}

func (x *LineItemChange) GetNewLineItemInfo() *LineItemInfo {
	if x != nil {
		return x.NewLineItemInfo
	}
	return nil
}

func (x *LineItemChange) GetChangeState() LineItemChangeState {
	if x != nil {
		return x.ChangeState
	}
	return LineItemChangeState_LINE_ITEM_CHANGE_STATE_UNSPECIFIED
}

func (x *LineItemChange) GetStateReason() string {
	if x != nil {
		return x.StateReason
	}
	return ""
}

func (x *LineItemChange) GetChangeStateReasonType() LineItemChangeStateReasonType {
	if x != nil {
		return x.ChangeStateReasonType
	}
	return LineItemChangeStateReasonType_LINE_ITEM_CHANGE_STATE_REASON_TYPE_UNSPECIFIED
}

func (x *LineItemChange) GetChangeEffectiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ChangeEffectiveTime
	}
	return nil
}

func (x *LineItemChange) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *LineItemChange) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Line item information.
type LineItemInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the offer can have either of these formats:
	// 'billingAccounts/{billing_account}/offers/{offer}',
	// or 'services/{service}/standardOffers/{offer}'.
	Offer string `protobuf:"bytes,13,opt,name=offer,proto3" json:"offer,omitempty"`
	// Optional. User-provided parameters.
	Parameters []*Parameter `protobuf:"bytes,9,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Output only. Information about the subscription created, if applicable.
	Subscription *Subscription `protobuf:"bytes,10,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *LineItemInfo) Reset() {
	*x = LineItemInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LineItemInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LineItemInfo) ProtoMessage() {}

func (x *LineItemInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LineItemInfo.ProtoReflect.Descriptor instead.
func (*LineItemInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{3}
}

func (x *LineItemInfo) GetOffer() string {
	if x != nil {
		return x.Offer
	}
	return ""
}

func (x *LineItemInfo) GetParameters() []*Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *LineItemInfo) GetSubscription() *Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

// User-provided Parameters.
type Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value of parameter.
	Value *Parameter_Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Parameter) Reset() {
	*x = Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Parameter) ProtoMessage() {}

func (x *Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Parameter.ProtoReflect.Descriptor instead.
func (*Parameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{4}
}

func (x *Parameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Parameter) GetValue() *Parameter_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

// Subscription information.
type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp when the subscription begins, if applicable.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The timestamp when the subscription ends, if applicable.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Whether auto renewal is enabled by user choice on current subscription.
	// This field indicates order/subscription status after pending plan change is
	// cancelled or rejected.
	AutoRenewalEnabled bool `protobuf:"varint,2,opt,name=auto_renewal_enabled,json=autoRenewalEnabled,proto3" json:"auto_renewal_enabled,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{5}
}

func (x *Subscription) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Subscription) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Subscription) GetAutoRenewalEnabled() bool {
	if x != nil {
		return x.AutoRenewalEnabled
	}
	return false
}

type Parameter_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of value.
	//
	// Types that are assignable to Kind:
	//	*Parameter_Value_Int64Value
	//	*Parameter_Value_StringValue
	//	*Parameter_Value_DoubleValue
	Kind isParameter_Value_Kind `protobuf_oneof:"kind"`
}

func (x *Parameter_Value) Reset() {
	*x = Parameter_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Parameter_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Parameter_Value) ProtoMessage() {}

func (x *Parameter_Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Parameter_Value.ProtoReflect.Descriptor instead.
func (*Parameter_Value) Descriptor() ([]byte, []int) {
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP(), []int{4, 0}
}

func (m *Parameter_Value) GetKind() isParameter_Value_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Parameter_Value) GetInt64Value() int64 {
	if x, ok := x.GetKind().(*Parameter_Value_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *Parameter_Value) GetStringValue() string {
	if x, ok := x.GetKind().(*Parameter_Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Parameter_Value) GetDoubleValue() float64 {
	if x, ok := x.GetKind().(*Parameter_Value_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

type isParameter_Value_Kind interface {
	isParameter_Value_Kind()
}

type Parameter_Value_Int64Value struct {
	// Represents an int64 value.
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type Parameter_Value_StringValue struct {
	// Represents a string value.
	StringValue string `protobuf:"bytes,4,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Parameter_Value_DoubleValue struct {
	// Represents a double value.
	DoubleValue float64 `protobuf:"fixed64,5,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*Parameter_Value_Int64Value) isParameter_Value_Kind() {}

func (*Parameter_Value_StringValue) isParameter_Value_Kind() {}

func (*Parameter_Value_DoubleValue) isParameter_Value_Kind() {}

var File_google_cloud_commerce_consumer_procurement_v1_order_proto protoreflect.FileDescriptor

var file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x2f, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72,
	0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9b, 0x04, 0x0a, 0x05, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0a, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12,
	0x6e, 0x0a, 0x14, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x65, 0x64, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x35, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x12, 0x30, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x7d, 0x22, 0xef, 0x02, 0x0a, 0x08, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74,
	0x65, 0x6d, 0x12, 0x25, 0x0a, 0x0c, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6c,
	0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x66, 0x0a, 0x0e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x69, 0x0a, 0x0e, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74,
	0x65, 0x6d, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70,
	0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x69, 0x0a, 0x0e,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x22, 0xee, 0x06, 0x0a, 0x0e, 0x4c, 0x69, 0x6e, 0x65,
	0x49, 0x74, 0x65, 0x6d, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x64, 0x12, 0x67, 0x0a, 0x0b,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x6d, 0x0a, 0x12, 0x6f, 0x6c, 0x64, 0x5f, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6f, 0x6c, 0x64, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x68, 0x0a, 0x12, 0x6e, 0x65, 0x77, 0x5f, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x6e,
	0x65, 0x77, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x6a,
	0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x12, 0x8a, 0x01, 0x0a, 0x18, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x53, 0x0a, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x13, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x9c, 0x02, 0x0a, 0x0c, 0x4c, 0x69, 0x6e,
	0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x47, 0x0a, 0x05, 0x6f, 0x66, 0x66,
	0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2b,
	0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x66, 0x66,
	0x65, 0x72, 0x12, 0x5d, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x64, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf3, 0x01, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a,
	0x7c, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xb2, 0x01,
	0x0a, 0x0c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x30, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12,
	0x61, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x2a, 0xd0, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x4c, 0x49, 0x4e,
	0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x20, 0x0a, 0x1c, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x48,
	0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45,
	0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x10, 0x03, 0x12, 0x2d, 0x0a, 0x29, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49,
	0x54, 0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x52, 0x45, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x04, 0x2a, 0xa7, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74,
	0x65, 0x6d, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a,
	0x22, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47,
	0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2b, 0x0a, 0x27, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54,
	0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c,
	0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x50, 0x50,
	0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x02, 0x12, 0x24, 0x0a, 0x20, 0x4c, 0x49, 0x4e, 0x45, 0x5f,
	0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x23, 0x0a,
	0x1f, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47,
	0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44,
	0x10, 0x04, 0x12, 0x24, 0x0a, 0x20, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f,
	0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x42, 0x41,
	0x4e, 0x44, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x05, 0x12, 0x25, 0x0a, 0x21, 0x4c, 0x49, 0x4e, 0x45,
	0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x2a,
	0xf3, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x32, 0x0a, 0x2e, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x53,
	0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2e, 0x0a, 0x2a, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54,
	0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x50, 0x49,
	0x52, 0x45, 0x44, 0x10, 0x01, 0x12, 0x35, 0x0a, 0x31, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54,
	0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52,
	0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x37, 0x0a, 0x33,
	0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x45, 0x44, 0x10, 0x03, 0x42, 0xb4, 0x03, 0xea, 0x41, 0x91, 0x01, 0x0a, 0x29, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x12, 0x29, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x74, 0x61, 0x6e,
	0x64, 0x61, 0x72, 0x64, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f, 0x66, 0x66, 0x65,
	0x72, 0x7d, 0x12, 0x39, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x62, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x7d, 0x0a, 0x31, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65,
	0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x70, 0x72, 0x6f, 0x63, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xaa, 0x02, 0x2d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x2e,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x2d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x5c,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5c, 0x50, 0x72, 0x6f, 0x63, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x32, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63,
	0x65, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x3a, 0x3a, 0x50, 0x72, 0x6f,
	0x63, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescOnce sync.Once
	file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescData = file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDesc
)

func file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescGZIP() []byte {
	file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescOnce.Do(func() {
		file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescData)
	})
	return file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDescData
}

var file_google_cloud_commerce_consumer_procurement_v1_order_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_commerce_consumer_procurement_v1_order_proto_goTypes = []interface{}{
	(LineItemChangeType)(0),            // 0: google.cloud.commerce.consumer.procurement.v1.LineItemChangeType
	(LineItemChangeState)(0),           // 1: google.cloud.commerce.consumer.procurement.v1.LineItemChangeState
	(LineItemChangeStateReasonType)(0), // 2: google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType
	(*Order)(nil),                      // 3: google.cloud.commerce.consumer.procurement.v1.Order
	(*LineItem)(nil),                   // 4: google.cloud.commerce.consumer.procurement.v1.LineItem
	(*LineItemChange)(nil),             // 5: google.cloud.commerce.consumer.procurement.v1.LineItemChange
	(*LineItemInfo)(nil),               // 6: google.cloud.commerce.consumer.procurement.v1.LineItemInfo
	(*Parameter)(nil),                  // 7: google.cloud.commerce.consumer.procurement.v1.Parameter
	(*Subscription)(nil),               // 8: google.cloud.commerce.consumer.procurement.v1.Subscription
	(*Parameter_Value)(nil),            // 9: google.cloud.commerce.consumer.procurement.v1.Parameter.Value
	(*timestamppb.Timestamp)(nil),      // 10: google.protobuf.Timestamp
}
var file_google_cloud_commerce_consumer_procurement_v1_order_proto_depIdxs = []int32{
	4,  // 0: google.cloud.commerce.consumer.procurement.v1.Order.line_items:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItem
	4,  // 1: google.cloud.commerce.consumer.procurement.v1.Order.cancelled_line_items:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItem
	10, // 2: google.cloud.commerce.consumer.procurement.v1.Order.create_time:type_name -> google.protobuf.Timestamp
	10, // 3: google.cloud.commerce.consumer.procurement.v1.Order.update_time:type_name -> google.protobuf.Timestamp
	6,  // 4: google.cloud.commerce.consumer.procurement.v1.LineItem.line_item_info:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemInfo
	5,  // 5: google.cloud.commerce.consumer.procurement.v1.LineItem.pending_change:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemChange
	5,  // 6: google.cloud.commerce.consumer.procurement.v1.LineItem.change_history:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemChange
	0,  // 7: google.cloud.commerce.consumer.procurement.v1.LineItemChange.change_type:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemChangeType
	6,  // 8: google.cloud.commerce.consumer.procurement.v1.LineItemChange.old_line_item_info:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemInfo
	6,  // 9: google.cloud.commerce.consumer.procurement.v1.LineItemChange.new_line_item_info:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemInfo
	1,  // 10: google.cloud.commerce.consumer.procurement.v1.LineItemChange.change_state:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemChangeState
	2,  // 11: google.cloud.commerce.consumer.procurement.v1.LineItemChange.change_state_reason_type:type_name -> google.cloud.commerce.consumer.procurement.v1.LineItemChangeStateReasonType
	10, // 12: google.cloud.commerce.consumer.procurement.v1.LineItemChange.change_effective_time:type_name -> google.protobuf.Timestamp
	10, // 13: google.cloud.commerce.consumer.procurement.v1.LineItemChange.create_time:type_name -> google.protobuf.Timestamp
	10, // 14: google.cloud.commerce.consumer.procurement.v1.LineItemChange.update_time:type_name -> google.protobuf.Timestamp
	7,  // 15: google.cloud.commerce.consumer.procurement.v1.LineItemInfo.parameters:type_name -> google.cloud.commerce.consumer.procurement.v1.Parameter
	8,  // 16: google.cloud.commerce.consumer.procurement.v1.LineItemInfo.subscription:type_name -> google.cloud.commerce.consumer.procurement.v1.Subscription
	9,  // 17: google.cloud.commerce.consumer.procurement.v1.Parameter.value:type_name -> google.cloud.commerce.consumer.procurement.v1.Parameter.Value
	10, // 18: google.cloud.commerce.consumer.procurement.v1.Subscription.start_time:type_name -> google.protobuf.Timestamp
	10, // 19: google.cloud.commerce.consumer.procurement.v1.Subscription.end_time:type_name -> google.protobuf.Timestamp
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_commerce_consumer_procurement_v1_order_proto_init() }
func file_google_cloud_commerce_consumer_procurement_v1_order_proto_init() {
	if File_google_cloud_commerce_consumer_procurement_v1_order_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Order); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LineItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LineItemChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LineItemInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Parameter_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*Parameter_Value_Int64Value)(nil),
		(*Parameter_Value_StringValue)(nil),
		(*Parameter_Value_DoubleValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_commerce_consumer_procurement_v1_order_proto_goTypes,
		DependencyIndexes: file_google_cloud_commerce_consumer_procurement_v1_order_proto_depIdxs,
		EnumInfos:         file_google_cloud_commerce_consumer_procurement_v1_order_proto_enumTypes,
		MessageInfos:      file_google_cloud_commerce_consumer_procurement_v1_order_proto_msgTypes,
	}.Build()
	File_google_cloud_commerce_consumer_procurement_v1_order_proto = out.File
	file_google_cloud_commerce_consumer_procurement_v1_order_proto_rawDesc = nil
	file_google_cloud_commerce_consumer_procurement_v1_order_proto_goTypes = nil
	file_google_cloud_commerce_consumer_procurement_v1_order_proto_depIdxs = nil
}
