// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/workstations/v1beta/workstations.proto

package workstationspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Value representing what should happen to the disk after the workstation
// is deleted.
type WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy int32

const (
	// Do not use.
	WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_RECLAIM_POLICY_UNSPECIFIED WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy = 0
	// The persistent disk will be deleted with the workstation.
	WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_DELETE WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy = 1
	// The persistent disk will be remain after the workstation is deleted,
	// and the administrator must manually delete the disk.
	WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_RETAIN WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy = 2
)

// Enum value maps for WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy.
var (
	WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy_name = map[int32]string{
		0: "RECLAIM_POLICY_UNSPECIFIED",
		1: "DELETE",
		2: "RETAIN",
	}
	WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy_value = map[string]int32{
		"RECLAIM_POLICY_UNSPECIFIED": 0,
		"DELETE":                     1,
		"RETAIN":                     2,
	}
)

func (x WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy) Enum() *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy {
	p := new(WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy)
	*p = x
	return p
}

func (x WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_workstations_v1beta_workstations_proto_enumTypes[0].Descriptor()
}

func (WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_workstations_v1beta_workstations_proto_enumTypes[0]
}

func (x WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy.Descriptor instead.
func (WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 1, 0, 0}
}

// Whether a workstation is running and ready to receive user requests.
type Workstation_State int32

const (
	// Do not use.
	Workstation_STATE_UNSPECIFIED Workstation_State = 0
	// The workstation is not yet ready to accept requests from users but will
	// be soon.
	Workstation_STATE_STARTING Workstation_State = 1
	// The workstation is ready to accept requests from users.
	Workstation_STATE_RUNNING Workstation_State = 2
	// The workstation is being stopped.
	Workstation_STATE_STOPPING Workstation_State = 3
	// The workstation is stopped and will not be able to receive requests until
	// it is started.
	Workstation_STATE_STOPPED Workstation_State = 4
)

// Enum value maps for Workstation_State.
var (
	Workstation_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STATE_STARTING",
		2: "STATE_RUNNING",
		3: "STATE_STOPPING",
		4: "STATE_STOPPED",
	}
	Workstation_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STATE_STARTING":    1,
		"STATE_RUNNING":     2,
		"STATE_STOPPING":    3,
		"STATE_STOPPED":     4,
	}
)

func (x Workstation_State) Enum() *Workstation_State {
	p := new(Workstation_State)
	*p = x
	return p
}

func (x Workstation_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workstation_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_workstations_v1beta_workstations_proto_enumTypes[1].Descriptor()
}

func (Workstation_State) Type() protoreflect.EnumType {
	return &file_google_cloud_workstations_v1beta_workstations_proto_enumTypes[1]
}

func (x Workstation_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workstation_State.Descriptor instead.
func (Workstation_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{2, 0}
}

// A grouping of workstation configurations and the associated workstations
//
//	in that region.
type WorkstationCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full name of this resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human-readable name for this resource.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. A system-assigned unique identified for this resource.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. Indicates whether this resource is currently being updated to
	// match its intended state.
	Reconciling bool `protobuf:"varint,4,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Client-specified annotations.
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Client-specified labels that are applied to the resource and that are also
	// propagated to the underlying Compute Engine resources.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Time when this resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when this resource was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time when this resource was soft-deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Checksum computed by the server. May be sent on update and delete requests
	// to make sure that the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Immutable. Name of the Compute Engine network in which instances associated
	// with this cluster will be created.
	Network string `protobuf:"bytes,10,opt,name=network,proto3" json:"network,omitempty"`
	// Immutable. Name of the Compute Engine subnetwork in which instances
	// associated with this cluster will be created. Must be part of the
	// subnetwork specified for this cluster.
	Subnetwork string `protobuf:"bytes,11,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Output only. The private IP address of the control plane for this cluster.
	// Workstation VMs need access to this IP address to work with the service, so
	// make sure that your firewall rules allow egress from the workstation VMs to
	// this address.
	ControlPlaneIp string `protobuf:"bytes,16,opt,name=control_plane_ip,json=controlPlaneIp,proto3" json:"control_plane_ip,omitempty"`
	// Configuration for private cluster.
	PrivateClusterConfig *WorkstationCluster_PrivateClusterConfig `protobuf:"bytes,12,opt,name=private_cluster_config,json=privateClusterConfig,proto3" json:"private_cluster_config,omitempty"`
	// Output only. Whether this resource is in degraded mode, in which case it
	// may require user action to restore full functionality. Details can be found
	// in the `conditions` field.
	Degraded bool `protobuf:"varint,13,opt,name=degraded,proto3" json:"degraded,omitempty"`
	// Output only. Status conditions describing the current resource state.
	Conditions []*status.Status `protobuf:"bytes,14,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (x *WorkstationCluster) Reset() {
	*x = WorkstationCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationCluster) ProtoMessage() {}

func (x *WorkstationCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationCluster.ProtoReflect.Descriptor instead.
func (*WorkstationCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{0}
}

func (x *WorkstationCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WorkstationCluster) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *WorkstationCluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *WorkstationCluster) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *WorkstationCluster) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *WorkstationCluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *WorkstationCluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *WorkstationCluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *WorkstationCluster) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *WorkstationCluster) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *WorkstationCluster) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *WorkstationCluster) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *WorkstationCluster) GetControlPlaneIp() string {
	if x != nil {
		return x.ControlPlaneIp
	}
	return ""
}

func (x *WorkstationCluster) GetPrivateClusterConfig() *WorkstationCluster_PrivateClusterConfig {
	if x != nil {
		return x.PrivateClusterConfig
	}
	return nil
}

func (x *WorkstationCluster) GetDegraded() bool {
	if x != nil {
		return x.Degraded
	}
	return false
}

func (x *WorkstationCluster) GetConditions() []*status.Status {
	if x != nil {
		return x.Conditions
	}
	return nil
}

// A set of configuration options describing how a workstation will be run.
// Workstation configurations are intended to be shared across multiple
// workstations.
type WorkstationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full name of this resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human-readable name for this resource.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. A system-assigned unique identified for this resource.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. Indicates whether this resource is currently being updated to
	// match its intended state.
	Reconciling bool `protobuf:"varint,4,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Client-specified annotations.
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Client-specified labels that are applied to the resource and that are also
	// propagated to the underlying Compute Engine resources.
	Labels map[string]string `protobuf:"bytes,18,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Time when this resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when this resource was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time when this resource was soft-deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Checksum computed by the server. May be sent on update and delete requests
	// to make sure that the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// How long to wait before automatically stopping an instance that hasn't
	// received any user traffic. A value of 0 indicates that this instance
	// should never time out due to idleness. Defaults to 20 minutes.
	IdleTimeout *durationpb.Duration `protobuf:"bytes,10,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// How long to wait before automatically stopping a workstation after it
	// started. A value of 0 indicates that workstations using this configuration
	// should never time out. Must be greater than 0 and less than 24 hours if
	// encryption_key is set. Defaults to 12 hours.
	RunningTimeout *durationpb.Duration `protobuf:"bytes,11,opt,name=running_timeout,json=runningTimeout,proto3" json:"running_timeout,omitempty"`
	// Runtime host for the workstation.
	Host *WorkstationConfig_Host `protobuf:"bytes,12,opt,name=host,proto3" json:"host,omitempty"`
	// Directories to persist across workstation sessions.
	PersistentDirectories []*WorkstationConfig_PersistentDirectory `protobuf:"bytes,13,rep,name=persistent_directories,json=persistentDirectories,proto3" json:"persistent_directories,omitempty"`
	// Container that will be run for each workstation using this configuration
	// when that workstation is started.
	Container *WorkstationConfig_Container `protobuf:"bytes,14,opt,name=container,proto3" json:"container,omitempty"`
	// Immutable. Encrypts resources of this workstation configuration using a
	// customer-managed encryption key.
	//
	// If specified, the boot disk of the Compute Engine instance and the
	// persistent disk are encrypted using this encryption key. If
	// this field is not set, the disks are encrypted using a generated
	// key. Customer-managed encryption keys do not protect disk metadata.
	//
	// If the customer-managed encryption key is rotated, when the workstation
	// instance is stopped, the system attempts to recreate the
	// persistent disk with the new version of the key. Be sure to keep
	// older versions of the key until the persistent disk is recreated.
	// Otherwise, data on the persistent disk will be lost.
	//
	// If the encryption key is revoked, the workstation session will
	// automatically be stopped within 7 hours.
	//
	// Immutable after the workstation configuration is created.
	EncryptionKey *WorkstationConfig_CustomerEncryptionKey `protobuf:"bytes,17,opt,name=encryption_key,json=encryptionKey,proto3" json:"encryption_key,omitempty"`
	// Readiness checks to perform when starting a workstation using this
	// workstation configuration. Mark a workstation as running only after all
	// specified readiness checks return 200 status codes.
	ReadinessChecks []*WorkstationConfig_ReadinessCheck `protobuf:"bytes,19,rep,name=readiness_checks,json=readinessChecks,proto3" json:"readiness_checks,omitempty"`
	// Output only. Whether this resource is in degraded mode, in which case it
	// may require user action to restore full functionality. Details can be found
	// in the `conditions` field.
	Degraded bool `protobuf:"varint,15,opt,name=degraded,proto3" json:"degraded,omitempty"`
	// Output only. Status conditions describing the current resource state.
	Conditions []*status.Status `protobuf:"bytes,16,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// Whether to enable linux auditd logging on the workstation. When enabled, a
	// service account must also be specified that has logging.buckets.write
	// permission on the project. Operating system audit logging is distinct from
	// [Cloud Audit
	// Logs](https://cloud.google.com/workstations/docs/audit-logging).
	EnableAuditAgent bool `protobuf:"varint,20,opt,name=enable_audit_agent,json=enableAuditAgent,proto3" json:"enable_audit_agent,omitempty"`
}

func (x *WorkstationConfig) Reset() {
	*x = WorkstationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig) ProtoMessage() {}

func (x *WorkstationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig.ProtoReflect.Descriptor instead.
func (*WorkstationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1}
}

func (x *WorkstationConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WorkstationConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *WorkstationConfig) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *WorkstationConfig) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *WorkstationConfig) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *WorkstationConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *WorkstationConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *WorkstationConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *WorkstationConfig) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *WorkstationConfig) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *WorkstationConfig) GetIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

func (x *WorkstationConfig) GetRunningTimeout() *durationpb.Duration {
	if x != nil {
		return x.RunningTimeout
	}
	return nil
}

func (x *WorkstationConfig) GetHost() *WorkstationConfig_Host {
	if x != nil {
		return x.Host
	}
	return nil
}

func (x *WorkstationConfig) GetPersistentDirectories() []*WorkstationConfig_PersistentDirectory {
	if x != nil {
		return x.PersistentDirectories
	}
	return nil
}

func (x *WorkstationConfig) GetContainer() *WorkstationConfig_Container {
	if x != nil {
		return x.Container
	}
	return nil
}

func (x *WorkstationConfig) GetEncryptionKey() *WorkstationConfig_CustomerEncryptionKey {
	if x != nil {
		return x.EncryptionKey
	}
	return nil
}

func (x *WorkstationConfig) GetReadinessChecks() []*WorkstationConfig_ReadinessCheck {
	if x != nil {
		return x.ReadinessChecks
	}
	return nil
}

func (x *WorkstationConfig) GetDegraded() bool {
	if x != nil {
		return x.Degraded
	}
	return false
}

func (x *WorkstationConfig) GetConditions() []*status.Status {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *WorkstationConfig) GetEnableAuditAgent() bool {
	if x != nil {
		return x.EnableAuditAgent
	}
	return false
}

// A single instance of a developer workstation with its own persistent storage.
type Workstation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full name of this resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human-readable name for this resource.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. A system-assigned unique identified for this resource.
	Uid string `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. Indicates whether this resource is currently being updated to
	// match its intended state.
	Reconciling bool `protobuf:"varint,4,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Client-specified annotations.
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Client-specified labels that are applied to the resource and that are also
	// propagated to the underlying Compute Engine resources.
	Labels map[string]string `protobuf:"bytes,13,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Time when this resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when this resource was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time when this resource was soft-deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Checksum computed by the server. May be sent on update and delete requests
	// to make sure that the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Current state of the workstation.
	State Workstation_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.workstations.v1beta.Workstation_State" json:"state,omitempty"`
	// Output only. Host to which clients can send HTTPS traffic that will be
	// received by the workstation. Authorized traffic will be received to the
	// workstation as HTTP on port 80. To send traffic to a different port,
	// clients may prefix the host with the destination port in the format
	// `{port}-{host}`.
	Host string `protobuf:"bytes,11,opt,name=host,proto3" json:"host,omitempty"`
	// Environment variables passed to the workstation container's entrypoint.
	Env map[string]string `protobuf:"bytes,12,rep,name=env,proto3" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Workstation) Reset() {
	*x = Workstation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workstation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workstation) ProtoMessage() {}

func (x *Workstation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workstation.ProtoReflect.Descriptor instead.
func (*Workstation) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{2}
}

func (x *Workstation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Workstation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Workstation) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Workstation) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *Workstation) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Workstation) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Workstation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Workstation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Workstation) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Workstation) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Workstation) GetState() Workstation_State {
	if x != nil {
		return x.State
	}
	return Workstation_STATE_UNSPECIFIED
}

func (x *Workstation) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *Workstation) GetEnv() map[string]string {
	if x != nil {
		return x.Env
	}
	return nil
}

// Request message for GetWorkstationCluster.
type GetWorkstationClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the requested resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkstationClusterRequest) Reset() {
	*x = GetWorkstationClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkstationClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkstationClusterRequest) ProtoMessage() {}

func (x *GetWorkstationClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkstationClusterRequest.ProtoReflect.Descriptor instead.
func (*GetWorkstationClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{3}
}

func (x *GetWorkstationClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListWorkstationClusters.
type ListWorkstationClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListWorkstationClustersRequest) Reset() {
	*x = ListWorkstationClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkstationClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkstationClustersRequest) ProtoMessage() {}

func (x *ListWorkstationClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkstationClustersRequest.ProtoReflect.Descriptor instead.
func (*ListWorkstationClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{4}
}

func (x *ListWorkstationClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkstationClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkstationClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListWorkstationClusters.
type ListWorkstationClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested workstation clusters.
	WorkstationClusters []*WorkstationCluster `protobuf:"bytes,1,rep,name=workstation_clusters,json=workstationClusters,proto3" json:"workstation_clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListWorkstationClustersResponse) Reset() {
	*x = ListWorkstationClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkstationClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkstationClustersResponse) ProtoMessage() {}

func (x *ListWorkstationClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkstationClustersResponse.ProtoReflect.Descriptor instead.
func (*ListWorkstationClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{5}
}

func (x *ListWorkstationClustersResponse) GetWorkstationClusters() []*WorkstationCluster {
	if x != nil {
		return x.WorkstationClusters
	}
	return nil
}

func (x *ListWorkstationClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListWorkstationClustersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for creating a CreateWorkstationCluster.
type CreateWorkstationClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID to use for the workstation cluster.
	WorkstationClusterId string `protobuf:"bytes,2,opt,name=workstation_cluster_id,json=workstationClusterId,proto3" json:"workstation_cluster_id,omitempty"`
	// Required. Workstation cluster to create.
	WorkstationCluster *WorkstationCluster `protobuf:"bytes,3,opt,name=workstation_cluster,json=workstationCluster,proto3" json:"workstation_cluster,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateWorkstationClusterRequest) Reset() {
	*x = CreateWorkstationClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkstationClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkstationClusterRequest) ProtoMessage() {}

func (x *CreateWorkstationClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkstationClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkstationClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{6}
}

func (x *CreateWorkstationClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkstationClusterRequest) GetWorkstationClusterId() string {
	if x != nil {
		return x.WorkstationClusterId
	}
	return ""
}

func (x *CreateWorkstationClusterRequest) GetWorkstationCluster() *WorkstationCluster {
	if x != nil {
		return x.WorkstationCluster
	}
	return nil
}

func (x *CreateWorkstationClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for UpdateWorkstationCluster.
type UpdateWorkstationClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Workstation cluster to update.
	WorkstationCluster *WorkstationCluster `protobuf:"bytes,1,opt,name=workstation_cluster,json=workstationCluster,proto3" json:"workstation_cluster,omitempty"`
	// Required. Mask that specifies which fields in the workstation cluster
	// should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set, and the workstation cluster is not found, a new workstation
	// cluster will be created. In this situation, update_mask is ignored.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateWorkstationClusterRequest) Reset() {
	*x = UpdateWorkstationClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkstationClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkstationClusterRequest) ProtoMessage() {}

func (x *UpdateWorkstationClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkstationClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkstationClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateWorkstationClusterRequest) GetWorkstationCluster() *WorkstationCluster {
	if x != nil {
		return x.WorkstationCluster
	}
	return nil
}

func (x *UpdateWorkstationClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateWorkstationClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateWorkstationClusterRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Message for deleting a workstation cluster.
type DeleteWorkstationClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the workstation cluster to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the review, but do not apply it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set, the request will be rejected if the latest version of the
	// workstation cluster on the server does not have this ETag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// If set, any workstation configurations and workstations in the
	// workstation cluster are also deleted. Otherwise, the request only
	// works if the workstation cluster has no configurations or workstations.
	Force bool `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteWorkstationClusterRequest) Reset() {
	*x = DeleteWorkstationClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkstationClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkstationClusterRequest) ProtoMessage() {}

func (x *DeleteWorkstationClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkstationClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkstationClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteWorkstationClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteWorkstationClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteWorkstationClusterRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteWorkstationClusterRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for GetWorkstationConfig.
type GetWorkstationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the requested resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkstationConfigRequest) Reset() {
	*x = GetWorkstationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkstationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkstationConfigRequest) ProtoMessage() {}

func (x *GetWorkstationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkstationConfigRequest.ProtoReflect.Descriptor instead.
func (*GetWorkstationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{9}
}

func (x *GetWorkstationConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListWorkstationConfigs.
type ListWorkstationConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListWorkstationConfigsRequest) Reset() {
	*x = ListWorkstationConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkstationConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkstationConfigsRequest) ProtoMessage() {}

func (x *ListWorkstationConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkstationConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkstationConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{10}
}

func (x *ListWorkstationConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkstationConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkstationConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListWorkstationConfigs.
type ListWorkstationConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested configs.
	WorkstationConfigs []*WorkstationConfig `protobuf:"bytes,1,rep,name=workstation_configs,json=workstationConfigs,proto3" json:"workstation_configs,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListWorkstationConfigsResponse) Reset() {
	*x = ListWorkstationConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkstationConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkstationConfigsResponse) ProtoMessage() {}

func (x *ListWorkstationConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkstationConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkstationConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{11}
}

func (x *ListWorkstationConfigsResponse) GetWorkstationConfigs() []*WorkstationConfig {
	if x != nil {
		return x.WorkstationConfigs
	}
	return nil
}

func (x *ListWorkstationConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListWorkstationConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for ListUsableWorkstationConfigs.
type ListUsableWorkstationConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListUsableWorkstationConfigsRequest) Reset() {
	*x = ListUsableWorkstationConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUsableWorkstationConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsableWorkstationConfigsRequest) ProtoMessage() {}

func (x *ListUsableWorkstationConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsableWorkstationConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListUsableWorkstationConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{12}
}

func (x *ListUsableWorkstationConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUsableWorkstationConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUsableWorkstationConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListUsableWorkstationConfigs.
type ListUsableWorkstationConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested configs.
	WorkstationConfigs []*WorkstationConfig `protobuf:"bytes,1,rep,name=workstation_configs,json=workstationConfigs,proto3" json:"workstation_configs,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListUsableWorkstationConfigsResponse) Reset() {
	*x = ListUsableWorkstationConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUsableWorkstationConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsableWorkstationConfigsResponse) ProtoMessage() {}

func (x *ListUsableWorkstationConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsableWorkstationConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListUsableWorkstationConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{13}
}

func (x *ListUsableWorkstationConfigsResponse) GetWorkstationConfigs() []*WorkstationConfig {
	if x != nil {
		return x.WorkstationConfigs
	}
	return nil
}

func (x *ListUsableWorkstationConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListUsableWorkstationConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for creating a CreateWorkstationConfig.
type CreateWorkstationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID to use for the workstation configuration.
	WorkstationConfigId string `protobuf:"bytes,2,opt,name=workstation_config_id,json=workstationConfigId,proto3" json:"workstation_config_id,omitempty"`
	// Required. Config to create.
	WorkstationConfig *WorkstationConfig `protobuf:"bytes,3,opt,name=workstation_config,json=workstationConfig,proto3" json:"workstation_config,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateWorkstationConfigRequest) Reset() {
	*x = CreateWorkstationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkstationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkstationConfigRequest) ProtoMessage() {}

func (x *CreateWorkstationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkstationConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkstationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{14}
}

func (x *CreateWorkstationConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkstationConfigRequest) GetWorkstationConfigId() string {
	if x != nil {
		return x.WorkstationConfigId
	}
	return ""
}

func (x *CreateWorkstationConfigRequest) GetWorkstationConfig() *WorkstationConfig {
	if x != nil {
		return x.WorkstationConfig
	}
	return nil
}

func (x *CreateWorkstationConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for UpdateWorkstationConfig.
type UpdateWorkstationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Config to update.
	WorkstationConfig *WorkstationConfig `protobuf:"bytes,1,opt,name=workstation_config,json=workstationConfig,proto3" json:"workstation_config,omitempty"`
	// Required. Mask specifying which fields in the workstation configuration
	// should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set and the workstation configuration is not found, a new
	// workstation configuration will be created. In this situation,
	// update_mask is ignored.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateWorkstationConfigRequest) Reset() {
	*x = UpdateWorkstationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkstationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkstationConfigRequest) ProtoMessage() {}

func (x *UpdateWorkstationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkstationConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkstationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateWorkstationConfigRequest) GetWorkstationConfig() *WorkstationConfig {
	if x != nil {
		return x.WorkstationConfig
	}
	return nil
}

func (x *UpdateWorkstationConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateWorkstationConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateWorkstationConfigRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Message for deleting a workstation configuration.
type DeleteWorkstationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the workstation configuration to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set, the request is rejected if the latest version of the
	// workstation configuration on the server does not have this ETag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// If set, any workstations in the workstation configuration are also deleted.
	// Otherwise, the request works only if the workstation configuration has
	// no workstations.
	Force bool `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteWorkstationConfigRequest) Reset() {
	*x = DeleteWorkstationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkstationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkstationConfigRequest) ProtoMessage() {}

func (x *DeleteWorkstationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkstationConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkstationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteWorkstationConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteWorkstationConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteWorkstationConfigRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteWorkstationConfigRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for GetWorkstation.
type GetWorkstationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the requested resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkstationRequest) Reset() {
	*x = GetWorkstationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkstationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkstationRequest) ProtoMessage() {}

func (x *GetWorkstationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkstationRequest.ProtoReflect.Descriptor instead.
func (*GetWorkstationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{17}
}

func (x *GetWorkstationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListWorkstations.
type ListWorkstationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListWorkstationsRequest) Reset() {
	*x = ListWorkstationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkstationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkstationsRequest) ProtoMessage() {}

func (x *ListWorkstationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkstationsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkstationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{18}
}

func (x *ListWorkstationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkstationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkstationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListWorkstations.
type ListWorkstationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested workstations.
	Workstations []*Workstation `protobuf:"bytes,1,rep,name=workstations,proto3" json:"workstations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListWorkstationsResponse) Reset() {
	*x = ListWorkstationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkstationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkstationsResponse) ProtoMessage() {}

func (x *ListWorkstationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkstationsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkstationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{19}
}

func (x *ListWorkstationsResponse) GetWorkstations() []*Workstation {
	if x != nil {
		return x.Workstations
	}
	return nil
}

func (x *ListWorkstationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListWorkstationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for ListUsableWorkstations.
type ListUsableWorkstationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListUsableWorkstationsRequest) Reset() {
	*x = ListUsableWorkstationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUsableWorkstationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsableWorkstationsRequest) ProtoMessage() {}

func (x *ListUsableWorkstationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsableWorkstationsRequest.ProtoReflect.Descriptor instead.
func (*ListUsableWorkstationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{20}
}

func (x *ListUsableWorkstationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUsableWorkstationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUsableWorkstationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListUsableWorkstations.
type ListUsableWorkstationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested workstations.
	Workstations []*Workstation `protobuf:"bytes,1,rep,name=workstations,proto3" json:"workstations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListUsableWorkstationsResponse) Reset() {
	*x = ListUsableWorkstationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUsableWorkstationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsableWorkstationsResponse) ProtoMessage() {}

func (x *ListUsableWorkstationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsableWorkstationsResponse.ProtoReflect.Descriptor instead.
func (*ListUsableWorkstationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{21}
}

func (x *ListUsableWorkstationsResponse) GetWorkstations() []*Workstation {
	if x != nil {
		return x.Workstations
	}
	return nil
}

func (x *ListUsableWorkstationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListUsableWorkstationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for creating a CreateWorkstation.
type CreateWorkstationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID to use for the workstation.
	WorkstationId string `protobuf:"bytes,2,opt,name=workstation_id,json=workstationId,proto3" json:"workstation_id,omitempty"`
	// Required. Workstation to create.
	Workstation *Workstation `protobuf:"bytes,3,opt,name=workstation,proto3" json:"workstation,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateWorkstationRequest) Reset() {
	*x = CreateWorkstationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkstationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkstationRequest) ProtoMessage() {}

func (x *CreateWorkstationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkstationRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkstationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{22}
}

func (x *CreateWorkstationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkstationRequest) GetWorkstationId() string {
	if x != nil {
		return x.WorkstationId
	}
	return ""
}

func (x *CreateWorkstationRequest) GetWorkstation() *Workstation {
	if x != nil {
		return x.Workstation
	}
	return nil
}

func (x *CreateWorkstationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for UpdateWorkstation.
type UpdateWorkstationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Workstation to update.
	Workstation *Workstation `protobuf:"bytes,1,opt,name=workstation,proto3" json:"workstation,omitempty"`
	// Required. Mask specifying which fields in the workstation configuration
	// should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set and the workstation configuration is not found, a new
	// workstation configuration is created. In this situation, update_mask
	// is ignored.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateWorkstationRequest) Reset() {
	*x = UpdateWorkstationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkstationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkstationRequest) ProtoMessage() {}

func (x *UpdateWorkstationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkstationRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkstationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{23}
}

func (x *UpdateWorkstationRequest) GetWorkstation() *Workstation {
	if x != nil {
		return x.Workstation
	}
	return nil
}

func (x *UpdateWorkstationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateWorkstationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateWorkstationRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for DeleteWorkstation.
type DeleteWorkstationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the workstation to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set, the request will be rejected if the latest version of the
	// workstation on the server does not have this ETag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteWorkstationRequest) Reset() {
	*x = DeleteWorkstationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkstationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkstationRequest) ProtoMessage() {}

func (x *DeleteWorkstationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkstationRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkstationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{24}
}

func (x *DeleteWorkstationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteWorkstationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteWorkstationRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for StartWorkstation.
type StartWorkstationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the workstation to start.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set, the request will be rejected if the latest version of the
	// workstation on the server does not have this ETag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *StartWorkstationRequest) Reset() {
	*x = StartWorkstationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartWorkstationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartWorkstationRequest) ProtoMessage() {}

func (x *StartWorkstationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartWorkstationRequest.ProtoReflect.Descriptor instead.
func (*StartWorkstationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{25}
}

func (x *StartWorkstationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartWorkstationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *StartWorkstationRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for StopWorkstation.
type StopWorkstationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the workstation to stop.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the review, but do not actually
	// apply it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set, the request will be rejected if the latest version of the
	// workstation on the server does not have this ETag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *StopWorkstationRequest) Reset() {
	*x = StopWorkstationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopWorkstationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopWorkstationRequest) ProtoMessage() {}

func (x *StopWorkstationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopWorkstationRequest.ProtoReflect.Descriptor instead.
func (*StopWorkstationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{26}
}

func (x *StopWorkstationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StopWorkstationRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *StopWorkstationRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for GenerateAccessToken.
type GenerateAccessTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the workstation for which the access token should be
	// generated.
	Workstation string `protobuf:"bytes,1,opt,name=workstation,proto3" json:"workstation,omitempty"`
	// Desired expiration or lifetime of the access token.
	//
	// Types that are assignable to Expiration:
	//	*GenerateAccessTokenRequest_ExpireTime
	//	*GenerateAccessTokenRequest_Ttl
	Expiration isGenerateAccessTokenRequest_Expiration `protobuf_oneof:"expiration"`
}

func (x *GenerateAccessTokenRequest) Reset() {
	*x = GenerateAccessTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAccessTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAccessTokenRequest) ProtoMessage() {}

func (x *GenerateAccessTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAccessTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateAccessTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{27}
}

func (x *GenerateAccessTokenRequest) GetWorkstation() string {
	if x != nil {
		return x.Workstation
	}
	return ""
}

func (m *GenerateAccessTokenRequest) GetExpiration() isGenerateAccessTokenRequest_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (x *GenerateAccessTokenRequest) GetExpireTime() *timestamppb.Timestamp {
	if x, ok := x.GetExpiration().(*GenerateAccessTokenRequest_ExpireTime); ok {
		return x.ExpireTime
	}
	return nil
}

func (x *GenerateAccessTokenRequest) GetTtl() *durationpb.Duration {
	if x, ok := x.GetExpiration().(*GenerateAccessTokenRequest_Ttl); ok {
		return x.Ttl
	}
	return nil
}

type isGenerateAccessTokenRequest_Expiration interface {
	isGenerateAccessTokenRequest_Expiration()
}

type GenerateAccessTokenRequest_ExpireTime struct {
	// Desired expiration time of the access token. This value must
	// be at most 24 hours in the future. If a value is not specified, the
	// token's expiration time will be set to a default value of 1 hour in the
	// future.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3,oneof"`
}

type GenerateAccessTokenRequest_Ttl struct {
	// Desired lifetime duration of the access token. This value must
	// be at most 24 hours. If a value is not specified, the token's lifetime
	// will be set to a default value of 1 hour.
	Ttl *durationpb.Duration `protobuf:"bytes,3,opt,name=ttl,proto3,oneof"`
}

func (*GenerateAccessTokenRequest_ExpireTime) isGenerateAccessTokenRequest_Expiration() {}

func (*GenerateAccessTokenRequest_Ttl) isGenerateAccessTokenRequest_Expiration() {}

// Response message for GenerateAccessToken.
type GenerateAccessTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated bearer access token. To use this token, include it in an
	// Authorization header of an HTTP request sent to the associated
	// workstation's hostname—for example, `Authorization: Bearer
	// <access_token>`.
	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Time at which the generated token will expire.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *GenerateAccessTokenResponse) Reset() {
	*x = GenerateAccessTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAccessTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAccessTokenResponse) ProtoMessage() {}

func (x *GenerateAccessTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAccessTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateAccessTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{28}
}

func (x *GenerateAccessTokenResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *GenerateAccessTokenResponse) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// Metadata for long-running operations.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Time that the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time that the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{29}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Configuration options for private clusters.
type WorkstationCluster_PrivateClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Whether Workstations endpoint is private.
	EnablePrivateEndpoint bool `protobuf:"varint,1,opt,name=enable_private_endpoint,json=enablePrivateEndpoint,proto3" json:"enable_private_endpoint,omitempty"`
	// Output only. Hostname for the workstation cluster. This field will be
	// populated only when private endpoint is enabled. To access workstations
	// in the cluster, create a new DNS zone mapping this domain name to an
	// internal IP address and a forwarding rule mapping that address to the
	// service attachment.
	ClusterHostname string `protobuf:"bytes,2,opt,name=cluster_hostname,json=clusterHostname,proto3" json:"cluster_hostname,omitempty"`
	// Output only. Service attachment URI for the workstation cluster. The
	// service attachemnt is created when private endpoint is enabled. To access
	// workstations in the cluster, configure access to the managed service
	// using [Private Service
	// Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
	ServiceAttachmentUri string `protobuf:"bytes,3,opt,name=service_attachment_uri,json=serviceAttachmentUri,proto3" json:"service_attachment_uri,omitempty"`
	// Additional projects that are allowed to attach to the workstation
	// cluster's service attachment. By default, the workstation cluster's
	// project and the VPC host project (if different) are allowed.
	AllowedProjects []string `protobuf:"bytes,4,rep,name=allowed_projects,json=allowedProjects,proto3" json:"allowed_projects,omitempty"`
}

func (x *WorkstationCluster_PrivateClusterConfig) Reset() {
	*x = WorkstationCluster_PrivateClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationCluster_PrivateClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationCluster_PrivateClusterConfig) ProtoMessage() {}

func (x *WorkstationCluster_PrivateClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationCluster_PrivateClusterConfig.ProtoReflect.Descriptor instead.
func (*WorkstationCluster_PrivateClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{0, 0}
}

func (x *WorkstationCluster_PrivateClusterConfig) GetEnablePrivateEndpoint() bool {
	if x != nil {
		return x.EnablePrivateEndpoint
	}
	return false
}

func (x *WorkstationCluster_PrivateClusterConfig) GetClusterHostname() string {
	if x != nil {
		return x.ClusterHostname
	}
	return ""
}

func (x *WorkstationCluster_PrivateClusterConfig) GetServiceAttachmentUri() string {
	if x != nil {
		return x.ServiceAttachmentUri
	}
	return ""
}

func (x *WorkstationCluster_PrivateClusterConfig) GetAllowedProjects() []string {
	if x != nil {
		return x.AllowedProjects
	}
	return nil
}

// Runtime host for a workstation.
type WorkstationConfig_Host struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of host that will be used for the workstation's runtime.
	//
	// Types that are assignable to Config:
	//	*WorkstationConfig_Host_GceInstance_
	Config isWorkstationConfig_Host_Config `protobuf_oneof:"config"`
}

func (x *WorkstationConfig_Host) Reset() {
	*x = WorkstationConfig_Host{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_Host) ProtoMessage() {}

func (x *WorkstationConfig_Host) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_Host.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_Host) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 0}
}

func (m *WorkstationConfig_Host) GetConfig() isWorkstationConfig_Host_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *WorkstationConfig_Host) GetGceInstance() *WorkstationConfig_Host_GceInstance {
	if x, ok := x.GetConfig().(*WorkstationConfig_Host_GceInstance_); ok {
		return x.GceInstance
	}
	return nil
}

type isWorkstationConfig_Host_Config interface {
	isWorkstationConfig_Host_Config()
}

type WorkstationConfig_Host_GceInstance_ struct {
	// Specifies a Compute Engine instance as the host.
	GceInstance *WorkstationConfig_Host_GceInstance `protobuf:"bytes,1,opt,name=gce_instance,json=gceInstance,proto3,oneof"`
}

func (*WorkstationConfig_Host_GceInstance_) isWorkstationConfig_Host_Config() {}

// A directory to persist across workstation sessions.
type WorkstationConfig_PersistentDirectory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of this directory in the running workstation.
	MountPath string `protobuf:"bytes,1,opt,name=mount_path,json=mountPath,proto3" json:"mount_path,omitempty"`
	// How a persistent directory should be implemented.
	//
	// Types that are assignable to DirectoryType:
	//	*WorkstationConfig_PersistentDirectory_GcePd
	DirectoryType isWorkstationConfig_PersistentDirectory_DirectoryType `protobuf_oneof:"directory_type"`
}

func (x *WorkstationConfig_PersistentDirectory) Reset() {
	*x = WorkstationConfig_PersistentDirectory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_PersistentDirectory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_PersistentDirectory) ProtoMessage() {}

func (x *WorkstationConfig_PersistentDirectory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_PersistentDirectory.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_PersistentDirectory) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 1}
}

func (x *WorkstationConfig_PersistentDirectory) GetMountPath() string {
	if x != nil {
		return x.MountPath
	}
	return ""
}

func (m *WorkstationConfig_PersistentDirectory) GetDirectoryType() isWorkstationConfig_PersistentDirectory_DirectoryType {
	if m != nil {
		return m.DirectoryType
	}
	return nil
}

func (x *WorkstationConfig_PersistentDirectory) GetGcePd() *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk {
	if x, ok := x.GetDirectoryType().(*WorkstationConfig_PersistentDirectory_GcePd); ok {
		return x.GcePd
	}
	return nil
}

type isWorkstationConfig_PersistentDirectory_DirectoryType interface {
	isWorkstationConfig_PersistentDirectory_DirectoryType()
}

type WorkstationConfig_PersistentDirectory_GcePd struct {
	// A PersistentDirectory backed by a Compute Engine persistent disk.
	GcePd *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk `protobuf:"bytes,2,opt,name=gce_pd,json=gcePd,proto3,oneof"`
}

func (*WorkstationConfig_PersistentDirectory_GcePd) isWorkstationConfig_PersistentDirectory_DirectoryType() {
}

// A Docker container.
type WorkstationConfig_Container struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Docker image defining the container. This image must be accessible by the
	// service account specified in the workstation configuration.
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// If set, overrides the default ENTRYPOINT specified by the image.
	Command []string `protobuf:"bytes,2,rep,name=command,proto3" json:"command,omitempty"`
	// Arguments passed to the entrypoint.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Environment variables passed to the container's entrypoint.
	Env map[string]string `protobuf:"bytes,4,rep,name=env,proto3" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If set, overrides the default DIR specified by the image.
	WorkingDir string `protobuf:"bytes,5,opt,name=working_dir,json=workingDir,proto3" json:"working_dir,omitempty"`
	// If set, overrides the USER specified in the image with the given uid.
	RunAsUser int32 `protobuf:"varint,6,opt,name=run_as_user,json=runAsUser,proto3" json:"run_as_user,omitempty"`
}

func (x *WorkstationConfig_Container) Reset() {
	*x = WorkstationConfig_Container{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_Container) ProtoMessage() {}

func (x *WorkstationConfig_Container) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_Container.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_Container) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 2}
}

func (x *WorkstationConfig_Container) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *WorkstationConfig_Container) GetCommand() []string {
	if x != nil {
		return x.Command
	}
	return nil
}

func (x *WorkstationConfig_Container) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *WorkstationConfig_Container) GetEnv() map[string]string {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *WorkstationConfig_Container) GetWorkingDir() string {
	if x != nil {
		return x.WorkingDir
	}
	return ""
}

func (x *WorkstationConfig_Container) GetRunAsUser() int32 {
	if x != nil {
		return x.RunAsUser
	}
	return 0
}

// A customer-managed encryption key for the Compute Engine resources
// of this workstation configuration.
type WorkstationConfig_CustomerEncryptionKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the Google Cloud KMS encryption key. For example,
	// `projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME`.
	KmsKey string `protobuf:"bytes,1,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// Immutable. The service account to use with the specified
	// KMS key. We recommend that you use a separate service account
	// and follow KMS best practices. For more information, see
	// [Separation of
	// duties](https://cloud.google.com/kms/docs/separation-of-duties) and
	// `gcloud kms keys add-iam-policy-binding`
	// [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
	KmsKeyServiceAccount string `protobuf:"bytes,2,opt,name=kms_key_service_account,json=kmsKeyServiceAccount,proto3" json:"kms_key_service_account,omitempty"`
}

func (x *WorkstationConfig_CustomerEncryptionKey) Reset() {
	*x = WorkstationConfig_CustomerEncryptionKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_CustomerEncryptionKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_CustomerEncryptionKey) ProtoMessage() {}

func (x *WorkstationConfig_CustomerEncryptionKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_CustomerEncryptionKey.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_CustomerEncryptionKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 3}
}

func (x *WorkstationConfig_CustomerEncryptionKey) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *WorkstationConfig_CustomerEncryptionKey) GetKmsKeyServiceAccount() string {
	if x != nil {
		return x.KmsKeyServiceAccount
	}
	return ""
}

// A readiness check to be performed on a workstation.
type WorkstationConfig_ReadinessCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to which the request should be sent.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Port to which the request should be sent.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *WorkstationConfig_ReadinessCheck) Reset() {
	*x = WorkstationConfig_ReadinessCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_ReadinessCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_ReadinessCheck) ProtoMessage() {}

func (x *WorkstationConfig_ReadinessCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_ReadinessCheck.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_ReadinessCheck) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 4}
}

func (x *WorkstationConfig_ReadinessCheck) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *WorkstationConfig_ReadinessCheck) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// A runtime using a Compute Engine instance.
type WorkstationConfig_Host_GceInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of a Compute Engine machine type.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Email address of the service account used on VM instances
	// used to support this configuration. If not set, VMs run with a
	// Google-managed service account. This service account must have
	// permission to pull the specified container image; otherwise, the image
	// must be publicly accessible.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Network tags to add to the Compute Engine machines backing the
	// Workstations.
	Tags []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
	// Number of instances to pool for faster workstation startup.
	PoolSize int32 `protobuf:"varint,5,opt,name=pool_size,json=poolSize,proto3" json:"pool_size,omitempty"`
	// Output only. Number of instances currently available in the pool for
	// faster workstation startup.
	PooledInstances int32 `protobuf:"varint,12,opt,name=pooled_instances,json=pooledInstances,proto3" json:"pooled_instances,omitempty"`
	// Whether instances have no public IP address.
	DisablePublicIpAddresses bool `protobuf:"varint,6,opt,name=disable_public_ip_addresses,json=disablePublicIpAddresses,proto3" json:"disable_public_ip_addresses,omitempty"`
	// A set of Compute Engine Shielded instance options.
	ShieldedInstanceConfig *WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig `protobuf:"bytes,8,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	// A set of Compute Engine Confidential VM instance options.
	ConfidentialInstanceConfig *WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig `protobuf:"bytes,10,opt,name=confidential_instance_config,json=confidentialInstanceConfig,proto3" json:"confidential_instance_config,omitempty"`
	// Size of the boot disk in GB. Defaults to 50.
	BootDiskSizeGb int32 `protobuf:"varint,9,opt,name=boot_disk_size_gb,json=bootDiskSizeGb,proto3" json:"boot_disk_size_gb,omitempty"`
	// A list of the type and count of accelerator cards attached to the
	// instance.
	Accelerators []*WorkstationConfig_Host_GceInstance_Accelerator `protobuf:"bytes,11,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
}

func (x *WorkstationConfig_Host_GceInstance) Reset() {
	*x = WorkstationConfig_Host_GceInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_Host_GceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_Host_GceInstance) ProtoMessage() {}

func (x *WorkstationConfig_Host_GceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_Host_GceInstance.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_Host_GceInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *WorkstationConfig_Host_GceInstance) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *WorkstationConfig_Host_GceInstance) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *WorkstationConfig_Host_GceInstance) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *WorkstationConfig_Host_GceInstance) GetPoolSize() int32 {
	if x != nil {
		return x.PoolSize
	}
	return 0
}

func (x *WorkstationConfig_Host_GceInstance) GetPooledInstances() int32 {
	if x != nil {
		return x.PooledInstances
	}
	return 0
}

func (x *WorkstationConfig_Host_GceInstance) GetDisablePublicIpAddresses() bool {
	if x != nil {
		return x.DisablePublicIpAddresses
	}
	return false
}

func (x *WorkstationConfig_Host_GceInstance) GetShieldedInstanceConfig() *WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *WorkstationConfig_Host_GceInstance) GetConfidentialInstanceConfig() *WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig {
	if x != nil {
		return x.ConfidentialInstanceConfig
	}
	return nil
}

func (x *WorkstationConfig_Host_GceInstance) GetBootDiskSizeGb() int32 {
	if x != nil {
		return x.BootDiskSizeGb
	}
	return 0
}

func (x *WorkstationConfig_Host_GceInstance) GetAccelerators() []*WorkstationConfig_Host_GceInstance_Accelerator {
	if x != nil {
		return x.Accelerators
	}
	return nil
}

// A set of Compute Engine Shielded instance options.
type WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the instance has Secure Boot enabled.
	EnableSecureBoot bool `protobuf:"varint,1,opt,name=enable_secure_boot,json=enableSecureBoot,proto3" json:"enable_secure_boot,omitempty"`
	// Whether the instance has the vTPM enabled.
	EnableVtpm bool `protobuf:"varint,2,opt,name=enable_vtpm,json=enableVtpm,proto3" json:"enable_vtpm,omitempty"`
	// Whether the instance has integrity monitoring enabled.
	EnableIntegrityMonitoring bool `protobuf:"varint,3,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
}

func (x *WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig) Reset() {
	*x = WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig) ProtoMessage() {}

func (x *WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 0, 0, 0}
}

func (x *WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig) GetEnableSecureBoot() bool {
	if x != nil {
		return x.EnableSecureBoot
	}
	return false
}

func (x *WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig) GetEnableVtpm() bool {
	if x != nil {
		return x.EnableVtpm
	}
	return false
}

func (x *WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

// A set of Compute Engine Confidential VM instance options.
type WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the instance has confidential compute enabled.
	EnableConfidentialCompute bool `protobuf:"varint,1,opt,name=enable_confidential_compute,json=enableConfidentialCompute,proto3" json:"enable_confidential_compute,omitempty"`
}

func (x *WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig) Reset() {
	*x = WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig) ProtoMessage() {}

func (x *WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 0, 0, 1}
}

func (x *WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig) GetEnableConfidentialCompute() bool {
	if x != nil {
		return x.EnableConfidentialCompute
	}
	return false
}

// An accelerator card attached to the instance.
type WorkstationConfig_Host_GceInstance_Accelerator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of accelerator resource to attach to the instance, for example,
	// "nvidia-tesla-p100".
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Number of accelerator cards exposed to the instance.
	Count int32 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *WorkstationConfig_Host_GceInstance_Accelerator) Reset() {
	*x = WorkstationConfig_Host_GceInstance_Accelerator{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_Host_GceInstance_Accelerator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_Host_GceInstance_Accelerator) ProtoMessage() {}

func (x *WorkstationConfig_Host_GceInstance_Accelerator) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_Host_GceInstance_Accelerator.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_Host_GceInstance_Accelerator) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 0, 0, 2}
}

func (x *WorkstationConfig_Host_GceInstance_Accelerator) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *WorkstationConfig_Host_GceInstance_Accelerator) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

// A PersistentDirectory backed by a Compute Engine regional persistent
// disk.
type WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Size of the disk in GB. Must be empty if source_snapshot is set.
	// Defaults to 200.
	SizeGb int32 `protobuf:"varint,1,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// Type of file system that the disk should be formatted with. The
	// workstation image must support this file system type. Must be empty
	// if source_snapshot is set. Defaults to ext4.
	FsType string `protobuf:"bytes,2,opt,name=fs_type,json=fsType,proto3" json:"fs_type,omitempty"`
	// Type of the disk to use. Defaults to pd-standard.
	DiskType string `protobuf:"bytes,3,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Name of the snapshot to use as the source for the disk. If set,
	// size_gb and fs_type must be empty.
	SourceSnapshot string `protobuf:"bytes,5,opt,name=source_snapshot,json=sourceSnapshot,proto3" json:"source_snapshot,omitempty"`
	// What should happen to the disk after the workstation is deleted.
	// Defaults to DELETE.
	ReclaimPolicy WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy `protobuf:"varint,4,opt,name=reclaim_policy,json=reclaimPolicy,proto3,enum=google.cloud.workstations.v1beta.WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy" json:"reclaim_policy,omitempty"`
}

func (x *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) Reset() {
	*x = WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) ProtoMessage() {}

func (x *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk.ProtoReflect.Descriptor instead.
func (*WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (x *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) GetFsType() string {
	if x != nil {
		return x.FsType
	}
	return ""
}

func (x *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) GetDiskType() string {
	if x != nil {
		return x.DiskType
	}
	return ""
}

func (x *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) GetSourceSnapshot() string {
	if x != nil {
		return x.SourceSnapshot
	}
	return ""
}

func (x *WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk) GetReclaimPolicy() WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy {
	if x != nil {
		return x.ReclaimPolicy
	}
	return WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_RECLAIM_POLICY_UNSPECIFIED
}

var File_google_cloud_workstations_v1beta_workstations_proto protoreflect.FileDescriptor

var file_google_cloud_workstations_v1beta_workstations_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe8, 0x0a, 0x0a, 0x12,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f,
	0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x67, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x23, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2d, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x50, 0x6c, 0x61, 0x6e, 0x65, 0x49, 0x70, 0x12, 0x7f, 0x0a, 0x16, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x14, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x65, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x64, 0x65, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xe9, 0x01, 0x0a, 0x14, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x17, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x10, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x16, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a, 0x3e,
	0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x8a, 0x01, 0xea, 0x41, 0x86, 0x01,
	0x0a, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x7d, 0x52, 0x01, 0x01, 0x22, 0xa0, 0x1e, 0x0a, 0x11, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65,
	0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e,
	0x67, 0x12, 0x66, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x3c, 0x0a, 0x0c,
	0x69, 0x64, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x69,
	0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x42, 0x0a, 0x0f, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x4c,
	0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x7e, 0x0a, 0x16,
	0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x15, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x75, 0x0a, 0x0e, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x6d, 0x0a, 0x10, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x0f,
	0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x12,
	0x1f, 0x0a, 0x08, 0x64, 0x65, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x64, 0x65, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64,
	0x12, 0x37, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x10,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x64,
	0x69, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x1a, 0xa1, 0x09, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74,
	0x12, 0x69, 0x0a, 0x0c, 0x67, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48, 0x6f, 0x73, 0x74,
	0x2e, 0x47, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0b,
	0x67, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0xa3, 0x08, 0x0a, 0x0b,
	0x47, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27,
	0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x6f, 0x6f, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x6f, 0x6f, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x6f, 0x6f, 0x6c,
	0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x6f, 0x6f, 0x6c, 0x65, 0x64, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x98, 0x01, 0x0a, 0x18, 0x73, 0x68, 0x69, 0x65,
	0x6c, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x48, 0x6f, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x47, 0x63, 0x65, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x73, 0x68, 0x69, 0x65,
	0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0xa4, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48,
	0x6f, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x47, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x11, 0x62, 0x6f, 0x6f,
	0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x47, 0x62, 0x12, 0x74, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x48, 0x6f, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x0c, 0x61, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x1a, 0xaa, 0x01, 0x0a, 0x19, 0x47,
	0x63, 0x65, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x76, 0x74, 0x70, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x56, 0x74, 0x70, 0x6d, 0x12, 0x3e, 0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x1a, 0x5f, 0x0a, 0x1d, 0x47, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x1a, 0x37, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xba, 0x04, 0x0a, 0x13,
	0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x7a, 0x0a, 0x06, 0x67, 0x63, 0x65, 0x5f, 0x70, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x47, 0x63, 0x65, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x74, 0x44, 0x69, 0x73, 0x6b, 0x48, 0x00, 0x52, 0x05, 0x67, 0x63, 0x65, 0x50, 0x64, 0x1a, 0xf5,
	0x02, 0x0a, 0x19, 0x47, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65,
	0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x17, 0x0a, 0x07,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73,
	0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x17, 0x0a, 0x07, 0x66, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x12, 0x96, 0x01, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x6f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x47, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b,
	0x2e, 0x52, 0x65, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d,
	0x72, 0x65, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x47, 0x0a,
	0x0d, 0x52, 0x65, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1e,
	0x0a, 0x1a, 0x52, 0x45, 0x43, 0x4c, 0x41, 0x49, 0x4d, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45,
	0x54, 0x41, 0x49, 0x4e, 0x10, 0x02, 0x42, 0x10, 0x0a, 0x0e, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xa2, 0x02, 0x0a, 0x09, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x58, 0x0a, 0x03, 0x65, 0x6e,
	0x76, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x45, 0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x03, 0x65, 0x6e, 0x76, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x69, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x44, 0x69, 0x72, 0x12, 0x1e, 0x0a, 0x0b, 0x72, 0x75, 0x6e, 0x5f, 0x61, 0x73, 0x5f,
	0x75, 0x73, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x72, 0x75, 0x6e, 0x41,
	0x73, 0x55, 0x73, 0x65, 0x72, 0x1a, 0x36, 0x0a, 0x08, 0x45, 0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x71, 0x0a,
	0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1c, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x6b, 0x6d,
	0x73, 0x4b, 0x65, 0x79, 0x12, 0x3a, 0x0a, 0x17, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x14, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0x38, 0x0a, 0x0e, 0x52, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xb1, 0x01, 0xea, 0x41, 0xad, 0x01, 0x0a, 0x2d, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x52, 0x01, 0x01, 0x22, 0xaf, 0x09, 0x0a, 0x0b, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x60,
	0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x4e, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x65, 0x6e, 0x76,
	0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x36, 0x0a, 0x08, 0x45,
	0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x6c, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x11,
	0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x04, 0x3a, 0xc7, 0x01, 0xea, 0x41, 0xc3, 0x01, 0x0a, 0x27, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x94, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x52, 0x01, 0x01, 0x22, 0x6a, 0x0a, 0x1c, 0x47,
	0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x30, 0x0a, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xac, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x30, 0x12, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd4, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x67, 0x0a, 0x14, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x13,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xbd, 0x02,
	0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x39, 0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x6a, 0x0a, 0x13,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x99, 0x02,
	0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x6a, 0x0a, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0xbc, 0x01, 0x0a, 0x1f, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x68, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xd0, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd6, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74,
	0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x64, 0x0a, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0xb7, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x67, 0x0a, 0x12,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x95, 0x02, 0x0a, 0x1e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x67, 0x0a,
	0x12, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x22, 0xba, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22,
	0x5c, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x0a, 0x2d, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb7, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x51, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xaa,
	0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbd, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51,
	0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x90, 0x02, 0x0a, 0x18,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f,
	0x0a, 0x2d, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xfc,
	0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0b, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x98, 0x01,
	0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x97, 0x01, 0x0a, 0x17, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x22, 0x96, 0x01, 0x0a, 0x16, 0x53, 0x74, 0x6f, 0x70, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xeb, 0x01, 0x0a, 0x1a,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0b, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a,
	0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00,
	0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x03,
	0x74, 0x74, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x42, 0x0c, 0x0a, 0x0a, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7d, 0x0a, 0x1b, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72,
	0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65,
	0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a,
	0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70,
	0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x32, 0xdf, 0x2b, 0x0a, 0x0c, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0xd9, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x12, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12,
	0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xb5, 0x02, 0x0a,
	0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb6, 0x01, 0xca, 0x41,
	0x27, 0x0a, 0x12, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x31, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x52, 0x3a, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x12, 0xb7, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xb8, 0x01, 0xca, 0x41, 0x27, 0x0a, 0x12, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x1f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x3a, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x32, 0x4f, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf2,
	0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0xca,
	0x41, 0x27, 0x0a, 0x12, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xeb, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x5f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12,
	0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xfe, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52,
	0x12, 0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0x9b, 0x02, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x6c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x5d, 0x12, 0x5b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0xc4, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc7, 0x01,
	0xca, 0x41, 0x26, 0x0a, 0x11, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x66, 0x3a, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xc6, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc9, 0x01, 0xca, 0x41, 0x26, 0x0a, 0x11, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x1e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x79, 0x3a, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x63, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x85, 0x02, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01,
	0xca, 0x41, 0x26, 0x0a, 0x11, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x2a, 0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x61, 0x12, 0x5f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xfb, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x70, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x61,
	0x12, 0x5f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x98, 0x02, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x7b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6c,
	0x12, 0x6a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x12, 0xac, 0x02, 0x0a,
	0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbb, 0x01,
	0xca, 0x41, 0x20, 0x0a, 0x0b, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6e, 0x3a, 0x0b, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5f, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xae, 0x02, 0x0a, 0x11,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbd, 0x01, 0xca,
	0x41, 0x20, 0x0a, 0x0b, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x17, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x7a, 0x3a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32,
	0x6b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x82, 0x02, 0x0a,
	0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01,
	0xca, 0x41, 0x20, 0x0a, 0x0b, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x61,
	0x2a, 0x5f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0x89, 0x02, 0x0a, 0x10, 0x53, 0x74, 0x61, 0x72, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x9a, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x6a, 0x3a, 0x01, 0x2a, 0x22, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x86, 0x02,
	0x0a, 0x0f, 0x53, 0x74, 0x6f, 0x70, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41, 0x20,
	0x0a, 0x0b, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x69, 0x3a, 0x01, 0x2a,
	0x22, 0x64, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70, 0x12, 0xa8, 0x02, 0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x93, 0x01, 0xda, 0x41,
	0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x7f, 0x3a, 0x01, 0x2a, 0x22, 0x7a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x85, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x11, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x48, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0x3b, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_workstations_v1beta_workstations_proto_rawDescOnce sync.Once
	file_google_cloud_workstations_v1beta_workstations_proto_rawDescData = file_google_cloud_workstations_v1beta_workstations_proto_rawDesc
)

func file_google_cloud_workstations_v1beta_workstations_proto_rawDescGZIP() []byte {
	file_google_cloud_workstations_v1beta_workstations_proto_rawDescOnce.Do(func() {
		file_google_cloud_workstations_v1beta_workstations_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_workstations_v1beta_workstations_proto_rawDescData)
	})
	return file_google_cloud_workstations_v1beta_workstations_proto_rawDescData
}

var file_google_cloud_workstations_v1beta_workstations_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_workstations_v1beta_workstations_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_google_cloud_workstations_v1beta_workstations_proto_goTypes = []interface{}{
	(WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_ReclaimPolicy)(0), // 0: google.cloud.workstations.v1beta.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy
	(Workstation_State)(0),                          // 1: google.cloud.workstations.v1beta.Workstation.State
	(*WorkstationCluster)(nil),                      // 2: google.cloud.workstations.v1beta.WorkstationCluster
	(*WorkstationConfig)(nil),                       // 3: google.cloud.workstations.v1beta.WorkstationConfig
	(*Workstation)(nil),                             // 4: google.cloud.workstations.v1beta.Workstation
	(*GetWorkstationClusterRequest)(nil),            // 5: google.cloud.workstations.v1beta.GetWorkstationClusterRequest
	(*ListWorkstationClustersRequest)(nil),          // 6: google.cloud.workstations.v1beta.ListWorkstationClustersRequest
	(*ListWorkstationClustersResponse)(nil),         // 7: google.cloud.workstations.v1beta.ListWorkstationClustersResponse
	(*CreateWorkstationClusterRequest)(nil),         // 8: google.cloud.workstations.v1beta.CreateWorkstationClusterRequest
	(*UpdateWorkstationClusterRequest)(nil),         // 9: google.cloud.workstations.v1beta.UpdateWorkstationClusterRequest
	(*DeleteWorkstationClusterRequest)(nil),         // 10: google.cloud.workstations.v1beta.DeleteWorkstationClusterRequest
	(*GetWorkstationConfigRequest)(nil),             // 11: google.cloud.workstations.v1beta.GetWorkstationConfigRequest
	(*ListWorkstationConfigsRequest)(nil),           // 12: google.cloud.workstations.v1beta.ListWorkstationConfigsRequest
	(*ListWorkstationConfigsResponse)(nil),          // 13: google.cloud.workstations.v1beta.ListWorkstationConfigsResponse
	(*ListUsableWorkstationConfigsRequest)(nil),     // 14: google.cloud.workstations.v1beta.ListUsableWorkstationConfigsRequest
	(*ListUsableWorkstationConfigsResponse)(nil),    // 15: google.cloud.workstations.v1beta.ListUsableWorkstationConfigsResponse
	(*CreateWorkstationConfigRequest)(nil),          // 16: google.cloud.workstations.v1beta.CreateWorkstationConfigRequest
	(*UpdateWorkstationConfigRequest)(nil),          // 17: google.cloud.workstations.v1beta.UpdateWorkstationConfigRequest
	(*DeleteWorkstationConfigRequest)(nil),          // 18: google.cloud.workstations.v1beta.DeleteWorkstationConfigRequest
	(*GetWorkstationRequest)(nil),                   // 19: google.cloud.workstations.v1beta.GetWorkstationRequest
	(*ListWorkstationsRequest)(nil),                 // 20: google.cloud.workstations.v1beta.ListWorkstationsRequest
	(*ListWorkstationsResponse)(nil),                // 21: google.cloud.workstations.v1beta.ListWorkstationsResponse
	(*ListUsableWorkstationsRequest)(nil),           // 22: google.cloud.workstations.v1beta.ListUsableWorkstationsRequest
	(*ListUsableWorkstationsResponse)(nil),          // 23: google.cloud.workstations.v1beta.ListUsableWorkstationsResponse
	(*CreateWorkstationRequest)(nil),                // 24: google.cloud.workstations.v1beta.CreateWorkstationRequest
	(*UpdateWorkstationRequest)(nil),                // 25: google.cloud.workstations.v1beta.UpdateWorkstationRequest
	(*DeleteWorkstationRequest)(nil),                // 26: google.cloud.workstations.v1beta.DeleteWorkstationRequest
	(*StartWorkstationRequest)(nil),                 // 27: google.cloud.workstations.v1beta.StartWorkstationRequest
	(*StopWorkstationRequest)(nil),                  // 28: google.cloud.workstations.v1beta.StopWorkstationRequest
	(*GenerateAccessTokenRequest)(nil),              // 29: google.cloud.workstations.v1beta.GenerateAccessTokenRequest
	(*GenerateAccessTokenResponse)(nil),             // 30: google.cloud.workstations.v1beta.GenerateAccessTokenResponse
	(*OperationMetadata)(nil),                       // 31: google.cloud.workstations.v1beta.OperationMetadata
	(*WorkstationCluster_PrivateClusterConfig)(nil), // 32: google.cloud.workstations.v1beta.WorkstationCluster.PrivateClusterConfig
	nil,                            // 33: google.cloud.workstations.v1beta.WorkstationCluster.AnnotationsEntry
	nil,                            // 34: google.cloud.workstations.v1beta.WorkstationCluster.LabelsEntry
	(*WorkstationConfig_Host)(nil), // 35: google.cloud.workstations.v1beta.WorkstationConfig.Host
	(*WorkstationConfig_PersistentDirectory)(nil),   // 36: google.cloud.workstations.v1beta.WorkstationConfig.PersistentDirectory
	(*WorkstationConfig_Container)(nil),             // 37: google.cloud.workstations.v1beta.WorkstationConfig.Container
	(*WorkstationConfig_CustomerEncryptionKey)(nil), // 38: google.cloud.workstations.v1beta.WorkstationConfig.CustomerEncryptionKey
	(*WorkstationConfig_ReadinessCheck)(nil),        // 39: google.cloud.workstations.v1beta.WorkstationConfig.ReadinessCheck
	nil,                                             // 40: google.cloud.workstations.v1beta.WorkstationConfig.AnnotationsEntry
	nil,                                             // 41: google.cloud.workstations.v1beta.WorkstationConfig.LabelsEntry
	(*WorkstationConfig_Host_GceInstance)(nil),      // 42: google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance
	(*WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig)(nil),     // 43: google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig
	(*WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig)(nil), // 44: google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig
	(*WorkstationConfig_Host_GceInstance_Accelerator)(nil),                   // 45: google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.Accelerator
	(*WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk)(nil),  // 46: google.cloud.workstations.v1beta.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk
	nil,                             // 47: google.cloud.workstations.v1beta.WorkstationConfig.Container.EnvEntry
	nil,                             // 48: google.cloud.workstations.v1beta.Workstation.AnnotationsEntry
	nil,                             // 49: google.cloud.workstations.v1beta.Workstation.LabelsEntry
	nil,                             // 50: google.cloud.workstations.v1beta.Workstation.EnvEntry
	(*timestamppb.Timestamp)(nil),   // 51: google.protobuf.Timestamp
	(*status.Status)(nil),           // 52: google.rpc.Status
	(*durationpb.Duration)(nil),     // 53: google.protobuf.Duration
	(*fieldmaskpb.FieldMask)(nil),   // 54: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil), // 55: google.longrunning.Operation
}
var file_google_cloud_workstations_v1beta_workstations_proto_depIdxs = []int32{
	33, // 0: google.cloud.workstations.v1beta.WorkstationCluster.annotations:type_name -> google.cloud.workstations.v1beta.WorkstationCluster.AnnotationsEntry
	34, // 1: google.cloud.workstations.v1beta.WorkstationCluster.labels:type_name -> google.cloud.workstations.v1beta.WorkstationCluster.LabelsEntry
	51, // 2: google.cloud.workstations.v1beta.WorkstationCluster.create_time:type_name -> google.protobuf.Timestamp
	51, // 3: google.cloud.workstations.v1beta.WorkstationCluster.update_time:type_name -> google.protobuf.Timestamp
	51, // 4: google.cloud.workstations.v1beta.WorkstationCluster.delete_time:type_name -> google.protobuf.Timestamp
	32, // 5: google.cloud.workstations.v1beta.WorkstationCluster.private_cluster_config:type_name -> google.cloud.workstations.v1beta.WorkstationCluster.PrivateClusterConfig
	52, // 6: google.cloud.workstations.v1beta.WorkstationCluster.conditions:type_name -> google.rpc.Status
	40, // 7: google.cloud.workstations.v1beta.WorkstationConfig.annotations:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.AnnotationsEntry
	41, // 8: google.cloud.workstations.v1beta.WorkstationConfig.labels:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.LabelsEntry
	51, // 9: google.cloud.workstations.v1beta.WorkstationConfig.create_time:type_name -> google.protobuf.Timestamp
	51, // 10: google.cloud.workstations.v1beta.WorkstationConfig.update_time:type_name -> google.protobuf.Timestamp
	51, // 11: google.cloud.workstations.v1beta.WorkstationConfig.delete_time:type_name -> google.protobuf.Timestamp
	53, // 12: google.cloud.workstations.v1beta.WorkstationConfig.idle_timeout:type_name -> google.protobuf.Duration
	53, // 13: google.cloud.workstations.v1beta.WorkstationConfig.running_timeout:type_name -> google.protobuf.Duration
	35, // 14: google.cloud.workstations.v1beta.WorkstationConfig.host:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.Host
	36, // 15: google.cloud.workstations.v1beta.WorkstationConfig.persistent_directories:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.PersistentDirectory
	37, // 16: google.cloud.workstations.v1beta.WorkstationConfig.container:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.Container
	38, // 17: google.cloud.workstations.v1beta.WorkstationConfig.encryption_key:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.CustomerEncryptionKey
	39, // 18: google.cloud.workstations.v1beta.WorkstationConfig.readiness_checks:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.ReadinessCheck
	52, // 19: google.cloud.workstations.v1beta.WorkstationConfig.conditions:type_name -> google.rpc.Status
	48, // 20: google.cloud.workstations.v1beta.Workstation.annotations:type_name -> google.cloud.workstations.v1beta.Workstation.AnnotationsEntry
	49, // 21: google.cloud.workstations.v1beta.Workstation.labels:type_name -> google.cloud.workstations.v1beta.Workstation.LabelsEntry
	51, // 22: google.cloud.workstations.v1beta.Workstation.create_time:type_name -> google.protobuf.Timestamp
	51, // 23: google.cloud.workstations.v1beta.Workstation.update_time:type_name -> google.protobuf.Timestamp
	51, // 24: google.cloud.workstations.v1beta.Workstation.delete_time:type_name -> google.protobuf.Timestamp
	1,  // 25: google.cloud.workstations.v1beta.Workstation.state:type_name -> google.cloud.workstations.v1beta.Workstation.State
	50, // 26: google.cloud.workstations.v1beta.Workstation.env:type_name -> google.cloud.workstations.v1beta.Workstation.EnvEntry
	2,  // 27: google.cloud.workstations.v1beta.ListWorkstationClustersResponse.workstation_clusters:type_name -> google.cloud.workstations.v1beta.WorkstationCluster
	2,  // 28: google.cloud.workstations.v1beta.CreateWorkstationClusterRequest.workstation_cluster:type_name -> google.cloud.workstations.v1beta.WorkstationCluster
	2,  // 29: google.cloud.workstations.v1beta.UpdateWorkstationClusterRequest.workstation_cluster:type_name -> google.cloud.workstations.v1beta.WorkstationCluster
	54, // 30: google.cloud.workstations.v1beta.UpdateWorkstationClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 31: google.cloud.workstations.v1beta.ListWorkstationConfigsResponse.workstation_configs:type_name -> google.cloud.workstations.v1beta.WorkstationConfig
	3,  // 32: google.cloud.workstations.v1beta.ListUsableWorkstationConfigsResponse.workstation_configs:type_name -> google.cloud.workstations.v1beta.WorkstationConfig
	3,  // 33: google.cloud.workstations.v1beta.CreateWorkstationConfigRequest.workstation_config:type_name -> google.cloud.workstations.v1beta.WorkstationConfig
	3,  // 34: google.cloud.workstations.v1beta.UpdateWorkstationConfigRequest.workstation_config:type_name -> google.cloud.workstations.v1beta.WorkstationConfig
	54, // 35: google.cloud.workstations.v1beta.UpdateWorkstationConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 36: google.cloud.workstations.v1beta.ListWorkstationsResponse.workstations:type_name -> google.cloud.workstations.v1beta.Workstation
	4,  // 37: google.cloud.workstations.v1beta.ListUsableWorkstationsResponse.workstations:type_name -> google.cloud.workstations.v1beta.Workstation
	4,  // 38: google.cloud.workstations.v1beta.CreateWorkstationRequest.workstation:type_name -> google.cloud.workstations.v1beta.Workstation
	4,  // 39: google.cloud.workstations.v1beta.UpdateWorkstationRequest.workstation:type_name -> google.cloud.workstations.v1beta.Workstation
	54, // 40: google.cloud.workstations.v1beta.UpdateWorkstationRequest.update_mask:type_name -> google.protobuf.FieldMask
	51, // 41: google.cloud.workstations.v1beta.GenerateAccessTokenRequest.expire_time:type_name -> google.protobuf.Timestamp
	53, // 42: google.cloud.workstations.v1beta.GenerateAccessTokenRequest.ttl:type_name -> google.protobuf.Duration
	51, // 43: google.cloud.workstations.v1beta.GenerateAccessTokenResponse.expire_time:type_name -> google.protobuf.Timestamp
	51, // 44: google.cloud.workstations.v1beta.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	51, // 45: google.cloud.workstations.v1beta.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	42, // 46: google.cloud.workstations.v1beta.WorkstationConfig.Host.gce_instance:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance
	46, // 47: google.cloud.workstations.v1beta.WorkstationConfig.PersistentDirectory.gce_pd:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk
	47, // 48: google.cloud.workstations.v1beta.WorkstationConfig.Container.env:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.Container.EnvEntry
	43, // 49: google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.shielded_instance_config:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig
	44, // 50: google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.confidential_instance_config:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig
	45, // 51: google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.accelerators:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.Host.GceInstance.Accelerator
	0,  // 52: google.cloud.workstations.v1beta.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.reclaim_policy:type_name -> google.cloud.workstations.v1beta.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy
	5,  // 53: google.cloud.workstations.v1beta.Workstations.GetWorkstationCluster:input_type -> google.cloud.workstations.v1beta.GetWorkstationClusterRequest
	6,  // 54: google.cloud.workstations.v1beta.Workstations.ListWorkstationClusters:input_type -> google.cloud.workstations.v1beta.ListWorkstationClustersRequest
	8,  // 55: google.cloud.workstations.v1beta.Workstations.CreateWorkstationCluster:input_type -> google.cloud.workstations.v1beta.CreateWorkstationClusterRequest
	9,  // 56: google.cloud.workstations.v1beta.Workstations.UpdateWorkstationCluster:input_type -> google.cloud.workstations.v1beta.UpdateWorkstationClusterRequest
	10, // 57: google.cloud.workstations.v1beta.Workstations.DeleteWorkstationCluster:input_type -> google.cloud.workstations.v1beta.DeleteWorkstationClusterRequest
	11, // 58: google.cloud.workstations.v1beta.Workstations.GetWorkstationConfig:input_type -> google.cloud.workstations.v1beta.GetWorkstationConfigRequest
	12, // 59: google.cloud.workstations.v1beta.Workstations.ListWorkstationConfigs:input_type -> google.cloud.workstations.v1beta.ListWorkstationConfigsRequest
	14, // 60: google.cloud.workstations.v1beta.Workstations.ListUsableWorkstationConfigs:input_type -> google.cloud.workstations.v1beta.ListUsableWorkstationConfigsRequest
	16, // 61: google.cloud.workstations.v1beta.Workstations.CreateWorkstationConfig:input_type -> google.cloud.workstations.v1beta.CreateWorkstationConfigRequest
	17, // 62: google.cloud.workstations.v1beta.Workstations.UpdateWorkstationConfig:input_type -> google.cloud.workstations.v1beta.UpdateWorkstationConfigRequest
	18, // 63: google.cloud.workstations.v1beta.Workstations.DeleteWorkstationConfig:input_type -> google.cloud.workstations.v1beta.DeleteWorkstationConfigRequest
	19, // 64: google.cloud.workstations.v1beta.Workstations.GetWorkstation:input_type -> google.cloud.workstations.v1beta.GetWorkstationRequest
	20, // 65: google.cloud.workstations.v1beta.Workstations.ListWorkstations:input_type -> google.cloud.workstations.v1beta.ListWorkstationsRequest
	22, // 66: google.cloud.workstations.v1beta.Workstations.ListUsableWorkstations:input_type -> google.cloud.workstations.v1beta.ListUsableWorkstationsRequest
	24, // 67: google.cloud.workstations.v1beta.Workstations.CreateWorkstation:input_type -> google.cloud.workstations.v1beta.CreateWorkstationRequest
	25, // 68: google.cloud.workstations.v1beta.Workstations.UpdateWorkstation:input_type -> google.cloud.workstations.v1beta.UpdateWorkstationRequest
	26, // 69: google.cloud.workstations.v1beta.Workstations.DeleteWorkstation:input_type -> google.cloud.workstations.v1beta.DeleteWorkstationRequest
	27, // 70: google.cloud.workstations.v1beta.Workstations.StartWorkstation:input_type -> google.cloud.workstations.v1beta.StartWorkstationRequest
	28, // 71: google.cloud.workstations.v1beta.Workstations.StopWorkstation:input_type -> google.cloud.workstations.v1beta.StopWorkstationRequest
	29, // 72: google.cloud.workstations.v1beta.Workstations.GenerateAccessToken:input_type -> google.cloud.workstations.v1beta.GenerateAccessTokenRequest
	2,  // 73: google.cloud.workstations.v1beta.Workstations.GetWorkstationCluster:output_type -> google.cloud.workstations.v1beta.WorkstationCluster
	7,  // 74: google.cloud.workstations.v1beta.Workstations.ListWorkstationClusters:output_type -> google.cloud.workstations.v1beta.ListWorkstationClustersResponse
	55, // 75: google.cloud.workstations.v1beta.Workstations.CreateWorkstationCluster:output_type -> google.longrunning.Operation
	55, // 76: google.cloud.workstations.v1beta.Workstations.UpdateWorkstationCluster:output_type -> google.longrunning.Operation
	55, // 77: google.cloud.workstations.v1beta.Workstations.DeleteWorkstationCluster:output_type -> google.longrunning.Operation
	3,  // 78: google.cloud.workstations.v1beta.Workstations.GetWorkstationConfig:output_type -> google.cloud.workstations.v1beta.WorkstationConfig
	13, // 79: google.cloud.workstations.v1beta.Workstations.ListWorkstationConfigs:output_type -> google.cloud.workstations.v1beta.ListWorkstationConfigsResponse
	15, // 80: google.cloud.workstations.v1beta.Workstations.ListUsableWorkstationConfigs:output_type -> google.cloud.workstations.v1beta.ListUsableWorkstationConfigsResponse
	55, // 81: google.cloud.workstations.v1beta.Workstations.CreateWorkstationConfig:output_type -> google.longrunning.Operation
	55, // 82: google.cloud.workstations.v1beta.Workstations.UpdateWorkstationConfig:output_type -> google.longrunning.Operation
	55, // 83: google.cloud.workstations.v1beta.Workstations.DeleteWorkstationConfig:output_type -> google.longrunning.Operation
	4,  // 84: google.cloud.workstations.v1beta.Workstations.GetWorkstation:output_type -> google.cloud.workstations.v1beta.Workstation
	21, // 85: google.cloud.workstations.v1beta.Workstations.ListWorkstations:output_type -> google.cloud.workstations.v1beta.ListWorkstationsResponse
	23, // 86: google.cloud.workstations.v1beta.Workstations.ListUsableWorkstations:output_type -> google.cloud.workstations.v1beta.ListUsableWorkstationsResponse
	55, // 87: google.cloud.workstations.v1beta.Workstations.CreateWorkstation:output_type -> google.longrunning.Operation
	55, // 88: google.cloud.workstations.v1beta.Workstations.UpdateWorkstation:output_type -> google.longrunning.Operation
	55, // 89: google.cloud.workstations.v1beta.Workstations.DeleteWorkstation:output_type -> google.longrunning.Operation
	55, // 90: google.cloud.workstations.v1beta.Workstations.StartWorkstation:output_type -> google.longrunning.Operation
	55, // 91: google.cloud.workstations.v1beta.Workstations.StopWorkstation:output_type -> google.longrunning.Operation
	30, // 92: google.cloud.workstations.v1beta.Workstations.GenerateAccessToken:output_type -> google.cloud.workstations.v1beta.GenerateAccessTokenResponse
	73, // [73:93] is the sub-list for method output_type
	53, // [53:73] is the sub-list for method input_type
	53, // [53:53] is the sub-list for extension type_name
	53, // [53:53] is the sub-list for extension extendee
	0,  // [0:53] is the sub-list for field type_name
}

func init() { file_google_cloud_workstations_v1beta_workstations_proto_init() }
func file_google_cloud_workstations_v1beta_workstations_proto_init() {
	if File_google_cloud_workstations_v1beta_workstations_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workstation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkstationClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkstationClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkstationClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkstationClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkstationClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkstationClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkstationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkstationConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkstationConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUsableWorkstationConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUsableWorkstationConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkstationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkstationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkstationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkstationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkstationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkstationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUsableWorkstationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListUsableWorkstationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkstationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkstationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkstationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartWorkstationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopWorkstationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAccessTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAccessTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationCluster_PrivateClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_Host); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_PersistentDirectory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_Container); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_CustomerEncryptionKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_ReadinessCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_Host_GceInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_Host_GceInstance_Accelerator); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*GenerateAccessTokenRequest_ExpireTime)(nil),
		(*GenerateAccessTokenRequest_Ttl)(nil),
	}
	file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[33].OneofWrappers = []interface{}{
		(*WorkstationConfig_Host_GceInstance_)(nil),
	}
	file_google_cloud_workstations_v1beta_workstations_proto_msgTypes[34].OneofWrappers = []interface{}{
		(*WorkstationConfig_PersistentDirectory_GcePd)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_workstations_v1beta_workstations_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   49,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_workstations_v1beta_workstations_proto_goTypes,
		DependencyIndexes: file_google_cloud_workstations_v1beta_workstations_proto_depIdxs,
		EnumInfos:         file_google_cloud_workstations_v1beta_workstations_proto_enumTypes,
		MessageInfos:      file_google_cloud_workstations_v1beta_workstations_proto_msgTypes,
	}.Build()
	File_google_cloud_workstations_v1beta_workstations_proto = out.File
	file_google_cloud_workstations_v1beta_workstations_proto_rawDesc = nil
	file_google_cloud_workstations_v1beta_workstations_proto_goTypes = nil
	file_google_cloud_workstations_v1beta_workstations_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// WorkstationsClient is the client API for Workstations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WorkstationsClient interface {
	// Returns the requested workstation cluster.
	GetWorkstationCluster(ctx context.Context, in *GetWorkstationClusterRequest, opts ...grpc.CallOption) (*WorkstationCluster, error)
	// Returns all workstation clusters in the specified location.
	ListWorkstationClusters(ctx context.Context, in *ListWorkstationClustersRequest, opts ...grpc.CallOption) (*ListWorkstationClustersResponse, error)
	// Creates a new workstation cluster.
	CreateWorkstationCluster(ctx context.Context, in *CreateWorkstationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing workstation cluster.
	UpdateWorkstationCluster(ctx context.Context, in *UpdateWorkstationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified workstation cluster.
	DeleteWorkstationCluster(ctx context.Context, in *DeleteWorkstationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the requested workstation configuration.
	GetWorkstationConfig(ctx context.Context, in *GetWorkstationConfigRequest, opts ...grpc.CallOption) (*WorkstationConfig, error)
	// Returns all workstation configurations in the specified cluster.
	ListWorkstationConfigs(ctx context.Context, in *ListWorkstationConfigsRequest, opts ...grpc.CallOption) (*ListWorkstationConfigsResponse, error)
	// Returns all workstation configurations in the specified cluster on which
	// the caller has the "workstations.workstation.create" permission.
	ListUsableWorkstationConfigs(ctx context.Context, in *ListUsableWorkstationConfigsRequest, opts ...grpc.CallOption) (*ListUsableWorkstationConfigsResponse, error)
	// Creates a new workstation configuration.
	CreateWorkstationConfig(ctx context.Context, in *CreateWorkstationConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing workstation configuration.
	UpdateWorkstationConfig(ctx context.Context, in *UpdateWorkstationConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified workstation configuration.
	DeleteWorkstationConfig(ctx context.Context, in *DeleteWorkstationConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the requested workstation.
	GetWorkstation(ctx context.Context, in *GetWorkstationRequest, opts ...grpc.CallOption) (*Workstation, error)
	// Returns all Workstations using the specified workstation configuration.
	ListWorkstations(ctx context.Context, in *ListWorkstationsRequest, opts ...grpc.CallOption) (*ListWorkstationsResponse, error)
	// Returns all workstations using the specified workstation configuration
	// on which the caller has the "workstations.workstations.use" permission.
	ListUsableWorkstations(ctx context.Context, in *ListUsableWorkstationsRequest, opts ...grpc.CallOption) (*ListUsableWorkstationsResponse, error)
	// Creates a new workstation.
	CreateWorkstation(ctx context.Context, in *CreateWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing workstation.
	UpdateWorkstation(ctx context.Context, in *UpdateWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified workstation.
	DeleteWorkstation(ctx context.Context, in *DeleteWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts running a workstation so that users can connect to it.
	StartWorkstation(ctx context.Context, in *StartWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops running a workstation, reducing costs.
	StopWorkstation(ctx context.Context, in *StopWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns a short-lived credential that can be used to send authenticated and
	// authorized traffic to a workstation.
	GenerateAccessToken(ctx context.Context, in *GenerateAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAccessTokenResponse, error)
}

type workstationsClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkstationsClient(cc grpc.ClientConnInterface) WorkstationsClient {
	return &workstationsClient{cc}
}

func (c *workstationsClient) GetWorkstationCluster(ctx context.Context, in *GetWorkstationClusterRequest, opts ...grpc.CallOption) (*WorkstationCluster, error) {
	out := new(WorkstationCluster)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/GetWorkstationCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) ListWorkstationClusters(ctx context.Context, in *ListWorkstationClustersRequest, opts ...grpc.CallOption) (*ListWorkstationClustersResponse, error) {
	out := new(ListWorkstationClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/ListWorkstationClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) CreateWorkstationCluster(ctx context.Context, in *CreateWorkstationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/CreateWorkstationCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) UpdateWorkstationCluster(ctx context.Context, in *UpdateWorkstationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/UpdateWorkstationCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) DeleteWorkstationCluster(ctx context.Context, in *DeleteWorkstationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/DeleteWorkstationCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) GetWorkstationConfig(ctx context.Context, in *GetWorkstationConfigRequest, opts ...grpc.CallOption) (*WorkstationConfig, error) {
	out := new(WorkstationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/GetWorkstationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) ListWorkstationConfigs(ctx context.Context, in *ListWorkstationConfigsRequest, opts ...grpc.CallOption) (*ListWorkstationConfigsResponse, error) {
	out := new(ListWorkstationConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/ListWorkstationConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) ListUsableWorkstationConfigs(ctx context.Context, in *ListUsableWorkstationConfigsRequest, opts ...grpc.CallOption) (*ListUsableWorkstationConfigsResponse, error) {
	out := new(ListUsableWorkstationConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/ListUsableWorkstationConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) CreateWorkstationConfig(ctx context.Context, in *CreateWorkstationConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/CreateWorkstationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) UpdateWorkstationConfig(ctx context.Context, in *UpdateWorkstationConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/UpdateWorkstationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) DeleteWorkstationConfig(ctx context.Context, in *DeleteWorkstationConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/DeleteWorkstationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) GetWorkstation(ctx context.Context, in *GetWorkstationRequest, opts ...grpc.CallOption) (*Workstation, error) {
	out := new(Workstation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/GetWorkstation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) ListWorkstations(ctx context.Context, in *ListWorkstationsRequest, opts ...grpc.CallOption) (*ListWorkstationsResponse, error) {
	out := new(ListWorkstationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/ListWorkstations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) ListUsableWorkstations(ctx context.Context, in *ListUsableWorkstationsRequest, opts ...grpc.CallOption) (*ListUsableWorkstationsResponse, error) {
	out := new(ListUsableWorkstationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/ListUsableWorkstations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) CreateWorkstation(ctx context.Context, in *CreateWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/CreateWorkstation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) UpdateWorkstation(ctx context.Context, in *UpdateWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/UpdateWorkstation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) DeleteWorkstation(ctx context.Context, in *DeleteWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/DeleteWorkstation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) StartWorkstation(ctx context.Context, in *StartWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/StartWorkstation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) StopWorkstation(ctx context.Context, in *StopWorkstationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/StopWorkstation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workstationsClient) GenerateAccessToken(ctx context.Context, in *GenerateAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAccessTokenResponse, error) {
	out := new(GenerateAccessTokenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.workstations.v1beta.Workstations/GenerateAccessToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkstationsServer is the server API for Workstations service.
type WorkstationsServer interface {
	// Returns the requested workstation cluster.
	GetWorkstationCluster(context.Context, *GetWorkstationClusterRequest) (*WorkstationCluster, error)
	// Returns all workstation clusters in the specified location.
	ListWorkstationClusters(context.Context, *ListWorkstationClustersRequest) (*ListWorkstationClustersResponse, error)
	// Creates a new workstation cluster.
	CreateWorkstationCluster(context.Context, *CreateWorkstationClusterRequest) (*longrunningpb.Operation, error)
	// Updates an existing workstation cluster.
	UpdateWorkstationCluster(context.Context, *UpdateWorkstationClusterRequest) (*longrunningpb.Operation, error)
	// Deletes the specified workstation cluster.
	DeleteWorkstationCluster(context.Context, *DeleteWorkstationClusterRequest) (*longrunningpb.Operation, error)
	// Returns the requested workstation configuration.
	GetWorkstationConfig(context.Context, *GetWorkstationConfigRequest) (*WorkstationConfig, error)
	// Returns all workstation configurations in the specified cluster.
	ListWorkstationConfigs(context.Context, *ListWorkstationConfigsRequest) (*ListWorkstationConfigsResponse, error)
	// Returns all workstation configurations in the specified cluster on which
	// the caller has the "workstations.workstation.create" permission.
	ListUsableWorkstationConfigs(context.Context, *ListUsableWorkstationConfigsRequest) (*ListUsableWorkstationConfigsResponse, error)
	// Creates a new workstation configuration.
	CreateWorkstationConfig(context.Context, *CreateWorkstationConfigRequest) (*longrunningpb.Operation, error)
	// Updates an existing workstation configuration.
	UpdateWorkstationConfig(context.Context, *UpdateWorkstationConfigRequest) (*longrunningpb.Operation, error)
	// Deletes the specified workstation configuration.
	DeleteWorkstationConfig(context.Context, *DeleteWorkstationConfigRequest) (*longrunningpb.Operation, error)
	// Returns the requested workstation.
	GetWorkstation(context.Context, *GetWorkstationRequest) (*Workstation, error)
	// Returns all Workstations using the specified workstation configuration.
	ListWorkstations(context.Context, *ListWorkstationsRequest) (*ListWorkstationsResponse, error)
	// Returns all workstations using the specified workstation configuration
	// on which the caller has the "workstations.workstations.use" permission.
	ListUsableWorkstations(context.Context, *ListUsableWorkstationsRequest) (*ListUsableWorkstationsResponse, error)
	// Creates a new workstation.
	CreateWorkstation(context.Context, *CreateWorkstationRequest) (*longrunningpb.Operation, error)
	// Updates an existing workstation.
	UpdateWorkstation(context.Context, *UpdateWorkstationRequest) (*longrunningpb.Operation, error)
	// Deletes the specified workstation.
	DeleteWorkstation(context.Context, *DeleteWorkstationRequest) (*longrunningpb.Operation, error)
	// Starts running a workstation so that users can connect to it.
	StartWorkstation(context.Context, *StartWorkstationRequest) (*longrunningpb.Operation, error)
	// Stops running a workstation, reducing costs.
	StopWorkstation(context.Context, *StopWorkstationRequest) (*longrunningpb.Operation, error)
	// Returns a short-lived credential that can be used to send authenticated and
	// authorized traffic to a workstation.
	GenerateAccessToken(context.Context, *GenerateAccessTokenRequest) (*GenerateAccessTokenResponse, error)
}

// UnimplementedWorkstationsServer can be embedded to have forward compatible implementations.
type UnimplementedWorkstationsServer struct {
}

func (*UnimplementedWorkstationsServer) GetWorkstationCluster(context.Context, *GetWorkstationClusterRequest) (*WorkstationCluster, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetWorkstationCluster not implemented")
}
func (*UnimplementedWorkstationsServer) ListWorkstationClusters(context.Context, *ListWorkstationClustersRequest) (*ListWorkstationClustersResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListWorkstationClusters not implemented")
}
func (*UnimplementedWorkstationsServer) CreateWorkstationCluster(context.Context, *CreateWorkstationClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateWorkstationCluster not implemented")
}
func (*UnimplementedWorkstationsServer) UpdateWorkstationCluster(context.Context, *UpdateWorkstationClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateWorkstationCluster not implemented")
}
func (*UnimplementedWorkstationsServer) DeleteWorkstationCluster(context.Context, *DeleteWorkstationClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteWorkstationCluster not implemented")
}
func (*UnimplementedWorkstationsServer) GetWorkstationConfig(context.Context, *GetWorkstationConfigRequest) (*WorkstationConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetWorkstationConfig not implemented")
}
func (*UnimplementedWorkstationsServer) ListWorkstationConfigs(context.Context, *ListWorkstationConfigsRequest) (*ListWorkstationConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListWorkstationConfigs not implemented")
}
func (*UnimplementedWorkstationsServer) ListUsableWorkstationConfigs(context.Context, *ListUsableWorkstationConfigsRequest) (*ListUsableWorkstationConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListUsableWorkstationConfigs not implemented")
}
func (*UnimplementedWorkstationsServer) CreateWorkstationConfig(context.Context, *CreateWorkstationConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateWorkstationConfig not implemented")
}
func (*UnimplementedWorkstationsServer) UpdateWorkstationConfig(context.Context, *UpdateWorkstationConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateWorkstationConfig not implemented")
}
func (*UnimplementedWorkstationsServer) DeleteWorkstationConfig(context.Context, *DeleteWorkstationConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteWorkstationConfig not implemented")
}
func (*UnimplementedWorkstationsServer) GetWorkstation(context.Context, *GetWorkstationRequest) (*Workstation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetWorkstation not implemented")
}
func (*UnimplementedWorkstationsServer) ListWorkstations(context.Context, *ListWorkstationsRequest) (*ListWorkstationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListWorkstations not implemented")
}
func (*UnimplementedWorkstationsServer) ListUsableWorkstations(context.Context, *ListUsableWorkstationsRequest) (*ListUsableWorkstationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListUsableWorkstations not implemented")
}
func (*UnimplementedWorkstationsServer) CreateWorkstation(context.Context, *CreateWorkstationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateWorkstation not implemented")
}
func (*UnimplementedWorkstationsServer) UpdateWorkstation(context.Context, *UpdateWorkstationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateWorkstation not implemented")
}
func (*UnimplementedWorkstationsServer) DeleteWorkstation(context.Context, *DeleteWorkstationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteWorkstation not implemented")
}
func (*UnimplementedWorkstationsServer) StartWorkstation(context.Context, *StartWorkstationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method StartWorkstation not implemented")
}
func (*UnimplementedWorkstationsServer) StopWorkstation(context.Context, *StopWorkstationRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method StopWorkstation not implemented")
}
func (*UnimplementedWorkstationsServer) GenerateAccessToken(context.Context, *GenerateAccessTokenRequest) (*GenerateAccessTokenResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateAccessToken not implemented")
}

func RegisterWorkstationsServer(s *grpc.Server, srv WorkstationsServer) {
	s.RegisterService(&_Workstations_serviceDesc, srv)
}

func _Workstations_GetWorkstationCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkstationClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).GetWorkstationCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/GetWorkstationCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).GetWorkstationCluster(ctx, req.(*GetWorkstationClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_ListWorkstationClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkstationClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).ListWorkstationClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/ListWorkstationClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).ListWorkstationClusters(ctx, req.(*ListWorkstationClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_CreateWorkstationCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkstationClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).CreateWorkstationCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/CreateWorkstationCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).CreateWorkstationCluster(ctx, req.(*CreateWorkstationClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_UpdateWorkstationCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkstationClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).UpdateWorkstationCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/UpdateWorkstationCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).UpdateWorkstationCluster(ctx, req.(*UpdateWorkstationClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_DeleteWorkstationCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkstationClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).DeleteWorkstationCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/DeleteWorkstationCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).DeleteWorkstationCluster(ctx, req.(*DeleteWorkstationClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_GetWorkstationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkstationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).GetWorkstationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/GetWorkstationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).GetWorkstationConfig(ctx, req.(*GetWorkstationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_ListWorkstationConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkstationConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).ListWorkstationConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/ListWorkstationConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).ListWorkstationConfigs(ctx, req.(*ListWorkstationConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_ListUsableWorkstationConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsableWorkstationConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).ListUsableWorkstationConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/ListUsableWorkstationConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).ListUsableWorkstationConfigs(ctx, req.(*ListUsableWorkstationConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_CreateWorkstationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkstationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).CreateWorkstationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/CreateWorkstationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).CreateWorkstationConfig(ctx, req.(*CreateWorkstationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_UpdateWorkstationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkstationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).UpdateWorkstationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/UpdateWorkstationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).UpdateWorkstationConfig(ctx, req.(*UpdateWorkstationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_DeleteWorkstationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkstationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).DeleteWorkstationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/DeleteWorkstationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).DeleteWorkstationConfig(ctx, req.(*DeleteWorkstationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_GetWorkstation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkstationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).GetWorkstation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/GetWorkstation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).GetWorkstation(ctx, req.(*GetWorkstationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_ListWorkstations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkstationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).ListWorkstations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/ListWorkstations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).ListWorkstations(ctx, req.(*ListWorkstationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_ListUsableWorkstations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsableWorkstationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).ListUsableWorkstations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/ListUsableWorkstations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).ListUsableWorkstations(ctx, req.(*ListUsableWorkstationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_CreateWorkstation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkstationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).CreateWorkstation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/CreateWorkstation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).CreateWorkstation(ctx, req.(*CreateWorkstationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_UpdateWorkstation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkstationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).UpdateWorkstation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/UpdateWorkstation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).UpdateWorkstation(ctx, req.(*UpdateWorkstationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_DeleteWorkstation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkstationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).DeleteWorkstation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/DeleteWorkstation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).DeleteWorkstation(ctx, req.(*DeleteWorkstationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_StartWorkstation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartWorkstationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).StartWorkstation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/StartWorkstation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).StartWorkstation(ctx, req.(*StartWorkstationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_StopWorkstation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopWorkstationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).StopWorkstation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/StopWorkstation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).StopWorkstation(ctx, req.(*StopWorkstationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Workstations_GenerateAccessToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAccessTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkstationsServer).GenerateAccessToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.workstations.v1beta.Workstations/GenerateAccessToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkstationsServer).GenerateAccessToken(ctx, req.(*GenerateAccessTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Workstations_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.workstations.v1beta.Workstations",
	HandlerType: (*WorkstationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetWorkstationCluster",
			Handler:    _Workstations_GetWorkstationCluster_Handler,
		},
		{
			MethodName: "ListWorkstationClusters",
			Handler:    _Workstations_ListWorkstationClusters_Handler,
		},
		{
			MethodName: "CreateWorkstationCluster",
			Handler:    _Workstations_CreateWorkstationCluster_Handler,
		},
		{
			MethodName: "UpdateWorkstationCluster",
			Handler:    _Workstations_UpdateWorkstationCluster_Handler,
		},
		{
			MethodName: "DeleteWorkstationCluster",
			Handler:    _Workstations_DeleteWorkstationCluster_Handler,
		},
		{
			MethodName: "GetWorkstationConfig",
			Handler:    _Workstations_GetWorkstationConfig_Handler,
		},
		{
			MethodName: "ListWorkstationConfigs",
			Handler:    _Workstations_ListWorkstationConfigs_Handler,
		},
		{
			MethodName: "ListUsableWorkstationConfigs",
			Handler:    _Workstations_ListUsableWorkstationConfigs_Handler,
		},
		{
			MethodName: "CreateWorkstationConfig",
			Handler:    _Workstations_CreateWorkstationConfig_Handler,
		},
		{
			MethodName: "UpdateWorkstationConfig",
			Handler:    _Workstations_UpdateWorkstationConfig_Handler,
		},
		{
			MethodName: "DeleteWorkstationConfig",
			Handler:    _Workstations_DeleteWorkstationConfig_Handler,
		},
		{
			MethodName: "GetWorkstation",
			Handler:    _Workstations_GetWorkstation_Handler,
		},
		{
			MethodName: "ListWorkstations",
			Handler:    _Workstations_ListWorkstations_Handler,
		},
		{
			MethodName: "ListUsableWorkstations",
			Handler:    _Workstations_ListUsableWorkstations_Handler,
		},
		{
			MethodName: "CreateWorkstation",
			Handler:    _Workstations_CreateWorkstation_Handler,
		},
		{
			MethodName: "UpdateWorkstation",
			Handler:    _Workstations_UpdateWorkstation_Handler,
		},
		{
			MethodName: "DeleteWorkstation",
			Handler:    _Workstations_DeleteWorkstation_Handler,
		},
		{
			MethodName: "StartWorkstation",
			Handler:    _Workstations_StartWorkstation_Handler,
		},
		{
			MethodName: "StopWorkstation",
			Handler:    _Workstations_StopWorkstation_Handler,
		},
		{
			MethodName: "GenerateAccessToken",
			Handler:    _Workstations_GenerateAccessToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/workstations/v1beta/workstations.proto",
}
