// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/retail/v2beta/catalog.proto

package retailpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of an attribute.
type CatalogAttribute_AttributeType int32

const (
	// The type of the attribute is unknown.
	//
	// Used when type cannot be derived from attribute that is not
	// [in_use][google.cloud.retail.v2beta.CatalogAttribute.in_use].
	CatalogAttribute_UNKNOWN CatalogAttribute_AttributeType = 0
	// Textual attribute.
	CatalogAttribute_TEXTUAL CatalogAttribute_AttributeType = 1
	// Numerical attribute.
	CatalogAttribute_NUMERICAL CatalogAttribute_AttributeType = 2
)

// Enum value maps for CatalogAttribute_AttributeType.
var (
	CatalogAttribute_AttributeType_name = map[int32]string{
		0: "UNKNOWN",
		1: "TEXTUAL",
		2: "NUMERICAL",
	}
	CatalogAttribute_AttributeType_value = map[string]int32{
		"UNKNOWN":   0,
		"TEXTUAL":   1,
		"NUMERICAL": 2,
	}
)

func (x CatalogAttribute_AttributeType) Enum() *CatalogAttribute_AttributeType {
	p := new(CatalogAttribute_AttributeType)
	*p = x
	return p
}

func (x CatalogAttribute_AttributeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CatalogAttribute_AttributeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_catalog_proto_enumTypes[0].Descriptor()
}

func (CatalogAttribute_AttributeType) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_catalog_proto_enumTypes[0]
}

func (x CatalogAttribute_AttributeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CatalogAttribute_AttributeType.Descriptor instead.
func (CatalogAttribute_AttributeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{1, 0}
}

// The status of the indexable option of a catalog attribute.
type CatalogAttribute_IndexableOption int32

const (
	// Value used when unset.
	CatalogAttribute_INDEXABLE_OPTION_UNSPECIFIED CatalogAttribute_IndexableOption = 0
	// Indexable option enabled for an attribute.
	CatalogAttribute_INDEXABLE_ENABLED CatalogAttribute_IndexableOption = 1
	// Indexable option disabled for an attribute.
	CatalogAttribute_INDEXABLE_DISABLED CatalogAttribute_IndexableOption = 2
)

// Enum value maps for CatalogAttribute_IndexableOption.
var (
	CatalogAttribute_IndexableOption_name = map[int32]string{
		0: "INDEXABLE_OPTION_UNSPECIFIED",
		1: "INDEXABLE_ENABLED",
		2: "INDEXABLE_DISABLED",
	}
	CatalogAttribute_IndexableOption_value = map[string]int32{
		"INDEXABLE_OPTION_UNSPECIFIED": 0,
		"INDEXABLE_ENABLED":            1,
		"INDEXABLE_DISABLED":           2,
	}
)

func (x CatalogAttribute_IndexableOption) Enum() *CatalogAttribute_IndexableOption {
	p := new(CatalogAttribute_IndexableOption)
	*p = x
	return p
}

func (x CatalogAttribute_IndexableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CatalogAttribute_IndexableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_catalog_proto_enumTypes[1].Descriptor()
}

func (CatalogAttribute_IndexableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_catalog_proto_enumTypes[1]
}

func (x CatalogAttribute_IndexableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CatalogAttribute_IndexableOption.Descriptor instead.
func (CatalogAttribute_IndexableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{1, 1}
}

// The status of the dynamic facetable option of a catalog attribute.
type CatalogAttribute_DynamicFacetableOption int32

const (
	// Value used when unset.
	CatalogAttribute_DYNAMIC_FACETABLE_OPTION_UNSPECIFIED CatalogAttribute_DynamicFacetableOption = 0
	// Dynamic facetable option enabled for an attribute.
	CatalogAttribute_DYNAMIC_FACETABLE_ENABLED CatalogAttribute_DynamicFacetableOption = 1
	// Dynamic facetable option disabled for an attribute.
	CatalogAttribute_DYNAMIC_FACETABLE_DISABLED CatalogAttribute_DynamicFacetableOption = 2
)

// Enum value maps for CatalogAttribute_DynamicFacetableOption.
var (
	CatalogAttribute_DynamicFacetableOption_name = map[int32]string{
		0: "DYNAMIC_FACETABLE_OPTION_UNSPECIFIED",
		1: "DYNAMIC_FACETABLE_ENABLED",
		2: "DYNAMIC_FACETABLE_DISABLED",
	}
	CatalogAttribute_DynamicFacetableOption_value = map[string]int32{
		"DYNAMIC_FACETABLE_OPTION_UNSPECIFIED": 0,
		"DYNAMIC_FACETABLE_ENABLED":            1,
		"DYNAMIC_FACETABLE_DISABLED":           2,
	}
)

func (x CatalogAttribute_DynamicFacetableOption) Enum() *CatalogAttribute_DynamicFacetableOption {
	p := new(CatalogAttribute_DynamicFacetableOption)
	*p = x
	return p
}

func (x CatalogAttribute_DynamicFacetableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CatalogAttribute_DynamicFacetableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_catalog_proto_enumTypes[2].Descriptor()
}

func (CatalogAttribute_DynamicFacetableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_catalog_proto_enumTypes[2]
}

func (x CatalogAttribute_DynamicFacetableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CatalogAttribute_DynamicFacetableOption.Descriptor instead.
func (CatalogAttribute_DynamicFacetableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{1, 2}
}

// The status of the searchable option of a catalog attribute.
type CatalogAttribute_SearchableOption int32

const (
	// Value used when unset.
	CatalogAttribute_SEARCHABLE_OPTION_UNSPECIFIED CatalogAttribute_SearchableOption = 0
	// Searchable option enabled for an attribute.
	CatalogAttribute_SEARCHABLE_ENABLED CatalogAttribute_SearchableOption = 1
	// Searchable option disabled for an attribute.
	CatalogAttribute_SEARCHABLE_DISABLED CatalogAttribute_SearchableOption = 2
)

// Enum value maps for CatalogAttribute_SearchableOption.
var (
	CatalogAttribute_SearchableOption_name = map[int32]string{
		0: "SEARCHABLE_OPTION_UNSPECIFIED",
		1: "SEARCHABLE_ENABLED",
		2: "SEARCHABLE_DISABLED",
	}
	CatalogAttribute_SearchableOption_value = map[string]int32{
		"SEARCHABLE_OPTION_UNSPECIFIED": 0,
		"SEARCHABLE_ENABLED":            1,
		"SEARCHABLE_DISABLED":           2,
	}
)

func (x CatalogAttribute_SearchableOption) Enum() *CatalogAttribute_SearchableOption {
	p := new(CatalogAttribute_SearchableOption)
	*p = x
	return p
}

func (x CatalogAttribute_SearchableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CatalogAttribute_SearchableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_catalog_proto_enumTypes[3].Descriptor()
}

func (CatalogAttribute_SearchableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_catalog_proto_enumTypes[3]
}

func (x CatalogAttribute_SearchableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CatalogAttribute_SearchableOption.Descriptor instead.
func (CatalogAttribute_SearchableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{1, 3}
}

// The status of the exact-searchable option of a catalog attribute.
type CatalogAttribute_ExactSearchableOption int32

const (
	// Value used when unset.
	CatalogAttribute_EXACT_SEARCHABLE_OPTION_UNSPECIFIED CatalogAttribute_ExactSearchableOption = 0
	// Exact searchable option enabled for an attribute.
	CatalogAttribute_EXACT_SEARCHABLE_ENABLED CatalogAttribute_ExactSearchableOption = 1
	// Exact searchable option disabled for an attribute.
	CatalogAttribute_EXACT_SEARCHABLE_DISABLED CatalogAttribute_ExactSearchableOption = 2
)

// Enum value maps for CatalogAttribute_ExactSearchableOption.
var (
	CatalogAttribute_ExactSearchableOption_name = map[int32]string{
		0: "EXACT_SEARCHABLE_OPTION_UNSPECIFIED",
		1: "EXACT_SEARCHABLE_ENABLED",
		2: "EXACT_SEARCHABLE_DISABLED",
	}
	CatalogAttribute_ExactSearchableOption_value = map[string]int32{
		"EXACT_SEARCHABLE_OPTION_UNSPECIFIED": 0,
		"EXACT_SEARCHABLE_ENABLED":            1,
		"EXACT_SEARCHABLE_DISABLED":           2,
	}
)

func (x CatalogAttribute_ExactSearchableOption) Enum() *CatalogAttribute_ExactSearchableOption {
	p := new(CatalogAttribute_ExactSearchableOption)
	*p = x
	return p
}

func (x CatalogAttribute_ExactSearchableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CatalogAttribute_ExactSearchableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_catalog_proto_enumTypes[4].Descriptor()
}

func (CatalogAttribute_ExactSearchableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_catalog_proto_enumTypes[4]
}

func (x CatalogAttribute_ExactSearchableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CatalogAttribute_ExactSearchableOption.Descriptor instead.
func (CatalogAttribute_ExactSearchableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{1, 4}
}

// The status of the retrievable option of a catalog attribute.
type CatalogAttribute_RetrievableOption int32

const (
	// Value used when unset.
	CatalogAttribute_RETRIEVABLE_OPTION_UNSPECIFIED CatalogAttribute_RetrievableOption = 0
	// Retrievable option enabled for an attribute.
	CatalogAttribute_RETRIEVABLE_ENABLED CatalogAttribute_RetrievableOption = 1
	// Retrievable option disabled for an attribute.
	CatalogAttribute_RETRIEVABLE_DISABLED CatalogAttribute_RetrievableOption = 2
)

// Enum value maps for CatalogAttribute_RetrievableOption.
var (
	CatalogAttribute_RetrievableOption_name = map[int32]string{
		0: "RETRIEVABLE_OPTION_UNSPECIFIED",
		1: "RETRIEVABLE_ENABLED",
		2: "RETRIEVABLE_DISABLED",
	}
	CatalogAttribute_RetrievableOption_value = map[string]int32{
		"RETRIEVABLE_OPTION_UNSPECIFIED": 0,
		"RETRIEVABLE_ENABLED":            1,
		"RETRIEVABLE_DISABLED":           2,
	}
)

func (x CatalogAttribute_RetrievableOption) Enum() *CatalogAttribute_RetrievableOption {
	p := new(CatalogAttribute_RetrievableOption)
	*p = x
	return p
}

func (x CatalogAttribute_RetrievableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CatalogAttribute_RetrievableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_catalog_proto_enumTypes[5].Descriptor()
}

func (CatalogAttribute_RetrievableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_catalog_proto_enumTypes[5]
}

func (x CatalogAttribute_RetrievableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CatalogAttribute_RetrievableOption.Descriptor instead.
func (CatalogAttribute_RetrievableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{1, 5}
}

// Configures what level the product should be uploaded with regards to
// how users will be send events and how predictions will be made.
type ProductLevelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of [Product][google.cloud.retail.v2beta.Product]s allowed to be
	// ingested into the catalog. Acceptable values are:
	//
	// * `primary` (default): You can ingest
	// [Product][google.cloud.retail.v2beta.Product]s of all types. When
	//   ingesting a [Product][google.cloud.retail.v2beta.Product], its type will
	//   default to
	//   [Product.Type.PRIMARY][google.cloud.retail.v2beta.Product.Type.PRIMARY]
	//   if unset.
	// * `variant` (incompatible with Retail Search): You can only
	//   ingest
	//   [Product.Type.VARIANT][google.cloud.retail.v2beta.Product.Type.VARIANT]
	//   [Product][google.cloud.retail.v2beta.Product]s. This means
	//   [Product.primary_product_id][google.cloud.retail.v2beta.Product.primary_product_id]
	//   cannot be empty.
	//
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned.
	//
	// If this field is `variant` and
	// [merchant_center_product_id_field][google.cloud.retail.v2beta.ProductLevelConfig.merchant_center_product_id_field]
	// is `itemGroupId`, an INVALID_ARGUMENT error is returned.
	//
	// See [Product
	// levels](https://cloud.google.com/retail/docs/catalog#product-levels)
	// for more details.
	IngestionProductType string `protobuf:"bytes,1,opt,name=ingestion_product_type,json=ingestionProductType,proto3" json:"ingestion_product_type,omitempty"`
	// Which field of [Merchant Center
	// Product](/bigquery-transfer/docs/merchant-center-products-schema) should be
	// imported as [Product.id][google.cloud.retail.v2beta.Product.id]. Acceptable
	// values are:
	//
	// * `offerId` (default): Import `offerId` as the product ID.
	// * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
	//   API will choose one item from the ones with the same `itemGroupId`, and
	//   use it to represent the item group.
	//
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned.
	//
	// If this field is `itemGroupId` and
	// [ingestion_product_type][google.cloud.retail.v2beta.ProductLevelConfig.ingestion_product_type]
	// is `variant`, an INVALID_ARGUMENT error is returned.
	//
	// See [Product
	// levels](https://cloud.google.com/retail/docs/catalog#product-levels)
	// for more details.
	MerchantCenterProductIdField string `protobuf:"bytes,2,opt,name=merchant_center_product_id_field,json=merchantCenterProductIdField,proto3" json:"merchant_center_product_id_field,omitempty"`
}

func (x *ProductLevelConfig) Reset() {
	*x = ProductLevelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductLevelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductLevelConfig) ProtoMessage() {}

func (x *ProductLevelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductLevelConfig.ProtoReflect.Descriptor instead.
func (*ProductLevelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{0}
}

func (x *ProductLevelConfig) GetIngestionProductType() string {
	if x != nil {
		return x.IngestionProductType
	}
	return ""
}

func (x *ProductLevelConfig) GetMerchantCenterProductIdField() string {
	if x != nil {
		return x.MerchantCenterProductIdField
	}
	return ""
}

// Catalog level attribute config for an attribute. For example, if customers
// want to enable/disable facet for a specific attribute.
type CatalogAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Attribute name.
	// For example: `color`, `brands`, `attributes.custom_attribute`, such as
	// `attributes.xyz`.
	// To be indexable, the attribute name can contain only alpha-numeric
	// characters and underscores. For example, an attribute named
	// `attributes.abc_xyz` can be indexed, but an attribute named
	// `attributes.abc-xyz` cannot be indexed.
	//
	// If the attribute key starts with `attributes.`, then the attribute is a
	// custom attribute. Attributes such as `brands`, `patterns`, and `title` are
	// built-in and called system attributes.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Output only. Indicates whether this attribute has been used by any
	// products. `True` if at least one
	// [Product][google.cloud.retail.v2beta.Product] is using this attribute in
	// [Product.attributes][google.cloud.retail.v2beta.Product.attributes].
	// Otherwise, this field is `False`.
	//
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] can be
	// pre-loaded by using
	// [CatalogService.AddCatalogAttribute][google.cloud.retail.v2beta.CatalogService.AddCatalogAttribute],
	// [CatalogService.ImportCatalogAttributes][], or
	// [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2beta.CatalogService.UpdateAttributesConfig]
	// APIs. This field is `False` for pre-loaded
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute]s.
	//
	// Only pre-loaded [catalog
	// attributes][google.cloud.retail.v2beta.CatalogAttribute] that are neither
	// in use by products nor predefined can be deleted. [Catalog
	// attributes][google.cloud.retail.v2beta.CatalogAttribute] that are
	// either in use by products or are predefined attributes cannot be deleted;
	// however, their configuration properties will reset to default values upon
	// removal request.
	//
	// After catalog changes, it takes about 10 minutes for this field to update.
	InUse bool `protobuf:"varint,9,opt,name=in_use,json=inUse,proto3" json:"in_use,omitempty"`
	// Output only. The type of this attribute. This is derived from the attribute
	// in [Product.attributes][google.cloud.retail.v2beta.Product.attributes].
	Type CatalogAttribute_AttributeType `protobuf:"varint,10,opt,name=type,proto3,enum=google.cloud.retail.v2beta.CatalogAttribute_AttributeType" json:"type,omitempty"`
	// When
	// [AttributesConfig.attribute_config_level][google.cloud.retail.v2beta.AttributesConfig.attribute_config_level]
	// is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
	// are indexed so that it can be filtered, faceted, or boosted in
	// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search].
	//
	// Must be specified, otherwise throws INVALID_FORMAT error.
	IndexableOption CatalogAttribute_IndexableOption `protobuf:"varint,5,opt,name=indexable_option,json=indexableOption,proto3,enum=google.cloud.retail.v2beta.CatalogAttribute_IndexableOption" json:"indexable_option,omitempty"`
	// If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
	// facet. Could only be DYNAMIC_FACETABLE_DISABLED if
	// [CatalogAttribute.indexable_option][google.cloud.retail.v2beta.CatalogAttribute.indexable_option]
	// is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Must be specified, otherwise throws INVALID_FORMAT error.
	DynamicFacetableOption CatalogAttribute_DynamicFacetableOption `protobuf:"varint,6,opt,name=dynamic_facetable_option,json=dynamicFacetableOption,proto3,enum=google.cloud.retail.v2beta.CatalogAttribute_DynamicFacetableOption" json:"dynamic_facetable_option,omitempty"`
	// When
	// [AttributesConfig.attribute_config_level][google.cloud.retail.v2beta.AttributesConfig.attribute_config_level]
	// is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
	// are searchable by text queries in
	// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search].
	//
	// If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
	// will not be searchable by text queries in
	// [SearchService.Search][google.cloud.retail.v2beta.SearchService.Search], as
	// there are no text values associated to numerical attributes.
	//
	// Must be specified, otherwise throws INVALID_FORMAT error.
	SearchableOption CatalogAttribute_SearchableOption `protobuf:"varint,7,opt,name=searchable_option,json=searchableOption,proto3,enum=google.cloud.retail.v2beta.CatalogAttribute_SearchableOption" json:"searchable_option,omitempty"`
	// When
	// [AttributesConfig.attribute_config_level][google.cloud.retail.v2beta.AttributesConfig.attribute_config_level]
	// is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if RECOMMENDATIONS_FILTERING_ENABLED,
	// attribute values are filterable for recommendations.
	// This option works for categorical features only,
	// does not work for numerical features, inventory filtering.
	RecommendationsFilteringOption RecommendationsFilteringOption `protobuf:"varint,8,opt,name=recommendations_filtering_option,json=recommendationsFilteringOption,proto3,enum=google.cloud.retail.v2beta.RecommendationsFilteringOption" json:"recommendations_filtering_option,omitempty"`
	// If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
	// This property only applies to textual custom attributes and requires
	// indexable set to enabled to enable exact-searchable. If unset, the server
	// behavior defaults to
	// [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2beta.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
	ExactSearchableOption CatalogAttribute_ExactSearchableOption `protobuf:"varint,11,opt,name=exact_searchable_option,json=exactSearchableOption,proto3,enum=google.cloud.retail.v2beta.CatalogAttribute_ExactSearchableOption" json:"exact_searchable_option,omitempty"`
	// If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
	// results. If unset, the server behavior defaults to
	// [RETRIEVABLE_DISABLED][google.cloud.retail.v2beta.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
	RetrievableOption CatalogAttribute_RetrievableOption `protobuf:"varint,12,opt,name=retrievable_option,json=retrievableOption,proto3,enum=google.cloud.retail.v2beta.CatalogAttribute_RetrievableOption" json:"retrievable_option,omitempty"`
}

func (x *CatalogAttribute) Reset() {
	*x = CatalogAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CatalogAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CatalogAttribute) ProtoMessage() {}

func (x *CatalogAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CatalogAttribute.ProtoReflect.Descriptor instead.
func (*CatalogAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{1}
}

func (x *CatalogAttribute) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *CatalogAttribute) GetInUse() bool {
	if x != nil {
		return x.InUse
	}
	return false
}

func (x *CatalogAttribute) GetType() CatalogAttribute_AttributeType {
	if x != nil {
		return x.Type
	}
	return CatalogAttribute_UNKNOWN
}

func (x *CatalogAttribute) GetIndexableOption() CatalogAttribute_IndexableOption {
	if x != nil {
		return x.IndexableOption
	}
	return CatalogAttribute_INDEXABLE_OPTION_UNSPECIFIED
}

func (x *CatalogAttribute) GetDynamicFacetableOption() CatalogAttribute_DynamicFacetableOption {
	if x != nil {
		return x.DynamicFacetableOption
	}
	return CatalogAttribute_DYNAMIC_FACETABLE_OPTION_UNSPECIFIED
}

func (x *CatalogAttribute) GetSearchableOption() CatalogAttribute_SearchableOption {
	if x != nil {
		return x.SearchableOption
	}
	return CatalogAttribute_SEARCHABLE_OPTION_UNSPECIFIED
}

func (x *CatalogAttribute) GetRecommendationsFilteringOption() RecommendationsFilteringOption {
	if x != nil {
		return x.RecommendationsFilteringOption
	}
	return RecommendationsFilteringOption_RECOMMENDATIONS_FILTERING_OPTION_UNSPECIFIED
}

func (x *CatalogAttribute) GetExactSearchableOption() CatalogAttribute_ExactSearchableOption {
	if x != nil {
		return x.ExactSearchableOption
	}
	return CatalogAttribute_EXACT_SEARCHABLE_OPTION_UNSPECIFIED
}

func (x *CatalogAttribute) GetRetrievableOption() CatalogAttribute_RetrievableOption {
	if x != nil {
		return x.RetrievableOption
	}
	return CatalogAttribute_RETRIEVABLE_OPTION_UNSPECIFIED
}

// Catalog level attribute config.
type AttributesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The fully qualified resource name of the attribute
	// config. Format: `projects/*/locations/*/catalogs/*/attributesConfig`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Enable attribute(s) config at catalog level.
	// For example, indexable, dynamic_facetable, or searchable for each
	// attribute.
	//
	// The key is catalog attribute's name.
	// For example: `color`, `brands`, `attributes.custom_attribute`, such as
	// `attributes.xyz`.
	//
	// The maximum number of catalog attributes allowed in a request is 1000.
	CatalogAttributes map[string]*CatalogAttribute `protobuf:"bytes,2,rep,name=catalog_attributes,json=catalogAttributes,proto3" json:"catalog_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The
	// [AttributeConfigLevel][google.cloud.retail.v2beta.AttributeConfigLevel]
	// used for this catalog.
	AttributeConfigLevel AttributeConfigLevel `protobuf:"varint,3,opt,name=attribute_config_level,json=attributeConfigLevel,proto3,enum=google.cloud.retail.v2beta.AttributeConfigLevel" json:"attribute_config_level,omitempty"`
}

func (x *AttributesConfig) Reset() {
	*x = AttributesConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributesConfig) ProtoMessage() {}

func (x *AttributesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributesConfig.ProtoReflect.Descriptor instead.
func (*AttributesConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{2}
}

func (x *AttributesConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AttributesConfig) GetCatalogAttributes() map[string]*CatalogAttribute {
	if x != nil {
		return x.CatalogAttributes
	}
	return nil
}

func (x *AttributesConfig) GetAttributeConfigLevel() AttributeConfigLevel {
	if x != nil {
		return x.AttributeConfigLevel
	}
	return AttributeConfigLevel_ATTRIBUTE_CONFIG_LEVEL_UNSPECIFIED
}

// Catalog level autocomplete config for customers to customize autocomplete
// feature's settings.
type CompletionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. Fully qualified name
	// `projects/*/locations/*/catalogs/*/completionConfig`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the matching order for autocomplete suggestions, e.g., a query
	// consisting of 'sh' with 'out-of-order' specified would suggest "women's
	// shoes", whereas a query of 'red s' with 'exact-prefix' specified would
	// suggest "red shoes". Currently supported values:
	//
	// * 'out-of-order'
	// * 'exact-prefix'
	//
	// Default value: 'exact-prefix'.
	MatchingOrder string `protobuf:"bytes,2,opt,name=matching_order,json=matchingOrder,proto3" json:"matching_order,omitempty"`
	// The maximum number of autocomplete suggestions returned per term. Default
	// value is 20. If left unset or set to 0, then will fallback to default
	// value.
	//
	// Value range is 1 to 20.
	MaxSuggestions int32 `protobuf:"varint,3,opt,name=max_suggestions,json=maxSuggestions,proto3" json:"max_suggestions,omitempty"`
	// The minimum number of characters needed to be typed in order to get
	// suggestions. Default value is 2. If left unset or set to 0, then will
	// fallback to default value.
	//
	// Value range is 1 to 20.
	MinPrefixLength int32 `protobuf:"varint,4,opt,name=min_prefix_length,json=minPrefixLength,proto3" json:"min_prefix_length,omitempty"`
	// If set to true, the auto learning function is enabled. Auto learning uses
	// user data to generate suggestions using ML techniques. Default value is
	// false. Only after enabling auto learning can users use `cloud-retail`
	// data in
	// [CompleteQueryRequest][google.cloud.retail.v2beta.CompleteQueryRequest].
	AutoLearning bool `protobuf:"varint,11,opt,name=auto_learning,json=autoLearning,proto3" json:"auto_learning,omitempty"`
	// Output only. The source data for the latest import of the autocomplete
	// suggestion phrases.
	SuggestionsInputConfig *CompletionDataInputConfig `protobuf:"bytes,5,opt,name=suggestions_input_config,json=suggestionsInputConfig,proto3" json:"suggestions_input_config,omitempty"`
	// Output only. Name of the LRO corresponding to the latest suggestion terms
	// list import.
	//
	// Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
	// retrieve the latest state of the Long Running Operation.
	LastSuggestionsImportOperation string `protobuf:"bytes,6,opt,name=last_suggestions_import_operation,json=lastSuggestionsImportOperation,proto3" json:"last_suggestions_import_operation,omitempty"`
	// Output only. The source data for the latest import of the autocomplete
	// denylist phrases.
	DenylistInputConfig *CompletionDataInputConfig `protobuf:"bytes,7,opt,name=denylist_input_config,json=denylistInputConfig,proto3" json:"denylist_input_config,omitempty"`
	// Output only. Name of the LRO corresponding to the latest denylist import.
	//
	// Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
	// retrieve the latest state of the Long Running Operation.
	LastDenylistImportOperation string `protobuf:"bytes,8,opt,name=last_denylist_import_operation,json=lastDenylistImportOperation,proto3" json:"last_denylist_import_operation,omitempty"`
	// Output only. The source data for the latest import of the autocomplete
	// allowlist phrases.
	AllowlistInputConfig *CompletionDataInputConfig `protobuf:"bytes,9,opt,name=allowlist_input_config,json=allowlistInputConfig,proto3" json:"allowlist_input_config,omitempty"`
	// Output only. Name of the LRO corresponding to the latest allowlist import.
	//
	// Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
	// retrieve the latest state of the Long Running Operation.
	LastAllowlistImportOperation string `protobuf:"bytes,10,opt,name=last_allowlist_import_operation,json=lastAllowlistImportOperation,proto3" json:"last_allowlist_import_operation,omitempty"`
}

func (x *CompletionConfig) Reset() {
	*x = CompletionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompletionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompletionConfig) ProtoMessage() {}

func (x *CompletionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompletionConfig.ProtoReflect.Descriptor instead.
func (*CompletionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{3}
}

func (x *CompletionConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CompletionConfig) GetMatchingOrder() string {
	if x != nil {
		return x.MatchingOrder
	}
	return ""
}

func (x *CompletionConfig) GetMaxSuggestions() int32 {
	if x != nil {
		return x.MaxSuggestions
	}
	return 0
}

func (x *CompletionConfig) GetMinPrefixLength() int32 {
	if x != nil {
		return x.MinPrefixLength
	}
	return 0
}

func (x *CompletionConfig) GetAutoLearning() bool {
	if x != nil {
		return x.AutoLearning
	}
	return false
}

func (x *CompletionConfig) GetSuggestionsInputConfig() *CompletionDataInputConfig {
	if x != nil {
		return x.SuggestionsInputConfig
	}
	return nil
}

func (x *CompletionConfig) GetLastSuggestionsImportOperation() string {
	if x != nil {
		return x.LastSuggestionsImportOperation
	}
	return ""
}

func (x *CompletionConfig) GetDenylistInputConfig() *CompletionDataInputConfig {
	if x != nil {
		return x.DenylistInputConfig
	}
	return nil
}

func (x *CompletionConfig) GetLastDenylistImportOperation() string {
	if x != nil {
		return x.LastDenylistImportOperation
	}
	return ""
}

func (x *CompletionConfig) GetAllowlistInputConfig() *CompletionDataInputConfig {
	if x != nil {
		return x.AllowlistInputConfig
	}
	return nil
}

func (x *CompletionConfig) GetLastAllowlistImportOperation() string {
	if x != nil {
		return x.LastAllowlistImportOperation
	}
	return ""
}

// Represents a link between a Merchant Center account and a branch.
// Once a link is established, products from the linked merchant center account
// will be streamed to the linked branch.
type MerchantCenterLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The linked [Merchant center account
	// ID](https://developers.google.com/shopping-content/guides/accountstatuses).
	// The account must be a standalone account or a sub-account of a MCA.
	MerchantCenterAccountId int64 `protobuf:"varint,1,opt,name=merchant_center_account_id,json=merchantCenterAccountId,proto3" json:"merchant_center_account_id,omitempty"`
	// The branch ID (e.g. 0/1/2) within this catalog that products from
	// merchant_center_account_id are streamed to. When updating this field, an
	// empty value will use the currently configured default branch. However,
	// changing the default branch later on won't change the linked branch here.
	//
	// A single branch ID can only have one linked merchant center account ID.
	BranchId string `protobuf:"bytes,2,opt,name=branch_id,json=branchId,proto3" json:"branch_id,omitempty"`
	// String representing the destination to import for, all if left empty.
	// List of possible values is given in [Included
	// destination](https://support.google.com/merchants/answer/7501026).
	// List of allowed string values:
	// "Shopping_ads", "Buy_on_google_listings", "Display_ads", "Local_inventory
	// _ads", "Free_listings", "Free_local_listings"
	// NOTE: The string values are case sensitive.
	Destinations []string `protobuf:"bytes,3,rep,name=destinations,proto3" json:"destinations,omitempty"`
	// Region code of offers to accept. 2-letter Uppercase ISO 3166-1 alpha-2
	// code. List of values can be found
	// [here](https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry)
	// under the `region` tag. If left blank no region filtering will be
	// performed.
	//
	// Example value: `US`.
	RegionCode string `protobuf:"bytes,4,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Language of the title/description and other string attributes. Use language
	// tags defined by [BCP 47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
	// ISO 639-1.
	//
	// This specifies the language of offers in Merchant Center that will be
	// accepted. If  empty no language filtering will be performed.
	//
	// Example value: `en`.
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Criteria for the Merchant Center feeds to be ingested via the link.
	// All offers will be ingested if the list is empty.
	// Otherwise the offers will be ingested from selected feeds.
	Feeds []*MerchantCenterFeedFilter `protobuf:"bytes,6,rep,name=feeds,proto3" json:"feeds,omitempty"`
}

func (x *MerchantCenterLink) Reset() {
	*x = MerchantCenterLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MerchantCenterLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantCenterLink) ProtoMessage() {}

func (x *MerchantCenterLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantCenterLink.ProtoReflect.Descriptor instead.
func (*MerchantCenterLink) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{4}
}

func (x *MerchantCenterLink) GetMerchantCenterAccountId() int64 {
	if x != nil {
		return x.MerchantCenterAccountId
	}
	return 0
}

func (x *MerchantCenterLink) GetBranchId() string {
	if x != nil {
		return x.BranchId
	}
	return ""
}

func (x *MerchantCenterLink) GetDestinations() []string {
	if x != nil {
		return x.Destinations
	}
	return nil
}

func (x *MerchantCenterLink) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *MerchantCenterLink) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *MerchantCenterLink) GetFeeds() []*MerchantCenterFeedFilter {
	if x != nil {
		return x.Feeds
	}
	return nil
}

// Merchant Center Feed filter criterion.
type MerchantCenterFeedFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Merchant Center primary feed ID.
	PrimaryFeedId int64 `protobuf:"varint,1,opt,name=primary_feed_id,json=primaryFeedId,proto3" json:"primary_feed_id,omitempty"`
	// Merchant Center primary feed name. The name is used for the display
	// purposes only.
	PrimaryFeedName string `protobuf:"bytes,2,opt,name=primary_feed_name,json=primaryFeedName,proto3" json:"primary_feed_name,omitempty"`
}

func (x *MerchantCenterFeedFilter) Reset() {
	*x = MerchantCenterFeedFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MerchantCenterFeedFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantCenterFeedFilter) ProtoMessage() {}

func (x *MerchantCenterFeedFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantCenterFeedFilter.ProtoReflect.Descriptor instead.
func (*MerchantCenterFeedFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{5}
}

func (x *MerchantCenterFeedFilter) GetPrimaryFeedId() int64 {
	if x != nil {
		return x.PrimaryFeedId
	}
	return 0
}

func (x *MerchantCenterFeedFilter) GetPrimaryFeedName() string {
	if x != nil {
		return x.PrimaryFeedName
	}
	return ""
}

// Configures Merchant Center linking.
// Links contained in the config will be used to sync data from a Merchant
// Center account to a Cloud Retail branch.
type MerchantCenterLinkingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Links between Merchant Center accounts and branches.
	Links []*MerchantCenterLink `protobuf:"bytes,1,rep,name=links,proto3" json:"links,omitempty"`
}

func (x *MerchantCenterLinkingConfig) Reset() {
	*x = MerchantCenterLinkingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MerchantCenterLinkingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantCenterLinkingConfig) ProtoMessage() {}

func (x *MerchantCenterLinkingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantCenterLinkingConfig.ProtoReflect.Descriptor instead.
func (*MerchantCenterLinkingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{6}
}

func (x *MerchantCenterLinkingConfig) GetLinks() []*MerchantCenterLink {
	if x != nil {
		return x.Links
	}
	return nil
}

// The catalog configuration.
type Catalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The fully qualified resource name of the catalog.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The catalog display name.
	//
	// This field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The product level configuration.
	ProductLevelConfig *ProductLevelConfig `protobuf:"bytes,4,opt,name=product_level_config,json=productLevelConfig,proto3" json:"product_level_config,omitempty"`
	// The Merchant Center linking configuration.
	// Once a link is added, the data stream from Merchant Center to Cloud Retail
	// will be enabled automatically. The requester must have access to the
	// merchant center account in order to make changes to this field.
	MerchantCenterLinkingConfig *MerchantCenterLinkingConfig `protobuf:"bytes,6,opt,name=merchant_center_linking_config,json=merchantCenterLinkingConfig,proto3" json:"merchant_center_linking_config,omitempty"`
}

func (x *Catalog) Reset() {
	*x = Catalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Catalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Catalog) ProtoMessage() {}

func (x *Catalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_catalog_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Catalog.ProtoReflect.Descriptor instead.
func (*Catalog) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP(), []int{7}
}

func (x *Catalog) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Catalog) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Catalog) GetProductLevelConfig() *ProductLevelConfig {
	if x != nil {
		return x.ProductLevelConfig
	}
	return nil
}

func (x *Catalog) GetMerchantCenterLinkingConfig() *MerchantCenterLinkingConfig {
	if x != nil {
		return x.MerchantCenterLinkingConfig
	}
	return nil
}

var File_google_cloud_retail_v2beta_catalog_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2beta_catalog_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x92, 0x01, 0x0a, 0x12,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x20, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x1c, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x22, 0xd5, 0x0b, 0x0a, 0x10, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1a, 0x0a, 0x06,
	0x69, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x69, 0x6e, 0x55, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x67, 0x0a,
	0x10, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x18, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61,
	0x63, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x64,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61, 0x63, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x11, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x84, 0x01, 0x0a, 0x20, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x0a, 0x17, 0x65, 0x78, 0x61, 0x63,
	0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x45, 0x78, 0x61, 0x63, 0x74, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x65,
	0x78, 0x61, 0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x2e, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x11, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x38, 0x0a, 0x0d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x45, 0x58, 0x54, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x62, 0x0a,
	0x0f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x50,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x4e, 0x44,
	0x45, 0x58, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x02, 0x22, 0x81, 0x01, 0x0a, 0x16, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x24,
	0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x46, 0x41, 0x43, 0x45, 0x54, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49,
	0x43, 0x5f, 0x46, 0x41, 0x43, 0x45, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43,
	0x5f, 0x46, 0x41, 0x43, 0x45, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x66, 0x0a, 0x10, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x45, 0x41,
	0x52, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12,
	0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x41, 0x42,
	0x4c, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x7d, 0x0a,
	0x15, 0x45, 0x78, 0x61, 0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x23, 0x45, 0x58, 0x41, 0x43, 0x54, 0x5f,
	0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1c, 0x0a, 0x18, 0x45, 0x58, 0x41, 0x43, 0x54, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1d, 0x0a,
	0x19, 0x45, 0x58, 0x41, 0x43, 0x54, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x6a, 0x0a, 0x11,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56,
	0x41, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x18,
	0x0a, 0x14, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x49,
	0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0xfd, 0x03, 0x0a, 0x10, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02,
	0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x72, 0x0a, 0x12, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x6b, 0x0a,
	0x16, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x1a, 0x72, 0x0a, 0x16, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x78,
	0xea, 0x41, 0x75, 0x0a, 0x26, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x87, 0x07, 0x0a, 0x10, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02,
	0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x69, 0x6e,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x6c, 0x65,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x75,
	0x74, 0x6f, 0x4c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x74, 0x0a, 0x18, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x4e, 0x0a, 0x21, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1e, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6e, 0x0a, 0x15, 0x64, 0x65, 0x6e, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x64, 0x65, 0x6e,
	0x79, 0x6c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x48, 0x0a, 0x1e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x64, 0x65, 0x6e, 0x79, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1b, 0x6c,
	0x61, 0x73, 0x74, 0x44, 0x65, 0x6e, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x16, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x1f,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1c, 0x6c, 0x61, 0x73, 0x74,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x26, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0xa9, 0x02, 0x0a, 0x12, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x1a, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x17, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x4a, 0x0a, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x46, 0x65, 0x65,
	0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x22, 0x6e,
	0x0a, 0x18, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x46, 0x65, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x46, 0x65, 0x65, 0x64,
	0x49, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x66, 0x65,
	0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x46, 0x65, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x63,
	0x0a, 0x1b, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x4c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a,
	0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x05, 0x6c, 0x69,
	0x6e, 0x6b, 0x73, 0x22, 0x95, 0x03, 0x0a, 0x07, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12,
	0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7c, 0x0a,
	0x1e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1b,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x4c, 0x69,
	0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x5e, 0xea, 0x41, 0x5b,
	0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12,
	0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x73, 0x2f, 0x7b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x7d, 0x42, 0xcb, 0x01, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0c,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa,
	0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_retail_v2beta_catalog_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2beta_catalog_proto_rawDescData = file_google_cloud_retail_v2beta_catalog_proto_rawDesc
)

func file_google_cloud_retail_v2beta_catalog_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2beta_catalog_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2beta_catalog_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2beta_catalog_proto_rawDescData)
	})
	return file_google_cloud_retail_v2beta_catalog_proto_rawDescData
}

var file_google_cloud_retail_v2beta_catalog_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_retail_v2beta_catalog_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_retail_v2beta_catalog_proto_goTypes = []interface{}{
	(CatalogAttribute_AttributeType)(0),          // 0: google.cloud.retail.v2beta.CatalogAttribute.AttributeType
	(CatalogAttribute_IndexableOption)(0),        // 1: google.cloud.retail.v2beta.CatalogAttribute.IndexableOption
	(CatalogAttribute_DynamicFacetableOption)(0), // 2: google.cloud.retail.v2beta.CatalogAttribute.DynamicFacetableOption
	(CatalogAttribute_SearchableOption)(0),       // 3: google.cloud.retail.v2beta.CatalogAttribute.SearchableOption
	(CatalogAttribute_ExactSearchableOption)(0),  // 4: google.cloud.retail.v2beta.CatalogAttribute.ExactSearchableOption
	(CatalogAttribute_RetrievableOption)(0),      // 5: google.cloud.retail.v2beta.CatalogAttribute.RetrievableOption
	(*ProductLevelConfig)(nil),                   // 6: google.cloud.retail.v2beta.ProductLevelConfig
	(*CatalogAttribute)(nil),                     // 7: google.cloud.retail.v2beta.CatalogAttribute
	(*AttributesConfig)(nil),                     // 8: google.cloud.retail.v2beta.AttributesConfig
	(*CompletionConfig)(nil),                     // 9: google.cloud.retail.v2beta.CompletionConfig
	(*MerchantCenterLink)(nil),                   // 10: google.cloud.retail.v2beta.MerchantCenterLink
	(*MerchantCenterFeedFilter)(nil),             // 11: google.cloud.retail.v2beta.MerchantCenterFeedFilter
	(*MerchantCenterLinkingConfig)(nil),          // 12: google.cloud.retail.v2beta.MerchantCenterLinkingConfig
	(*Catalog)(nil),                              // 13: google.cloud.retail.v2beta.Catalog
	nil,                                          // 14: google.cloud.retail.v2beta.AttributesConfig.CatalogAttributesEntry
	(RecommendationsFilteringOption)(0),          // 15: google.cloud.retail.v2beta.RecommendationsFilteringOption
	(AttributeConfigLevel)(0),                    // 16: google.cloud.retail.v2beta.AttributeConfigLevel
	(*CompletionDataInputConfig)(nil),            // 17: google.cloud.retail.v2beta.CompletionDataInputConfig
}
var file_google_cloud_retail_v2beta_catalog_proto_depIdxs = []int32{
	0,  // 0: google.cloud.retail.v2beta.CatalogAttribute.type:type_name -> google.cloud.retail.v2beta.CatalogAttribute.AttributeType
	1,  // 1: google.cloud.retail.v2beta.CatalogAttribute.indexable_option:type_name -> google.cloud.retail.v2beta.CatalogAttribute.IndexableOption
	2,  // 2: google.cloud.retail.v2beta.CatalogAttribute.dynamic_facetable_option:type_name -> google.cloud.retail.v2beta.CatalogAttribute.DynamicFacetableOption
	3,  // 3: google.cloud.retail.v2beta.CatalogAttribute.searchable_option:type_name -> google.cloud.retail.v2beta.CatalogAttribute.SearchableOption
	15, // 4: google.cloud.retail.v2beta.CatalogAttribute.recommendations_filtering_option:type_name -> google.cloud.retail.v2beta.RecommendationsFilteringOption
	4,  // 5: google.cloud.retail.v2beta.CatalogAttribute.exact_searchable_option:type_name -> google.cloud.retail.v2beta.CatalogAttribute.ExactSearchableOption
	5,  // 6: google.cloud.retail.v2beta.CatalogAttribute.retrievable_option:type_name -> google.cloud.retail.v2beta.CatalogAttribute.RetrievableOption
	14, // 7: google.cloud.retail.v2beta.AttributesConfig.catalog_attributes:type_name -> google.cloud.retail.v2beta.AttributesConfig.CatalogAttributesEntry
	16, // 8: google.cloud.retail.v2beta.AttributesConfig.attribute_config_level:type_name -> google.cloud.retail.v2beta.AttributeConfigLevel
	17, // 9: google.cloud.retail.v2beta.CompletionConfig.suggestions_input_config:type_name -> google.cloud.retail.v2beta.CompletionDataInputConfig
	17, // 10: google.cloud.retail.v2beta.CompletionConfig.denylist_input_config:type_name -> google.cloud.retail.v2beta.CompletionDataInputConfig
	17, // 11: google.cloud.retail.v2beta.CompletionConfig.allowlist_input_config:type_name -> google.cloud.retail.v2beta.CompletionDataInputConfig
	11, // 12: google.cloud.retail.v2beta.MerchantCenterLink.feeds:type_name -> google.cloud.retail.v2beta.MerchantCenterFeedFilter
	10, // 13: google.cloud.retail.v2beta.MerchantCenterLinkingConfig.links:type_name -> google.cloud.retail.v2beta.MerchantCenterLink
	6,  // 14: google.cloud.retail.v2beta.Catalog.product_level_config:type_name -> google.cloud.retail.v2beta.ProductLevelConfig
	12, // 15: google.cloud.retail.v2beta.Catalog.merchant_center_linking_config:type_name -> google.cloud.retail.v2beta.MerchantCenterLinkingConfig
	7,  // 16: google.cloud.retail.v2beta.AttributesConfig.CatalogAttributesEntry.value:type_name -> google.cloud.retail.v2beta.CatalogAttribute
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2beta_catalog_proto_init() }
func file_google_cloud_retail_v2beta_catalog_proto_init() {
	if File_google_cloud_retail_v2beta_catalog_proto != nil {
		return
	}
	file_google_cloud_retail_v2beta_common_proto_init()
	file_google_cloud_retail_v2beta_import_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2beta_catalog_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductLevelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CatalogAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributesConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompletionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MerchantCenterLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MerchantCenterFeedFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MerchantCenterLinkingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2beta_catalog_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Catalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2beta_catalog_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2beta_catalog_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2beta_catalog_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2beta_catalog_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2beta_catalog_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2beta_catalog_proto = out.File
	file_google_cloud_retail_v2beta_catalog_proto_rawDesc = nil
	file_google_cloud_retail_v2beta_catalog_proto_goTypes = nil
	file_google_cloud_retail_v2beta_catalog_proto_depIdxs = nil
}
