// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/maps/addressvalidation/v1/geocode.proto

package addressvalidationpb

import (
	reflect "reflect"
	sync "sync"

	viewport "google.golang.org/genproto/googleapis/geo/type/viewport"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Contains information about the place the input was geocoded to.
type Geocode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The geocoded location of the input.
	//
	// Using place IDs is preferred over using addresses,
	// latitude/longitude coordinates, or plus codes. Using coordinates when
	// routing or calculating driving directions will always result in the point
	// being snapped to the road nearest to those coordinates. This may not be a
	// road that will quickly or safely lead to the destination and may not be
	// near an access point to the property. Additionally, when a location is
	// reverse geocoded, there is no guarantee that the returned address will
	// match the original.
	Location *latlng.LatLng `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The plus code corresponding to the `location`.
	PlusCode *PlusCode `protobuf:"bytes,2,opt,name=plus_code,json=plusCode,proto3" json:"plus_code,omitempty"`
	// The bounds of the geocoded place.
	Bounds *viewport.Viewport `protobuf:"bytes,4,opt,name=bounds,proto3" json:"bounds,omitempty"`
	// The size of the geocoded place, in meters. This is another measure of the
	// coarseness of the geocoded location, but in physical size rather than in
	// semantic meaning.
	FeatureSizeMeters float32 `protobuf:"fixed32,5,opt,name=feature_size_meters,json=featureSizeMeters,proto3" json:"feature_size_meters,omitempty"`
	// The PlaceID of the place this input geocodes to.
	//
	// For more information about Place IDs see
	// [here](https://developers.google.com/maps/documentation/places/web-service/place-id).
	PlaceId string `protobuf:"bytes,6,opt,name=place_id,json=placeId,proto3" json:"place_id,omitempty"`
	// The type(s) of place that the input geocoded to. For example,
	// `['locality', 'political']`. The full list of types can be found
	// [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
	PlaceTypes []string `protobuf:"bytes,7,rep,name=place_types,json=placeTypes,proto3" json:"place_types,omitempty"`
}

func (x *Geocode) Reset() {
	*x = Geocode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_addressvalidation_v1_geocode_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Geocode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Geocode) ProtoMessage() {}

func (x *Geocode) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_addressvalidation_v1_geocode_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Geocode.ProtoReflect.Descriptor instead.
func (*Geocode) Descriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_geocode_proto_rawDescGZIP(), []int{0}
}

func (x *Geocode) GetLocation() *latlng.LatLng {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Geocode) GetPlusCode() *PlusCode {
	if x != nil {
		return x.PlusCode
	}
	return nil
}

func (x *Geocode) GetBounds() *viewport.Viewport {
	if x != nil {
		return x.Bounds
	}
	return nil
}

func (x *Geocode) GetFeatureSizeMeters() float32 {
	if x != nil {
		return x.FeatureSizeMeters
	}
	return 0
}

func (x *Geocode) GetPlaceId() string {
	if x != nil {
		return x.PlaceId
	}
	return ""
}

func (x *Geocode) GetPlaceTypes() []string {
	if x != nil {
		return x.PlaceTypes
	}
	return nil
}

// Plus code (http://plus.codes) is a location reference with two formats:
// global code defining a 14mx14m (1/8000th of a degree) or smaller rectangle,
// and compound code, replacing the prefix with a reference location.
type PlusCode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place's global (full) code, such as "9FWM33GV+HQ", representing an
	// 1/8000 by 1/8000 degree area (~14 by 14 meters).
	GlobalCode string `protobuf:"bytes,1,opt,name=global_code,json=globalCode,proto3" json:"global_code,omitempty"`
	// Place's compound code, such as "33GV+HQ, Ramberg, Norway", containing
	// the suffix of the global code and replacing the prefix with a formatted
	// name of a reference entity.
	CompoundCode string `protobuf:"bytes,2,opt,name=compound_code,json=compoundCode,proto3" json:"compound_code,omitempty"`
}

func (x *PlusCode) Reset() {
	*x = PlusCode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_addressvalidation_v1_geocode_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlusCode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlusCode) ProtoMessage() {}

func (x *PlusCode) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_addressvalidation_v1_geocode_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlusCode.ProtoReflect.Descriptor instead.
func (*PlusCode) Descriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_geocode_proto_rawDescGZIP(), []int{1}
}

func (x *PlusCode) GetGlobalCode() string {
	if x != nil {
		return x.GlobalCode
	}
	return ""
}

func (x *PlusCode) GetCompoundCode() string {
	if x != nil {
		return x.CompoundCode
	}
	return ""
}

var File_google_maps_addressvalidation_v1_geocode_proto protoreflect.FileDescriptor

var file_google_maps_addressvalidation_v1_geocode_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x2f, 0x67, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6f, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f,
	0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2, 0x02, 0x0a,
	0x07, 0x47, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x2f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x09, 0x70, 0x6c, 0x75,
	0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6c, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x70, 0x6c, 0x75, 0x73, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x31, 0x0a, 0x06, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x11, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x4d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x22, 0x50, 0x0a, 0x08, 0x50, 0x6c, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x43,
	0x6f, 0x64, 0x65, 0x42, 0x89, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x47, 0x65,
	0x6f, 0x63, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x58, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x70, 0x62, 0x3b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x07, 0x47, 0x4d, 0x50, 0x41,
	0x56, 0x56, 0x31, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70,
	0x73, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x4d, 0x61, 0x70, 0x73, 0x5c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x4d, 0x61, 0x70, 0x73, 0x3a, 0x3a, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_addressvalidation_v1_geocode_proto_rawDescOnce sync.Once
	file_google_maps_addressvalidation_v1_geocode_proto_rawDescData = file_google_maps_addressvalidation_v1_geocode_proto_rawDesc
)

func file_google_maps_addressvalidation_v1_geocode_proto_rawDescGZIP() []byte {
	file_google_maps_addressvalidation_v1_geocode_proto_rawDescOnce.Do(func() {
		file_google_maps_addressvalidation_v1_geocode_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_addressvalidation_v1_geocode_proto_rawDescData)
	})
	return file_google_maps_addressvalidation_v1_geocode_proto_rawDescData
}

var file_google_maps_addressvalidation_v1_geocode_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_maps_addressvalidation_v1_geocode_proto_goTypes = []interface{}{
	(*Geocode)(nil),           // 0: google.maps.addressvalidation.v1.Geocode
	(*PlusCode)(nil),          // 1: google.maps.addressvalidation.v1.PlusCode
	(*latlng.LatLng)(nil),     // 2: google.type.LatLng
	(*viewport.Viewport)(nil), // 3: google.geo.type.Viewport
}
var file_google_maps_addressvalidation_v1_geocode_proto_depIdxs = []int32{
	2, // 0: google.maps.addressvalidation.v1.Geocode.location:type_name -> google.type.LatLng
	1, // 1: google.maps.addressvalidation.v1.Geocode.plus_code:type_name -> google.maps.addressvalidation.v1.PlusCode
	3, // 2: google.maps.addressvalidation.v1.Geocode.bounds:type_name -> google.geo.type.Viewport
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_maps_addressvalidation_v1_geocode_proto_init() }
func file_google_maps_addressvalidation_v1_geocode_proto_init() {
	if File_google_maps_addressvalidation_v1_geocode_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_maps_addressvalidation_v1_geocode_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Geocode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_addressvalidation_v1_geocode_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlusCode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_addressvalidation_v1_geocode_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_addressvalidation_v1_geocode_proto_goTypes,
		DependencyIndexes: file_google_maps_addressvalidation_v1_geocode_proto_depIdxs,
		MessageInfos:      file_google_maps_addressvalidation_v1_geocode_proto_msgTypes,
	}.Build()
	File_google_maps_addressvalidation_v1_geocode_proto = out.File
	file_google_maps_addressvalidation_v1_geocode_proto_rawDesc = nil
	file_google_maps_addressvalidation_v1_geocode_proto_goTypes = nil
	file_google_maps_addressvalidation_v1_geocode_proto_depIdxs = nil
}
