// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/discoveryengine/v1beta/search_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum describing under which condition query expansion should occur.
type SearchRequest_QueryExpansionSpec_Condition int32

const (
	// Unspecified query expansion condition. In this case, server behavior
	// defaults to
	// [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
	SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED SearchRequest_QueryExpansionSpec_Condition = 0
	// Disabled query expansion. Only the exact search query is used, even if
	// [SearchResponse.total_size][google.cloud.discoveryengine.v1beta.SearchResponse.total_size]
	// is zero.
	SearchRequest_QueryExpansionSpec_DISABLED SearchRequest_QueryExpansionSpec_Condition = 1
	// Automatic query expansion built by the Search API.
	SearchRequest_QueryExpansionSpec_AUTO SearchRequest_QueryExpansionSpec_Condition = 2
)

// Enum value maps for SearchRequest_QueryExpansionSpec_Condition.
var (
	SearchRequest_QueryExpansionSpec_Condition_name = map[int32]string{
		0: "CONDITION_UNSPECIFIED",
		1: "DISABLED",
		2: "AUTO",
	}
	SearchRequest_QueryExpansionSpec_Condition_value = map[string]int32{
		"CONDITION_UNSPECIFIED": 0,
		"DISABLED":              1,
		"AUTO":                  2,
	}
)

func (x SearchRequest_QueryExpansionSpec_Condition) Enum() *SearchRequest_QueryExpansionSpec_Condition {
	p := new(SearchRequest_QueryExpansionSpec_Condition)
	*p = x
	return p
}

func (x SearchRequest_QueryExpansionSpec_Condition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_QueryExpansionSpec_Condition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_enumTypes[0].Descriptor()
}

func (SearchRequest_QueryExpansionSpec_Condition) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_search_service_proto_enumTypes[0]
}

func (x SearchRequest_QueryExpansionSpec_Condition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_QueryExpansionSpec_Condition.Descriptor instead.
func (SearchRequest_QueryExpansionSpec_Condition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 2, 0}
}

// Enum describing under which mode spell correction should occur.
type SearchRequest_SpellCorrectionSpec_Mode int32

const (
	// Unspecified spell correction mode. In this case, server behavior
	// defaults to
	// [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
	SearchRequest_SpellCorrectionSpec_MODE_UNSPECIFIED SearchRequest_SpellCorrectionSpec_Mode = 0
	// Search API will try to find a spell suggestion if there
	// is any and put in the
	// [SearchResponse.corrected_query][google.cloud.discoveryengine.v1beta.SearchResponse.corrected_query].
	// The spell suggestion will not be used as the search query.
	SearchRequest_SpellCorrectionSpec_SUGGESTION_ONLY SearchRequest_SpellCorrectionSpec_Mode = 1
	// Automatic spell correction built by the Search API. Search will
	// be based on the corrected query if found.
	SearchRequest_SpellCorrectionSpec_AUTO SearchRequest_SpellCorrectionSpec_Mode = 2
)

// Enum value maps for SearchRequest_SpellCorrectionSpec_Mode.
var (
	SearchRequest_SpellCorrectionSpec_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "SUGGESTION_ONLY",
		2: "AUTO",
	}
	SearchRequest_SpellCorrectionSpec_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"SUGGESTION_ONLY":  1,
		"AUTO":             2,
	}
)

func (x SearchRequest_SpellCorrectionSpec_Mode) Enum() *SearchRequest_SpellCorrectionSpec_Mode {
	p := new(SearchRequest_SpellCorrectionSpec_Mode)
	*p = x
	return p
}

func (x SearchRequest_SpellCorrectionSpec_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_SpellCorrectionSpec_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_enumTypes[1].Descriptor()
}

func (SearchRequest_SpellCorrectionSpec_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_search_service_proto_enumTypes[1]
}

func (x SearchRequest_SpellCorrectionSpec_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_SpellCorrectionSpec_Mode.Descriptor instead.
func (SearchRequest_SpellCorrectionSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 3, 0}
}

// Request message for
// [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
// method.
type SearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Search serving config, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
	// This field is used to identify the serving configuration name, set
	// of models used to make the search.
	ServingConfig string `protobuf:"bytes,1,opt,name=serving_config,json=servingConfig,proto3" json:"serving_config,omitempty"`
	// The branch resource name, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
	//
	// Use `default_branch` as the branch ID or leave this field empty, to search
	// documents under the default branch.
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3" json:"branch,omitempty"`
	// Raw search query.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// Maximum number of [Document][google.cloud.discoveryengine.v1beta.Document]s
	// to return. If unspecified, defaults to a reasonable value. The maximum
	// allowed value is 100. Values above 100 will be coerced to 100.
	//
	// If this field is negative, an  `INVALID_ARGUMENT`  is returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token received from a previous
	// [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
	// must match the call that provided the page token. Otherwise, an
	//  `INVALID_ARGUMENT`  error is returned.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A 0-indexed integer that specifies the current offset (that is, starting
	// result location, amongst the
	// [Document][google.cloud.discoveryengine.v1beta.Document]s deemed by the API
	// as relevant) in search results. This field is only considered if
	// [page_token][google.cloud.discoveryengine.v1beta.SearchRequest.page_token]
	// is unset.
	//
	// If this field is negative, an  `INVALID_ARGUMENT`  is returned.
	Offset int32 `protobuf:"varint,6,opt,name=offset,proto3" json:"offset,omitempty"`
	// The filter syntax consists of an expression language for constructing a
	// predicate from one or more fields of the documents being filtered. Filter
	// expression is case-sensitive.
	//
	// If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
	Filter string `protobuf:"bytes,7,opt,name=filter,proto3" json:"filter,omitempty"`
	// The order in which documents are returned. Document can be ordered by
	// a field in an [Document][google.cloud.discoveryengine.v1beta.Document]
	// object. Leave it unset if ordered by relevance. OrderBy expression is
	// case-sensitive.
	//
	// If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
	OrderBy string `protobuf:"bytes,8,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Information about the end user.
	// Highly recommended for analytics. The user_agent string in UserInfo will
	// be used to deduce device_type for analytics.
	UserInfo *UserInfo `protobuf:"bytes,21,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
	// Facet specifications for faceted search. If empty, no facets are returned.
	//
	// A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
	// error is returned.
	FacetSpecs []*SearchRequest_FacetSpec `protobuf:"bytes,9,rep,name=facet_specs,json=facetSpecs,proto3" json:"facet_specs,omitempty"`
	// Boost specification to boost certain documents.
	BoostSpec *SearchRequest_BoostSpec `protobuf:"bytes,10,opt,name=boost_spec,json=boostSpec,proto3" json:"boost_spec,omitempty"`
	// Additional search parameters.
	//
	// For public website search only, supported values are:
	//
	// * `user_country_code`: string. Default empty. If set to non-empty, results
	//    are restricted or boosted based on the location provided.
	// * `search_type`: double. Default empty. Enables non-webpage searching
	//   depending on the value. The only valid non-default value is 1,
	//   which enables image searching.
	Params map[string]*structpb.Value `protobuf:"bytes,11,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The query expansion specification that specifies the conditions under which
	// query expansion will occur.
	QueryExpansionSpec *SearchRequest_QueryExpansionSpec `protobuf:"bytes,13,opt,name=query_expansion_spec,json=queryExpansionSpec,proto3" json:"query_expansion_spec,omitempty"`
	// The spell correction specification that specifies the mode under
	// which spell correction will take effect.
	SpellCorrectionSpec *SearchRequest_SpellCorrectionSpec `protobuf:"bytes,14,opt,name=spell_correction_spec,json=spellCorrectionSpec,proto3" json:"spell_correction_spec,omitempty"`
	// A unique identifier for tracking visitors. For example, this could be
	// implemented with an HTTP cookie, which should be able to uniquely identify
	// a visitor on a single device. This unique identifier should not change if
	// the visitor logs in or out of the website.
	//
	// This field should NOT have a fixed value such as `unknown_visitor`.
	//
	// This should be the same identifier as
	// [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
	// and
	// [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.CompleteQueryRequest.user_pseudo_id]
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
	UserPseudoId string `protobuf:"bytes,15,opt,name=user_pseudo_id,json=userPseudoId,proto3" json:"user_pseudo_id,omitempty"`
	// The content search spec that configs the desired behavior of content
	// search.
	ContentSearchSpec *SearchRequest_ContentSearchSpec `protobuf:"bytes,24,opt,name=content_search_spec,json=contentSearchSpec,proto3" json:"content_search_spec,omitempty"`
	// Whether to turn on safe search. This is only supported for
	// [ContentConfig.PUBLIC_WEBSITE][].
	SafeSearch bool `protobuf:"varint,20,opt,name=safe_search,json=safeSearch,proto3" json:"safe_search,omitempty"`
	// The user labels applied to a resource must meet the following requirements:
	//
	// * Each resource can have multiple labels, up to a maximum of 64.
	// * Each label must be a key-value pair.
	// * Keys have a minimum length of 1 character and a maximum length of 63
	//   characters and cannot be empty. Values can be empty and have a maximum
	//   length of 63 characters.
	// * Keys and values can contain only lowercase letters, numeric characters,
	//   underscores, and dashes. All characters must use UTF-8 encoding, and
	//   international characters are allowed.
	// * The key portion of a label must be unique. However, you can use the same
	//   key with multiple resources.
	// * Keys must start with a lowercase letter or international character.
	//
	// See [Google Cloud
	// Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `protobuf:"bytes,22,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SearchRequest) Reset() {
	*x = SearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest) ProtoMessage() {}

func (x *SearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest.ProtoReflect.Descriptor instead.
func (*SearchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0}
}

func (x *SearchRequest) GetServingConfig() string {
	if x != nil {
		return x.ServingConfig
	}
	return ""
}

func (x *SearchRequest) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *SearchRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *SearchRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *SearchRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchRequest) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *SearchRequest) GetFacetSpecs() []*SearchRequest_FacetSpec {
	if x != nil {
		return x.FacetSpecs
	}
	return nil
}

func (x *SearchRequest) GetBoostSpec() *SearchRequest_BoostSpec {
	if x != nil {
		return x.BoostSpec
	}
	return nil
}

func (x *SearchRequest) GetParams() map[string]*structpb.Value {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *SearchRequest) GetQueryExpansionSpec() *SearchRequest_QueryExpansionSpec {
	if x != nil {
		return x.QueryExpansionSpec
	}
	return nil
}

func (x *SearchRequest) GetSpellCorrectionSpec() *SearchRequest_SpellCorrectionSpec {
	if x != nil {
		return x.SpellCorrectionSpec
	}
	return nil
}

func (x *SearchRequest) GetUserPseudoId() string {
	if x != nil {
		return x.UserPseudoId
	}
	return ""
}

func (x *SearchRequest) GetContentSearchSpec() *SearchRequest_ContentSearchSpec {
	if x != nil {
		return x.ContentSearchSpec
	}
	return nil
}

func (x *SearchRequest) GetSafeSearch() bool {
	if x != nil {
		return x.SafeSearch
	}
	return false
}

func (x *SearchRequest) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

// Response message for
// [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
// method.
type SearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of matched documents. The order represents the ranking.
	Results []*SearchResponse_SearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Results of facets requested by user.
	Facets []*SearchResponse_Facet `protobuf:"bytes,2,rep,name=facets,proto3" json:"facets,omitempty"`
	// Guided search result.
	GuidedSearchResult *SearchResponse_GuidedSearchResult `protobuf:"bytes,8,opt,name=guided_search_result,json=guidedSearchResult,proto3" json:"guided_search_result,omitempty"`
	// The estimated total count of matched items irrespective of pagination. The
	// count of
	// [results][google.cloud.discoveryengine.v1beta.SearchResponse.results]
	// returned by pagination may be less than the
	// [total_size][google.cloud.discoveryengine.v1beta.SearchResponse.total_size]
	// that matches.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// A unique search token. This should be included in the
	// [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] logs resulting
	// from this search, which enables accurate attribution of search model
	// performance.
	AttributionToken string `protobuf:"bytes,4,opt,name=attribution_token,json=attributionToken,proto3" json:"attribution_token,omitempty"`
	// The URI of a customer-defined redirect page. If redirect action is
	// triggered, no search is performed, and only
	// [redirect_uri][google.cloud.discoveryengine.v1beta.SearchResponse.redirect_uri]
	// and
	// [attribution_token][google.cloud.discoveryengine.v1beta.SearchResponse.attribution_token]
	// are set in the response.
	RedirectUri string `protobuf:"bytes,12,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
	// A token that can be sent as
	// [SearchRequest.page_token][google.cloud.discoveryengine.v1beta.SearchRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,5,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Contains the spell corrected query, if found. If the spell correction type
	// is AUTOMATIC, then the search results are based on corrected_query.
	// Otherwise the original query is used for search.
	CorrectedQuery string `protobuf:"bytes,7,opt,name=corrected_query,json=correctedQuery,proto3" json:"corrected_query,omitempty"`
	// A summary as part of the search results.
	// This field is only returned if
	// [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.summary_spec]
	// is set.
	Summary *SearchResponse_Summary `protobuf:"bytes,9,opt,name=summary,proto3" json:"summary,omitempty"`
	// Controls applied as part of the Control service.
	AppliedControls []string `protobuf:"bytes,10,rep,name=applied_controls,json=appliedControls,proto3" json:"applied_controls,omitempty"`
}

func (x *SearchResponse) Reset() {
	*x = SearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse) ProtoMessage() {}

func (x *SearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse.ProtoReflect.Descriptor instead.
func (*SearchResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchResponse) GetResults() []*SearchResponse_SearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchResponse) GetFacets() []*SearchResponse_Facet {
	if x != nil {
		return x.Facets
	}
	return nil
}

func (x *SearchResponse) GetGuidedSearchResult() *SearchResponse_GuidedSearchResult {
	if x != nil {
		return x.GuidedSearchResult
	}
	return nil
}

func (x *SearchResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *SearchResponse) GetAttributionToken() string {
	if x != nil {
		return x.AttributionToken
	}
	return ""
}

func (x *SearchResponse) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

func (x *SearchResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchResponse) GetCorrectedQuery() string {
	if x != nil {
		return x.CorrectedQuery
	}
	return ""
}

func (x *SearchResponse) GetSummary() *SearchResponse_Summary {
	if x != nil {
		return x.Summary
	}
	return nil
}

func (x *SearchResponse) GetAppliedControls() []string {
	if x != nil {
		return x.AppliedControls
	}
	return nil
}

// A facet specification to perform faceted search.
type SearchRequest_FacetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The facet key specification.
	FacetKey *SearchRequest_FacetSpec_FacetKey `protobuf:"bytes,1,opt,name=facet_key,json=facetKey,proto3" json:"facet_key,omitempty"`
	// Maximum of facet values that should be returned for this facet. If
	// unspecified, defaults to 20. The maximum allowed value is 300. Values
	// above 300 will be coerced to 300.
	//
	// If this field is negative, an  `INVALID_ARGUMENT`  is returned.
	Limit int32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// List of keys to exclude when faceting.
	//
	//
	// By default,
	// [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
	// is not excluded from the filter unless it is listed in this field.
	//
	// Listing a facet key in this field allows its values to appear as facet
	// results, even when they are filtered out of search results. Using this
	// field does not affect what search results are returned.
	//
	// For example, suppose there are 100 documents with the color facet "Red"
	// and 200 documents with the color facet "Blue". A query containing the
	// filter "color:ANY("Red")" and having "color" as
	// [FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key]
	// would by default return only "Red" documents in the search results, and
	// also return "Red" with count 100 as the only color facet. Although there
	// are also blue documents available, "Blue" would not be shown as an
	// available facet value.
	//
	// If "color" is listed in "excludedFilterKeys", then the query returns the
	// facet values "Red" with count 100 and "Blue" with count 200, because the
	// "color" key is now excluded from the filter. Because this field doesn't
	// affect search results, the search results are still correctly filtered to
	// return only "Red" documents.
	//
	// A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
	// error is returned.
	ExcludedFilterKeys []string `protobuf:"bytes,3,rep,name=excluded_filter_keys,json=excludedFilterKeys,proto3" json:"excluded_filter_keys,omitempty"`
	// Enables dynamic position for this facet. If set to true, the position of
	// this facet among all facets in the response is determined automatically.
	// It will be ordered together with dynamic facets if dynamic
	// facets is enabled. If set to false, the position of this facet in the
	// response will be the same as in the request, and it will be ranked before
	// the facets with dynamic position enable and all dynamic facets.
	//
	// For example, you may always want to have rating facet returned in
	// the response, but it's not necessarily to always display the rating facet
	// at the top. In that case, you can set enable_dynamic_position to true so
	// that the position of rating facet in response will be determined
	// automatically.
	//
	// Another example, assuming you have the following facets in the request:
	//
	// * "rating", enable_dynamic_position = true
	//
	// * "price", enable_dynamic_position = false
	//
	// * "brands", enable_dynamic_position = false
	//
	// And also you have a dynamic facets enable, which will generate a facet
	// 'gender'. Then the final order of the facets in the response can be
	// ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
	// "rating") depends on how API orders "gender" and "rating" facets.
	// However, notice that "price" and "brands" will always be
	// ranked at 1st and 2nd position since their enable_dynamic_position are
	// false.
	EnableDynamicPosition bool `protobuf:"varint,4,opt,name=enable_dynamic_position,json=enableDynamicPosition,proto3" json:"enable_dynamic_position,omitempty"`
}

func (x *SearchRequest_FacetSpec) Reset() {
	*x = SearchRequest_FacetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_FacetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_FacetSpec) ProtoMessage() {}

func (x *SearchRequest_FacetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_FacetSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_FacetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SearchRequest_FacetSpec) GetFacetKey() *SearchRequest_FacetSpec_FacetKey {
	if x != nil {
		return x.FacetKey
	}
	return nil
}

func (x *SearchRequest_FacetSpec) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *SearchRequest_FacetSpec) GetExcludedFilterKeys() []string {
	if x != nil {
		return x.ExcludedFilterKeys
	}
	return nil
}

func (x *SearchRequest_FacetSpec) GetEnableDynamicPosition() bool {
	if x != nil {
		return x.EnableDynamicPosition
	}
	return false
}

// Boost specification to boost certain documents.
type SearchRequest_BoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Condition boost specifications. If a document matches multiple conditions
	// in the specifictions, boost scores from these specifications are all
	// applied and combined in a non-linear way. Maximum number of
	// specifications is 20.
	ConditionBoostSpecs []*SearchRequest_BoostSpec_ConditionBoostSpec `protobuf:"bytes,1,rep,name=condition_boost_specs,json=conditionBoostSpecs,proto3" json:"condition_boost_specs,omitempty"`
}

func (x *SearchRequest_BoostSpec) Reset() {
	*x = SearchRequest_BoostSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_BoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_BoostSpec) ProtoMessage() {}

func (x *SearchRequest_BoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_BoostSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_BoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 1}
}

func (x *SearchRequest_BoostSpec) GetConditionBoostSpecs() []*SearchRequest_BoostSpec_ConditionBoostSpec {
	if x != nil {
		return x.ConditionBoostSpecs
	}
	return nil
}

// Specification to determine under which conditions query expansion should
// occur.
type SearchRequest_QueryExpansionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The condition under which query expansion should occur. Default to
	// [Condition.DISABLED][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
	Condition SearchRequest_QueryExpansionSpec_Condition `protobuf:"varint,1,opt,name=condition,proto3,enum=google.cloud.discoveryengine.v1beta.SearchRequest_QueryExpansionSpec_Condition" json:"condition,omitempty"`
}

func (x *SearchRequest_QueryExpansionSpec) Reset() {
	*x = SearchRequest_QueryExpansionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_QueryExpansionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_QueryExpansionSpec) ProtoMessage() {}

func (x *SearchRequest_QueryExpansionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_QueryExpansionSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_QueryExpansionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 2}
}

func (x *SearchRequest_QueryExpansionSpec) GetCondition() SearchRequest_QueryExpansionSpec_Condition {
	if x != nil {
		return x.Condition
	}
	return SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED
}

// The specification for query spell correction.
type SearchRequest_SpellCorrectionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mode under which spell correction should take effect to
	// replace the original search query. Default to
	// [Mode.AUTO][google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
	Mode SearchRequest_SpellCorrectionSpec_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.discoveryengine.v1beta.SearchRequest_SpellCorrectionSpec_Mode" json:"mode,omitempty"`
}

func (x *SearchRequest_SpellCorrectionSpec) Reset() {
	*x = SearchRequest_SpellCorrectionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_SpellCorrectionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_SpellCorrectionSpec) ProtoMessage() {}

func (x *SearchRequest_SpellCorrectionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_SpellCorrectionSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_SpellCorrectionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 3}
}

func (x *SearchRequest_SpellCorrectionSpec) GetMode() SearchRequest_SpellCorrectionSpec_Mode {
	if x != nil {
		return x.Mode
	}
	return SearchRequest_SpellCorrectionSpec_MODE_UNSPECIFIED
}

// The specification that configs the desired behavior of the UCS content
// search.
type SearchRequest_ContentSearchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If there is no snippet spec provided, there will be no snippet in the
	// search result.
	SnippetSpec *SearchRequest_ContentSearchSpec_SnippetSpec `protobuf:"bytes,1,opt,name=snippet_spec,json=snippetSpec,proto3" json:"snippet_spec,omitempty"`
	// If there is no summary spec provided, there will be no summary in the
	// search response.
	SummarySpec *SearchRequest_ContentSearchSpec_SummarySpec `protobuf:"bytes,2,opt,name=summary_spec,json=summarySpec,proto3" json:"summary_spec,omitempty"`
	// If there is no extractive_content_spec provided, there will be no
	// extractive answer in the search response.
	ExtractiveContentSpec *SearchRequest_ContentSearchSpec_ExtractiveContentSpec `protobuf:"bytes,3,opt,name=extractive_content_spec,json=extractiveContentSpec,proto3" json:"extractive_content_spec,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 4}
}

func (x *SearchRequest_ContentSearchSpec) GetSnippetSpec() *SearchRequest_ContentSearchSpec_SnippetSpec {
	if x != nil {
		return x.SnippetSpec
	}
	return nil
}

func (x *SearchRequest_ContentSearchSpec) GetSummarySpec() *SearchRequest_ContentSearchSpec_SummarySpec {
	if x != nil {
		return x.SummarySpec
	}
	return nil
}

func (x *SearchRequest_ContentSearchSpec) GetExtractiveContentSpec() *SearchRequest_ContentSearchSpec_ExtractiveContentSpec {
	if x != nil {
		return x.ExtractiveContentSpec
	}
	return nil
}

// Specifies how a facet is computed.
type SearchRequest_FacetSpec_FacetKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Supported textual and numerical facet keys in
	// [Document][google.cloud.discoveryengine.v1beta.Document] object, over
	// which the facet values are computed. Facet key is case-sensitive.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Set only if values should be bucketized into intervals. Must be set
	// for facets with numerical values. Must not be set for facet with text
	// values. Maximum number of intervals is 30.
	Intervals []*Interval `protobuf:"bytes,2,rep,name=intervals,proto3" json:"intervals,omitempty"`
	// Only get facet for the given restricted values. Only supported on
	// textual fields. For example, suppose "category" has three values
	// "Action > 2022", "Action > 2021" and "Sci-Fi > 2022". If set
	// "restricted_values" to "Action > 2022", the "category" facet will only
	// contain "Action > 2022". Only supported on textual fields. Maximum
	// is 10.
	RestrictedValues []string `protobuf:"bytes,3,rep,name=restricted_values,json=restrictedValues,proto3" json:"restricted_values,omitempty"`
	// Only get facet values that start with the given string prefix. For
	// example, suppose "category" has three values "Action > 2022",
	// "Action > 2021" and "Sci-Fi > 2022". If set "prefixes" to "Action", the
	// "category" facet will only contain "Action > 2022" and "Action > 2021".
	// Only supported on textual fields. Maximum is 10.
	Prefixes []string `protobuf:"bytes,4,rep,name=prefixes,proto3" json:"prefixes,omitempty"`
	// Only get facet values that contains the given strings. For example,
	// suppose "category" has three values "Action > 2022",
	// "Action > 2021" and "Sci-Fi > 2022". If set "contains" to "2022", the
	// "category" facet will only contain "Action > 2022" and "Sci-Fi > 2022".
	// Only supported on textual fields. Maximum is 10.
	Contains []string `protobuf:"bytes,5,rep,name=contains,proto3" json:"contains,omitempty"`
	// True to make facet keys case insensitive when getting faceting
	// values with prefixes or contains; false otherwise.
	CaseInsensitive bool `protobuf:"varint,6,opt,name=case_insensitive,json=caseInsensitive,proto3" json:"case_insensitive,omitempty"`
	// The order in which documents are returned.
	//
	// Allowed values are:
	//
	// * "count desc", which means order by
	// [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.count]
	// descending.
	//
	// * "value desc", which means order by
	// [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.value]
	// descending.
	//   Only applies to textual facets.
	//
	// If not set, textual values are sorted in [natural
	// order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
	// intervals are sorted in the order given by
	// [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
	OrderBy string `protobuf:"bytes,7,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchRequest_FacetSpec_FacetKey) Reset() {
	*x = SearchRequest_FacetSpec_FacetKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_FacetSpec_FacetKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_FacetSpec_FacetKey) ProtoMessage() {}

func (x *SearchRequest_FacetSpec_FacetKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_FacetSpec_FacetKey.ProtoReflect.Descriptor instead.
func (*SearchRequest_FacetSpec_FacetKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *SearchRequest_FacetSpec_FacetKey) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SearchRequest_FacetSpec_FacetKey) GetIntervals() []*Interval {
	if x != nil {
		return x.Intervals
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetRestrictedValues() []string {
	if x != nil {
		return x.RestrictedValues
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetPrefixes() []string {
	if x != nil {
		return x.Prefixes
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetContains() []string {
	if x != nil {
		return x.Contains
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetCaseInsensitive() bool {
	if x != nil {
		return x.CaseInsensitive
	}
	return false
}

func (x *SearchRequest_FacetSpec_FacetKey) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Boost applies to documents which match a condition.
type SearchRequest_BoostSpec_ConditionBoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression. See
	// [SearchRequest.filter][google.cloud.discoveryengine.v1beta.SearchRequest.filter]
	// for detail syntax and limitations.
	//
	// Examples:
	//
	// * To boost documents with document ID "doc_1" or "doc_2", and
	// color
	//   "Red" or "Blue":
	//     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
	Condition string `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Strength of the condition boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0.
	//
	// Setting to 1.0 gives the document a big promotion. However, it does not
	// necessarily mean that the boosted document will be the top result at
	// all times, nor that other documents will be excluded. Results could
	// still be shown even when none of them matches the condition. And
	// results that are significantly more relevant to the search query can
	// still trump your heavily favored but irrelevant documents.
	//
	// Setting to -1.0 gives the document a big demotion. However, results
	// that are deeply relevant might still be shown. The document will have
	// an upstream battle to get a fairly high ranking, but it is not blocked
	// out completely.
	//
	// Setting to 0.0 means no boost applied. The boosting condition is
	// ignored.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) Reset() {
	*x = SearchRequest_BoostSpec_ConditionBoostSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_BoostSpec_ConditionBoostSpec) ProtoMessage() {}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_BoostSpec_ConditionBoostSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_BoostSpec_ConditionBoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

// The specification that configs the snippet in the search results.
type SearchRequest_ContentSearchSpec_SnippetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max number of snippets returned in each search result.
	//
	// A snippet is an infomartive summary of a content with highlighting for
	// UI rendering.
	//
	// If the matching snippets is less than the max_snippet_count, return all
	// of the snippets; otherwise, return the max_snippet_count.
	//
	// At most 5 snippets will be returned for each SearchResult.
	MaxSnippetCount int32 `protobuf:"varint,1,opt,name=max_snippet_count,json=maxSnippetCount,proto3" json:"max_snippet_count,omitempty"`
	// if true, only snippet reference is returned.
	ReferenceOnly bool `protobuf:"varint,2,opt,name=reference_only,json=referenceOnly,proto3" json:"reference_only,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_SnippetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_SnippetSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_SnippetSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_SnippetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 4, 0}
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) GetMaxSnippetCount() int32 {
	if x != nil {
		return x.MaxSnippetCount
	}
	return 0
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) GetReferenceOnly() bool {
	if x != nil {
		return x.ReferenceOnly
	}
	return false
}

// The specification that configs the summary in the search response.
type SearchRequest_ContentSearchSpec_SummarySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of top results the summary should be generated from.
	// If the number of returned results is less than summary_result_count,
	// then the summary would be derived from all the results; otherwise, the
	// summary would be derived from the top results.
	//
	// At most 5 results can be used for generating summary.
	SummaryResultCount int32 `protobuf:"varint,1,opt,name=summary_result_count,json=summaryResultCount,proto3" json:"summary_result_count,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_SummarySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_SummarySpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_SummarySpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_SummarySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 4, 1}
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetSummaryResultCount() int32 {
	if x != nil {
		return x.SummaryResultCount
	}
	return 0
}

// The specification that configs the extractive content in search results.
type SearchRequest_ContentSearchSpec_ExtractiveContentSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The max number of extractive answers returned in each search result.
	//
	// An extractive answer is a verbatim answer extracted from the original
	// document, which provides precise and contextually relevant answer to
	// the search query.
	//
	// If the number of matching answers is less than the
	// extractive_answer_count, return all of the answers; otherwise, return
	// the extractive_answer_count.
	//
	// At most 5 answers will be returned for each SearchResult.
	MaxExtractiveAnswerCount int32 `protobuf:"varint,1,opt,name=max_extractive_answer_count,json=maxExtractiveAnswerCount,proto3" json:"max_extractive_answer_count,omitempty"`
	// The max number of extractive segments returned in each search result.
	//
	// An extractive segment is a text segment extracted from the original
	// document which is relevant to the search query and in general more
	// verbose than an extrative answer. The segment could then be used as
	// input for LLMs to generate summaries and answers.
	//
	// If the number of matching segments is less than the
	// max_extractive_segment_count, return all of the segments; otherwise,
	// return the max_extractive_segment_count.
	//
	// Currently one segment will be returned for each SearchResult.
	MaxExtractiveSegmentCount int32 `protobuf:"varint,2,opt,name=max_extractive_segment_count,json=maxExtractiveSegmentCount,proto3" json:"max_extractive_segment_count,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_ExtractiveContentSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_ExtractiveContentSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_ExtractiveContentSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_ExtractiveContentSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{0, 4, 2}
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) GetMaxExtractiveAnswerCount() int32 {
	if x != nil {
		return x.MaxExtractiveAnswerCount
	}
	return 0
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) GetMaxExtractiveSegmentCount() int32 {
	if x != nil {
		return x.MaxExtractiveSegmentCount
	}
	return 0
}

// Represents the search results.
type SearchResponse_SearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
	// searched [Document][google.cloud.discoveryengine.v1beta.Document].
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The document data snippet in the search response. Only fields that are
	// marked as retrievable are populated.
	Document *Document `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
}

func (x *SearchResponse_SearchResult) Reset() {
	*x = SearchResponse_SearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_SearchResult) ProtoMessage() {}

func (x *SearchResponse_SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_SearchResult.ProtoReflect.Descriptor instead.
func (*SearchResponse_SearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *SearchResponse_SearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SearchResponse_SearchResult) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

// A facet result.
type SearchResponse_Facet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key for this facet. E.g., "colors" or "price". It matches
	// [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The facet values for this field.
	Values []*SearchResponse_Facet_FacetValue `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// Whether the facet is dynamically generated.
	DynamicFacet bool `protobuf:"varint,3,opt,name=dynamic_facet,json=dynamicFacet,proto3" json:"dynamic_facet,omitempty"`
}

func (x *SearchResponse_Facet) Reset() {
	*x = SearchResponse_Facet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Facet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Facet) ProtoMessage() {}

func (x *SearchResponse_Facet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Facet.ProtoReflect.Descriptor instead.
func (*SearchResponse_Facet) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{1, 1}
}

func (x *SearchResponse_Facet) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SearchResponse_Facet) GetValues() []*SearchResponse_Facet_FacetValue {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *SearchResponse_Facet) GetDynamicFacet() bool {
	if x != nil {
		return x.DynamicFacet
	}
	return false
}

// Guided search result. The guided search helps user to refine the search
// results and narrow down to the real needs from a broaded search results.
type SearchResponse_GuidedSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of ranked refinement attributes.
	RefinementAttributes []*SearchResponse_GuidedSearchResult_RefinementAttribute `protobuf:"bytes,1,rep,name=refinement_attributes,json=refinementAttributes,proto3" json:"refinement_attributes,omitempty"`
}

func (x *SearchResponse_GuidedSearchResult) Reset() {
	*x = SearchResponse_GuidedSearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_GuidedSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_GuidedSearchResult) ProtoMessage() {}

func (x *SearchResponse_GuidedSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_GuidedSearchResult.ProtoReflect.Descriptor instead.
func (*SearchResponse_GuidedSearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{1, 2}
}

func (x *SearchResponse_GuidedSearchResult) GetRefinementAttributes() []*SearchResponse_GuidedSearchResult_RefinementAttribute {
	if x != nil {
		return x.RefinementAttributes
	}
	return nil
}

// Summary of the top N search result specified by the summary spec.
type SearchResponse_Summary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The summary content.
	SummaryText string `protobuf:"bytes,1,opt,name=summary_text,json=summaryText,proto3" json:"summary_text,omitempty"`
}

func (x *SearchResponse_Summary) Reset() {
	*x = SearchResponse_Summary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary) ProtoMessage() {}

func (x *SearchResponse_Summary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{1, 3}
}

func (x *SearchResponse_Summary) GetSummaryText() string {
	if x != nil {
		return x.SummaryText
	}
	return ""
}

// A facet value which contains value names and their count.
type SearchResponse_Facet_FacetValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A facet value which contains values.
	//
	// Types that are assignable to FacetValue:
	//	*SearchResponse_Facet_FacetValue_Value
	//	*SearchResponse_Facet_FacetValue_Interval
	FacetValue isSearchResponse_Facet_FacetValue_FacetValue `protobuf_oneof:"facet_value"`
	// Number of items that have this facet value.
	Count int64 `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *SearchResponse_Facet_FacetValue) Reset() {
	*x = SearchResponse_Facet_FacetValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Facet_FacetValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Facet_FacetValue) ProtoMessage() {}

func (x *SearchResponse_Facet_FacetValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Facet_FacetValue.ProtoReflect.Descriptor instead.
func (*SearchResponse_Facet_FacetValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (m *SearchResponse_Facet_FacetValue) GetFacetValue() isSearchResponse_Facet_FacetValue_FacetValue {
	if m != nil {
		return m.FacetValue
	}
	return nil
}

func (x *SearchResponse_Facet_FacetValue) GetValue() string {
	if x, ok := x.GetFacetValue().(*SearchResponse_Facet_FacetValue_Value); ok {
		return x.Value
	}
	return ""
}

func (x *SearchResponse_Facet_FacetValue) GetInterval() *Interval {
	if x, ok := x.GetFacetValue().(*SearchResponse_Facet_FacetValue_Interval); ok {
		return x.Interval
	}
	return nil
}

func (x *SearchResponse_Facet_FacetValue) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

type isSearchResponse_Facet_FacetValue_FacetValue interface {
	isSearchResponse_Facet_FacetValue_FacetValue()
}

type SearchResponse_Facet_FacetValue_Value struct {
	// Text value of a facet, such as "Black" for facet "colors".
	Value string `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

type SearchResponse_Facet_FacetValue_Interval struct {
	// Interval value for a facet, such as [10, 20) for facet "price". It
	// matches
	// [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
	Interval *Interval `protobuf:"bytes,2,opt,name=interval,proto3,oneof"`
}

func (*SearchResponse_Facet_FacetValue_Value) isSearchResponse_Facet_FacetValue_FacetValue() {}

func (*SearchResponse_Facet_FacetValue_Interval) isSearchResponse_Facet_FacetValue_FacetValue() {}

// Useful attribute for search result refinements.
type SearchResponse_GuidedSearchResult_RefinementAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Attribute key used to refine the results e.g. 'movie_type'.
	AttributeKey string `protobuf:"bytes,1,opt,name=attribute_key,json=attributeKey,proto3" json:"attribute_key,omitempty"`
	// Attribute value used to refine the results e.g. 'drama'.
	AttributeValue string `protobuf:"bytes,2,opt,name=attribute_value,json=attributeValue,proto3" json:"attribute_value,omitempty"`
}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) Reset() {
	*x = SearchResponse_GuidedSearchResult_RefinementAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_GuidedSearchResult_RefinementAttribute) ProtoMessage() {}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_GuidedSearchResult_RefinementAttribute.ProtoReflect.Descriptor instead.
func (*SearchResponse_GuidedSearchResult_RefinementAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP(), []int{1, 2, 0}
}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) GetAttributeKey() string {
	if x != nil {
		return x.AttributeKey
	}
	return ""
}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) GetAttributeValue() string {
	if x != nil {
		return x.AttributeValue
	}
	return ""
}

var File_google_cloud_discoveryengine_v1beta_search_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x95, 0x19, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x4a, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x5d, 0x0a, 0x0b, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x66, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x73, 0x12, 0x5b, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x56,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x77, 0x0a, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78,
	0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x12, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x7a, 0x0a, 0x15, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x13, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x24, 0x0a, 0x0e, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x70, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x50, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x49,
	0x64, 0x12, 0x74, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x61, 0x66, 0x65, 0x5f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x61,
	0x66, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x63, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x90, 0x04,
	0x0a, 0x09, 0x46, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x67, 0x0a, 0x09, 0x66,
	0x61, 0x63, 0x65, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x61, 0x63, 0x65,
	0x74, 0x4b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x36, 0x0a, 0x17,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x50, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x99, 0x02, 0x0a, 0x08, 0x46, 0x61, 0x63, 0x65, 0x74, 0x4b, 0x65,
	0x79, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4b, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x10, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x61,
	0x73, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x1a, 0xdb, 0x01, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x83,
	0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6f, 0x6f,
	0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x13, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x73, 0x1a, 0x48, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x6f, 0x73,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x1a, 0xc3,
	0x01, 0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6d, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x55,
	0x54, 0x4f, 0x10, 0x02, 0x1a, 0xb3, 0x01, 0x0a, 0x13, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f,
	0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f, 0x0a, 0x04,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53,
	0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x3b, 0x0a,
	0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x53,
	0x55, 0x47, 0x47, 0x45, 0x53, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x02, 0x1a, 0xcf, 0x05, 0x0a, 0x11, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x73, 0x0a, 0x0c, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0b, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x73, 0x0a, 0x0c, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0b, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x92, 0x01, 0x0a, 0x17, 0x65,
	0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x15, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x1a,
	0x60, 0x0a, 0x0b, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2a,
	0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x53, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4f, 0x6e, 0x6c,
	0x79, 0x1a, 0x3f, 0x0a, 0x0b, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x30, 0x0a, 0x14, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x1a, 0x97, 0x01, 0x0a, 0x15, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3d, 0x0a, 0x1b,
	0x6d, 0x61, 0x78, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x18, 0x6d, 0x61, 0x78, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x1c, 0x6d,
	0x61, 0x78, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x19, 0x6d, 0x61, 0x78, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x51, 0x0a, 0x0b,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xda,
	0x0a, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5a, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x51, 0x0a,
	0x06, 0x66, 0x61, 0x63, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x06, 0x66, 0x61, 0x63, 0x65, 0x74, 0x73,
	0x12, 0x78, 0x0a, 0x14, 0x67, 0x75, 0x69, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x47, 0x75, 0x69, 0x64, 0x65, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x12, 0x67, 0x75, 0x69, 0x64, 0x65, 0x64, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x72, 0x72,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x55, 0x0a, 0x07, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x1a, 0x69, 0x0a, 0x0c,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x49, 0x0a, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0xb5, 0x02, 0x0a, 0x05, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x5c, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x2e, 0x46,
	0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x66, 0x61, 0x63,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x46, 0x61, 0x63, 0x65, 0x74, 0x1a, 0x96, 0x01, 0x0a, 0x0a, 0x46, 0x61, 0x63, 0x65, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4b, 0x0a,
	0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x48, 0x00,
	0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0x0d, 0x0a, 0x0b, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a,
	0x8b, 0x02, 0x0a, 0x12, 0x47, 0x75, 0x69, 0x64, 0x65, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x8f, 0x01, 0x0a, 0x15, 0x72, 0x65, 0x66, 0x69, 0x6e,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x75, 0x69, 0x64,
	0x65, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52,
	0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x52, 0x14, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x63, 0x0a, 0x13, 0x52, 0x65, 0x66, 0x69,
	0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x2c, 0x0a,
	0x07, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x65, 0x78, 0x74, 0x32, 0xa3, 0x03, 0x0a, 0x0d,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xbd, 0x02,
	0x0a, 0x06, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xc9, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc2, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x67,
	0x3a, 0x01, 0x2a, 0x22, 0x62, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x54, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x1a, 0x52, 0xca,
	0x41, 0x1e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0x99, 0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x12, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45,
	0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02,
	0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_search_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_discoveryengine_v1beta_search_service_proto_goTypes = []interface{}{
	(SearchRequest_QueryExpansionSpec_Condition)(0),               // 0: google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
	(SearchRequest_SpellCorrectionSpec_Mode)(0),                   // 1: google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
	(*SearchRequest)(nil),                                         // 2: google.cloud.discoveryengine.v1beta.SearchRequest
	(*SearchResponse)(nil),                                        // 3: google.cloud.discoveryengine.v1beta.SearchResponse
	(*SearchRequest_FacetSpec)(nil),                               // 4: google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
	(*SearchRequest_BoostSpec)(nil),                               // 5: google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
	(*SearchRequest_QueryExpansionSpec)(nil),                      // 6: google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
	(*SearchRequest_SpellCorrectionSpec)(nil),                     // 7: google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
	(*SearchRequest_ContentSearchSpec)(nil),                       // 8: google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
	nil,                                                           // 9: google.cloud.discoveryengine.v1beta.SearchRequest.ParamsEntry
	nil,                                                           // 10: google.cloud.discoveryengine.v1beta.SearchRequest.UserLabelsEntry
	(*SearchRequest_FacetSpec_FacetKey)(nil),                      // 11: google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
	(*SearchRequest_BoostSpec_ConditionBoostSpec)(nil),            // 12: google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
	(*SearchRequest_ContentSearchSpec_SnippetSpec)(nil),           // 13: google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
	(*SearchRequest_ContentSearchSpec_SummarySpec)(nil),           // 14: google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
	(*SearchRequest_ContentSearchSpec_ExtractiveContentSpec)(nil), // 15: google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec
	(*SearchResponse_SearchResult)(nil),                           // 16: google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
	(*SearchResponse_Facet)(nil),                                  // 17: google.cloud.discoveryengine.v1beta.SearchResponse.Facet
	(*SearchResponse_GuidedSearchResult)(nil),                     // 18: google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
	(*SearchResponse_Summary)(nil),                                // 19: google.cloud.discoveryengine.v1beta.SearchResponse.Summary
	(*SearchResponse_Facet_FacetValue)(nil),                       // 20: google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
	(*SearchResponse_GuidedSearchResult_RefinementAttribute)(nil), // 21: google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute
	(*UserInfo)(nil),                                              // 22: google.cloud.discoveryengine.v1beta.UserInfo
	(*structpb.Value)(nil),                                        // 23: google.protobuf.Value
	(*Interval)(nil),                                              // 24: google.cloud.discoveryengine.v1beta.Interval
	(*Document)(nil),                                              // 25: google.cloud.discoveryengine.v1beta.Document
}
var file_google_cloud_discoveryengine_v1beta_search_service_proto_depIdxs = []int32{
	22, // 0: google.cloud.discoveryengine.v1beta.SearchRequest.user_info:type_name -> google.cloud.discoveryengine.v1beta.UserInfo
	4,  // 1: google.cloud.discoveryengine.v1beta.SearchRequest.facet_specs:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec
	5,  // 2: google.cloud.discoveryengine.v1beta.SearchRequest.boost_spec:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec
	9,  // 3: google.cloud.discoveryengine.v1beta.SearchRequest.params:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.ParamsEntry
	6,  // 4: google.cloud.discoveryengine.v1beta.SearchRequest.query_expansion_spec:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec
	7,  // 5: google.cloud.discoveryengine.v1beta.SearchRequest.spell_correction_spec:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec
	8,  // 6: google.cloud.discoveryengine.v1beta.SearchRequest.content_search_spec:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec
	10, // 7: google.cloud.discoveryengine.v1beta.SearchRequest.user_labels:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.UserLabelsEntry
	16, // 8: google.cloud.discoveryengine.v1beta.SearchResponse.results:type_name -> google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
	17, // 9: google.cloud.discoveryengine.v1beta.SearchResponse.facets:type_name -> google.cloud.discoveryengine.v1beta.SearchResponse.Facet
	18, // 10: google.cloud.discoveryengine.v1beta.SearchResponse.guided_search_result:type_name -> google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
	19, // 11: google.cloud.discoveryengine.v1beta.SearchResponse.summary:type_name -> google.cloud.discoveryengine.v1beta.SearchResponse.Summary
	11, // 12: google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.facet_key:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey
	12, // 13: google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.condition_boost_specs:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.BoostSpec.ConditionBoostSpec
	0,  // 14: google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.condition:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.Condition
	1,  // 15: google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.mode:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.SpellCorrectionSpec.Mode
	13, // 16: google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.snippet_spec:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SnippetSpec
	14, // 17: google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.summary_spec:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec
	15, // 18: google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.extractive_content_spec:type_name -> google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.ExtractiveContentSpec
	23, // 19: google.cloud.discoveryengine.v1beta.SearchRequest.ParamsEntry.value:type_name -> google.protobuf.Value
	24, // 20: google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals:type_name -> google.cloud.discoveryengine.v1beta.Interval
	25, // 21: google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult.document:type_name -> google.cloud.discoveryengine.v1beta.Document
	20, // 22: google.cloud.discoveryengine.v1beta.SearchResponse.Facet.values:type_name -> google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
	21, // 23: google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.refinement_attributes:type_name -> google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute
	24, // 24: google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.interval:type_name -> google.cloud.discoveryengine.v1beta.Interval
	2,  // 25: google.cloud.discoveryengine.v1beta.SearchService.Search:input_type -> google.cloud.discoveryengine.v1beta.SearchRequest
	3,  // 26: google.cloud.discoveryengine.v1beta.SearchService.Search:output_type -> google.cloud.discoveryengine.v1beta.SearchResponse
	26, // [26:27] is the sub-list for method output_type
	25, // [25:26] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_search_service_proto_init() }
func file_google_cloud_discoveryengine_v1beta_search_service_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_search_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_common_proto_init()
	file_google_cloud_discoveryengine_v1beta_document_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_FacetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_BoostSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_QueryExpansionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_SpellCorrectionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_FacetSpec_FacetKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_BoostSpec_ConditionBoostSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_SnippetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_SummarySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_ExtractiveContentSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_SearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Facet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_GuidedSearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Facet_FacetValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_GuidedSearchResult_RefinementAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*SearchResponse_Facet_FacetValue_Value)(nil),
		(*SearchResponse_Facet_FacetValue_Interval)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_search_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_search_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1beta_search_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_search_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_search_service_proto = out.File
	file_google_cloud_discoveryengine_v1beta_search_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_search_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_search_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SearchServiceClient is the client API for SearchService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SearchServiceClient interface {
	// Performs a search.
	Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error)
}

type searchServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSearchServiceClient(cc grpc.ClientConnInterface) SearchServiceClient {
	return &searchServiceClient{cc}
}

func (c *searchServiceClient) Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error) {
	out := new(SearchResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SearchService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SearchServiceServer is the server API for SearchService service.
type SearchServiceServer interface {
	// Performs a search.
	Search(context.Context, *SearchRequest) (*SearchResponse, error)
}

// UnimplementedSearchServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSearchServiceServer struct {
}

func (*UnimplementedSearchServiceServer) Search(context.Context, *SearchRequest) (*SearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Search not implemented")
}

func RegisterSearchServiceServer(s *grpc.Server, srv SearchServiceServer) {
	s.RegisterService(&_SearchService_serviceDesc, srv)
}

func _SearchService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SearchService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchServiceServer).Search(ctx, req.(*SearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SearchService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1beta.SearchService",
	HandlerType: (*SearchServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _SearchService_Search_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1beta/search_service.proto",
}
