// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/datastream/v1/datastream_resources.proto

package datastreampb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Private Connection state.
type PrivateConnection_State int32

const (
	// Unspecified state.
	PrivateConnection_STATE_UNSPECIFIED PrivateConnection_State = 0
	// The private connection is in creation state - creating resources.
	PrivateConnection_CREATING PrivateConnection_State = 1
	// The private connection has been created with all of its resources.
	PrivateConnection_CREATED PrivateConnection_State = 2
	// The private connection creation has failed.
	PrivateConnection_FAILED PrivateConnection_State = 3
	// The private connection is being deleted.
	PrivateConnection_DELETING PrivateConnection_State = 4
	// Delete request has failed, resource is in invalid state.
	PrivateConnection_FAILED_TO_DELETE PrivateConnection_State = 5
)

// Enum value maps for PrivateConnection_State.
var (
	PrivateConnection_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "CREATED",
		3: "FAILED",
		4: "DELETING",
		5: "FAILED_TO_DELETE",
	}
	PrivateConnection_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"CREATED":           2,
		"FAILED":            3,
		"DELETING":          4,
		"FAILED_TO_DELETE":  5,
	}
)

func (x PrivateConnection_State) Enum() *PrivateConnection_State {
	p := new(PrivateConnection_State)
	*p = x
	return p
}

func (x PrivateConnection_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[0].Descriptor()
}

func (PrivateConnection_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[0]
}

func (x PrivateConnection_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_State.Descriptor instead.
func (PrivateConnection_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{8, 0}
}

// Schema file format.
type JsonFileFormat_SchemaFileFormat int32

const (
	// Unspecified schema file format.
	JsonFileFormat_SCHEMA_FILE_FORMAT_UNSPECIFIED JsonFileFormat_SchemaFileFormat = 0
	// Do not attach schema file.
	JsonFileFormat_NO_SCHEMA_FILE JsonFileFormat_SchemaFileFormat = 1
	// Avro schema format.
	JsonFileFormat_AVRO_SCHEMA_FILE JsonFileFormat_SchemaFileFormat = 2
)

// Enum value maps for JsonFileFormat_SchemaFileFormat.
var (
	JsonFileFormat_SchemaFileFormat_name = map[int32]string{
		0: "SCHEMA_FILE_FORMAT_UNSPECIFIED",
		1: "NO_SCHEMA_FILE",
		2: "AVRO_SCHEMA_FILE",
	}
	JsonFileFormat_SchemaFileFormat_value = map[string]int32{
		"SCHEMA_FILE_FORMAT_UNSPECIFIED": 0,
		"NO_SCHEMA_FILE":                 1,
		"AVRO_SCHEMA_FILE":               2,
	}
)

func (x JsonFileFormat_SchemaFileFormat) Enum() *JsonFileFormat_SchemaFileFormat {
	p := new(JsonFileFormat_SchemaFileFormat)
	*p = x
	return p
}

func (x JsonFileFormat_SchemaFileFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JsonFileFormat_SchemaFileFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[1].Descriptor()
}

func (JsonFileFormat_SchemaFileFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[1]
}

func (x JsonFileFormat_SchemaFileFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JsonFileFormat_SchemaFileFormat.Descriptor instead.
func (JsonFileFormat_SchemaFileFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{30, 0}
}

// Json file compression.
type JsonFileFormat_JsonCompression int32

const (
	// Unspecified json file compression.
	JsonFileFormat_JSON_COMPRESSION_UNSPECIFIED JsonFileFormat_JsonCompression = 0
	// Do not compress JSON file.
	JsonFileFormat_NO_COMPRESSION JsonFileFormat_JsonCompression = 1
	// Gzip compression.
	JsonFileFormat_GZIP JsonFileFormat_JsonCompression = 2
)

// Enum value maps for JsonFileFormat_JsonCompression.
var (
	JsonFileFormat_JsonCompression_name = map[int32]string{
		0: "JSON_COMPRESSION_UNSPECIFIED",
		1: "NO_COMPRESSION",
		2: "GZIP",
	}
	JsonFileFormat_JsonCompression_value = map[string]int32{
		"JSON_COMPRESSION_UNSPECIFIED": 0,
		"NO_COMPRESSION":               1,
		"GZIP":                         2,
	}
)

func (x JsonFileFormat_JsonCompression) Enum() *JsonFileFormat_JsonCompression {
	p := new(JsonFileFormat_JsonCompression)
	*p = x
	return p
}

func (x JsonFileFormat_JsonCompression) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JsonFileFormat_JsonCompression) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[2].Descriptor()
}

func (JsonFileFormat_JsonCompression) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[2]
}

func (x JsonFileFormat_JsonCompression) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JsonFileFormat_JsonCompression.Descriptor instead.
func (JsonFileFormat_JsonCompression) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{30, 1}
}

// Stream state.
type Stream_State int32

const (
	// Unspecified stream state.
	Stream_STATE_UNSPECIFIED Stream_State = 0
	// The stream has been created but has not yet started streaming data.
	Stream_NOT_STARTED Stream_State = 1
	// The stream is running.
	Stream_RUNNING Stream_State = 2
	// The stream is paused.
	Stream_PAUSED Stream_State = 3
	// The stream is in maintenance mode.
	//
	// Updates are rejected on the resource in this state.
	Stream_MAINTENANCE Stream_State = 4
	// The stream is experiencing an error that is preventing data from being
	// streamed.
	Stream_FAILED Stream_State = 5
	// The stream has experienced a terminal failure.
	Stream_FAILED_PERMANENTLY Stream_State = 6
	// The stream is starting, but not yet running.
	Stream_STARTING Stream_State = 7
	// The Stream is no longer reading new events, but still writing events in
	// the buffer.
	Stream_DRAINING Stream_State = 8
)

// Enum value maps for Stream_State.
var (
	Stream_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "NOT_STARTED",
		2: "RUNNING",
		3: "PAUSED",
		4: "MAINTENANCE",
		5: "FAILED",
		6: "FAILED_PERMANENTLY",
		7: "STARTING",
		8: "DRAINING",
	}
	Stream_State_value = map[string]int32{
		"STATE_UNSPECIFIED":  0,
		"NOT_STARTED":        1,
		"RUNNING":            2,
		"PAUSED":             3,
		"MAINTENANCE":        4,
		"FAILED":             5,
		"FAILED_PERMANENTLY": 6,
		"STARTING":           7,
		"DRAINING":           8,
	}
)

func (x Stream_State) Enum() *Stream_State {
	p := new(Stream_State)
	*p = x
	return p
}

func (x Stream_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Stream_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[3].Descriptor()
}

func (Stream_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[3]
}

func (x Stream_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Stream_State.Descriptor instead.
func (Stream_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{34, 0}
}

// State of the stream object's backfill job.
type BackfillJob_State int32

const (
	// Default value.
	BackfillJob_STATE_UNSPECIFIED BackfillJob_State = 0
	// Backfill job was never started for the stream object (stream has backfill
	// strategy defined as manual or object was explicitly excluded from
	// automatic backfill).
	BackfillJob_NOT_STARTED BackfillJob_State = 1
	// Backfill job will start pending available resources.
	BackfillJob_PENDING BackfillJob_State = 2
	// Backfill job is running.
	BackfillJob_ACTIVE BackfillJob_State = 3
	// Backfill job stopped (next job run will start from beginning).
	BackfillJob_STOPPED BackfillJob_State = 4
	// Backfill job failed (due to an error).
	BackfillJob_FAILED BackfillJob_State = 5
	// Backfill completed successfully.
	BackfillJob_COMPLETED BackfillJob_State = 6
	// Backfill job failed since the table structure is currently unsupported
	// for backfill.
	BackfillJob_UNSUPPORTED BackfillJob_State = 7
)

// Enum value maps for BackfillJob_State.
var (
	BackfillJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "NOT_STARTED",
		2: "PENDING",
		3: "ACTIVE",
		4: "STOPPED",
		5: "FAILED",
		6: "COMPLETED",
		7: "UNSUPPORTED",
	}
	BackfillJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"NOT_STARTED":       1,
		"PENDING":           2,
		"ACTIVE":            3,
		"STOPPED":           4,
		"FAILED":            5,
		"COMPLETED":         6,
		"UNSUPPORTED":       7,
	}
)

func (x BackfillJob_State) Enum() *BackfillJob_State {
	p := new(BackfillJob_State)
	*p = x
	return p
}

func (x BackfillJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackfillJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[4].Descriptor()
}

func (BackfillJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[4]
}

func (x BackfillJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackfillJob_State.Descriptor instead.
func (BackfillJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{37, 0}
}

// Triggering reason for a backfill job.
type BackfillJob_Trigger int32

const (
	// Default value.
	BackfillJob_TRIGGER_UNSPECIFIED BackfillJob_Trigger = 0
	// Object backfill job was triggered automatically according to the stream's
	// backfill strategy.
	BackfillJob_AUTOMATIC BackfillJob_Trigger = 1
	// Object backfill job was triggered manually using the dedicated API.
	BackfillJob_MANUAL BackfillJob_Trigger = 2
)

// Enum value maps for BackfillJob_Trigger.
var (
	BackfillJob_Trigger_name = map[int32]string{
		0: "TRIGGER_UNSPECIFIED",
		1: "AUTOMATIC",
		2: "MANUAL",
	}
	BackfillJob_Trigger_value = map[string]int32{
		"TRIGGER_UNSPECIFIED": 0,
		"AUTOMATIC":           1,
		"MANUAL":              2,
	}
)

func (x BackfillJob_Trigger) Enum() *BackfillJob_Trigger {
	p := new(BackfillJob_Trigger)
	*p = x
	return p
}

func (x BackfillJob_Trigger) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackfillJob_Trigger) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[5].Descriptor()
}

func (BackfillJob_Trigger) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[5]
}

func (x BackfillJob_Trigger) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackfillJob_Trigger.Descriptor instead.
func (BackfillJob_Trigger) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{37, 1}
}

// Validation execution state.
type Validation_State int32

const (
	// Unspecified state.
	Validation_STATE_UNSPECIFIED Validation_State = 0
	// Validation did not execute.
	Validation_NOT_EXECUTED Validation_State = 1
	// Validation failed.
	Validation_FAILED Validation_State = 2
	// Validation passed.
	Validation_PASSED Validation_State = 3
)

// Enum value maps for Validation_State.
var (
	Validation_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "NOT_EXECUTED",
		2: "FAILED",
		3: "PASSED",
	}
	Validation_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"NOT_EXECUTED":      1,
		"FAILED":            2,
		"PASSED":            3,
	}
)

func (x Validation_State) Enum() *Validation_State {
	p := new(Validation_State)
	*p = x
	return p
}

func (x Validation_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Validation_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[6].Descriptor()
}

func (Validation_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[6]
}

func (x Validation_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Validation_State.Descriptor instead.
func (Validation_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{40, 0}
}

// Validation message level.
type ValidationMessage_Level int32

const (
	// Unspecified level.
	ValidationMessage_LEVEL_UNSPECIFIED ValidationMessage_Level = 0
	// Potentially cause issues with the Stream.
	ValidationMessage_WARNING ValidationMessage_Level = 1
	// Definitely cause issues with the Stream.
	ValidationMessage_ERROR ValidationMessage_Level = 2
)

// Enum value maps for ValidationMessage_Level.
var (
	ValidationMessage_Level_name = map[int32]string{
		0: "LEVEL_UNSPECIFIED",
		1: "WARNING",
		2: "ERROR",
	}
	ValidationMessage_Level_value = map[string]int32{
		"LEVEL_UNSPECIFIED": 0,
		"WARNING":           1,
		"ERROR":             2,
	}
)

func (x ValidationMessage_Level) Enum() *ValidationMessage_Level {
	p := new(ValidationMessage_Level)
	*p = x
	return p
}

func (x ValidationMessage_Level) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValidationMessage_Level) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[7].Descriptor()
}

func (ValidationMessage_Level) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes[7]
}

func (x ValidationMessage_Level) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValidationMessage_Level.Descriptor instead.
func (ValidationMessage_Level) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{41, 0}
}

// Oracle database profile.
type OracleProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hostname for the Oracle connection.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Port for the Oracle connection, default value is 1521.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Required. Username for the Oracle connection.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Password for the Oracle connection.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// Required. Database for the Oracle connection.
	DatabaseService string `protobuf:"bytes,5,opt,name=database_service,json=databaseService,proto3" json:"database_service,omitempty"`
	// Connection string attributes
	ConnectionAttributes map[string]string `protobuf:"bytes,6,rep,name=connection_attributes,json=connectionAttributes,proto3" json:"connection_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *OracleProfile) Reset() {
	*x = OracleProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleProfile) ProtoMessage() {}

func (x *OracleProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleProfile.ProtoReflect.Descriptor instead.
func (*OracleProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{0}
}

func (x *OracleProfile) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *OracleProfile) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *OracleProfile) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *OracleProfile) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *OracleProfile) GetDatabaseService() string {
	if x != nil {
		return x.DatabaseService
	}
	return ""
}

func (x *OracleProfile) GetConnectionAttributes() map[string]string {
	if x != nil {
		return x.ConnectionAttributes
	}
	return nil
}

// MySQL database profile.
type MysqlProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hostname for the MySQL connection.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Port for the MySQL connection, default value is 3306.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Required. Username for the MySQL connection.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Input only. Password for the MySQL connection.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// SSL configuration for the MySQL connection.
	SslConfig *MysqlSslConfig `protobuf:"bytes,5,opt,name=ssl_config,json=sslConfig,proto3" json:"ssl_config,omitempty"`
}

func (x *MysqlProfile) Reset() {
	*x = MysqlProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlProfile) ProtoMessage() {}

func (x *MysqlProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlProfile.ProtoReflect.Descriptor instead.
func (*MysqlProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{1}
}

func (x *MysqlProfile) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *MysqlProfile) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MysqlProfile) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *MysqlProfile) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *MysqlProfile) GetSslConfig() *MysqlSslConfig {
	if x != nil {
		return x.SslConfig
	}
	return nil
}

// PostgreSQL database profile.
type PostgresqlProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hostname for the PostgreSQL connection.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Port for the PostgreSQL connection, default value is 5432.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Required. Username for the PostgreSQL connection.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Password for the PostgreSQL connection.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// Required. Database for the PostgreSQL connection.
	Database string `protobuf:"bytes,5,opt,name=database,proto3" json:"database,omitempty"`
}

func (x *PostgresqlProfile) Reset() {
	*x = PostgresqlProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgresqlProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgresqlProfile) ProtoMessage() {}

func (x *PostgresqlProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgresqlProfile.ProtoReflect.Descriptor instead.
func (*PostgresqlProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{2}
}

func (x *PostgresqlProfile) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *PostgresqlProfile) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *PostgresqlProfile) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *PostgresqlProfile) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *PostgresqlProfile) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

// Cloud Storage bucket profile.
type GcsProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cloud Storage bucket name.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The root path inside the Cloud Storage bucket.
	RootPath string `protobuf:"bytes,2,opt,name=root_path,json=rootPath,proto3" json:"root_path,omitempty"`
}

func (x *GcsProfile) Reset() {
	*x = GcsProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsProfile) ProtoMessage() {}

func (x *GcsProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsProfile.ProtoReflect.Descriptor instead.
func (*GcsProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{3}
}

func (x *GcsProfile) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GcsProfile) GetRootPath() string {
	if x != nil {
		return x.RootPath
	}
	return ""
}

// BigQuery warehouse profile.
type BigQueryProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BigQueryProfile) Reset() {
	*x = BigQueryProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryProfile) ProtoMessage() {}

func (x *BigQueryProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryProfile.ProtoReflect.Descriptor instead.
func (*BigQueryProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{4}
}

// Static IP address connectivity. Used when the source database is configured
// to allow incoming connections from the Datastream public IP addresses
// for the region specified in the connection profile.
type StaticServiceIpConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StaticServiceIpConnectivity) Reset() {
	*x = StaticServiceIpConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StaticServiceIpConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticServiceIpConnectivity) ProtoMessage() {}

func (x *StaticServiceIpConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticServiceIpConnectivity.ProtoReflect.Descriptor instead.
func (*StaticServiceIpConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{5}
}

// Forward SSH Tunnel connectivity.
type ForwardSshTunnelConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hostname for the SSH tunnel.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Required. Username for the SSH tunnel.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// Port for the SSH tunnel, default value is 22.
	Port int32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// Types that are assignable to AuthenticationMethod:
	//	*ForwardSshTunnelConnectivity_Password
	//	*ForwardSshTunnelConnectivity_PrivateKey
	AuthenticationMethod isForwardSshTunnelConnectivity_AuthenticationMethod `protobuf_oneof:"authentication_method"`
}

func (x *ForwardSshTunnelConnectivity) Reset() {
	*x = ForwardSshTunnelConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardSshTunnelConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardSshTunnelConnectivity) ProtoMessage() {}

func (x *ForwardSshTunnelConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardSshTunnelConnectivity.ProtoReflect.Descriptor instead.
func (*ForwardSshTunnelConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{6}
}

func (x *ForwardSshTunnelConnectivity) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *ForwardSshTunnelConnectivity) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *ForwardSshTunnelConnectivity) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (m *ForwardSshTunnelConnectivity) GetAuthenticationMethod() isForwardSshTunnelConnectivity_AuthenticationMethod {
	if m != nil {
		return m.AuthenticationMethod
	}
	return nil
}

func (x *ForwardSshTunnelConnectivity) GetPassword() string {
	if x, ok := x.GetAuthenticationMethod().(*ForwardSshTunnelConnectivity_Password); ok {
		return x.Password
	}
	return ""
}

func (x *ForwardSshTunnelConnectivity) GetPrivateKey() string {
	if x, ok := x.GetAuthenticationMethod().(*ForwardSshTunnelConnectivity_PrivateKey); ok {
		return x.PrivateKey
	}
	return ""
}

type isForwardSshTunnelConnectivity_AuthenticationMethod interface {
	isForwardSshTunnelConnectivity_AuthenticationMethod()
}

type ForwardSshTunnelConnectivity_Password struct {
	// Input only. SSH password.
	Password string `protobuf:"bytes,100,opt,name=password,proto3,oneof"`
}

type ForwardSshTunnelConnectivity_PrivateKey struct {
	// Input only. SSH private key.
	PrivateKey string `protobuf:"bytes,101,opt,name=private_key,json=privateKey,proto3,oneof"`
}

func (*ForwardSshTunnelConnectivity_Password) isForwardSshTunnelConnectivity_AuthenticationMethod() {}

func (*ForwardSshTunnelConnectivity_PrivateKey) isForwardSshTunnelConnectivity_AuthenticationMethod() {
}

// The VPC Peering configuration is used to create VPC peering between
// Datastream and the consumer's VPC.
type VpcPeeringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified name of the VPC that Datastream will peer to.
	// Format: `projects/{project}/global/{networks}/{name}`
	Vpc string `protobuf:"bytes,1,opt,name=vpc,proto3" json:"vpc,omitempty"`
	// Required. A free subnet for peering. (CIDR of /29)
	Subnet string `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
}

func (x *VpcPeeringConfig) Reset() {
	*x = VpcPeeringConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpcPeeringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpcPeeringConfig) ProtoMessage() {}

func (x *VpcPeeringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpcPeeringConfig.ProtoReflect.Descriptor instead.
func (*VpcPeeringConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{7}
}

func (x *VpcPeeringConfig) GetVpc() string {
	if x != nil {
		return x.Vpc
	}
	return ""
}

func (x *VpcPeeringConfig) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

// The PrivateConnection resource is used to establish private connectivity
// between Datastream and a customer's network.
type PrivateConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time of the resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time of the resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The state of the Private Connection.
	State PrivateConnection_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.datastream.v1.PrivateConnection_State" json:"state,omitempty"`
	// Output only. In case of error, the details of the error in a user-friendly
	// format.
	Error *Error `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
	// VPC Peering Config.
	VpcPeeringConfig *VpcPeeringConfig `protobuf:"bytes,100,opt,name=vpc_peering_config,json=vpcPeeringConfig,proto3" json:"vpc_peering_config,omitempty"`
}

func (x *PrivateConnection) Reset() {
	*x = PrivateConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateConnection) ProtoMessage() {}

func (x *PrivateConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateConnection.ProtoReflect.Descriptor instead.
func (*PrivateConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{8}
}

func (x *PrivateConnection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PrivateConnection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PrivateConnection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PrivateConnection) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PrivateConnection) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PrivateConnection) GetState() PrivateConnection_State {
	if x != nil {
		return x.State
	}
	return PrivateConnection_STATE_UNSPECIFIED
}

func (x *PrivateConnection) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *PrivateConnection) GetVpcPeeringConfig() *VpcPeeringConfig {
	if x != nil {
		return x.VpcPeeringConfig
	}
	return nil
}

// Private Connectivity
type PrivateConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A reference to a private connection resource.
	// Format: `projects/{project}/locations/{location}/privateConnections/{name}`
	PrivateConnection string `protobuf:"bytes,1,opt,name=private_connection,json=privateConnection,proto3" json:"private_connection,omitempty"`
}

func (x *PrivateConnectivity) Reset() {
	*x = PrivateConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateConnectivity) ProtoMessage() {}

func (x *PrivateConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateConnectivity.ProtoReflect.Descriptor instead.
func (*PrivateConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{9}
}

func (x *PrivateConnectivity) GetPrivateConnection() string {
	if x != nil {
		return x.PrivateConnection
	}
	return ""
}

// The route resource is the child of the private connection resource,
// used for defining a route for a private connection.
type Route struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time of the resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time of the resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Destination address for connection
	DestinationAddress string `protobuf:"bytes,6,opt,name=destination_address,json=destinationAddress,proto3" json:"destination_address,omitempty"`
	// Destination port for connection
	DestinationPort int32 `protobuf:"varint,7,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
}

func (x *Route) Reset() {
	*x = Route{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Route) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Route) ProtoMessage() {}

func (x *Route) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Route.ProtoReflect.Descriptor instead.
func (*Route) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{10}
}

func (x *Route) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Route) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Route) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Route) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Route) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Route) GetDestinationAddress() string {
	if x != nil {
		return x.DestinationAddress
	}
	return ""
}

func (x *Route) GetDestinationPort() int32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

// MySQL SSL configuration information.
type MysqlSslConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input only. PEM-encoded private key associated with the Client Certificate.
	// If this field is used then the 'client_certificate' and the
	// 'ca_certificate' fields are mandatory.
	ClientKey string `protobuf:"bytes,1,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// Output only. Indicates whether the client_key field is set.
	ClientKeySet bool `protobuf:"varint,2,opt,name=client_key_set,json=clientKeySet,proto3" json:"client_key_set,omitempty"`
	// Input only. PEM-encoded certificate that will be used by the replica to
	// authenticate against the source database server. If this field is used
	// then the 'client_key' and the 'ca_certificate' fields are mandatory.
	ClientCertificate string `protobuf:"bytes,3,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// Output only. Indicates whether the client_certificate field is set.
	ClientCertificateSet bool `protobuf:"varint,4,opt,name=client_certificate_set,json=clientCertificateSet,proto3" json:"client_certificate_set,omitempty"`
	// Input only. PEM-encoded certificate of the CA that signed the source
	// database server's certificate.
	CaCertificate string `protobuf:"bytes,5,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
	// Output only. Indicates whether the ca_certificate field is set.
	CaCertificateSet bool `protobuf:"varint,6,opt,name=ca_certificate_set,json=caCertificateSet,proto3" json:"ca_certificate_set,omitempty"`
}

func (x *MysqlSslConfig) Reset() {
	*x = MysqlSslConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlSslConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlSslConfig) ProtoMessage() {}

func (x *MysqlSslConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlSslConfig.ProtoReflect.Descriptor instead.
func (*MysqlSslConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{11}
}

func (x *MysqlSslConfig) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *MysqlSslConfig) GetClientKeySet() bool {
	if x != nil {
		return x.ClientKeySet
	}
	return false
}

func (x *MysqlSslConfig) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *MysqlSslConfig) GetClientCertificateSet() bool {
	if x != nil {
		return x.ClientCertificateSet
	}
	return false
}

func (x *MysqlSslConfig) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

func (x *MysqlSslConfig) GetCaCertificateSet() bool {
	if x != nil {
		return x.CaCertificateSet
	}
	return false
}

// A set of reusable connection configurations to be used as a source or
// destination for a stream.
type ConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time of the resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time of the resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Connection configuration for the ConnectionProfile.
	//
	// Types that are assignable to Profile:
	//	*ConnectionProfile_OracleProfile
	//	*ConnectionProfile_GcsProfile
	//	*ConnectionProfile_MysqlProfile
	//	*ConnectionProfile_BigqueryProfile
	//	*ConnectionProfile_PostgresqlProfile
	Profile isConnectionProfile_Profile `protobuf_oneof:"profile"`
	// Connectivity options used to establish a connection to the profile.
	//
	// Types that are assignable to Connectivity:
	//	*ConnectionProfile_StaticServiceIpConnectivity
	//	*ConnectionProfile_ForwardSshConnectivity
	//	*ConnectionProfile_PrivateConnectivity
	Connectivity isConnectionProfile_Connectivity `protobuf_oneof:"connectivity"`
}

func (x *ConnectionProfile) Reset() {
	*x = ConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionProfile) ProtoMessage() {}

func (x *ConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionProfile.ProtoReflect.Descriptor instead.
func (*ConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{12}
}

func (x *ConnectionProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConnectionProfile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConnectionProfile) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ConnectionProfile) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ConnectionProfile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *ConnectionProfile) GetProfile() isConnectionProfile_Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

func (x *ConnectionProfile) GetOracleProfile() *OracleProfile {
	if x, ok := x.GetProfile().(*ConnectionProfile_OracleProfile); ok {
		return x.OracleProfile
	}
	return nil
}

func (x *ConnectionProfile) GetGcsProfile() *GcsProfile {
	if x, ok := x.GetProfile().(*ConnectionProfile_GcsProfile); ok {
		return x.GcsProfile
	}
	return nil
}

func (x *ConnectionProfile) GetMysqlProfile() *MysqlProfile {
	if x, ok := x.GetProfile().(*ConnectionProfile_MysqlProfile); ok {
		return x.MysqlProfile
	}
	return nil
}

func (x *ConnectionProfile) GetBigqueryProfile() *BigQueryProfile {
	if x, ok := x.GetProfile().(*ConnectionProfile_BigqueryProfile); ok {
		return x.BigqueryProfile
	}
	return nil
}

func (x *ConnectionProfile) GetPostgresqlProfile() *PostgresqlProfile {
	if x, ok := x.GetProfile().(*ConnectionProfile_PostgresqlProfile); ok {
		return x.PostgresqlProfile
	}
	return nil
}

func (m *ConnectionProfile) GetConnectivity() isConnectionProfile_Connectivity {
	if m != nil {
		return m.Connectivity
	}
	return nil
}

func (x *ConnectionProfile) GetStaticServiceIpConnectivity() *StaticServiceIpConnectivity {
	if x, ok := x.GetConnectivity().(*ConnectionProfile_StaticServiceIpConnectivity); ok {
		return x.StaticServiceIpConnectivity
	}
	return nil
}

func (x *ConnectionProfile) GetForwardSshConnectivity() *ForwardSshTunnelConnectivity {
	if x, ok := x.GetConnectivity().(*ConnectionProfile_ForwardSshConnectivity); ok {
		return x.ForwardSshConnectivity
	}
	return nil
}

func (x *ConnectionProfile) GetPrivateConnectivity() *PrivateConnectivity {
	if x, ok := x.GetConnectivity().(*ConnectionProfile_PrivateConnectivity); ok {
		return x.PrivateConnectivity
	}
	return nil
}

type isConnectionProfile_Profile interface {
	isConnectionProfile_Profile()
}

type ConnectionProfile_OracleProfile struct {
	// Oracle ConnectionProfile configuration.
	OracleProfile *OracleProfile `protobuf:"bytes,100,opt,name=oracle_profile,json=oracleProfile,proto3,oneof"`
}

type ConnectionProfile_GcsProfile struct {
	// Cloud Storage ConnectionProfile configuration.
	GcsProfile *GcsProfile `protobuf:"bytes,101,opt,name=gcs_profile,json=gcsProfile,proto3,oneof"`
}

type ConnectionProfile_MysqlProfile struct {
	// MySQL ConnectionProfile configuration.
	MysqlProfile *MysqlProfile `protobuf:"bytes,102,opt,name=mysql_profile,json=mysqlProfile,proto3,oneof"`
}

type ConnectionProfile_BigqueryProfile struct {
	// BigQuery Connection Profile configuration.
	BigqueryProfile *BigQueryProfile `protobuf:"bytes,103,opt,name=bigquery_profile,json=bigqueryProfile,proto3,oneof"`
}

type ConnectionProfile_PostgresqlProfile struct {
	// PostgreSQL Connection Profile configuration.
	PostgresqlProfile *PostgresqlProfile `protobuf:"bytes,104,opt,name=postgresql_profile,json=postgresqlProfile,proto3,oneof"`
}

func (*ConnectionProfile_OracleProfile) isConnectionProfile_Profile() {}

func (*ConnectionProfile_GcsProfile) isConnectionProfile_Profile() {}

func (*ConnectionProfile_MysqlProfile) isConnectionProfile_Profile() {}

func (*ConnectionProfile_BigqueryProfile) isConnectionProfile_Profile() {}

func (*ConnectionProfile_PostgresqlProfile) isConnectionProfile_Profile() {}

type isConnectionProfile_Connectivity interface {
	isConnectionProfile_Connectivity()
}

type ConnectionProfile_StaticServiceIpConnectivity struct {
	// Static Service IP connectivity.
	StaticServiceIpConnectivity *StaticServiceIpConnectivity `protobuf:"bytes,200,opt,name=static_service_ip_connectivity,json=staticServiceIpConnectivity,proto3,oneof"`
}

type ConnectionProfile_ForwardSshConnectivity struct {
	// Forward SSH tunnel connectivity.
	ForwardSshConnectivity *ForwardSshTunnelConnectivity `protobuf:"bytes,201,opt,name=forward_ssh_connectivity,json=forwardSshConnectivity,proto3,oneof"`
}

type ConnectionProfile_PrivateConnectivity struct {
	// Private connectivity.
	PrivateConnectivity *PrivateConnectivity `protobuf:"bytes,202,opt,name=private_connectivity,json=privateConnectivity,proto3,oneof"`
}

func (*ConnectionProfile_StaticServiceIpConnectivity) isConnectionProfile_Connectivity() {}

func (*ConnectionProfile_ForwardSshConnectivity) isConnectionProfile_Connectivity() {}

func (*ConnectionProfile_PrivateConnectivity) isConnectionProfile_Connectivity() {}

// Oracle Column.
type OracleColumn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	Column string `protobuf:"bytes,1,opt,name=column,proto3" json:"column,omitempty"`
	// The Oracle data type.
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Column length.
	Length int32 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	// Column precision.
	Precision int32 `protobuf:"varint,4,opt,name=precision,proto3" json:"precision,omitempty"`
	// Column scale.
	Scale int32 `protobuf:"varint,5,opt,name=scale,proto3" json:"scale,omitempty"`
	// Column encoding.
	Encoding string `protobuf:"bytes,6,opt,name=encoding,proto3" json:"encoding,omitempty"`
	// Whether or not the column represents a primary key.
	PrimaryKey bool `protobuf:"varint,7,opt,name=primary_key,json=primaryKey,proto3" json:"primary_key,omitempty"`
	// Whether or not the column can accept a null value.
	Nullable bool `protobuf:"varint,8,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// The ordinal position of the column in the table.
	OrdinalPosition int32 `protobuf:"varint,9,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
}

func (x *OracleColumn) Reset() {
	*x = OracleColumn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleColumn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleColumn) ProtoMessage() {}

func (x *OracleColumn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleColumn.ProtoReflect.Descriptor instead.
func (*OracleColumn) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{13}
}

func (x *OracleColumn) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *OracleColumn) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *OracleColumn) GetLength() int32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *OracleColumn) GetPrecision() int32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *OracleColumn) GetScale() int32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

func (x *OracleColumn) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

func (x *OracleColumn) GetPrimaryKey() bool {
	if x != nil {
		return x.PrimaryKey
	}
	return false
}

func (x *OracleColumn) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *OracleColumn) GetOrdinalPosition() int32 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

// Oracle table.
type OracleTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table name.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Oracle columns in the schema.
	// When unspecified as part of include/exclude objects, includes/excludes
	// everything.
	OracleColumns []*OracleColumn `protobuf:"bytes,2,rep,name=oracle_columns,json=oracleColumns,proto3" json:"oracle_columns,omitempty"`
}

func (x *OracleTable) Reset() {
	*x = OracleTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleTable) ProtoMessage() {}

func (x *OracleTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleTable.ProtoReflect.Descriptor instead.
func (*OracleTable) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{14}
}

func (x *OracleTable) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *OracleTable) GetOracleColumns() []*OracleColumn {
	if x != nil {
		return x.OracleColumns
	}
	return nil
}

// Oracle schema.
type OracleSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema name.
	Schema string `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
	// Tables in the schema.
	OracleTables []*OracleTable `protobuf:"bytes,2,rep,name=oracle_tables,json=oracleTables,proto3" json:"oracle_tables,omitempty"`
}

func (x *OracleSchema) Reset() {
	*x = OracleSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleSchema) ProtoMessage() {}

func (x *OracleSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleSchema.ProtoReflect.Descriptor instead.
func (*OracleSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{15}
}

func (x *OracleSchema) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *OracleSchema) GetOracleTables() []*OracleTable {
	if x != nil {
		return x.OracleTables
	}
	return nil
}

// Oracle database structure.
type OracleRdbms struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Oracle schemas/databases in the database server.
	OracleSchemas []*OracleSchema `protobuf:"bytes,1,rep,name=oracle_schemas,json=oracleSchemas,proto3" json:"oracle_schemas,omitempty"`
}

func (x *OracleRdbms) Reset() {
	*x = OracleRdbms{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleRdbms) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleRdbms) ProtoMessage() {}

func (x *OracleRdbms) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleRdbms.ProtoReflect.Descriptor instead.
func (*OracleRdbms) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{16}
}

func (x *OracleRdbms) GetOracleSchemas() []*OracleSchema {
	if x != nil {
		return x.OracleSchemas
	}
	return nil
}

// Oracle data source configuration
type OracleSourceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Oracle objects to include in the stream.
	IncludeObjects *OracleRdbms `protobuf:"bytes,1,opt,name=include_objects,json=includeObjects,proto3" json:"include_objects,omitempty"`
	// Oracle objects to exclude from the stream.
	ExcludeObjects *OracleRdbms `protobuf:"bytes,2,opt,name=exclude_objects,json=excludeObjects,proto3" json:"exclude_objects,omitempty"`
	// Maximum number of concurrent CDC tasks. The number should be non-negative.
	// If not set (or set to 0), the system's default value is used.
	MaxConcurrentCdcTasks int32 `protobuf:"varint,3,opt,name=max_concurrent_cdc_tasks,json=maxConcurrentCdcTasks,proto3" json:"max_concurrent_cdc_tasks,omitempty"`
	// Maximum number of concurrent backfill tasks. The number should be
	// non-negative. If not set (or set to 0), the system's default value is used.
	MaxConcurrentBackfillTasks int32 `protobuf:"varint,4,opt,name=max_concurrent_backfill_tasks,json=maxConcurrentBackfillTasks,proto3" json:"max_concurrent_backfill_tasks,omitempty"`
	// The configuration for handle Oracle large objects.
	//
	// Types that are assignable to LargeObjectsHandling:
	//	*OracleSourceConfig_DropLargeObjects_
	//	*OracleSourceConfig_StreamLargeObjects_
	LargeObjectsHandling isOracleSourceConfig_LargeObjectsHandling `protobuf_oneof:"large_objects_handling"`
}

func (x *OracleSourceConfig) Reset() {
	*x = OracleSourceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleSourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleSourceConfig) ProtoMessage() {}

func (x *OracleSourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleSourceConfig.ProtoReflect.Descriptor instead.
func (*OracleSourceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{17}
}

func (x *OracleSourceConfig) GetIncludeObjects() *OracleRdbms {
	if x != nil {
		return x.IncludeObjects
	}
	return nil
}

func (x *OracleSourceConfig) GetExcludeObjects() *OracleRdbms {
	if x != nil {
		return x.ExcludeObjects
	}
	return nil
}

func (x *OracleSourceConfig) GetMaxConcurrentCdcTasks() int32 {
	if x != nil {
		return x.MaxConcurrentCdcTasks
	}
	return 0
}

func (x *OracleSourceConfig) GetMaxConcurrentBackfillTasks() int32 {
	if x != nil {
		return x.MaxConcurrentBackfillTasks
	}
	return 0
}

func (m *OracleSourceConfig) GetLargeObjectsHandling() isOracleSourceConfig_LargeObjectsHandling {
	if m != nil {
		return m.LargeObjectsHandling
	}
	return nil
}

func (x *OracleSourceConfig) GetDropLargeObjects() *OracleSourceConfig_DropLargeObjects {
	if x, ok := x.GetLargeObjectsHandling().(*OracleSourceConfig_DropLargeObjects_); ok {
		return x.DropLargeObjects
	}
	return nil
}

func (x *OracleSourceConfig) GetStreamLargeObjects() *OracleSourceConfig_StreamLargeObjects {
	if x, ok := x.GetLargeObjectsHandling().(*OracleSourceConfig_StreamLargeObjects_); ok {
		return x.StreamLargeObjects
	}
	return nil
}

type isOracleSourceConfig_LargeObjectsHandling interface {
	isOracleSourceConfig_LargeObjectsHandling()
}

type OracleSourceConfig_DropLargeObjects_ struct {
	// Drop large object values.
	DropLargeObjects *OracleSourceConfig_DropLargeObjects `protobuf:"bytes,100,opt,name=drop_large_objects,json=dropLargeObjects,proto3,oneof"`
}

type OracleSourceConfig_StreamLargeObjects_ struct {
	// Stream large object values. NOTE: This feature is currently experimental.
	StreamLargeObjects *OracleSourceConfig_StreamLargeObjects `protobuf:"bytes,102,opt,name=stream_large_objects,json=streamLargeObjects,proto3,oneof"`
}

func (*OracleSourceConfig_DropLargeObjects_) isOracleSourceConfig_LargeObjectsHandling() {}

func (*OracleSourceConfig_StreamLargeObjects_) isOracleSourceConfig_LargeObjectsHandling() {}

// PostgreSQL Column.
type PostgresqlColumn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	Column string `protobuf:"bytes,1,opt,name=column,proto3" json:"column,omitempty"`
	// The PostgreSQL data type.
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Column length.
	Length int32 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	// Column precision.
	Precision int32 `protobuf:"varint,4,opt,name=precision,proto3" json:"precision,omitempty"`
	// Column scale.
	Scale int32 `protobuf:"varint,5,opt,name=scale,proto3" json:"scale,omitempty"`
	// Whether or not the column represents a primary key.
	PrimaryKey bool `protobuf:"varint,7,opt,name=primary_key,json=primaryKey,proto3" json:"primary_key,omitempty"`
	// Whether or not the column can accept a null value.
	Nullable bool `protobuf:"varint,8,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// The ordinal position of the column in the table.
	OrdinalPosition int32 `protobuf:"varint,9,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
}

func (x *PostgresqlColumn) Reset() {
	*x = PostgresqlColumn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgresqlColumn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgresqlColumn) ProtoMessage() {}

func (x *PostgresqlColumn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgresqlColumn.ProtoReflect.Descriptor instead.
func (*PostgresqlColumn) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{18}
}

func (x *PostgresqlColumn) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *PostgresqlColumn) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *PostgresqlColumn) GetLength() int32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *PostgresqlColumn) GetPrecision() int32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *PostgresqlColumn) GetScale() int32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

func (x *PostgresqlColumn) GetPrimaryKey() bool {
	if x != nil {
		return x.PrimaryKey
	}
	return false
}

func (x *PostgresqlColumn) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *PostgresqlColumn) GetOrdinalPosition() int32 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

// PostgreSQL table.
type PostgresqlTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table name.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// PostgreSQL columns in the schema.
	// When unspecified as part of include/exclude objects,
	// includes/excludes everything.
	PostgresqlColumns []*PostgresqlColumn `protobuf:"bytes,2,rep,name=postgresql_columns,json=postgresqlColumns,proto3" json:"postgresql_columns,omitempty"`
}

func (x *PostgresqlTable) Reset() {
	*x = PostgresqlTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgresqlTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgresqlTable) ProtoMessage() {}

func (x *PostgresqlTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgresqlTable.ProtoReflect.Descriptor instead.
func (*PostgresqlTable) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{19}
}

func (x *PostgresqlTable) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *PostgresqlTable) GetPostgresqlColumns() []*PostgresqlColumn {
	if x != nil {
		return x.PostgresqlColumns
	}
	return nil
}

// PostgreSQL schema.
type PostgresqlSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema name.
	Schema string `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
	// Tables in the schema.
	PostgresqlTables []*PostgresqlTable `protobuf:"bytes,2,rep,name=postgresql_tables,json=postgresqlTables,proto3" json:"postgresql_tables,omitempty"`
}

func (x *PostgresqlSchema) Reset() {
	*x = PostgresqlSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgresqlSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgresqlSchema) ProtoMessage() {}

func (x *PostgresqlSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgresqlSchema.ProtoReflect.Descriptor instead.
func (*PostgresqlSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{20}
}

func (x *PostgresqlSchema) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *PostgresqlSchema) GetPostgresqlTables() []*PostgresqlTable {
	if x != nil {
		return x.PostgresqlTables
	}
	return nil
}

// PostgreSQL database structure.
type PostgresqlRdbms struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PostgreSQL schemas in the database server.
	PostgresqlSchemas []*PostgresqlSchema `protobuf:"bytes,1,rep,name=postgresql_schemas,json=postgresqlSchemas,proto3" json:"postgresql_schemas,omitempty"`
}

func (x *PostgresqlRdbms) Reset() {
	*x = PostgresqlRdbms{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgresqlRdbms) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgresqlRdbms) ProtoMessage() {}

func (x *PostgresqlRdbms) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgresqlRdbms.ProtoReflect.Descriptor instead.
func (*PostgresqlRdbms) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{21}
}

func (x *PostgresqlRdbms) GetPostgresqlSchemas() []*PostgresqlSchema {
	if x != nil {
		return x.PostgresqlSchemas
	}
	return nil
}

// PostgreSQL data source configuration
type PostgresqlSourceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PostgreSQL objects to include in the stream.
	IncludeObjects *PostgresqlRdbms `protobuf:"bytes,1,opt,name=include_objects,json=includeObjects,proto3" json:"include_objects,omitempty"`
	// PostgreSQL objects to exclude from the stream.
	ExcludeObjects *PostgresqlRdbms `protobuf:"bytes,2,opt,name=exclude_objects,json=excludeObjects,proto3" json:"exclude_objects,omitempty"`
	// Required. Immutable. The name of the logical replication slot that's
	// configured with the pgoutput plugin.
	ReplicationSlot string `protobuf:"bytes,3,opt,name=replication_slot,json=replicationSlot,proto3" json:"replication_slot,omitempty"`
	// Required. The name of the publication that includes the set of all tables
	// that are defined in the stream's include_objects.
	Publication string `protobuf:"bytes,4,opt,name=publication,proto3" json:"publication,omitempty"`
	// Maximum number of concurrent backfill tasks. The number should be non
	// negative. If not set (or set to 0), the system's default value will be
	// used.
	MaxConcurrentBackfillTasks int32 `protobuf:"varint,5,opt,name=max_concurrent_backfill_tasks,json=maxConcurrentBackfillTasks,proto3" json:"max_concurrent_backfill_tasks,omitempty"`
}

func (x *PostgresqlSourceConfig) Reset() {
	*x = PostgresqlSourceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgresqlSourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgresqlSourceConfig) ProtoMessage() {}

func (x *PostgresqlSourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgresqlSourceConfig.ProtoReflect.Descriptor instead.
func (*PostgresqlSourceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{22}
}

func (x *PostgresqlSourceConfig) GetIncludeObjects() *PostgresqlRdbms {
	if x != nil {
		return x.IncludeObjects
	}
	return nil
}

func (x *PostgresqlSourceConfig) GetExcludeObjects() *PostgresqlRdbms {
	if x != nil {
		return x.ExcludeObjects
	}
	return nil
}

func (x *PostgresqlSourceConfig) GetReplicationSlot() string {
	if x != nil {
		return x.ReplicationSlot
	}
	return ""
}

func (x *PostgresqlSourceConfig) GetPublication() string {
	if x != nil {
		return x.Publication
	}
	return ""
}

func (x *PostgresqlSourceConfig) GetMaxConcurrentBackfillTasks() int32 {
	if x != nil {
		return x.MaxConcurrentBackfillTasks
	}
	return 0
}

// MySQL Column.
type MysqlColumn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	Column string `protobuf:"bytes,1,opt,name=column,proto3" json:"column,omitempty"`
	// The MySQL data type. Full data types list can be found here:
	// https://dev.mysql.com/doc/refman/8.0/en/data-types.html
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Column length.
	Length int32 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	// Column collation.
	Collation string `protobuf:"bytes,4,opt,name=collation,proto3" json:"collation,omitempty"`
	// Whether or not the column represents a primary key.
	PrimaryKey bool `protobuf:"varint,5,opt,name=primary_key,json=primaryKey,proto3" json:"primary_key,omitempty"`
	// Whether or not the column can accept a null value.
	Nullable bool `protobuf:"varint,6,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// The ordinal position of the column in the table.
	OrdinalPosition int32 `protobuf:"varint,7,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
}

func (x *MysqlColumn) Reset() {
	*x = MysqlColumn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlColumn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlColumn) ProtoMessage() {}

func (x *MysqlColumn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlColumn.ProtoReflect.Descriptor instead.
func (*MysqlColumn) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{23}
}

func (x *MysqlColumn) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *MysqlColumn) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *MysqlColumn) GetLength() int32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *MysqlColumn) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *MysqlColumn) GetPrimaryKey() bool {
	if x != nil {
		return x.PrimaryKey
	}
	return false
}

func (x *MysqlColumn) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *MysqlColumn) GetOrdinalPosition() int32 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

// MySQL table.
type MysqlTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table name.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// MySQL columns in the database.
	// When unspecified as part of include/exclude objects, includes/excludes
	// everything.
	MysqlColumns []*MysqlColumn `protobuf:"bytes,2,rep,name=mysql_columns,json=mysqlColumns,proto3" json:"mysql_columns,omitempty"`
}

func (x *MysqlTable) Reset() {
	*x = MysqlTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlTable) ProtoMessage() {}

func (x *MysqlTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlTable.ProtoReflect.Descriptor instead.
func (*MysqlTable) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{24}
}

func (x *MysqlTable) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *MysqlTable) GetMysqlColumns() []*MysqlColumn {
	if x != nil {
		return x.MysqlColumns
	}
	return nil
}

// MySQL database.
type MysqlDatabase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database name.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Tables in the database.
	MysqlTables []*MysqlTable `protobuf:"bytes,2,rep,name=mysql_tables,json=mysqlTables,proto3" json:"mysql_tables,omitempty"`
}

func (x *MysqlDatabase) Reset() {
	*x = MysqlDatabase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlDatabase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlDatabase) ProtoMessage() {}

func (x *MysqlDatabase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlDatabase.ProtoReflect.Descriptor instead.
func (*MysqlDatabase) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{25}
}

func (x *MysqlDatabase) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *MysqlDatabase) GetMysqlTables() []*MysqlTable {
	if x != nil {
		return x.MysqlTables
	}
	return nil
}

// MySQL database structure
type MysqlRdbms struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mysql databases on the server
	MysqlDatabases []*MysqlDatabase `protobuf:"bytes,1,rep,name=mysql_databases,json=mysqlDatabases,proto3" json:"mysql_databases,omitempty"`
}

func (x *MysqlRdbms) Reset() {
	*x = MysqlRdbms{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlRdbms) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlRdbms) ProtoMessage() {}

func (x *MysqlRdbms) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlRdbms.ProtoReflect.Descriptor instead.
func (*MysqlRdbms) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{26}
}

func (x *MysqlRdbms) GetMysqlDatabases() []*MysqlDatabase {
	if x != nil {
		return x.MysqlDatabases
	}
	return nil
}

// MySQL source configuration
type MysqlSourceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// MySQL objects to retrieve from the source.
	IncludeObjects *MysqlRdbms `protobuf:"bytes,1,opt,name=include_objects,json=includeObjects,proto3" json:"include_objects,omitempty"`
	// MySQL objects to exclude from the stream.
	ExcludeObjects *MysqlRdbms `protobuf:"bytes,2,opt,name=exclude_objects,json=excludeObjects,proto3" json:"exclude_objects,omitempty"`
	// Maximum number of concurrent CDC tasks. The number should be non negative.
	// If not set (or set to 0), the system's default value will be used.
	MaxConcurrentCdcTasks int32 `protobuf:"varint,3,opt,name=max_concurrent_cdc_tasks,json=maxConcurrentCdcTasks,proto3" json:"max_concurrent_cdc_tasks,omitempty"`
	// Maximum number of concurrent backfill tasks. The number should be non
	// negative. If not set (or set to 0), the system's default value will be
	// used.
	MaxConcurrentBackfillTasks int32 `protobuf:"varint,4,opt,name=max_concurrent_backfill_tasks,json=maxConcurrentBackfillTasks,proto3" json:"max_concurrent_backfill_tasks,omitempty"`
}

func (x *MysqlSourceConfig) Reset() {
	*x = MysqlSourceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlSourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlSourceConfig) ProtoMessage() {}

func (x *MysqlSourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlSourceConfig.ProtoReflect.Descriptor instead.
func (*MysqlSourceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{27}
}

func (x *MysqlSourceConfig) GetIncludeObjects() *MysqlRdbms {
	if x != nil {
		return x.IncludeObjects
	}
	return nil
}

func (x *MysqlSourceConfig) GetExcludeObjects() *MysqlRdbms {
	if x != nil {
		return x.ExcludeObjects
	}
	return nil
}

func (x *MysqlSourceConfig) GetMaxConcurrentCdcTasks() int32 {
	if x != nil {
		return x.MaxConcurrentCdcTasks
	}
	return 0
}

func (x *MysqlSourceConfig) GetMaxConcurrentBackfillTasks() int32 {
	if x != nil {
		return x.MaxConcurrentBackfillTasks
	}
	return 0
}

// The configuration of the stream source.
type SourceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Source connection profile resoource.
	// Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
	SourceConnectionProfile string `protobuf:"bytes,1,opt,name=source_connection_profile,json=sourceConnectionProfile,proto3" json:"source_connection_profile,omitempty"`
	// Stream configuration that is specific to the data source type.
	//
	// Types that are assignable to SourceStreamConfig:
	//	*SourceConfig_OracleSourceConfig
	//	*SourceConfig_MysqlSourceConfig
	//	*SourceConfig_PostgresqlSourceConfig
	SourceStreamConfig isSourceConfig_SourceStreamConfig `protobuf_oneof:"source_stream_config"`
}

func (x *SourceConfig) Reset() {
	*x = SourceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceConfig) ProtoMessage() {}

func (x *SourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceConfig.ProtoReflect.Descriptor instead.
func (*SourceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{28}
}

func (x *SourceConfig) GetSourceConnectionProfile() string {
	if x != nil {
		return x.SourceConnectionProfile
	}
	return ""
}

func (m *SourceConfig) GetSourceStreamConfig() isSourceConfig_SourceStreamConfig {
	if m != nil {
		return m.SourceStreamConfig
	}
	return nil
}

func (x *SourceConfig) GetOracleSourceConfig() *OracleSourceConfig {
	if x, ok := x.GetSourceStreamConfig().(*SourceConfig_OracleSourceConfig); ok {
		return x.OracleSourceConfig
	}
	return nil
}

func (x *SourceConfig) GetMysqlSourceConfig() *MysqlSourceConfig {
	if x, ok := x.GetSourceStreamConfig().(*SourceConfig_MysqlSourceConfig); ok {
		return x.MysqlSourceConfig
	}
	return nil
}

func (x *SourceConfig) GetPostgresqlSourceConfig() *PostgresqlSourceConfig {
	if x, ok := x.GetSourceStreamConfig().(*SourceConfig_PostgresqlSourceConfig); ok {
		return x.PostgresqlSourceConfig
	}
	return nil
}

type isSourceConfig_SourceStreamConfig interface {
	isSourceConfig_SourceStreamConfig()
}

type SourceConfig_OracleSourceConfig struct {
	// Oracle data source configuration.
	OracleSourceConfig *OracleSourceConfig `protobuf:"bytes,100,opt,name=oracle_source_config,json=oracleSourceConfig,proto3,oneof"`
}

type SourceConfig_MysqlSourceConfig struct {
	// MySQL data source configuration.
	MysqlSourceConfig *MysqlSourceConfig `protobuf:"bytes,101,opt,name=mysql_source_config,json=mysqlSourceConfig,proto3,oneof"`
}

type SourceConfig_PostgresqlSourceConfig struct {
	// PostgreSQL data source configuration.
	PostgresqlSourceConfig *PostgresqlSourceConfig `protobuf:"bytes,102,opt,name=postgresql_source_config,json=postgresqlSourceConfig,proto3,oneof"`
}

func (*SourceConfig_OracleSourceConfig) isSourceConfig_SourceStreamConfig() {}

func (*SourceConfig_MysqlSourceConfig) isSourceConfig_SourceStreamConfig() {}

func (*SourceConfig_PostgresqlSourceConfig) isSourceConfig_SourceStreamConfig() {}

// AVRO file format configuration.
type AvroFileFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AvroFileFormat) Reset() {
	*x = AvroFileFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvroFileFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvroFileFormat) ProtoMessage() {}

func (x *AvroFileFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvroFileFormat.ProtoReflect.Descriptor instead.
func (*AvroFileFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{29}
}

// JSON file format configuration.
type JsonFileFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The schema file format along JSON data files.
	SchemaFileFormat JsonFileFormat_SchemaFileFormat `protobuf:"varint,1,opt,name=schema_file_format,json=schemaFileFormat,proto3,enum=google.cloud.datastream.v1.JsonFileFormat_SchemaFileFormat" json:"schema_file_format,omitempty"`
	// Compression of the loaded JSON file.
	Compression JsonFileFormat_JsonCompression `protobuf:"varint,2,opt,name=compression,proto3,enum=google.cloud.datastream.v1.JsonFileFormat_JsonCompression" json:"compression,omitempty"`
}

func (x *JsonFileFormat) Reset() {
	*x = JsonFileFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JsonFileFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JsonFileFormat) ProtoMessage() {}

func (x *JsonFileFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JsonFileFormat.ProtoReflect.Descriptor instead.
func (*JsonFileFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{30}
}

func (x *JsonFileFormat) GetSchemaFileFormat() JsonFileFormat_SchemaFileFormat {
	if x != nil {
		return x.SchemaFileFormat
	}
	return JsonFileFormat_SCHEMA_FILE_FORMAT_UNSPECIFIED
}

func (x *JsonFileFormat) GetCompression() JsonFileFormat_JsonCompression {
	if x != nil {
		return x.Compression
	}
	return JsonFileFormat_JSON_COMPRESSION_UNSPECIFIED
}

// Google Cloud Storage destination configuration
type GcsDestinationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path inside the Cloud Storage bucket to write data to.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The maximum file size to be saved in the bucket.
	FileRotationMb int32 `protobuf:"varint,2,opt,name=file_rotation_mb,json=fileRotationMb,proto3" json:"file_rotation_mb,omitempty"`
	// The maximum duration for which new events are added before a file is
	// closed and a new file is created. Values within the range of 15-60 seconds
	// are allowed.
	FileRotationInterval *durationpb.Duration `protobuf:"bytes,3,opt,name=file_rotation_interval,json=fileRotationInterval,proto3" json:"file_rotation_interval,omitempty"`
	// File Format that the data should be written in.
	//
	// Types that are assignable to FileFormat:
	//	*GcsDestinationConfig_AvroFileFormat
	//	*GcsDestinationConfig_JsonFileFormat
	FileFormat isGcsDestinationConfig_FileFormat `protobuf_oneof:"file_format"`
}

func (x *GcsDestinationConfig) Reset() {
	*x = GcsDestinationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestinationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestinationConfig) ProtoMessage() {}

func (x *GcsDestinationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestinationConfig.ProtoReflect.Descriptor instead.
func (*GcsDestinationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{31}
}

func (x *GcsDestinationConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *GcsDestinationConfig) GetFileRotationMb() int32 {
	if x != nil {
		return x.FileRotationMb
	}
	return 0
}

func (x *GcsDestinationConfig) GetFileRotationInterval() *durationpb.Duration {
	if x != nil {
		return x.FileRotationInterval
	}
	return nil
}

func (m *GcsDestinationConfig) GetFileFormat() isGcsDestinationConfig_FileFormat {
	if m != nil {
		return m.FileFormat
	}
	return nil
}

func (x *GcsDestinationConfig) GetAvroFileFormat() *AvroFileFormat {
	if x, ok := x.GetFileFormat().(*GcsDestinationConfig_AvroFileFormat); ok {
		return x.AvroFileFormat
	}
	return nil
}

func (x *GcsDestinationConfig) GetJsonFileFormat() *JsonFileFormat {
	if x, ok := x.GetFileFormat().(*GcsDestinationConfig_JsonFileFormat); ok {
		return x.JsonFileFormat
	}
	return nil
}

type isGcsDestinationConfig_FileFormat interface {
	isGcsDestinationConfig_FileFormat()
}

type GcsDestinationConfig_AvroFileFormat struct {
	// AVRO file format configuration.
	AvroFileFormat *AvroFileFormat `protobuf:"bytes,100,opt,name=avro_file_format,json=avroFileFormat,proto3,oneof"`
}

type GcsDestinationConfig_JsonFileFormat struct {
	// JSON file format configuration.
	JsonFileFormat *JsonFileFormat `protobuf:"bytes,101,opt,name=json_file_format,json=jsonFileFormat,proto3,oneof"`
}

func (*GcsDestinationConfig_AvroFileFormat) isGcsDestinationConfig_FileFormat() {}

func (*GcsDestinationConfig_JsonFileFormat) isGcsDestinationConfig_FileFormat() {}

// BigQuery destination configuration
type BigQueryDestinationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target dataset(s) configuration.
	//
	// Types that are assignable to DatasetConfig:
	//	*BigQueryDestinationConfig_SingleTargetDataset_
	//	*BigQueryDestinationConfig_SourceHierarchyDatasets_
	DatasetConfig isBigQueryDestinationConfig_DatasetConfig `protobuf_oneof:"dataset_config"`
	// The guaranteed data freshness (in seconds) when querying tables created by
	// the stream. Editing this field will only affect new tables created in the
	// future, but existing tables will not be impacted. Lower values mean that
	// queries will return fresher data, but may result in higher cost.
	DataFreshness *durationpb.Duration `protobuf:"bytes,300,opt,name=data_freshness,json=dataFreshness,proto3" json:"data_freshness,omitempty"`
}

func (x *BigQueryDestinationConfig) Reset() {
	*x = BigQueryDestinationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDestinationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestinationConfig) ProtoMessage() {}

func (x *BigQueryDestinationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestinationConfig.ProtoReflect.Descriptor instead.
func (*BigQueryDestinationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{32}
}

func (m *BigQueryDestinationConfig) GetDatasetConfig() isBigQueryDestinationConfig_DatasetConfig {
	if m != nil {
		return m.DatasetConfig
	}
	return nil
}

func (x *BigQueryDestinationConfig) GetSingleTargetDataset() *BigQueryDestinationConfig_SingleTargetDataset {
	if x, ok := x.GetDatasetConfig().(*BigQueryDestinationConfig_SingleTargetDataset_); ok {
		return x.SingleTargetDataset
	}
	return nil
}

func (x *BigQueryDestinationConfig) GetSourceHierarchyDatasets() *BigQueryDestinationConfig_SourceHierarchyDatasets {
	if x, ok := x.GetDatasetConfig().(*BigQueryDestinationConfig_SourceHierarchyDatasets_); ok {
		return x.SourceHierarchyDatasets
	}
	return nil
}

func (x *BigQueryDestinationConfig) GetDataFreshness() *durationpb.Duration {
	if x != nil {
		return x.DataFreshness
	}
	return nil
}

type isBigQueryDestinationConfig_DatasetConfig interface {
	isBigQueryDestinationConfig_DatasetConfig()
}

type BigQueryDestinationConfig_SingleTargetDataset_ struct {
	// Single destination dataset.
	SingleTargetDataset *BigQueryDestinationConfig_SingleTargetDataset `protobuf:"bytes,201,opt,name=single_target_dataset,json=singleTargetDataset,proto3,oneof"`
}

type BigQueryDestinationConfig_SourceHierarchyDatasets_ struct {
	// Source hierarchy datasets.
	SourceHierarchyDatasets *BigQueryDestinationConfig_SourceHierarchyDatasets `protobuf:"bytes,202,opt,name=source_hierarchy_datasets,json=sourceHierarchyDatasets,proto3,oneof"`
}

func (*BigQueryDestinationConfig_SingleTargetDataset_) isBigQueryDestinationConfig_DatasetConfig() {}

func (*BigQueryDestinationConfig_SourceHierarchyDatasets_) isBigQueryDestinationConfig_DatasetConfig() {
}

// The configuration of the stream destination.
type DestinationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Destination connection profile resource.
	// Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
	DestinationConnectionProfile string `protobuf:"bytes,1,opt,name=destination_connection_profile,json=destinationConnectionProfile,proto3" json:"destination_connection_profile,omitempty"`
	// Stream configuration that is specific to the data destination type.
	//
	// Types that are assignable to DestinationStreamConfig:
	//	*DestinationConfig_GcsDestinationConfig
	//	*DestinationConfig_BigqueryDestinationConfig
	DestinationStreamConfig isDestinationConfig_DestinationStreamConfig `protobuf_oneof:"destination_stream_config"`
}

func (x *DestinationConfig) Reset() {
	*x = DestinationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationConfig) ProtoMessage() {}

func (x *DestinationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationConfig.ProtoReflect.Descriptor instead.
func (*DestinationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{33}
}

func (x *DestinationConfig) GetDestinationConnectionProfile() string {
	if x != nil {
		return x.DestinationConnectionProfile
	}
	return ""
}

func (m *DestinationConfig) GetDestinationStreamConfig() isDestinationConfig_DestinationStreamConfig {
	if m != nil {
		return m.DestinationStreamConfig
	}
	return nil
}

func (x *DestinationConfig) GetGcsDestinationConfig() *GcsDestinationConfig {
	if x, ok := x.GetDestinationStreamConfig().(*DestinationConfig_GcsDestinationConfig); ok {
		return x.GcsDestinationConfig
	}
	return nil
}

func (x *DestinationConfig) GetBigqueryDestinationConfig() *BigQueryDestinationConfig {
	if x, ok := x.GetDestinationStreamConfig().(*DestinationConfig_BigqueryDestinationConfig); ok {
		return x.BigqueryDestinationConfig
	}
	return nil
}

type isDestinationConfig_DestinationStreamConfig interface {
	isDestinationConfig_DestinationStreamConfig()
}

type DestinationConfig_GcsDestinationConfig struct {
	// A configuration for how data should be loaded to Cloud Storage.
	GcsDestinationConfig *GcsDestinationConfig `protobuf:"bytes,100,opt,name=gcs_destination_config,json=gcsDestinationConfig,proto3,oneof"`
}

type DestinationConfig_BigqueryDestinationConfig struct {
	// BigQuery destination configuration.
	BigqueryDestinationConfig *BigQueryDestinationConfig `protobuf:"bytes,101,opt,name=bigquery_destination_config,json=bigqueryDestinationConfig,proto3,oneof"`
}

func (*DestinationConfig_GcsDestinationConfig) isDestinationConfig_DestinationStreamConfig() {}

func (*DestinationConfig_BigqueryDestinationConfig) isDestinationConfig_DestinationStreamConfig() {}

// A resource representing streaming data from a source to a destination.
type Stream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The stream's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time of the stream.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update time of the stream.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Source connection profile configuration.
	SourceConfig *SourceConfig `protobuf:"bytes,6,opt,name=source_config,json=sourceConfig,proto3" json:"source_config,omitempty"`
	// Required. Destination connection profile configuration.
	DestinationConfig *DestinationConfig `protobuf:"bytes,7,opt,name=destination_config,json=destinationConfig,proto3" json:"destination_config,omitempty"`
	// The state of the stream.
	State Stream_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.datastream.v1.Stream_State" json:"state,omitempty"`
	// Stream backfill strategy.
	//
	// Types that are assignable to BackfillStrategy:
	//	*Stream_BackfillAll
	//	*Stream_BackfillNone
	BackfillStrategy isStream_BackfillStrategy `protobuf_oneof:"backfill_strategy"`
	// Output only. Errors on the Stream.
	Errors []*Error `protobuf:"bytes,9,rep,name=errors,proto3" json:"errors,omitempty"`
	// Immutable. A reference to a KMS encryption key.
	// If provided, it will be used to encrypt the data.
	// If left blank, data will be encrypted using an internal Stream-specific
	// encryption key provisioned through KMS.
	CustomerManagedEncryptionKey *string `protobuf:"bytes,10,opt,name=customer_managed_encryption_key,json=customerManagedEncryptionKey,proto3,oneof" json:"customer_managed_encryption_key,omitempty"`
}

func (x *Stream) Reset() {
	*x = Stream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream) ProtoMessage() {}

func (x *Stream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream.ProtoReflect.Descriptor instead.
func (*Stream) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{34}
}

func (x *Stream) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Stream) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Stream) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Stream) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Stream) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Stream) GetSourceConfig() *SourceConfig {
	if x != nil {
		return x.SourceConfig
	}
	return nil
}

func (x *Stream) GetDestinationConfig() *DestinationConfig {
	if x != nil {
		return x.DestinationConfig
	}
	return nil
}

func (x *Stream) GetState() Stream_State {
	if x != nil {
		return x.State
	}
	return Stream_STATE_UNSPECIFIED
}

func (m *Stream) GetBackfillStrategy() isStream_BackfillStrategy {
	if m != nil {
		return m.BackfillStrategy
	}
	return nil
}

func (x *Stream) GetBackfillAll() *Stream_BackfillAllStrategy {
	if x, ok := x.GetBackfillStrategy().(*Stream_BackfillAll); ok {
		return x.BackfillAll
	}
	return nil
}

func (x *Stream) GetBackfillNone() *Stream_BackfillNoneStrategy {
	if x, ok := x.GetBackfillStrategy().(*Stream_BackfillNone); ok {
		return x.BackfillNone
	}
	return nil
}

func (x *Stream) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *Stream) GetCustomerManagedEncryptionKey() string {
	if x != nil && x.CustomerManagedEncryptionKey != nil {
		return *x.CustomerManagedEncryptionKey
	}
	return ""
}

type isStream_BackfillStrategy interface {
	isStream_BackfillStrategy()
}

type Stream_BackfillAll struct {
	// Automatically backfill objects included in the stream source
	// configuration. Specific objects can be excluded.
	BackfillAll *Stream_BackfillAllStrategy `protobuf:"bytes,101,opt,name=backfill_all,json=backfillAll,proto3,oneof"`
}

type Stream_BackfillNone struct {
	// Do not automatically backfill any objects.
	BackfillNone *Stream_BackfillNoneStrategy `protobuf:"bytes,102,opt,name=backfill_none,json=backfillNone,proto3,oneof"`
}

func (*Stream_BackfillAll) isStream_BackfillStrategy() {}

func (*Stream_BackfillNone) isStream_BackfillStrategy() {}

// A specific stream object (e.g a specific DB table).
type StreamObject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The object resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time of the object.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update time of the object.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Active errors on the object.
	Errors []*Error `protobuf:"bytes,6,rep,name=errors,proto3" json:"errors,omitempty"`
	// The latest backfill job that was initiated for the stream object.
	BackfillJob *BackfillJob `protobuf:"bytes,7,opt,name=backfill_job,json=backfillJob,proto3" json:"backfill_job,omitempty"`
	// The object identifier in the data source.
	SourceObject *SourceObjectIdentifier `protobuf:"bytes,8,opt,name=source_object,json=sourceObject,proto3" json:"source_object,omitempty"`
}

func (x *StreamObject) Reset() {
	*x = StreamObject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamObject) ProtoMessage() {}

func (x *StreamObject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamObject.ProtoReflect.Descriptor instead.
func (*StreamObject) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{35}
}

func (x *StreamObject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StreamObject) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *StreamObject) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *StreamObject) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *StreamObject) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *StreamObject) GetBackfillJob() *BackfillJob {
	if x != nil {
		return x.BackfillJob
	}
	return nil
}

func (x *StreamObject) GetSourceObject() *SourceObjectIdentifier {
	if x != nil {
		return x.SourceObject
	}
	return nil
}

// Represents an identifier of an object in the data source.
type SourceObjectIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier for an object in the data source.
	//
	// Types that are assignable to SourceIdentifier:
	//	*SourceObjectIdentifier_OracleIdentifier
	//	*SourceObjectIdentifier_MysqlIdentifier
	//	*SourceObjectIdentifier_PostgresqlIdentifier
	SourceIdentifier isSourceObjectIdentifier_SourceIdentifier `protobuf_oneof:"source_identifier"`
}

func (x *SourceObjectIdentifier) Reset() {
	*x = SourceObjectIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceObjectIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceObjectIdentifier) ProtoMessage() {}

func (x *SourceObjectIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceObjectIdentifier.ProtoReflect.Descriptor instead.
func (*SourceObjectIdentifier) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{36}
}

func (m *SourceObjectIdentifier) GetSourceIdentifier() isSourceObjectIdentifier_SourceIdentifier {
	if m != nil {
		return m.SourceIdentifier
	}
	return nil
}

func (x *SourceObjectIdentifier) GetOracleIdentifier() *SourceObjectIdentifier_OracleObjectIdentifier {
	if x, ok := x.GetSourceIdentifier().(*SourceObjectIdentifier_OracleIdentifier); ok {
		return x.OracleIdentifier
	}
	return nil
}

func (x *SourceObjectIdentifier) GetMysqlIdentifier() *SourceObjectIdentifier_MysqlObjectIdentifier {
	if x, ok := x.GetSourceIdentifier().(*SourceObjectIdentifier_MysqlIdentifier); ok {
		return x.MysqlIdentifier
	}
	return nil
}

func (x *SourceObjectIdentifier) GetPostgresqlIdentifier() *SourceObjectIdentifier_PostgresqlObjectIdentifier {
	if x, ok := x.GetSourceIdentifier().(*SourceObjectIdentifier_PostgresqlIdentifier); ok {
		return x.PostgresqlIdentifier
	}
	return nil
}

type isSourceObjectIdentifier_SourceIdentifier interface {
	isSourceObjectIdentifier_SourceIdentifier()
}

type SourceObjectIdentifier_OracleIdentifier struct {
	// Oracle data source object identifier.
	OracleIdentifier *SourceObjectIdentifier_OracleObjectIdentifier `protobuf:"bytes,1,opt,name=oracle_identifier,json=oracleIdentifier,proto3,oneof"`
}

type SourceObjectIdentifier_MysqlIdentifier struct {
	// Mysql data source object identifier.
	MysqlIdentifier *SourceObjectIdentifier_MysqlObjectIdentifier `protobuf:"bytes,2,opt,name=mysql_identifier,json=mysqlIdentifier,proto3,oneof"`
}

type SourceObjectIdentifier_PostgresqlIdentifier struct {
	// PostgreSQL data source object identifier.
	PostgresqlIdentifier *SourceObjectIdentifier_PostgresqlObjectIdentifier `protobuf:"bytes,3,opt,name=postgresql_identifier,json=postgresqlIdentifier,proto3,oneof"`
}

func (*SourceObjectIdentifier_OracleIdentifier) isSourceObjectIdentifier_SourceIdentifier() {}

func (*SourceObjectIdentifier_MysqlIdentifier) isSourceObjectIdentifier_SourceIdentifier() {}

func (*SourceObjectIdentifier_PostgresqlIdentifier) isSourceObjectIdentifier_SourceIdentifier() {}

// Represents a backfill job on a specific stream object.
type BackfillJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Backfill job state.
	State BackfillJob_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.datastream.v1.BackfillJob_State" json:"state,omitempty"`
	// Backfill job's triggering reason.
	Trigger BackfillJob_Trigger `protobuf:"varint,2,opt,name=trigger,proto3,enum=google.cloud.datastream.v1.BackfillJob_Trigger" json:"trigger,omitempty"`
	// Output only. Backfill job's start time.
	LastStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_start_time,json=lastStartTime,proto3" json:"last_start_time,omitempty"`
	// Output only. Backfill job's end time.
	LastEndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_end_time,json=lastEndTime,proto3" json:"last_end_time,omitempty"`
	// Output only. Errors which caused the backfill job to fail.
	Errors []*Error `protobuf:"bytes,5,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *BackfillJob) Reset() {
	*x = BackfillJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackfillJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackfillJob) ProtoMessage() {}

func (x *BackfillJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackfillJob.ProtoReflect.Descriptor instead.
func (*BackfillJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{37}
}

func (x *BackfillJob) GetState() BackfillJob_State {
	if x != nil {
		return x.State
	}
	return BackfillJob_STATE_UNSPECIFIED
}

func (x *BackfillJob) GetTrigger() BackfillJob_Trigger {
	if x != nil {
		return x.Trigger
	}
	return BackfillJob_TRIGGER_UNSPECIFIED
}

func (x *BackfillJob) GetLastStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastStartTime
	}
	return nil
}

func (x *BackfillJob) GetLastEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastEndTime
	}
	return nil
}

func (x *BackfillJob) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Represent a user-facing Error.
type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A title that explains the reason for the error.
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
	// A unique identifier for this specific error,
	// allowing it to be traced throughout the system in logs and API responses.
	ErrorUuid string `protobuf:"bytes,2,opt,name=error_uuid,json=errorUuid,proto3" json:"error_uuid,omitempty"`
	// A message containing more information about the error that occurred.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// The time when the error occurred.
	ErrorTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=error_time,json=errorTime,proto3" json:"error_time,omitempty"`
	// Additional information about the error.
	Details map[string]string `protobuf:"bytes,5,rep,name=details,proto3" json:"details,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{38}
}

func (x *Error) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *Error) GetErrorUuid() string {
	if x != nil {
		return x.ErrorUuid
	}
	return ""
}

func (x *Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Error) GetErrorTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ErrorTime
	}
	return nil
}

func (x *Error) GetDetails() map[string]string {
	if x != nil {
		return x.Details
	}
	return nil
}

// Contains the current validation results.
type ValidationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of validations (includes both executed as well as not executed
	// validations).
	Validations []*Validation `protobuf:"bytes,1,rep,name=validations,proto3" json:"validations,omitempty"`
}

func (x *ValidationResult) Reset() {
	*x = ValidationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationResult) ProtoMessage() {}

func (x *ValidationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationResult.ProtoReflect.Descriptor instead.
func (*ValidationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{39}
}

func (x *ValidationResult) GetValidations() []*Validation {
	if x != nil {
		return x.Validations
	}
	return nil
}

// A validation to perform on a stream.
type Validation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short description of the validation.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Validation execution status.
	State Validation_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.datastream.v1.Validation_State" json:"state,omitempty"`
	// Messages reflecting the validation results.
	Message []*ValidationMessage `protobuf:"bytes,3,rep,name=message,proto3" json:"message,omitempty"`
	// A custom code identifying this validation.
	Code string `protobuf:"bytes,4,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *Validation) Reset() {
	*x = Validation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Validation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Validation) ProtoMessage() {}

func (x *Validation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Validation.ProtoReflect.Descriptor instead.
func (*Validation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{40}
}

func (x *Validation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Validation) GetState() Validation_State {
	if x != nil {
		return x.State
	}
	return Validation_STATE_UNSPECIFIED
}

func (x *Validation) GetMessage() []*ValidationMessage {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *Validation) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// Represent user-facing validation result message.
type ValidationMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the validation.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Message severity level (warning or error).
	Level ValidationMessage_Level `protobuf:"varint,2,opt,name=level,proto3,enum=google.cloud.datastream.v1.ValidationMessage_Level" json:"level,omitempty"`
	// Additional metadata related to the result.
	Metadata map[string]string `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A custom code identifying this specific message.
	Code string `protobuf:"bytes,4,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *ValidationMessage) Reset() {
	*x = ValidationMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationMessage) ProtoMessage() {}

func (x *ValidationMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationMessage.ProtoReflect.Descriptor instead.
func (*ValidationMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{41}
}

func (x *ValidationMessage) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ValidationMessage) GetLevel() ValidationMessage_Level {
	if x != nil {
		return x.Level
	}
	return ValidationMessage_LEVEL_UNSPECIFIED
}

func (x *ValidationMessage) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ValidationMessage) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// Configuration to drop large object values.
type OracleSourceConfig_DropLargeObjects struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *OracleSourceConfig_DropLargeObjects) Reset() {
	*x = OracleSourceConfig_DropLargeObjects{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleSourceConfig_DropLargeObjects) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleSourceConfig_DropLargeObjects) ProtoMessage() {}

func (x *OracleSourceConfig_DropLargeObjects) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleSourceConfig_DropLargeObjects.ProtoReflect.Descriptor instead.
func (*OracleSourceConfig_DropLargeObjects) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{17, 0}
}

// Configuration to stream large object values.
type OracleSourceConfig_StreamLargeObjects struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *OracleSourceConfig_StreamLargeObjects) Reset() {
	*x = OracleSourceConfig_StreamLargeObjects{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleSourceConfig_StreamLargeObjects) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleSourceConfig_StreamLargeObjects) ProtoMessage() {}

func (x *OracleSourceConfig_StreamLargeObjects) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleSourceConfig_StreamLargeObjects.ProtoReflect.Descriptor instead.
func (*OracleSourceConfig_StreamLargeObjects) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{17, 1}
}

// A single target dataset to which all data will be streamed.
type BigQueryDestinationConfig_SingleTargetDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dataset ID of the target dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
}

func (x *BigQueryDestinationConfig_SingleTargetDataset) Reset() {
	*x = BigQueryDestinationConfig_SingleTargetDataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDestinationConfig_SingleTargetDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestinationConfig_SingleTargetDataset) ProtoMessage() {}

func (x *BigQueryDestinationConfig_SingleTargetDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestinationConfig_SingleTargetDataset.ProtoReflect.Descriptor instead.
func (*BigQueryDestinationConfig_SingleTargetDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{32, 0}
}

func (x *BigQueryDestinationConfig_SingleTargetDataset) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

// Destination datasets are created so that hierarchy of the destination data
// objects matches the source hierarchy.
type BigQueryDestinationConfig_SourceHierarchyDatasets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dataset template to use for dynamic dataset creation.
	DatasetTemplate *BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate `protobuf:"bytes,2,opt,name=dataset_template,json=datasetTemplate,proto3" json:"dataset_template,omitempty"`
}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets) Reset() {
	*x = BigQueryDestinationConfig_SourceHierarchyDatasets{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestinationConfig_SourceHierarchyDatasets) ProtoMessage() {}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestinationConfig_SourceHierarchyDatasets.ProtoReflect.Descriptor instead.
func (*BigQueryDestinationConfig_SourceHierarchyDatasets) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{32, 1}
}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets) GetDatasetTemplate() *BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate {
	if x != nil {
		return x.DatasetTemplate
	}
	return nil
}

// Dataset template used for dynamic dataset creation.
type BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The geographic location where the dataset should reside. See
	// https://cloud.google.com/bigquery/docs/locations for supported
	// locations.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// If supplied, every created dataset will have its name prefixed by the
	// provided value. The prefix and name will be separated by an underscore.
	// i.e. <prefix>_<dataset_name>.
	DatasetIdPrefix string `protobuf:"bytes,2,opt,name=dataset_id_prefix,json=datasetIdPrefix,proto3" json:"dataset_id_prefix,omitempty"`
	// Describes the Cloud KMS encryption key that will be used to
	// protect destination BigQuery table. The BigQuery Service Account
	// associated with your project requires access to this encryption key.
	// i.e.
	// projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
	// See https://cloud.google.com/bigquery/docs/customer-managed-encryption
	// for more information.
	KmsKeyName string `protobuf:"bytes,3,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate) Reset() {
	*x = BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate) ProtoMessage() {}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate.ProtoReflect.Descriptor instead.
func (*BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{32, 1, 0}
}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate) GetDatasetIdPrefix() string {
	if x != nil {
		return x.DatasetIdPrefix
	}
	return ""
}

func (x *BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// Backfill strategy to automatically backfill the Stream's objects.
// Specific objects can be excluded.
type Stream_BackfillAllStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of objects to exclude.
	//
	// Types that are assignable to ExcludedObjects:
	//	*Stream_BackfillAllStrategy_OracleExcludedObjects
	//	*Stream_BackfillAllStrategy_MysqlExcludedObjects
	//	*Stream_BackfillAllStrategy_PostgresqlExcludedObjects
	ExcludedObjects isStream_BackfillAllStrategy_ExcludedObjects `protobuf_oneof:"excluded_objects"`
}

func (x *Stream_BackfillAllStrategy) Reset() {
	*x = Stream_BackfillAllStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stream_BackfillAllStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream_BackfillAllStrategy) ProtoMessage() {}

func (x *Stream_BackfillAllStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream_BackfillAllStrategy.ProtoReflect.Descriptor instead.
func (*Stream_BackfillAllStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{34, 0}
}

func (m *Stream_BackfillAllStrategy) GetExcludedObjects() isStream_BackfillAllStrategy_ExcludedObjects {
	if m != nil {
		return m.ExcludedObjects
	}
	return nil
}

func (x *Stream_BackfillAllStrategy) GetOracleExcludedObjects() *OracleRdbms {
	if x, ok := x.GetExcludedObjects().(*Stream_BackfillAllStrategy_OracleExcludedObjects); ok {
		return x.OracleExcludedObjects
	}
	return nil
}

func (x *Stream_BackfillAllStrategy) GetMysqlExcludedObjects() *MysqlRdbms {
	if x, ok := x.GetExcludedObjects().(*Stream_BackfillAllStrategy_MysqlExcludedObjects); ok {
		return x.MysqlExcludedObjects
	}
	return nil
}

func (x *Stream_BackfillAllStrategy) GetPostgresqlExcludedObjects() *PostgresqlRdbms {
	if x, ok := x.GetExcludedObjects().(*Stream_BackfillAllStrategy_PostgresqlExcludedObjects); ok {
		return x.PostgresqlExcludedObjects
	}
	return nil
}

type isStream_BackfillAllStrategy_ExcludedObjects interface {
	isStream_BackfillAllStrategy_ExcludedObjects()
}

type Stream_BackfillAllStrategy_OracleExcludedObjects struct {
	// Oracle data source objects to avoid backfilling.
	OracleExcludedObjects *OracleRdbms `protobuf:"bytes,1,opt,name=oracle_excluded_objects,json=oracleExcludedObjects,proto3,oneof"`
}

type Stream_BackfillAllStrategy_MysqlExcludedObjects struct {
	// MySQL data source objects to avoid backfilling.
	MysqlExcludedObjects *MysqlRdbms `protobuf:"bytes,2,opt,name=mysql_excluded_objects,json=mysqlExcludedObjects,proto3,oneof"`
}

type Stream_BackfillAllStrategy_PostgresqlExcludedObjects struct {
	// PostgreSQL data source objects to avoid backfilling.
	PostgresqlExcludedObjects *PostgresqlRdbms `protobuf:"bytes,3,opt,name=postgresql_excluded_objects,json=postgresqlExcludedObjects,proto3,oneof"`
}

func (*Stream_BackfillAllStrategy_OracleExcludedObjects) isStream_BackfillAllStrategy_ExcludedObjects() {
}

func (*Stream_BackfillAllStrategy_MysqlExcludedObjects) isStream_BackfillAllStrategy_ExcludedObjects() {
}

func (*Stream_BackfillAllStrategy_PostgresqlExcludedObjects) isStream_BackfillAllStrategy_ExcludedObjects() {
}

// Backfill strategy to disable automatic backfill for the Stream's objects.
type Stream_BackfillNoneStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Stream_BackfillNoneStrategy) Reset() {
	*x = Stream_BackfillNoneStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stream_BackfillNoneStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream_BackfillNoneStrategy) ProtoMessage() {}

func (x *Stream_BackfillNoneStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream_BackfillNoneStrategy.ProtoReflect.Descriptor instead.
func (*Stream_BackfillNoneStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{34, 1}
}

// Oracle data source object identifier.
type SourceObjectIdentifier_OracleObjectIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The schema name.
	Schema string `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
	// Required. The table name.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *SourceObjectIdentifier_OracleObjectIdentifier) Reset() {
	*x = SourceObjectIdentifier_OracleObjectIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceObjectIdentifier_OracleObjectIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceObjectIdentifier_OracleObjectIdentifier) ProtoMessage() {}

func (x *SourceObjectIdentifier_OracleObjectIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceObjectIdentifier_OracleObjectIdentifier.ProtoReflect.Descriptor instead.
func (*SourceObjectIdentifier_OracleObjectIdentifier) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{36, 0}
}

func (x *SourceObjectIdentifier_OracleObjectIdentifier) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *SourceObjectIdentifier_OracleObjectIdentifier) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

// PostgreSQL data source object identifier.
type SourceObjectIdentifier_PostgresqlObjectIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The schema name.
	Schema string `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
	// Required. The table name.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *SourceObjectIdentifier_PostgresqlObjectIdentifier) Reset() {
	*x = SourceObjectIdentifier_PostgresqlObjectIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceObjectIdentifier_PostgresqlObjectIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceObjectIdentifier_PostgresqlObjectIdentifier) ProtoMessage() {}

func (x *SourceObjectIdentifier_PostgresqlObjectIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceObjectIdentifier_PostgresqlObjectIdentifier.ProtoReflect.Descriptor instead.
func (*SourceObjectIdentifier_PostgresqlObjectIdentifier) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{36, 1}
}

func (x *SourceObjectIdentifier_PostgresqlObjectIdentifier) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *SourceObjectIdentifier_PostgresqlObjectIdentifier) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

// Mysql data source object identifier.
type SourceObjectIdentifier_MysqlObjectIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database name.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Required. The table name.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (x *SourceObjectIdentifier_MysqlObjectIdentifier) Reset() {
	*x = SourceObjectIdentifier_MysqlObjectIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceObjectIdentifier_MysqlObjectIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceObjectIdentifier_MysqlObjectIdentifier) ProtoMessage() {}

func (x *SourceObjectIdentifier_MysqlObjectIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceObjectIdentifier_MysqlObjectIdentifier.ProtoReflect.Descriptor instead.
func (*SourceObjectIdentifier_MysqlObjectIdentifier) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP(), []int{36, 2}
}

func (x *SourceObjectIdentifier_MysqlObjectIdentifier) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SourceObjectIdentifier_MysqlObjectIdentifier) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

var File_google_cloud_datastream_v1_datastream_resources_proto protoreflect.FileDescriptor

var file_google_cloud_datastream_v1_datastream_resources_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xf9, 0x02, 0x0a, 0x0d, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x2e, 0x0a, 0x10, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x78, 0x0a, 0x15, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x1a, 0x47, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd3, 0x01, 0x0a,
	0x0c, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x1f, 0x0a,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0x52, 0x08, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x49, 0x0a, 0x0a, 0x73, 0x73, 0x6c, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x73,
	0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x73, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0xab, 0x01, 0x0a, 0x11, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12,
	0x1f, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x22, 0x46, 0x0a, 0x0a, 0x47, 0x63, 0x73, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x1b,
	0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x6f, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x72, 0x6f, 0x6f, 0x74, 0x50, 0x61, 0x74, 0x68, 0x22, 0x11, 0x0a, 0x0f, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x1d, 0x0a, 0x1b, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x22, 0xd8, 0x01, 0x0a, 0x1c, 0x46,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x53, 0x73, 0x68, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x08, 0x68,
	0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x21, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x12, 0x26, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00,
	0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x42, 0x17, 0x0a, 0x15,
	0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x6a, 0x0a, 0x10, 0x56, 0x70, 0x63, 0x50, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a, 0x03, 0x76, 0x70, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52,
	0x03, 0x76, 0x70, 0x63, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x22, 0xbf, 0x06, 0x0a, 0x11, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x3c, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x5a, 0x0a,
	0x12, 0x76, 0x70, 0x63, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x76, 0x70, 0x63, 0x50, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x69, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x3a,
	0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x22, 0x79, 0x0a, 0x13, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x62, 0x0a, 0x12, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7,
	0x04, 0x0a, 0x05, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x72, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x85, 0x01, 0xea, 0x41, 0x81, 0x01, 0x0a, 0x1f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x5e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73,
	0x2f, 0x7b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x7d, 0x22, 0xad, 0x02, 0x0a, 0x0e, 0x4d, 0x79, 0x73,
	0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x04, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12,
	0x29, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x11, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x39,
	0x0a, 0x16, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x14, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x61, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0d, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x22, 0x8e, 0x0a, 0x0a, 0x11, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x49, 0x0a, 0x0b, 0x67, 0x63,
	0x73, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x67, 0x63, 0x73, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x4f, 0x0a, 0x0d, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52,
	0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x12, 0x5e, 0x0a, 0x12, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x68, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x11, 0x70,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x12, 0x7f, 0x0a, 0x1e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x48, 0x01, 0x52, 0x1b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x12, 0x75, 0x0a, 0x18, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x5f, 0x73, 0x73, 0x68,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0xc9, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x53, 0x73, 0x68, 0x54, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x01,
	0x52, 0x16, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x53, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x65, 0x0a, 0x14, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x01, 0x52, 0x13, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e,
	0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x4f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x7d, 0x42, 0x09,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x22, 0x93, 0x02, 0x0a, 0x0c, 0x4f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x5f,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x74, 0x0a, 0x0b, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x4f, 0x0a, 0x0e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x52, 0x0d, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x22, 0x74, 0x0a, 0x0c, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x4c, 0x0a,
	0x0d, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0c, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x22, 0x5e, 0x0a, 0x0b, 0x4f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x12, 0x4f, 0x0a, 0x0e, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0d, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x22, 0xe0, 0x04, 0x0a, 0x12,
	0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x50, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x52,
	0x64, 0x62, 0x6d, 0x73, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f,
	0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x64, 0x63, 0x5f, 0x74, 0x61, 0x73,
	0x6b, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x43, 0x64, 0x63, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x12,
	0x41, 0x0a, 0x1d, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1a, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x54, 0x61, 0x73,
	0x6b, 0x73, 0x12, 0x6f, 0x0a, 0x12, 0x64, 0x72, 0x6f, 0x70, 0x5f, 0x6c, 0x61, 0x72, 0x67, 0x65,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44,
	0x72, 0x6f, 0x70, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x48,
	0x00, 0x52, 0x10, 0x64, 0x72, 0x6f, 0x70, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x12, 0x75, 0x0a, 0x14, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6c, 0x61,
	0x72, 0x67, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x66, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x48, 0x00, 0x52, 0x12, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x61,
	0x72, 0x67, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a, 0x12, 0x0a, 0x10, 0x44, 0x72,
	0x6f, 0x70, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a, 0x14,
	0x0a, 0x12, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x42, 0x18, 0x0a, 0x16, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x22, 0xfb,
	0x01, 0x0a, 0x10, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14,
	0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x01, 0x0a,
	0x0f, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x5b, 0x0a, 0x12, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x52, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x73, 0x22, 0x84, 0x01, 0x0a, 0x10, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x12, 0x58, 0x0a, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x10, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x22, 0x6e, 0x0a, 0x0f, 0x50, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x12, 0x5b, 0x0a,
	0x12, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71,
	0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65,
	0x73, 0x71, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x22, 0xe1, 0x02, 0x0a, 0x16, 0x50,
	0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x52, 0x0e, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x54, 0x0a, 0x0f, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x52, 0x64, 0x62, 0x6d,
	0x73, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x12, 0x31, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02,
	0xe0, 0x41, 0x05, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x6c, 0x6f, 0x74, 0x12, 0x25, 0x0a, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x1d, 0x6d,
	0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x61,
	0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x1a, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x22, 0xe0,
	0x01, 0x0a, 0x0b, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x63,
	0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a,
	0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75,
	0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75,
	0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61,
	0x6c, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x70, 0x0a, 0x0a, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x52, 0x0c, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x73, 0x22, 0x76, 0x0a, 0x0d, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x12, 0x49, 0x0a, 0x0c, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0b,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x22, 0x60, 0x0a, 0x0a, 0x4d,
	0x79, 0x73, 0x71, 0x6c, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x12, 0x52, 0x0a, 0x0f, 0x6d, 0x79, 0x73,
	0x71, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x79, 0x73, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x0e, 0x6d,
	0x79, 0x73, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x22, 0xb1, 0x02,
	0x0a, 0x11, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x52,
	0x64, 0x62, 0x6d, 0x73, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c,
	0x52, 0x64, 0x62, 0x6d, 0x73, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x64, 0x63, 0x5f, 0x74, 0x61, 0x73, 0x6b,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x43, 0x64, 0x63, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x12, 0x41,
	0x0a, 0x1d, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1a, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x54, 0x61, 0x73, 0x6b,
	0x73, 0x22, 0xcc, 0x03, 0x0a, 0x0c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x6f, 0x0a, 0x19, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x17, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x62, 0x0a, 0x14, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x64, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x12, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x13, 0x6d, 0x79, 0x73, 0x71, 0x6c,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x65,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x11, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x18, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00,
	0x52, 0x16, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x16, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x10, 0x0a, 0x0e, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x22, 0x8e, 0x03, 0x0a, 0x0e, 0x4a, 0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x69, 0x0a, 0x12, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4a,
	0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x2e, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x10,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x5c, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x60,
	0x0a, 0x10, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x46, 0x49, 0x4c,
	0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48,
	0x45, 0x4d, 0x41, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x56,
	0x52, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x02,
	0x22, 0x51, 0x0a, 0x0f, 0x4a, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x4a, 0x53, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x50,
	0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x43, 0x4f, 0x4d, 0x50,
	0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x5a, 0x49,
	0x50, 0x10, 0x02, 0x22, 0xe4, 0x02, 0x0a, 0x14, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x12, 0x28, 0x0a, 0x10, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65,
	0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x62, 0x12, 0x4f, 0x0a, 0x16, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x56, 0x0a, 0x10, 0x61,
	0x76, 0x72, 0x6f, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18,
	0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x76, 0x72, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x56, 0x0a, 0x10, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x46,
	0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x6a, 0x73, 0x6f,
	0x6e, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0xe2, 0x05, 0x0a, 0x19, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x80, 0x01, 0x0a, 0x15, 0x73, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x48, 0x00, 0x52, 0x13, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x8c, 0x01, 0x0a, 0x19,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x68, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69,
	0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x48,
	0x00, 0x52, 0x17, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63,
	0x68, 0x79, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x41, 0x0a, 0x0e, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x66, 0x72, 0x65, 0x73, 0x68, 0x6e, 0x65, 0x73, 0x73, 0x18, 0xac, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d,
	0x64, 0x61, 0x74, 0x61, 0x46, 0x72, 0x65, 0x73, 0x68, 0x6e, 0x65, 0x73, 0x73, 0x1a, 0x34, 0x0a,
	0x13, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x49, 0x64, 0x1a, 0xa7, 0x02, 0x0a, 0x17, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69,
	0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x79, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12,
	0x88, 0x01, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68,
	0x79, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x1a, 0x80, 0x01, 0x0a, 0x0f, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x1f,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2a, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x49, 0x64, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x20, 0x0a, 0x0c, 0x6b,
	0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x10, 0x0a,
	0x0e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x8e, 0x03, 0x0a, 0x11, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x1e, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x52, 0x1c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x12, 0x68, 0x0a, 0x16, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63,
	0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x77, 0x0a, 0x1b, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x19, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x1b, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xc1, 0x0c, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x12,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x5b, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x61, 0x6c, 0x6c, 0x18,
	0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69,
	0x6c, 0x6c, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52,
	0x0b, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x41, 0x6c, 0x6c, 0x12, 0x5e, 0x0a, 0x0d,
	0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x6e, 0x6f, 0x6e, 0x65, 0x18, 0x66, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c,
	0x4e, 0x6f, 0x6e, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x0c,
	0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x4e, 0x6f, 0x6e, 0x65, 0x12, 0x3e, 0x0a, 0x06,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x4f, 0x0a, 0x1f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x01, 0x52, 0x1c, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x1a, 0xdb, 0x02,
	0x0a, 0x13, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x61, 0x0a, 0x17, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x48,
	0x00, 0x52, 0x15, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x5e, 0x0a, 0x16, 0x6d, 0x79, 0x73, 0x71,
	0x6c, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x52, 0x64, 0x62, 0x6d, 0x73,
	0x48, 0x00, 0x52, 0x14, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x6d, 0x0a, 0x1b, 0x70, 0x6f, 0x73, 0x74,
	0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67,
	0x72, 0x65, 0x73, 0x71, 0x6c, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x48, 0x00, 0x52, 0x19, 0x70, 0x6f,
	0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a, 0x16, 0x0a, 0x14, 0x42,
	0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x4e, 0x6f, 0x6e, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x99,
	0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a,
	0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49,
	0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x5f, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x4c, 0x59, 0x10, 0x06, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x3a, 0x5f, 0xea, 0x41, 0x5c, 0x0a,
	0x20, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x2f, 0x7b, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x62,
	0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x42, 0x22, 0x0a, 0x20, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x22, 0xb0, 0x04, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x62, 0x61,
	0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x4a, 0x6f, 0x62, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x66,
	0x69, 0x6c, 0x6c, 0x4a, 0x6f, 0x62, 0x12, 0x57, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x3a,
	0x76, 0xea, 0x41, 0x73, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x49, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x7b, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d, 0x2f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x22, 0xa2, 0x05, 0x0a, 0x16, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x12, 0x78, 0x0a, 0x11, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x48, 0x00, 0x52, 0x10, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x75, 0x0a, 0x10,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x0f, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x12, 0x84, 0x01, 0x0a, 0x15, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73,
	0x71, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x1a, 0x50, 0x0a, 0x16, 0x4f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x54, 0x0a, 0x1a,
	0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x1a, 0x53, 0x0a, 0x15, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x05,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x22, 0xae, 0x04, 0x0a,
	0x0b, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x4a, 0x6f, 0x62, 0x12, 0x43, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c,
	0x6c, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x49, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x4a, 0x6f, 0x62, 0x2e, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x0f,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6c,
	0x61, 0x73, 0x74, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x81, 0x01, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e,
	0x4f, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44,
	0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0d,
	0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0f, 0x0a,
	0x0b, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x07, 0x22, 0x3d,
	0x0a, 0x07, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x52, 0x49,
	0x47, 0x47, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x99, 0x02,
	0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x55, 0x75, 0x69, 0x64, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x3a, 0x0a,
	0x0c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5c, 0x0a, 0x10, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x48, 0x0a,
	0x0b, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x99, 0x02, 0x0a, 0x0a, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x47, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x48, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54,
	0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x53, 0x53, 0x45,
	0x44, 0x10, 0x03, 0x22, 0xda, 0x02, 0x0a, 0x11, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x49, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x57,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x36, 0x0a, 0x05, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02,
	0x42, 0xa8, 0x02, 0xea, 0x41, 0x4f, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x18, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x70,
	0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datastream_v1_datastream_resources_proto_rawDescOnce sync.Once
	file_google_cloud_datastream_v1_datastream_resources_proto_rawDescData = file_google_cloud_datastream_v1_datastream_resources_proto_rawDesc
)

func file_google_cloud_datastream_v1_datastream_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_datastream_v1_datastream_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_datastream_v1_datastream_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datastream_v1_datastream_resources_proto_rawDescData)
	})
	return file_google_cloud_datastream_v1_datastream_resources_proto_rawDescData
}

var file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 59)
var file_google_cloud_datastream_v1_datastream_resources_proto_goTypes = []interface{}{
	(PrivateConnection_State)(0),                  // 0: google.cloud.datastream.v1.PrivateConnection.State
	(JsonFileFormat_SchemaFileFormat)(0),          // 1: google.cloud.datastream.v1.JsonFileFormat.SchemaFileFormat
	(JsonFileFormat_JsonCompression)(0),           // 2: google.cloud.datastream.v1.JsonFileFormat.JsonCompression
	(Stream_State)(0),                             // 3: google.cloud.datastream.v1.Stream.State
	(BackfillJob_State)(0),                        // 4: google.cloud.datastream.v1.BackfillJob.State
	(BackfillJob_Trigger)(0),                      // 5: google.cloud.datastream.v1.BackfillJob.Trigger
	(Validation_State)(0),                         // 6: google.cloud.datastream.v1.Validation.State
	(ValidationMessage_Level)(0),                  // 7: google.cloud.datastream.v1.ValidationMessage.Level
	(*OracleProfile)(nil),                         // 8: google.cloud.datastream.v1.OracleProfile
	(*MysqlProfile)(nil),                          // 9: google.cloud.datastream.v1.MysqlProfile
	(*PostgresqlProfile)(nil),                     // 10: google.cloud.datastream.v1.PostgresqlProfile
	(*GcsProfile)(nil),                            // 11: google.cloud.datastream.v1.GcsProfile
	(*BigQueryProfile)(nil),                       // 12: google.cloud.datastream.v1.BigQueryProfile
	(*StaticServiceIpConnectivity)(nil),           // 13: google.cloud.datastream.v1.StaticServiceIpConnectivity
	(*ForwardSshTunnelConnectivity)(nil),          // 14: google.cloud.datastream.v1.ForwardSshTunnelConnectivity
	(*VpcPeeringConfig)(nil),                      // 15: google.cloud.datastream.v1.VpcPeeringConfig
	(*PrivateConnection)(nil),                     // 16: google.cloud.datastream.v1.PrivateConnection
	(*PrivateConnectivity)(nil),                   // 17: google.cloud.datastream.v1.PrivateConnectivity
	(*Route)(nil),                                 // 18: google.cloud.datastream.v1.Route
	(*MysqlSslConfig)(nil),                        // 19: google.cloud.datastream.v1.MysqlSslConfig
	(*ConnectionProfile)(nil),                     // 20: google.cloud.datastream.v1.ConnectionProfile
	(*OracleColumn)(nil),                          // 21: google.cloud.datastream.v1.OracleColumn
	(*OracleTable)(nil),                           // 22: google.cloud.datastream.v1.OracleTable
	(*OracleSchema)(nil),                          // 23: google.cloud.datastream.v1.OracleSchema
	(*OracleRdbms)(nil),                           // 24: google.cloud.datastream.v1.OracleRdbms
	(*OracleSourceConfig)(nil),                    // 25: google.cloud.datastream.v1.OracleSourceConfig
	(*PostgresqlColumn)(nil),                      // 26: google.cloud.datastream.v1.PostgresqlColumn
	(*PostgresqlTable)(nil),                       // 27: google.cloud.datastream.v1.PostgresqlTable
	(*PostgresqlSchema)(nil),                      // 28: google.cloud.datastream.v1.PostgresqlSchema
	(*PostgresqlRdbms)(nil),                       // 29: google.cloud.datastream.v1.PostgresqlRdbms
	(*PostgresqlSourceConfig)(nil),                // 30: google.cloud.datastream.v1.PostgresqlSourceConfig
	(*MysqlColumn)(nil),                           // 31: google.cloud.datastream.v1.MysqlColumn
	(*MysqlTable)(nil),                            // 32: google.cloud.datastream.v1.MysqlTable
	(*MysqlDatabase)(nil),                         // 33: google.cloud.datastream.v1.MysqlDatabase
	(*MysqlRdbms)(nil),                            // 34: google.cloud.datastream.v1.MysqlRdbms
	(*MysqlSourceConfig)(nil),                     // 35: google.cloud.datastream.v1.MysqlSourceConfig
	(*SourceConfig)(nil),                          // 36: google.cloud.datastream.v1.SourceConfig
	(*AvroFileFormat)(nil),                        // 37: google.cloud.datastream.v1.AvroFileFormat
	(*JsonFileFormat)(nil),                        // 38: google.cloud.datastream.v1.JsonFileFormat
	(*GcsDestinationConfig)(nil),                  // 39: google.cloud.datastream.v1.GcsDestinationConfig
	(*BigQueryDestinationConfig)(nil),             // 40: google.cloud.datastream.v1.BigQueryDestinationConfig
	(*DestinationConfig)(nil),                     // 41: google.cloud.datastream.v1.DestinationConfig
	(*Stream)(nil),                                // 42: google.cloud.datastream.v1.Stream
	(*StreamObject)(nil),                          // 43: google.cloud.datastream.v1.StreamObject
	(*SourceObjectIdentifier)(nil),                // 44: google.cloud.datastream.v1.SourceObjectIdentifier
	(*BackfillJob)(nil),                           // 45: google.cloud.datastream.v1.BackfillJob
	(*Error)(nil),                                 // 46: google.cloud.datastream.v1.Error
	(*ValidationResult)(nil),                      // 47: google.cloud.datastream.v1.ValidationResult
	(*Validation)(nil),                            // 48: google.cloud.datastream.v1.Validation
	(*ValidationMessage)(nil),                     // 49: google.cloud.datastream.v1.ValidationMessage
	nil,                                           // 50: google.cloud.datastream.v1.OracleProfile.ConnectionAttributesEntry
	nil,                                           // 51: google.cloud.datastream.v1.PrivateConnection.LabelsEntry
	nil,                                           // 52: google.cloud.datastream.v1.Route.LabelsEntry
	nil,                                           // 53: google.cloud.datastream.v1.ConnectionProfile.LabelsEntry
	(*OracleSourceConfig_DropLargeObjects)(nil),   // 54: google.cloud.datastream.v1.OracleSourceConfig.DropLargeObjects
	(*OracleSourceConfig_StreamLargeObjects)(nil), // 55: google.cloud.datastream.v1.OracleSourceConfig.StreamLargeObjects
	(*BigQueryDestinationConfig_SingleTargetDataset)(nil),                     // 56: google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
	(*BigQueryDestinationConfig_SourceHierarchyDatasets)(nil),                 // 57: google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
	(*BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate)(nil), // 58: google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate
	(*Stream_BackfillAllStrategy)(nil),                                        // 59: google.cloud.datastream.v1.Stream.BackfillAllStrategy
	(*Stream_BackfillNoneStrategy)(nil),                                       // 60: google.cloud.datastream.v1.Stream.BackfillNoneStrategy
	nil,                                                                       // 61: google.cloud.datastream.v1.Stream.LabelsEntry
	(*SourceObjectIdentifier_OracleObjectIdentifier)(nil),                     // 62: google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
	(*SourceObjectIdentifier_PostgresqlObjectIdentifier)(nil),                 // 63: google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
	(*SourceObjectIdentifier_MysqlObjectIdentifier)(nil),                      // 64: google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
	nil,                           // 65: google.cloud.datastream.v1.Error.DetailsEntry
	nil,                           // 66: google.cloud.datastream.v1.ValidationMessage.MetadataEntry
	(*timestamppb.Timestamp)(nil), // 67: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 68: google.protobuf.Duration
}
var file_google_cloud_datastream_v1_datastream_resources_proto_depIdxs = []int32{
	50, // 0: google.cloud.datastream.v1.OracleProfile.connection_attributes:type_name -> google.cloud.datastream.v1.OracleProfile.ConnectionAttributesEntry
	19, // 1: google.cloud.datastream.v1.MysqlProfile.ssl_config:type_name -> google.cloud.datastream.v1.MysqlSslConfig
	67, // 2: google.cloud.datastream.v1.PrivateConnection.create_time:type_name -> google.protobuf.Timestamp
	67, // 3: google.cloud.datastream.v1.PrivateConnection.update_time:type_name -> google.protobuf.Timestamp
	51, // 4: google.cloud.datastream.v1.PrivateConnection.labels:type_name -> google.cloud.datastream.v1.PrivateConnection.LabelsEntry
	0,  // 5: google.cloud.datastream.v1.PrivateConnection.state:type_name -> google.cloud.datastream.v1.PrivateConnection.State
	46, // 6: google.cloud.datastream.v1.PrivateConnection.error:type_name -> google.cloud.datastream.v1.Error
	15, // 7: google.cloud.datastream.v1.PrivateConnection.vpc_peering_config:type_name -> google.cloud.datastream.v1.VpcPeeringConfig
	67, // 8: google.cloud.datastream.v1.Route.create_time:type_name -> google.protobuf.Timestamp
	67, // 9: google.cloud.datastream.v1.Route.update_time:type_name -> google.protobuf.Timestamp
	52, // 10: google.cloud.datastream.v1.Route.labels:type_name -> google.cloud.datastream.v1.Route.LabelsEntry
	67, // 11: google.cloud.datastream.v1.ConnectionProfile.create_time:type_name -> google.protobuf.Timestamp
	67, // 12: google.cloud.datastream.v1.ConnectionProfile.update_time:type_name -> google.protobuf.Timestamp
	53, // 13: google.cloud.datastream.v1.ConnectionProfile.labels:type_name -> google.cloud.datastream.v1.ConnectionProfile.LabelsEntry
	8,  // 14: google.cloud.datastream.v1.ConnectionProfile.oracle_profile:type_name -> google.cloud.datastream.v1.OracleProfile
	11, // 15: google.cloud.datastream.v1.ConnectionProfile.gcs_profile:type_name -> google.cloud.datastream.v1.GcsProfile
	9,  // 16: google.cloud.datastream.v1.ConnectionProfile.mysql_profile:type_name -> google.cloud.datastream.v1.MysqlProfile
	12, // 17: google.cloud.datastream.v1.ConnectionProfile.bigquery_profile:type_name -> google.cloud.datastream.v1.BigQueryProfile
	10, // 18: google.cloud.datastream.v1.ConnectionProfile.postgresql_profile:type_name -> google.cloud.datastream.v1.PostgresqlProfile
	13, // 19: google.cloud.datastream.v1.ConnectionProfile.static_service_ip_connectivity:type_name -> google.cloud.datastream.v1.StaticServiceIpConnectivity
	14, // 20: google.cloud.datastream.v1.ConnectionProfile.forward_ssh_connectivity:type_name -> google.cloud.datastream.v1.ForwardSshTunnelConnectivity
	17, // 21: google.cloud.datastream.v1.ConnectionProfile.private_connectivity:type_name -> google.cloud.datastream.v1.PrivateConnectivity
	21, // 22: google.cloud.datastream.v1.OracleTable.oracle_columns:type_name -> google.cloud.datastream.v1.OracleColumn
	22, // 23: google.cloud.datastream.v1.OracleSchema.oracle_tables:type_name -> google.cloud.datastream.v1.OracleTable
	23, // 24: google.cloud.datastream.v1.OracleRdbms.oracle_schemas:type_name -> google.cloud.datastream.v1.OracleSchema
	24, // 25: google.cloud.datastream.v1.OracleSourceConfig.include_objects:type_name -> google.cloud.datastream.v1.OracleRdbms
	24, // 26: google.cloud.datastream.v1.OracleSourceConfig.exclude_objects:type_name -> google.cloud.datastream.v1.OracleRdbms
	54, // 27: google.cloud.datastream.v1.OracleSourceConfig.drop_large_objects:type_name -> google.cloud.datastream.v1.OracleSourceConfig.DropLargeObjects
	55, // 28: google.cloud.datastream.v1.OracleSourceConfig.stream_large_objects:type_name -> google.cloud.datastream.v1.OracleSourceConfig.StreamLargeObjects
	26, // 29: google.cloud.datastream.v1.PostgresqlTable.postgresql_columns:type_name -> google.cloud.datastream.v1.PostgresqlColumn
	27, // 30: google.cloud.datastream.v1.PostgresqlSchema.postgresql_tables:type_name -> google.cloud.datastream.v1.PostgresqlTable
	28, // 31: google.cloud.datastream.v1.PostgresqlRdbms.postgresql_schemas:type_name -> google.cloud.datastream.v1.PostgresqlSchema
	29, // 32: google.cloud.datastream.v1.PostgresqlSourceConfig.include_objects:type_name -> google.cloud.datastream.v1.PostgresqlRdbms
	29, // 33: google.cloud.datastream.v1.PostgresqlSourceConfig.exclude_objects:type_name -> google.cloud.datastream.v1.PostgresqlRdbms
	31, // 34: google.cloud.datastream.v1.MysqlTable.mysql_columns:type_name -> google.cloud.datastream.v1.MysqlColumn
	32, // 35: google.cloud.datastream.v1.MysqlDatabase.mysql_tables:type_name -> google.cloud.datastream.v1.MysqlTable
	33, // 36: google.cloud.datastream.v1.MysqlRdbms.mysql_databases:type_name -> google.cloud.datastream.v1.MysqlDatabase
	34, // 37: google.cloud.datastream.v1.MysqlSourceConfig.include_objects:type_name -> google.cloud.datastream.v1.MysqlRdbms
	34, // 38: google.cloud.datastream.v1.MysqlSourceConfig.exclude_objects:type_name -> google.cloud.datastream.v1.MysqlRdbms
	25, // 39: google.cloud.datastream.v1.SourceConfig.oracle_source_config:type_name -> google.cloud.datastream.v1.OracleSourceConfig
	35, // 40: google.cloud.datastream.v1.SourceConfig.mysql_source_config:type_name -> google.cloud.datastream.v1.MysqlSourceConfig
	30, // 41: google.cloud.datastream.v1.SourceConfig.postgresql_source_config:type_name -> google.cloud.datastream.v1.PostgresqlSourceConfig
	1,  // 42: google.cloud.datastream.v1.JsonFileFormat.schema_file_format:type_name -> google.cloud.datastream.v1.JsonFileFormat.SchemaFileFormat
	2,  // 43: google.cloud.datastream.v1.JsonFileFormat.compression:type_name -> google.cloud.datastream.v1.JsonFileFormat.JsonCompression
	68, // 44: google.cloud.datastream.v1.GcsDestinationConfig.file_rotation_interval:type_name -> google.protobuf.Duration
	37, // 45: google.cloud.datastream.v1.GcsDestinationConfig.avro_file_format:type_name -> google.cloud.datastream.v1.AvroFileFormat
	38, // 46: google.cloud.datastream.v1.GcsDestinationConfig.json_file_format:type_name -> google.cloud.datastream.v1.JsonFileFormat
	56, // 47: google.cloud.datastream.v1.BigQueryDestinationConfig.single_target_dataset:type_name -> google.cloud.datastream.v1.BigQueryDestinationConfig.SingleTargetDataset
	57, // 48: google.cloud.datastream.v1.BigQueryDestinationConfig.source_hierarchy_datasets:type_name -> google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets
	68, // 49: google.cloud.datastream.v1.BigQueryDestinationConfig.data_freshness:type_name -> google.protobuf.Duration
	39, // 50: google.cloud.datastream.v1.DestinationConfig.gcs_destination_config:type_name -> google.cloud.datastream.v1.GcsDestinationConfig
	40, // 51: google.cloud.datastream.v1.DestinationConfig.bigquery_destination_config:type_name -> google.cloud.datastream.v1.BigQueryDestinationConfig
	67, // 52: google.cloud.datastream.v1.Stream.create_time:type_name -> google.protobuf.Timestamp
	67, // 53: google.cloud.datastream.v1.Stream.update_time:type_name -> google.protobuf.Timestamp
	61, // 54: google.cloud.datastream.v1.Stream.labels:type_name -> google.cloud.datastream.v1.Stream.LabelsEntry
	36, // 55: google.cloud.datastream.v1.Stream.source_config:type_name -> google.cloud.datastream.v1.SourceConfig
	41, // 56: google.cloud.datastream.v1.Stream.destination_config:type_name -> google.cloud.datastream.v1.DestinationConfig
	3,  // 57: google.cloud.datastream.v1.Stream.state:type_name -> google.cloud.datastream.v1.Stream.State
	59, // 58: google.cloud.datastream.v1.Stream.backfill_all:type_name -> google.cloud.datastream.v1.Stream.BackfillAllStrategy
	60, // 59: google.cloud.datastream.v1.Stream.backfill_none:type_name -> google.cloud.datastream.v1.Stream.BackfillNoneStrategy
	46, // 60: google.cloud.datastream.v1.Stream.errors:type_name -> google.cloud.datastream.v1.Error
	67, // 61: google.cloud.datastream.v1.StreamObject.create_time:type_name -> google.protobuf.Timestamp
	67, // 62: google.cloud.datastream.v1.StreamObject.update_time:type_name -> google.protobuf.Timestamp
	46, // 63: google.cloud.datastream.v1.StreamObject.errors:type_name -> google.cloud.datastream.v1.Error
	45, // 64: google.cloud.datastream.v1.StreamObject.backfill_job:type_name -> google.cloud.datastream.v1.BackfillJob
	44, // 65: google.cloud.datastream.v1.StreamObject.source_object:type_name -> google.cloud.datastream.v1.SourceObjectIdentifier
	62, // 66: google.cloud.datastream.v1.SourceObjectIdentifier.oracle_identifier:type_name -> google.cloud.datastream.v1.SourceObjectIdentifier.OracleObjectIdentifier
	64, // 67: google.cloud.datastream.v1.SourceObjectIdentifier.mysql_identifier:type_name -> google.cloud.datastream.v1.SourceObjectIdentifier.MysqlObjectIdentifier
	63, // 68: google.cloud.datastream.v1.SourceObjectIdentifier.postgresql_identifier:type_name -> google.cloud.datastream.v1.SourceObjectIdentifier.PostgresqlObjectIdentifier
	4,  // 69: google.cloud.datastream.v1.BackfillJob.state:type_name -> google.cloud.datastream.v1.BackfillJob.State
	5,  // 70: google.cloud.datastream.v1.BackfillJob.trigger:type_name -> google.cloud.datastream.v1.BackfillJob.Trigger
	67, // 71: google.cloud.datastream.v1.BackfillJob.last_start_time:type_name -> google.protobuf.Timestamp
	67, // 72: google.cloud.datastream.v1.BackfillJob.last_end_time:type_name -> google.protobuf.Timestamp
	46, // 73: google.cloud.datastream.v1.BackfillJob.errors:type_name -> google.cloud.datastream.v1.Error
	67, // 74: google.cloud.datastream.v1.Error.error_time:type_name -> google.protobuf.Timestamp
	65, // 75: google.cloud.datastream.v1.Error.details:type_name -> google.cloud.datastream.v1.Error.DetailsEntry
	48, // 76: google.cloud.datastream.v1.ValidationResult.validations:type_name -> google.cloud.datastream.v1.Validation
	6,  // 77: google.cloud.datastream.v1.Validation.state:type_name -> google.cloud.datastream.v1.Validation.State
	49, // 78: google.cloud.datastream.v1.Validation.message:type_name -> google.cloud.datastream.v1.ValidationMessage
	7,  // 79: google.cloud.datastream.v1.ValidationMessage.level:type_name -> google.cloud.datastream.v1.ValidationMessage.Level
	66, // 80: google.cloud.datastream.v1.ValidationMessage.metadata:type_name -> google.cloud.datastream.v1.ValidationMessage.MetadataEntry
	58, // 81: google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.dataset_template:type_name -> google.cloud.datastream.v1.BigQueryDestinationConfig.SourceHierarchyDatasets.DatasetTemplate
	24, // 82: google.cloud.datastream.v1.Stream.BackfillAllStrategy.oracle_excluded_objects:type_name -> google.cloud.datastream.v1.OracleRdbms
	34, // 83: google.cloud.datastream.v1.Stream.BackfillAllStrategy.mysql_excluded_objects:type_name -> google.cloud.datastream.v1.MysqlRdbms
	29, // 84: google.cloud.datastream.v1.Stream.BackfillAllStrategy.postgresql_excluded_objects:type_name -> google.cloud.datastream.v1.PostgresqlRdbms
	85, // [85:85] is the sub-list for method output_type
	85, // [85:85] is the sub-list for method input_type
	85, // [85:85] is the sub-list for extension type_name
	85, // [85:85] is the sub-list for extension extendee
	0,  // [0:85] is the sub-list for field type_name
}

func init() { file_google_cloud_datastream_v1_datastream_resources_proto_init() }
func file_google_cloud_datastream_v1_datastream_resources_proto_init() {
	if File_google_cloud_datastream_v1_datastream_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgresqlProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StaticServiceIpConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForwardSshTunnelConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VpcPeeringConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Route); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlSslConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleColumn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleRdbms); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleSourceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgresqlColumn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgresqlTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgresqlSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgresqlRdbms); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgresqlSourceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlColumn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlDatabase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlRdbms); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlSourceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvroFileFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JsonFileFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestinationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryDestinationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamObject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceObjectIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackfillJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Validation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleSourceConfig_DropLargeObjects); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleSourceConfig_StreamLargeObjects); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryDestinationConfig_SingleTargetDataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryDestinationConfig_SourceHierarchyDatasets); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryDestinationConfig_SourceHierarchyDatasets_DatasetTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stream_BackfillAllStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stream_BackfillNoneStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceObjectIdentifier_OracleObjectIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceObjectIdentifier_PostgresqlObjectIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceObjectIdentifier_MysqlObjectIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*ForwardSshTunnelConnectivity_Password)(nil),
		(*ForwardSshTunnelConnectivity_PrivateKey)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*ConnectionProfile_OracleProfile)(nil),
		(*ConnectionProfile_GcsProfile)(nil),
		(*ConnectionProfile_MysqlProfile)(nil),
		(*ConnectionProfile_BigqueryProfile)(nil),
		(*ConnectionProfile_PostgresqlProfile)(nil),
		(*ConnectionProfile_StaticServiceIpConnectivity)(nil),
		(*ConnectionProfile_ForwardSshConnectivity)(nil),
		(*ConnectionProfile_PrivateConnectivity)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*OracleSourceConfig_DropLargeObjects_)(nil),
		(*OracleSourceConfig_StreamLargeObjects_)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[28].OneofWrappers = []interface{}{
		(*SourceConfig_OracleSourceConfig)(nil),
		(*SourceConfig_MysqlSourceConfig)(nil),
		(*SourceConfig_PostgresqlSourceConfig)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[31].OneofWrappers = []interface{}{
		(*GcsDestinationConfig_AvroFileFormat)(nil),
		(*GcsDestinationConfig_JsonFileFormat)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[32].OneofWrappers = []interface{}{
		(*BigQueryDestinationConfig_SingleTargetDataset_)(nil),
		(*BigQueryDestinationConfig_SourceHierarchyDatasets_)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[33].OneofWrappers = []interface{}{
		(*DestinationConfig_GcsDestinationConfig)(nil),
		(*DestinationConfig_BigqueryDestinationConfig)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[34].OneofWrappers = []interface{}{
		(*Stream_BackfillAll)(nil),
		(*Stream_BackfillNone)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[36].OneofWrappers = []interface{}{
		(*SourceObjectIdentifier_OracleIdentifier)(nil),
		(*SourceObjectIdentifier_MysqlIdentifier)(nil),
		(*SourceObjectIdentifier_PostgresqlIdentifier)(nil),
	}
	file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes[51].OneofWrappers = []interface{}{
		(*Stream_BackfillAllStrategy_OracleExcludedObjects)(nil),
		(*Stream_BackfillAllStrategy_MysqlExcludedObjects)(nil),
		(*Stream_BackfillAllStrategy_PostgresqlExcludedObjects)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datastream_v1_datastream_resources_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   59,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datastream_v1_datastream_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_datastream_v1_datastream_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_datastream_v1_datastream_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_datastream_v1_datastream_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_datastream_v1_datastream_resources_proto = out.File
	file_google_cloud_datastream_v1_datastream_resources_proto_rawDesc = nil
	file_google_cloud_datastream_v1_datastream_resources_proto_goTypes = nil
	file_google_cloud_datastream_v1_datastream_resources_proto_depIdxs = nil
}
