// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/dataplex/v1/data_quality.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list of aggregate metrics a rule can be evaluated against.
type DataQualityRule_StatisticRangeExpectation_ColumnStatistic int32

const (
	// Unspecified statistic type
	DataQualityRule_StatisticRangeExpectation_STATISTIC_UNDEFINED DataQualityRule_StatisticRangeExpectation_ColumnStatistic = 0
	// Evaluate the column mean
	DataQualityRule_StatisticRangeExpectation_MEAN DataQualityRule_StatisticRangeExpectation_ColumnStatistic = 1
	// Evaluate the column min
	DataQualityRule_StatisticRangeExpectation_MIN DataQualityRule_StatisticRangeExpectation_ColumnStatistic = 2
	// Evaluate the column max
	DataQualityRule_StatisticRangeExpectation_MAX DataQualityRule_StatisticRangeExpectation_ColumnStatistic = 3
)

// Enum value maps for DataQualityRule_StatisticRangeExpectation_ColumnStatistic.
var (
	DataQualityRule_StatisticRangeExpectation_ColumnStatistic_name = map[int32]string{
		0: "STATISTIC_UNDEFINED",
		1: "MEAN",
		2: "MIN",
		3: "MAX",
	}
	DataQualityRule_StatisticRangeExpectation_ColumnStatistic_value = map[string]int32{
		"STATISTIC_UNDEFINED": 0,
		"MEAN":                1,
		"MIN":                 2,
		"MAX":                 3,
	}
)

func (x DataQualityRule_StatisticRangeExpectation_ColumnStatistic) Enum() *DataQualityRule_StatisticRangeExpectation_ColumnStatistic {
	p := new(DataQualityRule_StatisticRangeExpectation_ColumnStatistic)
	*p = x
	return p
}

func (x DataQualityRule_StatisticRangeExpectation_ColumnStatistic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataQualityRule_StatisticRangeExpectation_ColumnStatistic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_data_quality_proto_enumTypes[0].Descriptor()
}

func (DataQualityRule_StatisticRangeExpectation_ColumnStatistic) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_data_quality_proto_enumTypes[0]
}

func (x DataQualityRule_StatisticRangeExpectation_ColumnStatistic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataQualityRule_StatisticRangeExpectation_ColumnStatistic.Descriptor instead.
func (DataQualityRule_StatisticRangeExpectation_ColumnStatistic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 5, 0}
}

// DataQualityScan related setting.
type DataQualitySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of rules to evaluate against a data source. At least one rule is
	// required.
	Rules []*DataQualityRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *DataQualitySpec) Reset() {
	*x = DataQualitySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualitySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec) ProtoMessage() {}

func (x *DataQualitySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec.ProtoReflect.Descriptor instead.
func (*DataQualitySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0}
}

func (x *DataQualitySpec) GetRules() []*DataQualityRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// The output of a DataQualityScan.
type DataQualityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Overall data quality result -- `true` if all rules passed.
	Passed bool `protobuf:"varint,5,opt,name=passed,proto3" json:"passed,omitempty"`
	// A list of results at the dimension level.
	Dimensions []*DataQualityDimensionResult `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// A list of all the rules in a job, and their results.
	Rules []*DataQualityRuleResult `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
	// The count of rows processed.
	RowCount int64 `protobuf:"varint,4,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// The data scanned for this result.
	ScannedData *ScannedData `protobuf:"bytes,7,opt,name=scanned_data,json=scannedData,proto3" json:"scanned_data,omitempty"`
}

func (x *DataQualityResult) Reset() {
	*x = DataQualityResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityResult) ProtoMessage() {}

func (x *DataQualityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityResult.ProtoReflect.Descriptor instead.
func (*DataQualityResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{1}
}

func (x *DataQualityResult) GetPassed() bool {
	if x != nil {
		return x.Passed
	}
	return false
}

func (x *DataQualityResult) GetDimensions() []*DataQualityDimensionResult {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *DataQualityResult) GetRules() []*DataQualityRuleResult {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *DataQualityResult) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *DataQualityResult) GetScannedData() *ScannedData {
	if x != nil {
		return x.ScannedData
	}
	return nil
}

// DataQualityRuleResult provides a more detailed, per-rule view of the results.
type DataQualityRuleResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rule specified in the DataQualitySpec, as is.
	Rule *DataQualityRule `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	// Whether the rule passed or failed.
	Passed bool `protobuf:"varint,7,opt,name=passed,proto3" json:"passed,omitempty"`
	// The number of rows a rule was evaluated against. This field is only valid
	// for ColumnMap type rules.
	//
	// Evaluated count can be configured to either
	//
	// * include all rows (default) - with `null` rows automatically failing rule
	// evaluation, or
	// * exclude `null` rows from the `evaluated_count`, by setting
	// `ignore_nulls = true`.
	EvaluatedCount int64 `protobuf:"varint,9,opt,name=evaluated_count,json=evaluatedCount,proto3" json:"evaluated_count,omitempty"`
	// The number of rows which passed a rule evaluation.
	// This field is only valid for ColumnMap type rules.
	PassedCount int64 `protobuf:"varint,8,opt,name=passed_count,json=passedCount,proto3" json:"passed_count,omitempty"`
	// The number of rows with null values in the specified column.
	NullCount int64 `protobuf:"varint,5,opt,name=null_count,json=nullCount,proto3" json:"null_count,omitempty"`
	// The ratio of **passed_count / evaluated_count**.
	// This field is only valid for ColumnMap type rules.
	PassRatio float64 `protobuf:"fixed64,6,opt,name=pass_ratio,json=passRatio,proto3" json:"pass_ratio,omitempty"`
	// The query to find rows that did not pass this rule.
	// Only applies to ColumnMap and RowCondition rules.
	FailingRowsQuery string `protobuf:"bytes,10,opt,name=failing_rows_query,json=failingRowsQuery,proto3" json:"failing_rows_query,omitempty"`
}

func (x *DataQualityRuleResult) Reset() {
	*x = DataQualityRuleResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRuleResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRuleResult) ProtoMessage() {}

func (x *DataQualityRuleResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRuleResult.ProtoReflect.Descriptor instead.
func (*DataQualityRuleResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{2}
}

func (x *DataQualityRuleResult) GetRule() *DataQualityRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *DataQualityRuleResult) GetPassed() bool {
	if x != nil {
		return x.Passed
	}
	return false
}

func (x *DataQualityRuleResult) GetEvaluatedCount() int64 {
	if x != nil {
		return x.EvaluatedCount
	}
	return 0
}

func (x *DataQualityRuleResult) GetPassedCount() int64 {
	if x != nil {
		return x.PassedCount
	}
	return 0
}

func (x *DataQualityRuleResult) GetNullCount() int64 {
	if x != nil {
		return x.NullCount
	}
	return 0
}

func (x *DataQualityRuleResult) GetPassRatio() float64 {
	if x != nil {
		return x.PassRatio
	}
	return 0
}

func (x *DataQualityRuleResult) GetFailingRowsQuery() string {
	if x != nil {
		return x.FailingRowsQuery
	}
	return ""
}

// DataQualityDimensionResult provides a more detailed, per-dimension view of
// the results.
type DataQualityDimensionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the dimension passed or failed.
	Passed bool `protobuf:"varint,3,opt,name=passed,proto3" json:"passed,omitempty"`
}

func (x *DataQualityDimensionResult) Reset() {
	*x = DataQualityDimensionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityDimensionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityDimensionResult) ProtoMessage() {}

func (x *DataQualityDimensionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityDimensionResult.ProtoReflect.Descriptor instead.
func (*DataQualityDimensionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{3}
}

func (x *DataQualityDimensionResult) GetPassed() bool {
	if x != nil {
		return x.Passed
	}
	return false
}

// A rule captures data quality intent about a data source.
type DataQualityRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rule-specific configuration.
	//
	// Types that are assignable to RuleType:
	//	*DataQualityRule_RangeExpectation_
	//	*DataQualityRule_NonNullExpectation_
	//	*DataQualityRule_SetExpectation_
	//	*DataQualityRule_RegexExpectation_
	//	*DataQualityRule_UniquenessExpectation_
	//	*DataQualityRule_StatisticRangeExpectation_
	//	*DataQualityRule_RowConditionExpectation_
	//	*DataQualityRule_TableConditionExpectation_
	RuleType isDataQualityRule_RuleType `protobuf_oneof:"rule_type"`
	// Optional. The unnested column which this rule is evaluated against.
	Column string `protobuf:"bytes,500,opt,name=column,proto3" json:"column,omitempty"`
	// Optional. Rows with `null` values will automatically fail a rule, unless
	// `ignore_null` is `true`. In that case, such `null` rows are trivially
	// considered passing.
	//
	// Only applicable to ColumnMap rules.
	IgnoreNull bool `protobuf:"varint,501,opt,name=ignore_null,json=ignoreNull,proto3" json:"ignore_null,omitempty"`
	// Required. The dimension a rule belongs to. Results are also aggregated at
	// the dimension level. Supported dimensions are **["COMPLETENESS",
	// "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS", "INTEGRITY"]**
	Dimension string `protobuf:"bytes,502,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// Optional. The minimum ratio of **passing_rows / total_rows** required to
	// pass this rule, with a range of [0.0, 1.0].
	//
	// 0 indicates default value (i.e. 1.0).
	Threshold float64 `protobuf:"fixed64,503,opt,name=threshold,proto3" json:"threshold,omitempty"`
}

func (x *DataQualityRule) Reset() {
	*x = DataQualityRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule) ProtoMessage() {}

func (x *DataQualityRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule.ProtoReflect.Descriptor instead.
func (*DataQualityRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4}
}

func (m *DataQualityRule) GetRuleType() isDataQualityRule_RuleType {
	if m != nil {
		return m.RuleType
	}
	return nil
}

func (x *DataQualityRule) GetRangeExpectation() *DataQualityRule_RangeExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_RangeExpectation_); ok {
		return x.RangeExpectation
	}
	return nil
}

func (x *DataQualityRule) GetNonNullExpectation() *DataQualityRule_NonNullExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_NonNullExpectation_); ok {
		return x.NonNullExpectation
	}
	return nil
}

func (x *DataQualityRule) GetSetExpectation() *DataQualityRule_SetExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_SetExpectation_); ok {
		return x.SetExpectation
	}
	return nil
}

func (x *DataQualityRule) GetRegexExpectation() *DataQualityRule_RegexExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_RegexExpectation_); ok {
		return x.RegexExpectation
	}
	return nil
}

func (x *DataQualityRule) GetUniquenessExpectation() *DataQualityRule_UniquenessExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_UniquenessExpectation_); ok {
		return x.UniquenessExpectation
	}
	return nil
}

func (x *DataQualityRule) GetStatisticRangeExpectation() *DataQualityRule_StatisticRangeExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_StatisticRangeExpectation_); ok {
		return x.StatisticRangeExpectation
	}
	return nil
}

func (x *DataQualityRule) GetRowConditionExpectation() *DataQualityRule_RowConditionExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_RowConditionExpectation_); ok {
		return x.RowConditionExpectation
	}
	return nil
}

func (x *DataQualityRule) GetTableConditionExpectation() *DataQualityRule_TableConditionExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_TableConditionExpectation_); ok {
		return x.TableConditionExpectation
	}
	return nil
}

func (x *DataQualityRule) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *DataQualityRule) GetIgnoreNull() bool {
	if x != nil {
		return x.IgnoreNull
	}
	return false
}

func (x *DataQualityRule) GetDimension() string {
	if x != nil {
		return x.Dimension
	}
	return ""
}

func (x *DataQualityRule) GetThreshold() float64 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

type isDataQualityRule_RuleType interface {
	isDataQualityRule_RuleType()
}

type DataQualityRule_RangeExpectation_ struct {
	// ColumnMap rule which evaluates whether each column value lies between a
	// specified range.
	RangeExpectation *DataQualityRule_RangeExpectation `protobuf:"bytes,1,opt,name=range_expectation,json=rangeExpectation,proto3,oneof"`
}

type DataQualityRule_NonNullExpectation_ struct {
	// ColumnMap rule which evaluates whether each column value is null.
	NonNullExpectation *DataQualityRule_NonNullExpectation `protobuf:"bytes,2,opt,name=non_null_expectation,json=nonNullExpectation,proto3,oneof"`
}

type DataQualityRule_SetExpectation_ struct {
	// ColumnMap rule which evaluates whether each column value is contained by
	// a specified set.
	SetExpectation *DataQualityRule_SetExpectation `protobuf:"bytes,3,opt,name=set_expectation,json=setExpectation,proto3,oneof"`
}

type DataQualityRule_RegexExpectation_ struct {
	// ColumnMap rule which evaluates whether each column value matches a
	// specified regex.
	RegexExpectation *DataQualityRule_RegexExpectation `protobuf:"bytes,4,opt,name=regex_expectation,json=regexExpectation,proto3,oneof"`
}

type DataQualityRule_UniquenessExpectation_ struct {
	// ColumnAggregate rule which evaluates whether the column has duplicates.
	UniquenessExpectation *DataQualityRule_UniquenessExpectation `protobuf:"bytes,100,opt,name=uniqueness_expectation,json=uniquenessExpectation,proto3,oneof"`
}

type DataQualityRule_StatisticRangeExpectation_ struct {
	// ColumnAggregate rule which evaluates whether the column aggregate
	// statistic lies between a specified range.
	StatisticRangeExpectation *DataQualityRule_StatisticRangeExpectation `protobuf:"bytes,101,opt,name=statistic_range_expectation,json=statisticRangeExpectation,proto3,oneof"`
}

type DataQualityRule_RowConditionExpectation_ struct {
	// Table rule which evaluates whether each row passes the specified
	// condition.
	RowConditionExpectation *DataQualityRule_RowConditionExpectation `protobuf:"bytes,200,opt,name=row_condition_expectation,json=rowConditionExpectation,proto3,oneof"`
}

type DataQualityRule_TableConditionExpectation_ struct {
	// Table rule which evaluates whether the provided expression is true.
	TableConditionExpectation *DataQualityRule_TableConditionExpectation `protobuf:"bytes,201,opt,name=table_condition_expectation,json=tableConditionExpectation,proto3,oneof"`
}

func (*DataQualityRule_RangeExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_NonNullExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_SetExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_RegexExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_UniquenessExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_StatisticRangeExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_RowConditionExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_TableConditionExpectation_) isDataQualityRule_RuleType() {}

// Evaluates whether each column value lies between a specified range.
type DataQualityRule_RangeExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The minimum column value allowed for a row to pass this
	// validation. At least one of `min_value` and `max_value` need to be
	// provided.
	MinValue string `protobuf:"bytes,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Optional. The maximum column value allowed for a row to pass this
	// validation. At least one of `min_value` and `max_value` need to be
	// provided.
	MaxValue string `protobuf:"bytes,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Optional. Whether each value needs to be strictly greater than ('>') the
	// minimum, or if equality is allowed.
	//
	// Only relevant if a `min_value` has been defined. Default = false.
	StrictMinEnabled bool `protobuf:"varint,3,opt,name=strict_min_enabled,json=strictMinEnabled,proto3" json:"strict_min_enabled,omitempty"`
	// Optional. Whether each value needs to be strictly lesser than ('<') the
	// maximum, or if equality is allowed.
	//
	// Only relevant if a `max_value` has been defined. Default = false.
	StrictMaxEnabled bool `protobuf:"varint,4,opt,name=strict_max_enabled,json=strictMaxEnabled,proto3" json:"strict_max_enabled,omitempty"`
}

func (x *DataQualityRule_RangeExpectation) Reset() {
	*x = DataQualityRule_RangeExpectation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule_RangeExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_RangeExpectation) ProtoMessage() {}

func (x *DataQualityRule_RangeExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_RangeExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_RangeExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 0}
}

func (x *DataQualityRule_RangeExpectation) GetMinValue() string {
	if x != nil {
		return x.MinValue
	}
	return ""
}

func (x *DataQualityRule_RangeExpectation) GetMaxValue() string {
	if x != nil {
		return x.MaxValue
	}
	return ""
}

func (x *DataQualityRule_RangeExpectation) GetStrictMinEnabled() bool {
	if x != nil {
		return x.StrictMinEnabled
	}
	return false
}

func (x *DataQualityRule_RangeExpectation) GetStrictMaxEnabled() bool {
	if x != nil {
		return x.StrictMaxEnabled
	}
	return false
}

// Evaluates whether each column value is null.
type DataQualityRule_NonNullExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataQualityRule_NonNullExpectation) Reset() {
	*x = DataQualityRule_NonNullExpectation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule_NonNullExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_NonNullExpectation) ProtoMessage() {}

func (x *DataQualityRule_NonNullExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_NonNullExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_NonNullExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 1}
}

// Evaluates whether each column value is contained by a specified set.
type DataQualityRule_SetExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Expected values for the column value.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *DataQualityRule_SetExpectation) Reset() {
	*x = DataQualityRule_SetExpectation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule_SetExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_SetExpectation) ProtoMessage() {}

func (x *DataQualityRule_SetExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_SetExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_SetExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 2}
}

func (x *DataQualityRule_SetExpectation) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Evaluates whether each column value matches a specified regex.
type DataQualityRule_RegexExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A regular expression the column value is expected to match.
	Regex string `protobuf:"bytes,1,opt,name=regex,proto3" json:"regex,omitempty"`
}

func (x *DataQualityRule_RegexExpectation) Reset() {
	*x = DataQualityRule_RegexExpectation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule_RegexExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_RegexExpectation) ProtoMessage() {}

func (x *DataQualityRule_RegexExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_RegexExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_RegexExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 3}
}

func (x *DataQualityRule_RegexExpectation) GetRegex() string {
	if x != nil {
		return x.Regex
	}
	return ""
}

// Evaluates whether the column has duplicates.
type DataQualityRule_UniquenessExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataQualityRule_UniquenessExpectation) Reset() {
	*x = DataQualityRule_UniquenessExpectation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule_UniquenessExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_UniquenessExpectation) ProtoMessage() {}

func (x *DataQualityRule_UniquenessExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_UniquenessExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_UniquenessExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 4}
}

// Evaluates whether the column aggregate statistic lies between a specified
// range.
type DataQualityRule_StatisticRangeExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The aggregate metric to evaluate.
	Statistic DataQualityRule_StatisticRangeExpectation_ColumnStatistic `protobuf:"varint,1,opt,name=statistic,proto3,enum=google.cloud.dataplex.v1.DataQualityRule_StatisticRangeExpectation_ColumnStatistic" json:"statistic,omitempty"`
	// The minimum column statistic value allowed for a row to pass this
	// validation.
	//
	// At least one of `min_value` and `max_value` need to be provided.
	MinValue string `protobuf:"bytes,2,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// The maximum column statistic value allowed for a row to pass this
	// validation.
	//
	// At least one of `min_value` and `max_value` need to be provided.
	MaxValue string `protobuf:"bytes,3,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Whether column statistic needs to be strictly greater than ('>')
	// the minimum, or if equality is allowed.
	//
	// Only relevant if a `min_value` has been defined. Default = false.
	StrictMinEnabled bool `protobuf:"varint,4,opt,name=strict_min_enabled,json=strictMinEnabled,proto3" json:"strict_min_enabled,omitempty"`
	// Whether column statistic needs to be strictly lesser than ('<') the
	// maximum, or if equality is allowed.
	//
	// Only relevant if a `max_value` has been defined. Default = false.
	StrictMaxEnabled bool `protobuf:"varint,5,opt,name=strict_max_enabled,json=strictMaxEnabled,proto3" json:"strict_max_enabled,omitempty"`
}

func (x *DataQualityRule_StatisticRangeExpectation) Reset() {
	*x = DataQualityRule_StatisticRangeExpectation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule_StatisticRangeExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_StatisticRangeExpectation) ProtoMessage() {}

func (x *DataQualityRule_StatisticRangeExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_StatisticRangeExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_StatisticRangeExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 5}
}

func (x *DataQualityRule_StatisticRangeExpectation) GetStatistic() DataQualityRule_StatisticRangeExpectation_ColumnStatistic {
	if x != nil {
		return x.Statistic
	}
	return DataQualityRule_StatisticRangeExpectation_STATISTIC_UNDEFINED
}

func (x *DataQualityRule_StatisticRangeExpectation) GetMinValue() string {
	if x != nil {
		return x.MinValue
	}
	return ""
}

func (x *DataQualityRule_StatisticRangeExpectation) GetMaxValue() string {
	if x != nil {
		return x.MaxValue
	}
	return ""
}

func (x *DataQualityRule_StatisticRangeExpectation) GetStrictMinEnabled() bool {
	if x != nil {
		return x.StrictMinEnabled
	}
	return false
}

func (x *DataQualityRule_StatisticRangeExpectation) GetStrictMaxEnabled() bool {
	if x != nil {
		return x.StrictMaxEnabled
	}
	return false
}

// Evaluates whether each row passes the specified condition.
//
// The SQL expression needs to use BigQuery standard SQL syntax and should
// produce a boolean value per row as the result.
//
// Example: col1 >= 0 AND col2 < 10
type DataQualityRule_RowConditionExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL expression.
	SqlExpression string `protobuf:"bytes,1,opt,name=sql_expression,json=sqlExpression,proto3" json:"sql_expression,omitempty"`
}

func (x *DataQualityRule_RowConditionExpectation) Reset() {
	*x = DataQualityRule_RowConditionExpectation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule_RowConditionExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_RowConditionExpectation) ProtoMessage() {}

func (x *DataQualityRule_RowConditionExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_RowConditionExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_RowConditionExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 6}
}

func (x *DataQualityRule_RowConditionExpectation) GetSqlExpression() string {
	if x != nil {
		return x.SqlExpression
	}
	return ""
}

// Evaluates whether the provided expression is true.
//
// The SQL expression needs to use BigQuery standard SQL syntax and should
// produce a scalar boolean result.
//
// Example: MIN(col1) >= 0
type DataQualityRule_TableConditionExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL expression.
	SqlExpression string `protobuf:"bytes,1,opt,name=sql_expression,json=sqlExpression,proto3" json:"sql_expression,omitempty"`
}

func (x *DataQualityRule_TableConditionExpectation) Reset() {
	*x = DataQualityRule_TableConditionExpectation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataQualityRule_TableConditionExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_TableConditionExpectation) ProtoMessage() {}

func (x *DataQualityRule_TableConditionExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_TableConditionExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_TableConditionExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4, 7}
}

func (x *DataQualityRule_TableConditionExpectation) GetSqlExpression() string {
	if x != nil {
		return x.SqlExpression
	}
	return ""
}

var File_google_cloud_dataplex_v1_data_quality_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_data_quality_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x52, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3f, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xaf, 0x02, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x70,
	0x61, 0x73, 0x73, 0x65, 0x64, 0x12, 0x54, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x0a, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x05, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x48, 0x0a, 0x0c, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x73, 0x63,
	0x61, 0x6e, 0x6e, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x22, 0xa6, 0x02, 0x0a, 0x15, 0x44, 0x61,
	0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x75,
	0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0e, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x73, 0x73, 0x65,
	0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6e, 0x75, 0x6c, 0x6c,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x70, 0x61, 0x73, 0x73, 0x52,
	0x61, 0x74, 0x69, 0x6f, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x61, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x72, 0x6f, 0x77, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x77, 0x73, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x22, 0x34, 0x0a, 0x1a, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x22, 0x9d, 0x0f, 0x0a, 0x0f, 0x44, 0x61, 0x74,
	0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x69, 0x0a, 0x11,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75,
	0x6c, 0x65, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x14, 0x6e, 0x6f, 0x6e, 0x5f, 0x6e,
	0x75, 0x6c, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65,
	0x2e, 0x4e, 0x6f, 0x6e, 0x4e, 0x75, 0x6c, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x12, 0x6e, 0x6f, 0x6e, 0x4e, 0x75, 0x6c, 0x6c, 0x45, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x0f, 0x73, 0x65, 0x74,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x65,
	0x74, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e,
	0x73, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69,
	0x0a, 0x11, 0x72, 0x65, 0x67, 0x65, 0x78, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x65, 0x67, 0x65, 0x78, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x72, 0x65, 0x67, 0x65, 0x78, 0x45, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x16, 0x75, 0x6e, 0x69,
	0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x2e, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x45,
	0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x15, 0x75, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x85, 0x01, 0x0a, 0x1b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x19, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x19,
	0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x6f, 0x77, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x86,
	0x01, 0x0a, 0x1b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xc9,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x19, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x18, 0xf4, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f,
	0x6e, 0x75, 0x6c, 0x6c, 0x18, 0xf5, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x4e, 0x75, 0x6c, 0x6c, 0x12, 0x22, 0x0a, 0x09,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0xf6, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0xf7, 0x03,
	0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x1a, 0xbc, 0x01, 0x0a, 0x10, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6e,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x6d,
	0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x31, 0x0a,
	0x12, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x4d, 0x69, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x31, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x4d, 0x61, 0x78, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x1a, 0x14, 0x0a, 0x12, 0x4e, 0x6f, 0x6e, 0x4e, 0x75, 0x6c, 0x6c, 0x45, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x28, 0x0a, 0x0e, 0x53, 0x65, 0x74,
	0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x1a, 0x28, 0x0a, 0x10, 0x52, 0x65, 0x67, 0x65, 0x78, 0x45, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x1a, 0x17, 0x0a,
	0x15, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x45, 0x78, 0x70, 0x65, 0x63,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xec, 0x02, 0x0a, 0x19, 0x53, 0x74, 0x61, 0x74, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x71, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75,
	0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x4d, 0x69, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x2c, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x4d, 0x61, 0x78, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x46, 0x0a,
	0x0f, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41, 0x54, 0x49, 0x53, 0x54, 0x49, 0x43, 0x5f, 0x55, 0x4e,
	0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x45, 0x41,
	0x4e, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03,
	0x4d, 0x41, 0x58, 0x10, 0x03, 0x1a, 0x40, 0x0a, 0x17, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x71, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x42, 0x0a, 0x19, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x71, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x71,
	0x6c, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x0a, 0x09, 0x72,
	0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x6c, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_data_quality_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_data_quality_proto_rawDescData = file_google_cloud_dataplex_v1_data_quality_proto_rawDesc
)

func file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_data_quality_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_data_quality_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_data_quality_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescData
}

var file_google_cloud_dataplex_v1_data_quality_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_dataplex_v1_data_quality_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_dataplex_v1_data_quality_proto_goTypes = []interface{}{
	(DataQualityRule_StatisticRangeExpectation_ColumnStatistic)(0), // 0: google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation.ColumnStatistic
	(*DataQualitySpec)(nil),                           // 1: google.cloud.dataplex.v1.DataQualitySpec
	(*DataQualityResult)(nil),                         // 2: google.cloud.dataplex.v1.DataQualityResult
	(*DataQualityRuleResult)(nil),                     // 3: google.cloud.dataplex.v1.DataQualityRuleResult
	(*DataQualityDimensionResult)(nil),                // 4: google.cloud.dataplex.v1.DataQualityDimensionResult
	(*DataQualityRule)(nil),                           // 5: google.cloud.dataplex.v1.DataQualityRule
	(*DataQualityRule_RangeExpectation)(nil),          // 6: google.cloud.dataplex.v1.DataQualityRule.RangeExpectation
	(*DataQualityRule_NonNullExpectation)(nil),        // 7: google.cloud.dataplex.v1.DataQualityRule.NonNullExpectation
	(*DataQualityRule_SetExpectation)(nil),            // 8: google.cloud.dataplex.v1.DataQualityRule.SetExpectation
	(*DataQualityRule_RegexExpectation)(nil),          // 9: google.cloud.dataplex.v1.DataQualityRule.RegexExpectation
	(*DataQualityRule_UniquenessExpectation)(nil),     // 10: google.cloud.dataplex.v1.DataQualityRule.UniquenessExpectation
	(*DataQualityRule_StatisticRangeExpectation)(nil), // 11: google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation
	(*DataQualityRule_RowConditionExpectation)(nil),   // 12: google.cloud.dataplex.v1.DataQualityRule.RowConditionExpectation
	(*DataQualityRule_TableConditionExpectation)(nil), // 13: google.cloud.dataplex.v1.DataQualityRule.TableConditionExpectation
	(*ScannedData)(nil),                               // 14: google.cloud.dataplex.v1.ScannedData
}
var file_google_cloud_dataplex_v1_data_quality_proto_depIdxs = []int32{
	5,  // 0: google.cloud.dataplex.v1.DataQualitySpec.rules:type_name -> google.cloud.dataplex.v1.DataQualityRule
	4,  // 1: google.cloud.dataplex.v1.DataQualityResult.dimensions:type_name -> google.cloud.dataplex.v1.DataQualityDimensionResult
	3,  // 2: google.cloud.dataplex.v1.DataQualityResult.rules:type_name -> google.cloud.dataplex.v1.DataQualityRuleResult
	14, // 3: google.cloud.dataplex.v1.DataQualityResult.scanned_data:type_name -> google.cloud.dataplex.v1.ScannedData
	5,  // 4: google.cloud.dataplex.v1.DataQualityRuleResult.rule:type_name -> google.cloud.dataplex.v1.DataQualityRule
	6,  // 5: google.cloud.dataplex.v1.DataQualityRule.range_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.RangeExpectation
	7,  // 6: google.cloud.dataplex.v1.DataQualityRule.non_null_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.NonNullExpectation
	8,  // 7: google.cloud.dataplex.v1.DataQualityRule.set_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.SetExpectation
	9,  // 8: google.cloud.dataplex.v1.DataQualityRule.regex_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.RegexExpectation
	10, // 9: google.cloud.dataplex.v1.DataQualityRule.uniqueness_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.UniquenessExpectation
	11, // 10: google.cloud.dataplex.v1.DataQualityRule.statistic_range_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation
	12, // 11: google.cloud.dataplex.v1.DataQualityRule.row_condition_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.RowConditionExpectation
	13, // 12: google.cloud.dataplex.v1.DataQualityRule.table_condition_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.TableConditionExpectation
	0,  // 13: google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation.statistic:type_name -> google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation.ColumnStatistic
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_data_quality_proto_init() }
func file_google_cloud_dataplex_v1_data_quality_proto_init() {
	if File_google_cloud_dataplex_v1_data_quality_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_processing_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualitySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRuleResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityDimensionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule_RangeExpectation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule_NonNullExpectation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule_SetExpectation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule_RegexExpectation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule_UniquenessExpectation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule_StatisticRangeExpectation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule_RowConditionExpectation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataQualityRule_TableConditionExpectation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*DataQualityRule_RangeExpectation_)(nil),
		(*DataQualityRule_NonNullExpectation_)(nil),
		(*DataQualityRule_SetExpectation_)(nil),
		(*DataQualityRule_RegexExpectation_)(nil),
		(*DataQualityRule_UniquenessExpectation_)(nil),
		(*DataQualityRule_StatisticRangeExpectation_)(nil),
		(*DataQualityRule_RowConditionExpectation_)(nil),
		(*DataQualityRule_TableConditionExpectation_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_data_quality_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_data_quality_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_data_quality_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_data_quality_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_data_quality_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_data_quality_proto = out.File
	file_google_cloud_dataplex_v1_data_quality_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_data_quality_proto_goTypes = nil
	file_google_cloud_dataplex_v1_data_quality_proto_depIdxs = nil
}
