// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/confidentialcomputing/v1alpha1/service.proto

package confidentialcomputingpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A Challenge from the server used to guarantee freshness of attestations
type Challenge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this Challenge in the format
	// `projects/*/locations/*/challenges/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which this Challenge was created
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this Challenge will no longer be usable. It
	// is also the expiration time for any tokens generated from this Challenge.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. Indicates if this challenge has been used to generate a token.
	Used bool `protobuf:"varint,4,opt,name=used,proto3" json:"used,omitempty"`
	// Output only. Random data which should be used when calling TPM2_Quote.
	// --
	Nonce []byte `protobuf:"bytes,5,opt,name=nonce,proto3" json:"nonce,omitempty"`
}

func (x *Challenge) Reset() {
	*x = Challenge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Challenge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Challenge) ProtoMessage() {}

func (x *Challenge) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Challenge.ProtoReflect.Descriptor instead.
func (*Challenge) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescGZIP(), []int{0}
}

func (x *Challenge) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Challenge) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Challenge) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Challenge) GetUsed() bool {
	if x != nil {
		return x.Used
	}
	return false
}

func (x *Challenge) GetNonce() []byte {
	if x != nil {
		return x.Nonce
	}
	return nil
}

// Message for creating a Challenge
type CreateChallengeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location where the Challenge will be
	// used, in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Challenge to be created. Currently this field can be empty as
	// all the Challenge fields are set by the server.
	Challenge *Challenge `protobuf:"bytes,2,opt,name=challenge,proto3" json:"challenge,omitempty"`
}

func (x *CreateChallengeRequest) Reset() {
	*x = CreateChallengeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChallengeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChallengeRequest) ProtoMessage() {}

func (x *CreateChallengeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChallengeRequest.ProtoReflect.Descriptor instead.
func (*CreateChallengeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateChallengeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateChallengeRequest) GetChallenge() *Challenge {
	if x != nil {
		return x.Challenge
	}
	return nil
}

// A request for an OIDC token, providing all the necessary information needed
// for this service to verify the plaform state of the requestor.
type VerifyAttestationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Challenge whose nonce was used to generate the
	// attestation, in the format `projects/*/locations/*/challenges/*`. The
	// provided Challenge will be consumed, and cannot be used again.
	Challenge string `protobuf:"bytes,1,opt,name=challenge,proto3" json:"challenge,omitempty"`
	// Optional. Credentials used to populate the "emails" claim in the
	// claims_token.
	GcpCredentials *GcpCredentials `protobuf:"bytes,2,opt,name=gcp_credentials,json=gcpCredentials,proto3" json:"gcp_credentials,omitempty"`
	// Required. The TPM-specific data provided by the attesting platform, used to
	// populate any of the claims regarding platform state.
	TpmAttestation *TpmAttestation `protobuf:"bytes,3,opt,name=tpm_attestation,json=tpmAttestation,proto3" json:"tpm_attestation,omitempty"`
}

func (x *VerifyAttestationRequest) Reset() {
	*x = VerifyAttestationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyAttestationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyAttestationRequest) ProtoMessage() {}

func (x *VerifyAttestationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyAttestationRequest.ProtoReflect.Descriptor instead.
func (*VerifyAttestationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescGZIP(), []int{2}
}

func (x *VerifyAttestationRequest) GetChallenge() string {
	if x != nil {
		return x.Challenge
	}
	return ""
}

func (x *VerifyAttestationRequest) GetGcpCredentials() *GcpCredentials {
	if x != nil {
		return x.GcpCredentials
	}
	return nil
}

func (x *VerifyAttestationRequest) GetTpmAttestation() *TpmAttestation {
	if x != nil {
		return x.TpmAttestation
	}
	return nil
}

// A response once an attestation has been successfully verified, containing a
// signed OIDC token.
type VerifyAttestationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The OIDC token issued by this service. It contains specific
	// platform claims based on the contents of the provided attestation.
	// --
	ClaimsToken []byte `protobuf:"bytes,1,opt,name=claims_token,json=claimsToken,proto3" json:"claims_token,omitempty"`
}

func (x *VerifyAttestationResponse) Reset() {
	*x = VerifyAttestationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyAttestationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyAttestationResponse) ProtoMessage() {}

func (x *VerifyAttestationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyAttestationResponse.ProtoReflect.Descriptor instead.
func (*VerifyAttestationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescGZIP(), []int{3}
}

func (x *VerifyAttestationResponse) GetClaimsToken() []byte {
	if x != nil {
		return x.ClaimsToken
	}
	return nil
}

// Credentials issued by GCP which are linked to the platform attestation. These
// will be verified server-side as part of attestaion verification.
type GcpCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of service account OpenID Connect ID tokens identifying which
	// service account identities should be included in the claims_token. These
	// can be generated by calling `serviceAccounts.generateIdToken`. The
	// Challenge.name must be used as the `audience` parameter, and the
	// `includeEmail` parameter must be `true`.
	// --
	IdTokens [][]byte `protobuf:"bytes,1,rep,name=id_tokens,json=idTokens,proto3" json:"id_tokens,omitempty"`
}

func (x *GcpCredentials) Reset() {
	*x = GcpCredentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcpCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcpCredentials) ProtoMessage() {}

func (x *GcpCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcpCredentials.ProtoReflect.Descriptor instead.
func (*GcpCredentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescGZIP(), []int{4}
}

func (x *GcpCredentials) GetIdTokens() [][]byte {
	if x != nil {
		return x.IdTokens
	}
	return nil
}

// TPM2 data containing everything necessary to validate any platform state
// measured into the TPM.
type TpmAttestation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TPM2 PCR Quotes generated by calling TPM2_Quote on each PCR bank.
	Quotes []*TpmAttestation_Quote `protobuf:"bytes,1,rep,name=quotes,proto3" json:"quotes,omitempty"`
	// The binary TCG Event Log containing events measured into the TPM by the
	// platform firmware and operating system. Formatted as described in the
	// "TCG PC Client Platform Firmware Profile Specification".
	TcgEventLog []byte `protobuf:"bytes,2,opt,name=tcg_event_log,json=tcgEventLog,proto3" json:"tcg_event_log,omitempty"`
	// An Event Log containing additional events measured into the TPM that are
	// not already present in the tcg_event_log. Formatted as described in the
	// "Canonical Event Log Format" TCG Specification.
	CanonicalEventLog []byte `protobuf:"bytes,3,opt,name=canonical_event_log,json=canonicalEventLog,proto3" json:"canonical_event_log,omitempty"`
	// DER-encoded X.509 certificate of the Attestation Key (otherwise known as
	// an AK or a TPM restricted signing key) used to generate the quotes.
	AkCert []byte `protobuf:"bytes,4,opt,name=ak_cert,json=akCert,proto3" json:"ak_cert,omitempty"`
	// List of DER-encoded X.509 certificates which, together with the ak_cert,
	// chain back to a trusted Root Certificate.
	CertChain [][]byte `protobuf:"bytes,5,rep,name=cert_chain,json=certChain,proto3" json:"cert_chain,omitempty"`
}

func (x *TpmAttestation) Reset() {
	*x = TpmAttestation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TpmAttestation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TpmAttestation) ProtoMessage() {}

func (x *TpmAttestation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TpmAttestation.ProtoReflect.Descriptor instead.
func (*TpmAttestation) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescGZIP(), []int{5}
}

func (x *TpmAttestation) GetQuotes() []*TpmAttestation_Quote {
	if x != nil {
		return x.Quotes
	}
	return nil
}

func (x *TpmAttestation) GetTcgEventLog() []byte {
	if x != nil {
		return x.TcgEventLog
	}
	return nil
}

func (x *TpmAttestation) GetCanonicalEventLog() []byte {
	if x != nil {
		return x.CanonicalEventLog
	}
	return nil
}

func (x *TpmAttestation) GetAkCert() []byte {
	if x != nil {
		return x.AkCert
	}
	return nil
}

func (x *TpmAttestation) GetCertChain() [][]byte {
	if x != nil {
		return x.CertChain
	}
	return nil
}

// Information about Platform Control Registers (PCRs) including a signature
// over their values, which can be used for remote validation.
type TpmAttestation_Quote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hash algorithm of the PCR bank being quoted, encoded as a TPM_ALG_ID
	HashAlgo int32 `protobuf:"varint,1,opt,name=hash_algo,json=hashAlgo,proto3" json:"hash_algo,omitempty"`
	// Raw binary values of each PCRs being quoted.
	PcrValues map[int32][]byte `protobuf:"bytes,2,rep,name=pcr_values,json=pcrValues,proto3" json:"pcr_values,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// TPM2 quote, encoded as a TPMS_ATTEST
	RawQuote []byte `protobuf:"bytes,3,opt,name=raw_quote,json=rawQuote,proto3" json:"raw_quote,omitempty"`
	// TPM2 signature, encoded as a TPMT_SIGNATURE
	RawSignature []byte `protobuf:"bytes,4,opt,name=raw_signature,json=rawSignature,proto3" json:"raw_signature,omitempty"`
}

func (x *TpmAttestation_Quote) Reset() {
	*x = TpmAttestation_Quote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TpmAttestation_Quote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TpmAttestation_Quote) ProtoMessage() {}

func (x *TpmAttestation_Quote) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TpmAttestation_Quote.ProtoReflect.Descriptor instead.
func (*TpmAttestation_Quote) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *TpmAttestation_Quote) GetHashAlgo() int32 {
	if x != nil {
		return x.HashAlgo
	}
	return 0
}

func (x *TpmAttestation_Quote) GetPcrValues() map[int32][]byte {
	if x != nil {
		return x.PcrValues
	}
	return nil
}

func (x *TpmAttestation_Quote) GetRawQuote() []byte {
	if x != nil {
		return x.RawQuote
	}
	return nil
}

func (x *TpmAttestation_Quote) GetRawSignature() []byte {
	if x != nil {
		return x.RawSignature
	}
	return nil
}

var File_google_cloud_confidentialcomputing_v1alpha1_service_proto protoreflect.FileDescriptor

var file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcc, 0x02, 0x0a,
	0x09, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x75, 0x73, 0x65, 0x64,
	0x12, 0x19, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x3a, 0x6e, 0xea, 0x41, 0x6b,
	0x0a, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65,
	0x12, 0x39, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65,
	0x6e, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x75, 0x75, 0x69, 0x64, 0x7d, 0x22, 0xb6, 0x01, 0x0a, 0x16,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x09, 0x63, 0x68, 0x61,
	0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x22, 0xc6, 0x02, 0x0a, 0x18, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x41,
	0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x54, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x63, 0x68,
	0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12, 0x69, 0x0a, 0x0f, 0x67, 0x63, 0x70, 0x5f, 0x63,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x63, 0x70, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x67, 0x63, 0x70, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x73, 0x12, 0x69, 0x0a, 0x0f, 0x74, 0x70, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x70, 0x6d, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74,
	0x70, 0x6d, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x43, 0x0a,
	0x19, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c,
	0x61, 0x69, 0x6d, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x2d, 0x0a, 0x0e, 0x47, 0x63, 0x70, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x08, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x22, 0x8f, 0x04, 0x0a, 0x0e, 0x54, 0x70, 0x6d, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x06, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x54, 0x70, 0x6d, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x52, 0x06, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x73, 0x12,
	0x22, 0x0a, 0x0d, 0x74, 0x63, 0x67, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x74, 0x63, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x4c, 0x6f, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x11, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x4c, 0x6f, 0x67, 0x12, 0x17, 0x0a, 0x07, 0x61, 0x6b, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x61, 0x6b, 0x43, 0x65, 0x72, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x63, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0c,
	0x52, 0x09, 0x63, 0x65, 0x72, 0x74, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x1a, 0x95, 0x02, 0x0a, 0x05,
	0x51, 0x75, 0x6f, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x61, 0x6c,
	0x67, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x68, 0x61, 0x73, 0x68, 0x41, 0x6c,
	0x67, 0x6f, 0x12, 0x6f, 0x0a, 0x0a, 0x70, 0x63, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x70, 0x6d, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x2e, 0x50, 0x63, 0x72, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x70, 0x63, 0x72, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x61, 0x77, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x72, 0x61, 0x77, 0x51, 0x75, 0x6f, 0x74, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x61, 0x77, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x72, 0x61, 0x77, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x1a, 0x3c, 0x0a, 0x0e, 0x50, 0x63, 0x72, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x32, 0xdb, 0x04, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x12, 0xea, 0x01,
	0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
	0x65, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x22, 0x5a,
	0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65,
	0x6e, 0x67, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x73, 0x12, 0xfa, 0x01, 0x0a, 0x11, 0x56,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x01, 0x2a, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x58, 0xca, 0x41, 0x24, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xb5, 0x02, 0x0a, 0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x65, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x70, 0x62, 0x3b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x2b, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5c,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xea, 0x02, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x3a,
	0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescOnce sync.Once
	file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescData = file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDesc
)

func file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescData)
	})
	return file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDescData
}

var file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_confidentialcomputing_v1alpha1_service_proto_goTypes = []interface{}{
	(*Challenge)(nil),                 // 0: google.cloud.confidentialcomputing.v1alpha1.Challenge
	(*CreateChallengeRequest)(nil),    // 1: google.cloud.confidentialcomputing.v1alpha1.CreateChallengeRequest
	(*VerifyAttestationRequest)(nil),  // 2: google.cloud.confidentialcomputing.v1alpha1.VerifyAttestationRequest
	(*VerifyAttestationResponse)(nil), // 3: google.cloud.confidentialcomputing.v1alpha1.VerifyAttestationResponse
	(*GcpCredentials)(nil),            // 4: google.cloud.confidentialcomputing.v1alpha1.GcpCredentials
	(*TpmAttestation)(nil),            // 5: google.cloud.confidentialcomputing.v1alpha1.TpmAttestation
	(*TpmAttestation_Quote)(nil),      // 6: google.cloud.confidentialcomputing.v1alpha1.TpmAttestation.Quote
	nil,                               // 7: google.cloud.confidentialcomputing.v1alpha1.TpmAttestation.Quote.PcrValuesEntry
	(*timestamppb.Timestamp)(nil),     // 8: google.protobuf.Timestamp
}
var file_google_cloud_confidentialcomputing_v1alpha1_service_proto_depIdxs = []int32{
	8, // 0: google.cloud.confidentialcomputing.v1alpha1.Challenge.create_time:type_name -> google.protobuf.Timestamp
	8, // 1: google.cloud.confidentialcomputing.v1alpha1.Challenge.expire_time:type_name -> google.protobuf.Timestamp
	0, // 2: google.cloud.confidentialcomputing.v1alpha1.CreateChallengeRequest.challenge:type_name -> google.cloud.confidentialcomputing.v1alpha1.Challenge
	4, // 3: google.cloud.confidentialcomputing.v1alpha1.VerifyAttestationRequest.gcp_credentials:type_name -> google.cloud.confidentialcomputing.v1alpha1.GcpCredentials
	5, // 4: google.cloud.confidentialcomputing.v1alpha1.VerifyAttestationRequest.tpm_attestation:type_name -> google.cloud.confidentialcomputing.v1alpha1.TpmAttestation
	6, // 5: google.cloud.confidentialcomputing.v1alpha1.TpmAttestation.quotes:type_name -> google.cloud.confidentialcomputing.v1alpha1.TpmAttestation.Quote
	7, // 6: google.cloud.confidentialcomputing.v1alpha1.TpmAttestation.Quote.pcr_values:type_name -> google.cloud.confidentialcomputing.v1alpha1.TpmAttestation.Quote.PcrValuesEntry
	1, // 7: google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing.CreateChallenge:input_type -> google.cloud.confidentialcomputing.v1alpha1.CreateChallengeRequest
	2, // 8: google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing.VerifyAttestation:input_type -> google.cloud.confidentialcomputing.v1alpha1.VerifyAttestationRequest
	0, // 9: google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing.CreateChallenge:output_type -> google.cloud.confidentialcomputing.v1alpha1.Challenge
	3, // 10: google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing.VerifyAttestation:output_type -> google.cloud.confidentialcomputing.v1alpha1.VerifyAttestationResponse
	9, // [9:11] is the sub-list for method output_type
	7, // [7:9] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_confidentialcomputing_v1alpha1_service_proto_init() }
func file_google_cloud_confidentialcomputing_v1alpha1_service_proto_init() {
	if File_google_cloud_confidentialcomputing_v1alpha1_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Challenge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChallengeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyAttestationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyAttestationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcpCredentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TpmAttestation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TpmAttestation_Quote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_confidentialcomputing_v1alpha1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_confidentialcomputing_v1alpha1_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_confidentialcomputing_v1alpha1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_confidentialcomputing_v1alpha1_service_proto = out.File
	file_google_cloud_confidentialcomputing_v1alpha1_service_proto_rawDesc = nil
	file_google_cloud_confidentialcomputing_v1alpha1_service_proto_goTypes = nil
	file_google_cloud_confidentialcomputing_v1alpha1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConfidentialComputingClient is the client API for ConfidentialComputing service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConfidentialComputingClient interface {
	// Creates a new Challenge in a given project and location.
	CreateChallenge(ctx context.Context, in *CreateChallengeRequest, opts ...grpc.CallOption) (*Challenge, error)
	// Verifies the provided attestation info, returning a signed OIDC token.
	VerifyAttestation(ctx context.Context, in *VerifyAttestationRequest, opts ...grpc.CallOption) (*VerifyAttestationResponse, error)
}

type confidentialComputingClient struct {
	cc grpc.ClientConnInterface
}

func NewConfidentialComputingClient(cc grpc.ClientConnInterface) ConfidentialComputingClient {
	return &confidentialComputingClient{cc}
}

func (c *confidentialComputingClient) CreateChallenge(ctx context.Context, in *CreateChallengeRequest, opts ...grpc.CallOption) (*Challenge, error) {
	out := new(Challenge)
	err := c.cc.Invoke(ctx, "/google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing/CreateChallenge", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *confidentialComputingClient) VerifyAttestation(ctx context.Context, in *VerifyAttestationRequest, opts ...grpc.CallOption) (*VerifyAttestationResponse, error) {
	out := new(VerifyAttestationResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing/VerifyAttestation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConfidentialComputingServer is the server API for ConfidentialComputing service.
type ConfidentialComputingServer interface {
	// Creates a new Challenge in a given project and location.
	CreateChallenge(context.Context, *CreateChallengeRequest) (*Challenge, error)
	// Verifies the provided attestation info, returning a signed OIDC token.
	VerifyAttestation(context.Context, *VerifyAttestationRequest) (*VerifyAttestationResponse, error)
}

// UnimplementedConfidentialComputingServer can be embedded to have forward compatible implementations.
type UnimplementedConfidentialComputingServer struct {
}

func (*UnimplementedConfidentialComputingServer) CreateChallenge(context.Context, *CreateChallengeRequest) (*Challenge, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChallenge not implemented")
}
func (*UnimplementedConfidentialComputingServer) VerifyAttestation(context.Context, *VerifyAttestationRequest) (*VerifyAttestationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyAttestation not implemented")
}

func RegisterConfidentialComputingServer(s *grpc.Server, srv ConfidentialComputingServer) {
	s.RegisterService(&_ConfidentialComputing_serviceDesc, srv)
}

func _ConfidentialComputing_CreateChallenge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChallengeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfidentialComputingServer).CreateChallenge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing/CreateChallenge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfidentialComputingServer).CreateChallenge(ctx, req.(*CreateChallengeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfidentialComputing_VerifyAttestation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyAttestationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfidentialComputingServer).VerifyAttestation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing/VerifyAttestation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfidentialComputingServer).VerifyAttestation(ctx, req.(*VerifyAttestationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConfidentialComputing_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing",
	HandlerType: (*ConfidentialComputingServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateChallenge",
			Handler:    _ConfidentialComputing_CreateChallenge_Handler,
		},
		{
			MethodName: "VerifyAttestation",
			Handler:    _ConfidentialComputing_VerifyAttestation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/confidentialcomputing/v1alpha1/service.proto",
}
