// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/aiplatform/v1beta1/tensorboard_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [TensorboardService.CreateTensorboard][google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboard].
type CreateTensorboardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the Tensorboard in.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Tensorboard to create.
	Tensorboard *Tensorboard `protobuf:"bytes,2,opt,name=tensorboard,proto3" json:"tensorboard,omitempty"`
}

func (x *CreateTensorboardRequest) Reset() {
	*x = CreateTensorboardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTensorboardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTensorboardRequest) ProtoMessage() {}

func (x *CreateTensorboardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTensorboardRequest.ProtoReflect.Descriptor instead.
func (*CreateTensorboardRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateTensorboardRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTensorboardRequest) GetTensorboard() *Tensorboard {
	if x != nil {
		return x.Tensorboard
	}
	return nil
}

// Request message for
// [TensorboardService.GetTensorboard][google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboard].
type GetTensorboardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Tensorboard resource.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTensorboardRequest) Reset() {
	*x = GetTensorboardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTensorboardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTensorboardRequest) ProtoMessage() {}

func (x *GetTensorboardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTensorboardRequest.ProtoReflect.Descriptor instead.
func (*GetTensorboardRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetTensorboardRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [TensorboardService.GetTensorboardUsage][].
type ReadTensorboardUsageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Tensorboard resource.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Tensorboard string `protobuf:"bytes,1,opt,name=tensorboard,proto3" json:"tensorboard,omitempty"`
}

func (x *ReadTensorboardUsageRequest) Reset() {
	*x = ReadTensorboardUsageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTensorboardUsageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTensorboardUsageRequest) ProtoMessage() {}

func (x *ReadTensorboardUsageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTensorboardUsageRequest.ProtoReflect.Descriptor instead.
func (*ReadTensorboardUsageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{2}
}

func (x *ReadTensorboardUsageRequest) GetTensorboard() string {
	if x != nil {
		return x.Tensorboard
	}
	return ""
}

// Response message for
// [TensorboardService.ReadTensorboardUsage][google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardUsage].
type ReadTensorboardUsageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maps year-month (YYYYMM) string to per month usage data.
	MonthlyUsageData map[string]*ReadTensorboardUsageResponse_PerMonthUsageData `protobuf:"bytes,1,rep,name=monthly_usage_data,json=monthlyUsageData,proto3" json:"monthly_usage_data,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ReadTensorboardUsageResponse) Reset() {
	*x = ReadTensorboardUsageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTensorboardUsageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTensorboardUsageResponse) ProtoMessage() {}

func (x *ReadTensorboardUsageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTensorboardUsageResponse.ProtoReflect.Descriptor instead.
func (*ReadTensorboardUsageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{3}
}

func (x *ReadTensorboardUsageResponse) GetMonthlyUsageData() map[string]*ReadTensorboardUsageResponse_PerMonthUsageData {
	if x != nil {
		return x.MonthlyUsageData
	}
	return nil
}

// Request message for
// [TensorboardService.ListTensorboards][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboards].
type ListTensorboardsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list Tensorboards.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the Tensorboards that match the filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of Tensorboards to return. The service may return
	// fewer than this value. If unspecified, at most 100 Tensorboards are
	// returned. The maximum value is 100; values above 100 are coerced to
	// 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [TensorboardService.ListTensorboards][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboards]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [TensorboardService.ListTensorboards][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboards]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListTensorboardsRequest) Reset() {
	*x = ListTensorboardsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorboardsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorboardsRequest) ProtoMessage() {}

func (x *ListTensorboardsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorboardsRequest.ProtoReflect.Descriptor instead.
func (*ListTensorboardsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListTensorboardsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTensorboardsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTensorboardsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTensorboardsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTensorboardsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListTensorboardsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [TensorboardService.ListTensorboards][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboards].
type ListTensorboardsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Tensorboards mathching the request.
	Tensorboards []*Tensorboard `protobuf:"bytes,1,rep,name=tensorboards,proto3" json:"tensorboards,omitempty"`
	// A token, which can be sent as
	// [ListTensorboardsRequest.page_token][google.cloud.aiplatform.v1beta1.ListTensorboardsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTensorboardsResponse) Reset() {
	*x = ListTensorboardsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorboardsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorboardsResponse) ProtoMessage() {}

func (x *ListTensorboardsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorboardsResponse.ProtoReflect.Descriptor instead.
func (*ListTensorboardsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListTensorboardsResponse) GetTensorboards() []*Tensorboard {
	if x != nil {
		return x.Tensorboards
	}
	return nil
}

func (x *ListTensorboardsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [TensorboardService.UpdateTensorboard][google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboard].
type UpdateTensorboardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Tensorboard resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field is overwritten if it's in the mask. If the
	// user does not provide a mask then all fields are overwritten if new
	// values are specified.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The Tensorboard's `name` field is used to identify the
	// Tensorboard to be updated. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Tensorboard *Tensorboard `protobuf:"bytes,2,opt,name=tensorboard,proto3" json:"tensorboard,omitempty"`
}

func (x *UpdateTensorboardRequest) Reset() {
	*x = UpdateTensorboardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTensorboardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTensorboardRequest) ProtoMessage() {}

func (x *UpdateTensorboardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTensorboardRequest.ProtoReflect.Descriptor instead.
func (*UpdateTensorboardRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateTensorboardRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTensorboardRequest) GetTensorboard() *Tensorboard {
	if x != nil {
		return x.Tensorboard
	}
	return nil
}

// Request message for
// [TensorboardService.DeleteTensorboard][google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboard].
type DeleteTensorboardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Tensorboard to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTensorboardRequest) Reset() {
	*x = DeleteTensorboardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTensorboardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTensorboardRequest) ProtoMessage() {}

func (x *DeleteTensorboardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTensorboardRequest.ProtoReflect.Descriptor instead.
func (*DeleteTensorboardRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteTensorboardRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [TensorboardService.CreateTensorboardExperiment][google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardExperiment].
type CreateTensorboardExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Tensorboard to create the
	// TensorboardExperiment in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The TensorboardExperiment to create.
	TensorboardExperiment *TensorboardExperiment `protobuf:"bytes,2,opt,name=tensorboard_experiment,json=tensorboardExperiment,proto3" json:"tensorboard_experiment,omitempty"`
	// Required. The ID to use for the Tensorboard experiment, which becomes the
	// final component of the Tensorboard experiment's resource name.
	//
	// This value should be 1-128 characters, and valid characters
	// are /[a-z][0-9]-/.
	TensorboardExperimentId string `protobuf:"bytes,3,opt,name=tensorboard_experiment_id,json=tensorboardExperimentId,proto3" json:"tensorboard_experiment_id,omitempty"`
}

func (x *CreateTensorboardExperimentRequest) Reset() {
	*x = CreateTensorboardExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTensorboardExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTensorboardExperimentRequest) ProtoMessage() {}

func (x *CreateTensorboardExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTensorboardExperimentRequest.ProtoReflect.Descriptor instead.
func (*CreateTensorboardExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{8}
}

func (x *CreateTensorboardExperimentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTensorboardExperimentRequest) GetTensorboardExperiment() *TensorboardExperiment {
	if x != nil {
		return x.TensorboardExperiment
	}
	return nil
}

func (x *CreateTensorboardExperimentRequest) GetTensorboardExperimentId() string {
	if x != nil {
		return x.TensorboardExperimentId
	}
	return ""
}

// Request message for
// [TensorboardService.GetTensorboardExperiment][google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardExperiment].
type GetTensorboardExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TensorboardExperiment resource.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTensorboardExperimentRequest) Reset() {
	*x = GetTensorboardExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTensorboardExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTensorboardExperimentRequest) ProtoMessage() {}

func (x *GetTensorboardExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTensorboardExperimentRequest.ProtoReflect.Descriptor instead.
func (*GetTensorboardExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{9}
}

func (x *GetTensorboardExperimentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [TensorboardService.ListTensorboardExperiments][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardExperiments].
type ListTensorboardExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Tensorboard to list
	// TensorboardExperiments. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the TensorboardExperiments that match the filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of TensorboardExperiments to return. The service may
	// return fewer than this value. If unspecified, at most 50
	// TensorboardExperiments are returned. The maximum value is 1000; values
	// above 1000 are coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [TensorboardService.ListTensorboardExperiments][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardExperiments]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [TensorboardService.ListTensorboardExperiments][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardExperiments]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListTensorboardExperimentsRequest) Reset() {
	*x = ListTensorboardExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorboardExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorboardExperimentsRequest) ProtoMessage() {}

func (x *ListTensorboardExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorboardExperimentsRequest.ProtoReflect.Descriptor instead.
func (*ListTensorboardExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListTensorboardExperimentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTensorboardExperimentsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTensorboardExperimentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTensorboardExperimentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTensorboardExperimentsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListTensorboardExperimentsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [TensorboardService.ListTensorboardExperiments][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardExperiments].
type ListTensorboardExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The TensorboardExperiments mathching the request.
	TensorboardExperiments []*TensorboardExperiment `protobuf:"bytes,1,rep,name=tensorboard_experiments,json=tensorboardExperiments,proto3" json:"tensorboard_experiments,omitempty"`
	// A token, which can be sent as
	// [ListTensorboardExperimentsRequest.page_token][google.cloud.aiplatform.v1beta1.ListTensorboardExperimentsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTensorboardExperimentsResponse) Reset() {
	*x = ListTensorboardExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorboardExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorboardExperimentsResponse) ProtoMessage() {}

func (x *ListTensorboardExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorboardExperimentsResponse.ProtoReflect.Descriptor instead.
func (*ListTensorboardExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListTensorboardExperimentsResponse) GetTensorboardExperiments() []*TensorboardExperiment {
	if x != nil {
		return x.TensorboardExperiments
	}
	return nil
}

func (x *ListTensorboardExperimentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [TensorboardService.UpdateTensorboardExperiment][google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardExperiment].
type UpdateTensorboardExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// TensorboardExperiment resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field is overwritten if it's in the mask. If the
	// user does not provide a mask then all fields are overwritten if new
	// values are specified.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The TensorboardExperiment's `name` field is used to identify the
	// TensorboardExperiment to be updated. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
	TensorboardExperiment *TensorboardExperiment `protobuf:"bytes,2,opt,name=tensorboard_experiment,json=tensorboardExperiment,proto3" json:"tensorboard_experiment,omitempty"`
}

func (x *UpdateTensorboardExperimentRequest) Reset() {
	*x = UpdateTensorboardExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTensorboardExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTensorboardExperimentRequest) ProtoMessage() {}

func (x *UpdateTensorboardExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTensorboardExperimentRequest.ProtoReflect.Descriptor instead.
func (*UpdateTensorboardExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateTensorboardExperimentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTensorboardExperimentRequest) GetTensorboardExperiment() *TensorboardExperiment {
	if x != nil {
		return x.TensorboardExperiment
	}
	return nil
}

// Request message for
// [TensorboardService.DeleteTensorboardExperiment][google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardExperiment].
type DeleteTensorboardExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TensorboardExperiment to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTensorboardExperimentRequest) Reset() {
	*x = DeleteTensorboardExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTensorboardExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTensorboardExperimentRequest) ProtoMessage() {}

func (x *DeleteTensorboardExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTensorboardExperimentRequest.ProtoReflect.Descriptor instead.
func (*DeleteTensorboardExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteTensorboardExperimentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [TensorboardService.BatchCreateTensorboardRuns][google.cloud.aiplatform.v1beta1.TensorboardService.BatchCreateTensorboardRuns].
type BatchCreateTensorboardRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardExperiment to create the
	// TensorboardRuns in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
	// The parent field in the CreateTensorboardRunRequest messages must match
	// this field.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message specifying the TensorboardRuns to create.
	// A maximum of 1000 TensorboardRuns can be created in a batch.
	Requests []*CreateTensorboardRunRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateTensorboardRunsRequest) Reset() {
	*x = BatchCreateTensorboardRunsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTensorboardRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTensorboardRunsRequest) ProtoMessage() {}

func (x *BatchCreateTensorboardRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTensorboardRunsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateTensorboardRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{14}
}

func (x *BatchCreateTensorboardRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateTensorboardRunsRequest) GetRequests() []*CreateTensorboardRunRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for
// [TensorboardService.BatchCreateTensorboardRuns][google.cloud.aiplatform.v1beta1.TensorboardService.BatchCreateTensorboardRuns].
type BatchCreateTensorboardRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created TensorboardRuns.
	TensorboardRuns []*TensorboardRun `protobuf:"bytes,1,rep,name=tensorboard_runs,json=tensorboardRuns,proto3" json:"tensorboard_runs,omitempty"`
}

func (x *BatchCreateTensorboardRunsResponse) Reset() {
	*x = BatchCreateTensorboardRunsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTensorboardRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTensorboardRunsResponse) ProtoMessage() {}

func (x *BatchCreateTensorboardRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTensorboardRunsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateTensorboardRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{15}
}

func (x *BatchCreateTensorboardRunsResponse) GetTensorboardRuns() []*TensorboardRun {
	if x != nil {
		return x.TensorboardRuns
	}
	return nil
}

// Request message for
// [TensorboardService.CreateTensorboardRun][google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardRun].
type CreateTensorboardRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardExperiment to create the
	// TensorboardRun in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The TensorboardRun to create.
	TensorboardRun *TensorboardRun `protobuf:"bytes,2,opt,name=tensorboard_run,json=tensorboardRun,proto3" json:"tensorboard_run,omitempty"`
	// Required. The ID to use for the Tensorboard run, which becomes the final
	// component of the Tensorboard run's resource name.
	//
	// This value should be 1-128 characters, and valid characters
	// are /[a-z][0-9]-/.
	TensorboardRunId string `protobuf:"bytes,3,opt,name=tensorboard_run_id,json=tensorboardRunId,proto3" json:"tensorboard_run_id,omitempty"`
}

func (x *CreateTensorboardRunRequest) Reset() {
	*x = CreateTensorboardRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTensorboardRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTensorboardRunRequest) ProtoMessage() {}

func (x *CreateTensorboardRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTensorboardRunRequest.ProtoReflect.Descriptor instead.
func (*CreateTensorboardRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{16}
}

func (x *CreateTensorboardRunRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTensorboardRunRequest) GetTensorboardRun() *TensorboardRun {
	if x != nil {
		return x.TensorboardRun
	}
	return nil
}

func (x *CreateTensorboardRunRequest) GetTensorboardRunId() string {
	if x != nil {
		return x.TensorboardRunId
	}
	return ""
}

// Request message for
// [TensorboardService.GetTensorboardRun][google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardRun].
type GetTensorboardRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TensorboardRun resource.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTensorboardRunRequest) Reset() {
	*x = GetTensorboardRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTensorboardRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTensorboardRunRequest) ProtoMessage() {}

func (x *GetTensorboardRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTensorboardRunRequest.ProtoReflect.Descriptor instead.
func (*GetTensorboardRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{17}
}

func (x *GetTensorboardRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [TensorboardService.ReadTensorboardBlobData][google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardBlobData].
type ReadTensorboardBlobDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardTimeSeries to list Blobs.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
	TimeSeries string `protobuf:"bytes,1,opt,name=time_series,json=timeSeries,proto3" json:"time_series,omitempty"`
	// IDs of the blobs to read.
	BlobIds []string `protobuf:"bytes,2,rep,name=blob_ids,json=blobIds,proto3" json:"blob_ids,omitempty"`
}

func (x *ReadTensorboardBlobDataRequest) Reset() {
	*x = ReadTensorboardBlobDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTensorboardBlobDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTensorboardBlobDataRequest) ProtoMessage() {}

func (x *ReadTensorboardBlobDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTensorboardBlobDataRequest.ProtoReflect.Descriptor instead.
func (*ReadTensorboardBlobDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{18}
}

func (x *ReadTensorboardBlobDataRequest) GetTimeSeries() string {
	if x != nil {
		return x.TimeSeries
	}
	return ""
}

func (x *ReadTensorboardBlobDataRequest) GetBlobIds() []string {
	if x != nil {
		return x.BlobIds
	}
	return nil
}

// Response message for
// [TensorboardService.ReadTensorboardBlobData][google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardBlobData].
type ReadTensorboardBlobDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Blob messages containing blob bytes.
	Blobs []*TensorboardBlob `protobuf:"bytes,1,rep,name=blobs,proto3" json:"blobs,omitempty"`
}

func (x *ReadTensorboardBlobDataResponse) Reset() {
	*x = ReadTensorboardBlobDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTensorboardBlobDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTensorboardBlobDataResponse) ProtoMessage() {}

func (x *ReadTensorboardBlobDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTensorboardBlobDataResponse.ProtoReflect.Descriptor instead.
func (*ReadTensorboardBlobDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{19}
}

func (x *ReadTensorboardBlobDataResponse) GetBlobs() []*TensorboardBlob {
	if x != nil {
		return x.Blobs
	}
	return nil
}

// Request message for
// [TensorboardService.ListTensorboardRuns][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardRuns].
type ListTensorboardRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardExperiment to list
	// TensorboardRuns. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the TensorboardRuns that match the filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of TensorboardRuns to return. The service may return
	// fewer than this value. If unspecified, at most 50 TensorboardRuns are
	// returned. The maximum value is 1000; values above 1000 are coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [TensorboardService.ListTensorboardRuns][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardRuns]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [TensorboardService.ListTensorboardRuns][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardRuns]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListTensorboardRunsRequest) Reset() {
	*x = ListTensorboardRunsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorboardRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorboardRunsRequest) ProtoMessage() {}

func (x *ListTensorboardRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorboardRunsRequest.ProtoReflect.Descriptor instead.
func (*ListTensorboardRunsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListTensorboardRunsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTensorboardRunsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTensorboardRunsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTensorboardRunsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTensorboardRunsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListTensorboardRunsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [TensorboardService.ListTensorboardRuns][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardRuns].
type ListTensorboardRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The TensorboardRuns mathching the request.
	TensorboardRuns []*TensorboardRun `protobuf:"bytes,1,rep,name=tensorboard_runs,json=tensorboardRuns,proto3" json:"tensorboard_runs,omitempty"`
	// A token, which can be sent as
	// [ListTensorboardRunsRequest.page_token][google.cloud.aiplatform.v1beta1.ListTensorboardRunsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTensorboardRunsResponse) Reset() {
	*x = ListTensorboardRunsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorboardRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorboardRunsResponse) ProtoMessage() {}

func (x *ListTensorboardRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorboardRunsResponse.ProtoReflect.Descriptor instead.
func (*ListTensorboardRunsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{21}
}

func (x *ListTensorboardRunsResponse) GetTensorboardRuns() []*TensorboardRun {
	if x != nil {
		return x.TensorboardRuns
	}
	return nil
}

func (x *ListTensorboardRunsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [TensorboardService.UpdateTensorboardRun][google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardRun].
type UpdateTensorboardRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// TensorboardRun resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field is overwritten if it's in the mask. If the
	// user does not provide a mask then all fields are overwritten if new
	// values are specified.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The TensorboardRun's `name` field is used to identify the
	// TensorboardRun to be updated. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
	TensorboardRun *TensorboardRun `protobuf:"bytes,2,opt,name=tensorboard_run,json=tensorboardRun,proto3" json:"tensorboard_run,omitempty"`
}

func (x *UpdateTensorboardRunRequest) Reset() {
	*x = UpdateTensorboardRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTensorboardRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTensorboardRunRequest) ProtoMessage() {}

func (x *UpdateTensorboardRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTensorboardRunRequest.ProtoReflect.Descriptor instead.
func (*UpdateTensorboardRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateTensorboardRunRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTensorboardRunRequest) GetTensorboardRun() *TensorboardRun {
	if x != nil {
		return x.TensorboardRun
	}
	return nil
}

// Request message for
// [TensorboardService.DeleteTensorboardRun][google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardRun].
type DeleteTensorboardRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TensorboardRun to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTensorboardRunRequest) Reset() {
	*x = DeleteTensorboardRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTensorboardRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTensorboardRunRequest) ProtoMessage() {}

func (x *DeleteTensorboardRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTensorboardRunRequest.ProtoReflect.Descriptor instead.
func (*DeleteTensorboardRunRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{23}
}

func (x *DeleteTensorboardRunRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [TensorboardService.BatchCreateTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.BatchCreateTensorboardTimeSeries].
type BatchCreateTensorboardTimeSeriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardExperiment to create the
	// TensorboardTimeSeries in.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
	// The TensorboardRuns referenced by the parent fields in the
	// CreateTensorboardTimeSeriesRequest messages must be sub resources of this
	// TensorboardExperiment.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message specifying the TensorboardTimeSeries to
	// create. A maximum of 1000 TensorboardTimeSeries can be created in a batch.
	Requests []*CreateTensorboardTimeSeriesRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateTensorboardTimeSeriesRequest) Reset() {
	*x = BatchCreateTensorboardTimeSeriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTensorboardTimeSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTensorboardTimeSeriesRequest) ProtoMessage() {}

func (x *BatchCreateTensorboardTimeSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTensorboardTimeSeriesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateTensorboardTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{24}
}

func (x *BatchCreateTensorboardTimeSeriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateTensorboardTimeSeriesRequest) GetRequests() []*CreateTensorboardTimeSeriesRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for
// [TensorboardService.BatchCreateTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.BatchCreateTensorboardTimeSeries].
type BatchCreateTensorboardTimeSeriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created TensorboardTimeSeries.
	TensorboardTimeSeries []*TensorboardTimeSeries `protobuf:"bytes,1,rep,name=tensorboard_time_series,json=tensorboardTimeSeries,proto3" json:"tensorboard_time_series,omitempty"`
}

func (x *BatchCreateTensorboardTimeSeriesResponse) Reset() {
	*x = BatchCreateTensorboardTimeSeriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateTensorboardTimeSeriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateTensorboardTimeSeriesResponse) ProtoMessage() {}

func (x *BatchCreateTensorboardTimeSeriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateTensorboardTimeSeriesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateTensorboardTimeSeriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{25}
}

func (x *BatchCreateTensorboardTimeSeriesResponse) GetTensorboardTimeSeries() []*TensorboardTimeSeries {
	if x != nil {
		return x.TensorboardTimeSeries
	}
	return nil
}

// Request message for
// [TensorboardService.CreateTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardTimeSeries].
type CreateTensorboardTimeSeriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardRun to create the
	// TensorboardTimeSeries in.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The user specified unique ID to use for the
	// TensorboardTimeSeries, which becomes the final component of the
	// TensorboardTimeSeries's resource name. This value should match
	// "[a-z0-9][a-z0-9-]{0, 127}"
	TensorboardTimeSeriesId string `protobuf:"bytes,3,opt,name=tensorboard_time_series_id,json=tensorboardTimeSeriesId,proto3" json:"tensorboard_time_series_id,omitempty"`
	// Required. The TensorboardTimeSeries to create.
	TensorboardTimeSeries *TensorboardTimeSeries `protobuf:"bytes,2,opt,name=tensorboard_time_series,json=tensorboardTimeSeries,proto3" json:"tensorboard_time_series,omitempty"`
}

func (x *CreateTensorboardTimeSeriesRequest) Reset() {
	*x = CreateTensorboardTimeSeriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTensorboardTimeSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTensorboardTimeSeriesRequest) ProtoMessage() {}

func (x *CreateTensorboardTimeSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTensorboardTimeSeriesRequest.ProtoReflect.Descriptor instead.
func (*CreateTensorboardTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{26}
}

func (x *CreateTensorboardTimeSeriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTensorboardTimeSeriesRequest) GetTensorboardTimeSeriesId() string {
	if x != nil {
		return x.TensorboardTimeSeriesId
	}
	return ""
}

func (x *CreateTensorboardTimeSeriesRequest) GetTensorboardTimeSeries() *TensorboardTimeSeries {
	if x != nil {
		return x.TensorboardTimeSeries
	}
	return nil
}

// Request message for
// [TensorboardService.GetTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardTimeSeries].
type GetTensorboardTimeSeriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TensorboardTimeSeries resource.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTensorboardTimeSeriesRequest) Reset() {
	*x = GetTensorboardTimeSeriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTensorboardTimeSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTensorboardTimeSeriesRequest) ProtoMessage() {}

func (x *GetTensorboardTimeSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTensorboardTimeSeriesRequest.ProtoReflect.Descriptor instead.
func (*GetTensorboardTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{27}
}

func (x *GetTensorboardTimeSeriesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [TensorboardService.ListTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardTimeSeries].
type ListTensorboardTimeSeriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardRun to list
	// TensorboardTimeSeries. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the TensorboardTimeSeries that match the filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of TensorboardTimeSeries to return. The service may
	// return fewer than this value. If unspecified, at most 50
	// TensorboardTimeSeries are returned. The maximum value is 1000; values
	// above 1000 are coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [TensorboardService.ListTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardTimeSeries]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [TensorboardService.ListTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardTimeSeries]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListTensorboardTimeSeriesRequest) Reset() {
	*x = ListTensorboardTimeSeriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorboardTimeSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorboardTimeSeriesRequest) ProtoMessage() {}

func (x *ListTensorboardTimeSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorboardTimeSeriesRequest.ProtoReflect.Descriptor instead.
func (*ListTensorboardTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{28}
}

func (x *ListTensorboardTimeSeriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTensorboardTimeSeriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTensorboardTimeSeriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTensorboardTimeSeriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTensorboardTimeSeriesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListTensorboardTimeSeriesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [TensorboardService.ListTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardTimeSeries].
type ListTensorboardTimeSeriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The TensorboardTimeSeries mathching the request.
	TensorboardTimeSeries []*TensorboardTimeSeries `protobuf:"bytes,1,rep,name=tensorboard_time_series,json=tensorboardTimeSeries,proto3" json:"tensorboard_time_series,omitempty"`
	// A token, which can be sent as
	// [ListTensorboardTimeSeriesRequest.page_token][google.cloud.aiplatform.v1beta1.ListTensorboardTimeSeriesRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTensorboardTimeSeriesResponse) Reset() {
	*x = ListTensorboardTimeSeriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTensorboardTimeSeriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTensorboardTimeSeriesResponse) ProtoMessage() {}

func (x *ListTensorboardTimeSeriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTensorboardTimeSeriesResponse.ProtoReflect.Descriptor instead.
func (*ListTensorboardTimeSeriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{29}
}

func (x *ListTensorboardTimeSeriesResponse) GetTensorboardTimeSeries() []*TensorboardTimeSeries {
	if x != nil {
		return x.TensorboardTimeSeries
	}
	return nil
}

func (x *ListTensorboardTimeSeriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [TensorboardService.UpdateTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardTimeSeries].
type UpdateTensorboardTimeSeriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// TensorboardTimeSeries resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field is overwritten if it's in the mask. If the
	// user does not provide a mask then all fields are overwritten if new
	// values are specified.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The TensorboardTimeSeries' `name` field is used to identify the
	// TensorboardTimeSeries to be updated.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
	TensorboardTimeSeries *TensorboardTimeSeries `protobuf:"bytes,2,opt,name=tensorboard_time_series,json=tensorboardTimeSeries,proto3" json:"tensorboard_time_series,omitempty"`
}

func (x *UpdateTensorboardTimeSeriesRequest) Reset() {
	*x = UpdateTensorboardTimeSeriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTensorboardTimeSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTensorboardTimeSeriesRequest) ProtoMessage() {}

func (x *UpdateTensorboardTimeSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTensorboardTimeSeriesRequest.ProtoReflect.Descriptor instead.
func (*UpdateTensorboardTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateTensorboardTimeSeriesRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTensorboardTimeSeriesRequest) GetTensorboardTimeSeries() *TensorboardTimeSeries {
	if x != nil {
		return x.TensorboardTimeSeries
	}
	return nil
}

// Request message for
// [TensorboardService.DeleteTensorboardTimeSeries][google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardTimeSeries].
type DeleteTensorboardTimeSeriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TensorboardTimeSeries to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTensorboardTimeSeriesRequest) Reset() {
	*x = DeleteTensorboardTimeSeriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTensorboardTimeSeriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTensorboardTimeSeriesRequest) ProtoMessage() {}

func (x *DeleteTensorboardTimeSeriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTensorboardTimeSeriesRequest.ProtoReflect.Descriptor instead.
func (*DeleteTensorboardTimeSeriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{31}
}

func (x *DeleteTensorboardTimeSeriesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [TensorboardService.BatchReadTensorboardTimeSeriesData][google.cloud.aiplatform.v1beta1.TensorboardService.BatchReadTensorboardTimeSeriesData].
type BatchReadTensorboardTimeSeriesDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Tensorboard containing
	// TensorboardTimeSeries to read data from. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`.
	// The TensorboardTimeSeries referenced by
	// [time_series][google.cloud.aiplatform.v1beta1.BatchReadTensorboardTimeSeriesDataRequest.time_series]
	// must be sub resources of this Tensorboard.
	Tensorboard string `protobuf:"bytes,1,opt,name=tensorboard,proto3" json:"tensorboard,omitempty"`
	// Required. The resource names of the TensorboardTimeSeries to read data
	// from. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
	TimeSeries []string `protobuf:"bytes,2,rep,name=time_series,json=timeSeries,proto3" json:"time_series,omitempty"`
}

func (x *BatchReadTensorboardTimeSeriesDataRequest) Reset() {
	*x = BatchReadTensorboardTimeSeriesDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchReadTensorboardTimeSeriesDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadTensorboardTimeSeriesDataRequest) ProtoMessage() {}

func (x *BatchReadTensorboardTimeSeriesDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadTensorboardTimeSeriesDataRequest.ProtoReflect.Descriptor instead.
func (*BatchReadTensorboardTimeSeriesDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{32}
}

func (x *BatchReadTensorboardTimeSeriesDataRequest) GetTensorboard() string {
	if x != nil {
		return x.Tensorboard
	}
	return ""
}

func (x *BatchReadTensorboardTimeSeriesDataRequest) GetTimeSeries() []string {
	if x != nil {
		return x.TimeSeries
	}
	return nil
}

// Response message for
// [TensorboardService.BatchReadTensorboardTimeSeriesData][google.cloud.aiplatform.v1beta1.TensorboardService.BatchReadTensorboardTimeSeriesData].
type BatchReadTensorboardTimeSeriesDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned time series data.
	TimeSeriesData []*TimeSeriesData `protobuf:"bytes,1,rep,name=time_series_data,json=timeSeriesData,proto3" json:"time_series_data,omitempty"`
}

func (x *BatchReadTensorboardTimeSeriesDataResponse) Reset() {
	*x = BatchReadTensorboardTimeSeriesDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchReadTensorboardTimeSeriesDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadTensorboardTimeSeriesDataResponse) ProtoMessage() {}

func (x *BatchReadTensorboardTimeSeriesDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadTensorboardTimeSeriesDataResponse.ProtoReflect.Descriptor instead.
func (*BatchReadTensorboardTimeSeriesDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{33}
}

func (x *BatchReadTensorboardTimeSeriesDataResponse) GetTimeSeriesData() []*TimeSeriesData {
	if x != nil {
		return x.TimeSeriesData
	}
	return nil
}

// Request message for
// [TensorboardService.ReadTensorboardTimeSeriesData][google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardTimeSeriesData].
type ReadTensorboardTimeSeriesDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardTimeSeries to read data from.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
	TensorboardTimeSeries string `protobuf:"bytes,1,opt,name=tensorboard_time_series,json=tensorboardTimeSeries,proto3" json:"tensorboard_time_series,omitempty"`
	// The maximum number of TensorboardTimeSeries' data to return.
	//
	// This value should be a positive integer.
	// This value can be set to -1 to return all data.
	MaxDataPoints int32 `protobuf:"varint,2,opt,name=max_data_points,json=maxDataPoints,proto3" json:"max_data_points,omitempty"`
	// Reads the TensorboardTimeSeries' data that match the filter expression.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ReadTensorboardTimeSeriesDataRequest) Reset() {
	*x = ReadTensorboardTimeSeriesDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTensorboardTimeSeriesDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTensorboardTimeSeriesDataRequest) ProtoMessage() {}

func (x *ReadTensorboardTimeSeriesDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTensorboardTimeSeriesDataRequest.ProtoReflect.Descriptor instead.
func (*ReadTensorboardTimeSeriesDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{34}
}

func (x *ReadTensorboardTimeSeriesDataRequest) GetTensorboardTimeSeries() string {
	if x != nil {
		return x.TensorboardTimeSeries
	}
	return ""
}

func (x *ReadTensorboardTimeSeriesDataRequest) GetMaxDataPoints() int32 {
	if x != nil {
		return x.MaxDataPoints
	}
	return 0
}

func (x *ReadTensorboardTimeSeriesDataRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [TensorboardService.ReadTensorboardTimeSeriesData][google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardTimeSeriesData].
type ReadTensorboardTimeSeriesDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned time series data.
	TimeSeriesData *TimeSeriesData `protobuf:"bytes,1,opt,name=time_series_data,json=timeSeriesData,proto3" json:"time_series_data,omitempty"`
}

func (x *ReadTensorboardTimeSeriesDataResponse) Reset() {
	*x = ReadTensorboardTimeSeriesDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTensorboardTimeSeriesDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTensorboardTimeSeriesDataResponse) ProtoMessage() {}

func (x *ReadTensorboardTimeSeriesDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTensorboardTimeSeriesDataResponse.ProtoReflect.Descriptor instead.
func (*ReadTensorboardTimeSeriesDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{35}
}

func (x *ReadTensorboardTimeSeriesDataResponse) GetTimeSeriesData() *TimeSeriesData {
	if x != nil {
		return x.TimeSeriesData
	}
	return nil
}

// Request message for
// [TensorboardService.WriteTensorboardExperimentData][google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardExperimentData].
type WriteTensorboardExperimentDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardExperiment to write data to.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
	TensorboardExperiment string `protobuf:"bytes,1,opt,name=tensorboard_experiment,json=tensorboardExperiment,proto3" json:"tensorboard_experiment,omitempty"`
	// Required. Requests containing per-run TensorboardTimeSeries data to write.
	WriteRunDataRequests []*WriteTensorboardRunDataRequest `protobuf:"bytes,2,rep,name=write_run_data_requests,json=writeRunDataRequests,proto3" json:"write_run_data_requests,omitempty"`
}

func (x *WriteTensorboardExperimentDataRequest) Reset() {
	*x = WriteTensorboardExperimentDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteTensorboardExperimentDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteTensorboardExperimentDataRequest) ProtoMessage() {}

func (x *WriteTensorboardExperimentDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteTensorboardExperimentDataRequest.ProtoReflect.Descriptor instead.
func (*WriteTensorboardExperimentDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{36}
}

func (x *WriteTensorboardExperimentDataRequest) GetTensorboardExperiment() string {
	if x != nil {
		return x.TensorboardExperiment
	}
	return ""
}

func (x *WriteTensorboardExperimentDataRequest) GetWriteRunDataRequests() []*WriteTensorboardRunDataRequest {
	if x != nil {
		return x.WriteRunDataRequests
	}
	return nil
}

// Response message for
// [TensorboardService.WriteTensorboardExperimentData][google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardExperimentData].
type WriteTensorboardExperimentDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WriteTensorboardExperimentDataResponse) Reset() {
	*x = WriteTensorboardExperimentDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteTensorboardExperimentDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteTensorboardExperimentDataResponse) ProtoMessage() {}

func (x *WriteTensorboardExperimentDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteTensorboardExperimentDataResponse.ProtoReflect.Descriptor instead.
func (*WriteTensorboardExperimentDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{37}
}

// Request message for
// [TensorboardService.WriteTensorboardRunData][google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardRunData].
type WriteTensorboardRunDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardRun to write data to.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
	TensorboardRun string `protobuf:"bytes,1,opt,name=tensorboard_run,json=tensorboardRun,proto3" json:"tensorboard_run,omitempty"`
	// Required. The TensorboardTimeSeries data to write.
	// Values with in a time series are indexed by their step value.
	// Repeated writes to the same step will overwrite the existing value for that
	// step.
	// The upper limit of data points per write request is 5000.
	TimeSeriesData []*TimeSeriesData `protobuf:"bytes,2,rep,name=time_series_data,json=timeSeriesData,proto3" json:"time_series_data,omitempty"`
}

func (x *WriteTensorboardRunDataRequest) Reset() {
	*x = WriteTensorboardRunDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteTensorboardRunDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteTensorboardRunDataRequest) ProtoMessage() {}

func (x *WriteTensorboardRunDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteTensorboardRunDataRequest.ProtoReflect.Descriptor instead.
func (*WriteTensorboardRunDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{38}
}

func (x *WriteTensorboardRunDataRequest) GetTensorboardRun() string {
	if x != nil {
		return x.TensorboardRun
	}
	return ""
}

func (x *WriteTensorboardRunDataRequest) GetTimeSeriesData() []*TimeSeriesData {
	if x != nil {
		return x.TimeSeriesData
	}
	return nil
}

// Response message for
// [TensorboardService.WriteTensorboardRunData][google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardRunData].
type WriteTensorboardRunDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WriteTensorboardRunDataResponse) Reset() {
	*x = WriteTensorboardRunDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteTensorboardRunDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteTensorboardRunDataResponse) ProtoMessage() {}

func (x *WriteTensorboardRunDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteTensorboardRunDataResponse.ProtoReflect.Descriptor instead.
func (*WriteTensorboardRunDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{39}
}

// Request message for
// [TensorboardService.ExportTensorboardTimeSeriesData][google.cloud.aiplatform.v1beta1.TensorboardService.ExportTensorboardTimeSeriesData].
type ExportTensorboardTimeSeriesDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the TensorboardTimeSeries to export data
	// from. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
	TensorboardTimeSeries string `protobuf:"bytes,1,opt,name=tensorboard_time_series,json=tensorboardTimeSeries,proto3" json:"tensorboard_time_series,omitempty"`
	// Exports the TensorboardTimeSeries' data that match the filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of data points to return per page.
	// The default page_size is 1000. Values must be between 1 and 10000.
	// Values above 10000 are coerced to 10000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [ExportTensorboardTimeSeriesData][google.cloud.aiplatform.v1beta1.TensorboardService.ExportTensorboardTimeSeriesData]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [ExportTensorboardTimeSeriesData][google.cloud.aiplatform.v1beta1.TensorboardService.ExportTensorboardTimeSeriesData]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field to use to sort the TensorboardTimeSeries' data.
	// By default, TensorboardTimeSeries' data is returned in a pseudo random
	// order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ExportTensorboardTimeSeriesDataRequest) Reset() {
	*x = ExportTensorboardTimeSeriesDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportTensorboardTimeSeriesDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTensorboardTimeSeriesDataRequest) ProtoMessage() {}

func (x *ExportTensorboardTimeSeriesDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTensorboardTimeSeriesDataRequest.ProtoReflect.Descriptor instead.
func (*ExportTensorboardTimeSeriesDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{40}
}

func (x *ExportTensorboardTimeSeriesDataRequest) GetTensorboardTimeSeries() string {
	if x != nil {
		return x.TensorboardTimeSeries
	}
	return ""
}

func (x *ExportTensorboardTimeSeriesDataRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ExportTensorboardTimeSeriesDataRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ExportTensorboardTimeSeriesDataRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ExportTensorboardTimeSeriesDataRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [TensorboardService.ExportTensorboardTimeSeriesData][google.cloud.aiplatform.v1beta1.TensorboardService.ExportTensorboardTimeSeriesData].
type ExportTensorboardTimeSeriesDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned time series data points.
	TimeSeriesDataPoints []*TimeSeriesDataPoint `protobuf:"bytes,1,rep,name=time_series_data_points,json=timeSeriesDataPoints,proto3" json:"time_series_data_points,omitempty"`
	// A token, which can be sent as
	// [page_token][google.cloud.aiplatform.v1beta1.ExportTensorboardTimeSeriesDataRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ExportTensorboardTimeSeriesDataResponse) Reset() {
	*x = ExportTensorboardTimeSeriesDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportTensorboardTimeSeriesDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTensorboardTimeSeriesDataResponse) ProtoMessage() {}

func (x *ExportTensorboardTimeSeriesDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTensorboardTimeSeriesDataResponse.ProtoReflect.Descriptor instead.
func (*ExportTensorboardTimeSeriesDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{41}
}

func (x *ExportTensorboardTimeSeriesDataResponse) GetTimeSeriesDataPoints() []*TimeSeriesDataPoint {
	if x != nil {
		return x.TimeSeriesDataPoints
	}
	return nil
}

func (x *ExportTensorboardTimeSeriesDataResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Details of operations that perform create Tensorboard.
type CreateTensorboardOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Tensorboard.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateTensorboardOperationMetadata) Reset() {
	*x = CreateTensorboardOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTensorboardOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTensorboardOperationMetadata) ProtoMessage() {}

func (x *CreateTensorboardOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTensorboardOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateTensorboardOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{42}
}

func (x *CreateTensorboardOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform update Tensorboard.
type UpdateTensorboardOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Tensorboard.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateTensorboardOperationMetadata) Reset() {
	*x = UpdateTensorboardOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTensorboardOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTensorboardOperationMetadata) ProtoMessage() {}

func (x *UpdateTensorboardOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTensorboardOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateTensorboardOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{43}
}

func (x *UpdateTensorboardOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Per user usage data.
type ReadTensorboardUsageResponse_PerUserUsageData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User's username
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Number of times the user has read data within the Tensorboard.
	ViewCount int64 `protobuf:"varint,2,opt,name=view_count,json=viewCount,proto3" json:"view_count,omitempty"`
}

func (x *ReadTensorboardUsageResponse_PerUserUsageData) Reset() {
	*x = ReadTensorboardUsageResponse_PerUserUsageData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTensorboardUsageResponse_PerUserUsageData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTensorboardUsageResponse_PerUserUsageData) ProtoMessage() {}

func (x *ReadTensorboardUsageResponse_PerUserUsageData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTensorboardUsageResponse_PerUserUsageData.ProtoReflect.Descriptor instead.
func (*ReadTensorboardUsageResponse_PerUserUsageData) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ReadTensorboardUsageResponse_PerUserUsageData) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *ReadTensorboardUsageResponse_PerUserUsageData) GetViewCount() int64 {
	if x != nil {
		return x.ViewCount
	}
	return 0
}

// Per month usage data
type ReadTensorboardUsageResponse_PerMonthUsageData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Usage data for each user in the given month.
	UserUsageData []*ReadTensorboardUsageResponse_PerUserUsageData `protobuf:"bytes,1,rep,name=user_usage_data,json=userUsageData,proto3" json:"user_usage_data,omitempty"`
}

func (x *ReadTensorboardUsageResponse_PerMonthUsageData) Reset() {
	*x = ReadTensorboardUsageResponse_PerMonthUsageData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadTensorboardUsageResponse_PerMonthUsageData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadTensorboardUsageResponse_PerMonthUsageData) ProtoMessage() {}

func (x *ReadTensorboardUsageResponse_PerMonthUsageData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadTensorboardUsageResponse_PerMonthUsageData.ProtoReflect.Descriptor instead.
func (*ReadTensorboardUsageResponse_PerMonthUsageData) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP(), []int{3, 1}
}

func (x *ReadTensorboardUsageResponse_PerMonthUsageData) GetUserUsageData() []*ReadTensorboardUsageResponse_PerUserUsageData {
	if x != nil {
		return x.UserUsageData
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_tensorboard_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x22, 0x5a, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x1b, 0x52, 0x65, 0x61, 0x64,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x0b, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x22, 0x96, 0x04, 0x0a, 0x1c, 0x52, 0x65, 0x61,
	0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x12, 0x6d, 0x6f,
	0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x6d, 0x6f, 0x6e,
	0x74, 0x68, 0x6c, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x1a, 0x4d, 0x0a,
	0x10, 0x50, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x55, 0x73, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x8b, 0x01, 0x0a,
	0x11, 0x50, 0x65, 0x72, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x55, 0x73, 0x61, 0x67, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x76, 0x0a, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x55, 0x73,
	0x65, 0x72, 0x55, 0x73, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0d, 0x75, 0x73, 0x65,
	0x72, 0x55, 0x73, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x1a, 0x94, 0x01, 0x0a, 0x15, 0x4d,
	0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x65, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x88, 0x02, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x94, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x0c, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x0c, 0x74,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xb1, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x53, 0x0a, 0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x22, 0x5d, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa5, 0x02, 0x0a, 0x22, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6d,
	0x0a, 0x16, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x15, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a,
	0x19, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x6e,
	0x0a, 0x1f, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9c,
	0x02, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xbd, 0x01,
	0x0a, 0x22, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x16, 0x74,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xda, 0x01,
	0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x72, 0x0a, 0x16, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x15, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x71, 0x0a, 0x22, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd3, 0x01,
	0x0a, 0x21, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x22, 0x80, 0x01, 0x0a, 0x22, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x10, 0x74, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x0f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x52, 0x75, 0x6e, 0x73, 0x22, 0xf9, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x5d, 0x0a, 0x0f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f,
	0x72, 0x75, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x12,
	0x31, 0x0a, 0x12, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72,
	0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e,
	0x49, 0x64, 0x22, 0x60, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x1e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x42, 0x6c, 0x6f, 0x62, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x6c, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x62, 0x6c, 0x6f, 0x62, 0x49, 0x64, 0x73, 0x22, 0x69, 0x0a, 0x1f,
	0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x42,
	0x6c, 0x6f, 0x62, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x46, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x42, 0x6c, 0x6f, 0x62,
	0x52, 0x05, 0x62, 0x6c, 0x6f, 0x62, 0x73, 0x22, 0x8e, 0x02, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08,
	0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa1, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x10, 0x74, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x52, 0x75, 0x6e, 0x52, 0x0f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x52, 0x75, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbe, 0x01, 0x0a,
	0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5d,
	0x0a, 0x0f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x22, 0x63, 0x0a,
	0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe0, 0x01, 0x0a, 0x27, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x64, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x28, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x6e, 0x0a, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x15, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x22, 0xac, 0x02, 0x0a, 0x22, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x1a, 0x74, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x49, 0x64, 0x12, 0x73, 0x0a, 0x17,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x74, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x22, 0x6e, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x9b, 0x02, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0xbb, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6e, 0x0a, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x15,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdb, 0x01,
	0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x73, 0x0a, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x71, 0x0a, 0x22, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd6,
	0x01, 0x0a, 0x29, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0b,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x52, 0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x58, 0x0a,
	0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x0a, 0x74, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x87, 0x01, 0x0a, 0x2a, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x22, 0xd7, 0x01, 0x0a, 0x24, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6f, 0x0a, 0x17, 0x74, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x15, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6d,
	0x61, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x82, 0x01, 0x0a, 0x25,
	0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x22, 0x94, 0x02, 0x0a, 0x25, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6e, 0x0a, 0x16, 0x74, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x15, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x7b, 0x0a, 0x17, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x14, 0x77, 0x72, 0x69, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x28, 0x0a, 0x26, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xdb, 0x01, 0x0a, 0x1e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52,
	0x0e, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x12,
	0x5e, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x22,
	0x21, 0x0a, 0x1f, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x88, 0x02, 0x0a, 0x26, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6f, 0x0a,
	0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x15, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xbe, 0x01,
	0x0a, 0x27, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6b, 0x0a, 0x17, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x52, 0x14, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a,
	0x01, 0x0a, 0x22, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8a, 0x01, 0x0a, 0x22,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0x87, 0x40, 0x0a, 0x12, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x83, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x93, 0x01, 0xca, 0x41, 0x31, 0x0a, 0x0b, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x12, 0x22, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x44, 0x3a, 0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x22, 0x35,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x73, 0x12, 0xbc, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x22, 0x44,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf1, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5c, 0xda, 0x41, 0x0b, 0x74,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48,
	0x12, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72,
	0x65, 0x61, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x94, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0xca, 0x41, 0x31, 0x0a, 0x0b,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x22, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a,
	0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x32, 0x41, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xcf, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x73, 0x12, 0xe6, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x77, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x02, 0x0a, 0x1b, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x9d, 0x01, 0xda, 0x41, 0x37, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x16, 0x74, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xe8, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x54,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x52,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xbc, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0x9f, 0x01, 0xda, 0x41, 0x22, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x74, 0x3a, 0x16, 0x74,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x5a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xfb, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x89, 0x02, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x2a, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x97, 0x02, 0x0a, 0x14,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x52, 0x75, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x52, 0x75, 0x6e, 0x22, 0x8f, 0x01, 0xda, 0x41, 0x29, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x2c,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x0f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x72, 0x75, 0x6e, 0x73, 0x12, 0x9a, 0x02, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x52, 0x75, 0x6e, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x73, 0xda,
	0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x3a, 0x01, 0x2a, 0x22, 0x56, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x12, 0xda, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x52, 0x75, 0x6e, 0x22, 0x59, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x99, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x22, 0x91, 0x01, 0xda, 0x41, 0x1b, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6d, 0x3a, 0x0f,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x32,
	0x5a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xed, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52,
	0x75, 0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5b,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x12,
	0x4a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x12, 0x82, 0x02, 0x0a, 0x14,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x52, 0x75, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4c, 0x2a, 0x4a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xba, 0x02, 0x0a, 0x20, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x80, 0x01, 0xda, 0x41, 0x0f,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x68, 0x3a, 0x01, 0x2a, 0x22, 0x63, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0xb6, 0x02,
	0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x99, 0x01, 0xda, 0x41, 0x1e,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x72, 0x3a, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x57, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0xfc, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x66, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59, 0x12, 0x57, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x22, 0xb7, 0x01, 0xda, 0x41, 0x23, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x8a, 0x01, 0x3a, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x32, 0x6f, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8c, 0x02, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x68, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x59, 0x12, 0x57, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x9d, 0x02, 0x0a, 0x1b,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x99, 0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x59, 0x2a, 0x57, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbb, 0x02, 0x0a, 0x22,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7c, 0xda, 0x41, 0x0b,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x68, 0x12, 0x66, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x3a,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x12, 0xc2, 0x02, 0x0a, 0x1d, 0x52, 0x65,
	0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x12, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x91, 0x01, 0xda, 0x41, 0x17,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x71, 0x12, 0x6f, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x12, 0xa2,
	0x02, 0x0a, 0x17, 0x52, 0x65, 0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x42, 0x6c, 0x6f, 0x62, 0x44, 0x61, 0x74, 0x61, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61,
	0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x42, 0x6c, 0x6f, 0x62,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x42, 0x6c, 0x6f,
	0x62, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x81, 0x01,
	0xda, 0x41, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x6d, 0x12, 0x6b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x42, 0x6c, 0x6f, 0x62, 0x44, 0x61, 0x74,
	0x61, 0x30, 0x01, 0x12, 0xcb, 0x02, 0x0a, 0x1e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x97, 0x01, 0xda, 0x41, 0x2e, 0x74, 0x65, 0x6e,
	0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x2c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x60, 0x3a, 0x01, 0x2a, 0x22, 0x5b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x12, 0xa8, 0x02, 0x0a, 0x17, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x52, 0x75, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x89, 0x01, 0xda, 0x41, 0x20, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x5f, 0x72, 0x75, 0x6e, 0x2c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x3a, 0x01, 0x2a, 0x22,
	0x5b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0xe4, 0x02, 0x0a,
	0x1f, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xad, 0x01, 0xda, 0x41, 0x17, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8c, 0x01, 0x3a, 0x01, 0x2a, 0x22, 0x86, 0x01, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0xee, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x17, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes = make([]protoimpl.MessageInfo, 47)
var file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_goTypes = []interface{}{
	(*CreateTensorboardRequest)(nil),                       // 0: google.cloud.aiplatform.v1beta1.CreateTensorboardRequest
	(*GetTensorboardRequest)(nil),                          // 1: google.cloud.aiplatform.v1beta1.GetTensorboardRequest
	(*ReadTensorboardUsageRequest)(nil),                    // 2: google.cloud.aiplatform.v1beta1.ReadTensorboardUsageRequest
	(*ReadTensorboardUsageResponse)(nil),                   // 3: google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse
	(*ListTensorboardsRequest)(nil),                        // 4: google.cloud.aiplatform.v1beta1.ListTensorboardsRequest
	(*ListTensorboardsResponse)(nil),                       // 5: google.cloud.aiplatform.v1beta1.ListTensorboardsResponse
	(*UpdateTensorboardRequest)(nil),                       // 6: google.cloud.aiplatform.v1beta1.UpdateTensorboardRequest
	(*DeleteTensorboardRequest)(nil),                       // 7: google.cloud.aiplatform.v1beta1.DeleteTensorboardRequest
	(*CreateTensorboardExperimentRequest)(nil),             // 8: google.cloud.aiplatform.v1beta1.CreateTensorboardExperimentRequest
	(*GetTensorboardExperimentRequest)(nil),                // 9: google.cloud.aiplatform.v1beta1.GetTensorboardExperimentRequest
	(*ListTensorboardExperimentsRequest)(nil),              // 10: google.cloud.aiplatform.v1beta1.ListTensorboardExperimentsRequest
	(*ListTensorboardExperimentsResponse)(nil),             // 11: google.cloud.aiplatform.v1beta1.ListTensorboardExperimentsResponse
	(*UpdateTensorboardExperimentRequest)(nil),             // 12: google.cloud.aiplatform.v1beta1.UpdateTensorboardExperimentRequest
	(*DeleteTensorboardExperimentRequest)(nil),             // 13: google.cloud.aiplatform.v1beta1.DeleteTensorboardExperimentRequest
	(*BatchCreateTensorboardRunsRequest)(nil),              // 14: google.cloud.aiplatform.v1beta1.BatchCreateTensorboardRunsRequest
	(*BatchCreateTensorboardRunsResponse)(nil),             // 15: google.cloud.aiplatform.v1beta1.BatchCreateTensorboardRunsResponse
	(*CreateTensorboardRunRequest)(nil),                    // 16: google.cloud.aiplatform.v1beta1.CreateTensorboardRunRequest
	(*GetTensorboardRunRequest)(nil),                       // 17: google.cloud.aiplatform.v1beta1.GetTensorboardRunRequest
	(*ReadTensorboardBlobDataRequest)(nil),                 // 18: google.cloud.aiplatform.v1beta1.ReadTensorboardBlobDataRequest
	(*ReadTensorboardBlobDataResponse)(nil),                // 19: google.cloud.aiplatform.v1beta1.ReadTensorboardBlobDataResponse
	(*ListTensorboardRunsRequest)(nil),                     // 20: google.cloud.aiplatform.v1beta1.ListTensorboardRunsRequest
	(*ListTensorboardRunsResponse)(nil),                    // 21: google.cloud.aiplatform.v1beta1.ListTensorboardRunsResponse
	(*UpdateTensorboardRunRequest)(nil),                    // 22: google.cloud.aiplatform.v1beta1.UpdateTensorboardRunRequest
	(*DeleteTensorboardRunRequest)(nil),                    // 23: google.cloud.aiplatform.v1beta1.DeleteTensorboardRunRequest
	(*BatchCreateTensorboardTimeSeriesRequest)(nil),        // 24: google.cloud.aiplatform.v1beta1.BatchCreateTensorboardTimeSeriesRequest
	(*BatchCreateTensorboardTimeSeriesResponse)(nil),       // 25: google.cloud.aiplatform.v1beta1.BatchCreateTensorboardTimeSeriesResponse
	(*CreateTensorboardTimeSeriesRequest)(nil),             // 26: google.cloud.aiplatform.v1beta1.CreateTensorboardTimeSeriesRequest
	(*GetTensorboardTimeSeriesRequest)(nil),                // 27: google.cloud.aiplatform.v1beta1.GetTensorboardTimeSeriesRequest
	(*ListTensorboardTimeSeriesRequest)(nil),               // 28: google.cloud.aiplatform.v1beta1.ListTensorboardTimeSeriesRequest
	(*ListTensorboardTimeSeriesResponse)(nil),              // 29: google.cloud.aiplatform.v1beta1.ListTensorboardTimeSeriesResponse
	(*UpdateTensorboardTimeSeriesRequest)(nil),             // 30: google.cloud.aiplatform.v1beta1.UpdateTensorboardTimeSeriesRequest
	(*DeleteTensorboardTimeSeriesRequest)(nil),             // 31: google.cloud.aiplatform.v1beta1.DeleteTensorboardTimeSeriesRequest
	(*BatchReadTensorboardTimeSeriesDataRequest)(nil),      // 32: google.cloud.aiplatform.v1beta1.BatchReadTensorboardTimeSeriesDataRequest
	(*BatchReadTensorboardTimeSeriesDataResponse)(nil),     // 33: google.cloud.aiplatform.v1beta1.BatchReadTensorboardTimeSeriesDataResponse
	(*ReadTensorboardTimeSeriesDataRequest)(nil),           // 34: google.cloud.aiplatform.v1beta1.ReadTensorboardTimeSeriesDataRequest
	(*ReadTensorboardTimeSeriesDataResponse)(nil),          // 35: google.cloud.aiplatform.v1beta1.ReadTensorboardTimeSeriesDataResponse
	(*WriteTensorboardExperimentDataRequest)(nil),          // 36: google.cloud.aiplatform.v1beta1.WriteTensorboardExperimentDataRequest
	(*WriteTensorboardExperimentDataResponse)(nil),         // 37: google.cloud.aiplatform.v1beta1.WriteTensorboardExperimentDataResponse
	(*WriteTensorboardRunDataRequest)(nil),                 // 38: google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
	(*WriteTensorboardRunDataResponse)(nil),                // 39: google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataResponse
	(*ExportTensorboardTimeSeriesDataRequest)(nil),         // 40: google.cloud.aiplatform.v1beta1.ExportTensorboardTimeSeriesDataRequest
	(*ExportTensorboardTimeSeriesDataResponse)(nil),        // 41: google.cloud.aiplatform.v1beta1.ExportTensorboardTimeSeriesDataResponse
	(*CreateTensorboardOperationMetadata)(nil),             // 42: google.cloud.aiplatform.v1beta1.CreateTensorboardOperationMetadata
	(*UpdateTensorboardOperationMetadata)(nil),             // 43: google.cloud.aiplatform.v1beta1.UpdateTensorboardOperationMetadata
	(*ReadTensorboardUsageResponse_PerUserUsageData)(nil),  // 44: google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.PerUserUsageData
	(*ReadTensorboardUsageResponse_PerMonthUsageData)(nil), // 45: google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.PerMonthUsageData
	nil,                              // 46: google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.MonthlyUsageDataEntry
	(*Tensorboard)(nil),              // 47: google.cloud.aiplatform.v1beta1.Tensorboard
	(*fieldmaskpb.FieldMask)(nil),    // 48: google.protobuf.FieldMask
	(*TensorboardExperiment)(nil),    // 49: google.cloud.aiplatform.v1beta1.TensorboardExperiment
	(*TensorboardRun)(nil),           // 50: google.cloud.aiplatform.v1beta1.TensorboardRun
	(*TensorboardBlob)(nil),          // 51: google.cloud.aiplatform.v1beta1.TensorboardBlob
	(*TensorboardTimeSeries)(nil),    // 52: google.cloud.aiplatform.v1beta1.TensorboardTimeSeries
	(*TimeSeriesData)(nil),           // 53: google.cloud.aiplatform.v1beta1.TimeSeriesData
	(*TimeSeriesDataPoint)(nil),      // 54: google.cloud.aiplatform.v1beta1.TimeSeriesDataPoint
	(*GenericOperationMetadata)(nil), // 55: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*longrunningpb.Operation)(nil),  // 56: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_depIdxs = []int32{
	47, // 0: google.cloud.aiplatform.v1beta1.CreateTensorboardRequest.tensorboard:type_name -> google.cloud.aiplatform.v1beta1.Tensorboard
	46, // 1: google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.monthly_usage_data:type_name -> google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.MonthlyUsageDataEntry
	48, // 2: google.cloud.aiplatform.v1beta1.ListTensorboardsRequest.read_mask:type_name -> google.protobuf.FieldMask
	47, // 3: google.cloud.aiplatform.v1beta1.ListTensorboardsResponse.tensorboards:type_name -> google.cloud.aiplatform.v1beta1.Tensorboard
	48, // 4: google.cloud.aiplatform.v1beta1.UpdateTensorboardRequest.update_mask:type_name -> google.protobuf.FieldMask
	47, // 5: google.cloud.aiplatform.v1beta1.UpdateTensorboardRequest.tensorboard:type_name -> google.cloud.aiplatform.v1beta1.Tensorboard
	49, // 6: google.cloud.aiplatform.v1beta1.CreateTensorboardExperimentRequest.tensorboard_experiment:type_name -> google.cloud.aiplatform.v1beta1.TensorboardExperiment
	48, // 7: google.cloud.aiplatform.v1beta1.ListTensorboardExperimentsRequest.read_mask:type_name -> google.protobuf.FieldMask
	49, // 8: google.cloud.aiplatform.v1beta1.ListTensorboardExperimentsResponse.tensorboard_experiments:type_name -> google.cloud.aiplatform.v1beta1.TensorboardExperiment
	48, // 9: google.cloud.aiplatform.v1beta1.UpdateTensorboardExperimentRequest.update_mask:type_name -> google.protobuf.FieldMask
	49, // 10: google.cloud.aiplatform.v1beta1.UpdateTensorboardExperimentRequest.tensorboard_experiment:type_name -> google.cloud.aiplatform.v1beta1.TensorboardExperiment
	16, // 11: google.cloud.aiplatform.v1beta1.BatchCreateTensorboardRunsRequest.requests:type_name -> google.cloud.aiplatform.v1beta1.CreateTensorboardRunRequest
	50, // 12: google.cloud.aiplatform.v1beta1.BatchCreateTensorboardRunsResponse.tensorboard_runs:type_name -> google.cloud.aiplatform.v1beta1.TensorboardRun
	50, // 13: google.cloud.aiplatform.v1beta1.CreateTensorboardRunRequest.tensorboard_run:type_name -> google.cloud.aiplatform.v1beta1.TensorboardRun
	51, // 14: google.cloud.aiplatform.v1beta1.ReadTensorboardBlobDataResponse.blobs:type_name -> google.cloud.aiplatform.v1beta1.TensorboardBlob
	48, // 15: google.cloud.aiplatform.v1beta1.ListTensorboardRunsRequest.read_mask:type_name -> google.protobuf.FieldMask
	50, // 16: google.cloud.aiplatform.v1beta1.ListTensorboardRunsResponse.tensorboard_runs:type_name -> google.cloud.aiplatform.v1beta1.TensorboardRun
	48, // 17: google.cloud.aiplatform.v1beta1.UpdateTensorboardRunRequest.update_mask:type_name -> google.protobuf.FieldMask
	50, // 18: google.cloud.aiplatform.v1beta1.UpdateTensorboardRunRequest.tensorboard_run:type_name -> google.cloud.aiplatform.v1beta1.TensorboardRun
	26, // 19: google.cloud.aiplatform.v1beta1.BatchCreateTensorboardTimeSeriesRequest.requests:type_name -> google.cloud.aiplatform.v1beta1.CreateTensorboardTimeSeriesRequest
	52, // 20: google.cloud.aiplatform.v1beta1.BatchCreateTensorboardTimeSeriesResponse.tensorboard_time_series:type_name -> google.cloud.aiplatform.v1beta1.TensorboardTimeSeries
	52, // 21: google.cloud.aiplatform.v1beta1.CreateTensorboardTimeSeriesRequest.tensorboard_time_series:type_name -> google.cloud.aiplatform.v1beta1.TensorboardTimeSeries
	48, // 22: google.cloud.aiplatform.v1beta1.ListTensorboardTimeSeriesRequest.read_mask:type_name -> google.protobuf.FieldMask
	52, // 23: google.cloud.aiplatform.v1beta1.ListTensorboardTimeSeriesResponse.tensorboard_time_series:type_name -> google.cloud.aiplatform.v1beta1.TensorboardTimeSeries
	48, // 24: google.cloud.aiplatform.v1beta1.UpdateTensorboardTimeSeriesRequest.update_mask:type_name -> google.protobuf.FieldMask
	52, // 25: google.cloud.aiplatform.v1beta1.UpdateTensorboardTimeSeriesRequest.tensorboard_time_series:type_name -> google.cloud.aiplatform.v1beta1.TensorboardTimeSeries
	53, // 26: google.cloud.aiplatform.v1beta1.BatchReadTensorboardTimeSeriesDataResponse.time_series_data:type_name -> google.cloud.aiplatform.v1beta1.TimeSeriesData
	53, // 27: google.cloud.aiplatform.v1beta1.ReadTensorboardTimeSeriesDataResponse.time_series_data:type_name -> google.cloud.aiplatform.v1beta1.TimeSeriesData
	38, // 28: google.cloud.aiplatform.v1beta1.WriteTensorboardExperimentDataRequest.write_run_data_requests:type_name -> google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
	53, // 29: google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest.time_series_data:type_name -> google.cloud.aiplatform.v1beta1.TimeSeriesData
	54, // 30: google.cloud.aiplatform.v1beta1.ExportTensorboardTimeSeriesDataResponse.time_series_data_points:type_name -> google.cloud.aiplatform.v1beta1.TimeSeriesDataPoint
	55, // 31: google.cloud.aiplatform.v1beta1.CreateTensorboardOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	55, // 32: google.cloud.aiplatform.v1beta1.UpdateTensorboardOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	44, // 33: google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.PerMonthUsageData.user_usage_data:type_name -> google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.PerUserUsageData
	45, // 34: google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.MonthlyUsageDataEntry.value:type_name -> google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse.PerMonthUsageData
	0,  // 35: google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboard:input_type -> google.cloud.aiplatform.v1beta1.CreateTensorboardRequest
	1,  // 36: google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboard:input_type -> google.cloud.aiplatform.v1beta1.GetTensorboardRequest
	2,  // 37: google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardUsage:input_type -> google.cloud.aiplatform.v1beta1.ReadTensorboardUsageRequest
	6,  // 38: google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboard:input_type -> google.cloud.aiplatform.v1beta1.UpdateTensorboardRequest
	4,  // 39: google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboards:input_type -> google.cloud.aiplatform.v1beta1.ListTensorboardsRequest
	7,  // 40: google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboard:input_type -> google.cloud.aiplatform.v1beta1.DeleteTensorboardRequest
	8,  // 41: google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardExperiment:input_type -> google.cloud.aiplatform.v1beta1.CreateTensorboardExperimentRequest
	9,  // 42: google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardExperiment:input_type -> google.cloud.aiplatform.v1beta1.GetTensorboardExperimentRequest
	12, // 43: google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardExperiment:input_type -> google.cloud.aiplatform.v1beta1.UpdateTensorboardExperimentRequest
	10, // 44: google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardExperiments:input_type -> google.cloud.aiplatform.v1beta1.ListTensorboardExperimentsRequest
	13, // 45: google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardExperiment:input_type -> google.cloud.aiplatform.v1beta1.DeleteTensorboardExperimentRequest
	16, // 46: google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardRun:input_type -> google.cloud.aiplatform.v1beta1.CreateTensorboardRunRequest
	14, // 47: google.cloud.aiplatform.v1beta1.TensorboardService.BatchCreateTensorboardRuns:input_type -> google.cloud.aiplatform.v1beta1.BatchCreateTensorboardRunsRequest
	17, // 48: google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardRun:input_type -> google.cloud.aiplatform.v1beta1.GetTensorboardRunRequest
	22, // 49: google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardRun:input_type -> google.cloud.aiplatform.v1beta1.UpdateTensorboardRunRequest
	20, // 50: google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardRuns:input_type -> google.cloud.aiplatform.v1beta1.ListTensorboardRunsRequest
	23, // 51: google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardRun:input_type -> google.cloud.aiplatform.v1beta1.DeleteTensorboardRunRequest
	24, // 52: google.cloud.aiplatform.v1beta1.TensorboardService.BatchCreateTensorboardTimeSeries:input_type -> google.cloud.aiplatform.v1beta1.BatchCreateTensorboardTimeSeriesRequest
	26, // 53: google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardTimeSeries:input_type -> google.cloud.aiplatform.v1beta1.CreateTensorboardTimeSeriesRequest
	27, // 54: google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardTimeSeries:input_type -> google.cloud.aiplatform.v1beta1.GetTensorboardTimeSeriesRequest
	30, // 55: google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardTimeSeries:input_type -> google.cloud.aiplatform.v1beta1.UpdateTensorboardTimeSeriesRequest
	28, // 56: google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardTimeSeries:input_type -> google.cloud.aiplatform.v1beta1.ListTensorboardTimeSeriesRequest
	31, // 57: google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardTimeSeries:input_type -> google.cloud.aiplatform.v1beta1.DeleteTensorboardTimeSeriesRequest
	32, // 58: google.cloud.aiplatform.v1beta1.TensorboardService.BatchReadTensorboardTimeSeriesData:input_type -> google.cloud.aiplatform.v1beta1.BatchReadTensorboardTimeSeriesDataRequest
	34, // 59: google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardTimeSeriesData:input_type -> google.cloud.aiplatform.v1beta1.ReadTensorboardTimeSeriesDataRequest
	18, // 60: google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardBlobData:input_type -> google.cloud.aiplatform.v1beta1.ReadTensorboardBlobDataRequest
	36, // 61: google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardExperimentData:input_type -> google.cloud.aiplatform.v1beta1.WriteTensorboardExperimentDataRequest
	38, // 62: google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardRunData:input_type -> google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataRequest
	40, // 63: google.cloud.aiplatform.v1beta1.TensorboardService.ExportTensorboardTimeSeriesData:input_type -> google.cloud.aiplatform.v1beta1.ExportTensorboardTimeSeriesDataRequest
	56, // 64: google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboard:output_type -> google.longrunning.Operation
	47, // 65: google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboard:output_type -> google.cloud.aiplatform.v1beta1.Tensorboard
	3,  // 66: google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardUsage:output_type -> google.cloud.aiplatform.v1beta1.ReadTensorboardUsageResponse
	56, // 67: google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboard:output_type -> google.longrunning.Operation
	5,  // 68: google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboards:output_type -> google.cloud.aiplatform.v1beta1.ListTensorboardsResponse
	56, // 69: google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboard:output_type -> google.longrunning.Operation
	49, // 70: google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardExperiment:output_type -> google.cloud.aiplatform.v1beta1.TensorboardExperiment
	49, // 71: google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardExperiment:output_type -> google.cloud.aiplatform.v1beta1.TensorboardExperiment
	49, // 72: google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardExperiment:output_type -> google.cloud.aiplatform.v1beta1.TensorboardExperiment
	11, // 73: google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardExperiments:output_type -> google.cloud.aiplatform.v1beta1.ListTensorboardExperimentsResponse
	56, // 74: google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardExperiment:output_type -> google.longrunning.Operation
	50, // 75: google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardRun:output_type -> google.cloud.aiplatform.v1beta1.TensorboardRun
	15, // 76: google.cloud.aiplatform.v1beta1.TensorboardService.BatchCreateTensorboardRuns:output_type -> google.cloud.aiplatform.v1beta1.BatchCreateTensorboardRunsResponse
	50, // 77: google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardRun:output_type -> google.cloud.aiplatform.v1beta1.TensorboardRun
	50, // 78: google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardRun:output_type -> google.cloud.aiplatform.v1beta1.TensorboardRun
	21, // 79: google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardRuns:output_type -> google.cloud.aiplatform.v1beta1.ListTensorboardRunsResponse
	56, // 80: google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardRun:output_type -> google.longrunning.Operation
	25, // 81: google.cloud.aiplatform.v1beta1.TensorboardService.BatchCreateTensorboardTimeSeries:output_type -> google.cloud.aiplatform.v1beta1.BatchCreateTensorboardTimeSeriesResponse
	52, // 82: google.cloud.aiplatform.v1beta1.TensorboardService.CreateTensorboardTimeSeries:output_type -> google.cloud.aiplatform.v1beta1.TensorboardTimeSeries
	52, // 83: google.cloud.aiplatform.v1beta1.TensorboardService.GetTensorboardTimeSeries:output_type -> google.cloud.aiplatform.v1beta1.TensorboardTimeSeries
	52, // 84: google.cloud.aiplatform.v1beta1.TensorboardService.UpdateTensorboardTimeSeries:output_type -> google.cloud.aiplatform.v1beta1.TensorboardTimeSeries
	29, // 85: google.cloud.aiplatform.v1beta1.TensorboardService.ListTensorboardTimeSeries:output_type -> google.cloud.aiplatform.v1beta1.ListTensorboardTimeSeriesResponse
	56, // 86: google.cloud.aiplatform.v1beta1.TensorboardService.DeleteTensorboardTimeSeries:output_type -> google.longrunning.Operation
	33, // 87: google.cloud.aiplatform.v1beta1.TensorboardService.BatchReadTensorboardTimeSeriesData:output_type -> google.cloud.aiplatform.v1beta1.BatchReadTensorboardTimeSeriesDataResponse
	35, // 88: google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardTimeSeriesData:output_type -> google.cloud.aiplatform.v1beta1.ReadTensorboardTimeSeriesDataResponse
	19, // 89: google.cloud.aiplatform.v1beta1.TensorboardService.ReadTensorboardBlobData:output_type -> google.cloud.aiplatform.v1beta1.ReadTensorboardBlobDataResponse
	37, // 90: google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardExperimentData:output_type -> google.cloud.aiplatform.v1beta1.WriteTensorboardExperimentDataResponse
	39, // 91: google.cloud.aiplatform.v1beta1.TensorboardService.WriteTensorboardRunData:output_type -> google.cloud.aiplatform.v1beta1.WriteTensorboardRunDataResponse
	41, // 92: google.cloud.aiplatform.v1beta1.TensorboardService.ExportTensorboardTimeSeriesData:output_type -> google.cloud.aiplatform.v1beta1.ExportTensorboardTimeSeriesDataResponse
	64, // [64:93] is the sub-list for method output_type
	35, // [35:64] is the sub-list for method input_type
	35, // [35:35] is the sub-list for extension type_name
	35, // [35:35] is the sub-list for extension extendee
	0,  // [0:35] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_tensorboard_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	file_google_cloud_aiplatform_v1beta1_tensorboard_proto_init()
	file_google_cloud_aiplatform_v1beta1_tensorboard_data_proto_init()
	file_google_cloud_aiplatform_v1beta1_tensorboard_experiment_proto_init()
	file_google_cloud_aiplatform_v1beta1_tensorboard_run_proto_init()
	file_google_cloud_aiplatform_v1beta1_tensorboard_time_series_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTensorboardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTensorboardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTensorboardUsageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTensorboardUsageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorboardsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorboardsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTensorboardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTensorboardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTensorboardExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTensorboardExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorboardExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorboardExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTensorboardExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTensorboardExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateTensorboardRunsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateTensorboardRunsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTensorboardRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTensorboardRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTensorboardBlobDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTensorboardBlobDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorboardRunsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorboardRunsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTensorboardRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTensorboardRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateTensorboardTimeSeriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateTensorboardTimeSeriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTensorboardTimeSeriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTensorboardTimeSeriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorboardTimeSeriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTensorboardTimeSeriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTensorboardTimeSeriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTensorboardTimeSeriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchReadTensorboardTimeSeriesDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchReadTensorboardTimeSeriesDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTensorboardTimeSeriesDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTensorboardTimeSeriesDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteTensorboardExperimentDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteTensorboardExperimentDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteTensorboardRunDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteTensorboardRunDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportTensorboardTimeSeriesDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportTensorboardTimeSeriesDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTensorboardOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTensorboardOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTensorboardUsageResponse_PerUserUsageData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadTensorboardUsageResponse_PerMonthUsageData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   47,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_tensorboard_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_tensorboard_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TensorboardServiceClient is the client API for TensorboardService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TensorboardServiceClient interface {
	// Creates a Tensorboard.
	CreateTensorboard(ctx context.Context, in *CreateTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Tensorboard.
	GetTensorboard(ctx context.Context, in *GetTensorboardRequest, opts ...grpc.CallOption) (*Tensorboard, error)
	// Returns a list of monthly active users for a given TensorBoard instance.
	ReadTensorboardUsage(ctx context.Context, in *ReadTensorboardUsageRequest, opts ...grpc.CallOption) (*ReadTensorboardUsageResponse, error)
	// Updates a Tensorboard.
	UpdateTensorboard(ctx context.Context, in *UpdateTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Tensorboards in a Location.
	ListTensorboards(ctx context.Context, in *ListTensorboardsRequest, opts ...grpc.CallOption) (*ListTensorboardsResponse, error)
	// Deletes a Tensorboard.
	DeleteTensorboard(ctx context.Context, in *DeleteTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a TensorboardExperiment.
	CreateTensorboardExperiment(ctx context.Context, in *CreateTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error)
	// Gets a TensorboardExperiment.
	GetTensorboardExperiment(ctx context.Context, in *GetTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error)
	// Updates a TensorboardExperiment.
	UpdateTensorboardExperiment(ctx context.Context, in *UpdateTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error)
	// Lists TensorboardExperiments in a Location.
	ListTensorboardExperiments(ctx context.Context, in *ListTensorboardExperimentsRequest, opts ...grpc.CallOption) (*ListTensorboardExperimentsResponse, error)
	// Deletes a TensorboardExperiment.
	DeleteTensorboardExperiment(ctx context.Context, in *DeleteTensorboardExperimentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a TensorboardRun.
	CreateTensorboardRun(ctx context.Context, in *CreateTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error)
	// Batch create TensorboardRuns.
	BatchCreateTensorboardRuns(ctx context.Context, in *BatchCreateTensorboardRunsRequest, opts ...grpc.CallOption) (*BatchCreateTensorboardRunsResponse, error)
	// Gets a TensorboardRun.
	GetTensorboardRun(ctx context.Context, in *GetTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error)
	// Updates a TensorboardRun.
	UpdateTensorboardRun(ctx context.Context, in *UpdateTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error)
	// Lists TensorboardRuns in a Location.
	ListTensorboardRuns(ctx context.Context, in *ListTensorboardRunsRequest, opts ...grpc.CallOption) (*ListTensorboardRunsResponse, error)
	// Deletes a TensorboardRun.
	DeleteTensorboardRun(ctx context.Context, in *DeleteTensorboardRunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
	BatchCreateTensorboardTimeSeries(ctx context.Context, in *BatchCreateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*BatchCreateTensorboardTimeSeriesResponse, error)
	// Creates a TensorboardTimeSeries.
	CreateTensorboardTimeSeries(ctx context.Context, in *CreateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error)
	// Gets a TensorboardTimeSeries.
	GetTensorboardTimeSeries(ctx context.Context, in *GetTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error)
	// Updates a TensorboardTimeSeries.
	UpdateTensorboardTimeSeries(ctx context.Context, in *UpdateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error)
	// Lists TensorboardTimeSeries in a Location.
	ListTensorboardTimeSeries(ctx context.Context, in *ListTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*ListTensorboardTimeSeriesResponse, error)
	// Deletes a TensorboardTimeSeries.
	DeleteTensorboardTimeSeries(ctx context.Context, in *DeleteTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Reads multiple TensorboardTimeSeries' data. The data point number limit is
	// 1000 for scalars, 100 for tensors and blob references. If the number of
	// data points stored is less than the limit, all data is returned.
	// Otherwise, the number limit of data points is randomly selected from
	// this time series and returned.
	BatchReadTensorboardTimeSeriesData(ctx context.Context, in *BatchReadTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*BatchReadTensorboardTimeSeriesDataResponse, error)
	// Reads a TensorboardTimeSeries' data. By default, if the number of data
	// points stored is less than 1000, all data is returned. Otherwise, 1000
	// data points is randomly selected from this time series and returned.
	// This value can be changed by changing max_data_points, which can't be
	// greater than 10k.
	ReadTensorboardTimeSeriesData(ctx context.Context, in *ReadTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*ReadTensorboardTimeSeriesDataResponse, error)
	// Gets bytes of TensorboardBlobs.
	// This is to allow reading blob data stored in consumer project's Cloud
	// Storage bucket without users having to obtain Cloud Storage access
	// permission.
	ReadTensorboardBlobData(ctx context.Context, in *ReadTensorboardBlobDataRequest, opts ...grpc.CallOption) (TensorboardService_ReadTensorboardBlobDataClient, error)
	// Write time series data points of multiple TensorboardTimeSeries in multiple
	// TensorboardRun's. If any data fail to be ingested, an error is returned.
	WriteTensorboardExperimentData(ctx context.Context, in *WriteTensorboardExperimentDataRequest, opts ...grpc.CallOption) (*WriteTensorboardExperimentDataResponse, error)
	// Write time series data points into multiple TensorboardTimeSeries under
	// a TensorboardRun. If any data fail to be ingested, an error is returned.
	WriteTensorboardRunData(ctx context.Context, in *WriteTensorboardRunDataRequest, opts ...grpc.CallOption) (*WriteTensorboardRunDataResponse, error)
	// Exports a TensorboardTimeSeries' data. Data is returned in paginated
	// responses.
	ExportTensorboardTimeSeriesData(ctx context.Context, in *ExportTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*ExportTensorboardTimeSeriesDataResponse, error)
}

type tensorboardServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTensorboardServiceClient(cc grpc.ClientConnInterface) TensorboardServiceClient {
	return &tensorboardServiceClient{cc}
}

func (c *tensorboardServiceClient) CreateTensorboard(ctx context.Context, in *CreateTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) GetTensorboard(ctx context.Context, in *GetTensorboardRequest, opts ...grpc.CallOption) (*Tensorboard, error) {
	out := new(Tensorboard)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ReadTensorboardUsage(ctx context.Context, in *ReadTensorboardUsageRequest, opts ...grpc.CallOption) (*ReadTensorboardUsageResponse, error) {
	out := new(ReadTensorboardUsageResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardUsage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) UpdateTensorboard(ctx context.Context, in *UpdateTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ListTensorboards(ctx context.Context, in *ListTensorboardsRequest, opts ...grpc.CallOption) (*ListTensorboardsResponse, error) {
	out := new(ListTensorboardsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboards", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) DeleteTensorboard(ctx context.Context, in *DeleteTensorboardRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboard", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) CreateTensorboardExperiment(ctx context.Context, in *CreateTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error) {
	out := new(TensorboardExperiment)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) GetTensorboardExperiment(ctx context.Context, in *GetTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error) {
	out := new(TensorboardExperiment)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) UpdateTensorboardExperiment(ctx context.Context, in *UpdateTensorboardExperimentRequest, opts ...grpc.CallOption) (*TensorboardExperiment, error) {
	out := new(TensorboardExperiment)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ListTensorboardExperiments(ctx context.Context, in *ListTensorboardExperimentsRequest, opts ...grpc.CallOption) (*ListTensorboardExperimentsResponse, error) {
	out := new(ListTensorboardExperimentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardExperiments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) DeleteTensorboardExperiment(ctx context.Context, in *DeleteTensorboardExperimentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) CreateTensorboardRun(ctx context.Context, in *CreateTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error) {
	out := new(TensorboardRun)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) BatchCreateTensorboardRuns(ctx context.Context, in *BatchCreateTensorboardRunsRequest, opts ...grpc.CallOption) (*BatchCreateTensorboardRunsResponse, error) {
	out := new(BatchCreateTensorboardRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchCreateTensorboardRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) GetTensorboardRun(ctx context.Context, in *GetTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error) {
	out := new(TensorboardRun)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) UpdateTensorboardRun(ctx context.Context, in *UpdateTensorboardRunRequest, opts ...grpc.CallOption) (*TensorboardRun, error) {
	out := new(TensorboardRun)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ListTensorboardRuns(ctx context.Context, in *ListTensorboardRunsRequest, opts ...grpc.CallOption) (*ListTensorboardRunsResponse, error) {
	out := new(ListTensorboardRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) DeleteTensorboardRun(ctx context.Context, in *DeleteTensorboardRunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) BatchCreateTensorboardTimeSeries(ctx context.Context, in *BatchCreateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*BatchCreateTensorboardTimeSeriesResponse, error) {
	out := new(BatchCreateTensorboardTimeSeriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchCreateTensorboardTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) CreateTensorboardTimeSeries(ctx context.Context, in *CreateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error) {
	out := new(TensorboardTimeSeries)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) GetTensorboardTimeSeries(ctx context.Context, in *GetTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error) {
	out := new(TensorboardTimeSeries)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) UpdateTensorboardTimeSeries(ctx context.Context, in *UpdateTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*TensorboardTimeSeries, error) {
	out := new(TensorboardTimeSeries)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ListTensorboardTimeSeries(ctx context.Context, in *ListTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*ListTensorboardTimeSeriesResponse, error) {
	out := new(ListTensorboardTimeSeriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) DeleteTensorboardTimeSeries(ctx context.Context, in *DeleteTensorboardTimeSeriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardTimeSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) BatchReadTensorboardTimeSeriesData(ctx context.Context, in *BatchReadTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*BatchReadTensorboardTimeSeriesDataResponse, error) {
	out := new(BatchReadTensorboardTimeSeriesDataResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchReadTensorboardTimeSeriesData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ReadTensorboardTimeSeriesData(ctx context.Context, in *ReadTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*ReadTensorboardTimeSeriesDataResponse, error) {
	out := new(ReadTensorboardTimeSeriesDataResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardTimeSeriesData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ReadTensorboardBlobData(ctx context.Context, in *ReadTensorboardBlobDataRequest, opts ...grpc.CallOption) (TensorboardService_ReadTensorboardBlobDataClient, error) {
	stream, err := c.cc.NewStream(ctx, &_TensorboardService_serviceDesc.Streams[0], "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardBlobData", opts...)
	if err != nil {
		return nil, err
	}
	x := &tensorboardServiceReadTensorboardBlobDataClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TensorboardService_ReadTensorboardBlobDataClient interface {
	Recv() (*ReadTensorboardBlobDataResponse, error)
	grpc.ClientStream
}

type tensorboardServiceReadTensorboardBlobDataClient struct {
	grpc.ClientStream
}

func (x *tensorboardServiceReadTensorboardBlobDataClient) Recv() (*ReadTensorboardBlobDataResponse, error) {
	m := new(ReadTensorboardBlobDataResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *tensorboardServiceClient) WriteTensorboardExperimentData(ctx context.Context, in *WriteTensorboardExperimentDataRequest, opts ...grpc.CallOption) (*WriteTensorboardExperimentDataResponse, error) {
	out := new(WriteTensorboardExperimentDataResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/WriteTensorboardExperimentData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) WriteTensorboardRunData(ctx context.Context, in *WriteTensorboardRunDataRequest, opts ...grpc.CallOption) (*WriteTensorboardRunDataResponse, error) {
	out := new(WriteTensorboardRunDataResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/WriteTensorboardRunData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tensorboardServiceClient) ExportTensorboardTimeSeriesData(ctx context.Context, in *ExportTensorboardTimeSeriesDataRequest, opts ...grpc.CallOption) (*ExportTensorboardTimeSeriesDataResponse, error) {
	out := new(ExportTensorboardTimeSeriesDataResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.TensorboardService/ExportTensorboardTimeSeriesData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TensorboardServiceServer is the server API for TensorboardService service.
type TensorboardServiceServer interface {
	// Creates a Tensorboard.
	CreateTensorboard(context.Context, *CreateTensorboardRequest) (*longrunningpb.Operation, error)
	// Gets a Tensorboard.
	GetTensorboard(context.Context, *GetTensorboardRequest) (*Tensorboard, error)
	// Returns a list of monthly active users for a given TensorBoard instance.
	ReadTensorboardUsage(context.Context, *ReadTensorboardUsageRequest) (*ReadTensorboardUsageResponse, error)
	// Updates a Tensorboard.
	UpdateTensorboard(context.Context, *UpdateTensorboardRequest) (*longrunningpb.Operation, error)
	// Lists Tensorboards in a Location.
	ListTensorboards(context.Context, *ListTensorboardsRequest) (*ListTensorboardsResponse, error)
	// Deletes a Tensorboard.
	DeleteTensorboard(context.Context, *DeleteTensorboardRequest) (*longrunningpb.Operation, error)
	// Creates a TensorboardExperiment.
	CreateTensorboardExperiment(context.Context, *CreateTensorboardExperimentRequest) (*TensorboardExperiment, error)
	// Gets a TensorboardExperiment.
	GetTensorboardExperiment(context.Context, *GetTensorboardExperimentRequest) (*TensorboardExperiment, error)
	// Updates a TensorboardExperiment.
	UpdateTensorboardExperiment(context.Context, *UpdateTensorboardExperimentRequest) (*TensorboardExperiment, error)
	// Lists TensorboardExperiments in a Location.
	ListTensorboardExperiments(context.Context, *ListTensorboardExperimentsRequest) (*ListTensorboardExperimentsResponse, error)
	// Deletes a TensorboardExperiment.
	DeleteTensorboardExperiment(context.Context, *DeleteTensorboardExperimentRequest) (*longrunningpb.Operation, error)
	// Creates a TensorboardRun.
	CreateTensorboardRun(context.Context, *CreateTensorboardRunRequest) (*TensorboardRun, error)
	// Batch create TensorboardRuns.
	BatchCreateTensorboardRuns(context.Context, *BatchCreateTensorboardRunsRequest) (*BatchCreateTensorboardRunsResponse, error)
	// Gets a TensorboardRun.
	GetTensorboardRun(context.Context, *GetTensorboardRunRequest) (*TensorboardRun, error)
	// Updates a TensorboardRun.
	UpdateTensorboardRun(context.Context, *UpdateTensorboardRunRequest) (*TensorboardRun, error)
	// Lists TensorboardRuns in a Location.
	ListTensorboardRuns(context.Context, *ListTensorboardRunsRequest) (*ListTensorboardRunsResponse, error)
	// Deletes a TensorboardRun.
	DeleteTensorboardRun(context.Context, *DeleteTensorboardRunRequest) (*longrunningpb.Operation, error)
	// Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
	BatchCreateTensorboardTimeSeries(context.Context, *BatchCreateTensorboardTimeSeriesRequest) (*BatchCreateTensorboardTimeSeriesResponse, error)
	// Creates a TensorboardTimeSeries.
	CreateTensorboardTimeSeries(context.Context, *CreateTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error)
	// Gets a TensorboardTimeSeries.
	GetTensorboardTimeSeries(context.Context, *GetTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error)
	// Updates a TensorboardTimeSeries.
	UpdateTensorboardTimeSeries(context.Context, *UpdateTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error)
	// Lists TensorboardTimeSeries in a Location.
	ListTensorboardTimeSeries(context.Context, *ListTensorboardTimeSeriesRequest) (*ListTensorboardTimeSeriesResponse, error)
	// Deletes a TensorboardTimeSeries.
	DeleteTensorboardTimeSeries(context.Context, *DeleteTensorboardTimeSeriesRequest) (*longrunningpb.Operation, error)
	// Reads multiple TensorboardTimeSeries' data. The data point number limit is
	// 1000 for scalars, 100 for tensors and blob references. If the number of
	// data points stored is less than the limit, all data is returned.
	// Otherwise, the number limit of data points is randomly selected from
	// this time series and returned.
	BatchReadTensorboardTimeSeriesData(context.Context, *BatchReadTensorboardTimeSeriesDataRequest) (*BatchReadTensorboardTimeSeriesDataResponse, error)
	// Reads a TensorboardTimeSeries' data. By default, if the number of data
	// points stored is less than 1000, all data is returned. Otherwise, 1000
	// data points is randomly selected from this time series and returned.
	// This value can be changed by changing max_data_points, which can't be
	// greater than 10k.
	ReadTensorboardTimeSeriesData(context.Context, *ReadTensorboardTimeSeriesDataRequest) (*ReadTensorboardTimeSeriesDataResponse, error)
	// Gets bytes of TensorboardBlobs.
	// This is to allow reading blob data stored in consumer project's Cloud
	// Storage bucket without users having to obtain Cloud Storage access
	// permission.
	ReadTensorboardBlobData(*ReadTensorboardBlobDataRequest, TensorboardService_ReadTensorboardBlobDataServer) error
	// Write time series data points of multiple TensorboardTimeSeries in multiple
	// TensorboardRun's. If any data fail to be ingested, an error is returned.
	WriteTensorboardExperimentData(context.Context, *WriteTensorboardExperimentDataRequest) (*WriteTensorboardExperimentDataResponse, error)
	// Write time series data points into multiple TensorboardTimeSeries under
	// a TensorboardRun. If any data fail to be ingested, an error is returned.
	WriteTensorboardRunData(context.Context, *WriteTensorboardRunDataRequest) (*WriteTensorboardRunDataResponse, error)
	// Exports a TensorboardTimeSeries' data. Data is returned in paginated
	// responses.
	ExportTensorboardTimeSeriesData(context.Context, *ExportTensorboardTimeSeriesDataRequest) (*ExportTensorboardTimeSeriesDataResponse, error)
}

// UnimplementedTensorboardServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTensorboardServiceServer struct {
}

func (*UnimplementedTensorboardServiceServer) CreateTensorboard(context.Context, *CreateTensorboardRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTensorboard not implemented")
}
func (*UnimplementedTensorboardServiceServer) GetTensorboard(context.Context, *GetTensorboardRequest) (*Tensorboard, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorboard not implemented")
}
func (*UnimplementedTensorboardServiceServer) ReadTensorboardUsage(context.Context, *ReadTensorboardUsageRequest) (*ReadTensorboardUsageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadTensorboardUsage not implemented")
}
func (*UnimplementedTensorboardServiceServer) UpdateTensorboard(context.Context, *UpdateTensorboardRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTensorboard not implemented")
}
func (*UnimplementedTensorboardServiceServer) ListTensorboards(context.Context, *ListTensorboardsRequest) (*ListTensorboardsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorboards not implemented")
}
func (*UnimplementedTensorboardServiceServer) DeleteTensorboard(context.Context, *DeleteTensorboardRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTensorboard not implemented")
}
func (*UnimplementedTensorboardServiceServer) CreateTensorboardExperiment(context.Context, *CreateTensorboardExperimentRequest) (*TensorboardExperiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTensorboardExperiment not implemented")
}
func (*UnimplementedTensorboardServiceServer) GetTensorboardExperiment(context.Context, *GetTensorboardExperimentRequest) (*TensorboardExperiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorboardExperiment not implemented")
}
func (*UnimplementedTensorboardServiceServer) UpdateTensorboardExperiment(context.Context, *UpdateTensorboardExperimentRequest) (*TensorboardExperiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTensorboardExperiment not implemented")
}
func (*UnimplementedTensorboardServiceServer) ListTensorboardExperiments(context.Context, *ListTensorboardExperimentsRequest) (*ListTensorboardExperimentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorboardExperiments not implemented")
}
func (*UnimplementedTensorboardServiceServer) DeleteTensorboardExperiment(context.Context, *DeleteTensorboardExperimentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTensorboardExperiment not implemented")
}
func (*UnimplementedTensorboardServiceServer) CreateTensorboardRun(context.Context, *CreateTensorboardRunRequest) (*TensorboardRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTensorboardRun not implemented")
}
func (*UnimplementedTensorboardServiceServer) BatchCreateTensorboardRuns(context.Context, *BatchCreateTensorboardRunsRequest) (*BatchCreateTensorboardRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateTensorboardRuns not implemented")
}
func (*UnimplementedTensorboardServiceServer) GetTensorboardRun(context.Context, *GetTensorboardRunRequest) (*TensorboardRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorboardRun not implemented")
}
func (*UnimplementedTensorboardServiceServer) UpdateTensorboardRun(context.Context, *UpdateTensorboardRunRequest) (*TensorboardRun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTensorboardRun not implemented")
}
func (*UnimplementedTensorboardServiceServer) ListTensorboardRuns(context.Context, *ListTensorboardRunsRequest) (*ListTensorboardRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorboardRuns not implemented")
}
func (*UnimplementedTensorboardServiceServer) DeleteTensorboardRun(context.Context, *DeleteTensorboardRunRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTensorboardRun not implemented")
}
func (*UnimplementedTensorboardServiceServer) BatchCreateTensorboardTimeSeries(context.Context, *BatchCreateTensorboardTimeSeriesRequest) (*BatchCreateTensorboardTimeSeriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateTensorboardTimeSeries not implemented")
}
func (*UnimplementedTensorboardServiceServer) CreateTensorboardTimeSeries(context.Context, *CreateTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTensorboardTimeSeries not implemented")
}
func (*UnimplementedTensorboardServiceServer) GetTensorboardTimeSeries(context.Context, *GetTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorboardTimeSeries not implemented")
}
func (*UnimplementedTensorboardServiceServer) UpdateTensorboardTimeSeries(context.Context, *UpdateTensorboardTimeSeriesRequest) (*TensorboardTimeSeries, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTensorboardTimeSeries not implemented")
}
func (*UnimplementedTensorboardServiceServer) ListTensorboardTimeSeries(context.Context, *ListTensorboardTimeSeriesRequest) (*ListTensorboardTimeSeriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorboardTimeSeries not implemented")
}
func (*UnimplementedTensorboardServiceServer) DeleteTensorboardTimeSeries(context.Context, *DeleteTensorboardTimeSeriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTensorboardTimeSeries not implemented")
}
func (*UnimplementedTensorboardServiceServer) BatchReadTensorboardTimeSeriesData(context.Context, *BatchReadTensorboardTimeSeriesDataRequest) (*BatchReadTensorboardTimeSeriesDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchReadTensorboardTimeSeriesData not implemented")
}
func (*UnimplementedTensorboardServiceServer) ReadTensorboardTimeSeriesData(context.Context, *ReadTensorboardTimeSeriesDataRequest) (*ReadTensorboardTimeSeriesDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadTensorboardTimeSeriesData not implemented")
}
func (*UnimplementedTensorboardServiceServer) ReadTensorboardBlobData(*ReadTensorboardBlobDataRequest, TensorboardService_ReadTensorboardBlobDataServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadTensorboardBlobData not implemented")
}
func (*UnimplementedTensorboardServiceServer) WriteTensorboardExperimentData(context.Context, *WriteTensorboardExperimentDataRequest) (*WriteTensorboardExperimentDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteTensorboardExperimentData not implemented")
}
func (*UnimplementedTensorboardServiceServer) WriteTensorboardRunData(context.Context, *WriteTensorboardRunDataRequest) (*WriteTensorboardRunDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteTensorboardRunData not implemented")
}
func (*UnimplementedTensorboardServiceServer) ExportTensorboardTimeSeriesData(context.Context, *ExportTensorboardTimeSeriesDataRequest) (*ExportTensorboardTimeSeriesDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportTensorboardTimeSeriesData not implemented")
}

func RegisterTensorboardServiceServer(s *grpc.Server, srv TensorboardServiceServer) {
	s.RegisterService(&_TensorboardService_serviceDesc, srv)
}

func _TensorboardService_CreateTensorboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTensorboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).CreateTensorboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).CreateTensorboard(ctx, req.(*CreateTensorboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_GetTensorboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).GetTensorboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).GetTensorboard(ctx, req.(*GetTensorboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ReadTensorboardUsage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadTensorboardUsageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ReadTensorboardUsage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardUsage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ReadTensorboardUsage(ctx, req.(*ReadTensorboardUsageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_UpdateTensorboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTensorboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).UpdateTensorboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).UpdateTensorboard(ctx, req.(*UpdateTensorboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ListTensorboards_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorboardsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ListTensorboards(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboards",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ListTensorboards(ctx, req.(*ListTensorboardsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_DeleteTensorboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTensorboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).DeleteTensorboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).DeleteTensorboard(ctx, req.(*DeleteTensorboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_CreateTensorboardExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTensorboardExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).CreateTensorboardExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).CreateTensorboardExperiment(ctx, req.(*CreateTensorboardExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_GetTensorboardExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorboardExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).GetTensorboardExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).GetTensorboardExperiment(ctx, req.(*GetTensorboardExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_UpdateTensorboardExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTensorboardExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).UpdateTensorboardExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).UpdateTensorboardExperiment(ctx, req.(*UpdateTensorboardExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ListTensorboardExperiments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorboardExperimentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ListTensorboardExperiments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardExperiments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ListTensorboardExperiments(ctx, req.(*ListTensorboardExperimentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_DeleteTensorboardExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTensorboardExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).DeleteTensorboardExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).DeleteTensorboardExperiment(ctx, req.(*DeleteTensorboardExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_CreateTensorboardRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTensorboardRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).CreateTensorboardRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).CreateTensorboardRun(ctx, req.(*CreateTensorboardRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_BatchCreateTensorboardRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateTensorboardRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).BatchCreateTensorboardRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchCreateTensorboardRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).BatchCreateTensorboardRuns(ctx, req.(*BatchCreateTensorboardRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_GetTensorboardRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorboardRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).GetTensorboardRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).GetTensorboardRun(ctx, req.(*GetTensorboardRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_UpdateTensorboardRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTensorboardRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).UpdateTensorboardRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).UpdateTensorboardRun(ctx, req.(*UpdateTensorboardRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ListTensorboardRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorboardRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ListTensorboardRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ListTensorboardRuns(ctx, req.(*ListTensorboardRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_DeleteTensorboardRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTensorboardRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).DeleteTensorboardRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).DeleteTensorboardRun(ctx, req.(*DeleteTensorboardRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_BatchCreateTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).BatchCreateTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchCreateTensorboardTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).BatchCreateTensorboardTimeSeries(ctx, req.(*BatchCreateTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_CreateTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).CreateTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/CreateTensorboardTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).CreateTensorboardTimeSeries(ctx, req.(*CreateTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_GetTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).GetTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/GetTensorboardTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).GetTensorboardTimeSeries(ctx, req.(*GetTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_UpdateTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).UpdateTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/UpdateTensorboardTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).UpdateTensorboardTimeSeries(ctx, req.(*UpdateTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ListTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ListTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/ListTensorboardTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ListTensorboardTimeSeries(ctx, req.(*ListTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_DeleteTensorboardTimeSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTensorboardTimeSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).DeleteTensorboardTimeSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/DeleteTensorboardTimeSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).DeleteTensorboardTimeSeries(ctx, req.(*DeleteTensorboardTimeSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_BatchReadTensorboardTimeSeriesData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchReadTensorboardTimeSeriesDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).BatchReadTensorboardTimeSeriesData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/BatchReadTensorboardTimeSeriesData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).BatchReadTensorboardTimeSeriesData(ctx, req.(*BatchReadTensorboardTimeSeriesDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ReadTensorboardTimeSeriesData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadTensorboardTimeSeriesDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ReadTensorboardTimeSeriesData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/ReadTensorboardTimeSeriesData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ReadTensorboardTimeSeriesData(ctx, req.(*ReadTensorboardTimeSeriesDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ReadTensorboardBlobData_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadTensorboardBlobDataRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TensorboardServiceServer).ReadTensorboardBlobData(m, &tensorboardServiceReadTensorboardBlobDataServer{stream})
}

type TensorboardService_ReadTensorboardBlobDataServer interface {
	Send(*ReadTensorboardBlobDataResponse) error
	grpc.ServerStream
}

type tensorboardServiceReadTensorboardBlobDataServer struct {
	grpc.ServerStream
}

func (x *tensorboardServiceReadTensorboardBlobDataServer) Send(m *ReadTensorboardBlobDataResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _TensorboardService_WriteTensorboardExperimentData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteTensorboardExperimentDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).WriteTensorboardExperimentData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/WriteTensorboardExperimentData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).WriteTensorboardExperimentData(ctx, req.(*WriteTensorboardExperimentDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_WriteTensorboardRunData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteTensorboardRunDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).WriteTensorboardRunData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/WriteTensorboardRunData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).WriteTensorboardRunData(ctx, req.(*WriteTensorboardRunDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TensorboardService_ExportTensorboardTimeSeriesData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportTensorboardTimeSeriesDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TensorboardServiceServer).ExportTensorboardTimeSeriesData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.TensorboardService/ExportTensorboardTimeSeriesData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TensorboardServiceServer).ExportTensorboardTimeSeriesData(ctx, req.(*ExportTensorboardTimeSeriesDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TensorboardService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.TensorboardService",
	HandlerType: (*TensorboardServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTensorboard",
			Handler:    _TensorboardService_CreateTensorboard_Handler,
		},
		{
			MethodName: "GetTensorboard",
			Handler:    _TensorboardService_GetTensorboard_Handler,
		},
		{
			MethodName: "ReadTensorboardUsage",
			Handler:    _TensorboardService_ReadTensorboardUsage_Handler,
		},
		{
			MethodName: "UpdateTensorboard",
			Handler:    _TensorboardService_UpdateTensorboard_Handler,
		},
		{
			MethodName: "ListTensorboards",
			Handler:    _TensorboardService_ListTensorboards_Handler,
		},
		{
			MethodName: "DeleteTensorboard",
			Handler:    _TensorboardService_DeleteTensorboard_Handler,
		},
		{
			MethodName: "CreateTensorboardExperiment",
			Handler:    _TensorboardService_CreateTensorboardExperiment_Handler,
		},
		{
			MethodName: "GetTensorboardExperiment",
			Handler:    _TensorboardService_GetTensorboardExperiment_Handler,
		},
		{
			MethodName: "UpdateTensorboardExperiment",
			Handler:    _TensorboardService_UpdateTensorboardExperiment_Handler,
		},
		{
			MethodName: "ListTensorboardExperiments",
			Handler:    _TensorboardService_ListTensorboardExperiments_Handler,
		},
		{
			MethodName: "DeleteTensorboardExperiment",
			Handler:    _TensorboardService_DeleteTensorboardExperiment_Handler,
		},
		{
			MethodName: "CreateTensorboardRun",
			Handler:    _TensorboardService_CreateTensorboardRun_Handler,
		},
		{
			MethodName: "BatchCreateTensorboardRuns",
			Handler:    _TensorboardService_BatchCreateTensorboardRuns_Handler,
		},
		{
			MethodName: "GetTensorboardRun",
			Handler:    _TensorboardService_GetTensorboardRun_Handler,
		},
		{
			MethodName: "UpdateTensorboardRun",
			Handler:    _TensorboardService_UpdateTensorboardRun_Handler,
		},
		{
			MethodName: "ListTensorboardRuns",
			Handler:    _TensorboardService_ListTensorboardRuns_Handler,
		},
		{
			MethodName: "DeleteTensorboardRun",
			Handler:    _TensorboardService_DeleteTensorboardRun_Handler,
		},
		{
			MethodName: "BatchCreateTensorboardTimeSeries",
			Handler:    _TensorboardService_BatchCreateTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "CreateTensorboardTimeSeries",
			Handler:    _TensorboardService_CreateTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "GetTensorboardTimeSeries",
			Handler:    _TensorboardService_GetTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "UpdateTensorboardTimeSeries",
			Handler:    _TensorboardService_UpdateTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "ListTensorboardTimeSeries",
			Handler:    _TensorboardService_ListTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "DeleteTensorboardTimeSeries",
			Handler:    _TensorboardService_DeleteTensorboardTimeSeries_Handler,
		},
		{
			MethodName: "BatchReadTensorboardTimeSeriesData",
			Handler:    _TensorboardService_BatchReadTensorboardTimeSeriesData_Handler,
		},
		{
			MethodName: "ReadTensorboardTimeSeriesData",
			Handler:    _TensorboardService_ReadTensorboardTimeSeriesData_Handler,
		},
		{
			MethodName: "WriteTensorboardExperimentData",
			Handler:    _TensorboardService_WriteTensorboardExperimentData_Handler,
		},
		{
			MethodName: "WriteTensorboardRunData",
			Handler:    _TensorboardService_WriteTensorboardRunData_Handler,
		},
		{
			MethodName: "ExportTensorboardTimeSeriesData",
			Handler:    _TensorboardService_ExportTensorboardTimeSeriesData_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadTensorboardBlobData",
			Handler:       _TensorboardService_ReadTensorboardBlobData_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/aiplatform/v1beta1/tensorboard_service.proto",
}
