// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/talent/v4beta1/job_service.proto

package talentpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An enum that specifies the job attributes that are returned in the
// [MatchingJob.job][google.cloud.talent.v4beta1.SearchJobsResponse.MatchingJob.job] or
// [ListJobsResponse.jobs][google.cloud.talent.v4beta1.ListJobsResponse.jobs] fields.
type JobView int32

const (
	// Default value.
	JobView_JOB_VIEW_UNSPECIFIED JobView = 0
	// A ID only view of job, with following attributes:
	// [Job.name][google.cloud.talent.v4beta1.Job.name], [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id], [Job.language_code][google.cloud.talent.v4beta1.Job.language_code].
	JobView_JOB_VIEW_ID_ONLY JobView = 1
	// A minimal view of the job, with the following attributes:
	// [Job.name][google.cloud.talent.v4beta1.Job.name], [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id], [Job.title][google.cloud.talent.v4beta1.Job.title],
	// [Job.company][google.cloud.talent.v4beta1.Job.company], [Job.DerivedInfo.locations][google.cloud.talent.v4beta1.Job.DerivedInfo.locations], [Job.language_code][google.cloud.talent.v4beta1.Job.language_code].
	JobView_JOB_VIEW_MINIMAL JobView = 2
	// A small view of the job, with the following attributes in the search
	// results: [Job.name][google.cloud.talent.v4beta1.Job.name], [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id], [Job.title][google.cloud.talent.v4beta1.Job.title],
	// [Job.company][google.cloud.talent.v4beta1.Job.company], [Job.DerivedInfo.locations][google.cloud.talent.v4beta1.Job.DerivedInfo.locations], [Job.visibility][google.cloud.talent.v4beta1.Job.visibility],
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], [Job.description][google.cloud.talent.v4beta1.Job.description].
	JobView_JOB_VIEW_SMALL JobView = 3
	// All available attributes are included in the search results.
	JobView_JOB_VIEW_FULL JobView = 4
)

// Enum value maps for JobView.
var (
	JobView_name = map[int32]string{
		0: "JOB_VIEW_UNSPECIFIED",
		1: "JOB_VIEW_ID_ONLY",
		2: "JOB_VIEW_MINIMAL",
		3: "JOB_VIEW_SMALL",
		4: "JOB_VIEW_FULL",
	}
	JobView_value = map[string]int32{
		"JOB_VIEW_UNSPECIFIED": 0,
		"JOB_VIEW_ID_ONLY":     1,
		"JOB_VIEW_MINIMAL":     2,
		"JOB_VIEW_SMALL":       3,
		"JOB_VIEW_FULL":        4,
	}
)

func (x JobView) Enum() *JobView {
	p := new(JobView)
	*p = x
	return p
}

func (x JobView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[0].Descriptor()
}

func (JobView) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[0]
}

func (x JobView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobView.Descriptor instead.
func (JobView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{0}
}

// A string-represented enumeration of the job search mode. The service
// operate differently for different modes of service.
type SearchJobsRequest_SearchMode int32

const (
	// The mode of the search method isn't specified. The default search
	// behavior is identical to JOB_SEARCH search behavior.
	SearchJobsRequest_SEARCH_MODE_UNSPECIFIED SearchJobsRequest_SearchMode = 0
	// The job search matches against all jobs, and featured jobs
	// (jobs with promotionValue > 0) are not specially handled.
	SearchJobsRequest_JOB_SEARCH SearchJobsRequest_SearchMode = 1
	// The job search matches only against featured jobs (jobs with a
	// promotionValue > 0). This method doesn't return any jobs having a
	// promotionValue <= 0. The search results order is determined by the
	// promotionValue (jobs with a higher promotionValue are returned higher up
	// in the search results), with relevance being used as a tiebreaker.
	SearchJobsRequest_FEATURED_JOB_SEARCH SearchJobsRequest_SearchMode = 2
)

// Enum value maps for SearchJobsRequest_SearchMode.
var (
	SearchJobsRequest_SearchMode_name = map[int32]string{
		0: "SEARCH_MODE_UNSPECIFIED",
		1: "JOB_SEARCH",
		2: "FEATURED_JOB_SEARCH",
	}
	SearchJobsRequest_SearchMode_value = map[string]int32{
		"SEARCH_MODE_UNSPECIFIED": 0,
		"JOB_SEARCH":              1,
		"FEATURED_JOB_SEARCH":     2,
	}
)

func (x SearchJobsRequest_SearchMode) Enum() *SearchJobsRequest_SearchMode {
	p := new(SearchJobsRequest_SearchMode)
	*p = x
	return p
}

func (x SearchJobsRequest_SearchMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchJobsRequest_SearchMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[1].Descriptor()
}

func (SearchJobsRequest_SearchMode) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[1]
}

func (x SearchJobsRequest_SearchMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchJobsRequest_SearchMode.Descriptor instead.
func (SearchJobsRequest_SearchMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{7, 0}
}

// Controls whether highly similar jobs are returned next to each other in
// the search results. Jobs are identified as highly similar based on
// their titles, job categories, and locations. Highly similar results are
// clustered so that only one representative job of the cluster is
// displayed to the job seeker higher up in the results, with the other jobs
// being displayed lower down in the results.
type SearchJobsRequest_DiversificationLevel int32

const (
	// The diversification level isn't specified.
	SearchJobsRequest_DIVERSIFICATION_LEVEL_UNSPECIFIED SearchJobsRequest_DiversificationLevel = 0
	// Disables diversification. Jobs that would normally be pushed to the last
	// page would not have their positions altered. This may result in highly
	// similar jobs appearing in sequence in the search results.
	SearchJobsRequest_DISABLED SearchJobsRequest_DiversificationLevel = 1
	// Default diversifying behavior. The result list is ordered so that
	// highly similar results are pushed to the end of the last page of search
	// results. If you are using pageToken to page through the result set,
	// latency might be lower but we can't guarantee that all results are
	// returned. If you are using page offset, latency might be higher but all
	// results are returned.
	SearchJobsRequest_SIMPLE SearchJobsRequest_DiversificationLevel = 2
)

// Enum value maps for SearchJobsRequest_DiversificationLevel.
var (
	SearchJobsRequest_DiversificationLevel_name = map[int32]string{
		0: "DIVERSIFICATION_LEVEL_UNSPECIFIED",
		1: "DISABLED",
		2: "SIMPLE",
	}
	SearchJobsRequest_DiversificationLevel_value = map[string]int32{
		"DIVERSIFICATION_LEVEL_UNSPECIFIED": 0,
		"DISABLED":                          1,
		"SIMPLE":                            2,
	}
)

func (x SearchJobsRequest_DiversificationLevel) Enum() *SearchJobsRequest_DiversificationLevel {
	p := new(SearchJobsRequest_DiversificationLevel)
	*p = x
	return p
}

func (x SearchJobsRequest_DiversificationLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchJobsRequest_DiversificationLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[2].Descriptor()
}

func (SearchJobsRequest_DiversificationLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[2]
}

func (x SearchJobsRequest_DiversificationLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchJobsRequest_DiversificationLevel.Descriptor instead.
func (SearchJobsRequest_DiversificationLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{7, 1}
}

// Controls what keyword matching behavior the search has. When keyword
// matching is enabled, a keyword match returns jobs that may not match given
// category filters when there are matching keywords. For example, for the
// query "program manager" with KeywordMatchMode set to KEYWORD_MATCH_ALL, a
// job posting with the title "software developer," which doesn't fall into
// "program manager" ontology, and "program manager" appearing in its
// description will be surfaced.
//
// For queries like "cloud" that don't contain title or
// location specific ontology, jobs with "cloud" keyword matches are returned
// regardless of this enum's value.
//
// Use [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4beta1.Company.keyword_searchable_job_custom_attributes] if
// company-specific globally matched custom field/attribute string values are
// needed. Enabling keyword match improves recall of subsequent search
// requests.
type SearchJobsRequest_KeywordMatchMode int32

const (
	// The keyword match option isn't specified. Defaults to
	// [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL] behavior.
	SearchJobsRequest_KEYWORD_MATCH_MODE_UNSPECIFIED SearchJobsRequest_KeywordMatchMode = 0
	// Disables keyword matching.
	SearchJobsRequest_KEYWORD_MATCH_DISABLED SearchJobsRequest_KeywordMatchMode = 1
	// Enable keyword matching over [Job.title][google.cloud.talent.v4beta1.Job.title],
	// [Job.description][google.cloud.talent.v4beta1.Job.description], [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name], [Job.addresses][google.cloud.talent.v4beta1.Job.addresses],
	// [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications], and keyword searchable [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes]
	// fields.
	SearchJobsRequest_KEYWORD_MATCH_ALL SearchJobsRequest_KeywordMatchMode = 2
	// Only enable keyword matching over [Job.title][google.cloud.talent.v4beta1.Job.title].
	SearchJobsRequest_KEYWORD_MATCH_TITLE_ONLY SearchJobsRequest_KeywordMatchMode = 3
)

// Enum value maps for SearchJobsRequest_KeywordMatchMode.
var (
	SearchJobsRequest_KeywordMatchMode_name = map[int32]string{
		0: "KEYWORD_MATCH_MODE_UNSPECIFIED",
		1: "KEYWORD_MATCH_DISABLED",
		2: "KEYWORD_MATCH_ALL",
		3: "KEYWORD_MATCH_TITLE_ONLY",
	}
	SearchJobsRequest_KeywordMatchMode_value = map[string]int32{
		"KEYWORD_MATCH_MODE_UNSPECIFIED": 0,
		"KEYWORD_MATCH_DISABLED":         1,
		"KEYWORD_MATCH_ALL":              2,
		"KEYWORD_MATCH_TITLE_ONLY":       3,
	}
)

func (x SearchJobsRequest_KeywordMatchMode) Enum() *SearchJobsRequest_KeywordMatchMode {
	p := new(SearchJobsRequest_KeywordMatchMode)
	*p = x
	return p
}

func (x SearchJobsRequest_KeywordMatchMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchJobsRequest_KeywordMatchMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[3].Descriptor()
}

func (SearchJobsRequest_KeywordMatchMode) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[3]
}

func (x SearchJobsRequest_KeywordMatchMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchJobsRequest_KeywordMatchMode.Descriptor instead.
func (SearchJobsRequest_KeywordMatchMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{7, 2}
}

// The importance level for [CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression].
type SearchJobsRequest_CustomRankingInfo_ImportanceLevel int32

const (
	// Default value if the importance level isn't specified.
	SearchJobsRequest_CustomRankingInfo_IMPORTANCE_LEVEL_UNSPECIFIED SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 0
	// The given ranking expression is of None importance, existing relevance
	// score (determined by API algorithm) dominates job's final ranking
	// position.
	SearchJobsRequest_CustomRankingInfo_NONE SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 1
	// The given ranking expression is of Low importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_LOW SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 2
	// The given ranking expression is of Mild importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_MILD SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 3
	// The given ranking expression is of Medium importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_MEDIUM SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 4
	// The given ranking expression is of High importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_HIGH SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 5
	// The given ranking expression is of Extreme importance, and dominates
	// job's final ranking position with existing relevance
	// score (determined by API algorithm) ignored.
	SearchJobsRequest_CustomRankingInfo_EXTREME SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 6
)

// Enum value maps for SearchJobsRequest_CustomRankingInfo_ImportanceLevel.
var (
	SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name = map[int32]string{
		0: "IMPORTANCE_LEVEL_UNSPECIFIED",
		1: "NONE",
		2: "LOW",
		3: "MILD",
		4: "MEDIUM",
		5: "HIGH",
		6: "EXTREME",
	}
	SearchJobsRequest_CustomRankingInfo_ImportanceLevel_value = map[string]int32{
		"IMPORTANCE_LEVEL_UNSPECIFIED": 0,
		"NONE":                         1,
		"LOW":                          2,
		"MILD":                         3,
		"MEDIUM":                       4,
		"HIGH":                         5,
		"EXTREME":                      6,
	}
)

func (x SearchJobsRequest_CustomRankingInfo_ImportanceLevel) Enum() *SearchJobsRequest_CustomRankingInfo_ImportanceLevel {
	p := new(SearchJobsRequest_CustomRankingInfo_ImportanceLevel)
	*p = x
	return p
}

func (x SearchJobsRequest_CustomRankingInfo_ImportanceLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchJobsRequest_CustomRankingInfo_ImportanceLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[4].Descriptor()
}

func (SearchJobsRequest_CustomRankingInfo_ImportanceLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_job_service_proto_enumTypes[4]
}

func (x SearchJobsRequest_CustomRankingInfo_ImportanceLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchJobsRequest_CustomRankingInfo_ImportanceLevel.Descriptor instead.
func (SearchJobsRequest_CustomRankingInfo_ImportanceLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{7, 0, 0}
}

// Create job request.
type CreateJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}". For example,
	// "projects/foo/tenant/bar". If tenant id is unspecified a default tenant
	// is created. For example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Job to be created.
	Job *Job `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *CreateJobRequest) Reset() {
	*x = CreateJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateJobRequest) ProtoMessage() {}

func (x *CreateJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateJobRequest.ProtoReflect.Descriptor instead.
func (*CreateJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateJobRequest) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Get job request.
type GetJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the job to retrieve.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
	// example, "projects/foo/tenants/bar/jobs/baz".
	//
	// If tenant id is unspecified, the default tenant is used. For
	// example, "projects/foo/jobs/bar".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetJobRequest) Reset() {
	*x = GetJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobRequest) ProtoMessage() {}

func (x *GetJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobRequest.ProtoReflect.Descriptor instead.
func (*GetJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Update job request.
type UpdateJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Job to be updated.
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// Strongly recommended for the best service experience.
	//
	// If [update_mask][google.cloud.talent.v4beta1.UpdateJobRequest.update_mask] is provided, only the specified fields in
	// [job][google.cloud.talent.v4beta1.UpdateJobRequest.job] are updated. Otherwise all the fields are updated.
	//
	// A field mask to restrict the fields that are updated. Only
	// top level fields of [Job][google.cloud.talent.v4beta1.Job] are supported.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateJobRequest) Reset() {
	*x = UpdateJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateJobRequest) ProtoMessage() {}

func (x *UpdateJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateJobRequest.ProtoReflect.Descriptor instead.
func (*UpdateJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateJobRequest) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

func (x *UpdateJobRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Delete job request.
type DeleteJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the job to be deleted.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
	// example, "projects/foo/tenants/bar/jobs/baz".
	//
	// If tenant id is unspecified, the default tenant is used. For
	// example, "projects/foo/jobs/bar".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteJobRequest) Reset() {
	*x = DeleteJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteJobRequest) ProtoMessage() {}

func (x *DeleteJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Batch delete jobs request.
type BatchDeleteJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}". For example,
	// "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
	// is created. For example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The filter string specifies the jobs to be deleted.
	//
	// Supported operator: =, AND
	//
	// The fields eligible for filtering are:
	//
	// * `companyName` (Required)
	// * `requisitionId` (Required)
	//
	// Sample Query: companyName = "projects/foo/companies/bar" AND
	// requisitionId = "req-1"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *BatchDeleteJobsRequest) Reset() {
	*x = BatchDeleteJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteJobsRequest) ProtoMessage() {}

func (x *BatchDeleteJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteJobsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{4}
}

func (x *BatchDeleteJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// List jobs request.
type ListJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}". For example,
	// "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
	// is created. For example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The filter string specifies the jobs to be enumerated.
	//
	// Supported operator: =, AND
	//
	// The fields eligible for filtering are:
	//
	// * `companyName`
	// * `requisitionId`
	// * `status` Available values: OPEN, EXPIRED, ALL. Defaults to
	// OPEN if no value is specified.
	//
	// At least one of `companyName` and `requisitionId` must present or an
	// INVALID_ARGUMENT error is thrown.
	//
	// Sample Query:
	//
	// * companyName = "projects/foo/tenants/bar/companies/baz"
	// * companyName = "projects/foo/tenants/bar/companies/baz" AND
	// requisitionId = "req-1"
	// * companyName = "projects/foo/tenants/bar/companies/baz" AND
	// status = "EXPIRED"
	// * requisitionId = "req-1"
	// * requisitionId = "req-1" AND status = "EXPIRED"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The starting point of a query result.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of jobs to be returned per page of results.
	//
	// If [job_view][google.cloud.talent.v4beta1.ListJobsRequest.job_view] is set to [JobView.JOB_VIEW_ID_ONLY][google.cloud.talent.v4beta1.JobView.JOB_VIEW_ID_ONLY], the maximum allowed
	// page size is 1000. Otherwise, the maximum allowed page size is 100.
	//
	// Default is 100 if empty or a number < 1 is specified.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The desired job attributes returned for jobs in the
	// search response. Defaults to [JobView.JOB_VIEW_FULL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_FULL] if no value is
	// specified.
	JobView JobView `protobuf:"varint,5,opt,name=job_view,json=jobView,proto3,enum=google.cloud.talent.v4beta1.JobView" json:"job_view,omitempty"`
}

func (x *ListJobsRequest) Reset() {
	*x = ListJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobsRequest) ProtoMessage() {}

func (x *ListJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobsRequest.ProtoReflect.Descriptor instead.
func (*ListJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListJobsRequest) GetJobView() JobView {
	if x != nil {
		return x.JobView
	}
	return JobView_JOB_VIEW_UNSPECIFIED
}

// List jobs response.
type ListJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Jobs for a given company.
	//
	// The maximum number of items returned is based on the limit field
	// provided in the request.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *ResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ListJobsResponse) Reset() {
	*x = ListJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobsResponse) ProtoMessage() {}

func (x *ListJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobsResponse.ProtoReflect.Descriptor instead.
func (*ListJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListJobsResponse) GetJobs() []*Job {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *ListJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListJobsResponse) GetMetadata() *ResponseMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// The Request body of the `SearchJobs` call.
type SearchJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the tenant to search within.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}". For example,
	// "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
	// is created. For example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Mode of a search.
	//
	// Defaults to [SearchMode.JOB_SEARCH][google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode.JOB_SEARCH].
	SearchMode SearchJobsRequest_SearchMode `protobuf:"varint,2,opt,name=search_mode,json=searchMode,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_SearchMode" json:"search_mode,omitempty"`
	// Required. The meta information collected about the job searcher, used to improve the
	// search quality of the service. The identifiers (such as `user_id`) are
	// provided by users, and must be unique and consistent.
	RequestMetadata *RequestMetadata `protobuf:"bytes,3,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
	// Query used to search against jobs, such as keyword, location filters, etc.
	JobQuery *JobQuery `protobuf:"bytes,4,opt,name=job_query,json=jobQuery,proto3" json:"job_query,omitempty"`
	// Controls whether to broaden the search when it produces sparse results.
	// Broadened queries append results to the end of the matching results
	// list.
	//
	// Defaults to false.
	EnableBroadening bool `protobuf:"varint,5,opt,name=enable_broadening,json=enableBroadening,proto3" json:"enable_broadening,omitempty"`
	// This field is deprecated.
	//
	// Deprecated: Do not use.
	RequirePreciseResultSize bool `protobuf:"varint,6,opt,name=require_precise_result_size,json=requirePreciseResultSize,proto3" json:"require_precise_result_size,omitempty"`
	// An expression specifies a histogram request against matching jobs.
	//
	// Expression syntax is an aggregation function call with histogram facets and
	// other options.
	//
	// Available aggregation function calls are:
	// * `count(string_histogram_facet)`: Count the number of matching entities,
	// for each distinct attribute value.
	// * `count(numeric_histogram_facet, list of buckets)`: Count the number of
	// matching entities within each bucket.
	//
	// A maximum of 200 histogram buckets are supported.
	//
	// Data types:
	//
	// * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
	// * String: string like "any string with backslash escape for quote(\")."
	// * Number: whole number and floating point number like 10, -1 and -0.01.
	// * List: list of elements with comma(,) separator surrounded by square
	// brackets, for example, [1, 2, 3] and ["one", "two", "three"].
	//
	// Built-in constants:
	//
	// * MIN (minimum number similar to java Double.MIN_VALUE)
	// * MAX (maximum number similar to java Double.MAX_VALUE)
	//
	// Built-in functions:
	//
	// * bucket(start, end[, label]): bucket built-in function creates a bucket
	// with range of [start, end). Note that the end is exclusive, for example,
	// bucket(1, MAX, "positive number") or bucket(1, 10).
	//
	// Job histogram facets:
	//
	//   - company_display_name: histogram by [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name].
	//   - employment_type: histogram by [Job.employment_types][google.cloud.talent.v4beta1.Job.employment_types], for example,
	//     "FULL_TIME", "PART_TIME".
	//   - company_size (DEPRECATED): histogram by [CompanySize][google.cloud.talent.v4beta1.CompanySize], for example,
	//
	// "SMALL", "MEDIUM", "BIG".
	//   - publish_time_in_day: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
	//     in days.
	//     Must specify list of numeric buckets in spec.
	//   - publish_time_in_month: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
	//     in months.
	//     Must specify list of numeric buckets in spec.
	//   - publish_time_in_year: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
	//     in years.
	//     Must specify list of numeric buckets in spec.
	//   - degree_types: histogram by the [Job.degree_types][google.cloud.talent.v4beta1.Job.degree_types], for example,
	//     "Bachelors", "Masters".
	//   - job_level: histogram by the [Job.job_level][google.cloud.talent.v4beta1.Job.job_level], for example, "Entry
	//     Level".
	//   - country: histogram by the country code of jobs, for example, "US", "FR".
	//   - admin1: histogram by the admin1 code of jobs, which is a global
	//     placeholder referring to the state, province, or the particular term a
	//     country uses to define the geographic structure below the country level,
	//     for example, "CA", "IL".
	//   - city: histogram by a combination of the "city name, admin1 code". For
	//     example,  "Mountain View, CA", "New York, NY".
	//   - admin1_country: histogram by a combination of the "admin1 code, country",
	//     for example, "CA, US", "IL, US".
	//   - city_coordinate: histogram by the city center's GPS coordinates (latitude
	//     and longitude), for example, 37.4038522,-122.0987765. Since the
	//     coordinates of a city center can change, customers may need to refresh
	//     them periodically.
	//   - locale: histogram by the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], for example, "en-US",
	//     "fr-FR".
	//   - language: histogram by the language subtag of the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code],
	//     for example, "en", "fr".
	//   - category: histogram by the [JobCategory][google.cloud.talent.v4beta1.JobCategory], for example,
	//     "COMPUTER_AND_IT", "HEALTHCARE".
	//   - base_compensation_unit: histogram by the
	//     [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit] of base
	//     salary, for example, "WEEKLY", "MONTHLY".
	//   - base_compensation: histogram by the base salary. Must specify list of
	//     numeric buckets to group results by.
	//   - annualized_base_compensation: histogram by the base annualized salary.
	//     Must specify list of numeric buckets to group results by.
	//   - annualized_total_compensation: histogram by the total annualized salary.
	//     Must specify list of numeric buckets to group results by.
	//   - string_custom_attribute: histogram by string [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
	//     Values can be accessed via square bracket notations like
	//     string_custom_attribute["key1"].
	//   - numeric_custom_attribute: histogram by numeric [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
	//     Values can be accessed via square bracket notations like
	//     numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
	//     group results by.
	//
	// Example expressions:
	//
	// * `count(admin1)`
	// * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
	// bucket(100000, MAX)])`
	//   - `count(string_custom_attribute["some-string-custom-attribute"])`
	//   - `count(numeric_custom_attribute["some-numeric-custom-attribute"],
	//     [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
	HistogramQueries []*HistogramQuery `protobuf:"bytes,7,rep,name=histogram_queries,json=histogramQueries,proto3" json:"histogram_queries,omitempty"`
	// The desired job attributes returned for jobs in the search response.
	// Defaults to [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_SMALL] if no value is specified.
	JobView JobView `protobuf:"varint,8,opt,name=job_view,json=jobView,proto3,enum=google.cloud.talent.v4beta1.JobView" json:"job_view,omitempty"`
	// An integer that specifies the current offset (that is, starting result
	// location, amongst the jobs deemed by the API as relevant) in search
	// results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchJobsRequest.page_token] is unset.
	//
	// The maximum allowed value is 5000. Otherwise an error is thrown.
	//
	// For example, 0 means to  return results starting from the first matching
	// job, and 10 means to return from the 11th job. This can be used for
	// pagination, (for example, pageSize = 10 and offset = 10 means to return
	// from the second page).
	Offset int32 `protobuf:"varint,9,opt,name=offset,proto3" json:"offset,omitempty"`
	// A limit on the number of jobs returned in the search results.
	// Increasing this value above the default value of 10 can increase search
	// response time. The value can be between 1 and 100.
	PageSize int32 `protobuf:"varint,10,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token specifying the current offset within
	// search results. See [SearchJobsResponse.next_page_token][google.cloud.talent.v4beta1.SearchJobsResponse.next_page_token] for
	// an explanation of how to obtain the next set of query results.
	PageToken string `protobuf:"bytes,11,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The criteria determining how search results are sorted. Default is
	// `"relevance desc"`.
	//
	// Supported options are:
	//
	//   - `"relevance desc"`: By relevance descending, as determined by the API
	//     algorithms. Relevance thresholding of query results is only available
	//     with this ordering.
	//   - `"posting_publish_time desc"`: By [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
	//     descending.
	//   - `"posting_update_time desc"`: By [Job.posting_update_time][google.cloud.talent.v4beta1.Job.posting_update_time]
	//     descending.
	//   - `"title"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] ascending.
	//   - `"title desc"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] descending.
	//   - `"annualized_base_compensation"`: By job's
	//     [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] ascending. Jobs
	//     whose annualized base compensation is unspecified are put at the end of
	//     search results.
	//   - `"annualized_base_compensation desc"`: By job's
	//     [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] descending. Jobs
	//     whose annualized base compensation is unspecified are put at the end of
	//     search results.
	//   - `"annualized_total_compensation"`: By job's
	//     [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] ascending. Jobs
	//     whose annualized base compensation is unspecified are put at the end of
	//     search results.
	//   - `"annualized_total_compensation desc"`: By job's
	//     [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] descending. Jobs
	//     whose annualized base compensation is unspecified are put at the end of
	//     search results.
	//   - `"custom_ranking desc"`: By the relevance score adjusted to the
	//     [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression] with weight
	//     factor assigned by
	//     [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.importance_level] in descending
	//     order.
	//   - Location sorting: Use the special syntax to order jobs by distance:<br>
	//     `"distance_from('Hawaii')"`: Order by distance from Hawaii.<br>
	//     `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.<br>
	//     `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
	//     multiple locations. See details below.<br>
	//     `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
	//     multiple locations. See details below.<br>
	//     The string can have a maximum of 256 characters. When multiple distance
	//     centers are provided, a job that is close to any of the distance centers
	//     would have a high rank. When a job has multiple locations, the job
	//     location closest to one of the distance centers will be used. Jobs that
	//     don't have locations will be ranked at the bottom. Distance is calculated
	//     with a precision of 11.3 meters (37.4 feet). Diversification strategy is
	//     still applied unless explicitly disabled in
	//     [diversification_level][google.cloud.talent.v4beta1.SearchJobsRequest.diversification_level].
	OrderBy string `protobuf:"bytes,12,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Controls whether highly similar jobs are returned next to each other in
	// the search results. Jobs are identified as highly similar based on
	// their titles, job categories, and locations. Highly similar results are
	// clustered so that only one representative job of the cluster is
	// displayed to the job seeker higher up in the results, with the other jobs
	// being displayed lower down in the results.
	//
	// Defaults to [DiversificationLevel.SIMPLE][google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel.SIMPLE] if no value
	// is specified.
	DiversificationLevel SearchJobsRequest_DiversificationLevel `protobuf:"varint,13,opt,name=diversification_level,json=diversificationLevel,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_DiversificationLevel" json:"diversification_level,omitempty"`
	// Controls over how job documents get ranked on top of existing relevance
	// score (determined by API algorithm).
	CustomRankingInfo *SearchJobsRequest_CustomRankingInfo `protobuf:"bytes,14,opt,name=custom_ranking_info,json=customRankingInfo,proto3" json:"custom_ranking_info,omitempty"`
	// This field is deprecated. Please use
	// [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] going forward.
	//
	// To migrate, disable_keyword_match set to false maps to
	// [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL], and disable_keyword_match set to
	// true maps to [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED]. If
	// [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] is set, this field is ignored.
	//
	// Controls whether to disable exact keyword match on [Job.title][google.cloud.talent.v4beta1.Job.title],
	// [Job.description][google.cloud.talent.v4beta1.Job.description], [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name], [Job.addresses][google.cloud.talent.v4beta1.Job.addresses],
	// [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications]. When disable keyword match is turned off, a
	// keyword match returns jobs that do not match given category filters when
	// there are matching keywords. For example, for the query "program manager,"
	// a result is returned even if the job posting has the title "software
	// developer," which doesn't fall into "program manager" ontology, but does
	// have "program manager" appearing in its description.
	//
	// For queries like "cloud" that don't contain title or
	// location specific ontology, jobs with "cloud" keyword matches are returned
	// regardless of this flag's value.
	//
	// Use [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4beta1.Company.keyword_searchable_job_custom_attributes] if
	// company-specific globally matched custom field/attribute string values are
	// needed. Enabling keyword match improves recall of subsequent search
	// requests.
	//
	// Defaults to false.
	DisableKeywordMatch bool `protobuf:"varint,16,opt,name=disable_keyword_match,json=disableKeywordMatch,proto3" json:"disable_keyword_match,omitempty"`
	// Controls what keyword match options to use.
	//
	// Defaults to [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL] if no value
	// is specified.
	KeywordMatchMode SearchJobsRequest_KeywordMatchMode `protobuf:"varint,18,opt,name=keyword_match_mode,json=keywordMatchMode,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_KeywordMatchMode" json:"keyword_match_mode,omitempty"`
}

func (x *SearchJobsRequest) Reset() {
	*x = SearchJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchJobsRequest) ProtoMessage() {}

func (x *SearchJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchJobsRequest.ProtoReflect.Descriptor instead.
func (*SearchJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{7}
}

func (x *SearchJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchJobsRequest) GetSearchMode() SearchJobsRequest_SearchMode {
	if x != nil {
		return x.SearchMode
	}
	return SearchJobsRequest_SEARCH_MODE_UNSPECIFIED
}

func (x *SearchJobsRequest) GetRequestMetadata() *RequestMetadata {
	if x != nil {
		return x.RequestMetadata
	}
	return nil
}

func (x *SearchJobsRequest) GetJobQuery() *JobQuery {
	if x != nil {
		return x.JobQuery
	}
	return nil
}

func (x *SearchJobsRequest) GetEnableBroadening() bool {
	if x != nil {
		return x.EnableBroadening
	}
	return false
}

// Deprecated: Do not use.
func (x *SearchJobsRequest) GetRequirePreciseResultSize() bool {
	if x != nil {
		return x.RequirePreciseResultSize
	}
	return false
}

func (x *SearchJobsRequest) GetHistogramQueries() []*HistogramQuery {
	if x != nil {
		return x.HistogramQueries
	}
	return nil
}

func (x *SearchJobsRequest) GetJobView() JobView {
	if x != nil {
		return x.JobView
	}
	return JobView_JOB_VIEW_UNSPECIFIED
}

func (x *SearchJobsRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *SearchJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchJobsRequest) GetDiversificationLevel() SearchJobsRequest_DiversificationLevel {
	if x != nil {
		return x.DiversificationLevel
	}
	return SearchJobsRequest_DIVERSIFICATION_LEVEL_UNSPECIFIED
}

func (x *SearchJobsRequest) GetCustomRankingInfo() *SearchJobsRequest_CustomRankingInfo {
	if x != nil {
		return x.CustomRankingInfo
	}
	return nil
}

func (x *SearchJobsRequest) GetDisableKeywordMatch() bool {
	if x != nil {
		return x.DisableKeywordMatch
	}
	return false
}

func (x *SearchJobsRequest) GetKeywordMatchMode() SearchJobsRequest_KeywordMatchMode {
	if x != nil {
		return x.KeywordMatchMode
	}
	return SearchJobsRequest_KEYWORD_MATCH_MODE_UNSPECIFIED
}

// Response for SearchJob method.
type SearchJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Job entities that match the specified [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	MatchingJobs []*SearchJobsResponse_MatchingJob `protobuf:"bytes,1,rep,name=matching_jobs,json=matchingJobs,proto3" json:"matching_jobs,omitempty"`
	// The histogram results that match with specified
	// [SearchJobsRequest.histogram_queries][google.cloud.talent.v4beta1.SearchJobsRequest.histogram_queries].
	HistogramQueryResults []*HistogramQueryResult `protobuf:"bytes,2,rep,name=histogram_query_results,json=histogramQueryResults,proto3" json:"histogram_query_results,omitempty"`
	// The token that specifies the starting position of the next page of results.
	// This field is empty if there are no more results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The location filters that the service applied to the specified query. If
	// any filters are lat-lng based, the [Location.location_type][google.cloud.talent.v4beta1.Location.location_type] is
	// [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4beta1.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
	LocationFilters []*Location `protobuf:"bytes,4,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// An estimation of the number of jobs that match the specified query.
	//
	// This number isn't guaranteed to be accurate. For accurate results,
	// see [SearchJobsResponse.total_size][google.cloud.talent.v4beta1.SearchJobsResponse.total_size].
	EstimatedTotalSize int32 `protobuf:"varint,5,opt,name=estimated_total_size,json=estimatedTotalSize,proto3" json:"estimated_total_size,omitempty"`
	// The precise result count with limit 100,000.
	TotalSize int32 `protobuf:"varint,6,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *ResponseMetadata `protobuf:"bytes,7,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// If query broadening is enabled, we may append additional results from the
	// broadened query. This number indicates how many of the jobs returned in the
	// jobs field are from the broadened query. These results are always at the
	// end of the jobs list. In particular, a value of 0, or if the field isn't
	// set, all the jobs in the jobs list are from the original
	// (without broadening) query. If this field is non-zero, subsequent requests
	// with offset after this result set should contain all broadened results.
	BroadenedQueryJobsCount int32 `protobuf:"varint,8,opt,name=broadened_query_jobs_count,json=broadenedQueryJobsCount,proto3" json:"broadened_query_jobs_count,omitempty"`
	// The spell checking result, and correction.
	SpellCorrection *SpellingCorrection `protobuf:"bytes,9,opt,name=spell_correction,json=spellCorrection,proto3" json:"spell_correction,omitempty"`
}

func (x *SearchJobsResponse) Reset() {
	*x = SearchJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchJobsResponse) ProtoMessage() {}

func (x *SearchJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchJobsResponse.ProtoReflect.Descriptor instead.
func (*SearchJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{8}
}

func (x *SearchJobsResponse) GetMatchingJobs() []*SearchJobsResponse_MatchingJob {
	if x != nil {
		return x.MatchingJobs
	}
	return nil
}

func (x *SearchJobsResponse) GetHistogramQueryResults() []*HistogramQueryResult {
	if x != nil {
		return x.HistogramQueryResults
	}
	return nil
}

func (x *SearchJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchJobsResponse) GetLocationFilters() []*Location {
	if x != nil {
		return x.LocationFilters
	}
	return nil
}

func (x *SearchJobsResponse) GetEstimatedTotalSize() int32 {
	if x != nil {
		return x.EstimatedTotalSize
	}
	return 0
}

func (x *SearchJobsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *SearchJobsResponse) GetMetadata() *ResponseMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *SearchJobsResponse) GetBroadenedQueryJobsCount() int32 {
	if x != nil {
		return x.BroadenedQueryJobsCount
	}
	return 0
}

func (x *SearchJobsResponse) GetSpellCorrection() *SpellingCorrection {
	if x != nil {
		return x.SpellCorrection
	}
	return nil
}

// Request to create a batch of jobs.
type BatchCreateJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}". For example,
	// "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
	// is created. For example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The jobs to be created.
	Jobs []*Job `protobuf:"bytes,2,rep,name=jobs,proto3" json:"jobs,omitempty"`
}

func (x *BatchCreateJobsRequest) Reset() {
	*x = BatchCreateJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateJobsRequest) ProtoMessage() {}

func (x *BatchCreateJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateJobsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{9}
}

func (x *BatchCreateJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateJobsRequest) GetJobs() []*Job {
	if x != nil {
		return x.Jobs
	}
	return nil
}

// Request to update a batch of jobs.
type BatchUpdateJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}". For example,
	// "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
	// is created. For example, "projects/foo".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The jobs to be updated.
	Jobs []*Job `protobuf:"bytes,2,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Strongly recommended for the best service experience. Be aware that it will
	// also increase latency when checking the status of a batch operation.
	//
	// If [update_mask][google.cloud.talent.v4beta1.BatchUpdateJobsRequest.update_mask] is provided, only the specified fields in
	// [Job][google.cloud.talent.v4beta1.Job] are updated. Otherwise all the fields are updated.
	//
	// A field mask to restrict the fields that are updated. Only
	// top level fields of [Job][google.cloud.talent.v4beta1.Job] are supported.
	//
	// If [update_mask][google.cloud.talent.v4beta1.BatchUpdateJobsRequest.update_mask] is provided, The [Job][google.cloud.talent.v4beta1.Job] inside
	// [JobResult][google.cloud.talent.v4beta1.JobOperationResult.JobResult]
	// will only contains fields that is updated, plus the Id of the Job.
	// Otherwise,  [Job][google.cloud.talent.v4beta1.Job] will include all fields, which can yield a very
	// large response.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *BatchUpdateJobsRequest) Reset() {
	*x = BatchUpdateJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateJobsRequest) ProtoMessage() {}

func (x *BatchUpdateJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateJobsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{10}
}

func (x *BatchUpdateJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateJobsRequest) GetJobs() []*Job {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *BatchUpdateJobsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The result of [JobService.BatchCreateJobs][google.cloud.talent.v4beta1.JobService.BatchCreateJobs] or
// [JobService.BatchUpdateJobs][google.cloud.talent.v4beta1.JobService.BatchUpdateJobs] APIs. It's used to
// replace [google.longrunning.Operation.response][google.longrunning.Operation.response] in case of success.
type JobOperationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of job mutation results from a batch mutate operation. It can change
	// until operation status is FINISHED, FAILED or CANCELLED.
	JobResults []*JobOperationResult_JobResult `protobuf:"bytes,1,rep,name=job_results,json=jobResults,proto3" json:"job_results,omitempty"`
}

func (x *JobOperationResult) Reset() {
	*x = JobOperationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobOperationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobOperationResult) ProtoMessage() {}

func (x *JobOperationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobOperationResult.ProtoReflect.Descriptor instead.
func (*JobOperationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{11}
}

func (x *JobOperationResult) GetJobResults() []*JobOperationResult_JobResult {
	if x != nil {
		return x.JobResults
	}
	return nil
}

// Custom ranking information for [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
type SearchJobsRequest_CustomRankingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Controls over how important the score of
	// [CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression] gets applied to job's final
	// ranking position.
	//
	// An error is thrown if not specified.
	ImportanceLevel SearchJobsRequest_CustomRankingInfo_ImportanceLevel `protobuf:"varint,1,opt,name=importance_level,json=importanceLevel,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_CustomRankingInfo_ImportanceLevel" json:"importance_level,omitempty"`
	// Required. Controls over how job documents get ranked on top of existing relevance
	// score (determined by API algorithm). A combination of the ranking
	// expression and relevance score is used to determine job's final ranking
	// position.
	//
	// The syntax for this expression is a subset of Google SQL syntax.
	//
	// Supported operators are: +, -, *, /, where the left and right side of
	// the operator is either a numeric [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes] key,
	// integer/double value or an expression that can be evaluated to a number.
	//
	// Parenthesis are supported to adjust calculation precedence. The
	// expression must be < 200 characters in length.
	//
	// The expression is considered invalid for a job if the expression
	// references custom attributes that are not populated on the job or if the
	// expression results in a divide by zero. If an expression is invalid for a
	// job, that job is demoted to the end of the results.
	//
	// Sample ranking expression
	// (year + 25) * 0.25 - (freshness / 0.5)
	RankingExpression string `protobuf:"bytes,2,opt,name=ranking_expression,json=rankingExpression,proto3" json:"ranking_expression,omitempty"`
}

func (x *SearchJobsRequest_CustomRankingInfo) Reset() {
	*x = SearchJobsRequest_CustomRankingInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchJobsRequest_CustomRankingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchJobsRequest_CustomRankingInfo) ProtoMessage() {}

func (x *SearchJobsRequest_CustomRankingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchJobsRequest_CustomRankingInfo.ProtoReflect.Descriptor instead.
func (*SearchJobsRequest_CustomRankingInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{7, 0}
}

func (x *SearchJobsRequest_CustomRankingInfo) GetImportanceLevel() SearchJobsRequest_CustomRankingInfo_ImportanceLevel {
	if x != nil {
		return x.ImportanceLevel
	}
	return SearchJobsRequest_CustomRankingInfo_IMPORTANCE_LEVEL_UNSPECIFIED
}

func (x *SearchJobsRequest_CustomRankingInfo) GetRankingExpression() string {
	if x != nil {
		return x.RankingExpression
	}
	return ""
}

// Job entry with metadata inside [SearchJobsResponse][google.cloud.talent.v4beta1.SearchJobsResponse].
type SearchJobsResponse_MatchingJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job resource that matches the specified [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// A summary of the job with core information that's displayed on the search
	// results listing page.
	JobSummary string `protobuf:"bytes,2,opt,name=job_summary,json=jobSummary,proto3" json:"job_summary,omitempty"`
	// Contains snippets of text from the [Job.title][google.cloud.talent.v4beta1.Job.title] field most
	// closely matching a search query's keywords, if available. The matching
	// query keywords are enclosed in HTML bold tags.
	JobTitleSnippet string `protobuf:"bytes,3,opt,name=job_title_snippet,json=jobTitleSnippet,proto3" json:"job_title_snippet,omitempty"`
	// Contains snippets of text from the [Job.description][google.cloud.talent.v4beta1.Job.description] and similar
	// fields that most closely match a search query's keywords, if available.
	// All HTML tags in the original fields are stripped when returned in this
	// field, and matching query keywords are enclosed in HTML bold tags.
	SearchTextSnippet string `protobuf:"bytes,4,opt,name=search_text_snippet,json=searchTextSnippet,proto3" json:"search_text_snippet,omitempty"`
	// Commute information which is generated based on specified
	//
	//	[CommuteFilter][google.cloud.talent.v4beta1.CommuteFilter].
	CommuteInfo *SearchJobsResponse_CommuteInfo `protobuf:"bytes,5,opt,name=commute_info,json=commuteInfo,proto3" json:"commute_info,omitempty"`
}

func (x *SearchJobsResponse_MatchingJob) Reset() {
	*x = SearchJobsResponse_MatchingJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchJobsResponse_MatchingJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchJobsResponse_MatchingJob) ProtoMessage() {}

func (x *SearchJobsResponse_MatchingJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchJobsResponse_MatchingJob.ProtoReflect.Descriptor instead.
func (*SearchJobsResponse_MatchingJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{8, 0}
}

func (x *SearchJobsResponse_MatchingJob) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

func (x *SearchJobsResponse_MatchingJob) GetJobSummary() string {
	if x != nil {
		return x.JobSummary
	}
	return ""
}

func (x *SearchJobsResponse_MatchingJob) GetJobTitleSnippet() string {
	if x != nil {
		return x.JobTitleSnippet
	}
	return ""
}

func (x *SearchJobsResponse_MatchingJob) GetSearchTextSnippet() string {
	if x != nil {
		return x.SearchTextSnippet
	}
	return ""
}

func (x *SearchJobsResponse_MatchingJob) GetCommuteInfo() *SearchJobsResponse_CommuteInfo {
	if x != nil {
		return x.CommuteInfo
	}
	return nil
}

// Commute details related to this job.
type SearchJobsResponse_CommuteInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location used as the destination in the commute calculation.
	JobLocation *Location `protobuf:"bytes,1,opt,name=job_location,json=jobLocation,proto3" json:"job_location,omitempty"`
	// The number of seconds required to travel to the job location from the
	// query location. A duration of 0 seconds indicates that the job isn't
	// reachable within the requested duration, but was returned as part of an
	// expanded query.
	TravelDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
}

func (x *SearchJobsResponse_CommuteInfo) Reset() {
	*x = SearchJobsResponse_CommuteInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchJobsResponse_CommuteInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchJobsResponse_CommuteInfo) ProtoMessage() {}

func (x *SearchJobsResponse_CommuteInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchJobsResponse_CommuteInfo.ProtoReflect.Descriptor instead.
func (*SearchJobsResponse_CommuteInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{8, 1}
}

func (x *SearchJobsResponse_CommuteInfo) GetJobLocation() *Location {
	if x != nil {
		return x.JobLocation
	}
	return nil
}

func (x *SearchJobsResponse_CommuteInfo) GetTravelDuration() *durationpb.Duration {
	if x != nil {
		return x.TravelDuration
	}
	return nil
}

// Mutation result of a job.
type JobOperationResult_JobResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Here [Job][google.cloud.talent.v4beta1.Job] only contains basic information including [name][google.cloud.talent.v4beta1.Job.name],
	// [company][google.cloud.talent.v4beta1.Job.company], [language_code][google.cloud.talent.v4beta1.Job.language_code]
	// and [requisition_id][google.cloud.talent.v4beta1.Job.requisition_id], use getJob method to retrieve
	// detailed information of the created/updated job.
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// The status of the job processed. This field is populated if the
	// processing of the [job][google.cloud.talent.v4beta1.JobOperationResult.JobResult.job] fails.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *JobOperationResult_JobResult) Reset() {
	*x = JobOperationResult_JobResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobOperationResult_JobResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobOperationResult_JobResult) ProtoMessage() {}

func (x *JobOperationResult_JobResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobOperationResult_JobResult.ProtoReflect.Descriptor instead.
func (*JobOperationResult_JobResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP(), []int{11, 0}
}

func (x *JobOperationResult_JobResult) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

func (x *JobOperationResult_JobResult) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

var File_google_cloud_talent_v4beta1_job_service_proto protoreflect.FileDescriptor

var file_google_cloud_talent_v4beta1_job_service_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a, 0x6f,
	0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a,
	0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x84, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x19, 0x12, 0x17, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x44, 0x0a, 0x0d,
	0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x19, 0x0a, 0x17, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x88, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6a, 0x6f, 0x62,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x47, 0x0a,
	0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x33, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x1f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x19, 0x0a, 0x17, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x37, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x19, 0x12, 0x17, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f,
	0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xe4, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4a,
	0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x19, 0x12, 0x17, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x3f, 0x0a, 0x08,
	0x6a, 0x6f, 0x62, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x56, 0x69, 0x65, 0x77, 0x22, 0xbb, 0x01,
	0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x34, 0x0a, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x52, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x49, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xcc, 0x0d, 0x0a, 0x11,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x19, 0x12, 0x17, 0x6a, 0x6f, 0x62, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a,
	0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0b, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x42, 0x0a, 0x09, 0x6a, 0x6f, 0x62, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x08,
	0x6a, 0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x72, 0x6f, 0x61, 0x64,
	0x65, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x41, 0x0a, 0x1b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x18,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x58, 0x0a, 0x11, 0x68, 0x69, 0x73, 0x74,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x10, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x3f, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x56, 0x69, 0x65, 0x77, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x12, 0x78, 0x0a, 0x15, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x44, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x14, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x70, 0x0a, 0x13,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x11, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32,
	0x0a, 0x15, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x6d, 0x0a, 0x12, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52,
	0x10, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64,
	0x65, 0x1a, 0xbf, 0x02, 0x0a, 0x11, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61, 0x6e, 0x6b,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x80, 0x01, 0x0a, 0x10, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x32, 0x0a, 0x12, 0x72, 0x61,
	0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x72, 0x61, 0x6e,
	0x6b, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x73,
	0x0a, 0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f,
	0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x07, 0x0a,
	0x03, 0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x49, 0x4c, 0x44, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04,
	0x48, 0x49, 0x47, 0x48, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x54, 0x52, 0x45, 0x4d,
	0x45, 0x10, 0x06, 0x22, 0x52, 0x0a, 0x0a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x01, 0x12, 0x17,
	0x0a, 0x13, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x44, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x53,
	0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x02, 0x22, 0x57, 0x0a, 0x14, 0x44, 0x69, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12,
	0x25, 0x0a, 0x21, 0x44, 0x49, 0x56, 0x45, 0x52, 0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x4d, 0x50, 0x4c, 0x45, 0x10, 0x02,
	0x22, 0x87, 0x01, 0x0a, 0x10, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x4b, 0x45, 0x59, 0x57, 0x4f, 0x52, 0x44,
	0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4b, 0x45, 0x59,
	0x57, 0x4f, 0x52, 0x44, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x4b, 0x45, 0x59, 0x57, 0x4f, 0x52, 0x44,
	0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18,
	0x4b, 0x45, 0x59, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x49,
	0x54, 0x4c, 0x45, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x03, 0x22, 0xcf, 0x08, 0x0a, 0x12, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x60, 0x0a, 0x0d, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f,
	0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x4a,
	0x6f, 0x62, 0x73, 0x12, 0x69, 0x0a, 0x17, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x15, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x50, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x73, 0x74, 0x69,
	0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x1a, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x65, 0x6e, 0x65,
	0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x65,
	0x6e, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4a, 0x6f, 0x62, 0x73, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x5a, 0x0a, 0x10, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x72, 0x72, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x70,
	0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x9e, 0x02,
	0x0a, 0x0b, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x0a,
	0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f,
	0x62, 0x12, 0x1f, 0x0a, 0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6a, 0x6f, 0x62, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x12, 0x2a, 0x0a, 0x11, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x5f,
	0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6a,
	0x6f, 0x62, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x2e,
	0x0a, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x5e,
	0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x9b,
	0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x48,
	0x0a, 0x0c, 0x6a, 0x6f, 0x62, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6a, 0x6f, 0x62,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x76,
	0x65, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x74, 0x72,
	0x61, 0x76, 0x65, 0x6c, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0x0a,
	0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x19, 0x12,
	0x17, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x39, 0x0a, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x22, 0xc9, 0x01, 0x0a, 0x16,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x19, 0x12, 0x17,
	0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x39, 0x0a, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xdd, 0x01, 0x0a, 0x12, 0x4a, 0x6f, 0x62, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5a,
	0x0a, 0x0b, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0a,
	0x6a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x6b, 0x0a, 0x09, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x32, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x12, 0x2a, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2a, 0x76, 0x0a, 0x07, 0x4a, 0x6f, 0x62, 0x56, 0x69,
	0x65, 0x77, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10,
	0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x49, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x4d,
	0x49, 0x4e, 0x49, 0x4d, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4a, 0x4f, 0x42, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d,
	0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x04, 0x32,
	0xce, 0x12, 0x0a, 0x0a, 0x4a, 0x6f, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc9,
	0x01, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x22, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x58, 0x22, 0x2b, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x26, 0x22, 0x21, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0a,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6a, 0x6f, 0x62, 0x12, 0x9b, 0x02, 0x0a, 0x0f, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb3, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x70, 0x22, 0x37, 0x2f, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x32, 0x22, 0x2d, 0x2f, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6a, 0x6f, 0x62, 0x73, 0xca, 0x41, 0x2c, 0x0a, 0x12, 0x4a, 0x6f,
	0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb7, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74,
	0x4a, 0x6f, 0x62, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x2b, 0x2f, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a,
	0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xca, 0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x32, 0x2f, 0x2f, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x5a, 0x2a, 0x32,
	0x25, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a,
	0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x03, 0x6a, 0x6f, 0x62, 0x12,
	0x9b, 0x02, 0x0a, 0x0f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4a,
	0x6f, 0x62, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb3, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x70,
	0x22, 0x37, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x32, 0x22, 0x2d,
	0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6a, 0x6f, 0x62, 0x73, 0xca, 0x41,
	0x2c, 0x0a, 0x12, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb3, 0x01,
	0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x2a, 0x2b, 0x2f, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x23, 0x2a, 0x21, 0x2f, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xe4, 0x01, 0x0a, 0x0f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6d, 0x22, 0x37, 0x2f,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x2f, 0x22, 0x2d, 0x2f, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0xd1, 0x01, 0x0a, 0x08, 0x4c,
	0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x2b, 0x2f, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x5a, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0xda, 0x41,
	0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0xdb,
	0x01, 0x0a, 0x0a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x22, 0x32, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a,
	0x6f, 0x62, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0x5a, 0x2d, 0x22,
	0x28, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0x12, 0xf3, 0x01, 0x0a,
	0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x46, 0x6f, 0x72, 0x41, 0x6c,
	0x65, 0x72, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x76, 0x22, 0x3a, 0x2f, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x46, 0x6f, 0x72, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x35, 0x22, 0x30, 0x2f,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73,
	0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x6f, 0x72, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x3a,
	0x01, 0x2a, 0x1a, 0x6c, 0xca, 0x41, 0x13, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x53, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6a, 0x6f, 0x62, 0x73,
	0x42, 0x7d, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x42, 0x0f, 0x4a, 0x6f, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x3b, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0xa2, 0x02, 0x03, 0x43, 0x54, 0x53, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_talent_v4beta1_job_service_proto_rawDescOnce sync.Once
	file_google_cloud_talent_v4beta1_job_service_proto_rawDescData = file_google_cloud_talent_v4beta1_job_service_proto_rawDesc
)

func file_google_cloud_talent_v4beta1_job_service_proto_rawDescGZIP() []byte {
	file_google_cloud_talent_v4beta1_job_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_talent_v4beta1_job_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_talent_v4beta1_job_service_proto_rawDescData)
	})
	return file_google_cloud_talent_v4beta1_job_service_proto_rawDescData
}

var file_google_cloud_talent_v4beta1_job_service_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_talent_v4beta1_job_service_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_talent_v4beta1_job_service_proto_goTypes = []interface{}{
	(JobView)(0),                                             // 0: google.cloud.talent.v4beta1.JobView
	(SearchJobsRequest_SearchMode)(0),                        // 1: google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode
	(SearchJobsRequest_DiversificationLevel)(0),              // 2: google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel
	(SearchJobsRequest_KeywordMatchMode)(0),                  // 3: google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode
	(SearchJobsRequest_CustomRankingInfo_ImportanceLevel)(0), // 4: google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
	(*CreateJobRequest)(nil),                                 // 5: google.cloud.talent.v4beta1.CreateJobRequest
	(*GetJobRequest)(nil),                                    // 6: google.cloud.talent.v4beta1.GetJobRequest
	(*UpdateJobRequest)(nil),                                 // 7: google.cloud.talent.v4beta1.UpdateJobRequest
	(*DeleteJobRequest)(nil),                                 // 8: google.cloud.talent.v4beta1.DeleteJobRequest
	(*BatchDeleteJobsRequest)(nil),                           // 9: google.cloud.talent.v4beta1.BatchDeleteJobsRequest
	(*ListJobsRequest)(nil),                                  // 10: google.cloud.talent.v4beta1.ListJobsRequest
	(*ListJobsResponse)(nil),                                 // 11: google.cloud.talent.v4beta1.ListJobsResponse
	(*SearchJobsRequest)(nil),                                // 12: google.cloud.talent.v4beta1.SearchJobsRequest
	(*SearchJobsResponse)(nil),                               // 13: google.cloud.talent.v4beta1.SearchJobsResponse
	(*BatchCreateJobsRequest)(nil),                           // 14: google.cloud.talent.v4beta1.BatchCreateJobsRequest
	(*BatchUpdateJobsRequest)(nil),                           // 15: google.cloud.talent.v4beta1.BatchUpdateJobsRequest
	(*JobOperationResult)(nil),                               // 16: google.cloud.talent.v4beta1.JobOperationResult
	(*SearchJobsRequest_CustomRankingInfo)(nil),              // 17: google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo
	(*SearchJobsResponse_MatchingJob)(nil),                   // 18: google.cloud.talent.v4beta1.SearchJobsResponse.MatchingJob
	(*SearchJobsResponse_CommuteInfo)(nil),                   // 19: google.cloud.talent.v4beta1.SearchJobsResponse.CommuteInfo
	(*JobOperationResult_JobResult)(nil),                     // 20: google.cloud.talent.v4beta1.JobOperationResult.JobResult
	(*Job)(nil),                                              // 21: google.cloud.talent.v4beta1.Job
	(*fieldmaskpb.FieldMask)(nil),                            // 22: google.protobuf.FieldMask
	(*ResponseMetadata)(nil),                                 // 23: google.cloud.talent.v4beta1.ResponseMetadata
	(*RequestMetadata)(nil),                                  // 24: google.cloud.talent.v4beta1.RequestMetadata
	(*JobQuery)(nil),                                         // 25: google.cloud.talent.v4beta1.JobQuery
	(*HistogramQuery)(nil),                                   // 26: google.cloud.talent.v4beta1.HistogramQuery
	(*HistogramQueryResult)(nil),                             // 27: google.cloud.talent.v4beta1.HistogramQueryResult
	(*Location)(nil),                                         // 28: google.cloud.talent.v4beta1.Location
	(*SpellingCorrection)(nil),                               // 29: google.cloud.talent.v4beta1.SpellingCorrection
	(*durationpb.Duration)(nil),                              // 30: google.protobuf.Duration
	(*status.Status)(nil),                                    // 31: google.rpc.Status
	(*longrunning.Operation)(nil),                            // 32: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                    // 33: google.protobuf.Empty
}
var file_google_cloud_talent_v4beta1_job_service_proto_depIdxs = []int32{
	21, // 0: google.cloud.talent.v4beta1.CreateJobRequest.job:type_name -> google.cloud.talent.v4beta1.Job
	21, // 1: google.cloud.talent.v4beta1.UpdateJobRequest.job:type_name -> google.cloud.talent.v4beta1.Job
	22, // 2: google.cloud.talent.v4beta1.UpdateJobRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 3: google.cloud.talent.v4beta1.ListJobsRequest.job_view:type_name -> google.cloud.talent.v4beta1.JobView
	21, // 4: google.cloud.talent.v4beta1.ListJobsResponse.jobs:type_name -> google.cloud.talent.v4beta1.Job
	23, // 5: google.cloud.talent.v4beta1.ListJobsResponse.metadata:type_name -> google.cloud.talent.v4beta1.ResponseMetadata
	1,  // 6: google.cloud.talent.v4beta1.SearchJobsRequest.search_mode:type_name -> google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode
	24, // 7: google.cloud.talent.v4beta1.SearchJobsRequest.request_metadata:type_name -> google.cloud.talent.v4beta1.RequestMetadata
	25, // 8: google.cloud.talent.v4beta1.SearchJobsRequest.job_query:type_name -> google.cloud.talent.v4beta1.JobQuery
	26, // 9: google.cloud.talent.v4beta1.SearchJobsRequest.histogram_queries:type_name -> google.cloud.talent.v4beta1.HistogramQuery
	0,  // 10: google.cloud.talent.v4beta1.SearchJobsRequest.job_view:type_name -> google.cloud.talent.v4beta1.JobView
	2,  // 11: google.cloud.talent.v4beta1.SearchJobsRequest.diversification_level:type_name -> google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel
	17, // 12: google.cloud.talent.v4beta1.SearchJobsRequest.custom_ranking_info:type_name -> google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo
	3,  // 13: google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode:type_name -> google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode
	18, // 14: google.cloud.talent.v4beta1.SearchJobsResponse.matching_jobs:type_name -> google.cloud.talent.v4beta1.SearchJobsResponse.MatchingJob
	27, // 15: google.cloud.talent.v4beta1.SearchJobsResponse.histogram_query_results:type_name -> google.cloud.talent.v4beta1.HistogramQueryResult
	28, // 16: google.cloud.talent.v4beta1.SearchJobsResponse.location_filters:type_name -> google.cloud.talent.v4beta1.Location
	23, // 17: google.cloud.talent.v4beta1.SearchJobsResponse.metadata:type_name -> google.cloud.talent.v4beta1.ResponseMetadata
	29, // 18: google.cloud.talent.v4beta1.SearchJobsResponse.spell_correction:type_name -> google.cloud.talent.v4beta1.SpellingCorrection
	21, // 19: google.cloud.talent.v4beta1.BatchCreateJobsRequest.jobs:type_name -> google.cloud.talent.v4beta1.Job
	21, // 20: google.cloud.talent.v4beta1.BatchUpdateJobsRequest.jobs:type_name -> google.cloud.talent.v4beta1.Job
	22, // 21: google.cloud.talent.v4beta1.BatchUpdateJobsRequest.update_mask:type_name -> google.protobuf.FieldMask
	20, // 22: google.cloud.talent.v4beta1.JobOperationResult.job_results:type_name -> google.cloud.talent.v4beta1.JobOperationResult.JobResult
	4,  // 23: google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.importance_level:type_name -> google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
	21, // 24: google.cloud.talent.v4beta1.SearchJobsResponse.MatchingJob.job:type_name -> google.cloud.talent.v4beta1.Job
	19, // 25: google.cloud.talent.v4beta1.SearchJobsResponse.MatchingJob.commute_info:type_name -> google.cloud.talent.v4beta1.SearchJobsResponse.CommuteInfo
	28, // 26: google.cloud.talent.v4beta1.SearchJobsResponse.CommuteInfo.job_location:type_name -> google.cloud.talent.v4beta1.Location
	30, // 27: google.cloud.talent.v4beta1.SearchJobsResponse.CommuteInfo.travel_duration:type_name -> google.protobuf.Duration
	21, // 28: google.cloud.talent.v4beta1.JobOperationResult.JobResult.job:type_name -> google.cloud.talent.v4beta1.Job
	31, // 29: google.cloud.talent.v4beta1.JobOperationResult.JobResult.status:type_name -> google.rpc.Status
	5,  // 30: google.cloud.talent.v4beta1.JobService.CreateJob:input_type -> google.cloud.talent.v4beta1.CreateJobRequest
	14, // 31: google.cloud.talent.v4beta1.JobService.BatchCreateJobs:input_type -> google.cloud.talent.v4beta1.BatchCreateJobsRequest
	6,  // 32: google.cloud.talent.v4beta1.JobService.GetJob:input_type -> google.cloud.talent.v4beta1.GetJobRequest
	7,  // 33: google.cloud.talent.v4beta1.JobService.UpdateJob:input_type -> google.cloud.talent.v4beta1.UpdateJobRequest
	15, // 34: google.cloud.talent.v4beta1.JobService.BatchUpdateJobs:input_type -> google.cloud.talent.v4beta1.BatchUpdateJobsRequest
	8,  // 35: google.cloud.talent.v4beta1.JobService.DeleteJob:input_type -> google.cloud.talent.v4beta1.DeleteJobRequest
	9,  // 36: google.cloud.talent.v4beta1.JobService.BatchDeleteJobs:input_type -> google.cloud.talent.v4beta1.BatchDeleteJobsRequest
	10, // 37: google.cloud.talent.v4beta1.JobService.ListJobs:input_type -> google.cloud.talent.v4beta1.ListJobsRequest
	12, // 38: google.cloud.talent.v4beta1.JobService.SearchJobs:input_type -> google.cloud.talent.v4beta1.SearchJobsRequest
	12, // 39: google.cloud.talent.v4beta1.JobService.SearchJobsForAlert:input_type -> google.cloud.talent.v4beta1.SearchJobsRequest
	21, // 40: google.cloud.talent.v4beta1.JobService.CreateJob:output_type -> google.cloud.talent.v4beta1.Job
	32, // 41: google.cloud.talent.v4beta1.JobService.BatchCreateJobs:output_type -> google.longrunning.Operation
	21, // 42: google.cloud.talent.v4beta1.JobService.GetJob:output_type -> google.cloud.talent.v4beta1.Job
	21, // 43: google.cloud.talent.v4beta1.JobService.UpdateJob:output_type -> google.cloud.talent.v4beta1.Job
	32, // 44: google.cloud.talent.v4beta1.JobService.BatchUpdateJobs:output_type -> google.longrunning.Operation
	33, // 45: google.cloud.talent.v4beta1.JobService.DeleteJob:output_type -> google.protobuf.Empty
	33, // 46: google.cloud.talent.v4beta1.JobService.BatchDeleteJobs:output_type -> google.protobuf.Empty
	11, // 47: google.cloud.talent.v4beta1.JobService.ListJobs:output_type -> google.cloud.talent.v4beta1.ListJobsResponse
	13, // 48: google.cloud.talent.v4beta1.JobService.SearchJobs:output_type -> google.cloud.talent.v4beta1.SearchJobsResponse
	13, // 49: google.cloud.talent.v4beta1.JobService.SearchJobsForAlert:output_type -> google.cloud.talent.v4beta1.SearchJobsResponse
	40, // [40:50] is the sub-list for method output_type
	30, // [30:40] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_talent_v4beta1_job_service_proto_init() }
func file_google_cloud_talent_v4beta1_job_service_proto_init() {
	if File_google_cloud_talent_v4beta1_job_service_proto != nil {
		return
	}
	file_google_cloud_talent_v4beta1_common_proto_init()
	file_google_cloud_talent_v4beta1_filters_proto_init()
	file_google_cloud_talent_v4beta1_histogram_proto_init()
	file_google_cloud_talent_v4beta1_job_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobOperationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchJobsRequest_CustomRankingInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchJobsResponse_MatchingJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchJobsResponse_CommuteInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_job_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobOperationResult_JobResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_talent_v4beta1_job_service_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_talent_v4beta1_job_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_talent_v4beta1_job_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_talent_v4beta1_job_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_talent_v4beta1_job_service_proto_msgTypes,
	}.Build()
	File_google_cloud_talent_v4beta1_job_service_proto = out.File
	file_google_cloud_talent_v4beta1_job_service_proto_rawDesc = nil
	file_google_cloud_talent_v4beta1_job_service_proto_goTypes = nil
	file_google_cloud_talent_v4beta1_job_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Creates a new job.
	//
	// Typically, the job becomes searchable within 10 seconds, but it may take
	// up to 5 minutes.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Begins executing a batch create jobs operation.
	BatchCreateJobs(ctx context.Context, in *BatchCreateJobsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Retrieves the specified job, whose status is OPEN or recently EXPIRED
	// within the last 90 days.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Updates specified job.
	//
	// Typically, updated contents become visible in search results within 10
	// seconds, but it may take up to 5 minutes.
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Begins executing a batch update jobs operation.
	BatchUpdateJobs(ctx context.Context, in *BatchUpdateJobsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes the specified job.
	//
	// Typically, the job becomes unsearchable within 10 seconds, but it may take
	// up to 5 minutes.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes a list of [Job][google.cloud.talent.v4beta1.Job]s by filter.
	BatchDeleteJobs(ctx context.Context, in *BatchDeleteJobsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists jobs by filter.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Searches for jobs using the provided [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This call constrains the [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs
	// present in the database, and only returns jobs that the caller has
	// permission to search against.
	SearchJobs(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error)
	// Searches for jobs using the provided [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This API call is intended for the use case of targeting passive job
	// seekers (for example, job seekers who have signed up to receive email
	// alerts about potential job opportunities), and has different algorithmic
	// adjustments that are targeted to passive job seekers.
	//
	// This call constrains the [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs
	// present in the database, and only returns jobs the caller has
	// permission to search against.
	SearchJobsForAlert(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error)
}

type jobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewJobServiceClient(cc grpc.ClientConnInterface) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/CreateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchCreateJobs(ctx context.Context, in *BatchCreateJobsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/BatchCreateJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/GetJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/UpdateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchUpdateJobs(ctx context.Context, in *BatchUpdateJobsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/BatchUpdateJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/DeleteJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchDeleteJobs(ctx context.Context, in *BatchDeleteJobsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/BatchDeleteJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/ListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchJobs(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error) {
	out := new(SearchJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/SearchJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchJobsForAlert(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error) {
	out := new(SearchJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/SearchJobsForAlert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Creates a new job.
	//
	// Typically, the job becomes searchable within 10 seconds, but it may take
	// up to 5 minutes.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Begins executing a batch create jobs operation.
	BatchCreateJobs(context.Context, *BatchCreateJobsRequest) (*longrunning.Operation, error)
	// Retrieves the specified job, whose status is OPEN or recently EXPIRED
	// within the last 90 days.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Updates specified job.
	//
	// Typically, updated contents become visible in search results within 10
	// seconds, but it may take up to 5 minutes.
	UpdateJob(context.Context, *UpdateJobRequest) (*Job, error)
	// Begins executing a batch update jobs operation.
	BatchUpdateJobs(context.Context, *BatchUpdateJobsRequest) (*longrunning.Operation, error)
	// Deletes the specified job.
	//
	// Typically, the job becomes unsearchable within 10 seconds, but it may take
	// up to 5 minutes.
	DeleteJob(context.Context, *DeleteJobRequest) (*emptypb.Empty, error)
	// Deletes a list of [Job][google.cloud.talent.v4beta1.Job]s by filter.
	BatchDeleteJobs(context.Context, *BatchDeleteJobsRequest) (*emptypb.Empty, error)
	// Lists jobs by filter.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Searches for jobs using the provided [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This call constrains the [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs
	// present in the database, and only returns jobs that the caller has
	// permission to search against.
	SearchJobs(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error)
	// Searches for jobs using the provided [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This API call is intended for the use case of targeting passive job
	// seekers (for example, job seekers who have signed up to receive email
	// alerts about potential job opportunities), and has different algorithmic
	// adjustments that are targeted to passive job seekers.
	//
	// This call constrains the [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs
	// present in the database, and only returns jobs the caller has
	// permission to search against.
	SearchJobsForAlert(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error)
}

// UnimplementedJobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedJobServiceServer struct {
}

func (*UnimplementedJobServiceServer) CreateJob(context.Context, *CreateJobRequest) (*Job, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateJob not implemented")
}
func (*UnimplementedJobServiceServer) BatchCreateJobs(context.Context, *BatchCreateJobsRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchCreateJobs not implemented")
}
func (*UnimplementedJobServiceServer) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (*UnimplementedJobServiceServer) UpdateJob(context.Context, *UpdateJobRequest) (*Job, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateJob not implemented")
}
func (*UnimplementedJobServiceServer) BatchUpdateJobs(context.Context, *BatchUpdateJobsRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchUpdateJobs not implemented")
}
func (*UnimplementedJobServiceServer) DeleteJob(context.Context, *DeleteJobRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteJob not implemented")
}
func (*UnimplementedJobServiceServer) BatchDeleteJobs(context.Context, *BatchDeleteJobsRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchDeleteJobs not implemented")
}
func (*UnimplementedJobServiceServer) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (*UnimplementedJobServiceServer) SearchJobs(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchJobs not implemented")
}
func (*UnimplementedJobServiceServer) SearchJobsForAlert(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchJobsForAlert not implemented")
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/CreateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchCreateJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchCreateJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/BatchCreateJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchCreateJobs(ctx, req.(*BatchCreateJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/UpdateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchUpdateJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchUpdateJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/BatchUpdateJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchUpdateJobs(ctx, req.(*BatchUpdateJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/DeleteJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchDeleteJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchDeleteJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/BatchDeleteJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchDeleteJobs(ctx, req.(*BatchDeleteJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/SearchJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchJobs(ctx, req.(*SearchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchJobsForAlert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchJobsForAlert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/SearchJobsForAlert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchJobsForAlert(ctx, req.(*SearchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobService_CreateJob_Handler,
		},
		{
			MethodName: "BatchCreateJobs",
			Handler:    _JobService_BatchCreateJobs_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobService_GetJob_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _JobService_UpdateJob_Handler,
		},
		{
			MethodName: "BatchUpdateJobs",
			Handler:    _JobService_BatchUpdateJobs_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _JobService_DeleteJob_Handler,
		},
		{
			MethodName: "BatchDeleteJobs",
			Handler:    _JobService_BatchDeleteJobs_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobService_ListJobs_Handler,
		},
		{
			MethodName: "SearchJobs",
			Handler:    _JobService_SearchJobs_Handler,
		},
		{
			MethodName: "SearchJobsForAlert",
			Handler:    _JobService_SearchJobsForAlert_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/job_service.proto",
}
