// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package baremetalsolution

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	baremetalsolutionpb "google.golang.org/genproto/googleapis/cloud/baremetalsolution/v2"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListInstances                []gax.CallOption
	GetInstance                  []gax.CallOption
	ResetInstance                []gax.CallOption
	ListVolumes                  []gax.CallOption
	GetVolume                    []gax.CallOption
	UpdateVolume                 []gax.CallOption
	ListNetworks                 []gax.CallOption
	GetNetwork                   []gax.CallOption
	ListSnapshotSchedulePolicies []gax.CallOption
	GetSnapshotSchedulePolicy    []gax.CallOption
	CreateSnapshotSchedulePolicy []gax.CallOption
	UpdateSnapshotSchedulePolicy []gax.CallOption
	DeleteSnapshotSchedulePolicy []gax.CallOption
	CreateVolumeSnapshot         []gax.CallOption
	RestoreVolumeSnapshot        []gax.CallOption
	DeleteVolumeSnapshot         []gax.CallOption
	GetVolumeSnapshot            []gax.CallOption
	ListVolumeSnapshots          []gax.CallOption
	GetLun                       []gax.CallOption
	ListLuns                     []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("baremetalsolution.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("baremetalsolution.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://baremetalsolution.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListInstances:                []gax.CallOption{},
		GetInstance:                  []gax.CallOption{},
		ResetInstance:                []gax.CallOption{},
		ListVolumes:                  []gax.CallOption{},
		GetVolume:                    []gax.CallOption{},
		UpdateVolume:                 []gax.CallOption{},
		ListNetworks:                 []gax.CallOption{},
		GetNetwork:                   []gax.CallOption{},
		ListSnapshotSchedulePolicies: []gax.CallOption{},
		GetSnapshotSchedulePolicy:    []gax.CallOption{},
		CreateSnapshotSchedulePolicy: []gax.CallOption{},
		UpdateSnapshotSchedulePolicy: []gax.CallOption{},
		DeleteSnapshotSchedulePolicy: []gax.CallOption{},
		CreateVolumeSnapshot:         []gax.CallOption{},
		RestoreVolumeSnapshot:        []gax.CallOption{},
		DeleteVolumeSnapshot:         []gax.CallOption{},
		GetVolumeSnapshot:            []gax.CallOption{},
		ListVolumeSnapshots:          []gax.CallOption{},
		GetLun:                       []gax.CallOption{},
		ListLuns:                     []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Bare Metal Solution API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListInstances(context.Context, *baremetalsolutionpb.ListInstancesRequest, ...gax.CallOption) *InstanceIterator
	GetInstance(context.Context, *baremetalsolutionpb.GetInstanceRequest, ...gax.CallOption) (*baremetalsolutionpb.Instance, error)
	ResetInstance(context.Context, *baremetalsolutionpb.ResetInstanceRequest, ...gax.CallOption) (*ResetInstanceOperation, error)
	ResetInstanceOperation(name string) *ResetInstanceOperation
	ListVolumes(context.Context, *baremetalsolutionpb.ListVolumesRequest, ...gax.CallOption) *VolumeIterator
	GetVolume(context.Context, *baremetalsolutionpb.GetVolumeRequest, ...gax.CallOption) (*baremetalsolutionpb.Volume, error)
	UpdateVolume(context.Context, *baremetalsolutionpb.UpdateVolumeRequest, ...gax.CallOption) (*UpdateVolumeOperation, error)
	UpdateVolumeOperation(name string) *UpdateVolumeOperation
	ListNetworks(context.Context, *baremetalsolutionpb.ListNetworksRequest, ...gax.CallOption) *NetworkIterator
	GetNetwork(context.Context, *baremetalsolutionpb.GetNetworkRequest, ...gax.CallOption) (*baremetalsolutionpb.Network, error)
	ListSnapshotSchedulePolicies(context.Context, *baremetalsolutionpb.ListSnapshotSchedulePoliciesRequest, ...gax.CallOption) *SnapshotSchedulePolicyIterator
	GetSnapshotSchedulePolicy(context.Context, *baremetalsolutionpb.GetSnapshotSchedulePolicyRequest, ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error)
	CreateSnapshotSchedulePolicy(context.Context, *baremetalsolutionpb.CreateSnapshotSchedulePolicyRequest, ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error)
	UpdateSnapshotSchedulePolicy(context.Context, *baremetalsolutionpb.UpdateSnapshotSchedulePolicyRequest, ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error)
	DeleteSnapshotSchedulePolicy(context.Context, *baremetalsolutionpb.DeleteSnapshotSchedulePolicyRequest, ...gax.CallOption) error
	CreateVolumeSnapshot(context.Context, *baremetalsolutionpb.CreateVolumeSnapshotRequest, ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error)
	RestoreVolumeSnapshot(context.Context, *baremetalsolutionpb.RestoreVolumeSnapshotRequest, ...gax.CallOption) (*RestoreVolumeSnapshotOperation, error)
	RestoreVolumeSnapshotOperation(name string) *RestoreVolumeSnapshotOperation
	DeleteVolumeSnapshot(context.Context, *baremetalsolutionpb.DeleteVolumeSnapshotRequest, ...gax.CallOption) error
	GetVolumeSnapshot(context.Context, *baremetalsolutionpb.GetVolumeSnapshotRequest, ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error)
	ListVolumeSnapshots(context.Context, *baremetalsolutionpb.ListVolumeSnapshotsRequest, ...gax.CallOption) *VolumeSnapshotIterator
	GetLun(context.Context, *baremetalsolutionpb.GetLunRequest, ...gax.CallOption) (*baremetalsolutionpb.Lun, error)
	ListLuns(context.Context, *baremetalsolutionpb.ListLunsRequest, ...gax.CallOption) *LunIterator
}

// Client is a client for interacting with Bare Metal Solution API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Performs management operations on Bare Metal Solution servers.
//
// The baremetalsolution.googleapis.com service provides management
// capabilities for Bare Metal Solution servers. To access the API methods, you
// must assign Bare Metal Solution IAM roles containing the desired permissions
// to your staff in your Google Cloud project. You must also enable the Bare
// Metal Solution API. Once enabled, the methods act
// upon specific servers in your Bare Metal Solution environment.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListInstances list servers in a given project and location.
func (c *Client) ListInstances(ctx context.Context, req *baremetalsolutionpb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	return c.internalClient.ListInstances(ctx, req, opts...)
}

// GetInstance get details about a single server.
func (c *Client) GetInstance(ctx context.Context, req *baremetalsolutionpb.GetInstanceRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Instance, error) {
	return c.internalClient.GetInstance(ctx, req, opts...)
}

// ResetInstance perform an ungraceful, hard reset on a server. Equivalent to shutting the
// power off and then turning it back on.
func (c *Client) ResetInstance(ctx context.Context, req *baremetalsolutionpb.ResetInstanceRequest, opts ...gax.CallOption) (*ResetInstanceOperation, error) {
	return c.internalClient.ResetInstance(ctx, req, opts...)
}

// ResetInstanceOperation returns a new ResetInstanceOperation from a given name.
// The name must be that of a previously created ResetInstanceOperation, possibly from a different process.
func (c *Client) ResetInstanceOperation(name string) *ResetInstanceOperation {
	return c.internalClient.ResetInstanceOperation(name)
}

// ListVolumes list storage volumes in a given project and location.
func (c *Client) ListVolumes(ctx context.Context, req *baremetalsolutionpb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	return c.internalClient.ListVolumes(ctx, req, opts...)
}

// GetVolume get details of a single storage volume.
func (c *Client) GetVolume(ctx context.Context, req *baremetalsolutionpb.GetVolumeRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	return c.internalClient.GetVolume(ctx, req, opts...)
}

// UpdateVolume update details of a single storage volume.
func (c *Client) UpdateVolume(ctx context.Context, req *baremetalsolutionpb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	return c.internalClient.UpdateVolume(ctx, req, opts...)
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *Client) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	return c.internalClient.UpdateVolumeOperation(name)
}

// ListNetworks list network in a given project and location.
func (c *Client) ListNetworks(ctx context.Context, req *baremetalsolutionpb.ListNetworksRequest, opts ...gax.CallOption) *NetworkIterator {
	return c.internalClient.ListNetworks(ctx, req, opts...)
}

// GetNetwork get details of a single network.
func (c *Client) GetNetwork(ctx context.Context, req *baremetalsolutionpb.GetNetworkRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Network, error) {
	return c.internalClient.GetNetwork(ctx, req, opts...)
}

// ListSnapshotSchedulePolicies list snapshot schedule policies in a given project and location.
func (c *Client) ListSnapshotSchedulePolicies(ctx context.Context, req *baremetalsolutionpb.ListSnapshotSchedulePoliciesRequest, opts ...gax.CallOption) *SnapshotSchedulePolicyIterator {
	return c.internalClient.ListSnapshotSchedulePolicies(ctx, req, opts...)
}

// GetSnapshotSchedulePolicy get details of a single snapshot schedule policy.
func (c *Client) GetSnapshotSchedulePolicy(ctx context.Context, req *baremetalsolutionpb.GetSnapshotSchedulePolicyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error) {
	return c.internalClient.GetSnapshotSchedulePolicy(ctx, req, opts...)
}

// CreateSnapshotSchedulePolicy create a snapshot schedule policy in the specified project.
func (c *Client) CreateSnapshotSchedulePolicy(ctx context.Context, req *baremetalsolutionpb.CreateSnapshotSchedulePolicyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error) {
	return c.internalClient.CreateSnapshotSchedulePolicy(ctx, req, opts...)
}

// UpdateSnapshotSchedulePolicy update a snapshot schedule policy in the specified project.
func (c *Client) UpdateSnapshotSchedulePolicy(ctx context.Context, req *baremetalsolutionpb.UpdateSnapshotSchedulePolicyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error) {
	return c.internalClient.UpdateSnapshotSchedulePolicy(ctx, req, opts...)
}

// DeleteSnapshotSchedulePolicy delete a named snapshot schedule policy.
func (c *Client) DeleteSnapshotSchedulePolicy(ctx context.Context, req *baremetalsolutionpb.DeleteSnapshotSchedulePolicyRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteSnapshotSchedulePolicy(ctx, req, opts...)
}

// CreateVolumeSnapshot create a storage volume snapshot in a containing volume.
func (c *Client) CreateVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.CreateVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	return c.internalClient.CreateVolumeSnapshot(ctx, req, opts...)
}

// RestoreVolumeSnapshot restore a storage volume snapshot to its containing volume.
func (c *Client) RestoreVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.RestoreVolumeSnapshotRequest, opts ...gax.CallOption) (*RestoreVolumeSnapshotOperation, error) {
	return c.internalClient.RestoreVolumeSnapshot(ctx, req, opts...)
}

// RestoreVolumeSnapshotOperation returns a new RestoreVolumeSnapshotOperation from a given name.
// The name must be that of a previously created RestoreVolumeSnapshotOperation, possibly from a different process.
func (c *Client) RestoreVolumeSnapshotOperation(name string) *RestoreVolumeSnapshotOperation {
	return c.internalClient.RestoreVolumeSnapshotOperation(name)
}

// DeleteVolumeSnapshot deletes a storage volume snapshot for a given volume.
func (c *Client) DeleteVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.DeleteVolumeSnapshotRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteVolumeSnapshot(ctx, req, opts...)
}

// GetVolumeSnapshot get details of a single storage volume snapshot.
func (c *Client) GetVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.GetVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	return c.internalClient.GetVolumeSnapshot(ctx, req, opts...)
}

// ListVolumeSnapshots list storage volume snapshots for given storage volume.
func (c *Client) ListVolumeSnapshots(ctx context.Context, req *baremetalsolutionpb.ListVolumeSnapshotsRequest, opts ...gax.CallOption) *VolumeSnapshotIterator {
	return c.internalClient.ListVolumeSnapshots(ctx, req, opts...)
}

// GetLun get details of a single storage logical unit number(LUN).
func (c *Client) GetLun(ctx context.Context, req *baremetalsolutionpb.GetLunRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Lun, error) {
	return c.internalClient.GetLun(ctx, req, opts...)
}

// ListLuns list storage volume luns for given storage volume.
func (c *Client) ListLuns(ctx context.Context, req *baremetalsolutionpb.ListLunsRequest, opts ...gax.CallOption) *LunIterator {
	return c.internalClient.ListLuns(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Bare Metal Solution API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client baremetalsolutionpb.BareMetalSolutionClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewClient creates a new bare metal solution client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Performs management operations on Bare Metal Solution servers.
//
// The baremetalsolution.googleapis.com service provides management
// capabilities for Bare Metal Solution servers. To access the API methods, you
// must assign Bare Metal Solution IAM roles containing the desired permissions
// to your staff in your Google Cloud project. You must also enable the Bare
// Metal Solution API. Once enabled, the methods act
// upon specific servers in your Bare Metal Solution environment.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		disableDeadlines: disableDeadlines,
		client:           baremetalsolutionpb.NewBareMetalSolutionClient(connPool),
		CallOptions:      &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *gRPCClient) ListInstances(ctx context.Context, req *baremetalsolutionpb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListInstances[0:len((*c.CallOptions).ListInstances):len((*c.CallOptions).ListInstances)], opts...)
	it := &InstanceIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListInstancesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Instance, string, error) {
		resp := &baremetalsolutionpb.ListInstancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListInstances(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetInstances(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetInstance(ctx context.Context, req *baremetalsolutionpb.GetInstanceRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Instance, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetInstance[0:len((*c.CallOptions).GetInstance):len((*c.CallOptions).GetInstance)], opts...)
	var resp *baremetalsolutionpb.Instance
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ResetInstance(ctx context.Context, req *baremetalsolutionpb.ResetInstanceRequest, opts ...gax.CallOption) (*ResetInstanceOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ResetInstance[0:len((*c.CallOptions).ResetInstance):len((*c.CallOptions).ResetInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ResetInstance(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResetInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListVolumes(ctx context.Context, req *baremetalsolutionpb.ListVolumesRequest, opts ...gax.CallOption) *VolumeIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListVolumes[0:len((*c.CallOptions).ListVolumes):len((*c.CallOptions).ListVolumes)], opts...)
	it := &VolumeIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListVolumesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Volume, string, error) {
		resp := &baremetalsolutionpb.ListVolumesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListVolumes(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVolumes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetVolume(ctx context.Context, req *baremetalsolutionpb.GetVolumeRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetVolume[0:len((*c.CallOptions).GetVolume):len((*c.CallOptions).GetVolume)], opts...)
	var resp *baremetalsolutionpb.Volume
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateVolume(ctx context.Context, req *baremetalsolutionpb.UpdateVolumeRequest, opts ...gax.CallOption) (*UpdateVolumeOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "volume.name", url.QueryEscape(req.GetVolume().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateVolume[0:len((*c.CallOptions).UpdateVolume):len((*c.CallOptions).UpdateVolume)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateVolume(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListNetworks(ctx context.Context, req *baremetalsolutionpb.ListNetworksRequest, opts ...gax.CallOption) *NetworkIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListNetworks[0:len((*c.CallOptions).ListNetworks):len((*c.CallOptions).ListNetworks)], opts...)
	it := &NetworkIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListNetworksRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Network, string, error) {
		resp := &baremetalsolutionpb.ListNetworksResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListNetworks(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetNetworks(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetNetwork(ctx context.Context, req *baremetalsolutionpb.GetNetworkRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Network, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetNetwork[0:len((*c.CallOptions).GetNetwork):len((*c.CallOptions).GetNetwork)], opts...)
	var resp *baremetalsolutionpb.Network
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetNetwork(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListSnapshotSchedulePolicies(ctx context.Context, req *baremetalsolutionpb.ListSnapshotSchedulePoliciesRequest, opts ...gax.CallOption) *SnapshotSchedulePolicyIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListSnapshotSchedulePolicies[0:len((*c.CallOptions).ListSnapshotSchedulePolicies):len((*c.CallOptions).ListSnapshotSchedulePolicies)], opts...)
	it := &SnapshotSchedulePolicyIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListSnapshotSchedulePoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.SnapshotSchedulePolicy, string, error) {
		resp := &baremetalsolutionpb.ListSnapshotSchedulePoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListSnapshotSchedulePolicies(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSnapshotSchedulePolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetSnapshotSchedulePolicy(ctx context.Context, req *baremetalsolutionpb.GetSnapshotSchedulePolicyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetSnapshotSchedulePolicy[0:len((*c.CallOptions).GetSnapshotSchedulePolicy):len((*c.CallOptions).GetSnapshotSchedulePolicy)], opts...)
	var resp *baremetalsolutionpb.SnapshotSchedulePolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetSnapshotSchedulePolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateSnapshotSchedulePolicy(ctx context.Context, req *baremetalsolutionpb.CreateSnapshotSchedulePolicyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateSnapshotSchedulePolicy[0:len((*c.CallOptions).CreateSnapshotSchedulePolicy):len((*c.CallOptions).CreateSnapshotSchedulePolicy)], opts...)
	var resp *baremetalsolutionpb.SnapshotSchedulePolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateSnapshotSchedulePolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateSnapshotSchedulePolicy(ctx context.Context, req *baremetalsolutionpb.UpdateSnapshotSchedulePolicyRequest, opts ...gax.CallOption) (*baremetalsolutionpb.SnapshotSchedulePolicy, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "snapshot_schedule_policy.name", url.QueryEscape(req.GetSnapshotSchedulePolicy().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateSnapshotSchedulePolicy[0:len((*c.CallOptions).UpdateSnapshotSchedulePolicy):len((*c.CallOptions).UpdateSnapshotSchedulePolicy)], opts...)
	var resp *baremetalsolutionpb.SnapshotSchedulePolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateSnapshotSchedulePolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteSnapshotSchedulePolicy(ctx context.Context, req *baremetalsolutionpb.DeleteSnapshotSchedulePolicyRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteSnapshotSchedulePolicy[0:len((*c.CallOptions).DeleteSnapshotSchedulePolicy):len((*c.CallOptions).DeleteSnapshotSchedulePolicy)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteSnapshotSchedulePolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) CreateVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.CreateVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateVolumeSnapshot[0:len((*c.CallOptions).CreateVolumeSnapshot):len((*c.CallOptions).CreateVolumeSnapshot)], opts...)
	var resp *baremetalsolutionpb.VolumeSnapshot
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateVolumeSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) RestoreVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.RestoreVolumeSnapshotRequest, opts ...gax.CallOption) (*RestoreVolumeSnapshotOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "volume_snapshot", url.QueryEscape(req.GetVolumeSnapshot())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).RestoreVolumeSnapshot[0:len((*c.CallOptions).RestoreVolumeSnapshot):len((*c.CallOptions).RestoreVolumeSnapshot)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.RestoreVolumeSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RestoreVolumeSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.DeleteVolumeSnapshotRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteVolumeSnapshot[0:len((*c.CallOptions).DeleteVolumeSnapshot):len((*c.CallOptions).DeleteVolumeSnapshot)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteVolumeSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetVolumeSnapshot(ctx context.Context, req *baremetalsolutionpb.GetVolumeSnapshotRequest, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetVolumeSnapshot[0:len((*c.CallOptions).GetVolumeSnapshot):len((*c.CallOptions).GetVolumeSnapshot)], opts...)
	var resp *baremetalsolutionpb.VolumeSnapshot
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetVolumeSnapshot(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListVolumeSnapshots(ctx context.Context, req *baremetalsolutionpb.ListVolumeSnapshotsRequest, opts ...gax.CallOption) *VolumeSnapshotIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListVolumeSnapshots[0:len((*c.CallOptions).ListVolumeSnapshots):len((*c.CallOptions).ListVolumeSnapshots)], opts...)
	it := &VolumeSnapshotIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListVolumeSnapshotsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.VolumeSnapshot, string, error) {
		resp := &baremetalsolutionpb.ListVolumeSnapshotsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListVolumeSnapshots(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetVolumeSnapshots(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetLun(ctx context.Context, req *baremetalsolutionpb.GetLunRequest, opts ...gax.CallOption) (*baremetalsolutionpb.Lun, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetLun[0:len((*c.CallOptions).GetLun):len((*c.CallOptions).GetLun)], opts...)
	var resp *baremetalsolutionpb.Lun
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetLun(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLuns(ctx context.Context, req *baremetalsolutionpb.ListLunsRequest, opts ...gax.CallOption) *LunIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListLuns[0:len((*c.CallOptions).ListLuns):len((*c.CallOptions).ListLuns)], opts...)
	it := &LunIterator{}
	req = proto.Clone(req).(*baremetalsolutionpb.ListLunsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*baremetalsolutionpb.Lun, string, error) {
		resp := &baremetalsolutionpb.ListLunsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListLuns(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLuns(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ResetInstanceOperation manages a long-running operation from ResetInstance.
type ResetInstanceOperation struct {
	lro *longrunning.Operation
}

// ResetInstanceOperation returns a new ResetInstanceOperation from a given name.
// The name must be that of a previously created ResetInstanceOperation, possibly from a different process.
func (c *gRPCClient) ResetInstanceOperation(name string) *ResetInstanceOperation {
	return &ResetInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ResetInstanceOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*baremetalsolutionpb.ResetInstanceResponse, error) {
	var resp baremetalsolutionpb.ResetInstanceResponse
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ResetInstanceOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*baremetalsolutionpb.ResetInstanceResponse, error) {
	var resp baremetalsolutionpb.ResetInstanceResponse
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ResetInstanceOperation) Metadata() (*baremetalsolutionpb.OperationMetadata, error) {
	var meta baremetalsolutionpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ResetInstanceOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ResetInstanceOperation) Name() string {
	return op.lro.Name()
}

// RestoreVolumeSnapshotOperation manages a long-running operation from RestoreVolumeSnapshot.
type RestoreVolumeSnapshotOperation struct {
	lro *longrunning.Operation
}

// RestoreVolumeSnapshotOperation returns a new RestoreVolumeSnapshotOperation from a given name.
// The name must be that of a previously created RestoreVolumeSnapshotOperation, possibly from a different process.
func (c *gRPCClient) RestoreVolumeSnapshotOperation(name string) *RestoreVolumeSnapshotOperation {
	return &RestoreVolumeSnapshotOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *RestoreVolumeSnapshotOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	var resp baremetalsolutionpb.VolumeSnapshot
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *RestoreVolumeSnapshotOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*baremetalsolutionpb.VolumeSnapshot, error) {
	var resp baremetalsolutionpb.VolumeSnapshot
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *RestoreVolumeSnapshotOperation) Metadata() (*baremetalsolutionpb.OperationMetadata, error) {
	var meta baremetalsolutionpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *RestoreVolumeSnapshotOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *RestoreVolumeSnapshotOperation) Name() string {
	return op.lro.Name()
}

// UpdateVolumeOperation manages a long-running operation from UpdateVolume.
type UpdateVolumeOperation struct {
	lro *longrunning.Operation
}

// UpdateVolumeOperation returns a new UpdateVolumeOperation from a given name.
// The name must be that of a previously created UpdateVolumeOperation, possibly from a different process.
func (c *gRPCClient) UpdateVolumeOperation(name string) *UpdateVolumeOperation {
	return &UpdateVolumeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateVolumeOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	var resp baremetalsolutionpb.Volume
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateVolumeOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*baremetalsolutionpb.Volume, error) {
	var resp baremetalsolutionpb.Volume
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateVolumeOperation) Metadata() (*baremetalsolutionpb.OperationMetadata, error) {
	var meta baremetalsolutionpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateVolumeOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateVolumeOperation) Name() string {
	return op.lro.Name()
}

// InstanceIterator manages a stream of *baremetalsolutionpb.Instance.
type InstanceIterator struct {
	items    []*baremetalsolutionpb.Instance
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*baremetalsolutionpb.Instance, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *InstanceIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *InstanceIterator) Next() (*baremetalsolutionpb.Instance, error) {
	var item *baremetalsolutionpb.Instance
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *InstanceIterator) bufLen() int {
	return len(it.items)
}

func (it *InstanceIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// LunIterator manages a stream of *baremetalsolutionpb.Lun.
type LunIterator struct {
	items    []*baremetalsolutionpb.Lun
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*baremetalsolutionpb.Lun, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *LunIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *LunIterator) Next() (*baremetalsolutionpb.Lun, error) {
	var item *baremetalsolutionpb.Lun
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *LunIterator) bufLen() int {
	return len(it.items)
}

func (it *LunIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// NetworkIterator manages a stream of *baremetalsolutionpb.Network.
type NetworkIterator struct {
	items    []*baremetalsolutionpb.Network
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*baremetalsolutionpb.Network, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *NetworkIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *NetworkIterator) Next() (*baremetalsolutionpb.Network, error) {
	var item *baremetalsolutionpb.Network
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *NetworkIterator) bufLen() int {
	return len(it.items)
}

func (it *NetworkIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SnapshotSchedulePolicyIterator manages a stream of *baremetalsolutionpb.SnapshotSchedulePolicy.
type SnapshotSchedulePolicyIterator struct {
	items    []*baremetalsolutionpb.SnapshotSchedulePolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*baremetalsolutionpb.SnapshotSchedulePolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SnapshotSchedulePolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SnapshotSchedulePolicyIterator) Next() (*baremetalsolutionpb.SnapshotSchedulePolicy, error) {
	var item *baremetalsolutionpb.SnapshotSchedulePolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SnapshotSchedulePolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *SnapshotSchedulePolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VolumeIterator manages a stream of *baremetalsolutionpb.Volume.
type VolumeIterator struct {
	items    []*baremetalsolutionpb.Volume
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*baremetalsolutionpb.Volume, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *VolumeIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VolumeIterator) Next() (*baremetalsolutionpb.Volume, error) {
	var item *baremetalsolutionpb.Volume
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VolumeIterator) bufLen() int {
	return len(it.items)
}

func (it *VolumeIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// VolumeSnapshotIterator manages a stream of *baremetalsolutionpb.VolumeSnapshot.
type VolumeSnapshotIterator struct {
	items    []*baremetalsolutionpb.VolumeSnapshot
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*baremetalsolutionpb.VolumeSnapshot, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *VolumeSnapshotIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *VolumeSnapshotIterator) Next() (*baremetalsolutionpb.VolumeSnapshot, error) {
	var item *baremetalsolutionpb.VolumeSnapshot
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *VolumeSnapshotIterator) bufLen() int {
	return len(it.items)
}

func (it *VolumeSnapshotIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
