// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package deploy_test

import (
	"context"

	deploy "cloud.google.com/go/deploy/apiv1"
	"google.golang.org/api/iterator"
	deploypb "google.golang.org/genproto/googleapis/cloud/deploy/v1"
)

func ExampleNewCloudDeployClient() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleCloudDeployClient_ListDeliveryPipelines() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.ListDeliveryPipelinesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#ListDeliveryPipelinesRequest.
	}
	it := c.ListDeliveryPipelines(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleCloudDeployClient_GetDeliveryPipeline() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.GetDeliveryPipelineRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#GetDeliveryPipelineRequest.
	}
	resp, err := c.GetDeliveryPipeline(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_CreateDeliveryPipeline() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.CreateDeliveryPipelineRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#CreateDeliveryPipelineRequest.
	}
	op, err := c.CreateDeliveryPipeline(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_UpdateDeliveryPipeline() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.UpdateDeliveryPipelineRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#UpdateDeliveryPipelineRequest.
	}
	op, err := c.UpdateDeliveryPipeline(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_DeleteDeliveryPipeline() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.DeleteDeliveryPipelineRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#DeleteDeliveryPipelineRequest.
	}
	op, err := c.DeleteDeliveryPipeline(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	err = op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleCloudDeployClient_ListTargets() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.ListTargetsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#ListTargetsRequest.
	}
	it := c.ListTargets(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleCloudDeployClient_GetTarget() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.GetTargetRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#GetTargetRequest.
	}
	resp, err := c.GetTarget(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_CreateTarget() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.CreateTargetRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#CreateTargetRequest.
	}
	op, err := c.CreateTarget(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_UpdateTarget() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.UpdateTargetRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#UpdateTargetRequest.
	}
	op, err := c.UpdateTarget(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_DeleteTarget() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.DeleteTargetRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#DeleteTargetRequest.
	}
	op, err := c.DeleteTarget(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	err = op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleCloudDeployClient_ListReleases() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.ListReleasesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#ListReleasesRequest.
	}
	it := c.ListReleases(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleCloudDeployClient_GetRelease() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.GetReleaseRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#GetReleaseRequest.
	}
	resp, err := c.GetRelease(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_CreateRelease() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.CreateReleaseRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#CreateReleaseRequest.
	}
	op, err := c.CreateRelease(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_ApproveRollout() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.ApproveRolloutRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#ApproveRolloutRequest.
	}
	resp, err := c.ApproveRollout(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_ListRollouts() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.ListRolloutsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#ListRolloutsRequest.
	}
	it := c.ListRollouts(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleCloudDeployClient_GetRollout() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.GetRolloutRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#GetRolloutRequest.
	}
	resp, err := c.GetRollout(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_CreateRollout() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.CreateRolloutRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#CreateRolloutRequest.
	}
	op, err := c.CreateRollout(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleCloudDeployClient_GetConfig() {
	ctx := context.Background()
	c, err := deploy.NewCloudDeployClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &deploypb.GetConfigRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/google.golang.org/genproto/googleapis/cloud/deploy/v1#GetConfigRequest.
	}
	resp, err := c.GetConfig(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}
