// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package chromemanagement provides access to the Chrome Management API.
//
// For product documentation, see: http://developers.google.com/chrome/management/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/chromemanagement/v1"
//   ...
//   ctx := context.Background()
//   chromemanagementService, err := chromemanagement.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   chromemanagementService, err := chromemanagement.NewService(ctx, option.WithScopes(chromemanagement.ChromeManagementReportsReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   chromemanagementService, err := chromemanagement.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   chromemanagementService, err := chromemanagement.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package chromemanagement // import "google.golang.org/api/chromemanagement/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "chromemanagement:v1"
const apiName = "chromemanagement"
const apiVersion = "v1"
const basePath = "https://chromemanagement.googleapis.com/"
const mtlsBasePath = "https://chromemanagement.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See detailed information about apps installed on Chrome browsers and
	// devices managed by your organization
	ChromeManagementAppdetailsReadonlyScope = "https://www.googleapis.com/auth/chrome.management.appdetails.readonly"

	// See reports about devices and Chrome browsers managed within your
	// organization
	ChromeManagementReportsReadonlyScope = "https://www.googleapis.com/auth/chrome.management.reports.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/chrome.management.appdetails.readonly",
		"https://www.googleapis.com/auth/chrome.management.reports.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Customers = NewCustomersService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Customers *CustomersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.Apps = NewCustomersAppsService(s)
	rs.Reports = NewCustomersReportsService(s)
	return rs
}

type CustomersService struct {
	s *Service

	Apps *CustomersAppsService

	Reports *CustomersReportsService
}

func NewCustomersAppsService(s *Service) *CustomersAppsService {
	rs := &CustomersAppsService{s: s}
	rs.Android = NewCustomersAppsAndroidService(s)
	rs.Chrome = NewCustomersAppsChromeService(s)
	rs.Web = NewCustomersAppsWebService(s)
	return rs
}

type CustomersAppsService struct {
	s *Service

	Android *CustomersAppsAndroidService

	Chrome *CustomersAppsChromeService

	Web *CustomersAppsWebService
}

func NewCustomersAppsAndroidService(s *Service) *CustomersAppsAndroidService {
	rs := &CustomersAppsAndroidService{s: s}
	return rs
}

type CustomersAppsAndroidService struct {
	s *Service
}

func NewCustomersAppsChromeService(s *Service) *CustomersAppsChromeService {
	rs := &CustomersAppsChromeService{s: s}
	return rs
}

type CustomersAppsChromeService struct {
	s *Service
}

func NewCustomersAppsWebService(s *Service) *CustomersAppsWebService {
	rs := &CustomersAppsWebService{s: s}
	return rs
}

type CustomersAppsWebService struct {
	s *Service
}

func NewCustomersReportsService(s *Service) *CustomersReportsService {
	rs := &CustomersReportsService{s: s}
	return rs
}

type CustomersReportsService struct {
	s *Service
}

// GoogleChromeManagementV1AndroidAppInfo: Android app information.
type GoogleChromeManagementV1AndroidAppInfo struct {
	// Permissions: Output only. Permissions requested by an Android app.
	Permissions []*GoogleChromeManagementV1AndroidAppPermission `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1AndroidAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AndroidAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1AndroidAppPermission: Permission requested by
// an Android app.
type GoogleChromeManagementV1AndroidAppPermission struct {
	// Type: Output only. The type of the permission.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1AndroidAppPermission) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AndroidAppPermission
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1AppDetails: Resource representing app
// details.
type GoogleChromeManagementV1AppDetails struct {
	// AndroidAppInfo: Output only. Android app information.
	AndroidAppInfo *GoogleChromeManagementV1AndroidAppInfo `json:"androidAppInfo,omitempty"`

	// AppId: Output only. Unique store identifier for the item. Examples:
	// "gmbmikajjgmnabiglmofipeabaddhgne" for the Save to Google Drive
	// Chrome extension, "com.google.android.apps.docs" for the Google Drive
	// Android app.
	AppId string `json:"appId,omitempty"`

	// ChromeAppInfo: Output only. Chrome Web Store app information.
	ChromeAppInfo *GoogleChromeManagementV1ChromeAppInfo `json:"chromeAppInfo,omitempty"`

	// Description: Output only. App's description.
	Description string `json:"description,omitempty"`

	// DetailUri: Output only. The uri for the detail page of the item.
	DetailUri string `json:"detailUri,omitempty"`

	// DisplayName: Output only. App's display name.
	DisplayName string `json:"displayName,omitempty"`

	// FirstPublishTime: Output only. First published time.
	FirstPublishTime string `json:"firstPublishTime,omitempty"`

	// HomepageUri: Output only. Home page or Website uri.
	HomepageUri string `json:"homepageUri,omitempty"`

	// IconUri: Output only. A link to an image that can be used as an icon
	// for the product.
	IconUri string `json:"iconUri,omitempty"`

	// IsPaidApp: Output only. Indicates if the app has to be paid for OR
	// has paid content.
	IsPaidApp bool `json:"isPaidApp,omitempty"`

	// LatestPublishTime: Output only. Latest published time.
	LatestPublishTime string `json:"latestPublishTime,omitempty"`

	// Name: Output only. Format:
	// name=customers/{customer_id}/apps/{chrome|android|web}/{app_id}@{versi
	// on}
	Name string `json:"name,omitempty"`

	// PrivacyPolicyUri: Output only. The URI pointing to the privacy policy
	// of the app, if it was provided by the developer. Version-specific
	// field that will only be set when the requested app version is found.
	PrivacyPolicyUri string `json:"privacyPolicyUri,omitempty"`

	// Publisher: Output only. The publisher of the item.
	Publisher string `json:"publisher,omitempty"`

	// ReviewNumber: Output only. Number of reviews received. Chrome Web
	// Store review information will always be for the latest version of an
	// app.
	ReviewNumber int64 `json:"reviewNumber,omitempty,string"`

	// ReviewRating: Output only. The rating of the app (on 5 stars). Chrome
	// Web Store review information will always be for the latest version of
	// an app.
	ReviewRating float64 `json:"reviewRating,omitempty"`

	// RevisionId: Output only. App version. A new revision is committed
	// whenever a new version of the app is published.
	RevisionId string `json:"revisionId,omitempty"`

	// ServiceError: Output only. Information about a partial service error
	// if applicable.
	ServiceError *GoogleRpcStatus `json:"serviceError,omitempty"`

	// Type: Output only. App type.
	//
	// Possible values:
	//   "APP_ITEM_TYPE_UNSPECIFIED" - App type unspecified.
	//   "CHROME" - Chrome app.
	//   "ANDROID" - ARC++ app.
	//   "WEB" - Web app.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AndroidAppInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidAppInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1AppDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AppDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleChromeManagementV1AppDetails) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleChromeManagementV1AppDetails
	var s1 struct {
		ReviewRating gensupport.JSONFloat64 `json:"reviewRating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ReviewRating = float64(s1.ReviewRating)
	return nil
}

// GoogleChromeManagementV1BrowserVersion: Describes a browser version
// and its install count.
type GoogleChromeManagementV1BrowserVersion struct {
	// Channel: Output only. The release channel of the installed browser.
	//
	// Possible values:
	//   "RELEASE_CHANNEL_UNSPECIFIED" - No release channel specified.
	//   "CANARY" - Canary release channel.
	//   "DEV" - Dev release channel.
	//   "BETA" - Beta release channel.
	//   "STABLE" - Stable release channel.
	Channel string `json:"channel,omitempty"`

	// Count: Output only. Count grouped by device_system and major version
	Count int64 `json:"count,omitempty,string"`

	// DeviceOsVersion: Output only. Version of the system-specified
	// operating system.
	DeviceOsVersion string `json:"deviceOsVersion,omitempty"`

	// System: Output only. The device operating system.
	//
	// Possible values:
	//   "DEVICE_SYSTEM_UNSPECIFIED" - No operating system specified.
	//   "SYSTEM_OTHER" - Other operating system.
	//   "SYSTEM_ANDROID" - Android operating system.
	//   "SYSTEM_IOS" - Apple iOS operating system.
	//   "SYSTEM_CROS" - Chrome OS operating system.
	//   "SYSTEM_WINDOWS" - Microsoft Windows operating system.
	//   "SYSTEM_MAC" - Apple macOS operating system.
	//   "SYSTEM_LINUX" - Linux operating system.
	System string `json:"system,omitempty"`

	// Version: Output only. The full version of the installed browser.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Channel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Channel") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1BrowserVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1BrowserVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ChromeAppInfo: Chrome Web Store app
// information.
type GoogleChromeManagementV1ChromeAppInfo struct {
	// GoogleOwned: Output only. Whether the app or extension is built and
	// maintained by Google. Version-specific field that will only be set
	// when the requested app version is found.
	GoogleOwned bool `json:"googleOwned,omitempty"`

	// IsCwsHosted: Output only. Whether the app or extension is in a
	// published state in the Chrome Web Store.
	IsCwsHosted bool `json:"isCwsHosted,omitempty"`

	// IsTheme: Output only. Whether the app or extension is a theme.
	IsTheme bool `json:"isTheme,omitempty"`

	// MinUserCount: Output only. The minimum number of users using this
	// app.
	MinUserCount int64 `json:"minUserCount,omitempty"`

	// Permissions: Output only. Every custom permission requested by the
	// app. Version-specific field that will only be set when the requested
	// app version is found.
	Permissions []*GoogleChromeManagementV1ChromeAppPermission `json:"permissions,omitempty"`

	// SiteAccess: Output only. Every permission giving access to domains or
	// broad host patterns. ( e.g. www.google.com). This includes the
	// matches from content scripts as well as hosts in the permissions node
	// of the manifest. Version-specific field that will only be set when
	// the requested app version is found.
	SiteAccess []*GoogleChromeManagementV1ChromeAppSiteAccess `json:"siteAccess,omitempty"`

	// SupportEnabled: Output only. The app developer has enabled support
	// for their app. Version-specific field that will only be set when the
	// requested app version is found.
	SupportEnabled bool `json:"supportEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GoogleOwned") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GoogleOwned") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1ChromeAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ChromeAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ChromeAppPermission: Permission requested by
// a Chrome app or extension.
type GoogleChromeManagementV1ChromeAppPermission struct {
	// AccessUserData: Output only. If available, whether this permissions
	// grants the app/extension access to user data.
	AccessUserData bool `json:"accessUserData,omitempty"`

	// DocumentationUri: Output only. If available, a URI to a page that has
	// documentation for the current permission.
	DocumentationUri string `json:"documentationUri,omitempty"`

	// Type: Output only. The type of the permission.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessUserData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessUserData") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1ChromeAppPermission) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ChromeAppPermission
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ChromeAppSiteAccess: Represent one host
// permission.
type GoogleChromeManagementV1ChromeAppSiteAccess struct {
	// HostMatch: Output only. This can contain very specific hosts, or
	// patterns like "*.com" for instance.
	HostMatch string `json:"hostMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HostMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HostMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1ChromeAppSiteAccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ChromeAppSiteAccess
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeVersionsResponse: Response
// containing requested browser versions details and counts.
type GoogleChromeManagementV1CountChromeVersionsResponse struct {
	// BrowserVersions: List of all browser versions and their install
	// counts.
	BrowserVersions []*GoogleChromeManagementV1BrowserVersion `json:"browserVersions,omitempty"`

	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total number browser versions matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BrowserVersions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BrowserVersions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1CountChromeVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeVersionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountInstalledAppsResponse: Response
// containing details of queried installed apps.
type GoogleChromeManagementV1CountInstalledAppsResponse struct {
	// InstalledApps: List of installed apps matching request.
	InstalledApps []*GoogleChromeManagementV1InstalledApp `json:"installedApps,omitempty"`

	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total number of installed apps matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "InstalledApps") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstalledApps") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1CountInstalledAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountInstalledAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1Device: Describes a device reporting Chrome
// browser information.
type GoogleChromeManagementV1Device struct {
	// DeviceId: Output only. The ID of the device that reported this Chrome
	// browser information.
	DeviceId string `json:"deviceId,omitempty"`

	// Machine: Output only. The name of the machine within its local
	// network.
	Machine string `json:"machine,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1Device) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1Device
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1FindInstalledAppDevicesResponse: Response
// containing a list of devices with queried app installed.
type GoogleChromeManagementV1FindInstalledAppDevicesResponse struct {
	// Devices: A list of devices which have the app installed. Sorted in
	// ascending alphabetical order on the Device.machine field.
	Devices []*GoogleChromeManagementV1Device `json:"devices,omitempty"`

	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total number of devices matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Devices") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Devices") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1FindInstalledAppDevicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1FindInstalledAppDevicesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1InstalledApp: Describes an installed app.
type GoogleChromeManagementV1InstalledApp struct {
	// AppId: Output only. Unique identifier of the app. For Chrome apps and
	// extensions, the 32-character id (e.g.
	// ehoadneljpdggcbbknedodolkkjodefl). For Android apps, the package name
	// (e.g. com.evernote).
	AppId string `json:"appId,omitempty"`

	// AppInstallType: Output only. How the app was installed.
	//
	// Possible values:
	//   "APP_INSTALL_TYPE_UNSPECIFIED" - Application install type not
	// specified.
	//   "MULTIPLE" - Multiple app install types.
	//   "NORMAL" - Normal app install type.
	//   "ADMIN" - Administrator app install type.
	//   "DEVELOPMENT" - Development app install type.
	//   "SIDELOAD" - Sideloaded app install type.
	//   "OTHER" - Other app install type.
	AppInstallType string `json:"appInstallType,omitempty"`

	// AppSource: Output only. Source of the installed app.
	//
	// Possible values:
	//   "APP_SOURCE_UNSPECIFIED" - Application source not specified.
	//   "CHROME_WEBSTORE" - Generally for extensions and Chrome apps.
	//   "PLAY_STORE" - Play Store app.
	AppSource string `json:"appSource,omitempty"`

	// AppType: Output only. Type of the app.
	//
	// Possible values:
	//   "APP_TYPE_UNSPECIFIED" - App type not specified.
	//   "EXTENSION" - Chrome extension.
	//   "APP" - Chrome app.
	//   "THEME" - Chrome theme.
	//   "HOSTED_APP" - Chrome hosted app.
	//   "ANDROID_APP" - ARC++ app.
	AppType string `json:"appType,omitempty"`

	// BrowserDeviceCount: Output only. Count of browser devices with this
	// app installed.
	BrowserDeviceCount int64 `json:"browserDeviceCount,omitempty,string"`

	// Description: Output only. Description of the installed app.
	Description string `json:"description,omitempty"`

	// Disabled: Output only. Whether the app is disabled.
	Disabled bool `json:"disabled,omitempty"`

	// DisplayName: Output only. Name of the installed app.
	DisplayName string `json:"displayName,omitempty"`

	// HomepageUri: Output only. Homepage uri of the installed app.
	HomepageUri string `json:"homepageUri,omitempty"`

	// OsUserCount: Output only. Count of ChromeOS users with this app
	// installed.
	OsUserCount int64 `json:"osUserCount,omitempty,string"`

	// Permissions: Output only. Permissions of the installed app.
	Permissions []string `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1InstalledApp) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1InstalledApp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "chromemanagement.customers.apps.android.get":

type CustomersAppsAndroidGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a specific app for a customer by its resource name.
//
// - name: The app for which details are being queried. Examples:
//   "customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@
//   2.1.2" for the Save to Google Drive Chrome extension version 2.1.2,
//   "customers/my_customer/apps/android/com.google.android.apps.docs"
//   for the Google Drive Android app's latest version.
func (r *CustomersAppsAndroidService) Get(name string) *CustomersAppsAndroidGetCall {
	c := &CustomersAppsAndroidGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersAppsAndroidGetCall) Fields(s ...googleapi.Field) *CustomersAppsAndroidGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersAppsAndroidGetCall) IfNoneMatch(entityTag string) *CustomersAppsAndroidGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersAppsAndroidGetCall) Context(ctx context.Context) *CustomersAppsAndroidGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersAppsAndroidGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsAndroidGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210830")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.android.get" call.
// Exactly one of *GoogleChromeManagementV1AppDetails or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleChromeManagementV1AppDetails.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersAppsAndroidGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a specific app for a customer by its resource name.",
	//   "flatPath": "v1/customers/{customersId}/apps/android/{androidId}",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.apps.android.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The app for which details are being queried. Examples: \"customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@2.1.2\" for the Save to Google Drive Chrome extension version 2.1.2, \"customers/my_customer/apps/android/com.google.android.apps.docs\" for the Google Drive Android app's latest version.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/apps/android/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1AppDetails"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.appdetails.readonly"
	//   ]
	// }

}

// method id "chromemanagement.customers.apps.chrome.get":

type CustomersAppsChromeGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a specific app for a customer by its resource name.
//
// - name: The app for which details are being queried. Examples:
//   "customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@
//   2.1.2" for the Save to Google Drive Chrome extension version 2.1.2,
//   "customers/my_customer/apps/android/com.google.android.apps.docs"
//   for the Google Drive Android app's latest version.
func (r *CustomersAppsChromeService) Get(name string) *CustomersAppsChromeGetCall {
	c := &CustomersAppsChromeGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersAppsChromeGetCall) Fields(s ...googleapi.Field) *CustomersAppsChromeGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersAppsChromeGetCall) IfNoneMatch(entityTag string) *CustomersAppsChromeGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersAppsChromeGetCall) Context(ctx context.Context) *CustomersAppsChromeGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersAppsChromeGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsChromeGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210830")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.chrome.get" call.
// Exactly one of *GoogleChromeManagementV1AppDetails or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleChromeManagementV1AppDetails.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersAppsChromeGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a specific app for a customer by its resource name.",
	//   "flatPath": "v1/customers/{customersId}/apps/chrome/{chromeId}",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.apps.chrome.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The app for which details are being queried. Examples: \"customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@2.1.2\" for the Save to Google Drive Chrome extension version 2.1.2, \"customers/my_customer/apps/android/com.google.android.apps.docs\" for the Google Drive Android app's latest version.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/apps/chrome/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1AppDetails"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.appdetails.readonly"
	//   ]
	// }

}

// method id "chromemanagement.customers.apps.web.get":

type CustomersAppsWebGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a specific app for a customer by its resource name.
//
// - name: The app for which details are being queried. Examples:
//   "customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@
//   2.1.2" for the Save to Google Drive Chrome extension version 2.1.2,
//   "customers/my_customer/apps/android/com.google.android.apps.docs"
//   for the Google Drive Android app's latest version.
func (r *CustomersAppsWebService) Get(name string) *CustomersAppsWebGetCall {
	c := &CustomersAppsWebGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersAppsWebGetCall) Fields(s ...googleapi.Field) *CustomersAppsWebGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersAppsWebGetCall) IfNoneMatch(entityTag string) *CustomersAppsWebGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersAppsWebGetCall) Context(ctx context.Context) *CustomersAppsWebGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersAppsWebGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsWebGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210830")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.web.get" call.
// Exactly one of *GoogleChromeManagementV1AppDetails or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleChromeManagementV1AppDetails.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersAppsWebGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a specific app for a customer by its resource name.",
	//   "flatPath": "v1/customers/{customersId}/apps/web/{webId}",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.apps.web.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The app for which details are being queried. Examples: \"customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@2.1.2\" for the Save to Google Drive Chrome extension version 2.1.2, \"customers/my_customer/apps/android/com.google.android.apps.docs\" for the Google Drive Android app's latest version.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/apps/web/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1AppDetails"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.appdetails.readonly"
	//   ]
	// }

}

// method id "chromemanagement.customers.reports.countChromeVersions":

type CustomersReportsCountChromeVersionsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeVersions: Generate report of installed Chrome versions.
//
// - customer: Customer id or "my_customer" to use the customer
//   associated to the account making the request.
func (r *CustomersReportsService) CountChromeVersions(customer string) *CustomersReportsCountChromeVersionsCall {
	c := &CustomersReportsCountChromeVersionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// results, AND-separated fields in EBNF syntax. Note: OR operations are
// not supported in this filter. Supported filter fields: *
// last_active_date
func (c *CustomersReportsCountChromeVersionsCall) Filter(filter string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsCountChromeVersionsCall) OrgUnitId(orgUnitId string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results to return. Maximum and default are 100.
func (c *CustomersReportsCountChromeVersionsCall) PageSize(pageSize int64) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify
// the page of the request to be returned.
func (c *CustomersReportsCountChromeVersionsCall) PageToken(pageToken string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersReportsCountChromeVersionsCall) Fields(s ...googleapi.Field) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersReportsCountChromeVersionsCall) IfNoneMatch(entityTag string) *CustomersReportsCountChromeVersionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersReportsCountChromeVersionsCall) Context(ctx context.Context) *CustomersReportsCountChromeVersionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersReportsCountChromeVersionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountChromeVersionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210830")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countChromeVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countChromeVersions" call.
// Exactly one of *GoogleChromeManagementV1CountChromeVersionsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleChromeManagementV1CountChromeVersionsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersReportsCountChromeVersionsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1CountChromeVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generate report of installed Chrome versions.",
	//   "flatPath": "v1/customers/{customersId}/reports:countChromeVersions",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.reports.countChromeVersions",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "Required. Customer id or \"my_customer\" to use the customer associated to the account making the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Query string to filter results, AND-separated fields in EBNF syntax. Note: OR operations are not supported in this filter. Supported filter fields: * last_active_date",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orgUnitId": {
	//       "description": "The ID of the organizational unit.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results to return. Maximum and default are 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token to specify the page of the request to be returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/reports:countChromeVersions",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1CountChromeVersionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.reports.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsCountChromeVersionsCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountChromeVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "chromemanagement.customers.reports.countInstalledApps":

type CustomersReportsCountInstalledAppsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountInstalledApps: Generate report of app installations.
//
// - customer: Customer id or "my_customer" to use the customer
//   associated to the account making the request.
func (r *CustomersReportsService) CountInstalledApps(customer string) *CustomersReportsCountInstalledAppsCall {
	c := &CustomersReportsCountInstalledAppsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// results, AND-separated fields in EBNF syntax. Note: OR operations are
// not supported in this filter. Supported filter fields: * app_name *
// app_type * install_type * number_of_permissions * total_install_count
// * latest_profile_active_date * permission_name
func (c *CustomersReportsCountInstalledAppsCall) Filter(filter string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order
// results. Supported order by fields: * app_name * app_type *
// install_type * number_of_permissions * total_install_count
func (c *CustomersReportsCountInstalledAppsCall) OrderBy(orderBy string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsCountInstalledAppsCall) OrgUnitId(orgUnitId string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results to return. Maximum and default are 100.
func (c *CustomersReportsCountInstalledAppsCall) PageSize(pageSize int64) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify
// the page of the request to be returned.
func (c *CustomersReportsCountInstalledAppsCall) PageToken(pageToken string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersReportsCountInstalledAppsCall) Fields(s ...googleapi.Field) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersReportsCountInstalledAppsCall) IfNoneMatch(entityTag string) *CustomersReportsCountInstalledAppsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersReportsCountInstalledAppsCall) Context(ctx context.Context) *CustomersReportsCountInstalledAppsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersReportsCountInstalledAppsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountInstalledAppsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210830")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countInstalledApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countInstalledApps" call.
// Exactly one of *GoogleChromeManagementV1CountInstalledAppsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleChromeManagementV1CountInstalledAppsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersReportsCountInstalledAppsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountInstalledAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1CountInstalledAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generate report of app installations.",
	//   "flatPath": "v1/customers/{customersId}/reports:countInstalledApps",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.reports.countInstalledApps",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "Required. Customer id or \"my_customer\" to use the customer associated to the account making the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Query string to filter results, AND-separated fields in EBNF syntax. Note: OR operations are not supported in this filter. Supported filter fields: * app_name * app_type * install_type * number_of_permissions * total_install_count * latest_profile_active_date * permission_name",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Field used to order results. Supported order by fields: * app_name * app_type * install_type * number_of_permissions * total_install_count",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orgUnitId": {
	//       "description": "The ID of the organizational unit.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results to return. Maximum and default are 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token to specify the page of the request to be returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/reports:countInstalledApps",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1CountInstalledAppsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.reports.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsCountInstalledAppsCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountInstalledAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "chromemanagement.customers.reports.findInstalledAppDevices":

type CustomersReportsFindInstalledAppDevicesCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FindInstalledAppDevices: Generate report of devices that have a
// specified app installed.
//
// - customer: Customer id or "my_customer" to use the customer
//   associated to the account making the request.
func (r *CustomersReportsService) FindInstalledAppDevices(customer string) *CustomersReportsFindInstalledAppDevicesCall {
	c := &CustomersReportsFindInstalledAppDevicesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// AppId sets the optional parameter "appId": Unique identifier of the
// app. For Chrome apps and extensions, the 32-character id (e.g.
// ehoadneljpdggcbbknedodolkkjodefl). For Android apps, the package name
// (e.g. com.evernote).
func (c *CustomersReportsFindInstalledAppDevicesCall) AppId(appId string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("appId", appId)
	return c
}

// AppType sets the optional parameter "appType": Type of the app.
//
// Possible values:
//   "APP_TYPE_UNSPECIFIED" - App type not specified.
//   "EXTENSION" - Chrome extension.
//   "APP" - Chrome app.
//   "THEME" - Chrome theme.
//   "HOSTED_APP" - Chrome hosted app.
//   "ANDROID_APP" - ARC++ app.
func (c *CustomersReportsFindInstalledAppDevicesCall) AppType(appType string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("appType", appType)
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// results, AND-separated fields in EBNF syntax. Note: OR operations are
// not supported in this filter. Supported filter fields: *
// last_active_date
func (c *CustomersReportsFindInstalledAppDevicesCall) Filter(filter string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order
// results. Supported order by fields: * machine * device_id
func (c *CustomersReportsFindInstalledAppDevicesCall) OrderBy(orderBy string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsFindInstalledAppDevicesCall) OrgUnitId(orgUnitId string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results to return. Maximum and default are 100.
func (c *CustomersReportsFindInstalledAppDevicesCall) PageSize(pageSize int64) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify
// the page of the request to be returned.
func (c *CustomersReportsFindInstalledAppDevicesCall) PageToken(pageToken string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersReportsFindInstalledAppDevicesCall) Fields(s ...googleapi.Field) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersReportsFindInstalledAppDevicesCall) IfNoneMatch(entityTag string) *CustomersReportsFindInstalledAppDevicesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersReportsFindInstalledAppDevicesCall) Context(ctx context.Context) *CustomersReportsFindInstalledAppDevicesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersReportsFindInstalledAppDevicesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsFindInstalledAppDevicesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210830")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:findInstalledAppDevices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.findInstalledAppDevices" call.
// Exactly one of
// *GoogleChromeManagementV1FindInstalledAppDevicesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleChromeManagementV1FindInstalledAppDevicesResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersReportsFindInstalledAppDevicesCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1FindInstalledAppDevicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1FindInstalledAppDevicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generate report of devices that have a specified app installed.",
	//   "flatPath": "v1/customers/{customersId}/reports:findInstalledAppDevices",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.reports.findInstalledAppDevices",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "appId": {
	//       "description": "Unique identifier of the app. For Chrome apps and extensions, the 32-character id (e.g. ehoadneljpdggcbbknedodolkkjodefl). For Android apps, the package name (e.g. com.evernote).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "appType": {
	//       "description": "Type of the app.",
	//       "enum": [
	//         "APP_TYPE_UNSPECIFIED",
	//         "EXTENSION",
	//         "APP",
	//         "THEME",
	//         "HOSTED_APP",
	//         "ANDROID_APP"
	//       ],
	//       "enumDescriptions": [
	//         "App type not specified.",
	//         "Chrome extension.",
	//         "Chrome app.",
	//         "Chrome theme.",
	//         "Chrome hosted app.",
	//         "ARC++ app."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "customer": {
	//       "description": "Required. Customer id or \"my_customer\" to use the customer associated to the account making the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Query string to filter results, AND-separated fields in EBNF syntax. Note: OR operations are not supported in this filter. Supported filter fields: * last_active_date",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Field used to order results. Supported order by fields: * machine * device_id",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orgUnitId": {
	//       "description": "The ID of the organizational unit.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results to return. Maximum and default are 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token to specify the page of the request to be returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/reports:findInstalledAppDevices",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1FindInstalledAppDevicesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.reports.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsFindInstalledAppDevicesCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1FindInstalledAppDevicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
