// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package assuredworkloads provides access to the Assured Workloads API.
//
// For product documentation, see: https://cloud.google.com/learnmoreurl
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/assuredworkloads/v1"
//	...
//	ctx := context.Background()
//	assuredworkloadsService, err := assuredworkloads.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	assuredworkloadsService, err := assuredworkloads.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	assuredworkloadsService, err := assuredworkloads.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package assuredworkloads // import "google.golang.org/api/assuredworkloads/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "assuredworkloads:v1"
const apiName = "assuredworkloads"
const apiVersion = "v1"
const basePath = "https://assuredworkloads.googleapis.com/"
const mtlsBasePath = "https://assuredworkloads.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Organizations = NewOrganizationsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Organizations *OrganizationsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.Operations = NewOrganizationsLocationsOperationsService(s)
	rs.Workloads = NewOrganizationsLocationsWorkloadsService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	Operations *OrganizationsLocationsOperationsService

	Workloads *OrganizationsLocationsWorkloadsService
}

func NewOrganizationsLocationsOperationsService(s *Service) *OrganizationsLocationsOperationsService {
	rs := &OrganizationsLocationsOperationsService{s: s}
	return rs
}

type OrganizationsLocationsOperationsService struct {
	s *Service
}

func NewOrganizationsLocationsWorkloadsService(s *Service) *OrganizationsLocationsWorkloadsService {
	rs := &OrganizationsLocationsWorkloadsService{s: s}
	rs.Violations = NewOrganizationsLocationsWorkloadsViolationsService(s)
	return rs
}

type OrganizationsLocationsWorkloadsService struct {
	s *Service

	Violations *OrganizationsLocationsWorkloadsViolationsService
}

func NewOrganizationsLocationsWorkloadsViolationsService(s *Service) *OrganizationsLocationsWorkloadsViolationsService {
	rs := &OrganizationsLocationsWorkloadsViolationsService{s: s}
	return rs
}

type OrganizationsLocationsWorkloadsViolationsService struct {
	s *Service
}

// GoogleCloudAssuredworkloadsV1AcknowledgeViolationRequest: Request for
// acknowledging the violation Next Id: 5
type GoogleCloudAssuredworkloadsV1AcknowledgeViolationRequest struct {
	// Comment: Required. Business justification explaining the need for
	// violation acknowledgement
	Comment string `json:"comment,omitempty"`

	// NonCompliantOrgPolicy: Optional. This field is deprecated and will be
	// removed in future version of the API. Name of the OrgPolicy which was
	// modified with non-compliant change and resulted in this violation.
	// Format: projects/{project_number}/policies/{constraint_name}
	// folders/{folder_id}/policies/{constraint_name}
	// organizations/{organization_id}/policies/{constraint_name}
	NonCompliantOrgPolicy string `json:"nonCompliantOrgPolicy,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Comment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Comment") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1AcknowledgeViolationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1AcknowledgeViolationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1AcknowledgeViolationResponse: Response
// for violation acknowledgement
type GoogleCloudAssuredworkloadsV1AcknowledgeViolationResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse: Response
// containing the analysis results for the hypothetical resource move.
type GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse struct {
	// AssetMoveAnalyses: List of analysis results for each asset in scope.
	AssetMoveAnalyses []*GoogleCloudAssuredworkloadsV1AssetMoveAnalysis `json:"assetMoveAnalyses,omitempty"`

	// NextPageToken: The next page token. Is empty if the last page is
	// reached.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AssetMoveAnalyses")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetMoveAnalyses") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1AssetMoveAnalysis: Represents move
// analysis results for an asset.
type GoogleCloudAssuredworkloadsV1AssetMoveAnalysis struct {
	// AnalysisGroups: List of eligible analyses performed for the asset.
	AnalysisGroups []*GoogleCloudAssuredworkloadsV1MoveAnalysisGroup `json:"analysisGroups,omitempty"`

	// Asset: The full resource name of the asset being analyzed. Example:
	// //compute.googleapis.com/projects/my_project_123/zones/zone1/instances
	// /instance1
	Asset string `json:"asset,omitempty"`

	// AssetType: Type of the asset being analyzed. Possible values will be
	// among the ones listed here
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
	AssetType string `json:"assetType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalysisGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisGroups") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1AssetMoveAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1AssetMoveAnalysis
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1CreateWorkloadOperationMetadata:
// Operation metadata to give request details of CreateWorkload.
type GoogleCloudAssuredworkloadsV1CreateWorkloadOperationMetadata struct {
	// ComplianceRegime: Optional. Compliance controls that should be
	// applied to the resources managed by the workload.
	//
	// Possible values:
	//   "COMPLIANCE_REGIME_UNSPECIFIED" - Unknown compliance regime.
	//   "IL4" - Information protection as per DoD IL4 requirements.
	//   "CJIS" - Criminal Justice Information Services (CJIS) Security
	// policies.
	//   "FEDRAMP_HIGH" - FedRAMP High data protection controls
	//   "FEDRAMP_MODERATE" - FedRAMP Moderate data protection controls
	//   "US_REGIONAL_ACCESS" - Assured Workloads For US Regions data
	// protection controls
	//   "HIPAA" - Health Insurance Portability and Accountability Act
	// controls
	//   "HITRUST" - Health Information Trust Alliance controls
	//   "EU_REGIONS_AND_SUPPORT" - Assured Workloads For EU Regions and
	// Support controls
	//   "CA_REGIONS_AND_SUPPORT" - Assured Workloads For Canada Regions and
	// Support controls
	//   "ITAR" - International Traffic in Arms Regulations
	//   "AU_REGIONS_AND_US_SUPPORT" - Assured Workloads for Australia
	// Regions and Support controls Available for public preview
	// consumption. Don't create production workloads.
	//   "ASSURED_WORKLOADS_FOR_PARTNERS" - Assured Workloads for Partners;
	//   "ISR_REGIONS" - Assured Workloads for Israel
	//   "ISR_REGIONS_AND_SUPPORT" - Assured Workloads for Israel Regions
	//   "CA_PROTECTED_B" - Assured Workloads for Canada Protected B regime
	//   "IL5" - Information protection as per DoD IL5 requirements.
	//   "JP_REGIONS_AND_SUPPORT" - Assured Workloads for Japan Regions
	ComplianceRegime string `json:"complianceRegime,omitempty"`

	// CreateTime: Optional. Time when the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Optional. The display name of the workload.
	DisplayName string `json:"displayName,omitempty"`

	// Parent: Optional. The parent of the workload.
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ComplianceRegime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ComplianceRegime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1CreateWorkloadOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1CreateWorkloadOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1ListViolationsResponse: Response of
// ListViolations endpoint.
type GoogleCloudAssuredworkloadsV1ListViolationsResponse struct {
	// NextPageToken: The next page token. Returns empty if reached the last
	// page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Violations: List of Violations under a Workload.
	Violations []*GoogleCloudAssuredworkloadsV1Violation `json:"violations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1ListViolationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1ListViolationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1ListWorkloadsResponse: Response of
// ListWorkloads endpoint.
type GoogleCloudAssuredworkloadsV1ListWorkloadsResponse struct {
	// NextPageToken: The next page token. Return empty if reached the last
	// page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Workloads: List of Workloads under a given parent.
	Workloads []*GoogleCloudAssuredworkloadsV1Workload `json:"workloads,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1ListWorkloadsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1ListWorkloadsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1MoveAnalysisGroup: Represents a logical
// group of checks performed for an asset. If successful, the group
// contains the analysis result, otherwise it contains an error with the
// failure reason.
type GoogleCloudAssuredworkloadsV1MoveAnalysisGroup struct {
	// AnalysisResult: Result of a successful analysis.
	AnalysisResult *GoogleCloudAssuredworkloadsV1MoveAnalysisResult `json:"analysisResult,omitempty"`

	// DisplayName: Name of the analysis group.
	DisplayName string `json:"displayName,omitempty"`

	// Error: Error details for a failed analysis.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1MoveAnalysisGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1MoveAnalysisGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1MoveAnalysisResult: Represents the
// successful move analysis results for a group.
type GoogleCloudAssuredworkloadsV1MoveAnalysisResult struct {
	// Blockers: List of blockers. If not resolved, these will result in
	// compliance violations in the target.
	Blockers []*GoogleCloudAssuredworkloadsV1MoveImpact `json:"blockers,omitempty"`

	// Warnings: List of warnings. These are risks that may or may not
	// result in compliance violations.
	Warnings []*GoogleCloudAssuredworkloadsV1MoveImpact `json:"warnings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Blockers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Blockers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1MoveAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1MoveAnalysisResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1MoveImpact: Represents the impact of
// moving the asset to the target.
type GoogleCloudAssuredworkloadsV1MoveImpact struct {
	// Detail: Explanation of the impact.
	Detail string `json:"detail,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Detail") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1MoveImpact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1MoveImpact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1MutatePartnerPermissionsRequest: Request
// for updating permission settings for a partner workload.
type GoogleCloudAssuredworkloadsV1MutatePartnerPermissionsRequest struct {
	// Etag: Optional. The etag of the workload. If this is provided, it
	// must match the server's etag.
	Etag string `json:"etag,omitempty"`

	// PartnerPermissions: Required. The partner permissions to be updated.
	PartnerPermissions *GoogleCloudAssuredworkloadsV1WorkloadPartnerPermissions `json:"partnerPermissions,omitempty"`

	// UpdateMask: Required. The list of fields to be updated. E.g.
	// update_mask { paths: "partner_permissions.data_logs_viewer"}
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1MutatePartnerPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1MutatePartnerPermissionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesRequest: Request
// for restricting list of available resources in Workload environment.
type GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesRequest struct {
	// RestrictionType: Required. The type of restriction for using gcp
	// products in the Workload environment.
	//
	// Possible values:
	//   "RESTRICTION_TYPE_UNSPECIFIED" - Unknown restriction type.
	//   "ALLOW_ALL_GCP_RESOURCES" - Allow the use all of all gcp products,
	// irrespective of the compliance posture. This effectively removes
	// gcp.restrictServiceUsage OrgPolicy on the AssuredWorkloads Folder.
	//   "ALLOW_COMPLIANT_RESOURCES" - Based on Workload's compliance
	// regime, allowed list changes. See -
	// https://cloud.google.com/assured-workloads/docs/supported-products
	// for the list of supported resources.
	//   "APPEND_COMPLIANT_RESOURCES" - Similar to ALLOW_COMPLIANT_RESOURCES
	// but adds the list of compliant resources to the existing list of
	// compliant resources. Effective org-policy of the Folder is considered
	// to ensure there is no disruption to the existing customer workflows.
	RestrictionType string `json:"restrictionType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RestrictionType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RestrictionType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesResponse:
// Response for restricting the list of allowed resources.
type GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAssuredworkloadsV1Violation: Workload monitoring
// Violation. Next Id: 28
type GoogleCloudAssuredworkloadsV1Violation struct {
	// Acknowledged: A boolean that indicates if the violation is
	// acknowledged
	Acknowledged bool `json:"acknowledged,omitempty"`

	// AcknowledgementTime: Optional. Timestamp when this violation was
	// acknowledged first. Check exception_contexts to find the last time
	// the violation was acknowledged when there are more than one
	// violations. This field will be absent when acknowledged field is
	// marked as false.
	AcknowledgementTime string `json:"acknowledgementTime,omitempty"`

	// AuditLogLink: Output only. Immutable. Audit Log Link for violated
	// resource Format:
	// https://console.cloud.google.com/logs/query;query={logName}{protoPayload.resourceName}{timeRange}{folder}
	AuditLogLink string `json:"auditLogLink,omitempty"`

	// BeginTime: Output only. Time of the event which triggered the
	// Violation.
	BeginTime string `json:"beginTime,omitempty"`

	// Category: Output only. Category under which this violation is mapped.
	// e.g. Location, Service Usage, Access, Encryption, etc.
	Category string `json:"category,omitempty"`

	// Description: Output only. Description for the Violation. e.g.
	// OrgPolicy gcp.resourceLocations has non compliant value.
	Description string `json:"description,omitempty"`

	// ExceptionAuditLogLink: Output only. Immutable. Audit Log link to find
	// business justification provided for violation exception. Format:
	// https://console.cloud.google.com/logs/query;query={logName}{protoPayload.resourceName}{protoPayload.methodName}{timeRange}{organization}
	ExceptionAuditLogLink string `json:"exceptionAuditLogLink,omitempty"`

	// ExceptionContexts: Output only. List of all the exception detail
	// added for the violation.
	ExceptionContexts []*GoogleCloudAssuredworkloadsV1ViolationExceptionContext `json:"exceptionContexts,omitempty"`

	// Name: Output only. Immutable. Name of the Violation. Format:
	// organizations/{organization}/locations/{location}/workloads/{workload_
	// id}/violations/{violations_id}
	Name string `json:"name,omitempty"`

	// NonCompliantOrgPolicy: Output only. Immutable. Name of the OrgPolicy
	// which was modified with non-compliant change and resulted this
	// violation. Format:
	// projects/{project_number}/policies/{constraint_name}
	// folders/{folder_id}/policies/{constraint_name}
	// organizations/{organization_id}/policies/{constraint_name}
	NonCompliantOrgPolicy string `json:"nonCompliantOrgPolicy,omitempty"`

	// OrgPolicyConstraint: Output only. Immutable. The
	// org-policy-constraint that was incorrectly changed, which resulted in
	// this violation.
	OrgPolicyConstraint string `json:"orgPolicyConstraint,omitempty"`

	// Remediation: Output only. Compliance violation remediation
	Remediation *GoogleCloudAssuredworkloadsV1ViolationRemediation `json:"remediation,omitempty"`

	// ResolveTime: Output only. Time of the event which fixed the
	// Violation. If the violation is ACTIVE this will be empty.
	ResolveTime string `json:"resolveTime,omitempty"`

	// State: Output only. State of the violation
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "RESOLVED" - Violation is resolved.
	//   "UNRESOLVED" - Violation is Unresolved
	//   "EXCEPTION" - Violation is Exception
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. The last time when the Violation record was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Acknowledged") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Acknowledged") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1Violation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1Violation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1ViolationExceptionContext: Violation
// exception detail. Next Id: 6
type GoogleCloudAssuredworkloadsV1ViolationExceptionContext struct {
	// AcknowledgementTime: Timestamp when the violation was acknowledged.
	AcknowledgementTime string `json:"acknowledgementTime,omitempty"`

	// Comment: Business justification provided towards the acknowledgement
	// of the violation.
	Comment string `json:"comment,omitempty"`

	// UserName: Name of the user (or service account) who acknowledged the
	// violation.
	UserName string `json:"userName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcknowledgementTime")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcknowledgementTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1ViolationExceptionContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1ViolationExceptionContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1ViolationRemediation: Represents
// remediation guidance to resolve compliance violation for
// AssuredWorkload
type GoogleCloudAssuredworkloadsV1ViolationRemediation struct {
	// CompliantValues: Values that can resolve the violation For example:
	// for list org policy violations, this will either be the list of
	// allowed or denied values
	CompliantValues []string `json:"compliantValues,omitempty"`

	// Instructions: Required. Remediation instructions to resolve
	// violations
	Instructions *GoogleCloudAssuredworkloadsV1ViolationRemediationInstructions `json:"instructions,omitempty"`

	// RemediationType: Output only. Reemediation type based on the type of
	// org policy values violated
	//
	// Possible values:
	//   "REMEDIATION_TYPE_UNSPECIFIED" - Unspecified remediation type
	//   "REMEDIATION_BOOLEAN_ORG_POLICY_VIOLATION" - Remediation type for
	// boolean org policy
	//   "REMEDIATION_LIST_ALLOWED_VALUES_ORG_POLICY_VIOLATION" -
	// Remediation type for list org policy which have allowed values in the
	// monitoring rule
	//   "REMEDIATION_LIST_DENIED_VALUES_ORG_POLICY_VIOLATION" - Remediation
	// type for list org policy which have denied values in the monitoring
	// rule
	//
	// "REMEDIATION_RESTRICT_CMEK_CRYPTO_KEY_PROJECTS_ORG_POLICY_VIOLATION"
	// - Remediation type for gcp.restrictCmekCryptoKeyProjects
	RemediationType string `json:"remediationType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompliantValues") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompliantValues") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1ViolationRemediation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1ViolationRemediation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1ViolationRemediationInstructions:
// Instructions to remediate violation
type GoogleCloudAssuredworkloadsV1ViolationRemediationInstructions struct {
	// ConsoleInstructions: Remediation instructions to resolve violation
	// via cloud console
	ConsoleInstructions *GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsConsole `json:"consoleInstructions,omitempty"`

	// GcloudInstructions: Remediation instructions to resolve violation via
	// gcloud cli
	GcloudInstructions *GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsGcloud `json:"gcloudInstructions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConsoleInstructions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsoleInstructions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1ViolationRemediationInstructions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1ViolationRemediationInstructions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsConsole:
// Remediation instructions to resolve violation via cloud console
type GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsConsole struct {
	// AdditionalLinks: Additional urls for more information about steps
	AdditionalLinks []string `json:"additionalLinks,omitempty"`

	// ConsoleUris: Link to console page where violations can be resolved
	ConsoleUris []string `json:"consoleUris,omitempty"`

	// Steps: Steps to resolve violation via cloud console
	Steps []string `json:"steps,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalLinks") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsConsole) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsConsole
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsGcloud:
// Remediation instructions to resolve violation via gcloud cli
type GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsGcloud struct {
	// AdditionalLinks: Additional urls for more information about steps
	AdditionalLinks []string `json:"additionalLinks,omitempty"`

	// GcloudCommands: Gcloud command to resolve violation
	GcloudCommands []string `json:"gcloudCommands,omitempty"`

	// Steps: Steps to resolve violation via gcloud cli
	Steps []string `json:"steps,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalLinks") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsGcloud) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1ViolationRemediationInstructionsGcloud
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1Workload: A Workload object for managing
// highly regulated workloads of cloud customers.
type GoogleCloudAssuredworkloadsV1Workload struct {
	// BillingAccount: Optional. The billing account used for the resources
	// which are direct children of workload. This billing account is
	// initially associated with the resources created as part of Workload
	// creation. After the initial creation of these resources, the customer
	// can change the assigned billing account. The resource name has the
	// form `billingAccounts/{billing_account_id}`. For example,
	// `billingAccounts/012345-567890-ABCDEF`.
	BillingAccount string `json:"billingAccount,omitempty"`

	// ComplianceRegime: Required. Immutable. Compliance Regime associated
	// with this workload.
	//
	// Possible values:
	//   "COMPLIANCE_REGIME_UNSPECIFIED" - Unknown compliance regime.
	//   "IL4" - Information protection as per DoD IL4 requirements.
	//   "CJIS" - Criminal Justice Information Services (CJIS) Security
	// policies.
	//   "FEDRAMP_HIGH" - FedRAMP High data protection controls
	//   "FEDRAMP_MODERATE" - FedRAMP Moderate data protection controls
	//   "US_REGIONAL_ACCESS" - Assured Workloads For US Regions data
	// protection controls
	//   "HIPAA" - Health Insurance Portability and Accountability Act
	// controls
	//   "HITRUST" - Health Information Trust Alliance controls
	//   "EU_REGIONS_AND_SUPPORT" - Assured Workloads For EU Regions and
	// Support controls
	//   "CA_REGIONS_AND_SUPPORT" - Assured Workloads For Canada Regions and
	// Support controls
	//   "ITAR" - International Traffic in Arms Regulations
	//   "AU_REGIONS_AND_US_SUPPORT" - Assured Workloads for Australia
	// Regions and Support controls Available for public preview
	// consumption. Don't create production workloads.
	//   "ASSURED_WORKLOADS_FOR_PARTNERS" - Assured Workloads for Partners;
	//   "ISR_REGIONS" - Assured Workloads for Israel
	//   "ISR_REGIONS_AND_SUPPORT" - Assured Workloads for Israel Regions
	//   "CA_PROTECTED_B" - Assured Workloads for Canada Protected B regime
	//   "IL5" - Information protection as per DoD IL5 requirements.
	//   "JP_REGIONS_AND_SUPPORT" - Assured Workloads for Japan Regions
	ComplianceRegime string `json:"complianceRegime,omitempty"`

	// ComplianceStatus: Output only. Count of active Violations in the
	// Workload.
	ComplianceStatus *GoogleCloudAssuredworkloadsV1WorkloadComplianceStatus `json:"complianceStatus,omitempty"`

	// CompliantButDisallowedServices: Output only. Urls for services which
	// are compliant for this Assured Workload, but which are currently
	// disallowed by the ResourceUsageRestriction org policy. Invoke
	// RestrictAllowedResources endpoint to allow your project developers to
	// use these services in their environment."
	CompliantButDisallowedServices []string `json:"compliantButDisallowedServices,omitempty"`

	// CreateTime: Output only. Immutable. The Workload creation timestamp.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Required. The user-assigned display name of the
	// Workload. When present it must be between 4 to 30 characters. Allowed
	// characters are: lowercase and uppercase letters, numbers, hyphen, and
	// spaces. Example: My Workload
	DisplayName string `json:"displayName,omitempty"`

	// EkmProvisioningResponse: Optional. Represents the Ekm Provisioning
	// State of the given workload.
	EkmProvisioningResponse *GoogleCloudAssuredworkloadsV1WorkloadEkmProvisioningResponse `json:"ekmProvisioningResponse,omitempty"`

	// EnableSovereignControls: Optional. Indicates the sovereignty status
	// of the given workload. Currently meant to be used by Europe/Canada
	// customers.
	EnableSovereignControls bool `json:"enableSovereignControls,omitempty"`

	// Etag: Optional. ETag of the workload, it is calculated on the basis
	// of the Workload contents. It will be used in Update & Delete
	// operations.
	Etag string `json:"etag,omitempty"`

	// KajEnrollmentState: Output only. Represents the KAJ enrollment state
	// of the given workload.
	//
	// Possible values:
	//   "KAJ_ENROLLMENT_STATE_UNSPECIFIED" - Default State for KAJ
	// Enrollment.
	//   "KAJ_ENROLLMENT_STATE_PENDING" - Pending State for KAJ Enrollment.
	//   "KAJ_ENROLLMENT_STATE_COMPLETE" - Complete State for KAJ
	// Enrollment.
	KajEnrollmentState string `json:"kajEnrollmentState,omitempty"`

	// KmsSettings: Input only. Settings used to create a CMEK crypto key.
	// When set, a project with a KMS CMEK key is provisioned. This field is
	// deprecated as of Feb 28, 2022. In order to create a Keyring, callers
	// should specify, ENCRYPTION_KEYS_PROJECT or KEYRING in
	// ResourceSettings.resource_type field.
	KmsSettings *GoogleCloudAssuredworkloadsV1WorkloadKMSSettings `json:"kmsSettings,omitempty"`

	// Labels: Optional. Labels applied to the workload.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Optional. The resource name of the workload. Format:
	// organizations/{organization}/locations/{location}/workloads/{workload}
	//  Read-only.
	Name string `json:"name,omitempty"`

	// Partner: Optional. Partner regime associated with this workload.
	//
	// Possible values:
	//   "PARTNER_UNSPECIFIED"
	//   "LOCAL_CONTROLS_BY_S3NS" - Enum representing S3NS (Thales) partner.
	//   "SOVEREIGN_CONTROLS_BY_T_SYSTEMS" - Enum representing T_SYSTEM
	// (TSI) partner.
	//   "SOVEREIGN_CONTROLS_BY_SIA_MINSAIT" - Enum representing SIA_MINSAIT
	// (Indra) partner.
	//   "SOVEREIGN_CONTROLS_BY_PSN" - Enum representing PSN (TIM) partner.
	Partner string `json:"partner,omitempty"`

	// PartnerPermissions: Optional. Permissions granted to the AW Partner
	// SA account for the customer workload
	PartnerPermissions *GoogleCloudAssuredworkloadsV1WorkloadPartnerPermissions `json:"partnerPermissions,omitempty"`

	// ProvisionedResourcesParent: Input only. The parent resource for the
	// resources managed by this Assured Workload. May be either empty or a
	// folder resource which is a child of the Workload parent. If not
	// specified all resources are created under the parent organization.
	// Format: folders/{folder_id}
	ProvisionedResourcesParent string `json:"provisionedResourcesParent,omitempty"`

	// ResourceSettings: Input only. Resource properties that are used to
	// customize workload resources. These properties (such as custom
	// project id) will be used to create workload resources if possible.
	// This field is optional.
	ResourceSettings []*GoogleCloudAssuredworkloadsV1WorkloadResourceSettings `json:"resourceSettings,omitempty"`

	// Resources: Output only. The resources associated with this workload.
	// These resources will be created when creating the workload. If any of
	// the projects already exist, the workload creation will fail. Always
	// read only.
	Resources []*GoogleCloudAssuredworkloadsV1WorkloadResourceInfo `json:"resources,omitempty"`

	// SaaEnrollmentResponse: Output only. Represents the SAA enrollment
	// response of the given workload. SAA enrollment response is queried
	// during GetWorkload call. In failure cases, user friendly error
	// message is shown in SAA details page.
	SaaEnrollmentResponse *GoogleCloudAssuredworkloadsV1WorkloadSaaEnrollmentResponse `json:"saaEnrollmentResponse,omitempty"`

	// ViolationNotificationsEnabled: Optional. Indicates whether the e-mail
	// notification for a violation is enabled for a workload. This value
	// will be by default True, and if not present will be considered as
	// true. This should only be updated via updateWorkload call. Any
	// Changes to this field during the createWorkload call will not be
	// honored. This will always be true while creating the workload.
	ViolationNotificationsEnabled bool `json:"violationNotificationsEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BillingAccount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BillingAccount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1Workload) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1Workload
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1WorkloadComplianceStatus: Represents the
// Compliance Status of this workload
type GoogleCloudAssuredworkloadsV1WorkloadComplianceStatus struct {
	// AcknowledgedViolationCount: Number of current orgPolicy violations
	// which are acknowledged.
	AcknowledgedViolationCount int64 `json:"acknowledgedViolationCount,omitempty"`

	// ActiveViolationCount: Number of current orgPolicy violations which
	// are not acknowledged.
	ActiveViolationCount int64 `json:"activeViolationCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AcknowledgedViolationCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AcknowledgedViolationCount") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1WorkloadComplianceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1WorkloadComplianceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1WorkloadEkmProvisioningResponse:
// External key management systems(EKM) Provisioning response
type GoogleCloudAssuredworkloadsV1WorkloadEkmProvisioningResponse struct {
	// EkmProvisioningErrorDomain: Indicates Ekm provisioning error if any.
	//
	// Possible values:
	//   "EKM_PROVISIONING_ERROR_DOMAIN_UNSPECIFIED" - No error domain
	//   "UNSPECIFIED_ERROR" - Error but domain is unspecified.
	//   "GOOGLE_SERVER_ERROR" - Internal logic breaks within provisioning
	// code.
	//   "EXTERNAL_USER_ERROR" - Error occurred with the customer not
	// granting permission/creating resource.
	//   "EXTERNAL_PARTNER_ERROR" - Error occurred within the partner's
	// provisioning cluster.
	//   "TIMEOUT_ERROR" - Resource wasn't provisioned in the required 7 day
	// time period
	EkmProvisioningErrorDomain string `json:"ekmProvisioningErrorDomain,omitempty"`

	// EkmProvisioningErrorMapping: Detailed error message if Ekm
	// provisioning fails
	//
	// Possible values:
	//   "EKM_PROVISIONING_ERROR_MAPPING_UNSPECIFIED" - Error is
	// unspecified.
	//   "INVALID_SERVICE_ACCOUNT" - Service account is used is invalid.
	//   "MISSING_METRICS_SCOPE_ADMIN_PERMISSION" - Iam permission
	// monitoring.MetricsScopeAdmin wasn't applied.
	//   "MISSING_EKM_CONNECTION_ADMIN_PERMISSION" - Iam permission
	// cloudkms.ekmConnectionsAdmin wasn't applied.
	EkmProvisioningErrorMapping string `json:"ekmProvisioningErrorMapping,omitempty"`

	// EkmProvisioningState: Indicates Ekm enrollment Provisioning of a
	// given workload.
	//
	// Possible values:
	//   "EKM_PROVISIONING_STATE_UNSPECIFIED" - Default State for Ekm
	// Provisioning
	//   "EKM_PROVISIONING_STATE_PENDING" - Pending State for Ekm
	// Provisioning
	//   "EKM_PROVISIONING_STATE_FAILED" - Failed State for Ekm Provisioning
	//   "EKM_PROVISIONING_STATE_COMPLETED" - Completed State for Ekm
	// Provisioning
	EkmProvisioningState string `json:"ekmProvisioningState,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EkmProvisioningErrorDomain") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EkmProvisioningErrorDomain") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1WorkloadEkmProvisioningResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1WorkloadEkmProvisioningResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1WorkloadKMSSettings: Settings specific
// to the Key Management Service.
type GoogleCloudAssuredworkloadsV1WorkloadKMSSettings struct {
	// NextRotationTime: Required. Input only. Immutable. The time at which
	// the Key Management Service will automatically create a new version of
	// the crypto key and mark it as the primary.
	NextRotationTime string `json:"nextRotationTime,omitempty"`

	// RotationPeriod: Required. Input only. Immutable. [next_rotation_time]
	// will be advanced by this period when the Key Management Service
	// automatically rotates a key. Must be at least 24 hours and at most
	// 876,000 hours.
	RotationPeriod string `json:"rotationPeriod,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NextRotationTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextRotationTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1WorkloadKMSSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1WorkloadKMSSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1WorkloadPartnerPermissions: Permissions
// granted to the AW Partner SA account for the customer workload
type GoogleCloudAssuredworkloadsV1WorkloadPartnerPermissions struct {
	// AssuredWorkloadsMonitoring: Optional. Allow partner to view violation
	// alerts.
	AssuredWorkloadsMonitoring bool `json:"assuredWorkloadsMonitoring,omitempty"`

	// DataLogsViewer: Allow the partner to view inspectability logs and
	// monitoring violations.
	DataLogsViewer bool `json:"dataLogsViewer,omitempty"`

	// ServiceAccessApprover: Optional. Allow partner to view access
	// approval logs.
	ServiceAccessApprover bool `json:"serviceAccessApprover,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AssuredWorkloadsMonitoring") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AssuredWorkloadsMonitoring") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1WorkloadPartnerPermissions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1WorkloadPartnerPermissions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1WorkloadResourceInfo: Represent the
// resources that are children of this Workload.
type GoogleCloudAssuredworkloadsV1WorkloadResourceInfo struct {
	// ResourceId: Resource identifier. For a project this represents
	// project_number.
	ResourceId int64 `json:"resourceId,omitempty,string"`

	// ResourceType: Indicates the type of resource.
	//
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED" - Unknown resource type.
	//   "CONSUMER_PROJECT" - Deprecated. Existing workloads will continue
	// to support this, but new CreateWorkloadRequests should not specify
	// this as an input value.
	//   "CONSUMER_FOLDER" - Consumer Folder.
	//   "ENCRYPTION_KEYS_PROJECT" - Consumer project containing encryption
	// keys.
	//   "KEYRING" - Keyring resource that hosts encryption keys.
	ResourceType string `json:"resourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1WorkloadResourceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1WorkloadResourceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1WorkloadResourceSettings: Represent the
// custom settings for the resources to be created.
type GoogleCloudAssuredworkloadsV1WorkloadResourceSettings struct {
	// DisplayName: User-assigned resource display name. If not empty it
	// will be used to create a resource with the specified name.
	DisplayName string `json:"displayName,omitempty"`

	// ResourceId: Resource identifier. For a project this represents
	// project_id. If the project is already taken, the workload creation
	// will fail. For KeyRing, this represents the keyring_id. For a folder,
	// don't set this value as folder_id is assigned by Google.
	ResourceId string `json:"resourceId,omitempty"`

	// ResourceType: Indicates the type of resource. This field should be
	// specified to correspond the id to the right project type
	// (CONSUMER_PROJECT or ENCRYPTION_KEYS_PROJECT)
	//
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED" - Unknown resource type.
	//   "CONSUMER_PROJECT" - Deprecated. Existing workloads will continue
	// to support this, but new CreateWorkloadRequests should not specify
	// this as an input value.
	//   "CONSUMER_FOLDER" - Consumer Folder.
	//   "ENCRYPTION_KEYS_PROJECT" - Consumer project containing encryption
	// keys.
	//   "KEYRING" - Keyring resource that hosts encryption keys.
	ResourceType string `json:"resourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1WorkloadResourceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1WorkloadResourceSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssuredworkloadsV1WorkloadSaaEnrollmentResponse: Signed
// Access Approvals (SAA) enrollment response.
type GoogleCloudAssuredworkloadsV1WorkloadSaaEnrollmentResponse struct {
	// SetupErrors: Indicates SAA enrollment setup error if any.
	//
	// Possible values:
	//   "SETUP_ERROR_UNSPECIFIED" - Unspecified.
	//   "ERROR_INVALID_BASE_SETUP" - Invalid states for all customers, to
	// be redirected to AA UI for additional details.
	//   "ERROR_MISSING_EXTERNAL_SIGNING_KEY" - Returned when there is not
	// an EKM key configured.
	//   "ERROR_NOT_ALL_SERVICES_ENROLLED" - Returned when there are no
	// enrolled services or the customer is enrolled in CAA only for a
	// subset of services.
	//   "ERROR_SETUP_CHECK_FAILED" - Returned when exception was
	// encountered during evaluation of other criteria.
	SetupErrors []string `json:"setupErrors,omitempty"`

	// SetupStatus: Indicates SAA enrollment status of a given workload.
	//
	// Possible values:
	//   "SETUP_STATE_UNSPECIFIED" - Unspecified.
	//   "STATUS_PENDING" - SAA enrollment pending.
	//   "STATUS_COMPLETE" - SAA enrollment comopleted.
	SetupStatus string `json:"setupStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SetupErrors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SetupErrors") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssuredworkloadsV1WorkloadSaaEnrollmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssuredworkloadsV1WorkloadSaaEnrollmentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal, successful response of the operation. If the
	// original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "assuredworkloads.organizations.locations.operations.get":

type OrganizationsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *OrganizationsLocationsOperationsService) Get(name string) *OrganizationsLocationsOperationsGetCall {
	c := &OrganizationsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsOperationsGetCall) Context(ctx context.Context) *OrganizationsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "assuredworkloads.organizations.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.operations.list":

type OrganizationsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *OrganizationsLocationsOperationsService) List(name string) *OrganizationsLocationsOperationsListCall {
	c := &OrganizationsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *OrganizationsLocationsOperationsListCall) Filter(filter string) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *OrganizationsLocationsOperationsListCall) PageSize(pageSize int64) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *OrganizationsLocationsOperationsListCall) PageToken(pageToken string) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsOperationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsOperationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsOperationsListCall) Context(ctx context.Context) *OrganizationsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "assuredworkloads.organizations.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "assuredworkloads.organizations.locations.workloads.analyzeWorkloadMove":

type OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall struct {
	s            *Service
	target       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AnalyzeWorkloadMove: Analyzes a hypothetical move of a source
// resource to a target workload to surface compliance risks. The
// analysis is best effort and is not guaranteed to be exhaustive.
//
//   - target: The resource ID of the folder-based destination workload.
//     This workload is where the source resource will hypothetically be
//     moved to. Specify the workload's relative resource name, formatted
//     as:
//     "organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{
//     WORKLOAD_ID}" For example:
//     "organizations/123/locations/us-east1/workloads/assured-workload-2".
func (r *OrganizationsLocationsWorkloadsService) AnalyzeWorkloadMove(target string) *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall {
	c := &OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.target = target
	return c
}

// AssetTypes sets the optional parameter "assetTypes": List of asset
// types to be analyzed, including and under the source resource. If
// empty, all assets are analyzed. The complete list of asset types is
// available here
// (https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) AssetTypes(assetTypes ...string) *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall {
	c.urlParams_.SetMulti("assetTypes", append([]string{}, assetTypes...))
	return c
}

// PageSize sets the optional parameter "pageSize": Page size. If a
// value is not specified, the default value of 10 is used.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) PageSize(pageSize int64) *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token
// from the previous response. It needs to be passed in the second and
// following requests.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) PageToken(pageToken string) *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Project sets the optional parameter "project": The source type is a
// project. Specify the project's relative resource name, formatted as
// either a project number or a project ID: "projects/{PROJECT_NUMBER}"
// or "projects/{PROJECT_ID}" For example: "projects/951040570662" when
// specifying a project number, or "projects/my-project-123" when
// specifying a project ID.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) Project(project string) *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall {
	c.urlParams_.Set("project", project)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) IfNoneMatch(entityTag string) *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+target}:analyzeWorkloadMove")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"target": c.target,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.analyzeWorkloadMove" call.
// Exactly one of
// *GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Analyzes a hypothetical move of a source resource to a target workload to surface compliance risks. The analysis is best effort and is not guaranteed to be exhaustive.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}:analyzeWorkloadMove",
	//   "httpMethod": "GET",
	//   "id": "assuredworkloads.organizations.locations.workloads.analyzeWorkloadMove",
	//   "parameterOrder": [
	//     "target"
	//   ],
	//   "parameters": {
	//     "assetTypes": {
	//       "description": "Optional. List of asset types to be analyzed, including and under the source resource. If empty, all assets are analyzed. The complete list of asset types is available [here](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Page size. If a value is not specified, the default value of 10 is used.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. The page token from the previous response. It needs to be passed in the second and following requests.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "project": {
	//       "description": "The source type is a project. Specify the project's relative resource name, formatted as either a project number or a project ID: \"projects/{PROJECT_NUMBER}\" or \"projects/{PROJECT_ID}\" For example: \"projects/951040570662\" when specifying a project number, or \"projects/my-project-123\" when specifying a project ID.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "target": {
	//       "description": "Required. The resource ID of the folder-based destination workload. This workload is where the source resource will hypothetically be moved to. Specify the workload's relative resource name, formatted as: \"organizations/{ORGANIZATION_ID}/locations/{LOCATION_ID}/workloads/{WORKLOAD_ID}\" For example: \"organizations/123/locations/us-east1/workloads/assured-workload-2\"",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+target}:analyzeWorkloadMove",
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsWorkloadsAnalyzeWorkloadMoveCall) Pages(ctx context.Context, f func(*GoogleCloudAssuredworkloadsV1AnalyzeWorkloadMoveResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "assuredworkloads.organizations.locations.workloads.create":

type OrganizationsLocationsWorkloadsCreateCall struct {
	s                                     *Service
	parent                                string
	googlecloudassuredworkloadsv1workload *GoogleCloudAssuredworkloadsV1Workload
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Creates Assured Workload.
//
//   - parent: The resource name of the new Workload's parent. Must be of
//     the form `organizations/{org_id}/locations/{location_id}`.
func (r *OrganizationsLocationsWorkloadsService) Create(parent string, googlecloudassuredworkloadsv1workload *GoogleCloudAssuredworkloadsV1Workload) *OrganizationsLocationsWorkloadsCreateCall {
	c := &OrganizationsLocationsWorkloadsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudassuredworkloadsv1workload = googlecloudassuredworkloadsv1workload
	return c
}

// ExternalId sets the optional parameter "externalId": A identifier
// associated with the workload and underlying projects which allows for
// the break down of billing costs for a workload. The value provided
// for the identifier will add a label to the workload and contained
// projects with the identifier as the value.
func (c *OrganizationsLocationsWorkloadsCreateCall) ExternalId(externalId string) *OrganizationsLocationsWorkloadsCreateCall {
	c.urlParams_.Set("externalId", externalId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsCreateCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudassuredworkloadsv1workload)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/workloads")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsWorkloadsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates Assured Workload.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads",
	//   "httpMethod": "POST",
	//   "id": "assuredworkloads.organizations.locations.workloads.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "externalId": {
	//       "description": "Optional. A identifier associated with the workload and underlying projects which allows for the break down of billing costs for a workload. The value provided for the identifier will add a label to the workload and contained projects with the identifier as the value.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the new Workload's parent. Must be of the form `organizations/{org_id}/locations/{location_id}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/workloads",
	//   "request": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1Workload"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.workloads.delete":

type OrganizationsLocationsWorkloadsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the workload. Make sure that workload's direct
// children are already in a deleted state, otherwise the request will
// fail with a FAILED_PRECONDITION error. In addition to
// assuredworkloads.workload.delete permission, the user should also
// have orgpolicy.policy.set permission on the deleted folder to remove
// Assured Workloads OrgPolicies.
//
//   - name: The `name` field is used to identify the workload. Format:
//     organizations/{org_id}/locations/{location_id}/workloads/{workload_i
//     d}.
func (r *OrganizationsLocationsWorkloadsService) Delete(name string) *OrganizationsLocationsWorkloadsDeleteCall {
	c := &OrganizationsLocationsWorkloadsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": The etag of the workload. If
// this is provided, it must match the server's etag.
func (c *OrganizationsLocationsWorkloadsDeleteCall) Etag(etag string) *OrganizationsLocationsWorkloadsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsWorkloadsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the workload. Make sure that workload's direct children are already in a deleted state, otherwise the request will fail with a FAILED_PRECONDITION error. In addition to assuredworkloads.workload.delete permission, the user should also have orgpolicy.policy.set permission on the deleted folder to remove Assured Workloads OrgPolicies.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}",
	//   "httpMethod": "DELETE",
	//   "id": "assuredworkloads.organizations.locations.workloads.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "etag": {
	//       "description": "Optional. The etag of the workload. If this is provided, it must match the server's etag.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The `name` field is used to identify the workload. Format: organizations/{org_id}/locations/{location_id}/workloads/{workload_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.workloads.get":

type OrganizationsLocationsWorkloadsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets Assured Workload associated with a CRM Node
//
//   - name: The resource name of the Workload to fetch. This is the
//     workloads's relative path in the API, formatted as
//     "organizations/{organization_id}/locations/{location_id}/workloads/{
//     workload_id}". For example,
//     "organizations/123/locations/us-east1/workloads/assured-workload-1".
func (r *OrganizationsLocationsWorkloadsService) Get(name string) *OrganizationsLocationsWorkloadsGetCall {
	c := &OrganizationsLocationsWorkloadsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsWorkloadsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsWorkloadsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsGetCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.get" call.
// Exactly one of *GoogleCloudAssuredworkloadsV1Workload or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudAssuredworkloadsV1Workload.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsWorkloadsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1Workload, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1Workload{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets Assured Workload associated with a CRM Node",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}",
	//   "httpMethod": "GET",
	//   "id": "assuredworkloads.organizations.locations.workloads.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Workload to fetch. This is the workloads's relative path in the API, formatted as \"organizations/{organization_id}/locations/{location_id}/workloads/{workload_id}\". For example, \"organizations/123/locations/us-east1/workloads/assured-workload-1\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1Workload"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.workloads.list":

type OrganizationsLocationsWorkloadsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Assured Workloads under a CRM Node.
//
//   - parent: Parent Resource to list workloads from. Must be of the form
//     `organizations/{org_id}/locations/{location}`.
func (r *OrganizationsLocationsWorkloadsService) List(parent string) *OrganizationsLocationsWorkloadsListCall {
	c := &OrganizationsLocationsWorkloadsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A custom filter for
// filtering by properties of a workload. At this time, only filtering
// by labels is supported.
func (c *OrganizationsLocationsWorkloadsListCall) Filter(filter string) *OrganizationsLocationsWorkloadsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Page size.
func (c *OrganizationsLocationsWorkloadsListCall) PageSize(pageSize int64) *OrganizationsLocationsWorkloadsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// returned from previous request. Page token contains context from
// previous request. Page token needs to be passed in the second and
// following requests.
func (c *OrganizationsLocationsWorkloadsListCall) PageToken(pageToken string) *OrganizationsLocationsWorkloadsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsWorkloadsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsWorkloadsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsListCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/workloads")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.list" call.
// Exactly one of *GoogleCloudAssuredworkloadsV1ListWorkloadsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudAssuredworkloadsV1ListWorkloadsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsWorkloadsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1ListWorkloadsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1ListWorkloadsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists Assured Workloads under a CRM Node.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads",
	//   "httpMethod": "GET",
	//   "id": "assuredworkloads.organizations.locations.workloads.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A custom filter for filtering by properties of a workload. At this time, only filtering by labels is supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Page token returned from previous request. Page token contains context from previous request. Page token needs to be passed in the second and following requests.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Parent Resource to list workloads from. Must be of the form `organizations/{org_id}/locations/{location}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/workloads",
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1ListWorkloadsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsWorkloadsListCall) Pages(ctx context.Context, f func(*GoogleCloudAssuredworkloadsV1ListWorkloadsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "assuredworkloads.organizations.locations.workloads.mutatePartnerPermissions":

type OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall struct {
	s                                                            *Service
	name                                                         string
	googlecloudassuredworkloadsv1mutatepartnerpermissionsrequest *GoogleCloudAssuredworkloadsV1MutatePartnerPermissionsRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// MutatePartnerPermissions: Update the permissions settings for an
// existing partner workload. For force updates don't set etag field in
// the Workload. Only one update operation per workload can be in
// progress.
//
//   - name: The `name` field is used to identify the workload. Format:
//     organizations/{org_id}/locations/{location_id}/workloads/{workload_i
//     d}.
func (r *OrganizationsLocationsWorkloadsService) MutatePartnerPermissions(name string, googlecloudassuredworkloadsv1mutatepartnerpermissionsrequest *GoogleCloudAssuredworkloadsV1MutatePartnerPermissionsRequest) *OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall {
	c := &OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudassuredworkloadsv1mutatepartnerpermissionsrequest = googlecloudassuredworkloadsv1mutatepartnerpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudassuredworkloadsv1mutatepartnerpermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:mutatePartnerPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.mutatePartnerPermissions" call.
// Exactly one of *GoogleCloudAssuredworkloadsV1Workload or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudAssuredworkloadsV1Workload.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsWorkloadsMutatePartnerPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1Workload, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1Workload{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the permissions settings for an existing partner workload. For force updates don't set etag field in the Workload. Only one update operation per workload can be in progress.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}:mutatePartnerPermissions",
	//   "httpMethod": "PATCH",
	//   "id": "assuredworkloads.organizations.locations.workloads.mutatePartnerPermissions",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The `name` field is used to identify the workload. Format: organizations/{org_id}/locations/{location_id}/workloads/{workload_id}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:mutatePartnerPermissions",
	//   "request": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1MutatePartnerPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1Workload"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.workloads.patch":

type OrganizationsLocationsWorkloadsPatchCall struct {
	s                                     *Service
	name                                  string
	googlecloudassuredworkloadsv1workload *GoogleCloudAssuredworkloadsV1Workload
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates an existing workload. Currently allows updating of
// workload display_name and labels. For force updates don't set etag
// field in the Workload. Only one update operation per workload can be
// in progress.
//
//   - name: Optional. The resource name of the workload. Format:
//     organizations/{organization}/locations/{location}/workloads/{workloa
//     d} Read-only.
func (r *OrganizationsLocationsWorkloadsService) Patch(name string, googlecloudassuredworkloadsv1workload *GoogleCloudAssuredworkloadsV1Workload) *OrganizationsLocationsWorkloadsPatchCall {
	c := &OrganizationsLocationsWorkloadsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudassuredworkloadsv1workload = googlecloudassuredworkloadsv1workload
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated.
func (c *OrganizationsLocationsWorkloadsPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsWorkloadsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsPatchCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudassuredworkloadsv1workload)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.patch" call.
// Exactly one of *GoogleCloudAssuredworkloadsV1Workload or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudAssuredworkloadsV1Workload.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsWorkloadsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1Workload, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1Workload{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing workload. Currently allows updating of workload display_name and labels. For force updates don't set etag field in the Workload. Only one update operation per workload can be in progress.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}",
	//   "httpMethod": "PATCH",
	//   "id": "assuredworkloads.organizations.locations.workloads.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Optional. The resource name of the workload. Format: organizations/{organization}/locations/{location}/workloads/{workload} Read-only.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1Workload"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1Workload"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.workloads.restrictAllowedResources":

type OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall struct {
	s                                                            *Service
	name                                                         string
	googlecloudassuredworkloadsv1restrictallowedresourcesrequest *GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// RestrictAllowedResources: Restrict the list of resources allowed in
// the Workload environment. The current list of allowed products can be
// found at
// https://cloud.google.com/assured-workloads/docs/supported-products In
// addition to assuredworkloads.workload.update permission, the user
// should also have orgpolicy.policy.set permission on the folder
// resource to use this functionality.
//
//   - name: The resource name of the Workload. This is the workloads's
//     relative path in the API, formatted as
//     "organizations/{organization_id}/locations/{location_id}/workloads/{
//     workload_id}". For example,
//     "organizations/123/locations/us-east1/workloads/assured-workload-1".
func (r *OrganizationsLocationsWorkloadsService) RestrictAllowedResources(name string, googlecloudassuredworkloadsv1restrictallowedresourcesrequest *GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesRequest) *OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall {
	c := &OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudassuredworkloadsv1restrictallowedresourcesrequest = googlecloudassuredworkloadsv1restrictallowedresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudassuredworkloadsv1restrictallowedresourcesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:restrictAllowedResources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.restrictAllowedResources" call.
// Exactly one of
// *GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesResponse.ServerR
// esponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsWorkloadsRestrictAllowedResourcesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Restrict the list of resources allowed in the Workload environment. The current list of allowed products can be found at https://cloud.google.com/assured-workloads/docs/supported-products In addition to assuredworkloads.workload.update permission, the user should also have orgpolicy.policy.set permission on the folder resource to use this functionality.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}:restrictAllowedResources",
	//   "httpMethod": "POST",
	//   "id": "assuredworkloads.organizations.locations.workloads.restrictAllowedResources",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Workload. This is the workloads's relative path in the API, formatted as \"organizations/{organization_id}/locations/{location_id}/workloads/{workload_id}\". For example, \"organizations/123/locations/us-east1/workloads/assured-workload-1\".",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:restrictAllowedResources",
	//   "request": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1RestrictAllowedResourcesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.workloads.violations.acknowledge":

type OrganizationsLocationsWorkloadsViolationsAcknowledgeCall struct {
	s                                                        *Service
	name                                                     string
	googlecloudassuredworkloadsv1acknowledgeviolationrequest *GoogleCloudAssuredworkloadsV1AcknowledgeViolationRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Acknowledge: Acknowledges an existing violation. By acknowledging a
// violation, users acknowledge the existence of a compliance violation
// in their workload and decide to ignore it due to a valid business
// justification. Acknowledgement is a permanent operation and it cannot
// be reverted.
//
//   - name: The resource name of the Violation to acknowledge. Format:
//     organizations/{organization}/locations/{location}/workloads/{workloa
//     d}/violations/{violation}.
func (r *OrganizationsLocationsWorkloadsViolationsService) Acknowledge(name string, googlecloudassuredworkloadsv1acknowledgeviolationrequest *GoogleCloudAssuredworkloadsV1AcknowledgeViolationRequest) *OrganizationsLocationsWorkloadsViolationsAcknowledgeCall {
	c := &OrganizationsLocationsWorkloadsViolationsAcknowledgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudassuredworkloadsv1acknowledgeviolationrequest = googlecloudassuredworkloadsv1acknowledgeviolationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsViolationsAcknowledgeCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsViolationsAcknowledgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsViolationsAcknowledgeCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsViolationsAcknowledgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsViolationsAcknowledgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsViolationsAcknowledgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudassuredworkloadsv1acknowledgeviolationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:acknowledge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.violations.acknowledge" call.
// Exactly one of
// *GoogleCloudAssuredworkloadsV1AcknowledgeViolationResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudAssuredworkloadsV1AcknowledgeViolationResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsWorkloadsViolationsAcknowledgeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1AcknowledgeViolationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1AcknowledgeViolationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Acknowledges an existing violation. By acknowledging a violation, users acknowledge the existence of a compliance violation in their workload and decide to ignore it due to a valid business justification. Acknowledgement is a permanent operation and it cannot be reverted.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}/violations/{violationsId}:acknowledge",
	//   "httpMethod": "POST",
	//   "id": "assuredworkloads.organizations.locations.workloads.violations.acknowledge",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Violation to acknowledge. Format: organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+/violations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:acknowledge",
	//   "request": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1AcknowledgeViolationRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1AcknowledgeViolationResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.workloads.violations.get":

type OrganizationsLocationsWorkloadsViolationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves Assured Workload Violation based on ID.
//
//   - name: The resource name of the Violation to fetch (ie.
//     Violation.name). Format:
//     organizations/{organization}/locations/{location}/workloads/{workloa
//     d}/violations/{violation}.
func (r *OrganizationsLocationsWorkloadsViolationsService) Get(name string) *OrganizationsLocationsWorkloadsViolationsGetCall {
	c := &OrganizationsLocationsWorkloadsViolationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsViolationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsViolationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsWorkloadsViolationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsWorkloadsViolationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsViolationsGetCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsViolationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsViolationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsViolationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.violations.get" call.
// Exactly one of *GoogleCloudAssuredworkloadsV1Violation or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudAssuredworkloadsV1Violation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsLocationsWorkloadsViolationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1Violation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1Violation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves Assured Workload Violation based on ID.",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}/violations/{violationsId}",
	//   "httpMethod": "GET",
	//   "id": "assuredworkloads.organizations.locations.workloads.violations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Violation to fetch (ie. Violation.name). Format: organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+/violations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1Violation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "assuredworkloads.organizations.locations.workloads.violations.list":

type OrganizationsLocationsWorkloadsViolationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Violations in the AssuredWorkload Environment.
// Callers may also choose to read across multiple Workloads as per
// AIP-159 (https://google.aip.dev/159) by using '-' (the hyphen or dash
// character) as a wildcard character instead of workload-id in the
// parent. Format
// `organizations/{org_id}/locations/{location}/workloads/-`
//
//   - parent: The Workload name. Format
//     `organizations/{org_id}/locations/{location}/workloads/{workload}`.
func (r *OrganizationsLocationsWorkloadsViolationsService) List(parent string) *OrganizationsLocationsWorkloadsViolationsListCall {
	c := &OrganizationsLocationsWorkloadsViolationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A custom filter for
// filtering by the Violations properties.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) Filter(filter string) *OrganizationsLocationsWorkloadsViolationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IntervalEndTime sets the optional parameter "interval.endTime": The
// end of the time window.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) IntervalEndTime(intervalEndTime string) *OrganizationsLocationsWorkloadsViolationsListCall {
	c.urlParams_.Set("interval.endTime", intervalEndTime)
	return c
}

// IntervalStartTime sets the optional parameter "interval.startTime":
// The start of the time window.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) IntervalStartTime(intervalStartTime string) *OrganizationsLocationsWorkloadsViolationsListCall {
	c.urlParams_.Set("interval.startTime", intervalStartTime)
	return c
}

// PageSize sets the optional parameter "pageSize": Page size.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) PageSize(pageSize int64) *OrganizationsLocationsWorkloadsViolationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// returned from previous request.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) PageToken(pageToken string) *OrganizationsLocationsWorkloadsViolationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsWorkloadsViolationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsWorkloadsViolationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) Context(ctx context.Context) *OrganizationsLocationsWorkloadsViolationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsWorkloadsViolationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/violations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "assuredworkloads.organizations.locations.workloads.violations.list" call.
// Exactly one of *GoogleCloudAssuredworkloadsV1ListViolationsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudAssuredworkloadsV1ListViolationsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudAssuredworkloadsV1ListViolationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudAssuredworkloadsV1ListViolationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the Violations in the AssuredWorkload Environment. Callers may also choose to read across multiple Workloads as per [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash character) as a wildcard character instead of workload-id in the parent. Format `organizations/{org_id}/locations/{location}/workloads/-`",
	//   "flatPath": "v1/organizations/{organizationsId}/locations/{locationsId}/workloads/{workloadsId}/violations",
	//   "httpMethod": "GET",
	//   "id": "assuredworkloads.organizations.locations.workloads.violations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. A custom filter for filtering by the Violations properties.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.endTime": {
	//       "description": "The end of the time window.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "interval.startTime": {
	//       "description": "The start of the time window.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token returned from previous request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The Workload name. Format `organizations/{org_id}/locations/{location}/workloads/{workload}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/locations/[^/]+/workloads/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/violations",
	//   "response": {
	//     "$ref": "GoogleCloudAssuredworkloadsV1ListViolationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsWorkloadsViolationsListCall) Pages(ctx context.Context, f func(*GoogleCloudAssuredworkloadsV1ListViolationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
