// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/irm/v1alpha2/incidents.proto

package irm

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Describes whether the alerting condition is still firing.
type Signal_State int32

const (
	// Unspecified
	Signal_STATE_UNSPECIFIED Signal_State = 0
	// Firing
	Signal_STATE_OPEN Signal_State = 1
	// Non-firing
	Signal_STATE_CLOSED Signal_State = 2
)

// Enum value maps for Signal_State.
var (
	Signal_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STATE_OPEN",
		2: "STATE_CLOSED",
	}
	Signal_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STATE_OPEN":        1,
		"STATE_CLOSED":      2,
	}
)

func (x Signal_State) Enum() *Signal_State {
	p := new(Signal_State)
	*p = x
	return p
}

func (x Signal_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Signal_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[0].Descriptor()
}

func (Signal_State) Type() protoreflect.EnumType {
	return &file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[0]
}

func (x Signal_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Signal_State.Descriptor instead.
func (Signal_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{1, 0}
}

// Specifies the escalation level of this incident, within the IRM protocol
// for handling incidents.
type Incident_EscalationLevel int32

const (
	// The incident has not been escalated. This is the value used by all new
	// and legacy incidents.
	Incident_ESCALATION_LEVEL_UNSPECIFIED Incident_EscalationLevel = 0
	// The incident has been escalated to the organizational level.
	Incident_ESCALATION_LEVEL_ORGANIZATION Incident_EscalationLevel = 1
)

// Enum value maps for Incident_EscalationLevel.
var (
	Incident_EscalationLevel_name = map[int32]string{
		0: "ESCALATION_LEVEL_UNSPECIFIED",
		1: "ESCALATION_LEVEL_ORGANIZATION",
	}
	Incident_EscalationLevel_value = map[string]int32{
		"ESCALATION_LEVEL_UNSPECIFIED":  0,
		"ESCALATION_LEVEL_ORGANIZATION": 1,
	}
)

func (x Incident_EscalationLevel) Enum() *Incident_EscalationLevel {
	p := new(Incident_EscalationLevel)
	*p = x
	return p
}

func (x Incident_EscalationLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Incident_EscalationLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[1].Descriptor()
}

func (Incident_EscalationLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[1]
}

func (x Incident_EscalationLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Incident_EscalationLevel.Descriptor instead.
func (Incident_EscalationLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{5, 0}
}

// Severity of an incident.
type Incident_Severity int32

const (
	// Severity is not specified.
	Incident_SEVERITY_UNSPECIFIED Incident_Severity = 0
	// Huge incident.
	Incident_SEVERITY_HUGE Incident_Severity = 1
	// Major incident.
	Incident_SEVERITY_MAJOR Incident_Severity = 2
	// Medium incident.
	Incident_SEVERITY_MEDIUM Incident_Severity = 3
	// Minor incident.
	Incident_SEVERITY_MINOR Incident_Severity = 4
	// Negligible incident.
	Incident_SEVERITY_NEGLIGIBLE Incident_Severity = 5
)

// Enum value maps for Incident_Severity.
var (
	Incident_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "SEVERITY_HUGE",
		2: "SEVERITY_MAJOR",
		3: "SEVERITY_MEDIUM",
		4: "SEVERITY_MINOR",
		5: "SEVERITY_NEGLIGIBLE",
	}
	Incident_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"SEVERITY_HUGE":        1,
		"SEVERITY_MAJOR":       2,
		"SEVERITY_MEDIUM":      3,
		"SEVERITY_MINOR":       4,
		"SEVERITY_NEGLIGIBLE":  5,
	}
)

func (x Incident_Severity) Enum() *Incident_Severity {
	p := new(Incident_Severity)
	*p = x
	return p
}

func (x Incident_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Incident_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[2].Descriptor()
}

func (Incident_Severity) Type() protoreflect.EnumType {
	return &file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[2]
}

func (x Incident_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Incident_Severity.Descriptor instead.
func (Incident_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{5, 1}
}

// Stage of an incident.
type Incident_Stage int32

const (
	// This is the default value if no stage has been specified.
	// Note: The caller of the API should set the stage to DETECTED.
	Incident_STAGE_UNSPECIFIED Incident_Stage = 0
	// The incident has been detected. This is the initial stage of a new
	// incident.
	// Note: The caller still has to set the stage manually.
	Incident_STAGE_DETECTED Incident_Stage = 4
	// This incident has been formally characterized.
	Incident_STAGE_TRIAGED Incident_Stage = 1
	// This incident has been mitigated, i.e. does not affect the service level
	// anymore.
	Incident_STAGE_MITIGATED Incident_Stage = 2
	// This incident has been fully resolved, i.e. there are no immediate
	// follow-up tasks.
	Incident_STAGE_RESOLVED Incident_Stage = 3
	// Postmortem for the incident was written.
	Incident_STAGE_DOCUMENTED Incident_Stage = 5
	// Stage for an incident with `duplicate_incident`. This incident is not
	// authoritative anymore and the `duplicate_incident` should be used to
	// determine the stage.
	Incident_STAGE_DUPLICATE Incident_Stage = 6
)

// Enum value maps for Incident_Stage.
var (
	Incident_Stage_name = map[int32]string{
		0: "STAGE_UNSPECIFIED",
		4: "STAGE_DETECTED",
		1: "STAGE_TRIAGED",
		2: "STAGE_MITIGATED",
		3: "STAGE_RESOLVED",
		5: "STAGE_DOCUMENTED",
		6: "STAGE_DUPLICATE",
	}
	Incident_Stage_value = map[string]int32{
		"STAGE_UNSPECIFIED": 0,
		"STAGE_DETECTED":    4,
		"STAGE_TRIAGED":     1,
		"STAGE_MITIGATED":   2,
		"STAGE_RESOLVED":    3,
		"STAGE_DOCUMENTED":  5,
		"STAGE_DUPLICATE":   6,
	}
)

func (x Incident_Stage) Enum() *Incident_Stage {
	p := new(Incident_Stage)
	*p = x
	return p
}

func (x Incident_Stage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Incident_Stage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[3].Descriptor()
}

func (Incident_Stage) Type() protoreflect.EnumType {
	return &file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[3]
}

func (x Incident_Stage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Incident_Stage.Descriptor instead.
func (Incident_Stage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{5, 2}
}

// The type of channel/venue for incident communications.
type Incident_CommunicationVenue_ChannelType int32

const (
	// An unspecified communication channel.
	Incident_CommunicationVenue_CHANNEL_TYPE_UNSPECIFIED Incident_CommunicationVenue_ChannelType = 0
	// A communication channel that is represented by a generic URI.
	Incident_CommunicationVenue_CHANNEL_TYPE_URI Incident_CommunicationVenue_ChannelType = 1
	// A communication channel that represents a Slack channel.
	Incident_CommunicationVenue_CHANNEL_TYPE_SLACK Incident_CommunicationVenue_ChannelType = 5
)

// Enum value maps for Incident_CommunicationVenue_ChannelType.
var (
	Incident_CommunicationVenue_ChannelType_name = map[int32]string{
		0: "CHANNEL_TYPE_UNSPECIFIED",
		1: "CHANNEL_TYPE_URI",
		5: "CHANNEL_TYPE_SLACK",
	}
	Incident_CommunicationVenue_ChannelType_value = map[string]int32{
		"CHANNEL_TYPE_UNSPECIFIED": 0,
		"CHANNEL_TYPE_URI":         1,
		"CHANNEL_TYPE_SLACK":       5,
	}
)

func (x Incident_CommunicationVenue_ChannelType) Enum() *Incident_CommunicationVenue_ChannelType {
	p := new(Incident_CommunicationVenue_ChannelType)
	*p = x
	return p
}

func (x Incident_CommunicationVenue_ChannelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Incident_CommunicationVenue_ChannelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[4].Descriptor()
}

func (Incident_CommunicationVenue_ChannelType) Type() protoreflect.EnumType {
	return &file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[4]
}

func (x Incident_CommunicationVenue_ChannelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Incident_CommunicationVenue_ChannelType.Descriptor instead.
func (Incident_CommunicationVenue_ChannelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{5, 0, 0}
}

// List of possible roles.
type IncidentRole_Type int32

const (
	// The role is unspecified.
	IncidentRole_TYPE_UNSPECIFIED IncidentRole_Type = 0
	// Incident Commander: Manages response plan, near-term and long-term
	// objectives, establishes priorities, and delegates tasks as needed.
	IncidentRole_TYPE_INCIDENT_COMMANDER IncidentRole_Type = 1
	// Communications Lead: Keeps everybody outside and within the response team
	// informed.
	IncidentRole_TYPE_COMMUNICATIONS_LEAD IncidentRole_Type = 2
	// Operations Lead: Figures out what to do, and gets it done.
	IncidentRole_TYPE_OPERATIONS_LEAD IncidentRole_Type = 3
	// External Customer Communications Lead: Responsible for communicating
	// incident details to customers/public.
	IncidentRole_TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD IncidentRole_Type = 4
	// Primary Oncall: Responds to the initial page and handles all
	// responsibilities for pre-escalated incidents.
	IncidentRole_TYPE_PRIMARY_ONCALL IncidentRole_Type = 5
	// Secondary Oncall: Helps the primary oncall if necessary; mostly useful
	// for pre-escalated incidents.
	IncidentRole_TYPE_SECONDARY_ONCALL IncidentRole_Type = 6
	// User-specified roles. One example is a Planning Lead, who keeps track of
	// the incident. Another is an assistant Incident Commander.
	IncidentRole_TYPE_OTHER IncidentRole_Type = 7
)

// Enum value maps for IncidentRole_Type.
var (
	IncidentRole_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TYPE_INCIDENT_COMMANDER",
		2: "TYPE_COMMUNICATIONS_LEAD",
		3: "TYPE_OPERATIONS_LEAD",
		4: "TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD",
		5: "TYPE_PRIMARY_ONCALL",
		6: "TYPE_SECONDARY_ONCALL",
		7: "TYPE_OTHER",
	}
	IncidentRole_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":                           0,
		"TYPE_INCIDENT_COMMANDER":                    1,
		"TYPE_COMMUNICATIONS_LEAD":                   2,
		"TYPE_OPERATIONS_LEAD":                       3,
		"TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD": 4,
		"TYPE_PRIMARY_ONCALL":                        5,
		"TYPE_SECONDARY_ONCALL":                      6,
		"TYPE_OTHER":                                 7,
	}
)

func (x IncidentRole_Type) Enum() *IncidentRole_Type {
	p := new(IncidentRole_Type)
	*p = x
	return p
}

func (x IncidentRole_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IncidentRole_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[5].Descriptor()
}

func (IncidentRole_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[5]
}

func (x IncidentRole_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IncidentRole_Type.Descriptor instead.
func (IncidentRole_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{6, 0}
}

// Possible types of an artifact.
type Artifact_Type int32

const (
	// External type is unspecified.
	Artifact_TYPE_UNSPECIFIED Artifact_Type = 0
	// URL.
	Artifact_TYPE_URL Artifact_Type = 1
	// A JIRA issue.
	Artifact_TYPE_JIRA_ISSUE Artifact_Type = 4
)

// Enum value maps for Artifact_Type.
var (
	Artifact_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TYPE_URL",
		4: "TYPE_JIRA_ISSUE",
	}
	Artifact_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"TYPE_URL":         1,
		"TYPE_JIRA_ISSUE":  4,
	}
)

func (x Artifact_Type) Enum() *Artifact_Type {
	p := new(Artifact_Type)
	*p = x
	return p
}

func (x Artifact_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Artifact_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[6].Descriptor()
}

func (Artifact_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[6]
}

func (x Artifact_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Artifact_Type.Descriptor instead.
func (Artifact_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{8, 0}
}

// Types of changes that users can subscribe to in an incident.
type Subscription_EventType int32

const (
	// An event_type that's not specified is an error.
	Subscription_EVENT_TYPE_UNSPECIFIED Subscription_EventType = 0
	// The incident's title has changed.
	Subscription_EVENT_TYPE_TITLE_CHANGE Subscription_EventType = 1
	// The incident's synopsis has changed.
	Subscription_EVENT_TYPE_SYNOPSIS_CHANGE Subscription_EventType = 2
	// The incident's stage has changed.
	Subscription_EVENT_TYPE_STAGE_CHANGE Subscription_EventType = 3
	// The incident's severity has changed.
	Subscription_EVENT_TYPE_SEVERITY_CHANGE Subscription_EventType = 4
	// A new annotation has been added to the incident.
	Subscription_EVENT_TYPE_ANNOTATION_ADD Subscription_EventType = 5
	// An annotation has been modified.
	Subscription_EVENT_TYPE_ANNOTATION_CHANGE Subscription_EventType = 6
)

// Enum value maps for Subscription_EventType.
var (
	Subscription_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "EVENT_TYPE_TITLE_CHANGE",
		2: "EVENT_TYPE_SYNOPSIS_CHANGE",
		3: "EVENT_TYPE_STAGE_CHANGE",
		4: "EVENT_TYPE_SEVERITY_CHANGE",
		5: "EVENT_TYPE_ANNOTATION_ADD",
		6: "EVENT_TYPE_ANNOTATION_CHANGE",
	}
	Subscription_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":       0,
		"EVENT_TYPE_TITLE_CHANGE":      1,
		"EVENT_TYPE_SYNOPSIS_CHANGE":   2,
		"EVENT_TYPE_STAGE_CHANGE":      3,
		"EVENT_TYPE_SEVERITY_CHANGE":   4,
		"EVENT_TYPE_ANNOTATION_ADD":    5,
		"EVENT_TYPE_ANNOTATION_CHANGE": 6,
	}
)

func (x Subscription_EventType) Enum() *Subscription_EventType {
	p := new(Subscription_EventType)
	*p = x
	return p
}

func (x Subscription_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subscription_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[7].Descriptor()
}

func (Subscription_EventType) Type() protoreflect.EnumType {
	return &file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes[7]
}

func (x Subscription_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subscription_EventType.Descriptor instead.
func (Subscription_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{10, 0}
}

// A user of the IRM app.
type User struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of several ways to uniquely identify a user.
	//
	// Types that are assignable to User:
	//	*User_UserId
	//	*User_Email
	User isUser_User `protobuf_oneof:"user"`
}

func (x *User) Reset() {
	*x = User{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use User.ProtoReflect.Descriptor instead.
func (*User) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{0}
}

func (m *User) GetUser() isUser_User {
	if m != nil {
		return m.User
	}
	return nil
}

func (x *User) GetUserId() string {
	if x, ok := x.GetUser().(*User_UserId); ok {
		return x.UserId
	}
	return ""
}

func (x *User) GetEmail() string {
	if x, ok := x.GetUser().(*User_Email); ok {
		return x.Email
	}
	return ""
}

type isUser_User interface {
	isUser_User()
}

type User_UserId struct {
	// Output only. User id that will allow to get additional information from
	// People API. This field will be populated implicitly if the caller creates
	// or edits a resource (for example, posts an annotation).
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3,oneof"`
}

type User_Email struct {
	// Email address of the user. This must be associated with a Google account.
	// This field will be set if the user is explicitly identified (verbatim) by
	// email address in an API request (potentially sometime in the past). It
	// will not be populated based on the credentials of a caller of the API.
	Email string `protobuf:"bytes,2,opt,name=email,proto3,oneof"`
}

func (*User_UserId) isUser_User() {}

func (*User_Email) isUser_User() {}

// A signal is a message calling attention to a (potential) incident. An example
// is a page based on a Stackdriver Alerting policy.
type Signal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the signal, for example,
	// "projects/{project_id_or_number}/signals/{signal_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Etag to validate the object is unchanged for a read-modify-write operation.
	// An empty etag will overwrite other changes.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Resource name of the incident this signal is currently assigned to.
	// May be empty if signal is unassigned.
	Incident string `protobuf:"bytes,3,opt,name=incident,proto3" json:"incident,omitempty"`
	// Output only. Time this signal was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time this signal was closed. This field is not populated
	// while the signal is still firing.
	CloseTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=close_time,json=closeTime,proto3" json:"close_time,omitempty"`
	// The time this Signal was first detected. This is identical to create_time
	// for Signals created by Stackdriver Alerting.
	DetectTime *timestamp.Timestamp `protobuf:"bytes,15,opt,name=detect_time,json=detectTime,proto3" json:"detect_time,omitempty"`
	// Output only. The user that created this signal for manually created
	// signals. Empty if this signal was generated by a system (for example,
	// Stackdriver Alerting).
	Creator *User `protobuf:"bytes,5,opt,name=creator,proto3" json:"creator,omitempty"`
	// One-line summary of the signal.
	// Immutable.
	Title string `protobuf:"bytes,6,opt,name=title,proto3" json:"title,omitempty"`
	// Content type string. 'text/plain' is currently the only supported content
	// type for Signals created via the API. Signals created by Stackdriver
	// Alerting support 'text/html' as well. Immutable for Signals created by
	// Stackdriver Alerting.
	ContentType string `protobuf:"bytes,7,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Full message of the signal.
	// Immutable for Signals created by Stackdriver Alerting.
	Content string `protobuf:"bytes,8,opt,name=content,proto3" json:"content,omitempty"`
	// The state of this signal.
	// For Signals created by Stackdriver Alerting this field is output only.
	SignalState Signal_State `protobuf:"varint,9,opt,name=signal_state,json=signalState,proto3,enum=google.cloud.irm.v1alpha2.Signal_State" json:"signal_state,omitempty"`
	// A set of artifacts to additional resources for this Signal. For example, a
	// link to Stackdriver logging for the Signal.
	// Immutable for Signals created by Stackdriver Alerting.
	SignalArtifacts []*Signal_SignalArtifact `protobuf:"bytes,16,rep,name=signal_artifacts,json=signalArtifacts,proto3" json:"signal_artifacts,omitempty"`
}

func (x *Signal) Reset() {
	*x = Signal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Signal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signal) ProtoMessage() {}

func (x *Signal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signal.ProtoReflect.Descriptor instead.
func (*Signal) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{1}
}

func (x *Signal) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Signal) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Signal) GetIncident() string {
	if x != nil {
		return x.Incident
	}
	return ""
}

func (x *Signal) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Signal) GetCloseTime() *timestamp.Timestamp {
	if x != nil {
		return x.CloseTime
	}
	return nil
}

func (x *Signal) GetDetectTime() *timestamp.Timestamp {
	if x != nil {
		return x.DetectTime
	}
	return nil
}

func (x *Signal) GetCreator() *User {
	if x != nil {
		return x.Creator
	}
	return nil
}

func (x *Signal) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Signal) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *Signal) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Signal) GetSignalState() Signal_State {
	if x != nil {
		return x.SignalState
	}
	return Signal_STATE_UNSPECIFIED
}

func (x *Signal) GetSignalArtifacts() []*Signal_SignalArtifact {
	if x != nil {
		return x.SignalArtifacts
	}
	return nil
}

// A text annotation by a user.
type Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the annotation, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}/annotations/{annotation_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Author of the annotation.
	Author *User `protobuf:"bytes,2,opt,name=author,proto3" json:"author,omitempty"`
	// Output only. Time the annotation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Content of the annotation.
	Content string `protobuf:"bytes,4,opt,name=content,proto3" json:"content,omitempty"`
	// Content type of the annotation, for example, 'text/plain'
	// or 'text/markdown'.
	ContentType string `protobuf:"bytes,5,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
}

func (x *Annotation) Reset() {
	*x = Annotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotation) ProtoMessage() {}

func (x *Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Annotation.ProtoReflect.Descriptor instead.
func (*Annotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{2}
}

func (x *Annotation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Annotation) GetAuthor() *User {
	if x != nil {
		return x.Author
	}
	return nil
}

func (x *Annotation) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Annotation) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Annotation) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

// A tag by a user.
type Tag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of a tag, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}/tags/{tag_id}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name of the resource (for example, "cause:rollout"). Immutable.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *Tag) Reset() {
	*x = Tag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tag) ProtoMessage() {}

func (x *Tag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tag.ProtoReflect.Descriptor instead.
func (*Tag) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{3}
}

func (x *Tag) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tag) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Synopsis is a summary of an incident and it contains a textual content,
// an author and a last updated timestamp.
type Synopsis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content type string, for example, 'text/plain' or 'text/markdown'.
	ContentType string `protobuf:"bytes,1,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Textual content of the synopsis. It can be plain text or markdown as
	// indicated by the content_type.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Last updated timestamp.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Author of the synopsis.
	Author *User `protobuf:"bytes,4,opt,name=author,proto3" json:"author,omitempty"`
}

func (x *Synopsis) Reset() {
	*x = Synopsis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Synopsis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Synopsis) ProtoMessage() {}

func (x *Synopsis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Synopsis.ProtoReflect.Descriptor instead.
func (*Synopsis) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{4}
}

func (x *Synopsis) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *Synopsis) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Synopsis) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Synopsis) GetAuthor() *User {
	if x != nil {
		return x.Author
	}
	return nil
}

// Representation of an incident.
type Incident struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One-line summary of the incident.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Escalation level of the incident.
	EscalationLevel Incident_EscalationLevel `protobuf:"varint,3,opt,name=escalation_level,json=escalationLevel,proto3,enum=google.cloud.irm.v1alpha2.Incident_EscalationLevel" json:"escalation_level,omitempty"`
	// Etag to validate the object is unchanged for a read-modify-write operation.
	// An empty etag will overwrite other changes.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Severity of the incident.
	Severity Incident_Severity `protobuf:"varint,5,opt,name=severity,proto3,enum=google.cloud.irm.v1alpha2.Incident_Severity" json:"severity,omitempty"`
	// Stage of the incident.
	Stage Incident_Stage `protobuf:"varint,6,opt,name=stage,proto3,enum=google.cloud.irm.v1alpha2.Incident_Stage" json:"stage,omitempty"`
	// Resource name of the incident this incident is a duplicate of. Empty if
	// this incident is not a duplicate.
	// An incident can only be a duplicate of an incident that is not marked as a
	// duplicate already. Setting this to a non-empty value must also set the
	// stage to `STAGE_DUPLICATE`. Unsetting this value value must also update
	// `stage` to a value other than `STAGE_DUPLICATE`.
	DuplicateIncident string `protobuf:"bytes,9,opt,name=duplicate_incident,json=duplicateIncident,proto3" json:"duplicate_incident,omitempty"`
	// Output only. Time this incident started. Used to measure the 'elapsed
	// time'. Start time of an incident is the earliest creation time of any of
	// its Signals or the create time of the incident if no Signals are assigned.
	StartTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Synopsis of this incident.
	Synopsis *Synopsis `protobuf:"bytes,8,opt,name=synopsis,proto3" json:"synopsis,omitempty"`
	// Location of communications for this incident. This is informational
	// only; IRM does not use this to send messages.
	CommunicationVenue *Incident_CommunicationVenue `protobuf:"bytes,10,opt,name=communication_venue,json=communicationVenue,proto3" json:"communication_venue,omitempty"`
}

func (x *Incident) Reset() {
	*x = Incident{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Incident) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Incident) ProtoMessage() {}

func (x *Incident) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Incident.ProtoReflect.Descriptor instead.
func (*Incident) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{5}
}

func (x *Incident) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Incident) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Incident) GetEscalationLevel() Incident_EscalationLevel {
	if x != nil {
		return x.EscalationLevel
	}
	return Incident_ESCALATION_LEVEL_UNSPECIFIED
}

func (x *Incident) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Incident) GetSeverity() Incident_Severity {
	if x != nil {
		return x.Severity
	}
	return Incident_SEVERITY_UNSPECIFIED
}

func (x *Incident) GetStage() Incident_Stage {
	if x != nil {
		return x.Stage
	}
	return Incident_STAGE_UNSPECIFIED
}

func (x *Incident) GetDuplicateIncident() string {
	if x != nil {
		return x.DuplicateIncident
	}
	return ""
}

func (x *Incident) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Incident) GetSynopsis() *Synopsis {
	if x != nil {
		return x.Synopsis
	}
	return nil
}

func (x *Incident) GetCommunicationVenue() *Incident_CommunicationVenue {
	if x != nil {
		return x.CommunicationVenue
	}
	return nil
}

// Describes a role that can be assigned to an incident.
type IncidentRole struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of role. The role type is immutable in role assignments. Each role
	// type can only be used once per incident, except for TYPE_OTHER.
	Type IncidentRole_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.irm.v1alpha2.IncidentRole_Type" json:"type,omitempty"`
	// Output only and empty unless TYPE_OTHER is used. Title of the role. For
	// TYPE_OTHER, must be unique within an incident.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Output only and empty unless TYPE_OTHER is used. Description of the role.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *IncidentRole) Reset() {
	*x = IncidentRole{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IncidentRole) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IncidentRole) ProtoMessage() {}

func (x *IncidentRole) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IncidentRole.ProtoReflect.Descriptor instead.
func (*IncidentRole) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{6}
}

func (x *IncidentRole) GetType() IncidentRole_Type {
	if x != nil {
		return x.Type
	}
	return IncidentRole_TYPE_UNSPECIFIED
}

func (x *IncidentRole) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *IncidentRole) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Stores the assignee of a role as well as the proposed next assignee.
type IncidentRoleAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name such as
	// "projects/{project_id_or_number}/incidents/{incident_id}/role_assignments/{role_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The role that is or will be assigned.
	Role *IncidentRole `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	// The user this role is assigned to. This field can only be directly set
	// during creation request. Subsequent updates are done via the
	// IncidentRoleHandover methods.
	Assignee *User `protobuf:"bytes,4,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// The recipient of a requested role handoff. This field can only be directly
	// set during creation request. Subsequent updates are done via the
	// IncidentRoleHandover methods.
	//
	// `assignee` is always the current role-holder, and `proposed_assignee` is
	// used to track unfinished assignments and handoffs. Let's say Bob assigns
	// Alice to a role. Then the fields are:
	//   `assignee`: nil, `proposed_assignee`: Alice
	// If Alice accepts, then the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	// If she cancels, then the RoleAssignment is deleted.
	// Let's say Alice has the role. Then the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	// If Alice becomes incapacitated and Bob requests Carol to take over, then
	// the fields are:
	//   `assignee`: Alice, `proposed_assignee`: Carol
	// After Carol accepts the handover, the fields are:
	//   `assignee`: Carol, `proposed_assignee`: nil
	// Or if Carol refuses the handover, the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	ProposedAssignee *User `protobuf:"bytes,5,opt,name=proposed_assignee,json=proposedAssignee,proto3" json:"proposed_assignee,omitempty"`
}

func (x *IncidentRoleAssignment) Reset() {
	*x = IncidentRoleAssignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IncidentRoleAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IncidentRoleAssignment) ProtoMessage() {}

func (x *IncidentRoleAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IncidentRoleAssignment.ProtoReflect.Descriptor instead.
func (*IncidentRoleAssignment) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{7}
}

func (x *IncidentRoleAssignment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IncidentRoleAssignment) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *IncidentRoleAssignment) GetRole() *IncidentRole {
	if x != nil {
		return x.Role
	}
	return nil
}

func (x *IncidentRoleAssignment) GetAssignee() *User {
	if x != nil {
		return x.Assignee
	}
	return nil
}

func (x *IncidentRoleAssignment) GetProposedAssignee() *User {
	if x != nil {
		return x.ProposedAssignee
	}
	return nil
}

// External artifact associated to an incident.
type Artifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name such as
	// "projects/{project_id_or_number}/incidents/{incident_id}/artifacts/{artifact_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided name of an artifact.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// URL to access the artifact.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// Type of this artifact.
	Type Artifact_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.irm.v1alpha2.Artifact_Type" json:"type,omitempty"`
}

func (x *Artifact) Reset() {
	*x = Artifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Artifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Artifact) ProtoMessage() {}

func (x *Artifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Artifact.ProtoReflect.Descriptor instead.
func (*Artifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{8}
}

func (x *Artifact) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Artifact) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Artifact) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Artifact) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Artifact) GetType() Artifact_Type {
	if x != nil {
		return x.Type
	}
	return Artifact_TYPE_UNSPECIFIED
}

// Communication Channels are mechanisms used to receive notifications
// about changes to incidents.
type CommunicationChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An endpoint describes how messages will be delivered.
	//
	// Types that are assignable to Endpoint:
	//	*CommunicationChannel_Email_
	//	*CommunicationChannel_NotificationChannel_
	Endpoint isCommunicationChannel_Endpoint `protobuf_oneof:"endpoint"`
}

func (x *CommunicationChannel) Reset() {
	*x = CommunicationChannel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommunicationChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommunicationChannel) ProtoMessage() {}

func (x *CommunicationChannel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommunicationChannel.ProtoReflect.Descriptor instead.
func (*CommunicationChannel) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{9}
}

func (m *CommunicationChannel) GetEndpoint() isCommunicationChannel_Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (x *CommunicationChannel) GetEmail() *CommunicationChannel_Email {
	if x, ok := x.GetEndpoint().(*CommunicationChannel_Email_); ok {
		return x.Email
	}
	return nil
}

func (x *CommunicationChannel) GetNotificationChannel() *CommunicationChannel_NotificationChannel {
	if x, ok := x.GetEndpoint().(*CommunicationChannel_NotificationChannel_); ok {
		return x.NotificationChannel
	}
	return nil
}

type isCommunicationChannel_Endpoint interface {
	isCommunicationChannel_Endpoint()
}

type CommunicationChannel_Email_ struct {
	// Messages will be delivered via email.
	Email *CommunicationChannel_Email `protobuf:"bytes,1,opt,name=email,proto3,oneof"`
}

type CommunicationChannel_NotificationChannel_ struct {
	// Messages will be delivered via a Stackdriver notification channel.
	NotificationChannel *CommunicationChannel_NotificationChannel `protobuf:"bytes,2,opt,name=notification_channel,json=notificationChannel,proto3,oneof"`
}

func (*CommunicationChannel_Email_) isCommunicationChannel_Endpoint() {}

func (*CommunicationChannel_NotificationChannel_) isCommunicationChannel_Endpoint() {}

// A subscription allows users to get notifications about changes to
// an incident.
type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name such as
	// "projects/{project_id_or_number}/incidents/{incident_id}/subscriptions/{subscription_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// A communications channel to send subscription messages to.
	SubscriptionChannel *CommunicationChannel `protobuf:"bytes,3,opt,name=subscription_channel,json=subscriptionChannel,proto3" json:"subscription_channel,omitempty"`
	// Types of events this subscription receives notifications for.
	EventTypes []Subscription_EventType `protobuf:"varint,4,rep,packed,name=event_types,json=eventTypes,proto3,enum=google.cloud.irm.v1alpha2.Subscription_EventType" json:"event_types,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{10}
}

func (x *Subscription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subscription) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Subscription) GetSubscriptionChannel() *CommunicationChannel {
	if x != nil {
		return x.SubscriptionChannel
	}
	return nil
}

func (x *Subscription) GetEventTypes() []Subscription_EventType {
	if x != nil {
		return x.EventTypes
	}
	return nil
}

// An artifact associated with the Signal.
type Signal_SignalArtifact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of resource linked to
	//
	// Types that are assignable to ArtifactType:
	//	*Signal_SignalArtifact_UserType
	ArtifactType isSignal_SignalArtifact_ArtifactType `protobuf_oneof:"artifact_type"`
	// The URI for the artifact.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Signal_SignalArtifact) Reset() {
	*x = Signal_SignalArtifact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Signal_SignalArtifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signal_SignalArtifact) ProtoMessage() {}

func (x *Signal_SignalArtifact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signal_SignalArtifact.ProtoReflect.Descriptor instead.
func (*Signal_SignalArtifact) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{1, 0}
}

func (m *Signal_SignalArtifact) GetArtifactType() isSignal_SignalArtifact_ArtifactType {
	if m != nil {
		return m.ArtifactType
	}
	return nil
}

func (x *Signal_SignalArtifact) GetUserType() string {
	if x, ok := x.GetArtifactType().(*Signal_SignalArtifact_UserType); ok {
		return x.UserType
	}
	return ""
}

func (x *Signal_SignalArtifact) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

type isSignal_SignalArtifact_ArtifactType interface {
	isSignal_SignalArtifact_ArtifactType()
}

type Signal_SignalArtifact_UserType struct {
	// A custom user type
	UserType string `protobuf:"bytes,2,opt,name=user_type,json=userType,proto3,oneof"`
}

func (*Signal_SignalArtifact_UserType) isSignal_SignalArtifact_ArtifactType() {}

// CommunicationVenue is a record of where conversations about an incident
// are happening.
type Incident_CommunicationVenue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A URI to the web interface of the channel.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// A name representing the channel in IRM UI.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of channel/venue for incident communications.
	ChannelType Incident_CommunicationVenue_ChannelType `protobuf:"varint,3,opt,name=channel_type,json=channelType,proto3,enum=google.cloud.irm.v1alpha2.Incident_CommunicationVenue_ChannelType" json:"channel_type,omitempty"`
}

func (x *Incident_CommunicationVenue) Reset() {
	*x = Incident_CommunicationVenue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Incident_CommunicationVenue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Incident_CommunicationVenue) ProtoMessage() {}

func (x *Incident_CommunicationVenue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Incident_CommunicationVenue.ProtoReflect.Descriptor instead.
func (*Incident_CommunicationVenue) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Incident_CommunicationVenue) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Incident_CommunicationVenue) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Incident_CommunicationVenue) GetChannelType() Incident_CommunicationVenue_ChannelType {
	if x != nil {
		return x.ChannelType
	}
	return Incident_CommunicationVenue_CHANNEL_TYPE_UNSPECIFIED
}

// A communication channel that delivers messages to an email address.
type CommunicationChannel_Email struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The email address, for example, "user@example.com".
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *CommunicationChannel_Email) Reset() {
	*x = CommunicationChannel_Email{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommunicationChannel_Email) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommunicationChannel_Email) ProtoMessage() {}

func (x *CommunicationChannel_Email) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommunicationChannel_Email.ProtoReflect.Descriptor instead.
func (*CommunicationChannel_Email) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{9, 0}
}

func (x *CommunicationChannel_Email) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// A communication channel that delivers messages to a Stackdriver
// notification channel.
type CommunicationChannel_NotificationChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stackdriver notification channel name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CommunicationChannel_NotificationChannel) Reset() {
	*x = CommunicationChannel_NotificationChannel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommunicationChannel_NotificationChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommunicationChannel_NotificationChannel) ProtoMessage() {}

func (x *CommunicationChannel_NotificationChannel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommunicationChannel_NotificationChannel.ProtoReflect.Descriptor instead.
func (*CommunicationChannel_NotificationChannel) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP(), []int{9, 1}
}

func (x *CommunicationChannel_NotificationChannel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_irm_v1alpha2_incidents_proto protoreflect.FileDescriptor

var file_google_cloud_irm_v1alpha2_incidents_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x69, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x41, 0x0a, 0x04, 0x55, 0x73, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x07, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x42, 0x06, 0x0a, 0x04,
	0x75, 0x73, 0x65, 0x72, 0x22, 0x93, 0x06, 0x0a, 0x06, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x39, 0x0a, 0x0a, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0c, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x2e,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x0f,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x1a,
	0x52, 0x0a, 0x0e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x12, 0x1d, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x69, 0x42, 0x0f, 0x0a, 0x0d, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x40, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x50, 0x45,
	0x4e, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4c, 0x4f,
	0x53, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x43, 0xea, 0x41, 0x40, 0x0a, 0x19, 0x69, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x23, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x73, 0x2f, 0x7b, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x7d, 0x22, 0xb9, 0x02, 0x0a, 0x0a, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a,
	0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x06,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x1d, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x8d, 0x01, 0x0a, 0x03, 0x54, 0x61, 0x67, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x4f, 0xea, 0x41, 0x4c, 0x0a, 0x16, 0x69, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x61, 0x67, 0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x74, 0x61, 0x67, 0x73,
	0x2f, 0x7b, 0x74, 0x61, 0x67, 0x7d, 0x22, 0xbd, 0x01, 0x0a, 0x08, 0x53, 0x79, 0x6e, 0x6f, 0x70,
	0x73, 0x69, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x37, 0x0a,
	0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x06,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x22, 0xa9, 0x0a, 0x0a, 0x08, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x5e, 0x0a, 0x10, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x2e, 0x45, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x52, 0x0f, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x48, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x67,
	0x65, 0x12, 0x2d, 0x0a, 0x12, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64,
	0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x73,
	0x79, 0x6e, 0x6f, 0x70, 0x73, 0x69, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x79, 0x6e, 0x6f, 0x70, 0x73,
	0x69, 0x73, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x70, 0x73, 0x69, 0x73, 0x12, 0x67, 0x0a, 0x13,
	0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x65,
	0x6e, 0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x6e, 0x75,
	0x65, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x65, 0x6e, 0x75, 0x65, 0x1a, 0x8b, 0x02, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x6e, 0x75, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x65, 0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x6e, 0x75, 0x65, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x22, 0x59, 0x0a, 0x0b, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x48, 0x41, 0x4e, 0x4e,
	0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x52, 0x49, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x43,
	0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x4c, 0x41, 0x43,
	0x4b, 0x10, 0x05, 0x22, 0x56, 0x0a, 0x0f, 0x45, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x53, 0x43, 0x41, 0x4c, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x53, 0x43, 0x41,
	0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x4f, 0x52, 0x47,
	0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x22, 0x8d, 0x01, 0x0a, 0x08,
	0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45,
	0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x48,
	0x55, 0x47, 0x45, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54,
	0x59, 0x5f, 0x4d, 0x41, 0x4a, 0x4f, 0x52, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x56,
	0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12, 0x12,
	0x0a, 0x0e, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x4d, 0x49, 0x4e, 0x4f, 0x52,
	0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x4e,
	0x45, 0x47, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x05, 0x22, 0x99, 0x01, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x52, 0x49, 0x41, 0x47, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x4d, 0x49, 0x54,
	0x49, 0x47, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x47,
	0x45, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10,
	0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x45, 0x44,
	0x10, 0x05, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x55, 0x50, 0x4c,
	0x49, 0x43, 0x41, 0x54, 0x45, 0x10, 0x06, 0x3a, 0x49, 0xea, 0x41, 0x46, 0x0a, 0x1b, 0x69, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x7d, 0x22, 0xf0, 0x02, 0x0a, 0x0c, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52,
	0x6f, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe5, 0x01,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x43, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x4f,
	0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x45, 0x52, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x4e, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53,
	0x5f, 0x4c, 0x45, 0x41, 0x44, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x4c, 0x45, 0x41, 0x44, 0x10,
	0x03, 0x12, 0x2e, 0x0a, 0x2a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e,
	0x41, 0x4c, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4d, 0x4d,
	0x55, 0x4e, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x4c, 0x45, 0x41, 0x44, 0x10,
	0x04, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52,
	0x59, 0x5f, 0x4f, 0x4e, 0x43, 0x41, 0x4c, 0x4c, 0x10, 0x05, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x5f, 0x4f, 0x4e, 0x43,
	0x41, 0x4c, 0x4c, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x54,
	0x48, 0x45, 0x52, 0x10, 0x07, 0x22, 0x8d, 0x03, 0x0a, 0x16, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x3b, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x52,
	0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x65, 0x12, 0x4c, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x10,
	0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65,
	0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x29, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x6f, 0x72, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x7d, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x5f,
	0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x6f, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xc6, 0x02, 0x0a, 0x08, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12,
	0x3c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x3f, 0x0a,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x52, 0x4c, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x4a, 0x49, 0x52, 0x41, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x04, 0x3a, 0x5e,
	0xea, 0x41, 0x5b, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x7d, 0x22, 0xb9,
	0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x4d, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x48, 0x00, 0x52,
	0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x78, 0x0a, 0x14, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x13, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x1a, 0x21, 0x0a, 0x05, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x1a, 0x29, 0x0a, 0x13, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0xbf, 0x04, 0x0a, 0x0c, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x12, 0x62, 0x0a, 0x14, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x52, 0x13, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x52, 0x0a, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xe2, 0x01, 0x0a, 0x09,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x54, 0x49, 0x54, 0x4c, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x53, 0x59, 0x4e, 0x4f, 0x50, 0x53, 0x49, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x03, 0x12,
	0x1e, 0x0a, 0x1a, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45,
	0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x04, 0x12,
	0x1d, 0x0a, 0x19, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x4e,
	0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x44, 0x44, 0x10, 0x05, 0x12, 0x20,
	0x0a, 0x1c, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x4e, 0x4e,
	0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x06,
	0x3a, 0x6a, 0xea, 0x41, 0x67, 0x0a, 0x1f, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x7d, 0x2f,
	0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x68, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x61, 0x70, 0x69, 0x50, 0x01, 0x5a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x69, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x3b,
	0x69, 0x72, 0x6d, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_irm_v1alpha2_incidents_proto_rawDescOnce sync.Once
	file_google_cloud_irm_v1alpha2_incidents_proto_rawDescData = file_google_cloud_irm_v1alpha2_incidents_proto_rawDesc
)

func file_google_cloud_irm_v1alpha2_incidents_proto_rawDescGZIP() []byte {
	file_google_cloud_irm_v1alpha2_incidents_proto_rawDescOnce.Do(func() {
		file_google_cloud_irm_v1alpha2_incidents_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_irm_v1alpha2_incidents_proto_rawDescData)
	})
	return file_google_cloud_irm_v1alpha2_incidents_proto_rawDescData
}

var file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_irm_v1alpha2_incidents_proto_goTypes = []interface{}{
	(Signal_State)(0),                                // 0: google.cloud.irm.v1alpha2.Signal.State
	(Incident_EscalationLevel)(0),                    // 1: google.cloud.irm.v1alpha2.Incident.EscalationLevel
	(Incident_Severity)(0),                           // 2: google.cloud.irm.v1alpha2.Incident.Severity
	(Incident_Stage)(0),                              // 3: google.cloud.irm.v1alpha2.Incident.Stage
	(Incident_CommunicationVenue_ChannelType)(0),     // 4: google.cloud.irm.v1alpha2.Incident.CommunicationVenue.ChannelType
	(IncidentRole_Type)(0),                           // 5: google.cloud.irm.v1alpha2.IncidentRole.Type
	(Artifact_Type)(0),                               // 6: google.cloud.irm.v1alpha2.Artifact.Type
	(Subscription_EventType)(0),                      // 7: google.cloud.irm.v1alpha2.Subscription.EventType
	(*User)(nil),                                     // 8: google.cloud.irm.v1alpha2.User
	(*Signal)(nil),                                   // 9: google.cloud.irm.v1alpha2.Signal
	(*Annotation)(nil),                               // 10: google.cloud.irm.v1alpha2.Annotation
	(*Tag)(nil),                                      // 11: google.cloud.irm.v1alpha2.Tag
	(*Synopsis)(nil),                                 // 12: google.cloud.irm.v1alpha2.Synopsis
	(*Incident)(nil),                                 // 13: google.cloud.irm.v1alpha2.Incident
	(*IncidentRole)(nil),                             // 14: google.cloud.irm.v1alpha2.IncidentRole
	(*IncidentRoleAssignment)(nil),                   // 15: google.cloud.irm.v1alpha2.IncidentRoleAssignment
	(*Artifact)(nil),                                 // 16: google.cloud.irm.v1alpha2.Artifact
	(*CommunicationChannel)(nil),                     // 17: google.cloud.irm.v1alpha2.CommunicationChannel
	(*Subscription)(nil),                             // 18: google.cloud.irm.v1alpha2.Subscription
	(*Signal_SignalArtifact)(nil),                    // 19: google.cloud.irm.v1alpha2.Signal.SignalArtifact
	(*Incident_CommunicationVenue)(nil),              // 20: google.cloud.irm.v1alpha2.Incident.CommunicationVenue
	(*CommunicationChannel_Email)(nil),               // 21: google.cloud.irm.v1alpha2.CommunicationChannel.Email
	(*CommunicationChannel_NotificationChannel)(nil), // 22: google.cloud.irm.v1alpha2.CommunicationChannel.NotificationChannel
	(*timestamp.Timestamp)(nil),                      // 23: google.protobuf.Timestamp
}
var file_google_cloud_irm_v1alpha2_incidents_proto_depIdxs = []int32{
	23, // 0: google.cloud.irm.v1alpha2.Signal.create_time:type_name -> google.protobuf.Timestamp
	23, // 1: google.cloud.irm.v1alpha2.Signal.close_time:type_name -> google.protobuf.Timestamp
	23, // 2: google.cloud.irm.v1alpha2.Signal.detect_time:type_name -> google.protobuf.Timestamp
	8,  // 3: google.cloud.irm.v1alpha2.Signal.creator:type_name -> google.cloud.irm.v1alpha2.User
	0,  // 4: google.cloud.irm.v1alpha2.Signal.signal_state:type_name -> google.cloud.irm.v1alpha2.Signal.State
	19, // 5: google.cloud.irm.v1alpha2.Signal.signal_artifacts:type_name -> google.cloud.irm.v1alpha2.Signal.SignalArtifact
	8,  // 6: google.cloud.irm.v1alpha2.Annotation.author:type_name -> google.cloud.irm.v1alpha2.User
	23, // 7: google.cloud.irm.v1alpha2.Annotation.create_time:type_name -> google.protobuf.Timestamp
	23, // 8: google.cloud.irm.v1alpha2.Synopsis.update_time:type_name -> google.protobuf.Timestamp
	8,  // 9: google.cloud.irm.v1alpha2.Synopsis.author:type_name -> google.cloud.irm.v1alpha2.User
	1,  // 10: google.cloud.irm.v1alpha2.Incident.escalation_level:type_name -> google.cloud.irm.v1alpha2.Incident.EscalationLevel
	2,  // 11: google.cloud.irm.v1alpha2.Incident.severity:type_name -> google.cloud.irm.v1alpha2.Incident.Severity
	3,  // 12: google.cloud.irm.v1alpha2.Incident.stage:type_name -> google.cloud.irm.v1alpha2.Incident.Stage
	23, // 13: google.cloud.irm.v1alpha2.Incident.start_time:type_name -> google.protobuf.Timestamp
	12, // 14: google.cloud.irm.v1alpha2.Incident.synopsis:type_name -> google.cloud.irm.v1alpha2.Synopsis
	20, // 15: google.cloud.irm.v1alpha2.Incident.communication_venue:type_name -> google.cloud.irm.v1alpha2.Incident.CommunicationVenue
	5,  // 16: google.cloud.irm.v1alpha2.IncidentRole.type:type_name -> google.cloud.irm.v1alpha2.IncidentRole.Type
	14, // 17: google.cloud.irm.v1alpha2.IncidentRoleAssignment.role:type_name -> google.cloud.irm.v1alpha2.IncidentRole
	8,  // 18: google.cloud.irm.v1alpha2.IncidentRoleAssignment.assignee:type_name -> google.cloud.irm.v1alpha2.User
	8,  // 19: google.cloud.irm.v1alpha2.IncidentRoleAssignment.proposed_assignee:type_name -> google.cloud.irm.v1alpha2.User
	6,  // 20: google.cloud.irm.v1alpha2.Artifact.type:type_name -> google.cloud.irm.v1alpha2.Artifact.Type
	21, // 21: google.cloud.irm.v1alpha2.CommunicationChannel.email:type_name -> google.cloud.irm.v1alpha2.CommunicationChannel.Email
	22, // 22: google.cloud.irm.v1alpha2.CommunicationChannel.notification_channel:type_name -> google.cloud.irm.v1alpha2.CommunicationChannel.NotificationChannel
	17, // 23: google.cloud.irm.v1alpha2.Subscription.subscription_channel:type_name -> google.cloud.irm.v1alpha2.CommunicationChannel
	7,  // 24: google.cloud.irm.v1alpha2.Subscription.event_types:type_name -> google.cloud.irm.v1alpha2.Subscription.EventType
	4,  // 25: google.cloud.irm.v1alpha2.Incident.CommunicationVenue.channel_type:type_name -> google.cloud.irm.v1alpha2.Incident.CommunicationVenue.ChannelType
	26, // [26:26] is the sub-list for method output_type
	26, // [26:26] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_google_cloud_irm_v1alpha2_incidents_proto_init() }
func file_google_cloud_irm_v1alpha2_incidents_proto_init() {
	if File_google_cloud_irm_v1alpha2_incidents_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*User); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Signal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Annotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Synopsis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Incident); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IncidentRole); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IncidentRoleAssignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Artifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommunicationChannel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Signal_SignalArtifact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Incident_CommunicationVenue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommunicationChannel_Email); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommunicationChannel_NotificationChannel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*User_UserId)(nil),
		(*User_Email)(nil),
	}
	file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*CommunicationChannel_Email_)(nil),
		(*CommunicationChannel_NotificationChannel_)(nil),
	}
	file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*Signal_SignalArtifact_UserType)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_irm_v1alpha2_incidents_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_irm_v1alpha2_incidents_proto_goTypes,
		DependencyIndexes: file_google_cloud_irm_v1alpha2_incidents_proto_depIdxs,
		EnumInfos:         file_google_cloud_irm_v1alpha2_incidents_proto_enumTypes,
		MessageInfos:      file_google_cloud_irm_v1alpha2_incidents_proto_msgTypes,
	}.Build()
	File_google_cloud_irm_v1alpha2_incidents_proto = out.File
	file_google_cloud_irm_v1alpha2_incidents_proto_rawDesc = nil
	file_google_cloud_irm_v1alpha2_incidents_proto_goTypes = nil
	file_google_cloud_irm_v1alpha2_incidents_proto_depIdxs = nil
}
