// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package binaryauthorization aliases all exported identifiers in package
// "cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb".
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package binaryauthorization

import (
	src "cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
const (
	AdmissionRule_ALWAYS_ALLOW                                       = src.AdmissionRule_ALWAYS_ALLOW
	AdmissionRule_ALWAYS_DENY                                        = src.AdmissionRule_ALWAYS_DENY
	AdmissionRule_DRYRUN_AUDIT_LOG_ONLY                              = src.AdmissionRule_DRYRUN_AUDIT_LOG_ONLY
	AdmissionRule_ENFORCED_BLOCK_AND_AUDIT_LOG                       = src.AdmissionRule_ENFORCED_BLOCK_AND_AUDIT_LOG
	AdmissionRule_ENFORCEMENT_MODE_UNSPECIFIED                       = src.AdmissionRule_ENFORCEMENT_MODE_UNSPECIFIED
	AdmissionRule_EVALUATION_MODE_UNSPECIFIED                        = src.AdmissionRule_EVALUATION_MODE_UNSPECIFIED
	AdmissionRule_REQUIRE_ATTESTATION                                = src.AdmissionRule_REQUIRE_ATTESTATION
	PkixPublicKey_ECDSA_P256_SHA256                                  = src.PkixPublicKey_ECDSA_P256_SHA256
	PkixPublicKey_ECDSA_P384_SHA384                                  = src.PkixPublicKey_ECDSA_P384_SHA384
	PkixPublicKey_ECDSA_P521_SHA512                                  = src.PkixPublicKey_ECDSA_P521_SHA512
	PkixPublicKey_EC_SIGN_P256_SHA256                                = src.PkixPublicKey_EC_SIGN_P256_SHA256
	PkixPublicKey_EC_SIGN_P384_SHA384                                = src.PkixPublicKey_EC_SIGN_P384_SHA384
	PkixPublicKey_EC_SIGN_P521_SHA512                                = src.PkixPublicKey_EC_SIGN_P521_SHA512
	PkixPublicKey_RSA_PSS_2048_SHA256                                = src.PkixPublicKey_RSA_PSS_2048_SHA256
	PkixPublicKey_RSA_PSS_3072_SHA256                                = src.PkixPublicKey_RSA_PSS_3072_SHA256
	PkixPublicKey_RSA_PSS_4096_SHA256                                = src.PkixPublicKey_RSA_PSS_4096_SHA256
	PkixPublicKey_RSA_PSS_4096_SHA512                                = src.PkixPublicKey_RSA_PSS_4096_SHA512
	PkixPublicKey_RSA_SIGN_PKCS1_2048_SHA256                         = src.PkixPublicKey_RSA_SIGN_PKCS1_2048_SHA256
	PkixPublicKey_RSA_SIGN_PKCS1_3072_SHA256                         = src.PkixPublicKey_RSA_SIGN_PKCS1_3072_SHA256
	PkixPublicKey_RSA_SIGN_PKCS1_4096_SHA256                         = src.PkixPublicKey_RSA_SIGN_PKCS1_4096_SHA256
	PkixPublicKey_RSA_SIGN_PKCS1_4096_SHA512                         = src.PkixPublicKey_RSA_SIGN_PKCS1_4096_SHA512
	PkixPublicKey_SIGNATURE_ALGORITHM_UNSPECIFIED                    = src.PkixPublicKey_SIGNATURE_ALGORITHM_UNSPECIFIED
	Policy_DISABLE                                                   = src.Policy_DISABLE
	Policy_ENABLE                                                    = src.Policy_ENABLE
	Policy_GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED                 = src.Policy_GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED
	ValidateAttestationOccurrenceResponse_ATTESTATION_NOT_VERIFIABLE = src.ValidateAttestationOccurrenceResponse_ATTESTATION_NOT_VERIFIABLE
	ValidateAttestationOccurrenceResponse_RESULT_UNSPECIFIED         = src.ValidateAttestationOccurrenceResponse_RESULT_UNSPECIFIED
	ValidateAttestationOccurrenceResponse_VERIFIED                   = src.ValidateAttestationOccurrenceResponse_VERIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
var (
	AdmissionRule_EnforcementMode_name                       = src.AdmissionRule_EnforcementMode_name
	AdmissionRule_EnforcementMode_value                      = src.AdmissionRule_EnforcementMode_value
	AdmissionRule_EvaluationMode_name                        = src.AdmissionRule_EvaluationMode_name
	AdmissionRule_EvaluationMode_value                       = src.AdmissionRule_EvaluationMode_value
	File_google_cloud_binaryauthorization_v1_resources_proto = src.File_google_cloud_binaryauthorization_v1_resources_proto
	File_google_cloud_binaryauthorization_v1_service_proto   = src.File_google_cloud_binaryauthorization_v1_service_proto
	PkixPublicKey_SignatureAlgorithm_name                    = src.PkixPublicKey_SignatureAlgorithm_name
	PkixPublicKey_SignatureAlgorithm_value                   = src.PkixPublicKey_SignatureAlgorithm_value
	Policy_GlobalPolicyEvaluationMode_name                   = src.Policy_GlobalPolicyEvaluationMode_name
	Policy_GlobalPolicyEvaluationMode_value                  = src.Policy_GlobalPolicyEvaluationMode_value
	ValidateAttestationOccurrenceResponse_Result_name        = src.ValidateAttestationOccurrenceResponse_Result_name
	ValidateAttestationOccurrenceResponse_Result_value       = src.ValidateAttestationOccurrenceResponse_Result_value
)

// An [admission rule][google.cloud.binaryauthorization.v1.AdmissionRule]
// specifies either that all container images used in a pod creation request
// must be attested to by one or more
// [attestors][google.cloud.binaryauthorization.v1.Attestor], that all pod
// creations will be allowed, or that all pod creations will be denied. Images
// matching an [admission allowlist
// pattern][google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern] are
// exempted from admission rules and will never block a pod creation.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type AdmissionRule = src.AdmissionRule

// Defines the possible actions when a pod creation is denied by an admission
// rule.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type AdmissionRule_EnforcementMode = src.AdmissionRule_EnforcementMode
type AdmissionRule_EvaluationMode = src.AdmissionRule_EvaluationMode

// An [admission allowlist
// pattern][google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern]
// exempts images from checks by [admission
// rules][google.cloud.binaryauthorization.v1.AdmissionRule].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type AdmissionWhitelistPattern = src.AdmissionWhitelistPattern

// An [attestor][google.cloud.binaryauthorization.v1.Attestor] that attests to
// container image artifacts. An existing attestor cannot be modified except
// where indicated.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type Attestor = src.Attestor

// An [attestor public
// key][google.cloud.binaryauthorization.v1.AttestorPublicKey] that will be
// used to verify attestations signed by this attestor.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type AttestorPublicKey = src.AttestorPublicKey
type AttestorPublicKey_AsciiArmoredPgpPublicKey = src.AttestorPublicKey_AsciiArmoredPgpPublicKey
type AttestorPublicKey_PkixPublicKey = src.AttestorPublicKey_PkixPublicKey
type Attestor_UserOwnedGrafeasNote = src.Attestor_UserOwnedGrafeasNote

// BinauthzManagementServiceV1Client is the client API for
// BinauthzManagementServiceV1 service. For semantics around ctx use and
// closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type BinauthzManagementServiceV1Client = src.BinauthzManagementServiceV1Client

// BinauthzManagementServiceV1Server is the server API for
// BinauthzManagementServiceV1 service.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type BinauthzManagementServiceV1Server = src.BinauthzManagementServiceV1Server

// Request message for [BinauthzManagementService.CreateAttestor][].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type CreateAttestorRequest = src.CreateAttestorRequest

// Request message for [BinauthzManagementService.DeleteAttestor][].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type DeleteAttestorRequest = src.DeleteAttestorRequest

// Request message for [BinauthzManagementService.GetAttestor][].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type GetAttestorRequest = src.GetAttestorRequest

// Request message for [BinauthzManagementService.GetPolicy][].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type GetPolicyRequest = src.GetPolicyRequest

// Request to read the current system policy.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type GetSystemPolicyRequest = src.GetSystemPolicyRequest

// Request message for [BinauthzManagementService.ListAttestors][].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type ListAttestorsRequest = src.ListAttestorsRequest

// Response message for [BinauthzManagementService.ListAttestors][].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type ListAttestorsResponse = src.ListAttestorsResponse

// A public key in the PkixPublicKey format (see
// https://tools.ietf.org/html/rfc5280#section-4.1.2.7 for details). Public
// keys of this type are typically textually encoded using the PEM format.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type PkixPublicKey = src.PkixPublicKey

// Represents a signature algorithm and other information necessary to verify
// signatures with a given public key. This is based primarily on the public
// key types supported by Tink's PemKeyType, which is in turn based on KMS's
// supported signing algorithms. See
// https://cloud.google.com/kms/docs/algorithms. In the future, BinAuthz might
// support additional public key types independently of Tink and/or KMS.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type PkixPublicKey_SignatureAlgorithm = src.PkixPublicKey_SignatureAlgorithm

// A [policy][google.cloud.binaryauthorization.v1.Policy] for container image
// binary authorization.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type Policy = src.Policy
type Policy_GlobalPolicyEvaluationMode = src.Policy_GlobalPolicyEvaluationMode

// SystemPolicyV1Client is the client API for SystemPolicyV1 service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type SystemPolicyV1Client = src.SystemPolicyV1Client

// SystemPolicyV1Server is the server API for SystemPolicyV1 service.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type SystemPolicyV1Server = src.SystemPolicyV1Server

// UnimplementedBinauthzManagementServiceV1Server can be embedded to have
// forward compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type UnimplementedBinauthzManagementServiceV1Server = src.UnimplementedBinauthzManagementServiceV1Server

// UnimplementedSystemPolicyV1Server can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type UnimplementedSystemPolicyV1Server = src.UnimplementedSystemPolicyV1Server

// UnimplementedValidationHelperV1Server can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type UnimplementedValidationHelperV1Server = src.UnimplementedValidationHelperV1Server

// Request message for [BinauthzManagementService.UpdateAttestor][].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type UpdateAttestorRequest = src.UpdateAttestorRequest

// Request message for [BinauthzManagementService.UpdatePolicy][].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type UpdatePolicyRequest = src.UpdatePolicyRequest

// An [user owned Grafeas
// note][google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote] references a
// Grafeas Attestation.Authority Note created by the user.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type UserOwnedGrafeasNote = src.UserOwnedGrafeasNote

// Request message for
// [ValidationHelperV1.ValidateAttestationOccurrence][google.cloud.binaryauthorization.v1.ValidationHelperV1.ValidateAttestationOccurrence].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type ValidateAttestationOccurrenceRequest = src.ValidateAttestationOccurrenceRequest

// Response message for
// [ValidationHelperV1.ValidateAttestationOccurrence][google.cloud.binaryauthorization.v1.ValidationHelperV1.ValidateAttestationOccurrence].
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type ValidateAttestationOccurrenceResponse = src.ValidateAttestationOccurrenceResponse

// The enum returned in the "result" field.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type ValidateAttestationOccurrenceResponse_Result = src.ValidateAttestationOccurrenceResponse_Result

// ValidationHelperV1Client is the client API for ValidationHelperV1 service.
// For semantics around ctx use and closing/ending streaming RPCs, please refer
// to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type ValidationHelperV1Client = src.ValidationHelperV1Client

// ValidationHelperV1Server is the server API for ValidationHelperV1 service.
//
// Deprecated: Please use types in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
type ValidationHelperV1Server = src.ValidationHelperV1Server

// Deprecated: Please use funcs in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
func NewBinauthzManagementServiceV1Client(cc grpc.ClientConnInterface) BinauthzManagementServiceV1Client {
	return src.NewBinauthzManagementServiceV1Client(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
func NewSystemPolicyV1Client(cc grpc.ClientConnInterface) SystemPolicyV1Client {
	return src.NewSystemPolicyV1Client(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
func NewValidationHelperV1Client(cc grpc.ClientConnInterface) ValidationHelperV1Client {
	return src.NewValidationHelperV1Client(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
func RegisterBinauthzManagementServiceV1Server(s *grpc.Server, srv BinauthzManagementServiceV1Server) {
	src.RegisterBinauthzManagementServiceV1Server(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
func RegisterSystemPolicyV1Server(s *grpc.Server, srv SystemPolicyV1Server) {
	src.RegisterSystemPolicyV1Server(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/binaryauthorization/apiv1/binaryauthorizationpb
func RegisterValidationHelperV1Server(s *grpc.Server, srv ValidationHelperV1Server) {
	src.RegisterValidationHelperV1Server(s, srv)
}
